/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.StringInfo;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceNetAdhocctlPeerInfo;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.HLE.modules150.sceNet;
import jpcsp.HLE.modules150.sceNetAdhoc;
import jpcsp.HLE.modules150.sceUtility;
import jpcsp.Processor;
import jpcsp.hardware.Wlan;
import jpcsp.network.INetworkAdapter;
import org.apache.log4j.Logger;

@HLELogging
public class sceNetAdhocctl
extends HLEModule {
    public static Logger log = Modules.getLogger("sceNetAdhocctl");
    public static final int PSP_ADHOCCTL_EVENT_ERROR = 0;
    public static final int PSP_ADHOCCTL_EVENT_CONNECTED = 1;
    public static final int PSP_ADHOCCTL_EVENT_DISCONNECTED = 2;
    public static final int PSP_ADHOCCTL_EVENT_SCAN = 3;
    public static final int PSP_ADHOCCTL_EVENT_GAME = 4;
    public static final int PSP_ADHOCCTL_EVENT_DISCOVER = 5;
    public static final int PSP_ADHOCCTL_EVENT_WOL = 6;
    public static final int PSP_ADHOCCTL_EVENT_WOL_INTERRUPTED = 7;
    public static final int PSP_ADHOCCTL_STATE_DISCONNECTED = 0;
    public static final int PSP_ADHOCCTL_STATE_CONNECTED = 1;
    public static final int PSP_ADHOCCTL_STATE_SCAN = 2;
    public static final int PSP_ADHOCCTL_STATE_GAME = 3;
    public static final int PSP_ADHOCCTL_STATE_DISCOVER = 4;
    public static final int PSP_ADHOCCTL_STATE_WOL = 5;
    public static final int PSP_ADHOCCTL_MODE_NORMAL = 0;
    public static final int PSP_ADHOCCTL_MODE_GAMEMODE = 1;
    public static final int PSP_ADHOCCTL_MODE_NONE = -1;
    public static final int NICK_NAME_LENGTH = 128;
    public static final int GROUP_NAME_LENGTH = 8;
    public static final int IBSS_NAME_LENGTH = 6;
    public static final int ADHOC_ID_LENGTH = 9;
    public static final int MAX_GAME_MODE_MACS = 16;
    private boolean isInitialized;
    protected int adhocctlCurrentState;
    protected String adhocctlCurrentGroup;
    protected String adhocctlCurrentIBSS;
    protected int adhocctlCurrentMode;
    protected int adhocctlCurrentChannel;
    protected int adhocctlCurrentType;
    protected String adhocctlCurrentAdhocID;
    protected boolean doTerminate;
    protected SceKernelThreadInfo adhocctlThread;
    private boolean doScan;
    private volatile long scanStartMillis;
    private static final int SCAN_DURATION_MILLIS = 700;
    private boolean doDisconnect;
    private boolean doJoin;
    private boolean gameModeJoinComplete;
    protected LinkedList<AdhocctlPeer> peers;
    protected LinkedList<AdhocctlNetwork> networks;
    protected LinkedList<pspNetMacAddress> gameModeMacs;
    protected LinkedList<pspNetMacAddress> requiredGameModeMacs;
    protected INetworkAdapter networkAdapter;
    private long connectCompleteTimestamp;
    private static final int CONNECT_COMPLETE_DELAY_MILLIS = 200;
    private HashMap<Integer, AdhocctlHandler> adhocctlIdMap = new HashMap();
    private static final String adhocctlHandlerIdPurpose = "sceNetAdhocctl-Handler";

    @Override
    public String getName() {
        return "sceNetAdhocctl";
    }

    @Override
    public void start() {
        this.peers = new LinkedList();
        this.networks = new LinkedList();
        this.gameModeMacs = new LinkedList();
        this.requiredGameModeMacs = new LinkedList();
        this.adhocctlCurrentIBSS = "Jpcsp";
        this.adhocctlCurrentMode = -1;
        this.adhocctlCurrentChannel = Wlan.getAdhocChannel();
        this.isInitialized = false;
        this.networkAdapter = Modules.sceNetModule.getNetworkAdapter();
        super.start();
    }

    protected static long getCurrentTimestamp() {
        return Emulator.getClock().microTime();
    }

    protected void checkInitialized() {
        if (!this.isInitialized) {
            throw new SceKernelErrorException(-2143220984);
        }
    }

    public void hleNetAdhocctlAddGameModeMac(byte[] macAddr) {
        for (pspNetMacAddress macAddress : this.gameModeMacs) {
            if (!sceNetAdhoc.isSameMacAddress(macAddress.macAddress, macAddr)) continue;
            return;
        }
        pspNetMacAddress macAddress = new pspNetMacAddress();
        macAddress.setMacAddress(macAddr);
        this.gameModeMacs.add(macAddress);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Adding new Game Mode MAC: %s", macAddress));
        }
    }

    private void doConnect() {
        long now;
        if (this.adhocctlCurrentGroup != null && this.networkAdapter.isConnectComplete() && (now = Emulator.getClock().currentTimeMillis()) >= this.connectCompleteTimestamp) {
            if (this.adhocctlCurrentMode == 1) {
                this.setState(3);
                this.notifyAdhocctlHandler(4, 0);
            } else {
                this.setState(1);
                this.notifyAdhocctlHandler(1, 0);
            }
            this.doJoin = false;
        }
    }

    private int getAdhocctlThreadPollDelay() {
        int quickPollDelay = 100000;
        if (this.adhocctlCurrentState == 2) {
            return 100000;
        }
        if (this.doJoin) {
            return 100000;
        }
        if (this.adhocctlCurrentState == 0 && this.adhocctlCurrentGroup != null) {
            return 100000;
        }
        return 500000;
    }

    public void hleNetAdhocctlThread(Processor processor) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        if (log.isDebugEnabled()) {
            log.debug((Object)"hleNetAdhocctlThread");
        }
        if (this.doTerminate) {
            this.setState(0);
            this.notifyAdhocctlHandler(2, 0);
            this.setGroupName(null, -1);
        } else if (this.doDisconnect) {
            this.setState(0);
            this.notifyAdhocctlHandler(2, 0);
            this.setGroupName(null, -1);
            this.doDisconnect = false;
        } else if (this.doScan) {
            this.setState(2);
            this.scanStartMillis = Emulator.getClock().milliTime();
            this.doScan = false;
        } else if (this.doJoin) {
            if (this.adhocctlCurrentMode == 1) {
                if (this.requiredGameModeMacs.size() > 0 && this.gameModeMacs.size() >= this.requiredGameModeMacs.size()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("All GameMode MACs have joined, GameMode Join is now complete", new Object[0]));
                    }
                    this.hleNetAdhocctlSetGameModeJoinComplete(true);
                    this.gameModeMacs.clear();
                    this.gameModeMacs.addAll(this.requiredGameModeMacs);
                }
                if (this.gameModeJoinComplete) {
                    this.doConnect();
                } else {
                    this.hleNetAdhocctlAddGameModeMac(Wlan.getMacAddress());
                }
            } else {
                this.doConnect();
            }
        } else if (this.adhocctlCurrentState == 0) {
            this.doConnect();
        }
        if (this.adhocctlCurrentState == 1 || this.adhocctlCurrentState == 3 || this.doJoin) {
            this.networkAdapter.updatePeers();
        } else if (this.adhocctlCurrentState == 2) {
            this.networkAdapter.updatePeers();
            long now = Emulator.getClock().milliTime();
            if (now - this.scanStartMillis > 700L) {
                this.setState(0);
                this.notifyAdhocctlHandler(3, 0);
            }
        }
        if (this.doTerminate) {
            processor.cpu._v0 = 0;
            threadMan.hleKernelExitDeleteThread();
            this.adhocctlThread = null;
            this.doTerminate = false;
        } else {
            threadMan.hleKernelDelayThread(this.getAdhocctlThreadPollDelay(), false);
        }
    }

    protected void setState(int state) {
        this.adhocctlCurrentState = state;
    }

    protected void setGroupName(String groupName, int mode) {
        this.adhocctlCurrentGroup = groupName;
        this.adhocctlCurrentMode = mode;
        this.gameModeJoinComplete = false;
        this.gameModeMacs.clear();
        if (groupName != null) {
            this.connectCompleteTimestamp = Emulator.getClock().currentTimeMillis() + 200L;
        }
    }

    public void hleNetAdhocctlConnect(String groupName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleNetAdhocctlConnect groupName='%s'", groupName));
        }
        if (this.hleNetAdhocctlGetGroupName() == null || !this.hleNetAdhocctlGetGroupName().equals(groupName)) {
            this.setGroupName(groupName, 0);
            this.networkAdapter.sceNetAdhocctlConnect();
        }
    }

    public void hleNetAdhocctlConnectGame(String groupName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleNetAdhocctlConnectGame groupName='%s'", groupName));
        }
        this.setGroupName(groupName, 1);
    }

    public int hleNetAdhocctlGetState() {
        return this.adhocctlCurrentState;
    }

    protected void notifyAdhocctlHandler(int event, int error) {
        for (AdhocctlHandler handler : this.adhocctlIdMap.values()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Notifying handler %s with event=%d, error=%d", handler, event, error));
            }
            handler.setEvent(event);
            handler.setError(error);
            handler.triggerAdhocctlHandler();
        }
    }

    public String hleNetAdhocctlGetAdhocID() {
        return this.adhocctlCurrentAdhocID;
    }

    public String hleNetAdhocctlGetGroupName() {
        return this.adhocctlCurrentGroup;
    }

    public String hleNetAdhocctlGetIBSS() {
        return this.adhocctlCurrentIBSS;
    }

    public int hleNetAdhocctlGetMode() {
        return this.adhocctlCurrentMode;
    }

    public int hleNetAdhocctlGetChannel() {
        return this.adhocctlCurrentChannel;
    }

    public void hleNetAdhocctlAddNetwork(String groupName, pspNetMacAddress mac, int mode) {
        this.hleNetAdhocctlAddNetwork(groupName, mac, this.adhocctlCurrentChannel, this.adhocctlCurrentIBSS, mode);
    }

    public void hleNetAdhocctlAddNetwork(String groupName, pspNetMacAddress mac, int channel, String ibss, int mode) {
        boolean found = false;
        for (AdhocctlNetwork network : this.networks) {
            if (!network.equals(channel, groupName, ibss, mode)) continue;
            found = true;
            break;
        }
        if (!found) {
            AdhocctlNetwork network = new AdhocctlNetwork();
            network.channel = channel;
            network.name = groupName;
            network.bssid = ibss;
            network.mode = mode;
            this.networks.add(network);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("New network discovered %s", network));
            }
        }
    }

    public void hleNetAdhocctlScanComplete() {
        this.scanStartMillis = 0L;
    }

    public void hleNetAdhocctlAddPeer(String nickName, pspNetMacAddress mac) {
        boolean peerFound = false;
        for (AdhocctlPeer peer : this.peers) {
            if (!peer.equals(nickName, mac.macAddress)) continue;
            peer.updateTimestamp();
            peerFound = true;
            break;
        }
        if (!peerFound) {
            AdhocctlPeer peer = new AdhocctlPeer(nickName, mac.macAddress);
            this.peers.add(peer);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("New peer discovered %s", peer));
            }
        }
    }

    public List<String> getPeersNickName() {
        LinkedList<String> nickNames = new LinkedList<String>();
        for (AdhocctlPeer peer : this.peers) {
            nickNames.add(peer.nickName);
        }
        return nickNames;
    }

    public int getNumberPeers() {
        return this.peers.size();
    }

    public String getPeerNickName(byte[] macAddress) {
        for (AdhocctlPeer peer : this.peers) {
            if (!peer.equals(macAddress)) continue;
            return peer.nickName;
        }
        return null;
    }

    public void hleNetAdhocctlDeletePeer(byte[] macAddress) {
        for (AdhocctlPeer peer : this.peers) {
            if (!peer.equals(macAddress)) continue;
            this.peers.remove(peer);
            if (!log.isDebugEnabled()) break;
            log.debug((Object)String.format("Peer deleted %s", peer));
            break;
        }
    }

    public void hleNetAdhocctlPeerUpdateTimestamp(byte[] macAddress) {
        for (AdhocctlPeer peer : this.peers) {
            if (!peer.equals(macAddress)) continue;
            peer.updateTimestamp();
            break;
        }
    }

    public boolean isGameModeComplete() {
        return this.gameModeMacs.size() >= this.requiredGameModeMacs.size();
    }

    public List<pspNetMacAddress> hleNetAdhocctlGetRequiredGameModeMacs() {
        return this.requiredGameModeMacs;
    }

    public void hleNetAdhocctlSetGameModeJoinComplete(boolean gameModeJoinComplete) {
        this.gameModeJoinComplete = gameModeJoinComplete;
    }

    public void hleNetAdhocctlSetGameModeMacs(byte[][] gameModeMacs) {
        this.gameModeMacs.clear();
        for (int i = 0; i < gameModeMacs.length; ++i) {
            this.hleNetAdhocctlAddGameModeMac(gameModeMacs[i]);
        }
    }

    public static void fillNextPointersInLinkedList(TPointer buffer, int size, int elementSize) {
        for (int offset = 0; offset < size; offset += elementSize) {
            if (offset + elementSize >= size) {
                buffer.setValue32(offset, 0);
                continue;
            }
            buffer.setValue32(offset, buffer.getAddress() + offset + elementSize);
        }
    }

    @HLEFunction(nid=-496033170, version=150, checkInsideInterrupt=true)
    public int sceNetAdhocctlInit(int stackSize, int priority, @CanBeNull TPointer product) {
        if (this.isInitialized) {
            return -2143220985;
        }
        if (product.isNotNull()) {
            this.adhocctlCurrentType = product.getValue32(0);
            this.adhocctlCurrentAdhocID = product.getStringNZ(4, 9);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Found product data: type=%d, AdhocID='%s'", this.adhocctlCurrentType, this.adhocctlCurrentAdhocID));
            }
        }
        this.setState(0);
        this.doTerminate = false;
        this.doScan = false;
        this.doDisconnect = false;
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        this.adhocctlThread = threadMan.hleKernelCreateThread("SceNetAdhocctl", 0x8000070, priority, stackSize, 0, 0);
        threadMan.hleKernelStartThread(this.adhocctlThread, 0, 0, this.adhocctlThread.gpReg_addr);
        this.networkAdapter.sceNetAdhocctlInit();
        this.isInitialized = true;
        return 0;
    }

    @HLEFunction(nid=-1654088173, version=150, checkInsideInterrupt=true)
    public int sceNetAdhocctlTerm() {
        this.doTerminate = true;
        this.isInitialized = false;
        this.networkAdapter.sceNetAdhocctlTerm();
        return 0;
    }

    @HLEFunction(nid=181421037, version=150, checkInsideInterrupt=true)
    public int sceNetAdhocctlConnect(@CanBeNull @StringInfo(maxLength=8) PspString groupName) {
        this.checkInitialized();
        this.hleNetAdhocctlConnect(groupName.getString());
        return 0;
    }

    @HLEFunction(nid=-335137343, version=150, checkInsideInterrupt=true)
    public int sceNetAdhocctlCreate(@CanBeNull @StringInfo(maxLength=8) PspString groupName) {
        this.checkInitialized();
        this.setGroupName(groupName.getString(), 0);
        this.networkAdapter.sceNetAdhocctlCreate();
        return 0;
    }

    @HLEFunction(nid=1585412553, version=150, checkInsideInterrupt=true)
    public int sceNetAdhocctlJoin(TPointer scanInfoAddr) {
        this.checkInitialized();
        if (scanInfoAddr.isAddressGood()) {
            int nextAddr = scanInfoAddr.getValue32(0);
            int ch = scanInfoAddr.getValue32(4);
            String groupName = scanInfoAddr.getStringNZ(8, 8);
            String bssID = scanInfoAddr.getStringNZ(16, 6);
            int mode = scanInfoAddr.getValue32(24);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNetAdhocctlJoin nextAddr 0x%08X, ch %d, groupName '%s', bssID '%s', mode %d", nextAddr, ch, groupName, bssID, mode));
            }
            this.doJoin = true;
            this.setGroupName(groupName, 0);
            this.networkAdapter.sceNetAdhocctlJoin();
        }
        return 0;
    }

    @HLEFunction(nid=150992800, version=150, checkInsideInterrupt=true)
    public int sceNetAdhocctlScan() {
        this.checkInitialized();
        this.doScan = true;
        this.networkAdapter.sceNetAdhocctlScan();
        return 0;
    }

    @HLEFunction(nid=876617061, version=150, checkInsideInterrupt=true)
    public int sceNetAdhocctlDisconnect() {
        this.checkInitialized();
        this.doDisconnect = true;
        this.networkAdapter.sceNetAdhocctlDisconnect();
        while (!this.peers.isEmpty()) {
            AdhocctlPeer peer = this.peers.get(0);
            this.hleNetAdhocctlDeletePeer(peer.macAddress);
        }
        return 0;
    }

    @HLEFunction(nid=548607904, version=150, checkInsideInterrupt=true)
    public int sceNetAdhocctlAddHandler(TPointer adhocctlHandlerAddr, int adhocctlHandlerArg) {
        this.checkInitialized();
        AdhocctlHandler adhocctlHandler = new AdhocctlHandler(adhocctlHandlerAddr.getAddress(), adhocctlHandlerArg);
        int id = adhocctlHandler.getId();
        if (id == Integer.MIN_VALUE) {
            return -2143220974;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetAdhocctlAddHandler returning id=0x%X", id));
        }
        this.adhocctlIdMap.put(id, adhocctlHandler);
        return id;
    }

    @HLEFunction(nid=1677871371, version=150, checkInsideInterrupt=true)
    public int sceNetAdhocctlDelHandler(int id) {
        this.checkInitialized();
        AdhocctlHandler handler = this.adhocctlIdMap.remove(id);
        if (handler != null) {
            handler.delete();
        }
        return 0;
    }

    @HLEFunction(nid=1978454918, version=150, checkInsideInterrupt=true)
    public int sceNetAdhocctlGetState(TPointer32 stateAddr) {
        this.checkInitialized();
        stateAddr.setValue(this.adhocctlCurrentState);
        return 0;
    }

    @HLEFunction(nid=908902031, version=150)
    public int sceNetAdhocctlGetAdhocId(TPointer addr) {
        this.checkInitialized();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetAdhocctlGetAdhocId returning type=%d, adhocID='%s'", this.adhocctlCurrentType, this.adhocctlCurrentAdhocID));
        }
        addr.setValue32(0, this.adhocctlCurrentType);
        addr.setStringNZ(4, 9, this.adhocctlCurrentAdhocID);
        return 0;
    }

    @HLEFunction(nid=-513619180, version=150)
    public int sceNetAdhocctlGetPeerList(TPointer32 sizeAddr, @CanBeNull TPointer buf) {
        this.checkInitialized();
        int size = sizeAddr.getValue();
        SceNetAdhocctlPeerInfo peerInfo = new SceNetAdhocctlPeerInfo();
        sizeAddr.setValue(peerInfo.sizeof() * this.peers.size());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetAdhocctlGetPeerList returning size=%d", sizeAddr.getValue()));
        }
        if (buf.isNotNull()) {
            int offset = 0;
            for (AdhocctlPeer peer : this.peers) {
                if (offset + peerInfo.sizeof() > size || peer == null) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetAdhocctlGetPeerList returning %s at 0x%08X", peer, buf.getAddress() + offset));
                }
                peerInfo.nickName = peer.nickName;
                peerInfo.macAddress = new pspNetMacAddress();
                peerInfo.macAddress.setMacAddress(peer.macAddress);
                peerInfo.timestamp = peer.timestamp;
                peerInfo.write(buf, offset);
                offset += peerInfo.sizeof();
            }
            sceNetAdhocctl.fillNextPointersInLinkedList(buf, offset, peerInfo.sizeof());
        }
        return 0;
    }

    @HLEFunction(nid=-1917304868, version=150)
    public int sceNetAdhocctlGetPeerInfo(pspNetMacAddress macAddress, int size, TPointer peerInfoAddr) {
        this.checkInitialized();
        int result = -2143221994;
        if (sceNetAdhoc.isMyMacAddress(macAddress.macAddress)) {
            SceNetAdhocctlPeerInfo peerInfo = new SceNetAdhocctlPeerInfo();
            peerInfo.nickName = sceUtility.getSystemParamNickname();
            peerInfo.macAddress = new pspNetMacAddress(Wlan.getMacAddress());
            peerInfo.timestamp = sceNetAdhocctl.getCurrentTimestamp();
            peerInfo.write(peerInfoAddr);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNetAdhocctlGetPeerInfo for own MAC address, returning %s", peerInfo));
            }
            result = 0;
        } else {
            for (AdhocctlPeer peer : this.peers) {
                if (!macAddress.equals(peer.macAddress)) continue;
                SceNetAdhocctlPeerInfo peerInfo = new SceNetAdhocctlPeerInfo();
                peerInfo.nickName = peer.nickName;
                peerInfo.macAddress = new pspNetMacAddress(peer.macAddress);
                peerInfo.timestamp = peer.timestamp;
                peerInfo.write(peerInfoAddr);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetAdhocctlGetPeerInfo returning %s", peerInfo));
                }
                result = 0;
                break;
            }
        }
        if (result != 0 && log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetAdhocctlGetPeerInfo returning 0x%08X", result));
        }
        return result;
    }

    @HLEFunction(nid=-1722414402, version=150)
    public int sceNetAdhocctlGetAddrByName(@StringInfo(maxLength=128) PspString nickName, TPointer32 sizeAddr, @CanBeNull TPointer buf) {
        this.checkInitialized();
        LinkedList<AdhocctlPeer> matchingPeers = new LinkedList<AdhocctlPeer>();
        for (AdhocctlPeer peer : this.peers) {
            if (!nickName.equals(peer.nickName)) continue;
            matchingPeers.add(peer);
        }
        int size = sizeAddr.getValue();
        SceNetAdhocctlPeerInfo peerInfo = new SceNetAdhocctlPeerInfo();
        sizeAddr.setValue(peerInfo.sizeof() * matchingPeers.size());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetAdhocctlGetAddrByName returning size=%d", sizeAddr.getValue()));
        }
        if (buf.isNotNull()) {
            int offset = 0;
            for (AdhocctlPeer peer : matchingPeers) {
                if (offset + peerInfo.sizeof() > size) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetAdhocctlGetAddrByName returning %s at 0x%08X", peer, buf.getAddress() + offset));
                }
                peerInfo.nickName = peer.nickName;
                peerInfo.macAddress = new pspNetMacAddress();
                peerInfo.macAddress.setMacAddress(peer.macAddress);
                peerInfo.timestamp = peer.timestamp;
                peerInfo.write(buf, offset);
                offset += peerInfo.sizeof();
            }
            sceNetAdhocctl.fillNextPointersInLinkedList(buf, offset, peerInfo.sizeof());
        }
        return 0;
    }

    @HLEFunction(nid=-1994997757, version=150)
    public int sceNetAdhocctlGetNameByAddr(pspNetMacAddress macAddress, TPointer nickNameAddr) {
        this.checkInitialized();
        String nickName = "";
        for (AdhocctlPeer peer : this.peers) {
            if (!sceNetAdhoc.isSameMacAddress(macAddress.macAddress, peer.macAddress)) continue;
            nickName = peer.nickName;
        }
        nickNameAddr.setStringNZ(128, nickName);
        return 0;
    }

    @HLEFunction(nid=-556150130, version=150)
    public int sceNetAdhocctlGetParameter(TPointer paramsAddr) {
        this.checkInitialized();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetAdhocctlGetParameter returning channel=%d, group='%s', IBSS='%s', nickName='%s'", this.adhocctlCurrentChannel, this.adhocctlCurrentGroup, this.adhocctlCurrentIBSS, sceUtility.getSystemParamNickname()));
        }
        paramsAddr.setValue32(0, this.adhocctlCurrentChannel);
        paramsAddr.setStringNZ(4, 8, this.adhocctlCurrentGroup);
        paramsAddr.setStringNZ(12, 6, this.adhocctlCurrentIBSS);
        paramsAddr.setStringNZ(18, 128, sceUtility.getSystemParamNickname());
        return 0;
    }

    @HLEFunction(nid=-2119245378, version=150)
    public int sceNetAdhocctlGetScanInfo(TPointer32 sizeAddr, @CanBeNull TPointer buf) {
        this.checkInitialized();
        int scanInfoSize = 28;
        int size = sizeAddr.getValue();
        sizeAddr.setValue(28 * this.networks.size());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetAdhocctlGetScanInfo returning size=%d", sizeAddr.getValue()));
        }
        if (buf.isNotNull()) {
            int offset = 0;
            for (AdhocctlNetwork network : this.networks) {
                if (offset + 28 > size || network == null) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetAdhocctlGetScanInfo returning %s at 0x%08X", network, buf.getAddress() + offset));
                }
                buf.setValue32(offset += 4, network.channel);
                buf.setStringNZ(offset += 4, 8, network.name);
                buf.setStringNZ(offset += 8, 6, network.bssid);
                buf.setValue16(offset += 6, (short)0);
                buf.setValue32(offset += 2, network.mode);
                offset += 4;
            }
            sceNetAdhocctl.fillNextPointersInLinkedList(buf, offset, 28);
        }
        return 0;
    }

    @HLEFunction(nid=-1514121778, version=150)
    public int sceNetAdhocctlCreateEnterGameMode(@CanBeNull @StringInfo(maxLength=8) PspString groupName, int unknown, int num, TPointer macsAddr, int timeout, int unknown2) {
        this.checkInitialized();
        this.gameModeMacs.clear();
        this.requiredGameModeMacs.clear();
        for (int i = 0; i < num; ++i) {
            pspNetMacAddress macAddress = new pspNetMacAddress();
            macAddress.read(macsAddr, i * macAddress.sizeof());
            this.requiredGameModeMacs.add(macAddress);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)String.format("sceNetAdhocctlCreateEnterGameMode macAddress#%d=%s", i, macAddress));
        }
        this.doJoin = true;
        this.setGroupName(groupName.getString(), 1);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1330114944, version=150)
    public int sceNetAdhocctlCreateEnterGameModeMin() {
        this.checkInitialized();
        return 0;
    }

    @HLEFunction(nid=536385349, version=150)
    public int sceNetAdhocctlJoinEnterGameMode(@StringInfo(maxLength=8) PspString groupName, pspNetMacAddress macAddress, int timeout, int unknown) {
        this.checkInitialized();
        this.doJoin = true;
        this.setGroupName(groupName.getString(), 1);
        return 0;
    }

    @HLEFunction(nid=-812775347, version=150)
    public int sceNetAdhocctlExitGameMode() {
        this.checkInitialized();
        this.doDisconnect = true;
        Modules.sceNetAdhocModule.hleExitGameMode();
        return 0;
    }

    @HLEFunction(nid=1510034656, version=150)
    public int sceNetAdhocctlGetGameModeInfo(TPointer gameModeInfoAddr) {
        this.checkInitialized();
        int offset = 0;
        gameModeInfoAddr.setValue32(offset, this.gameModeMacs.size());
        offset += 4;
        for (pspNetMacAddress macAddress : this.gameModeMacs) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNetAdhocctlGetGameModeInfo returning %s", macAddress));
            }
            macAddress.write(gameModeInfoAddr, offset);
            offset += macAddress.sizeof();
        }
        return 0;
    }

    protected static class AdhocctlNetwork {
        public int channel;
        public String name;
        public String bssid;
        public int mode;

        protected AdhocctlNetwork() {
        }

        public boolean equals(int channel, String name, String bssid, int mode) {
            return channel == this.channel && name.equals(this.name) && bssid.equals(this.bssid) && mode == this.mode;
        }

        public String toString() {
            return String.format("AdhocctlNetwork[channel=%d, name='%s', bssid='%s', mode=%d]", this.channel, this.name, this.bssid, this.mode);
        }
    }

    protected static class AdhocctlPeer {
        public String nickName;
        public byte[] macAddress;
        public long timestamp;

        public AdhocctlPeer(String nickName, byte[] macAddress) {
            this.nickName = nickName;
            this.macAddress = (byte[])macAddress.clone();
            this.updateTimestamp();
        }

        public void updateTimestamp() {
            this.timestamp = sceNetAdhocctl.getCurrentTimestamp();
        }

        public boolean equals(String nickName, byte[] macAddress) {
            return nickName.equals(this.nickName) && sceNetAdhoc.isSameMacAddress(macAddress, this.macAddress);
        }

        public boolean equals(byte[] macAddress) {
            return sceNetAdhoc.isSameMacAddress(macAddress, this.macAddress);
        }

        public String toString() {
            return String.format("nickName='%s', macAddress=%s, timestamp=%d", this.nickName, sceNet.convertMacAddressToString(this.macAddress), this.timestamp);
        }
    }

    protected class AdhocctlHandler {
        private int entryAddr;
        private int currentEvent;
        private int currentError;
        private int currentArg;
        private final int id;

        private AdhocctlHandler(int addr, int arg) {
            this.entryAddr = addr;
            this.currentArg = arg;
            this.id = SceUidManager.getNewId(sceNetAdhocctl.adhocctlHandlerIdPurpose, 0, 3);
        }

        protected void triggerAdhocctlHandler() {
            SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
            if (thread != null) {
                Modules.ThreadManForUserModule.executeCallback(thread, this.entryAddr, null, true, this.currentEvent, this.currentError, this.currentArg);
            }
        }

        protected int getId() {
            return this.id;
        }

        protected void setEvent(int event) {
            this.currentEvent = event;
        }

        protected void setError(int error) {
            this.currentError = error;
        }

        protected void delete() {
            SceUidManager.releaseId(this.id, sceNetAdhocctl.adhocctlHandlerIdPurpose);
        }

        public String toString() {
            return String.format("AdhocctlHandler[id=%d, entry=0x%08X, arg=0x%08X]", this.getId(), this.entryAddr, this.currentArg);
        }
    }
}

