/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.HLEModuleManager;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.MainGUI;
import jpcsp.Memory;
import jpcsp.State;
import jpcsp.graphics.GEProfiler;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.RenderingEngineFactory;
import jpcsp.graphics.RE.RenderingEngineLwjgl;
import jpcsp.graphics.RE.buffer.IREBufferManager;
import jpcsp.graphics.VertexCache;
import jpcsp.graphics.VideoEngine;
import jpcsp.graphics.capture.CaptureManager;
import jpcsp.graphics.textures.GETexture;
import jpcsp.graphics.textures.GETextureManager;
import jpcsp.graphics.textures.TextureCache;
import jpcsp.hardware.Screen;
import jpcsp.memory.IMemoryReaderWriter;
import jpcsp.memory.MemoryReaderWriter;
import jpcsp.scheduler.UnblockThreadAction;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.AbstractStringSettingsListener;
import jpcsp.settings.ISettingsListener;
import jpcsp.settings.Settings;
import jpcsp.util.DurationStatistics;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.PixelFormat;

@HLELogging
public class sceDisplay
extends HLEModule {
    public static Logger log = Modules.getLogger("sceDisplay");
    protected AWTGLCanvas_sceDisplay canvas;
    private boolean onlyGEGraphics = false;
    private boolean saveGEToTexture = false;
    private boolean useSoftwareRenderer = false;
    private boolean saveStencilToMemory = false;
    private static final boolean useDebugGL = false;
    private static final int internalTextureFormat = 3;
    private static final String resizeScaleFactorSettings = "emu.graphics.resizeScaleFactor";
    public static final int PSP_DISPLAY_MODE_LCD = 0;
    public static final int PSP_DISPLAY_MODE_VESA1A = 26;
    public static final int PSP_DISPLAY_MODE_PSEUDO_VGA = 96;
    public static final int PSP_DISPLAY_SETBUF_IMMEDIATE = 0;
    public static final int PSP_DISPLAY_SETBUF_NEXTFRAME = 1;
    private static final float hCountPerVblank = 285.72f;
    private static final float FRAME_PER_SEC = 59.94006f;
    private IRenderingEngine re;
    private IRenderingEngine reDisplay;
    private boolean startModules;
    private boolean isStarted;
    private int drawBuffer;
    private float[] drawBufferArray;
    private boolean resetDisplaySettings;
    private boolean resetGeTextures;
    private int mode;
    private static float viewportResizeFilterScaleFactor = 1.0f;
    private static int viewportResizeFilterScaleFactorInt = 1;
    private boolean resizePending;
    private FrameBufferSettings fb;
    private FrameBufferSettings ge;
    private int sync;
    private boolean setGeBufCalledAtLeastOnce;
    public boolean gotBadGeBufParams;
    public boolean gotBadFbBufParams;
    protected boolean isFbShowing;
    private DisplayScreen displayScreen;
    private boolean detailsDirty;
    private boolean displayDirty;
    private boolean geDirty;
    private long lastUpdate;
    private boolean initGLcalled;
    private String openGLversion;
    private boolean calledFromCommandLine;
    private Buffer temp;
    private ByteBuffer tempByteBuffer;
    private int tempSize;
    private int canvasWidth;
    private int canvasHeight;
    private boolean createTex;
    private int texFb;
    private int resizedTexFb;
    private float texS;
    private float texT;
    private Robot captureRobot;
    private boolean wantScreenshot;
    private long prevStatsTime;
    private long frameCount;
    private long paintFrameCount;
    private long prevFrameCount;
    private long prevPaintFrameCount;
    private long reportCount;
    private int vcount;
    private long lastVblankMicroTime;
    private DisplayVblankAction displayVblankAction;
    public DurationStatistics statistics;
    public DurationStatistics statisticsCopyGeToMemory;
    public DurationStatistics statisticsCopyMemoryToGe;
    private AsyncDisplayThread asyncDisplayThread;
    private SoftwareRenderingDisplayThread softwareRenderingDisplayThread;
    private volatile boolean insideRendering;
    private List<WaitVblankInfo> waitingOnVblank;
    private int antiAliasSamplesNum;
    private int desiredFps = 0;
    private int maxFramesSkippedInSequence = 3;
    private int framesSkippedInSequence;
    private LinkedList<Long> frameTimestamps = new LinkedList();
    private boolean skipNextFrameBufferSwitch;
    private static final int[] stencilPixelMasks = new int[]{0, Short.MAX_VALUE, 4095, 0xFFFFFF};
    private static final int[] stencilValueMasks = new int[]{0, 128, 240, 255};
    private static final int[] stencilValueShifts = new int[]{0, 8, 8, 24};

    public AWTGLCanvas getCanvas() {
        return this.canvas;
    }

    @Override
    public String getName() {
        return "sceDisplay";
    }

    public sceDisplay() throws LWJGLException {
        this.setSettingsListener("emu.graphics.antialias", new AntiAliasSettingsListerner());
        DisplaySettingsListener displaySettingsListener = new DisplaySettingsListener();
        this.setSettingsListener("emu.useVertexCache", displaySettingsListener);
        this.setSettingsListener("emu.useshaders", displaySettingsListener);
        this.setSettingsListener("emu.useGeometryShader", displaySettingsListener);
        this.setSettingsListener("emu.disableubo", displaySettingsListener);
        this.setSettingsListener("emu.enablevao", displaySettingsListener);
        this.setSettingsListener("emu.enablegetexture", displaySettingsListener);
        this.setSettingsListener("emu.enablenativeclut", displaySettingsListener);
        this.setSettingsListener("emu.enabledynamicshaders", displaySettingsListener);
        this.setSettingsListener("emu.enableshaderstenciltest", displaySettingsListener);
        this.setSettingsListener("emu.enableshadercolormask", displaySettingsListener);
        this.displayScreen = new DisplayScreen();
        this.canvas = new AWTGLCanvas_sceDisplay();
        this.setScreenResolution(this.displayScreen.getWidth(), this.displayScreen.getHeight());
        if (!Emulator.getMainGUI().isFullScreen()) {
            this.setViewportResizeScaleFactor(Settings.getInstance().readFloat(resizeScaleFactorSettings, 1.0f));
        }
        this.texFb = -1;
        this.resizedTexFb = -1;
        this.startModules = false;
        this.isStarted = false;
        this.resizePending = false;
        this.tempSize = 0;
        this.fb = new FrameBufferSettings(0x4000000, 512, 480, 272, 3);
        this.ge = new FrameBufferSettings(this.fb);
    }

    public void setDesiredFPS(int desiredFPS) {
        this.desiredFps = desiredFPS;
    }

    public int getDesiredFPS() {
        return this.desiredFps;
    }

    public final void setScreenResolution(int width, int height) {
        this.canvasWidth = width;
        this.canvasHeight = height;
        this.canvas.setSize(width, height);
    }

    public float getViewportResizeScaleFactor() {
        return viewportResizeFilterScaleFactor;
    }

    public void setViewportResizeScaleFactor(int width, int height) {
        float scaleAspectRatio;
        float scaleWidth = (float)width / (float)this.displayScreen.getWidth();
        float scaleHeight = (float)height / (float)this.displayScreen.getHeight();
        if (Emulator.getMainGUI().isFullScreen()) {
            Dimension fullScreenDimension = MainGUI.getFullScreenDimension();
            scaleAspectRatio = fullScreenDimension.width == width && fullScreenDimension.height > height ? scaleWidth : (fullScreenDimension.height == height && fullScreenDimension.width > width ? scaleHeight : Math.min(scaleWidth, scaleHeight));
        } else {
            scaleAspectRatio = (scaleWidth + scaleHeight) / 2.0f;
        }
        this.setViewportResizeScaleFactor(scaleAspectRatio);
        this.resizePending = true;
    }

    private void forceSetViewportResizeScaleFactor(float viewportResizeFilterScaleFactor) {
        if (!Emulator.getMainGUI().isFullScreen()) {
            Settings.getInstance().writeFloat(resizeScaleFactorSettings, viewportResizeFilterScaleFactor);
        }
        this.resetGeTextures = true;
        sceDisplay.viewportResizeFilterScaleFactor = viewportResizeFilterScaleFactor;
        viewportResizeFilterScaleFactorInt = Math.round((float)Math.ceil(viewportResizeFilterScaleFactor));
        Dimension size = new Dimension(sceDisplay.getResizedWidth(this.displayScreen.getWidth()), sceDisplay.getResizedHeight(this.displayScreen.getHeight()));
        this.canvas.setSize(size);
        this.canvas.setPreferredSize(size);
        if (Emulator.getMainGUI().isFullScreen()) {
            Emulator.getMainGUI().setFullScreenDisplaySize();
        }
        this.createTex = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("setViewportResizeScaleFactor resize=%f, size(%dx%d), canvas(%dx%d), location(%d,%d)", Float.valueOf(viewportResizeFilterScaleFactor), size.width, size.height, this.canvasWidth, this.canvasHeight, this.canvas.getLocation().x, this.canvas.getLocation().y));
        }
    }

    public void setViewportResizeScaleFactor(float viewportResizeFilterScaleFactor) {
        if (viewportResizeFilterScaleFactor < 1.0f) {
            return;
        }
        if (viewportResizeFilterScaleFactor != sceDisplay.viewportResizeFilterScaleFactor) {
            this.forceSetViewportResizeScaleFactor(viewportResizeFilterScaleFactor);
        }
    }

    public void updateDisplaySize() {
        float scaleFactor = viewportResizeFilterScaleFactor;
        this.setDisplayMinimumSize();
        Emulator.getMainGUI().setDisplaySize(sceDisplay.getResizedWidth(this.displayScreen.getWidth()), sceDisplay.getResizedHeight(this.displayScreen.getHeight()));
        this.forceSetViewportResizeScaleFactor(scaleFactor);
    }

    public void setDisplayMinimumSize() {
        Emulator.getMainGUI().setDisplayMinimumSize(this.displayScreen.getWidth(), this.displayScreen.getHeight());
    }

    public static int getResizedWidth(int width) {
        return Math.round((float)width * viewportResizeFilterScaleFactor);
    }

    public boolean isDisplaySwappedXY() {
        return this.displayScreen.isSwappedXY();
    }

    public static int getResizedWidthPow2(int widthPow2) {
        return widthPow2 * viewportResizeFilterScaleFactorInt;
    }

    public static int getResizedHeight(int height) {
        return Math.round((float)height * viewportResizeFilterScaleFactor);
    }

    public static int getResizedHeightPow2(int heightPow2) {
        return heightPow2 * viewportResizeFilterScaleFactorInt;
    }

    private void setAntiAliasSamplesNum(int samples) {
        this.antiAliasSamplesNum = samples;
    }

    @Override
    public void start() {
        this.statistics = new DurationStatistics("sceDisplay Statistics");
        this.statisticsCopyGeToMemory = new DurationStatistics("Copy GE to Memory");
        this.statisticsCopyMemoryToGe = new DurationStatistics("Copy Memory to GE");
        if (log.isDebugEnabled()) {
            try {
                DisplayMode[] availableDisplayModes = Display.getAvailableDisplayModes();
                for (int i = 0; availableDisplayModes != null && i < availableDisplayModes.length; ++i) {
                    log.debug((Object)String.format("Available Display Mode #%d = %s", i, availableDisplayModes[i]));
                }
                log.debug((Object)String.format("Desktop Display Mode = %s", Display.getDesktopDisplayMode()));
                log.debug((Object)String.format("Current Display Mode = %s", Display.getDisplayMode()));
                log.debug((Object)String.format("initGL called = %b, OpenGL Version = %s", this.initGLcalled, this.openGLversion));
            }
            catch (LWJGLException e) {
                log.error((Object)e);
            }
        }
        if (!this.initGLcalled && !this.calledFromCommandLine) {
            throw new RuntimeException("Jpcsp cannot display.\nThe cause could be that you are using an old graphic card driver (try to update it)\nor your display format is not compatible with Jpcsp (try to change your display format, Jpcsp requires 32 bit color depth)\nor the anti-aliasing settings is not supported by your display (leave the Jpcsp anti-aliasing to its default setting)");
        }
        if (!HLEModuleManager.getInstance().isStartFromSyscall()) {
            this.mode = 0;
            this.fb = new FrameBufferSettings(0x4000000, 512, 480, 272, 3);
            this.ge = new FrameBufferSettings(this.fb);
            this.sync = 0;
            this.createTex = true;
        }
        this.detailsDirty = true;
        this.displayDirty = true;
        this.geDirty = false;
        this.isFbShowing = false;
        this.setGeBufCalledAtLeastOnce = false;
        this.gotBadGeBufParams = false;
        this.gotBadFbBufParams = false;
        this.prevStatsTime = 0L;
        this.frameCount = 0L;
        this.paintFrameCount = 0L;
        this.prevFrameCount = 0L;
        this.prevFrameCount = 0L;
        this.reportCount = 0L;
        this.insideRendering = false;
        this.vcount = 0;
        if (this.asyncDisplayThread == null) {
            this.asyncDisplayThread = new AsyncDisplayThread();
            this.asyncDisplayThread.setDaemon(true);
            this.asyncDisplayThread.setName("Async Display Thread");
            this.asyncDisplayThread.start();
        }
        if (this.displayVblankAction == null) {
            this.displayVblankAction = new DisplayVblankAction();
            IntrManager.getInstance().addVBlankAction(this.displayVblankAction);
        }
        this.waitingOnVblank = new LinkedList<WaitVblankInfo>();
        this.startModules = true;
        this.re = null;
        this.reDisplay = null;
        this.resetDisplaySettings = false;
        this.saveGEToTexture = Settings.getInstance().readBool("emu.enablegetexture");
        if (this.saveGEToTexture) {
            log.info((Object)"Saving GE to Textures");
        }
        try {
            this.captureRobot = new Robot();
            this.captureRobot.setAutoDelay(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setSettingsListener("emu.onlyGEGraphics", new OnlyGeSettingsListener());
        this.setSettingsListener("emu.useSoftwareRenderer", new SoftwareRendererSettingsListener());
        this.setSettingsListener("emu.saveStencilToMemory", new SaveStencilToMemorySettingsListener());
        super.start();
    }

    @Override
    public void stop() {
        VideoEngine.getInstance().stop();
        if (this.asyncDisplayThread != null) {
            this.asyncDisplayThread.exit();
            this.asyncDisplayThread = null;
        }
        this.re = null;
        this.reDisplay = null;
        this.startModules = false;
        this.isStarted = false;
        super.stop();
    }

    public void exit() {
        if (this.statistics != null) {
            // empty if block
        }
    }

    public void step(boolean immediately) {
        long now = System.currentTimeMillis();
        if (immediately || now - this.lastUpdate > 16L || this.geDirty) {
            if ((!this.isOnlyGEGraphics() || VideoEngine.getInstance().hasDrawLists()) && (this.geDirty || this.detailsDirty || this.displayDirty)) {
                this.detailsDirty = false;
                this.displayDirty = false;
                this.geDirty = false;
                this.asyncDisplayThread.display();
            }
            this.lastUpdate = now;
        }
    }

    public void step() {
        this.step(false);
    }

    public final void write8(int rawAddress) {
        if (this.fb.isRawAddressInside(rawAddress)) {
            this.displayDirty = true;
        }
    }

    public final void write16(int rawAddress) {
        if (this.fb.isRawAddressInside(rawAddress)) {
            this.displayDirty = true;
        }
    }

    public final void write32(int rawAddress) {
        if (this.fb.isRawAddressInside(rawAddress)) {
            this.displayDirty = true;
        }
    }

    public final void write(int address) {
        if (this.fb.isAddressInside(address)) {
            this.displayDirty = true;
        }
    }

    public IRenderingEngine getRenderingEngine() {
        return this.re;
    }

    public void setRenderingEngine(IRenderingEngine re) {
        this.re = re;
    }

    public void setGeDirty(boolean dirty) {
        this.geDirty = dirty;
        if (dirty && this.softwareRenderingDisplayThread != null) {
            this.softwareRenderingDisplayThread.display();
        }
    }

    public void hleDisplaySetGeMode(int width, int height) {
        if (width <= 0 || height <= 0) {
            log.warn((Object)String.format("hleDisplaySetGeMode width=%d, height=%d bad params", width, height));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleDisplaySetGeMode width=%d, height=%d", width, height));
            }
            this.ge.setDimension(width, height);
        }
    }

    public void hleDisplaySetGeBuf(int topaddr, int bufferwidth, int pixelformat, boolean copyGEToMemory, boolean forceLoadGEToScreen) {
        this.hleDisplaySetGeBuf(topaddr, bufferwidth, pixelformat, copyGEToMemory, forceLoadGEToScreen, this.ge.getWidth(), this.ge.getHeight());
    }

    public void hleDisplaySetGeBuf(int topaddr, int bufferwidth, int pixelformat, boolean copyGEToMemory, boolean forceLoadGEToScreen, int width, int height) {
        boolean loadGEToScreen;
        if ((topaddr &= 0x3FFFFFFF) < 0x4000000) {
            topaddr += 0x4000000;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleDisplaySetGeBuf topaddr=0x%08X, bufferwidth=%d, pixelformat=%d, copyGE=%b, with=%d, height=%d", topaddr, bufferwidth, pixelformat, copyGEToMemory, width, height));
        }
        if (this.isUsingSoftwareRenderer() || VideoEngine.getInstance().isSkipThisFrame()) {
            copyGEToMemory = false;
            forceLoadGEToScreen = false;
        }
        if (topaddr == this.ge.getTopAddr() && bufferwidth == this.ge.getBufferWidth() && pixelformat == this.ge.getPixelFormat() && width == this.ge.getWidth() && height == this.ge.getHeight()) {
            if (forceLoadGEToScreen) {
                this.loadGEToScreen();
            }
            return;
        }
        if (topaddr < 0x4000000 || topaddr >= 0x41FFFFF || (bufferwidth &= 0xFFFFFFFC) <= 0 || pixelformat < 0 || pixelformat > 3 || this.sync != 0 && this.sync != 1) {
            if (this.setGeBufCalledAtLeastOnce) {
                log.warn((Object)String.format("hleDisplaySetGeBuf topaddr=0x%08X, bufferwidth=%d, pixelformat=%d bad params", topaddr, bufferwidth, pixelformat));
                this.gotBadGeBufParams = true;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hleDisplaySetGeBuf topaddr=0x%08X, bufferwidth=%d, pixelformat=%d bad params", topaddr, bufferwidth, pixelformat));
                }
                this.setGeBufCalledAtLeastOnce = true;
            }
            return;
        }
        if (this.gotBadGeBufParams) {
            this.gotBadGeBufParams = false;
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("hleDisplaySetGeBuf topaddr=0x%08X, bufferwidth=%d, pixelformat=%d OK", topaddr, bufferwidth, pixelformat));
            }
        }
        if (this.re.isVertexArrayAvailable()) {
            this.re.bindVertexArray(0);
        }
        boolean bl = loadGEToScreen = !this.isUsingSoftwareRenderer() && !VideoEngine.getInstance().isSkipThisFrame();
        if (copyGEToMemory && (this.ge.getTopAddr() != topaddr || this.ge.getPixelFormat() != pixelformat)) {
            this.copyGeToMemory(false, false);
            loadGEToScreen = true;
        }
        this.ge = new FrameBufferSettings(topaddr, bufferwidth, width, height, pixelformat);
        this.checkTemp();
        if (loadGEToScreen) {
            this.loadGEToScreen();
            if (State.captureGeNextFrame) {
                this.captureGeImage();
            }
        }
        this.setGeBufCalledAtLeastOnce = true;
    }

    public static int getPixelFormatBytes(int pixelformat) {
        return IRenderingEngine.sizeOfTextureType[pixelformat];
    }

    public boolean isGeAddress(int address) {
        return this.ge.isAddressInside(address);
    }

    public boolean isFbAddress(int address) {
        return this.fb.isAddressInside(address);
    }

    public boolean isOnlyGEGraphics() {
        return this.onlyGEGraphics;
    }

    public void setOnlyGEGraphics(boolean onlyGEGraphics) {
        this.onlyGEGraphics = onlyGEGraphics;
        log.info((Object)String.format("Only GE Graphics: %b", onlyGEGraphics));
    }

    public boolean isSaveStencilToMemory() {
        return this.saveStencilToMemory;
    }

    public void setSaveStencilToMemory(boolean saveStencilToMemory) {
        this.saveStencilToMemory = saveStencilToMemory;
        log.info((Object)String.format("Save Stencil To Memory: %b", saveStencilToMemory));
    }

    public void setUseSoftwareRenderer(boolean useSoftwareRenderer) {
        this.useSoftwareRenderer = useSoftwareRenderer;
        if (useSoftwareRenderer) {
            if (!Screen.hasScreen() && this.softwareRenderingDisplayThread == null) {
                this.softwareRenderingDisplayThread = new SoftwareRenderingDisplayThread();
                this.softwareRenderingDisplayThread.setDaemon(true);
                this.softwareRenderingDisplayThread.setName("GUI");
                this.softwareRenderingDisplayThread.start();
                log.debug((Object)"Starting Software Rendering Display Thread");
            }
        } else if (this.softwareRenderingDisplayThread != null) {
            log.debug((Object)"Stopping Software Rendering Display Thread");
            this.softwareRenderingDisplayThread.exit();
            this.softwareRenderingDisplayThread = null;
        }
        if (this.isStarted) {
            this.resetDisplaySettings = true;
        }
    }

    public boolean isUsingSoftwareRenderer() {
        return this.useSoftwareRenderer;
    }

    public void rotate(int angleId) {
        switch (angleId) {
            case 0: {
                this.displayScreen = new DisplayScreenRotation90();
                break;
            }
            case 1: {
                this.displayScreen = new DisplayScreenRotation270();
                break;
            }
            case 2: {
                this.displayScreen = new DisplayScreenRotation180();
                break;
            }
            case 3: {
                this.displayScreen = new DisplayScreenMirrorX(new DisplayScreen());
                break;
            }
            case 4: {
                this.displayScreen = new DisplayScreen();
            }
        }
        this.updateDisplaySize();
    }

    public void saveScreen() {
        String fileName;
        String fileFormat = "png";
        int id = 1;
        while (new File(fileName = String.format("%s-Shot-%d.%s", State.discId, id, fileFormat)).exists()) {
            ++id;
        }
        Rectangle rect = Emulator.getMainGUI().getCaptureRectangle();
        try {
            BufferedImage img = this.captureRobot.createScreenCapture(rect);
            ImageIO.write((RenderedImage)img, fileFormat, new File(fileName));
            img.flush();
        }
        catch (IOException e) {
            log.error((Object)"Error saving screenshot", (Throwable)e);
        }
        this.wantScreenshot = false;
    }

    public int getTopAddrFb() {
        return this.fb.getTopAddr();
    }

    public int getBufferWidthFb() {
        return this.fb.getBufferWidth();
    }

    public int getPixelFormatFb() {
        return this.fb.getPixelFormat();
    }

    public int getSync() {
        return this.sync;
    }

    public int getWidthFb() {
        return this.fb.getWidth();
    }

    public int getHeightFb() {
        return this.fb.getHeight();
    }

    public int getTopAddrGe() {
        return this.ge.getTopAddr();
    }

    public int getBufferWidthGe() {
        return this.ge.getBufferWidth();
    }

    public int getWidthGe() {
        return this.ge.getWidth();
    }

    public int getHeightGe() {
        return this.ge.getHeight();
    }

    public BufferInfo getBufferInfoGe() {
        return new BufferInfo(this.ge.getTopAddr(), this.ge.getBottomAddr(), this.ge.getWidth(), this.ge.getHeight(), this.ge.getBufferWidth(), this.ge.getPixelFormat());
    }

    public BufferInfo getBufferInfoFb() {
        return new BufferInfo(this.fb.getTopAddr(), this.fb.getBottomAddr(), this.fb.getWidth(), this.fb.getHeight(), this.fb.getBufferWidth(), this.fb.getPixelFormat());
    }

    public boolean getSaveGEToTexture() {
        return this.saveGEToTexture;
    }

    public int getCanvasWidth() {
        return this.canvasWidth;
    }

    public int getCanvasHeight() {
        return this.canvasHeight;
    }

    public void captureGeImage() {
        if (this.isUsingSoftwareRenderer()) {
            Buffer buffer = Memory.getInstance().getBuffer(this.ge.getTopAddr(), this.ge.getBufferWidth() * this.ge.getHeight() * sceDisplay.getPixelFormatBytes(this.ge.getPixelFormat()));
            CaptureManager.captureImage(this.ge.getTopAddr(), 0, buffer, this.ge.getWidth(), this.ge.getHeight(), this.ge.getBufferWidth(), this.ge.getPixelFormat(), false, 0, false, false);
            return;
        }
        int texGe = this.re.genTexture();
        this.re.bindTexture(texGe);
        this.re.setTextureFormat(this.ge.getPixelFormat(), false);
        this.re.setTexImage(0, 3, sceDisplay.getResizedWidthPow2(this.ge.getBufferWidth()), sceDisplay.getResizedHeightPow2(Utilities.makePow2(this.ge.getHeight())), this.ge.getPixelFormat(), this.ge.getPixelFormat(), 0, null);
        this.re.setTextureMipmapMinFilter(0);
        this.re.setTextureMipmapMagFilter(0);
        this.re.setTextureMipmapMinLevel(0);
        this.re.setTextureMipmapMaxLevel(0);
        this.re.setTextureWrapMode(1, 1);
        this.re.setPixelStore(sceDisplay.getResizedWidthPow2(this.ge.getBufferWidth()), sceDisplay.getPixelFormatBytes(this.ge.getPixelFormat()));
        this.re.copyTexSubImage(0, 0, 0, 0, 0, sceDisplay.getResizedWidth(Math.min(this.ge.getWidth(), this.ge.getBufferWidth())), sceDisplay.getResizedHeight(this.ge.getHeight()));
        this.temp.clear();
        this.re.getTexImage(0, this.ge.getPixelFormat(), this.ge.getPixelFormat(), this.temp);
        CaptureManager.captureImage(this.ge.getTopAddr(), 0, this.temp, sceDisplay.getResizedWidth(this.ge.getWidth()), sceDisplay.getResizedHeight(this.ge.getHeight()), sceDisplay.getResizedWidthPow2(this.ge.getBufferWidth()), this.ge.getPixelFormat(), false, 0, true, false);
        this.re.deleteTexture(texGe);
    }

    public void captureCurrentTexture(int address, int width, int height, int bufferWidth, int pixelFormat) {
        this.re.setPixelStore(bufferWidth, sceDisplay.getPixelFormatBytes(pixelFormat));
        this.temp.clear();
        this.re.getTexImage(0, pixelFormat, pixelFormat, this.temp);
        CaptureManager.captureImage(address, 0, this.temp, width, height, bufferWidth, pixelFormat, false, 0, true, false);
    }

    private void reportFPSStats() {
        long timeNow = System.currentTimeMillis();
        long realElapsedTime = timeNow - this.prevStatsTime;
        if (realElapsedTime > 1000L) {
            ++this.reportCount;
            if (this.frameCount == this.prevFrameCount) {
                this.frameCount = this.paintFrameCount;
                this.prevFrameCount = this.prevPaintFrameCount;
            }
            int lastFPS = (int)(this.frameCount - this.prevFrameCount);
            double averageFPS = (double)this.frameCount / (double)this.reportCount;
            this.prevFrameCount = this.frameCount;
            this.prevPaintFrameCount = this.paintFrameCount;
            this.prevStatsTime = timeNow;
            Emulator.setFpsTitle(String.format("FPS: %d, averageFPS: %.1f", lastFPS, averageFPS));
        }
    }

    private void loadGEToScreen() {
        if (VideoEngine.log.isDebugEnabled()) {
            VideoEngine.log.debug((Object)String.format("Reloading GE Memory (0x%08X-0x%08X) to screen (%dx%d)", this.ge.getTopAddr(), this.ge.getBottomAddr(), this.ge.getWidth(), this.ge.getHeight()));
        }
        if (this.statisticsCopyMemoryToGe != null) {
            this.statisticsCopyMemoryToGe.start();
        }
        if (this.saveGEToTexture && !VideoEngine.getInstance().isVideoTexture(this.ge.getTopAddr())) {
            GETexture geTexture = GETextureManager.getInstance().getGETexture(this.re, this.ge.getTopAddr(), this.ge.getBufferWidth(), this.ge.getWidth(), this.ge.getHeight(), this.ge.getPixelFormat(), true);
            geTexture.copyTextureToScreen(this.re);
        } else {
            if (this.re.isVertexArrayAvailable()) {
                this.re.bindVertexArray(0);
            }
            this.re.bindTexture(this.texFb);
            this.re.setPixelStore(this.ge.getBufferWidth(), sceDisplay.getPixelFormatBytes(this.ge.getPixelFormat()));
            int textureSize = this.ge.getBufferWidth() * this.ge.getHeight() * sceDisplay.getPixelFormatBytes(this.ge.getPixelFormat());
            this.ge.getPixels().clear();
            this.re.setTexSubImage(0, 0, 0, this.ge.getBufferWidth(), this.ge.getHeight(), this.ge.getPixelFormat(), this.ge.getPixelFormat(), textureSize, this.ge.getPixels());
            this.drawFrameBuffer(this.fb, false, true, this.ge.getBufferWidth(), this.ge.getPixelFormat(), this.ge.getWidth(), this.ge.getHeight());
        }
        if (this.statisticsCopyMemoryToGe != null) {
            this.statisticsCopyMemoryToGe.end();
        }
    }

    private void copyStencilToMemory() {
        if (this.ge.getPixelFormat() >= stencilPixelMasks.length) {
            log.warn((Object)String.format("copyGeToMemory: unimplemented pixelformat %d for Stencil buffer copy", this.ge.getPixelFormat()));
            return;
        }
        if (stencilValueMasks[this.ge.getPixelFormat()] == 0) {
            return;
        }
        VideoEngine videoEngine = VideoEngine.getInstance();
        int stencilWidth = Math.min(this.ge.getWidth(), this.ge.getBufferWidth());
        int stencilHeight = Math.min(this.ge.getHeight(), videoEngine.getMaxSpriteHeight());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Copy stencil to GE: pixelFormat=%d, %dx%d, maxSprite=%dx%d", this.ge.getPixelFormat(), stencilWidth, stencilHeight, videoEngine.getMaxSpriteWidth(), videoEngine.getMaxSpriteHeight()));
        }
        int stencilBufferSize = stencilWidth * stencilHeight;
        this.tempByteBuffer.clear();
        this.re.setPixelStore(stencilWidth, 1);
        this.re.readStencil(0, 0, stencilWidth, stencilHeight, stencilBufferSize, this.tempByteBuffer);
        int bytesPerPixel = IRenderingEngine.sizeOfTextureType[this.ge.getPixelFormat()];
        IMemoryReaderWriter memoryReaderWriter = MemoryReaderWriter.getMemoryReaderWriter(this.ge.getTopAddr(), stencilHeight * this.ge.getBufferWidth() * bytesPerPixel, bytesPerPixel);
        this.tempByteBuffer.rewind();
        int stencilPixelMask = stencilPixelMasks[this.ge.getPixelFormat()];
        int stencilValueMask = stencilValueMasks[this.ge.getPixelFormat()];
        int stencilValueShift = stencilValueShifts[this.ge.getPixelFormat()];
        for (int y = 0; y < stencilHeight; ++y) {
            this.tempByteBuffer.position((stencilHeight - y - 1) * stencilWidth);
            for (int x = 0; x < stencilWidth; ++x) {
                int pixel = memoryReaderWriter.readCurrent();
                int stencilValue = this.tempByteBuffer.get() & stencilValueMask;
                pixel = pixel & stencilPixelMask | stencilValue << stencilValueShift;
                memoryReaderWriter.writeNext(pixel);
            }
            if (stencilWidth >= this.ge.getBufferWidth()) continue;
            memoryReaderWriter.skip(this.ge.getBufferWidth() - stencilWidth);
        }
        memoryReaderWriter.flush();
        if (GEProfiler.isProfilerEnabled()) {
            GEProfiler.copyStencilToMemory();
        }
    }

    public void copyGeToMemory(boolean preserveScreen, boolean forceCopyToMemory) {
        if (this.isUsingSoftwareRenderer()) {
            return;
        }
        if (VideoEngine.log.isDebugEnabled()) {
            VideoEngine.log.debug((Object)String.format("Copy GE Screen to Memory 0x%08X-0x%08X", this.ge.getTopAddr(), this.ge.getBottomAddr()));
        }
        if (this.statisticsCopyGeToMemory != null) {
            this.statisticsCopyGeToMemory.start();
        }
        if (this.saveGEToTexture && !VideoEngine.getInstance().isVideoTexture(this.ge.getTopAddr())) {
            GETexture geTexture = GETextureManager.getInstance().getGETexture(this.re, this.ge.getTopAddr(), this.ge.getBufferWidth(), this.ge.getWidth(), this.ge.getHeight(), this.ge.getPixelFormat(), true);
            geTexture.copyScreenToTexture(this.re);
        } else {
            forceCopyToMemory = true;
        }
        if (forceCopyToMemory) {
            this.re.bindTexture(this.resizedTexFb);
            this.re.setTextureFormat(this.ge.getPixelFormat(), false);
            this.re.copyTexSubImage(0, 0, 0, 0, 0, sceDisplay.getResizedWidth(Math.min(this.ge.getBufferWidth(), this.ge.getWidth())), sceDisplay.getResizedHeight(this.ge.getHeight()));
            this.drawFrameBuffer(this.fb, true, true, this.ge.getBufferWidth(), this.ge.getPixelFormat(), this.ge.getWidth(), this.ge.getHeight());
            this.copyScreenToPixels(this.ge.getPixels(), this.ge.getBufferWidth(), this.ge.getPixelFormat(), this.ge.getWidth(), this.ge.getHeight());
            if (this.saveStencilToMemory) {
                this.copyStencilToMemory();
            }
            if (preserveScreen) {
                this.re.bindTexture(this.resizedTexFb);
                this.drawFrameBuffer(this.fb, true, false, this.ge.getBufferWidth(), this.ge.getPixelFormat(), this.ge.getWidth(), this.ge.getHeight());
            }
        }
        if (this.statisticsCopyGeToMemory != null) {
            this.statisticsCopyGeToMemory.end();
        }
        if (GEProfiler.isProfilerEnabled()) {
            GEProfiler.copyGeToMemory();
        }
    }

    private void drawFrameBuffer(FrameBufferSettings fb, boolean keepOriginalSize, boolean invert, int bufferwidth, int pixelformat, int width, int height) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("drawFrameBuffer fb=%s, keepOriginalSize=%b, invert=%b, bufferWidth=%d, pixelFormat=%d, width=%d, height=%d, %s", fb, keepOriginalSize, invert, bufferwidth, pixelformat, width, height, this.displayScreen));
        }
        this.reDisplay.startDirectRendering(true, false, true, true, !invert, width, height);
        if (keepOriginalSize) {
            this.reDisplay.setViewport(0, 0, width, height);
        } else {
            this.reDisplay.setViewport(0, 0, sceDisplay.getResizedWidth(width), sceDisplay.getResizedHeight(height));
        }
        this.reDisplay.setTextureFormat(pixelformat, false);
        float scale = 1.0f;
        if (keepOriginalSize) {
            scale = (float)sceDisplay.getResizedHeight(height) / (float)sceDisplay.getResizedHeightPow2(Utilities.makePow2(height));
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("drawFrameBuffer scale = %f / %f = %f", Float.valueOf(scale), Float.valueOf(this.texT), Float.valueOf(scale / this.texT)));
            }
            scale /= this.texT;
        }
        int i = 0;
        this.drawBufferArray[i++] = this.displayScreen.getTextureLowerRightS() * scale;
        this.drawBufferArray[i++] = this.displayScreen.getTextureLowerRightT() * scale;
        this.drawBufferArray[i++] = width;
        this.drawBufferArray[i++] = height;
        this.drawBufferArray[i++] = this.displayScreen.getTextureLowerLeftS() * scale;
        this.drawBufferArray[i++] = this.displayScreen.getTextureLowerLeftT() * scale;
        this.drawBufferArray[i++] = 0.0f;
        this.drawBufferArray[i++] = height;
        this.drawBufferArray[i++] = this.displayScreen.getTextureUpperLeftS() * scale;
        this.drawBufferArray[i++] = this.displayScreen.getTextureUpperLeftT() * scale;
        this.drawBufferArray[i++] = 0.0f;
        this.drawBufferArray[i++] = 0.0f;
        this.drawBufferArray[i++] = this.displayScreen.getTextureUpperRightS() * scale;
        this.drawBufferArray[i++] = this.displayScreen.getTextureUpperRightT() * scale;
        this.drawBufferArray[i++] = width;
        this.drawBufferArray[i++] = 0.0f;
        int bufferSizeInFloats = i;
        IREBufferManager bufferManager = this.reDisplay.getBufferManager();
        ByteBuffer byteBuffer = bufferManager.getBuffer(this.drawBuffer);
        byteBuffer.clear();
        byteBuffer.asFloatBuffer().put(this.drawBufferArray, 0, bufferSizeInFloats);
        if (this.reDisplay.isVertexArrayAvailable()) {
            this.reDisplay.bindVertexArray(0);
        }
        this.reDisplay.setVertexInfo(null, false, false, true, 7);
        this.reDisplay.enableClientState(0);
        this.reDisplay.disableClientState(1);
        this.reDisplay.disableClientState(2);
        this.reDisplay.enableClientState(3);
        bufferManager.setTexCoordPointer(this.drawBuffer, 2, 6, 4 * VideoEngine.SIZEOF_FLOAT, 0);
        bufferManager.setVertexPointer(this.drawBuffer, 2, 6, 4 * VideoEngine.SIZEOF_FLOAT, 2 * VideoEngine.SIZEOF_FLOAT);
        bufferManager.setBufferData(0, this.drawBuffer, bufferSizeInFloats * VideoEngine.SIZEOF_FLOAT, byteBuffer, 6);
        this.reDisplay.drawArrays(7, 0, 4);
        this.reDisplay.endDirectRendering();
    }

    private void drawFrameBufferFromMemory(FrameBufferSettings fb) {
        fb.getPixels().clear();
        this.reDisplay.bindTexture(this.texFb);
        this.reDisplay.setTextureFormat(fb.getPixelFormat(), false);
        this.reDisplay.setPixelStore(fb.getBufferWidth(), sceDisplay.getPixelFormatBytes(fb.getPixelFormat()));
        int textureSize = fb.getBufferWidth() * fb.getHeight() * sceDisplay.getPixelFormatBytes(fb.getPixelFormat());
        this.reDisplay.setTexSubImage(0, 0, 0, fb.getBufferWidth(), fb.getHeight(), fb.getPixelFormat(), fb.getPixelFormat(), textureSize, fb.getPixels());
        this.drawFrameBuffer(fb, false, true, fb.getBufferWidth(), fb.getPixelFormat(), this.displayScreen.getWidth(fb), this.displayScreen.getHeight(fb));
    }

    private void copyBufferByLines(IntBuffer dstBuffer, IntBuffer srcBuffer, int dstBufferWidth, int srcBufferWidth, int pixelFormat, int width, int height) {
        int pixelsPerElement = 4 / sceDisplay.getPixelFormatBytes(pixelFormat);
        for (int y = 0; y < height; ++y) {
            int srcStartOffset = y * srcBufferWidth / pixelsPerElement;
            int dstStartOffset = y * dstBufferWidth / pixelsPerElement;
            srcBuffer.limit(srcStartOffset + (width + 1) / pixelsPerElement);
            srcBuffer.position(srcStartOffset);
            dstBuffer.position(dstStartOffset);
            if (srcBuffer.remaining() >= dstBuffer.remaining()) continue;
            dstBuffer.put(srcBuffer);
        }
    }

    private void copyScreenToPixels(Buffer pixels, int bufferWidth, int pixelFormat, int width, int height) {
        this.reDisplay.bindTexture(this.texFb);
        this.reDisplay.setTextureFormat(this.fb.getPixelFormat(), false);
        this.reDisplay.setPixelStore(bufferWidth, sceDisplay.getPixelFormatBytes(pixelFormat));
        this.reDisplay.copyTexSubImage(0, 0, 0, 0, 0, Math.min(bufferWidth, width), height);
        Buffer buffer = pixels.capacity() >= this.temp.capacity() ? pixels : this.temp;
        buffer.clear();
        this.reDisplay.getTexImage(0, pixelFormat, pixelFormat, buffer);
        if (buffer == this.temp) {
            this.temp.clear();
            pixels.clear();
            this.temp.limit(pixels.limit());
            if (this.temp instanceof ByteBuffer) {
                ByteBuffer srcBuffer = (ByteBuffer)this.temp;
                ByteBuffer dstBuffer = (ByteBuffer)pixels;
                dstBuffer.put(srcBuffer);
            } else if (this.temp instanceof IntBuffer) {
                IntBuffer srcBuffer = (IntBuffer)this.temp;
                IntBuffer dstBuffer = (IntBuffer)pixels;
                VideoEngine videoEngine = VideoEngine.getInstance();
                if (videoEngine.isUsingTRXKICK() && videoEngine.getMaxSpriteHeight() < Integer.MAX_VALUE) {
                    int srcBufferWidth = bufferWidth;
                    int dstBufferWidth = bufferWidth;
                    int pixelsPerElement = 4 / sceDisplay.getPixelFormatBytes(pixelFormat);
                    int maxHeight = videoEngine.getMaxSpriteHeight();
                    int maxWidth = videoEngine.getMaxSpriteWidth();
                    int textureAlignment = pixelsPerElement == 1 ? 3 : 7;
                    maxHeight = maxHeight + textureAlignment & ~textureAlignment;
                    maxWidth = maxWidth + textureAlignment & ~textureAlignment;
                    if (VideoEngine.log.isDebugEnabled()) {
                        VideoEngine.log.debug((Object)("maxSpriteHeight=" + maxHeight + ", maxSpriteWidth=" + maxWidth));
                    }
                    if (maxHeight > height) {
                        maxHeight = height;
                    }
                    if (maxWidth > width) {
                        maxWidth = width;
                    }
                    this.copyBufferByLines(dstBuffer, srcBuffer, dstBufferWidth, srcBufferWidth, pixelFormat, maxWidth, maxHeight);
                } else {
                    dstBuffer.put(srcBuffer);
                }
            } else {
                throw new RuntimeException("unhandled buffer type");
            }
        }
    }

    public int hleDisplayWaitVblankStart(int cycles, boolean doCallbacks) {
        if (cycles <= 0) {
            return -2147483138;
        }
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        SceKernelThreadInfo thread = threadMan.getCurrentThread();
        int threadId = threadMan.getCurrentThreadID();
        int lastWaitVblank = thread.displayLastWaitVcount;
        int unblockVcount = lastWaitVblank + cycles;
        if (unblockVcount <= this.vcount) {
            UnblockThreadAction vblankAction = new UnblockThreadAction(threadId);
            IntrManager.getInstance().addVBlankActionOnce(vblankAction);
            thread.displayLastWaitVcount = this.vcount + 1;
        } else {
            WaitVblankInfo waitVblankInfo = new WaitVblankInfo(threadId, unblockVcount);
            this.waitingOnVblank.add(waitVblankInfo);
        }
        threadMan.hleBlockCurrentThread(261, unblockVcount, doCallbacks, null, new VblankWaitStateChecker(unblockVcount));
        return 0;
    }

    private void hleVblankStart() {
        this.lastVblankMicroTime = Emulator.getClock().microTime();
        ++this.vcount;
        if (!this.waitingOnVblank.isEmpty()) {
            ListIterator<WaitVblankInfo> lit = this.waitingOnVblank.listIterator();
            while (lit.hasNext()) {
                WaitVblankInfo waitVblankInfo = lit.next();
                if (waitVblankInfo.unblockVcount > this.vcount) continue;
                ThreadManForUser threadMan = Modules.ThreadManForUserModule;
                SceKernelThreadInfo thread = threadMan.getThreadById(waitVblankInfo.threadId);
                if (thread != null) {
                    thread.displayLastWaitVcount = this.vcount;
                    threadMan.hleUnblockThread(waitVblankInfo.threadId);
                }
                lit.remove();
            }
        }
    }

    private boolean isVblank() {
        long nowMicroTime = Emulator.getClock().microTime();
        long microTimeSinceLastVblank = nowMicroTime - this.lastVblankMicroTime;
        return microTimeSinceLastVblank <= 731L;
    }

    private int getCurrentHcount() {
        long nowMicroTime = Emulator.getClock().microTime();
        long microTimeSinceLastVblank = nowMicroTime - this.lastVblankMicroTime;
        float vblankStep = (float)microTimeSinceLastVblank / 16666.666f;
        if (vblankStep > 1.0f) {
            vblankStep = 1.0f;
        }
        return (int)(vblankStep * 285.72f);
    }

    public int getVcount() {
        return this.vcount;
    }

    private int createTexture(int textureId, boolean isResized) {
        if (textureId != -1) {
            this.reDisplay.deleteTexture(textureId);
        }
        textureId = this.reDisplay.genTexture();
        this.reDisplay.bindTexture(textureId);
        this.reDisplay.setTextureFormat(this.fb.getPixelFormat(), false);
        this.reDisplay.setTexImage(0, 3, isResized ? sceDisplay.getResizedWidthPow2(this.fb.getBufferWidth()) : this.fb.getBufferWidth(), isResized ? sceDisplay.getResizedHeightPow2(Utilities.makePow2(this.fb.getHeight())) : Utilities.makePow2(this.fb.getHeight()), this.fb.getPixelFormat(), this.fb.getPixelFormat(), 0, null);
        this.reDisplay.setTextureMipmapMinFilter(0);
        this.reDisplay.setTextureMipmapMagFilter(0);
        this.reDisplay.setTextureMipmapMinLevel(0);
        this.reDisplay.setTextureMipmapMaxLevel(0);
        this.reDisplay.setTextureWrapMode(1, 1);
        return textureId;
    }

    private void checkTemp() {
        int sizeInBytes = sceDisplay.getResizedWidthPow2(Math.max(this.fb.getBufferWidth(), this.ge.getBufferWidth())) * sceDisplay.getResizedHeightPow2(Utilities.makePow2(Math.max(this.fb.getHeight(), this.ge.getHeight()))) * sceDisplay.getPixelFormatBytes(Math.max(this.fb.getPixelFormat(), this.ge.getPixelFormat()));
        if (sizeInBytes > this.tempSize) {
            this.tempByteBuffer = ByteBuffer.allocateDirect(sizeInBytes).order(ByteOrder.LITTLE_ENDIAN);
            this.temp = Memory.getInstance().getMainMemoryByteBuffer() instanceof IntBuffer ? this.tempByteBuffer.asIntBuffer() : this.tempByteBuffer;
            this.tempSize = sizeInBytes;
        }
    }

    public void setCalledFromCommandLine() {
        this.calledFromCommandLine = true;
    }

    public void takeScreenshot() {
        this.wantScreenshot = true;
    }

    public boolean isInsideRendering() {
        return this.insideRendering;
    }

    public void setInsideRendering(boolean insideRendering) {
        this.insideRendering = insideRendering;
    }

    public void waitForRenderingCompletion(int address) {
        while (this.isInsideRendering() && this.isGeAddress(address)) {
            Utilities.sleep(10);
        }
    }

    @HLEFunction(nid=237039991, version=150, checkInsideInterrupt=true)
    public int sceDisplaySetMode(int displayMode, int displayWidth, int displayHeight) {
        if (displayWidth <= 0 || displayHeight <= 0) {
            return -2147483388;
        }
        if (displayMode != 0) {
            return -2147483385;
        }
        this.mode = displayMode;
        this.fb.setDimension(displayWidth, displayHeight);
        this.detailsDirty = true;
        return 0;
    }

    @HLEFunction(nid=-559835180, version=150)
    public int sceDisplayGetMode(TPointer32 modeAddr, TPointer32 widthAddr, TPointer32 heightAddr) {
        modeAddr.setValue(this.mode);
        widthAddr.setValue(this.fb.getWidth());
        heightAddr.setValue(this.fb.getHeight());
        return 0;
    }

    @HLEFunction(nid=-609827644, version=150)
    public float sceDisplayGetFramePerSec() {
        return 59.94006f;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2127928260, version=150, checkInsideInterrupt=true)
    public int sceDisplaySetHoldMode(int holdMode) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1522219898, version=150, checkInsideInterrupt=true)
    public int sceDisplaySetResumeMode(int resumeMode) {
        return 0;
    }

    @HLEFunction(nid=681411326, version=150)
    public int sceDisplaySetFrameBuf(@CanBeNull TPointer topaddr, int bufferwidth, int pixelformat, int syncType) {
        return this.hleDisplaySetFrameBuf(topaddr.getAddress(), bufferwidth, pixelformat, syncType);
    }

    private int hleDisplaySetFrameBufError(int topaddr, int bufferwidth, int pixelformat, int syncType, int error, String errorString) {
        log.warn((Object)String.format("sceDisplaySetFrameBuf topaddr=0x%08X, bufferwidth=%d, pixelformat=%d, syncType=%d %s: returning 0x%08X", topaddr, bufferwidth, pixelformat, syncType, errorString, error));
        this.gotBadFbBufParams = true;
        return error;
    }

    public int hleDisplaySetFrameBuf(int topaddr, int bufferwidth, int pixelformat, int syncType) {
        if (syncType != 0 && syncType != 1) {
            return this.hleDisplaySetFrameBufError(topaddr, bufferwidth, pixelformat, syncType, -2147483385, "bad syncType");
        }
        if ((topaddr & 0xF) != 0) {
            return this.hleDisplaySetFrameBufError(topaddr, bufferwidth, pixelformat, syncType, -2147483389, "bad topaddr");
        }
        if (topaddr != 0 && !Memory.isRAM(topaddr) && !Memory.isVRAM(topaddr)) {
            return this.hleDisplaySetFrameBufError(topaddr, bufferwidth, pixelformat, syncType, -2147483389, "bad topaddr");
        }
        if ((bufferwidth & 0x3F) != 0) {
            return this.hleDisplaySetFrameBufError(topaddr, bufferwidth, pixelformat, syncType, -2147483388, "bad bufferwidth");
        }
        if (bufferwidth == 0 && topaddr != 0) {
            return this.hleDisplaySetFrameBufError(topaddr, bufferwidth, pixelformat, syncType, -2147483388, "bad bufferwidth");
        }
        if (pixelformat < 0 || pixelformat > 3) {
            return this.hleDisplaySetFrameBufError(topaddr, bufferwidth, pixelformat, syncType, -2147483384, "bad pixelformat");
        }
        if (topaddr == 0) {
            log.info((Object)String.format("sceDisplaySetFrameBuf topaddr=0x%08X, bufferwidth=%d, pixelformat=%d, syncType=%d (blocking display output)", topaddr, bufferwidth, pixelformat, syncType));
            this.isFbShowing = false;
            this.gotBadFbBufParams = true;
            return 0;
        }
        if (this.gotBadFbBufParams) {
            this.gotBadFbBufParams = false;
            log.info((Object)String.format("sceDisplaySetFrameBuf topaddr=0x%08X, bufferwidth=%d, pixelformat=%d, syncType=%d ok", topaddr, bufferwidth, pixelformat, syncType));
        }
        if (topaddr == this.fb.getTopAddr() && bufferwidth == this.fb.getBufferWidth() && pixelformat == this.fb.getPixelFormat() && syncType == this.sync) {
            return 0;
        }
        if (topaddr != this.fb.getTopAddr()) {
            ++this.frameCount;
        }
        this.framesSkippedInSequence = this.skipNextFrameBufferSwitch ? ++this.framesSkippedInSequence : 0;
        boolean skipThisFrame = false;
        if (this.desiredFps > 0) {
            long currentFrameTimestamp = Emulator.getClock().currentTimeMillis();
            this.frameTimestamps.addLast(currentFrameTimestamp);
            while (currentFrameTimestamp - this.frameTimestamps.getFirst() > 1000L) {
                this.frameTimestamps.removeFirst();
            }
            int currentFps = this.frameTimestamps.size();
            if (currentFps < this.desiredFps && this.framesSkippedInSequence < this.maxFramesSkippedInSequence) {
                skipThisFrame = true;
            }
        }
        VideoEngine.getInstance().setSkipThisFrame(skipThisFrame);
        if (this.skipNextFrameBufferSwitch) {
            if (topaddr != this.fb.getTopAddr()) {
                Memory.getInstance().memcpy(topaddr, this.fb.getTopAddr(), this.fb.getBottomAddr() - this.fb.getTopAddr());
            }
            this.skipNextFrameBufferSwitch = false;
        }
        if (pixelformat != this.fb.getPixelFormat() || bufferwidth != this.fb.getBufferWidth() || Utilities.makePow2(this.fb.getHeight()) != Utilities.makePow2(this.fb.getHeight())) {
            this.createTex = true;
        }
        this.fb = new FrameBufferSettings(topaddr, bufferwidth, this.fb.getWidth(), this.fb.getHeight(), pixelformat);
        this.sync = syncType;
        this.texS = (float)this.fb.getWidth() / (float)bufferwidth;
        this.texT = (float)this.fb.getHeight() / (float)Utilities.makePow2(this.fb.getHeight());
        this.displayScreen.update();
        this.detailsDirty = true;
        this.isFbShowing = true;
        if (State.captureGeNextFrame && CaptureManager.hasListExecuted()) {
            State.captureGeNextFrame = false;
            CaptureManager.captureFrameBufDetails();
            CaptureManager.endCapture();
        }
        VideoEngine.getInstance().hleSetFrameBuf(this.fb.getTopAddr(), this.fb.getBufferWidth(), this.fb.getPixelFormat());
        return 0;
    }

    @HLEFunction(nid=-287691180, version=150)
    public int sceDisplayGetFrameBuf(TPointer32 topaddrAddr, TPointer32 bufferwidthAddr, TPointer32 pixelformatAddr, int syncType) {
        topaddrAddr.setValue(this.fb.getTopAddr());
        bufferwidthAddr.setValue(this.fb.getBufferWidth());
        pixelformatAddr.setValue(this.fb.getPixelFormat());
        return 0;
    }

    @HLEFunction(nid=-1259112198, version=150)
    public boolean sceDisplayIsForeground() {
        return this.isFbShowing;
    }

    @HLEUnimplemented
    @HLEFunction(nid=834976424, version=150)
    public int sceDisplayGetBrightness(int leveladdr, int unkaddr) {
        return 0;
    }

    @HLEFunction(nid=-1670468905, version=150)
    public int sceDisplayGetVcount() {
        return this.vcount;
    }

    @HLEFunction(nid=1296961772, version=150)
    public boolean sceDisplayIsVblank() {
        boolean isVblank = this.isVblank();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceDisplayIsVblank returns %b", isVblank));
        }
        return isVblank;
    }

    @HLEFunction(nid=919468766, version=150, checkInsideInterrupt=true)
    public int sceDisplayWaitVblank() {
        if (!this.isVblank()) {
            this.sceDisplayWaitVblankStart();
        }
        return 0;
    }

    @HLEFunction(nid=-1900417975, version=150, checkInsideInterrupt=true)
    public int sceDisplayWaitVblankCB() {
        if (!this.isVblank()) {
            this.sceDisplayWaitVblankStartCB();
        }
        return 0;
    }

    @HLEFunction(nid=-1739839513, version=150, checkInsideInterrupt=true)
    public int sceDisplayWaitVblankStart() {
        return this.hleDisplayWaitVblankStart(1, false);
    }

    @HLEFunction(nid=1190233795, version=150, checkInsideInterrupt=true)
    public int sceDisplayWaitVblankStartCB() {
        return this.hleDisplayWaitVblankStart(1, true);
    }

    @HLEFunction(nid=2000540579, version=150)
    public int sceDisplayGetCurrentHcount() {
        int currentHcount = this.getCurrentHcount();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceDisplayGetCurrentHcount returning %d", currentHcount));
        }
        return currentHcount;
    }

    @HLEFunction(nid=554609466, version=150)
    public int sceDisplayGetAccumulatedHcount() {
        int currentHcount = this.getCurrentHcount();
        int accumulatedHcount = currentHcount + (int)((float)this.vcount * 285.72f);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceDisplayGetAccumulatedHcount returning %d (currentHcount=%d)", accumulatedHcount, currentHcount));
        }
        return accumulatedHcount;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1472270023, version=150)
    public int sceDisplayAdjustAccumulatedHcount() {
        return 0;
    }

    static /* synthetic */ float[] access$1202(sceDisplay x0, float[] x1) {
        x0.drawBufferArray = x1;
        return x1;
    }

    protected class DisplayScreenMirrorY
    extends DisplayScreen {
        private DisplayScreen displayScreen;

        public DisplayScreenMirrorY(DisplayScreen displayScreen) {
            this.displayScreen = displayScreen;
        }

        @Override
        protected int[] getIndices() {
            int[] i = this.displayScreen.getIndices();
            return new int[]{i[4], i[5], i[6], i[7], i[0], i[1], i[2], i[3]};
        }

        @Override
        protected boolean isSwappedXY() {
            return this.displayScreen.isSwappedXY();
        }
    }

    protected class DisplayScreenMirrorX
    extends DisplayScreen {
        private DisplayScreen displayScreen;

        public DisplayScreenMirrorX(DisplayScreen displayScreen) {
            this.displayScreen = displayScreen;
            this.update();
        }

        @Override
        protected int[] getIndices() {
            if (this.displayScreen == null) {
                return null;
            }
            int[] i = this.displayScreen.getIndices();
            return new int[]{i[2], i[3], i[0], i[1], i[6], i[7], i[4], i[5]};
        }

        @Override
        protected boolean isSwappedXY() {
            return this.displayScreen.isSwappedXY();
        }
    }

    protected class DisplayScreenRotation270
    extends DisplayScreen {
        protected DisplayScreenRotation270() {
        }

        @Override
        protected int[] getIndices() {
            return new int[]{2, 3, 6, 7, 0, 1, 4, 5};
        }

        @Override
        protected boolean isSwappedXY() {
            return true;
        }
    }

    protected class DisplayScreenRotation180
    extends DisplayScreen {
        protected DisplayScreenRotation180() {
        }

        @Override
        protected int[] getIndices() {
            return new int[]{6, 7, 4, 5, 2, 3, 0, 1};
        }
    }

    protected class DisplayScreenRotation90
    extends DisplayScreen {
        protected DisplayScreenRotation90() {
        }

        @Override
        protected int[] getIndices() {
            return new int[]{4, 5, 0, 1, 6, 7, 2, 3};
        }

        @Override
        protected boolean isSwappedXY() {
            return true;
        }
    }

    protected class DisplayScreen {
        private float[] values;

        public DisplayScreen() {
            this.update();
        }

        public void update() {
            int[] indices = this.getIndices();
            if (indices == null) {
                return;
            }
            float[] baseValues = new float[]{0.0f, 0.0f, sceDisplay.this.texS, 0.0f, 0.0f, sceDisplay.this.texT, sceDisplay.this.texS, sceDisplay.this.texT};
            this.values = new float[baseValues.length];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = baseValues[indices[i]];
            }
        }

        protected int[] getIndices() {
            return new int[]{0, 1, 2, 3, 4, 5, 6, 7};
        }

        protected boolean isSwappedXY() {
            return false;
        }

        protected int getWidth(int width, int height) {
            return this.isSwappedXY() ? height : width;
        }

        protected int getHeight(int width, int height) {
            return this.isSwappedXY() ? width : height;
        }

        public int getWidth() {
            return this.getWidth(480, 272);
        }

        public int getHeight() {
            return this.getHeight(480, 272);
        }

        public int getWidth(FrameBufferSettings fb) {
            return this.getWidth(fb.getWidth(), fb.getHeight());
        }

        public int getHeight(FrameBufferSettings fb) {
            return this.getHeight(fb.getWidth(), fb.getHeight());
        }

        public float getTextureUpperLeftS() {
            return this.values[0];
        }

        public float getTextureUpperLeftT() {
            return this.values[1];
        }

        public float getTextureUpperRightS() {
            return this.values[2];
        }

        public float getTextureUpperRightT() {
            return this.values[3];
        }

        public float getTextureLowerLeftS() {
            return this.values[4];
        }

        public float getTextureLowerLeftT() {
            return this.values[5];
        }

        public float getTextureLowerRightS() {
            return this.values[6];
        }

        public float getTextureLowerRightT() {
            return this.values[7];
        }

        public String toString() {
            return String.format("DisplayScreen [%f, %f, %f, %f, %f, %f, %f, %f, %b]", Float.valueOf(this.values[0]), Float.valueOf(this.values[1]), Float.valueOf(this.values[2]), Float.valueOf(this.values[3]), Float.valueOf(this.values[4]), Float.valueOf(this.values[5]), Float.valueOf(this.values[6]), Float.valueOf(this.values[7]), this.isSwappedXY());
        }
    }

    public static class BufferInfo {
        public int topAddr;
        public int bottomAddr;
        public int width;
        public int height;
        public int bufferWidth;
        public int pixelFormat;

        public BufferInfo(int topAddr, int bottomAddr, int width, int height, int bufferWidth, int pixelFormat) {
            this.topAddr = topAddr;
            this.bottomAddr = bottomAddr;
            this.width = width;
            this.height = height;
            this.bufferWidth = bufferWidth;
            this.pixelFormat = pixelFormat;
        }
    }

    private class DisplaySettingsListener
    implements ISettingsListener {
        private DisplaySettingsListener() {
        }

        @Override
        public void settingsValueChanged(String option, String value) {
            if (sceDisplay.this.isStarted) {
                sceDisplay.this.resetDisplaySettings = true;
            }
        }
    }

    private class AntiAliasSettingsListerner
    extends AbstractStringSettingsListener {
        private Pattern pattern = Pattern.compile("x(\\d+)", 2);

        private AntiAliasSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(String value) {
            Matcher matcher;
            int samples = 0;
            if (value != null && (matcher = this.pattern.matcher(value)).matches()) {
                samples = Integer.parseInt(matcher.group(1));
            }
            sceDisplay.this.setAntiAliasSamplesNum(samples);
        }
    }

    private class VblankWaitStateChecker
    implements IWaitStateChecker {
        private int vcount;

        public VblankWaitStateChecker(int vcount) {
            this.vcount = vcount;
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            return sceDisplay.this.vcount < this.vcount;
        }
    }

    private class DisplayVblankAction
    implements IAction {
        private DisplayVblankAction() {
        }

        @Override
        public void execute() {
            sceDisplay.this.hleVblankStart();
        }
    }

    private static class SoftwareRenderingDisplayThread
    extends AbstractDisplayThread {
        private SoftwareRenderingDisplayThread() {
        }

        @Override
        protected void doDisplay() {
            if (VideoEngine.getInstance().hasDrawLists()) {
                IRenderingEngine re = Modules.sceDisplayModule.getRenderingEngine();
                if (re == null && !Screen.hasScreen()) {
                    re = RenderingEngineFactory.createRenderingEngine();
                    Modules.sceDisplayModule.setRenderingEngine(re);
                    VideoEngine.getInstance().start();
                }
                if (re != null) {
                    re.startDisplay();
                    VideoEngine.getInstance().update();
                    re.endDisplay();
                }
            }
        }
    }

    private static class AsyncDisplayThread
    extends AbstractDisplayThread {
        private AsyncDisplayThread() {
        }

        @Override
        protected void doDisplay() {
            if (!Modules.sceDisplayModule.isOnlyGEGraphics() || VideoEngine.getInstance().hasDrawLists()) {
                Modules.sceDisplayModule.canvas.repaint();
            }
        }
    }

    private static abstract class AbstractDisplayThread
    extends Thread {
        private Semaphore displaySemaphore = new Semaphore(1);
        protected boolean run = true;

        public AbstractDisplayThread() {
            VideoEngine.getInstance();
        }

        @Override
        public void run() {
            while (this.run) {
                this.waitForDisplay();
                if (!this.run) continue;
                this.doDisplay();
            }
        }

        protected abstract void doDisplay();

        public void display() {
            this.displaySemaphore.release();
        }

        private void waitForDisplay() {
            while (true) {
                try {
                    int availablePermits;
                    while ((availablePermits = this.displaySemaphore.drainPermits()) <= 0 && !this.displaySemaphore.tryAcquire(100L, TimeUnit.MILLISECONDS)) {
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public void exit() {
            this.run = false;
            this.display();
        }
    }

    private static class WaitVblankInfo {
        public int threadId;
        public int unblockVcount;

        public WaitVblankInfo(int threadId, int unblockVcount) {
            this.threadId = threadId;
            this.unblockVcount = unblockVcount;
        }
    }

    private class SaveStencilToMemorySettingsListener
    extends AbstractBoolSettingsListener {
        private SaveStencilToMemorySettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceDisplay.this.setSaveStencilToMemory(value);
        }
    }

    private class SoftwareRendererSettingsListener
    extends AbstractBoolSettingsListener {
        private SoftwareRendererSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceDisplay.this.setUseSoftwareRenderer(value);
        }
    }

    private class OnlyGeSettingsListener
    extends AbstractBoolSettingsListener {
        private OnlyGeSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceDisplay.this.setOnlyGEGraphics(value);
        }
    }

    private static class FrameBufferSettings {
        private int topAddr;
        private int bottomAddr;
        private int bufferWidth;
        private int width;
        private int height;
        private int pixelFormat;
        private Buffer pixels;

        public FrameBufferSettings(int topAddr, int bufferWidth, int width, int height, int pixelFormat) {
            this.topAddr = topAddr & 0x3FFFFFFF;
            this.bufferWidth = bufferWidth;
            this.width = width;
            this.height = height;
            this.pixelFormat = pixelFormat;
            this.update();
        }

        public FrameBufferSettings(FrameBufferSettings copy) {
            this.topAddr = copy.topAddr;
            this.bottomAddr = copy.bottomAddr;
            this.bufferWidth = copy.bufferWidth;
            this.width = copy.width;
            this.height = copy.height;
            this.pixelFormat = copy.pixelFormat;
            this.pixels = copy.pixels;
        }

        private void update() {
            int size = this.bufferWidth * this.height * sceDisplay.getPixelFormatBytes(this.pixelFormat);
            this.bottomAddr = this.topAddr + size;
            this.pixels = Memory.getInstance().getBuffer(this.topAddr, size);
        }

        public int getTopAddr() {
            return this.topAddr;
        }

        public int getBottomAddr() {
            return this.bottomAddr;
        }

        public int getBufferWidth() {
            return this.bufferWidth;
        }

        public int getPixelFormat() {
            return this.pixelFormat;
        }

        public Buffer getPixels() {
            return this.pixels;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public boolean isRawAddressInside(int address) {
            return address >= this.topAddr && address < this.bottomAddr;
        }

        public boolean isAddressInside(int address) {
            return this.isRawAddressInside(address & 0x3FFFFFFF);
        }

        public void setDimension(int width, int height) {
            this.width = width;
            this.height = height;
            this.update();
        }

        public String toString() {
            return String.format("0x%08X-0x%08X, %dx%d, bufferWidth=%d, pixelFormat=%d", this.topAddr, this.bottomAddr, this.width, this.height, this.bufferWidth, this.pixelFormat);
        }
    }

    class AWTGLCanvas_sceDisplay
    extends AWTGLCanvas {
        public AWTGLCanvas_sceDisplay() throws LWJGLException {
            super(null, new PixelFormat().withBitsPerPixel(8).withAlphaBits(8).withStencilBits(8).withSamples(sceDisplay.this.antiAliasSamplesNum), null, new ContextAttribs().withDebug(false));
        }

        @Override
        protected void paintGL() {
            VideoEngine videoEngine = VideoEngine.getInstance();
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("paintGL resize=%f, size(%dx%d), canvas(%dx%d), location(%d,%d)", Float.valueOf(viewportResizeFilterScaleFactor), sceDisplay.this.canvas.getSize().width, sceDisplay.this.canvas.getSize().height, sceDisplay.this.canvasWidth, sceDisplay.this.canvasHeight, sceDisplay.this.canvas.getLocation().x, sceDisplay.this.canvas.getLocation().y));
            }
            if (sceDisplay.this.resizePending && Emulator.getMainGUI().isVisible()) {
                Emulator.getMainGUI().pack();
                sceDisplay.this.resizePending = false;
            }
            if (sceDisplay.this.statistics != null) {
                sceDisplay.this.statistics.start();
            }
            if (sceDisplay.this.resetDisplaySettings) {
                if (sceDisplay.this.isStarted) {
                    videoEngine.stop();
                }
                TextureCache.getInstance().reset(sceDisplay.this.re);
                VertexCache.getInstance().reset(sceDisplay.this.re);
                sceDisplay.this.startModules = true;
                sceDisplay.this.re = null;
                sceDisplay.this.reDisplay = null;
                sceDisplay.this.resetDisplaySettings = false;
                sceDisplay.this.saveGEToTexture = Settings.getInstance().readBool("emu.enablegetexture");
                if (sceDisplay.this.saveGEToTexture) {
                    log.info((Object)"Saving GE to Textures");
                }
            }
            if (sceDisplay.this.re == null) {
                if (sceDisplay.this.startModules) {
                    sceDisplay.this.re = RenderingEngineFactory.createRenderingEngine();
                    if (sceDisplay.this.isUsingSoftwareRenderer()) {
                        sceDisplay.this.reDisplay = RenderingEngineFactory.createRenderingEngineForDisplay();
                        sceDisplay.this.reDisplay.setGeContext(videoEngine.getContext());
                    } else {
                        sceDisplay.this.reDisplay = sceDisplay.this.re;
                    }
                } else {
                    sceDisplay.this.re = RenderingEngineFactory.createInitialRenderingEngine();
                    sceDisplay.this.reDisplay = sceDisplay.this.re;
                }
            }
            if (sceDisplay.this.startModules) {
                sceDisplay.this.saveGEToTexture = Settings.getInstance().readBool("emu.enablegetexture");
                if (sceDisplay.this.saveGEToTexture) {
                    GETextureManager.getInstance().reset(sceDisplay.this.reDisplay);
                }
                videoEngine.start();
                sceDisplay.this.drawBuffer = sceDisplay.this.reDisplay.getBufferManager().genBuffer(0, 6, 16, 6);
                sceDisplay.access$1202(sceDisplay.this, new float[16]);
                sceDisplay.this.startModules = false;
                if (sceDisplay.this.saveGEToTexture && !sceDisplay.this.re.isFramebufferObjectAvailable()) {
                    sceDisplay.this.saveGEToTexture = false;
                    log.warn((Object)"Saving GE to Textures has been automatically disabled: FBO is not supported by this OpenGL version");
                }
                sceDisplay.this.isStarted = true;
            }
            if (!sceDisplay.this.isStarted) {
                sceDisplay.this.reDisplay.clear(0.0f, 0.0f, 0.0f, 0.0f);
                return;
            }
            if (sceDisplay.this.createTex) {
                sceDisplay.this.texFb = sceDisplay.this.createTexture(sceDisplay.this.texFb, false);
                sceDisplay.this.resizedTexFb = sceDisplay.this.createTexture(sceDisplay.this.resizedTexFb, true);
                sceDisplay.this.checkTemp();
                sceDisplay.this.createTex = false;
            }
            if (sceDisplay.this.resetGeTextures) {
                if (sceDisplay.this.saveGEToTexture) {
                    GETextureManager.getInstance().reset(sceDisplay.this.reDisplay);
                }
                sceDisplay.this.resetGeTextures = false;
            }
            sceDisplay.this.skipNextFrameBufferSwitch = videoEngine.isSkipThisFrame();
            boolean doSwapBuffers = true;
            FrameBufferSettings currentFb = sceDisplay.this.fb;
            sceDisplay.this.setInsideRendering(true);
            if (sceDisplay.this.isUsingSoftwareRenderer()) {
                if (sceDisplay.this.softwareRenderingDisplayThread == null) {
                    sceDisplay.this.re.startDisplay();
                    videoEngine.update();
                    sceDisplay.this.re.endDisplay();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceDisplay.paintGL - software - rendering the FB 0x%08X", currentFb.getTopAddr()));
                }
                sceDisplay.this.reDisplay.startDisplay();
                sceDisplay.this.drawFrameBufferFromMemory(currentFb);
                sceDisplay.this.reDisplay.endDisplay();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sceDisplay.paintGL - software - end display");
                }
            } else if (sceDisplay.this.isOnlyGEGraphics()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sceDisplay.paintGL - start display - only GE");
                }
                sceDisplay.this.re.startDisplay();
                doSwapBuffers = videoEngine.update();
                sceDisplay.this.re.endDisplay();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sceDisplay.paintGL - end display - only GE");
                }
            } else {
                GETexture geTexture;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sceDisplay.paintGL - start display");
                }
                sceDisplay.this.re.startDisplay();
                if (videoEngine.update()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("sceDisplay.paintGL - saving the GE to memory 0x%08X", sceDisplay.this.ge.getTopAddr()));
                    }
                    if (sceDisplay.this.saveGEToTexture && !videoEngine.isVideoTexture(sceDisplay.this.ge.getTopAddr())) {
                        geTexture = GETextureManager.getInstance().getGETexture(sceDisplay.this.reDisplay, sceDisplay.this.ge.getTopAddr(), sceDisplay.this.ge.getBufferWidth(), sceDisplay.this.ge.getWidth(), sceDisplay.this.ge.getHeight(), sceDisplay.this.ge.getPixelFormat(), true);
                        geTexture.copyScreenToTexture(sceDisplay.this.re);
                    } else {
                        sceDisplay.this.reDisplay.bindTexture(sceDisplay.this.resizedTexFb);
                        sceDisplay.this.reDisplay.setTextureFormat(sceDisplay.this.ge.getPixelFormat(), false);
                        sceDisplay.this.reDisplay.copyTexSubImage(0, 0, 0, 0, 0, sceDisplay.getResizedWidth(sceDisplay.this.ge.getWidth()), sceDisplay.getResizedHeight(sceDisplay.this.ge.getHeight()));
                        sceDisplay.this.drawFrameBuffer(currentFb, true, true, currentFb.getBufferWidth(), currentFb.getPixelFormat(), currentFb.getWidth(), currentFb.getHeight());
                        sceDisplay.this.copyScreenToPixels(sceDisplay.this.ge.getPixels(), sceDisplay.this.ge.getBufferWidth(), sceDisplay.this.ge.getPixelFormat(), sceDisplay.this.ge.getWidth(), sceDisplay.this.ge.getHeight());
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceDisplay.paintGL - rendering the FB 0x%08X", currentFb.getTopAddr()));
                }
                if (sceDisplay.this.saveGEToTexture && !videoEngine.isVideoTexture(sceDisplay.this.fb.getTopAddr())) {
                    geTexture = GETextureManager.getInstance().getGETexture(sceDisplay.this.reDisplay, currentFb.getTopAddr(), currentFb.getBufferWidth(), currentFb.getWidth(), currentFb.getHeight(), currentFb.getPixelFormat(), true);
                    geTexture.copyTextureToScreen(sceDisplay.this.reDisplay);
                } else {
                    sceDisplay.this.drawFrameBufferFromMemory(currentFb);
                }
                sceDisplay.this.re.endDisplay();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sceDisplay.paintGL - end display");
                }
            }
            sceDisplay.this.setInsideRendering(false);
            if (doSwapBuffers) {
                sceDisplay.this.paintFrameCount++;
                try {
                    sceDisplay.this.canvas.swapBuffers();
                }
                catch (LWJGLException e) {
                    // empty catch block
                }
            }
            sceDisplay.this.reportFPSStats();
            if (sceDisplay.this.statistics != null) {
                sceDisplay.this.statistics.end();
            }
            if (sceDisplay.this.wantScreenshot) {
                sceDisplay.this.saveScreen();
            }
        }

        @Override
        protected void initGL() {
            this.setSwapInterval(0);
            super.initGL();
            sceDisplay.this.initGLcalled = true;
            sceDisplay.this.openGLversion = RenderingEngineLwjgl.getVersion();
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("setBounds width=%d, height=%d", width, height));
            }
            sceDisplay.this.canvasWidth = width;
            sceDisplay.this.canvasHeight = height;
            super.setBounds(x, y, width, height);
        }

        @Override
        public void componentResized(ComponentEvent e) {
            sceDisplay.this.setViewportResizeScaleFactor(this.getWidth(), this.getHeight());
        }
    }
}

