/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.types.SceFontInfo;
import jpcsp.HLE.kernel.types.pspCharInfo;
import jpcsp.format.BWFont;
import jpcsp.util.Debug;

public class SceFontInfoBW
extends SceFontInfo {
    private short[][] charBitmapData;
    private int[] charmapCompressed;
    private static final int[] pixelColors = new int[]{0, -1};

    public SceFontInfoBW(BWFont fontFile) {
        byte[] fontData = fontFile.getFontData();
        this.charmapCompressed = fontFile.getCharmapCompressed();
        int numberCharBitmaps = fontData.length / 36;
        this.charBitmapData = new short[numberCharBitmaps][18];
        this.shadowScaleX = 24;
        this.shadowScaleY = 24;
        int fontDataIndex = 0;
        for (int i = 0; i < numberCharBitmaps; ++i) {
            int j = 0;
            while (j < 18) {
                int bitmapRow = Integer.reverse((fontData[fontDataIndex] & 0xFF) << 8 | fontData[fontDataIndex + 1] & 0xFF) >>> 16;
                this.charBitmapData[i][j] = (short)bitmapRow;
                ++j;
                fontDataIndex += 2;
            }
        }
    }

    @Override
    public void printFont(int base, int bpl, int bufWidth, int bufHeight, int x, int y, int clipX, int clipY, int clipWidth, int clipHeight, int pixelformat, int charCode, int altCharCode, int glyphType) {
        if (glyphType != 0) {
            return;
        }
        int charIndex = this.getCharIndex(charCode, this.charmapCompressed);
        if (charIndex < 0 || charIndex >= this.charBitmapData.length) {
            return;
        }
        short[] bitmapData = this.charBitmapData[charIndex];
        for (int yy = 0; yy < 18; ++yy) {
            int bitmapRow = bitmapData[yy] & 0xFFFF;
            int xx = 0;
            while (xx < 16) {
                int pixelX = x + xx;
                int pixelY = y + yy;
                if (pixelX >= clipX && pixelX < clipX + clipWidth && pixelY >= clipY && pixelY < clipY + clipHeight) {
                    int pixelColor = pixelColors[bitmapRow & 1];
                    Debug.setFontPixel(base, bpl, bufWidth, bufHeight, pixelX, pixelY, pixelColor, pixelformat);
                }
                ++xx;
                bitmapRow >>= 1;
            }
        }
    }

    @Override
    public pspCharInfo getCharInfo(int charCode, int glyphType) {
        pspCharInfo charInfo = new pspCharInfo();
        if (glyphType != 0) {
            return charInfo;
        }
        charInfo.bitmapWidth = 16;
        charInfo.bitmapHeight = 19;
        charInfo.bitmapTop = 16;
        charInfo.sfp26Width = 1024;
        charInfo.sfp26Height = 1216;
        charInfo.sfp26Ascender = 1152;
        charInfo.sfp26BearingHY = 1152;
        charInfo.sfp26BearingVX = -480;
        charInfo.sfp26AdvanceH = 1088;
        charInfo.sfp26AdvanceV = 1280;
        return charInfo;
    }
}

