/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.GUI;

import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import jpcsp.Emulator;
import jpcsp.filesystems.umdiso.UmdIsoFile;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.media.MediaEngine;
import jpcsp.settings.Settings;

public class UmdBrowserPmf {
    private UmdIsoReader iso;
    private UmdIsoFile isoFile;
    private String fileName;
    private IContainer container;
    private IVideoResampler resampler;
    private int videoStreamId;
    private IStreamCoder videoCoder;
    private int audioStreamId;
    private IStreamCoder audioCoder;
    private IPacket packet;
    private long firstTimestampInStream;
    private long systemClockStartTime;
    private IConverter converter;
    private BufferedImage image;
    private boolean done;
    private boolean endOfVideo;
    private boolean threadExit;
    private JLabel display;
    private PmfDisplayThread displayThread;
    private PmfByteChannel byteChannel;
    private SourceDataLine mLine;

    public UmdBrowserPmf(UmdIsoReader iso, String fileName, JLabel display) {
        this.iso = iso;
        this.fileName = fileName;
        this.display = display;
        this.init();
        this.initVideo();
    }

    private void init() {
        this.image = null;
        this.done = false;
        this.threadExit = false;
        MediaEngine.initXuggler();
        this.isoFile = null;
        try {
            this.isoFile = this.iso.getFile(this.fileName);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Emulator.log.error((Object)e);
        }
    }

    private Image getImage() {
        return this.image;
    }

    public final boolean initVideo() {
        if (this.isoFile == null) {
            return false;
        }
        if (!this.startVideo()) {
            return false;
        }
        this.displayThread = new PmfDisplayThread();
        this.displayThread.setDaemon(true);
        this.displayThread.setName("UMD Browser - PMF Display Thread");
        this.displayThread.start();
        return true;
    }

    private boolean startVideo() {
        this.endOfVideo = false;
        try {
            this.container = IContainer.make();
        }
        catch (Throwable e) {
            Emulator.log.error((Object)e);
            return false;
        }
        try {
            this.isoFile.seek(0L);
        }
        catch (IOException e) {
            Emulator.log.error((Object)e);
            return false;
        }
        this.byteChannel = new PmfByteChannel(this.isoFile);
        if (this.container.open((ReadableByteChannel)this.byteChannel, null) < 0) {
            Emulator.log.error((Object)("could not open file: " + this.fileName));
            return false;
        }
        int numStreams = this.container.getNumStreams();
        this.videoStreamId = -1;
        this.videoCoder = null;
        this.audioStreamId = -1;
        this.audioCoder = null;
        boolean audioMuted = Settings.getInstance().readBool("emu.mutesound");
        for (int i = 0; i < numStreams; ++i) {
            IStream stream = this.container.getStream((long)i);
            IStreamCoder coder = stream.getStreamCoder();
            if (coder.getCodecType() == ICodec.Type.CODEC_TYPE_VIDEO) {
                this.videoStreamId = i;
                this.videoCoder = coder;
                continue;
            }
            if (coder.getCodecType() != ICodec.Type.CODEC_TYPE_AUDIO || audioMuted) continue;
            this.audioStreamId = i;
            this.audioCoder = coder;
        }
        if (this.videoCoder != null && MediaEngine.streamCoderOpen(this.videoCoder) < 0) {
            Emulator.log.error((Object)("could not open video decoder for container: " + this.fileName));
            return false;
        }
        if (this.audioCoder != null && MediaEngine.streamCoderOpen(this.audioCoder) < 0) {
            Emulator.log.info((Object)("AT3+ audio format is not yet supported by Jpcsp (file=" + this.fileName + ")"));
            return false;
        }
        this.resampler = null;
        if (this.videoCoder != null) {
            this.converter = ConverterFactory.createConverter((String)"XUGGLER-BGR-24", (IPixelFormat.Type)IPixelFormat.Type.BGR24, (int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight());
            if (this.videoCoder.getPixelType() != IPixelFormat.Type.BGR24 || this.videoCoder.getWidth() != 144 || this.videoCoder.getHeight() != 80) {
                this.resampler = IVideoResampler.make((int)144, (int)80, (IPixelFormat.Type)IPixelFormat.Type.BGR24, (int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight(), (IPixelFormat.Type)this.videoCoder.getPixelType());
                if (this.resampler == null) {
                    Emulator.log.error((Object)("could not create color space resampler for: " + this.fileName));
                    return false;
                }
            }
        }
        if (this.audioCoder != null) {
            this.openAudio(this.audioCoder);
        }
        this.packet = IPacket.make();
        this.firstTimestampInStream = Global.NO_PTS;
        this.systemClockStartTime = 0L;
        return true;
    }

    private void closeVideo() {
        if (this.container != null) {
            this.container.close();
            this.container = null;
        }
        if (this.videoCoder != null) {
            this.videoCoder.close();
            this.videoCoder = null;
        }
        if (this.resampler != null) {
            this.resampler.delete();
            this.resampler = null;
        }
        if (this.converter != null) {
            this.converter.delete();
            this.converter = null;
        }
        if (this.packet != null) {
            this.packet.delete();
            this.packet = null;
        }
    }

    private void loopVideo() {
        this.closeVideo();
        this.closeAudio();
        this.startVideo();
    }

    private void stopDisplayThread() {
        while (this.displayThread != null && !this.threadExit) {
            this.done = true;
            this.sleep(1L);
        }
        this.displayThread = null;
    }

    public void stopVideo() {
        this.stopDisplayThread();
        this.closeVideo();
        this.closeAudio();
        if (this.isoFile != null) {
            try {
                this.isoFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void stepVideo() {
        if (this.container.readNextPacket(this.packet) >= 0) {
            if (this.packet.getStreamIndex() == this.videoStreamId && this.videoCoder != null) {
                IVideoPicture picture = IVideoPicture.make((IPixelFormat.Type)this.videoCoder.getPixelType(), (int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight());
                int offset = 0;
                while (offset < this.packet.getSize()) {
                    int bytesDecoded = this.videoCoder.decodeVideo(picture, this.packet, offset);
                    if (bytesDecoded < 0) {
                        throw new RuntimeException("got error decoding video in: " + this.fileName);
                    }
                    offset += bytesDecoded;
                    if (!picture.isComplete()) continue;
                    IVideoPicture newPic = picture;
                    if (this.resampler != null && this.resampler.resample(newPic = IVideoPicture.make((IPixelFormat.Type)this.resampler.getOutputPixelFormat(), (int)this.resampler.getOutputWidth(), (int)this.resampler.getOutputHeight()), picture) < 0) {
                        throw new RuntimeException("could not resample video from: " + this.fileName);
                    }
                    if (newPic.getPixelType() != IPixelFormat.Type.BGR24) {
                        throw new RuntimeException("could not decode video BGR 24 bit data in: " + this.fileName);
                    }
                    if (this.firstTimestampInStream == Global.NO_PTS) {
                        this.firstTimestampInStream = picture.getTimeStamp();
                        this.systemClockStartTime = System.currentTimeMillis();
                    } else {
                        long systemClockCurrentTime = System.currentTimeMillis();
                        long millisecondsClockTimeSinceStartofVideo = systemClockCurrentTime - this.systemClockStartTime;
                        long millisecondsStreamTimeSinceStartOfVideo = (picture.getTimeStamp() - this.firstTimestampInStream) / 1000L;
                        long millisecondsTolerance = 50L;
                        long millisecondsToSleep = millisecondsStreamTimeSinceStartOfVideo - (millisecondsClockTimeSinceStartofVideo + 50L);
                        this.sleep(millisecondsToSleep);
                    }
                    this.image = this.converter.toImage(newPic);
                }
            } else if (this.packet.getStreamIndex() == this.audioStreamId && this.audioCoder != null) {
                int bytesDecoded;
                IAudioSamples samples = IAudioSamples.make((long)1024L, (long)this.audioCoder.getChannels());
                for (int offset = 0; offset < this.packet.getSize(); offset += bytesDecoded) {
                    bytesDecoded = this.audioCoder.decodeAudio(samples, this.packet, offset);
                    if (bytesDecoded >= 0) continue;
                    throw new RuntimeException("got error decoding audio in: " + this.fileName);
                }
            }
        } else {
            this.endOfVideo = true;
        }
    }

    private void openAudio(IStreamCoder aAudioCoder) {
        AudioFormat audioFormat = new AudioFormat(aAudioCoder.getSampleRate(), (int)IAudioSamples.findSampleBitDepth((IAudioSamples.Format)aAudioCoder.getSampleFormat()), aAudioCoder.getChannels(), true, false);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            this.mLine = (SourceDataLine)AudioSystem.getLine(info);
            this.mLine.open(audioFormat);
            this.mLine.start();
        }
        catch (LineUnavailableException e) {
            throw new RuntimeException("could not open audio line");
        }
    }

    private void playAudio(IAudioSamples aSamples) {
        byte[] rawBytes = aSamples.getData().getByteArray(0, aSamples.getSize());
        this.mLine.write(rawBytes, 0, aSamples.getSize());
    }

    private void closeAudio() {
        if (this.mLine != null) {
            this.mLine.drain();
            this.mLine.close();
            this.mLine = null;
        }
    }

    private void sleep(long millis) {
        if (millis > 0L) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class PmfByteChannel
    implements ReadableByteChannel {
        private UmdIsoFile file;
        private byte[] buffer;

        public PmfByteChannel(UmdIsoFile file) {
            this.file = file;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            int length;
            int available = dst.remaining();
            if (this.buffer == null || this.buffer.length < available) {
                this.buffer = new byte[available];
            }
            if ((length = this.file.read(this.buffer, 0, available)) > 0) {
                dst.put(this.buffer, 0, length);
            }
            return length;
        }

        @Override
        public void close() throws IOException {
            this.file.close();
            this.file = null;
        }

        @Override
        public boolean isOpen() {
            return this.file != null;
        }
    }

    private class PmfDisplayThread
    extends Thread {
        private PmfDisplayThread() {
        }

        @Override
        public void run() {
            while (!UmdBrowserPmf.this.done) {
                while (!UmdBrowserPmf.this.endOfVideo && !UmdBrowserPmf.this.done) {
                    UmdBrowserPmf.this.stepVideo();
                    if (UmdBrowserPmf.this.display == null || UmdBrowserPmf.this.getImage() == null) continue;
                    UmdBrowserPmf.this.display.setIcon(new ImageIcon(UmdBrowserPmf.this.getImage()));
                }
                if (UmdBrowserPmf.this.done) continue;
                UmdBrowserPmf.this.loopVideo();
            }
            UmdBrowserPmf.this.threadExit = true;
        }
    }
}

