/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Debugger.DisassemblerModule;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jpcsp.GUI.CancelButton;
import jpcsp.util.Constants;
import jpcsp.util.JpcspDialogManager;

public class DumpCodeDialog
extends JDialog {
    public static final int DUMPCODE_APPROVE = 1;
    int retVal = 0;
    private CancelButton btnCancel;
    private JButton btnFilename;
    private JButton btnOk;
    private JLabel lblEndAddress;
    private JLabel lblFilename;
    private JLabel lblStartAddress;
    private JTextField txtEndAddress;
    private JTextField txtFilename;
    private JTextField txtStartAddress;

    public DumpCodeDialog(Frame parent, int start) {
        super(parent, true);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.txtStartAddress.setText(String.format("0x%08X", start));
        this.txtEndAddress.setText(String.format("0x%08X", start));
    }

    public int getStartAddress() {
        return Integer.decode(this.txtStartAddress.getText());
    }

    public int getEndAddress() {
        return Integer.decode(this.txtEndAddress.getText());
    }

    public String getFilename() {
        return this.txtFilename.getText();
    }

    public int getReturnValue() {
        return this.retVal;
    }

    private void initComponents() {
        this.lblStartAddress = new JLabel();
        this.txtStartAddress = new JTextField();
        this.lblEndAddress = new JLabel();
        this.lblFilename = new JLabel();
        this.txtEndAddress = new JTextField();
        this.txtFilename = new JTextField();
        this.btnFilename = new JButton();
        this.btnOk = new JButton();
        this.btnCancel = new CancelButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
        this.setTitle(bundle.getString("DumpCodeDialog.title"));
        this.setResizable(false);
        this.lblStartAddress.setText(bundle.getString("DumpCodeDialog.lblStartAddress.text"));
        this.txtStartAddress.setFont(new Font("Courier New", 0, 12));
        this.txtStartAddress.setHorizontalAlignment(0);
        this.txtStartAddress.setText("0x00000000");
        this.txtStartAddress.setInputVerifier(new AddressInputVerifier());
        this.lblEndAddress.setText(bundle.getString("DumpCodeDialog.lblEndAddress.text"));
        this.lblFilename.setText(bundle.getString("DumpCodeDialog.lblFilename.text"));
        this.txtEndAddress.setFont(new Font("Courier New", 0, 12));
        this.txtEndAddress.setHorizontalAlignment(0);
        this.txtEndAddress.setText("0x00000000");
        this.txtEndAddress.setInputVerifier(new AddressInputVerifier());
        this.txtFilename.setEditable(false);
        this.txtFilename.setText("dump.txt");
        this.btnFilename.setText("...");
        this.btnFilename.setPreferredSize(new Dimension(25, 25));
        this.btnFilename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DumpCodeDialog.this.btnFilenameActionPerformed(evt);
            }
        });
        this.btnOk.setText(bundle.getString("OkButton.text"));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DumpCodeDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancel.setText(bundle.getString("CancelButton.text"));
        this.btnCancel.setParent(this);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblStartAddress).addComponent(this.lblEndAddress).addComponent(this.lblFilename)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtStartAddress).addComponent(this.txtEndAddress).addGroup(layout.createSequentialGroup().addComponent(this.txtFilename, -2, 225, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnFilename, -2, -1, -2)))).addGroup(layout.createSequentialGroup().addComponent(this.btnOk, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblStartAddress).addComponent(this.txtStartAddress, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblEndAddress).addComponent(this.txtEndAddress, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtFilename, -2, -1, -2).addComponent(this.btnFilename, -2, -1, -2).addComponent(this.lblFilename)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOk).addComponent(this.btnCancel, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void btnFilenameActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString("DumpCodeDialog.dlgOutputFile.title"));
        fc.setSelectedFile(new File(this.txtFilename.getText()));
        fc.addChoosableFileFilter(Constants.fltTextFiles);
        fc.setFileFilter(Constants.fltTextFiles);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        this.txtFilename.setText(fc.getSelectedFile().getAbsolutePath());
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        if (this.getStartAddress() > this.getEndAddress()) {
            JpcspDialogManager.showError(this, ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString("DumpCodeDialog.strErrAddressRange.title"));
            return;
        }
        this.retVal = 1;
        this.setVisible(false);
    }

    private class AddressInputVerifier
    extends InputVerifier {
        private AddressInputVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            try {
                JTextField tf = (JTextField)input;
                int value = Integer.decode(tf.getText());
                if (value % 4 != 0) {
                    value /= 4;
                }
                tf.setText(String.format("0x%08X", value));
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
    }
}

