/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.compiler.CodeInstruction;
import jpcsp.Allegrex.compiler.CodeSequence;
import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Allegrex.compiler.CompilerContext;
import jpcsp.Allegrex.compiler.IExecutable;
import jpcsp.Allegrex.compiler.MemoryRanges;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Allegrex.compiler.SequenceCodeInstruction;
import jpcsp.Allegrex.compiler.nativeCode.HookCodeInstruction;
import jpcsp.Allegrex.compiler.nativeCode.NativeCodeInstruction;
import jpcsp.Allegrex.compiler.nativeCode.NativeCodeManager;
import jpcsp.Allegrex.compiler.nativeCode.NativeCodeSequence;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;

public class CodeBlock {
    private int startAddress;
    private int lowestAddress;
    private int highestAddress;
    private LinkedList<CodeInstruction> codeInstructions = new LinkedList();
    private LinkedList<SequenceCodeInstruction> sequenceCodeInstructions = new LinkedList();
    private SequenceCodeInstruction currentSequence = null;
    private IExecutable executable = null;
    private static final String objectInternalName = Type.getInternalName(Object.class);
    private static final String[] interfacesForExecutable = new String[]{Type.getInternalName(IExecutable.class)};
    private static final String[] exceptions = new String[]{Type.getInternalName(Exception.class)};
    private int instanceIndex;
    private Common.Instruction[] interpretedInstructions;
    private int[] interpretedOpcodes;
    private MemoryRanges memoryRanges = new MemoryRanges();
    private int flags;

    public CodeBlock(int startAddress, int instanceCount) {
        this.startAddress = startAddress;
        this.instanceIndex = instanceCount;
        this.lowestAddress = startAddress;
        this.highestAddress = startAddress;
        RuntimeContext.addCodeBlock(startAddress, this);
    }

    public void addInstruction(int address, int opcode, Common.Instruction insn, boolean isBranchTarget, boolean isBranching, int branchingTo) {
        if (Compiler.log.isTraceEnabled()) {
            Compiler.log.trace((Object)String.format("CodeBlock.addInstruction 0x%X - %s", address, insn.disasm(address, opcode)));
        }
        CodeInstruction codeInstruction = new CodeInstruction(address, opcode, insn, isBranchTarget, isBranching, branchingTo);
        if (this.codeInstructions.isEmpty() || this.codeInstructions.getLast().getAddress() < address) {
            this.codeInstructions.add(codeInstruction);
        } else {
            ListIterator<CodeInstruction> lit = this.codeInstructions.listIterator();
            while (lit.hasNext()) {
                CodeInstruction listItem = (CodeInstruction)lit.next();
                if (listItem.getAddress() <= address) continue;
                lit.previous();
                lit.add(codeInstruction);
                break;
            }
            if (address < this.lowestAddress) {
                this.lowestAddress = address;
            }
        }
        if (address > this.highestAddress) {
            this.highestAddress = address;
        }
        this.memoryRanges.addAddress(address);
        this.flags |= insn.getFlags();
    }

    public void setIsBranchTarget(int address) {
        CodeInstruction codeInstruction;
        if (Compiler.log.isTraceEnabled()) {
            Compiler.log.trace((Object)("CodeBlock.setIsBranchTarget 0x" + Integer.toHexString(address).toUpperCase()));
        }
        if ((codeInstruction = this.getCodeInstruction(address)) != null) {
            codeInstruction.setBranchTarget(true);
        }
    }

    public int getStartAddress() {
        return this.startAddress;
    }

    public int getLowestAddress() {
        return this.lowestAddress;
    }

    public int getHighestAddress() {
        return this.highestAddress;
    }

    public int getLength() {
        return (this.getHighestAddress() - this.getLowestAddress()) / 4 + 1;
    }

    public CodeInstruction getCodeInstruction(int address) {
        if (this.currentSequence != null) {
            return this.currentSequence.getCodeSequence().getCodeInstruction(address);
        }
        for (CodeInstruction codeInstruction : this.codeInstructions) {
            if (codeInstruction.getAddress() != address) continue;
            return codeInstruction;
        }
        return null;
    }

    public String getClassName() {
        return CompilerContext.getClassName(this.getStartAddress(), this.getInstanceIndex());
    }

    public String getInternalClassName() {
        return this.getInternalName(this.getClassName());
    }

    private String getInternalName(String name) {
        return name.replace('.', '/');
    }

    private Class<IExecutable> loadExecutable(CompilerContext context, String className, byte[] bytes) throws ClassFormatError {
        try {
            return context.getClassLoader().defineClass(className, bytes);
        }
        catch (ClassFormatError e) {
            throw e;
        }
        catch (LinkageError le) {
            try {
                return context.getClassLoader().findClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
        }
    }

    private void addConstructor(ClassVisitor cv) {
        MethodVisitor mv = cv.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, objectInternalName, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void addNonStaticMethods(CompilerContext context, ClassVisitor cv) {
        MethodVisitor mv = cv.visitMethod(1, context.getExecMethodName(), context.getExecMethodDesc(), null, exceptions);
        mv.visitCode();
        mv.visitMethodInsn(184, this.getClassName(), context.getStaticExecMethodName(), context.getStaticExecMethodDesc());
        mv.visitInsn(172);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        FieldVisitor fv = cv.visitField(10, context.getReplaceFieldName(), CompilerContext.executableDescriptor, null, null);
        fv.visitEnd();
        mv = cv.visitMethod(1, context.getReplaceMethodName(), context.getReplaceMethodDesc(), null, exceptions);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(179, this.getClassName(), context.getReplaceFieldName(), CompilerContext.executableDescriptor);
        mv.visitInsn(177);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        mv = cv.visitMethod(1, context.getGetMethodName(), context.getGetMethodDesc(), null, exceptions);
        mv.visitCode();
        mv.visitFieldInsn(178, this.getClassName(), context.getReplaceFieldName(), CompilerContext.executableDescriptor);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void addCodeSequence(List<CodeSequence> codeSequences, CodeSequence codeSequence) {
        if (codeSequence != null && codeSequence.getLength() > 1) {
            codeSequences.add(codeSequence);
        }
    }

    private void generateCodeSequences(List<CodeSequence> codeSequences, int sequenceMaxInstructions) {
        CodeSequence currentCodeSequence = null;
        int nextAddress = 0;
        int sequenceMaxInstructionsWithDelay = sequenceMaxInstructions - 1;
        for (CodeInstruction codeInstruction : this.codeInstructions) {
            int address = codeInstruction.getAddress();
            if (address < nextAddress) continue;
            if (codeInstruction.hasFlags(2)) {
                this.addCodeSequence(codeSequences, currentCodeSequence);
                currentCodeSequence = null;
                if (!codeInstruction.hasFlags(4)) continue;
                nextAddress = address + 8;
                continue;
            }
            if (codeInstruction.isBranchTarget()) {
                this.addCodeSequence(codeSequences, currentCodeSequence);
                currentCodeSequence = new CodeSequence(address);
                continue;
            }
            if (currentCodeSequence == null) {
                currentCodeSequence = new CodeSequence(address);
            } else if (currentCodeSequence.getLength() + codeInstruction.getLength() > sequenceMaxInstructionsWithDelay) {
                boolean doSplit = false;
                if (currentCodeSequence.getLength() + codeInstruction.getLength() > sequenceMaxInstructions) {
                    doSplit = true;
                } else if (codeInstruction.hasFlags(4)) {
                    doSplit = true;
                }
                if (doSplit) {
                    this.addCodeSequence(codeSequences, currentCodeSequence);
                    currentCodeSequence = new CodeSequence(address);
                }
            }
            currentCodeSequence.setEndAddress(codeInstruction.getEndAddress());
        }
        this.addCodeSequence(codeSequences, currentCodeSequence);
    }

    private CodeSequence findCodeSequence(CodeInstruction codeInstruction, List<CodeSequence> codeSequences, CodeSequence currentCodeSequence) {
        int address = codeInstruction.getAddress();
        if (currentCodeSequence != null && currentCodeSequence.isInside(address)) {
            return currentCodeSequence;
        }
        for (CodeSequence codeSequence : codeSequences) {
            if (!codeSequence.isInside(address)) continue;
            return codeSequence;
        }
        return null;
    }

    private void splitCodeSequences(CompilerContext context, int methodMaxInstructions) {
        ArrayList<CodeSequence> codeSequences = new ArrayList<CodeSequence>();
        this.generateCodeSequences(codeSequences, methodMaxInstructions);
        Collections.sort(codeSequences);
        int currentMethodInstructions = this.codeInstructions.size();
        ArrayList<CodeSequence> sequencesToBeSplit = new ArrayList<CodeSequence>();
        for (CodeSequence codeSequence : codeSequences) {
            sequencesToBeSplit.add(codeSequence);
            if (Compiler.log.isDebugEnabled()) {
                Compiler.log.debug((Object)("Sequence to be split: " + codeSequence.toString()));
            }
            if ((currentMethodInstructions -= codeSequence.getLength()) > methodMaxInstructions) continue;
            break;
        }
        CodeSequence currentCodeSequence = null;
        ListIterator<SequenceCodeInstruction> lit = this.codeInstructions.listIterator();
        while (lit.hasNext()) {
            CodeInstruction codeInstruction = (CodeInstruction)lit.next();
            CodeSequence codeSequence = this.findCodeSequence(codeInstruction, sequencesToBeSplit, currentCodeSequence);
            if (codeSequence == null) continue;
            lit.remove();
            if (codeSequence.getInstructions().isEmpty()) {
                codeSequence.addInstruction(codeInstruction);
                SequenceCodeInstruction sequenceCodeInstruction = new SequenceCodeInstruction(codeSequence);
                lit.add(sequenceCodeInstruction);
                this.sequenceCodeInstructions.add(sequenceCodeInstruction);
            } else {
                codeSequence.addInstruction(codeInstruction);
            }
            currentCodeSequence = codeSequence;
        }
    }

    private void scanNativeCodeSequences(CompilerContext context) {
        NativeCodeManager nativeCodeManager = context.getNativeCodeManager();
        ListIterator<CodeInstruction> lit = this.codeInstructions.listIterator();
        while (lit.hasNext()) {
            CodeInstruction codeInstruction = (CodeInstruction)lit.next();
            NativeCodeSequence nativeCodeSequence = nativeCodeManager.getNativeCodeSequence(codeInstruction, this);
            if (nativeCodeSequence == null) continue;
            if (nativeCodeSequence.isHook()) {
                HookCodeInstruction hookCodeInstruction = new HookCodeInstruction(nativeCodeSequence, codeInstruction);
                lit.remove();
                lit.add(hookCodeInstruction);
                continue;
            }
            NativeCodeInstruction nativeCodeInstruction = new NativeCodeInstruction(codeInstruction.getAddress(), nativeCodeSequence);
            if (nativeCodeInstruction.isBranching()) {
                this.setIsBranchTarget(nativeCodeInstruction.getBranchingTo());
            }
            if (nativeCodeSequence.isWholeCodeBlock()) {
                this.codeInstructions.clear();
                this.codeInstructions.add(nativeCodeInstruction);
                continue;
            }
            lit.remove();
            List<CodeInstruction> beforeCodeInstructions = nativeCodeSequence.getBeforeCodeInstructions();
            if (beforeCodeInstructions != null) {
                for (CodeInstruction beforeCodeInstruction : beforeCodeInstructions) {
                    CodeInstruction newCodeInstruction = new CodeInstruction(beforeCodeInstruction);
                    newCodeInstruction.setAddress(codeInstruction.getAddress());
                    lit.add(newCodeInstruction);
                }
            }
            lit.add(nativeCodeInstruction);
            for (int i = nativeCodeSequence.getNumOpcodes() - 1; i > 0 && lit.hasNext(); --i) {
                lit.next();
                lit.remove();
            }
        }
    }

    private void prepare(CompilerContext context, int methodMaxInstructions) {
        this.memoryRanges.updateValues();
        this.scanNativeCodeSequences(context);
        if (this.codeInstructions.size() > methodMaxInstructions) {
            if (Compiler.log.isInfoEnabled()) {
                Compiler.log.info((Object)("Splitting " + this.getClassName() + " (" + this.codeInstructions.size() + "/" + methodMaxInstructions + ")"));
            }
            this.splitCodeSequences(context, methodMaxInstructions);
        }
    }

    private void compile(CompilerContext context, MethodVisitor mv, List<CodeInstruction> codeInstructions) {
        context.optimizeSequence(codeInstructions);
        int numberInstructionsToBeSkipped = 0;
        for (CodeInstruction codeInstruction : codeInstructions) {
            if (numberInstructionsToBeSkipped > 0) {
                if (!context.isSkipDelaySlot() && codeInstruction.isBranchTarget()) {
                    context.compileDelaySlotAsBranchTarget(codeInstruction);
                }
                if (--numberInstructionsToBeSkipped > 0) continue;
                context.skipInstructions(0, false);
                continue;
            }
            codeInstruction.compile(context, mv);
            numberInstructionsToBeSkipped = context.getNumberInstructionsToBeSkipped();
        }
    }

    private Class<IExecutable> interpret(CompilerContext context) {
        ClassWriter cw;
        Class<IExecutable> compiledClass = null;
        context.setCodeBlock(this);
        String className = this.getInternalClassName();
        if (Compiler.log.isInfoEnabled()) {
            Compiler.log.info((Object)("Compiling for Interpreter " + className));
        }
        int computeFlag = 2;
        if (context.isAutomaticMaxLocals() || context.isAutomaticMaxStack()) {
            computeFlag |= 1;
        }
        ClassWriter cv = cw = new ClassWriter(computeFlag);
        if (Compiler.log.isDebugEnabled()) {
            cv = new CheckClassAdapter((ClassVisitor)cv);
        }
        StringWriter debugOutput = null;
        if (Compiler.log.isDebugEnabled()) {
            debugOutput = new StringWriter();
            PrintWriter debugPrintWriter = new PrintWriter(debugOutput);
            cv = new TraceClassVisitor((ClassVisitor)cv, debugPrintWriter);
        }
        cv.visit(50, 33, className, null, objectInternalName, interfacesForExecutable);
        context.startClass((ClassVisitor)cv);
        this.addConstructor((ClassVisitor)cv);
        this.addNonStaticMethods(context, (ClassVisitor)cv);
        MethodVisitor mv = cv.visitMethod(9, context.getStaticExecMethodName(), context.getStaticExecMethodDesc(), null, exceptions);
        mv.visitCode();
        context.setMethodVisitor(mv);
        context.startMethod();
        context.compileExecuteInterpreter(this.getStartAddress());
        mv.visitMaxs(context.getMaxStack(), context.getMaxLocals());
        mv.visitEnd();
        cv.visitEnd();
        if (debugOutput != null) {
            Compiler.log.debug((Object)debugOutput.toString());
        }
        compiledClass = this.loadExecutable(context, className, cw.toByteArray());
        return compiledClass;
    }

    private Class<IExecutable> compile(CompilerContext context) throws ClassFormatError {
        ClassWriter cw;
        Class<IExecutable> compiledClass = null;
        context.setCodeBlock(this);
        String className = this.getInternalClassName();
        if (Compiler.log.isDebugEnabled()) {
            Compiler.log.debug((Object)("Compiling " + className));
        }
        this.prepare(context, context.getMethodMaxInstructions());
        this.currentSequence = null;
        int computeFlag = 2;
        if (context.isAutomaticMaxLocals() || context.isAutomaticMaxStack()) {
            computeFlag |= 1;
        }
        ClassWriter cv = cw = new ClassWriter(computeFlag);
        if (Compiler.log.isDebugEnabled()) {
            cv = new CheckClassAdapter((ClassVisitor)cv);
        }
        StringWriter debugOutput = null;
        if (Compiler.log.isTraceEnabled()) {
            debugOutput = new StringWriter();
            PrintWriter debugPrintWriter = new PrintWriter(debugOutput);
            cv = new TraceClassVisitor((ClassVisitor)cv, debugPrintWriter);
        }
        cv.visit(50, 33, className, null, objectInternalName, interfacesForExecutable);
        context.startClass((ClassVisitor)cv);
        this.addConstructor((ClassVisitor)cv);
        this.addNonStaticMethods(context, (ClassVisitor)cv);
        MethodVisitor mv = cv.visitMethod(9, context.getStaticExecMethodName(), context.getStaticExecMethodDesc(), null, exceptions);
        mv.visitCode();
        context.setMethodVisitor(mv);
        context.startMethod();
        if (!this.codeInstructions.isEmpty() && this.codeInstructions.getFirst().getAddress() != this.getStartAddress()) {
            mv.visitJumpInsn(167, this.getCodeInstruction(this.getStartAddress()).getLabel());
        }
        this.compile(context, mv, this.codeInstructions);
        mv.visitMaxs(context.getMaxStack(), context.getMaxLocals());
        mv.visitEnd();
        for (SequenceCodeInstruction sequenceCodeInstruction : this.sequenceCodeInstructions) {
            if (Compiler.log.isDebugEnabled()) {
                Compiler.log.debug((Object)("Compiling Sequence " + sequenceCodeInstruction.getMethodName(context)));
            }
            this.currentSequence = sequenceCodeInstruction;
            mv = cv.visitMethod(9, sequenceCodeInstruction.getMethodName(context), "()V", null, exceptions);
            mv.visitCode();
            context.setMethodVisitor(mv);
            context.startSequenceMethod();
            this.compile(context, mv, sequenceCodeInstruction.getCodeSequence().getInstructions());
            context.endSequenceMethod();
            mv.visitMaxs(context.getMaxStack(), context.getMaxLocals());
            mv.visitEnd();
        }
        this.currentSequence = null;
        cv.visitEnd();
        if (debugOutput != null) {
            Compiler.log.trace((Object)debugOutput.toString());
        }
        try {
            compiledClass = this.loadExecutable(context, className, cw.toByteArray());
        }
        catch (NullPointerException e) {
            Compiler.log.error((Object)("Error while compiling " + className + ": " + e));
        }
        return compiledClass;
    }

    public IExecutable getExecutable() {
        return this.executable;
    }

    public synchronized IExecutable getExecutable(CompilerContext context) throws ClassFormatError {
        Class<IExecutable> classExecutable;
        if (this.executable == null && (classExecutable = this.compile(context)) != null) {
            try {
                this.executable = classExecutable.newInstance();
            }
            catch (InstantiationException e) {
                Compiler.log.error((Object)e);
            }
            catch (IllegalAccessException e) {
                Compiler.log.error((Object)e);
            }
        }
        return this.executable;
    }

    public synchronized IExecutable getInterpretedExecutable(CompilerContext context) {
        Class<IExecutable> classExecutable;
        if (this.executable == null && (classExecutable = this.interpret(context)) != null) {
            try {
                this.executable = classExecutable.newInstance();
            }
            catch (InstantiationException e) {
                Compiler.log.error((Object)e);
            }
            catch (IllegalAccessException e) {
                Compiler.log.error((Object)e);
            }
        }
        return this.executable;
    }

    public int getInstanceIndex() {
        return this.instanceIndex;
    }

    public int getNewInstanceIndex() {
        ++this.instanceIndex;
        return this.instanceIndex;
    }

    public Common.Instruction[] getInterpretedInstructions() {
        return this.interpretedInstructions;
    }

    public void setInterpretedInstructions(Common.Instruction[] interpretedInstructions) {
        this.interpretedInstructions = interpretedInstructions;
    }

    public int[] getInterpretedOpcodes() {
        return this.interpretedOpcodes;
    }

    public void setInterpretedOpcodes(int[] interpretedOpcodes) {
        this.interpretedOpcodes = interpretedOpcodes;
    }

    public boolean areOpcodesChanged() {
        return this.memoryRanges.areValuesChanged();
    }

    public boolean isOverlappingWithAddressRange(int address, int size) {
        return this.memoryRanges.isOverlappingWithAddressRange(address, size);
    }

    public boolean isInternal() {
        int addr = this.getStartAddress();
        return addr < 0x8000080 && addr >= 0x8000000;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean hasFlags(int testFlags) {
        return (this.flags & testFlags) == testFlags;
    }

    public String toString() {
        return String.format("CodeBlock 0x%08X[0x%08X-0x%08X]", this.getStartAddress(), this.getLowestAddress(), this.getHighestAddress());
    }
}

