/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex;

import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.MduState;
import jpcsp.Emulator;
import jpcsp.Memory;

public class LsuState
extends MduState {
    public static final Memory memory = Memory.getInstance();
    protected static final boolean CHECK_ALIGNMENT = true;
    private static final int[] lwlMask = new int[]{0xFFFFFF, 65535, 255, 0};
    private static final int[] lwlShift = new int[]{24, 16, 8, 0};
    private static final int[] lwrMask = new int[]{0, -16777216, -65536, -256};
    private static final int[] lwrShift = new int[]{0, 8, 16, 24};
    private static final int[] swlMask = new int[]{-256, -65536, -16777216, 0};
    private static final int[] swlShift = new int[]{24, 16, 8, 0};
    private static final int[] swrMask = new int[]{0, 255, 65535, 0xFFFFFF};
    private static final int[] swrShift = new int[]{0, 8, 16, 24};

    @Override
    public void reset() {
    }

    @Override
    public void resetAll() {
        super.resetAll();
    }

    public LsuState() {
    }

    public void copy(LsuState that) {
        super.copy(that);
    }

    public LsuState(LsuState that) {
        super(that);
    }

    public void doLB(int rt, int rs, int simm16) {
        byte word = (byte)memory.read8(this.getRegister(rs) + simm16);
        if (rt != 0) {
            this.setRegister(rt, word);
        }
    }

    public void doLBU(int rt, int rs, int simm16) {
        int word = memory.read8(this.getRegister(rs) + simm16) & 0xFF;
        if (rt != 0) {
            this.setRegister(rt, word);
        }
    }

    public void doLH(int rt, int rs, int simm16) {
        CpuState cpu = Emulator.getProcessor().cpu;
        int address = this.getRegister(rs) + simm16;
        if ((address & 1) != 0) {
            Memory.log.error((Object)String.format("LH unaligned addr:0x%08x pc:0x%08x", address, cpu.pc));
        }
        short word = (short)memory.read16(this.getRegister(rs) + simm16);
        if (rt != 0) {
            this.setRegister(rt, word);
        }
    }

    public void doLHU(int rt, int rs, int simm16) {
        CpuState cpu = Emulator.getProcessor().cpu;
        int address = this.getRegister(rs) + simm16;
        if ((address & 1) != 0) {
            Memory.log.error((Object)String.format("LHU unaligned addr:0x%08x pc:0x%08x", address, cpu.pc));
        }
        int word = memory.read16(this.getRegister(rs) + simm16) & 0xFFFF;
        if (rt != 0) {
            this.setRegister(rt, word);
        }
    }

    public void doLWL(int rt, int rs, int simm16) {
        int address = this.getRegister(rs) + simm16;
        int offset = address & 3;
        int value = this.getRegister(rt);
        int data = memory.read32(address & 0xFFFFFFFC);
        if (rt != 0) {
            this.setRegister(rt, data << lwlShift[offset] | value & lwlMask[offset]);
        }
    }

    public void doLW(int rt, int rs, int simm16) {
        CpuState cpu = Emulator.getProcessor().cpu;
        int address = this.getRegister(rs) + simm16;
        if ((address & 3) != 0) {
            Memory.log.error((Object)String.format("LW unaligned addr:0x%08x pc:0x%08x", address, cpu.pc));
        }
        int word = memory.read32(this.getRegister(rs) + simm16);
        if (rt != 0) {
            this.setRegister(rt, word);
        }
    }

    public void doLWR(int rt, int rs, int simm16) {
        int address = this.getRegister(rs) + simm16;
        int offset = address & 3;
        int value = this.getRegister(rt);
        int data = memory.read32(address & 0xFFFFFFFC);
        if (rt != 0) {
            this.setRegister(rt, data >>> lwrShift[offset] | value & lwrMask[offset]);
        }
    }

    public void doSB(int rt, int rs, int simm16) {
        memory.write8(this.getRegister(rs) + simm16, (byte)(this.getRegister(rt) & 0xFF));
    }

    public void doSH(int rt, int rs, int simm16) {
        CpuState cpu = Emulator.getProcessor().cpu;
        int address = this.getRegister(rs) + simm16;
        if ((address & 1) != 0) {
            Memory.log.error((Object)String.format("SH unaligned addr:0x%08x pc:0x%08x", address, cpu.pc));
        }
        memory.write16(this.getRegister(rs) + simm16, (short)(this.getRegister(rt) & 0xFFFF));
    }

    public void doSWL(int rt, int rs, int simm16) {
        int address = this.getRegister(rs) + simm16;
        int offset = address & 3;
        int value = this.getRegister(rt);
        int data = memory.read32(address & 0xFFFFFFFC);
        data = value >>> swlShift[offset] | data & swlMask[offset];
        memory.write32(address & 0xFFFFFFFC, data);
    }

    public void doSW(int rt, int rs, int simm16) {
        CpuState cpu = Emulator.getProcessor().cpu;
        int address = this.getRegister(rs) + simm16;
        if ((address & 3) != 0) {
            Memory.log.error((Object)String.format("SW unaligned addr:0x%08x pc:0x%08x", address, cpu.pc));
        }
        memory.write32(this.getRegister(rs) + simm16, this.getRegister(rt));
    }

    public void doSWR(int rt, int rs, int simm16) {
        int address = this.getRegister(rs) + simm16;
        int offset = address & 3;
        int value = this.getRegister(rt);
        int data = memory.read32(address & 0xFFFFFFFC);
        data = value << swrShift[offset] | data & swrMask[offset];
        memory.write32(address & 0xFFFFFFFC, data);
    }

    public void doLL(int rt, int rs, int simm16) {
        int word = memory.read32(this.getRegister(rs) + simm16);
        if (rt != 0) {
            this.setRegister(rt, word);
        }
    }

    public void doSC(int rt, int rs, int simm16) {
        memory.write32(this.getRegister(rs) + simm16, this.getRegister(rt));
        if (rt != 0) {
            this.setRegister(rt, 1);
        }
    }
}

