/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex;

import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.VfpuState;
import jpcsp.Allegrex.compiler.CodeInstruction;
import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Allegrex.compiler.ICompilerContext;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Allegrex.compiler.SequenceLWCodeInstruction;
import jpcsp.Allegrex.compiler.SequenceSWCodeInstruction;
import jpcsp.Emulator;
import jpcsp.HLE.SyscallHandler;
import jpcsp.Processor;
import jpcsp.util.Utilities;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class Instructions {
    public static final Common.Instruction NOP = new Common.Instruction(0){

        @Override
        public final String name() {
            return "NOP";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
        }

        @Override
        public String disasm(int address, int insn) {
            return "nop";
        }
    };
    public static final Common.Instruction ICACHE_INDEX_INVALIDATE = new Common.Instruction(1){

        @Override
        public final String name() {
            return "ICACHE INDEX INVALIDATE";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmCODEIMMRS("cache", 4, (short)imm16, rs);
        }
    };
    public static final Common.Instruction ICACHE_INDEX_UNLOCK = new Common.Instruction(2){

        @Override
        public final String name() {
            return "ICACHE INDEX UNLOCK";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmCODEIMMRS("cache", 6, (short)imm16, rs);
        }
    };
    public static final Common.Instruction ICACHE_HIT_INVALIDATE = new Common.Instruction(3){

        @Override
        public final String name() {
            return "ICACHE HIT INVALIDATE";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            int addr = processor.cpu.getRegister(rs) + (short)imm16;
            int size = 64;
            if (Emulator.log.isInfoEnabled()) {
                Emulator.log.info((Object)String.format("%s addr=0x%08X, size=%d", this.name(), addr, size));
            }
            RuntimeContext.invalidateRange(addr, size);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmCODEIMMRS("cache", 8, (short)imm16, rs);
        }
    };
    public static final Common.Instruction ICACHE_FILL = new Common.Instruction(4){

        @Override
        public final String name() {
            return "ICACHE FILL";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmCODEIMMRS("cache", 10, (short)imm16, rs);
        }
    };
    public static final Common.Instruction ICACHE_FILL_WITH_LOCK = new Common.Instruction(5){

        @Override
        public final String name() {
            return "ICACHE FILL WITH LOCK";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmCODEIMMRS("cache", 11, (short)imm16, rs);
        }
    };
    public static final Common.Instruction DCACHE_INDEX_WRITEBACK_INVALIDATE = new Common.Instruction(6){

        @Override
        public final String name() {
            return "DCACHE INDEX WRITEBACK INVALIDATE";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmCODEIMMRS("cache", 20, (short)imm16, rs);
        }
    };
    public static final Common.Instruction DCACHE_INDEX_UNLOCK = new Common.Instruction(7){

        @Override
        public final String name() {
            return "DCACHE INDEX UNLOCK";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmCODEIMMRS("cache", 22, (short)imm16, rs);
        }
    };
    public static final Common.Instruction DCACHE_CREATE_DIRTY_EXCLUSIVE = new Common.Instruction(8){

        @Override
        public final String name() {
            return "DCACHE CREATE DIRTY EXCLUSIVE";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmCODEIMMRS("cache", 24, (short)imm16, rs);
        }
    };
    public static final Common.Instruction DCACHE_HIT_INVALIDATE = new Common.Instruction(9){

        @Override
        public final String name() {
            return "DCACHE HIT INVALIDATE";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmCODEIMMRS("cache", 25, (short)imm16, rs);
        }
    };
    public static final Common.Instruction DCACHE_HIT_WRITEBACK = new Common.Instruction(10){

        @Override
        public final String name() {
            return "DCACHE HIT WRITEBACK";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmCODEIMMRS("cache", 26, (short)imm16, rs);
        }
    };
    public static final Common.Instruction DCACHE_HIT_WRITEBACK_INVALIDATE = new Common.Instruction(11){

        @Override
        public final String name() {
            return "DCACHE HIT WRITEBACK INVALIDATE";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmCODEIMMRS("cache", 27, (short)imm16, rs);
        }
    };
    public static final Common.Instruction DCACHE_CREATE_DIRTY_EXCLUSIVE_WITH_LOCK = new Common.Instruction(12){

        @Override
        public final String name() {
            return "DCACHE CREATE DIRTY EXCLUSIVE WITH LOCK";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmCODEIMMRS("cache", 28, (short)imm16, rs);
        }
    };
    public static final Common.Instruction DCACHE_FILL = new Common.Instruction(13){

        @Override
        public final String name() {
            return "DCACHE FILL";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmCODEIMMRS("cache", 30, (short)imm16, rs);
        }
    };
    public static final Common.Instruction DCACHE_FILL_WITH_LOCK = new Common.Instruction(14){

        @Override
        public final String name() {
            return "DCACHE FILL WITH LOCK";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmCODEIMMRS("cache", 31, (short)imm16, rs);
        }
    };
    public static final Common.Instruction SYSCALL = new Common.Instruction(15, 32768){

        @Override
        public final String name() {
            return "SYSCALL";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm20 = insn >> 6 & 0xFFFFF;
            SyscallHandler.syscall(imm20);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileSyscall();
        }

        @Override
        public String disasm(int address, int insn) {
            int imm20 = insn >> 6 & 0xFFFFF;
            return Common.disasmSYSCALL(imm20);
        }
    };
    public static final Common.Instruction ERET = new Common.Instruction(16){

        @Override
        public final String name() {
            return "ERET";
        }

        @Override
        public final String category() {
            return "MIPS III";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            return "eret";
        }
    };
    public static final Common.Instruction BREAK = new Common.Instruction(17){

        @Override
        public final String name() {
            return "BREAK";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm20 = insn >> 6 & 0xFFFFF;
            Emulator.log.error((Object)String.format("Allegrex break 0x%05X", imm20));
            if (!Processor.memory.isIgnoreInvalidMemoryAccess()) {
                Emulator.PauseEmuWithStatus(256);
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm20 = insn >> 6 & 0xFFFFF;
            return Common.disasmBREAK(imm20);
        }
    };
    public static final Common.Instruction SYNC = new Common.Instruction(18){

        @Override
        public final String name() {
            return "SYNC";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
        }

        @Override
        public String disasm(int address, int insn) {
            return "sync";
        }
    };
    public static final Common.Instruction HALT = new Common.Instruction(19){

        @Override
        public final String name() {
            return "HALT";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            Emulator.log.error((Object)"Allegrex halt");
            Emulator.PauseEmuWithStatus(512);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            return "halt";
        }
    };
    public static final Common.Instruction MFIC = new Common.Instruction(20){

        @Override
        public final String name() {
            return "MFIC";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int rt = insn >> 21 & 0x1F;
            return Common.disasmRT("mfic", rt);
        }
    };
    public static final Common.Instruction MTIC = new Common.Instruction(21){

        @Override
        public final String name() {
            return "MTIC";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int rt = insn >> 21 & 0x1F;
            return Common.disasmRT("mtic", rt);
        }
    };
    public static final Common.Instruction ADD = new Common.Instruction(22, 16384){

        @Override
        public final String name() {
            return "ADD";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doADDU(rd, rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                if (context.isRsRegister0() && context.isRtRegister0()) {
                    context.storeRd(0);
                } else {
                    context.prepareRdForStore();
                    if (context.isRsRegister0()) {
                        context.loadRt();
                    } else {
                        context.loadRs();
                        if (!context.isRtRegister0()) {
                            context.loadRt();
                            context.getMethodVisitor().visitInsn(96);
                        }
                    }
                    context.storeRd();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRSRT("add", rd, rs, rt);
        }
    };
    public static final Common.Instruction ADDU = new Common.Instruction(23, 16384){

        @Override
        public final String name() {
            return "ADDU";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doADDU(rd, rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            ADD.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRSRT("addu", rd, rs, rt);
        }
    };
    public static final Common.Instruction ADDI = new Common.Instruction(24, 8192){

        @Override
        public final String name() {
            return "ADDI";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doADDIU(rt, rs, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            ADDIU.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTRSIMM("addi", rt, rs, (short)imm16);
        }
    };
    public static final Common.Instruction ADDIU = new Common.Instruction(25, 8192){

        @Override
        public final String name() {
            return "ADDIU";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doADDIU(rt, rs, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRtRegister0()) {
                int imm = context.getImm16(true);
                if (context.isRsRegister0()) {
                    context.storeRt(imm);
                } else if (imm != 0 || context.getRsRegisterIndex() != context.getRtRegisterIndex()) {
                    context.prepareRtForStore();
                    context.loadRs();
                    if (imm != 0) {
                        context.loadImm(imm);
                        context.getMethodVisitor().visitInsn(96);
                    }
                    context.storeRt();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTRSIMM("addiu", rt, rs, (short)imm16);
        }
    };
    public static final Common.Instruction AND = new Common.Instruction(26, 16384){

        @Override
        public final String name() {
            return "AND";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doAND(rd, rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                if (context.isRsRegister0() || context.isRtRegister0()) {
                    context.storeRd(0);
                } else {
                    context.prepareRdForStore();
                    context.loadRs();
                    context.loadRt();
                    context.getMethodVisitor().visitInsn(126);
                    context.storeRd();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRSRT("and", rd, rs, rt);
        }
    };
    public static final Common.Instruction ANDI = new Common.Instruction(27, 8192){

        @Override
        public final String name() {
            return "ANDI";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doANDI(rt, rs, imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRtRegister0()) {
                int imm = context.getImm16(false);
                if (imm == 0 || context.isRsRegister0()) {
                    context.storeRt(0);
                } else {
                    context.prepareRtForStore();
                    context.loadRs();
                    context.loadImm(imm);
                    context.getMethodVisitor().visitInsn(126);
                    context.storeRt();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTRSIMM("andi", rt, rs, imm16);
        }
    };
    public static final Common.Instruction NOR = new Common.Instruction(28, 16384){

        @Override
        public final String name() {
            return "NOR";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doNOR(rd, rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                if (context.isRsRegister0() && context.isRtRegister0()) {
                    context.storeRd(-1);
                } else {
                    context.prepareRdForStore();
                    if (context.isRsRegister0()) {
                        context.loadRt();
                    } else {
                        context.loadRs();
                        if (!context.isRtRegister0() && context.getRsRegisterIndex() != context.getRtRegisterIndex()) {
                            context.loadRt();
                            context.getMethodVisitor().visitInsn(128);
                        }
                    }
                    context.loadImm(-1);
                    context.getMethodVisitor().visitInsn(130);
                    context.storeRd();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRSRT("nor", rd, rs, rt);
        }
    };
    public static final Common.Instruction OR = new Common.Instruction(29, 16384){

        @Override
        public final String name() {
            return "OR";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doOR(rd, rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                if (context.isRsRegister0() && context.isRtRegister0()) {
                    context.storeRd(0);
                } else {
                    context.prepareRdForStore();
                    if (context.isRsRegister0()) {
                        context.loadRt();
                    } else {
                        context.loadRs();
                        if (!context.isRtRegister0() && context.getRsRegisterIndex() != context.getRtRegisterIndex()) {
                            context.loadRt();
                            context.getMethodVisitor().visitInsn(128);
                        }
                    }
                    context.storeRd();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRSRT("or", rd, rs, rt);
        }
    };
    public static final Common.Instruction ORI = new Common.Instruction(30, 8192){

        @Override
        public final String name() {
            return "ORI";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doORI(rt, rs, imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRtRegister0()) {
                int imm = context.getImm16(false);
                if (context.isRsRegister0()) {
                    context.storeRt(imm);
                } else if (imm != 0 || context.getRsRegisterIndex() != context.getRtRegisterIndex()) {
                    context.prepareRtForStore();
                    context.loadRs();
                    if (imm != 0) {
                        context.loadImm(imm);
                        context.getMethodVisitor().visitInsn(128);
                    }
                    context.storeRt();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTRSIMM("ori", rt, rs, imm16);
        }
    };
    public static final Common.Instruction XOR = new Common.Instruction(31, 16384){

        @Override
        public final String name() {
            return "XOR";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doXOR(rd, rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                if (context.isRsRegister0() && context.isRtRegister0()) {
                    context.storeRd(0);
                } else if (context.getRtRegisterIndex() == context.getRsRegisterIndex()) {
                    context.storeRd(0);
                } else {
                    context.prepareRdForStore();
                    if (context.isRsRegister0()) {
                        context.loadRt();
                    } else {
                        context.loadRs();
                        if (!context.isRtRegister0()) {
                            context.loadRt();
                            context.getMethodVisitor().visitInsn(130);
                        }
                    }
                    context.storeRd();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRSRT("xor", rd, rs, rt);
        }
    };
    public static final Common.Instruction XORI = new Common.Instruction(32, 8192){

        @Override
        public final String name() {
            return "XORI";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doXORI(rt, rs, imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRtRegister0()) {
                int imm = context.getImm16(false);
                if (context.isRsRegister0()) {
                    context.storeRt(imm);
                } else if (imm != 0 || context.getRtRegisterIndex() != context.getRsRegisterIndex()) {
                    context.prepareRtForStore();
                    context.loadRs();
                    if (imm != 0) {
                        context.loadImm(imm);
                        context.getMethodVisitor().visitInsn(130);
                    }
                    context.storeRt();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTRSIMM("xori", rt, rs, imm16);
        }
    };
    public static final Common.Instruction SLL = new Common.Instruction(33, 16384){

        @Override
        public final String name() {
            return "SLL";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int sa = insn >> 6 & 0x1F;
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            processor.cpu.doSLL(rd, rt, sa);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                if (context.isRtRegister0()) {
                    context.storeRd(0);
                } else {
                    context.prepareRdForStore();
                    context.loadRt();
                    int sa = context.getSaValue();
                    if (sa != 0) {
                        context.loadImm(sa);
                        context.getMethodVisitor().visitInsn(120);
                    }
                    context.storeRd();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int sa = insn >> 6 & 0x1F;
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            return Common.disasmRDRTSA("sll", rd, rt, sa);
        }
    };
    public static final Common.Instruction SLLV = new Common.Instruction(34, 16384){

        @Override
        public final String name() {
            return "SLLV";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doSLLV(rd, rt, rs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                if (context.isRtRegister0()) {
                    context.storeRd(0);
                } else {
                    context.prepareRdForStore();
                    context.loadRt();
                    if (!context.isRsRegister0()) {
                        context.loadRs();
                        context.loadImm(31);
                        context.getMethodVisitor().visitInsn(126);
                        context.getMethodVisitor().visitInsn(120);
                    }
                    context.storeRd();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRTRS("sllv", rd, rt, rs);
        }
    };
    public static final Common.Instruction SRA = new Common.Instruction(35, 16384){

        @Override
        public final String name() {
            return "SRA";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int sa = insn >> 6 & 0x1F;
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            processor.cpu.doSRA(rd, rt, sa);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                if (context.isRtRegister0()) {
                    context.storeRd(0);
                } else {
                    context.prepareRdForStore();
                    context.loadRt();
                    int sa = context.getSaValue();
                    if (sa != 0) {
                        context.loadImm(sa);
                        context.getMethodVisitor().visitInsn(122);
                    }
                    context.storeRd();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int sa = insn >> 6 & 0x1F;
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            return Common.disasmRDRTSA("sra", rd, rt, sa);
        }
    };
    public static final Common.Instruction SRAV = new Common.Instruction(36, 16384){

        @Override
        public final String name() {
            return "SRAV";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doSRAV(rd, rt, rs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                if (context.isRtRegister0()) {
                    context.storeRd(0);
                } else {
                    context.prepareRdForStore();
                    context.loadRt();
                    if (!context.isRsRegister0()) {
                        context.loadRs();
                        context.loadImm(31);
                        context.getMethodVisitor().visitInsn(126);
                        context.getMethodVisitor().visitInsn(122);
                    }
                    context.storeRd();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRTRS("srav", rd, rt, rs);
        }
    };
    public static final Common.Instruction SRL = new Common.Instruction(37, 16384){

        @Override
        public final String name() {
            return "SRL";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int sa = insn >> 6 & 0x1F;
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            processor.cpu.doSRL(rd, rt, sa);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                if (context.isRtRegister0()) {
                    context.storeRd(0);
                } else {
                    context.prepareRdForStore();
                    context.loadRt();
                    int sa = context.getSaValue();
                    if (sa != 0) {
                        context.loadImm(sa);
                        context.getMethodVisitor().visitInsn(124);
                    }
                    context.storeRd();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int sa = insn >> 6 & 0x1F;
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            return Common.disasmRDRTSA("srl", rd, rt, sa);
        }
    };
    public static final Common.Instruction SRLV = new Common.Instruction(38, 16384){

        @Override
        public final String name() {
            return "SRLV";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doSRLV(rd, rt, rs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                if (context.isRtRegister0()) {
                    context.storeRd(0);
                } else {
                    context.prepareRdForStore();
                    context.loadRt();
                    if (!context.isRsRegister0()) {
                        context.loadRs();
                        context.loadImm(31);
                        context.getMethodVisitor().visitInsn(126);
                        context.getMethodVisitor().visitInsn(124);
                    }
                    context.storeRd();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRTRS("srlv", rd, rt, rs);
        }
    };
    public static final Common.Instruction ROTR = new Common.Instruction(39, 16384){

        @Override
        public final String name() {
            return "ROTR";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int sa = insn >> 6 & 0x1F;
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            processor.cpu.doROTR(rd, rt, sa);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                if (context.isRtRegister0()) {
                    context.storeRd(0);
                } else {
                    context.prepareRdForStore();
                    context.loadRt();
                    int sa = context.getSaValue();
                    if (sa != 0) {
                        context.getMethodVisitor().visitInsn(89);
                        context.loadImm(sa);
                        context.getMethodVisitor().visitInsn(124);
                        context.getMethodVisitor().visitInsn(95);
                        context.loadImm(32 - sa);
                        context.getMethodVisitor().visitInsn(120);
                        context.getMethodVisitor().visitInsn(128);
                    }
                    context.storeRd();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int sa = insn >> 6 & 0x1F;
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            return Common.disasmRDRTSA("rotr", rd, rt, sa);
        }
    };
    public static final Common.Instruction ROTRV = new Common.Instruction(40, 16384){

        @Override
        public final String name() {
            return "ROTRV";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doROTRV(rd, rt, rs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                if (context.isRtRegister0()) {
                    context.storeRd(0);
                } else {
                    context.prepareRdForStore();
                    context.loadRt();
                    if (!context.isRsRegister0()) {
                        context.loadRs();
                        context.loadImm(31);
                        context.getMethodVisitor().visitInsn(126);
                        context.getMethodVisitor().visitInsn(92);
                        context.getMethodVisitor().visitInsn(124);
                        context.getMethodVisitor().visitInsn(91);
                        context.getMethodVisitor().visitInsn(87);
                        context.getMethodVisitor().visitInsn(116);
                        context.getMethodVisitor().visitInsn(120);
                        context.getMethodVisitor().visitInsn(128);
                    }
                    context.storeRd();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRTRS("rotrv", rd, rt, rs);
        }
    };
    public static final Common.Instruction SLT = new Common.Instruction(41, 16384){

        @Override
        public final String name() {
            return "SLT";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doSLT(rd, rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                if (context.getRsRegisterIndex() == context.getRtRegisterIndex()) {
                    context.storeRd(0);
                } else {
                    MethodVisitor mv = context.getMethodVisitor();
                    Label ifLtLabel = new Label();
                    Label continueLabel = new Label();
                    context.prepareRdForStore();
                    if (context.isRsRegister0()) {
                        context.loadRt();
                        mv.visitJumpInsn(157, ifLtLabel);
                    } else if (context.isRtRegister0()) {
                        context.loadRs();
                        mv.visitJumpInsn(155, ifLtLabel);
                    } else {
                        context.loadRs();
                        context.loadRt();
                        mv.visitJumpInsn(161, ifLtLabel);
                    }
                    context.loadImm(0);
                    mv.visitJumpInsn(167, continueLabel);
                    mv.visitLabel(ifLtLabel);
                    context.loadImm(1);
                    mv.visitLabel(continueLabel);
                    context.storeRd();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRSRT("slt", rd, rs, rt);
        }
    };
    public static final Common.Instruction SLTI = new Common.Instruction(42, 8192){

        @Override
        public final String name() {
            return "SLTI";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doSLTI(rt, rs, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRtRegister0()) {
                int simm16 = context.getImm16(true);
                if (context.isRsRegister0()) {
                    context.storeRt(simm16 > 0 ? 1 : 0);
                } else {
                    MethodVisitor mv = context.getMethodVisitor();
                    Label ifLtLabel = new Label();
                    Label continueLabel = new Label();
                    context.prepareRtForStore();
                    context.loadRs();
                    if (simm16 == 0) {
                        mv.visitJumpInsn(155, ifLtLabel);
                    } else {
                        context.loadImm(simm16);
                        mv.visitJumpInsn(161, ifLtLabel);
                    }
                    context.loadImm(0);
                    mv.visitJumpInsn(167, continueLabel);
                    mv.visitLabel(ifLtLabel);
                    context.loadImm(1);
                    mv.visitLabel(continueLabel);
                    context.storeRt();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTRSIMM("slti", rt, rs, (short)imm16);
        }
    };
    public static final Common.Instruction SLTU = new Common.Instruction(43, 16384){

        @Override
        public final String name() {
            return "SLTU";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doSLTU(rd, rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                if (context.getRsRegisterIndex() == context.getRtRegisterIndex()) {
                    context.storeRd(0);
                } else if (context.isRtRegister0()) {
                    context.storeRd(0);
                } else {
                    MethodVisitor mv = context.getMethodVisitor();
                    Label ifLtLabel = new Label();
                    Label continueLabel = new Label();
                    context.prepareRdForStore();
                    if (context.isRsRegister0()) {
                        context.loadRt();
                        mv.visitJumpInsn(154, ifLtLabel);
                    } else {
                        context.loadRs();
                        context.convertUnsignedIntToLong();
                        context.loadRt();
                        context.convertUnsignedIntToLong();
                        mv.visitInsn(148);
                        mv.visitJumpInsn(155, ifLtLabel);
                    }
                    context.loadImm(0);
                    mv.visitJumpInsn(167, continueLabel);
                    mv.visitLabel(ifLtLabel);
                    context.loadImm(1);
                    mv.visitLabel(continueLabel);
                    context.storeRd();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRSRT("sltu", rd, rs, rt);
        }
    };
    public static final Common.Instruction SLTIU = new Common.Instruction(44, 8192){

        @Override
        public final String name() {
            return "SLTIU";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doSLTIU(rt, rs, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRtRegister0()) {
                int simm16 = context.getImm16(true);
                if (context.isRsRegister0()) {
                    context.storeRt(0 < simm16 ? 1 : 0);
                } else if (simm16 == 0) {
                    context.storeRt(0);
                } else {
                    MethodVisitor mv = context.getMethodVisitor();
                    Label ifLtLabel = new Label();
                    Label continueLabel = new Label();
                    context.prepareRtForStore();
                    if (simm16 == 1) {
                        context.loadRs();
                        mv.visitJumpInsn(153, ifLtLabel);
                    } else {
                        context.loadRs();
                        context.convertUnsignedIntToLong();
                        mv.visitLdcInsn((Object)((long)simm16 & 0xFFFFFFFFL));
                        mv.visitInsn(148);
                        mv.visitJumpInsn(155, ifLtLabel);
                    }
                    context.loadImm(0);
                    mv.visitJumpInsn(167, continueLabel);
                    mv.visitLabel(ifLtLabel);
                    context.loadImm(1);
                    mv.visitLabel(continueLabel);
                    context.storeRt();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTRSIMM("sltiu", rt, rs, (short)imm16);
        }
    };
    public static final Common.Instruction SUB = new Common.Instruction(45, 16384){

        @Override
        public final String name() {
            return "SUB";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doSUBU(rd, rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                if (context.getRsRegisterIndex() == context.getRtRegisterIndex()) {
                    context.storeRd(0);
                } else {
                    context.prepareRdForStore();
                    if (context.isRsRegister0()) {
                        context.loadRt();
                        context.getMethodVisitor().visitInsn(116);
                    } else {
                        context.loadRs();
                        if (!context.isRtRegister0()) {
                            context.loadRt();
                            context.getMethodVisitor().visitInsn(100);
                        }
                    }
                    context.storeRd();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRSRT("sub", rd, rs, rt);
        }
    };
    public static final Common.Instruction SUBU = new Common.Instruction(46, 16384){

        @Override
        public final String name() {
            return "SUBU";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doSUBU(rd, rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            SUB.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRSRT("subu", rd, rs, rt);
        }
    };
    public static final Common.Instruction LUI = new Common.Instruction(47, 8192){

        @Override
        public final String name() {
            return "LUI";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            processor.cpu.doLUI(rt, imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRtRegister0()) {
                int uimm16 = context.getImm16(false);
                context.storeRt(uimm16 << 16);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            return Common.disasmRTIMM("lui", rt, imm16);
        }
    };
    public static final Common.Instruction SEB = new Common.Instruction(48, 16384){

        @Override
        public final String name() {
            return "SEB";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            processor.cpu.doSEB(rd, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                context.prepareRdForStore();
                context.loadRt();
                context.getMethodVisitor().visitInsn(145);
                context.storeRd();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            return Common.disasmRDRT("seb", rd, rt);
        }
    };
    public static final Common.Instruction SEH = new Common.Instruction(49, 16384){

        @Override
        public final String name() {
            return "SEH";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            processor.cpu.doSEH(rd, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                context.prepareRdForStore();
                context.loadRt();
                context.getMethodVisitor().visitInsn(147);
                context.storeRd();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            return Common.disasmRDRT("seh", rd, rt);
        }
    };
    public static final Common.Instruction BITREV = new Common.Instruction(50, 16384){

        @Override
        public final String name() {
            return "BITREV";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            processor.cpu.doBITREV(rd, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileRDRT("doBITREV");
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            return Common.disasmRDRT("bitrev", rd, rt);
        }
    };
    public static final Common.Instruction WSBH = new Common.Instruction(51, 16384){

        @Override
        public final String name() {
            return "WSBH";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            processor.cpu.doWSBH(rd, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileRDRT("doWSBH");
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            return Common.disasmRDRT("wsbh", rd, rt);
        }
    };
    public static final Common.Instruction WSBW = new Common.Instruction(52, 16384){

        @Override
        public final String name() {
            return "WSBW";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            processor.cpu.doWSBW(rd, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileRDRT("doWSBW");
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            return Common.disasmRDRT("wsbw", rd, rt);
        }
    };
    public static final Common.Instruction MOVZ = new Common.Instruction(53, 16384){

        @Override
        public final String name() {
            return "MOVZ";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doMOVZ(rd, rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.loadRt();
            Label doNotChange = new Label();
            context.getMethodVisitor().visitJumpInsn(154, doNotChange);
            context.prepareRdForStore();
            context.loadRs();
            context.storeRd();
            context.getMethodVisitor().visitLabel(doNotChange);
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRSRT("movz", rd, rs, rt);
        }
    };
    public static final Common.Instruction MOVN = new Common.Instruction(54, 16384){

        @Override
        public final String name() {
            return "MOVN";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doMOVN(rd, rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.loadRt();
            Label doNotChange = new Label();
            context.getMethodVisitor().visitJumpInsn(153, doNotChange);
            context.prepareRdForStore();
            context.loadRs();
            context.storeRd();
            context.getMethodVisitor().visitLabel(doNotChange);
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRSRT("movn", rd, rs, rt);
        }
    };
    public static final Common.Instruction MAX = new Common.Instruction(55, 16384){

        @Override
        public final String name() {
            return "MAX";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doMAX(rd, rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                Label continueLabel = new Label();
                if (context.getRdRegisterIndex() == context.getRtRegisterIndex()) {
                    context.loadRs();
                    context.loadRt();
                    context.getMethodVisitor().visitJumpInsn(164, continueLabel);
                    context.prepareRdForStore();
                    context.loadRs();
                    context.storeRd();
                    context.getMethodVisitor().visitLabel(continueLabel);
                } else if (context.getRdRegisterIndex() == context.getRsRegisterIndex()) {
                    context.loadRs();
                    context.loadRt();
                    context.getMethodVisitor().visitJumpInsn(162, continueLabel);
                    context.prepareRdForStore();
                    context.loadRt();
                    context.storeRd();
                    context.getMethodVisitor().visitLabel(continueLabel);
                } else if (context.getRsRegisterIndex() == context.getRtRegisterIndex()) {
                    context.prepareRdForStore();
                    context.loadRs();
                    context.storeRd();
                } else {
                    context.prepareRdForStore();
                    context.loadRs();
                    context.loadRt();
                    Label case1Label = new Label();
                    context.getMethodVisitor().visitJumpInsn(164, case1Label);
                    context.loadRs();
                    context.getMethodVisitor().visitJumpInsn(167, continueLabel);
                    context.getMethodVisitor().visitLabel(case1Label);
                    context.loadRt();
                    context.getMethodVisitor().visitLabel(continueLabel);
                    context.storeRd();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRSRT("max", rd, rs, rt);
        }
    };
    public static final Common.Instruction MIN = new Common.Instruction(56, 16384){

        @Override
        public final String name() {
            return "MIN";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doMIN(rd, rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                Label continueLabel = new Label();
                if (context.getRdRegisterIndex() == context.getRtRegisterIndex()) {
                    context.loadRs();
                    context.loadRt();
                    context.getMethodVisitor().visitJumpInsn(162, continueLabel);
                    context.prepareRdForStore();
                    context.loadRs();
                    context.storeRd();
                    context.getMethodVisitor().visitLabel(continueLabel);
                } else if (context.getRdRegisterIndex() == context.getRsRegisterIndex()) {
                    context.loadRs();
                    context.loadRt();
                    context.getMethodVisitor().visitJumpInsn(164, continueLabel);
                    context.prepareRdForStore();
                    context.loadRt();
                    context.storeRd();
                    context.getMethodVisitor().visitLabel(continueLabel);
                } else if (context.getRsRegisterIndex() == context.getRtRegisterIndex()) {
                    context.prepareRdForStore();
                    context.loadRs();
                    context.storeRd();
                } else {
                    context.prepareRdForStore();
                    context.loadRs();
                    context.loadRt();
                    Label case1Label = new Label();
                    context.getMethodVisitor().visitJumpInsn(162, case1Label);
                    context.loadRs();
                    context.getMethodVisitor().visitJumpInsn(167, continueLabel);
                    context.getMethodVisitor().visitLabel(case1Label);
                    context.loadRt();
                    context.getMethodVisitor().visitLabel(continueLabel);
                    context.storeRd();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRSRT("min", rd, rs, rt);
        }
    };
    public static final Common.Instruction CLZ = new Common.Instruction(57, 16384){

        @Override
        public final String name() {
            return "CLZ";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doCLZ(rd, rs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                if (context.isRsRegister0()) {
                    context.storeRd(32);
                } else {
                    context.prepareRdForStore();
                    context.loadRs();
                    context.getMethodVisitor().visitMethodInsn(184, Type.getInternalName(Integer.class), "numberOfLeadingZeros", "(I)I");
                    context.storeRd();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRS("clz", rd, rs);
        }
    };
    public static final Common.Instruction CLO = new Common.Instruction(58, 16384){

        @Override
        public final String name() {
            return "CLO";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doCLO(rd, rs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                if (context.isRsRegister0()) {
                    context.storeRd(0);
                } else {
                    context.prepareRdForStore();
                    context.loadRs();
                    context.loadImm(-1);
                    context.getMethodVisitor().visitInsn(130);
                    context.getMethodVisitor().visitMethodInsn(184, Type.getInternalName(Integer.class), "numberOfLeadingZeros", "(I)I");
                    context.storeRd();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRS("clo", rd, rs);
        }
    };
    public static final Common.Instruction EXT = new Common.Instruction(59, 8192){

        @Override
        public final String name() {
            return "EXT";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int lsb = insn >> 6 & 0x1F;
            int msb = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doEXT(rt, rs, lsb, msb);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRtRegister0()) {
                int lsb = insn >> 6 & 0x1F;
                int msb = insn >> 11 & 0x1F;
                int mask = ~(-1 << msb + 1);
                if (context.isRsRegister0() || mask == 0) {
                    context.storeRt(0);
                } else {
                    context.prepareRtForStore();
                    context.loadRs();
                    if (lsb != 0) {
                        context.loadImm(lsb);
                        context.getMethodVisitor().visitInsn(124);
                    }
                    if (mask != -1) {
                        context.loadImm(mask);
                        context.getMethodVisitor().visitInsn(126);
                    }
                    context.storeRt();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int lsb = insn >> 6 & 0x1F;
            int msb = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmEXT(rt, rs, lsb, msb);
        }
    };
    public static final Common.Instruction INS = new Common.Instruction(60, 8192){

        @Override
        public final String name() {
            return "INS";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int lsb = insn >> 6 & 0x1F;
            int msb = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doINS(rt, rs, lsb, msb);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRtRegister0()) {
                int msb = insn >> 11 & 0x1F;
                int lsb = insn >> 6 & 0x1F;
                int mask = ~(-1 << msb - lsb + 1) << lsb;
                if (mask == -1 && context.isRsRegister0()) {
                    context.storeRt(0);
                } else if (mask != 0) {
                    context.prepareRtForStore();
                    if (mask == -1) {
                        context.loadRs();
                        if (lsb != 0) {
                            context.loadImm(lsb);
                            context.getMethodVisitor().visitInsn(120);
                        }
                    } else {
                        context.loadRt();
                        context.loadImm(~mask);
                        context.getMethodVisitor().visitInsn(126);
                        if (!context.isRsRegister0()) {
                            context.loadRs();
                            if (lsb != 0) {
                                context.loadImm(lsb);
                                context.getMethodVisitor().visitInsn(120);
                            }
                            if (mask != -1) {
                                context.loadImm(mask);
                                context.getMethodVisitor().visitInsn(126);
                            }
                            context.getMethodVisitor().visitInsn(128);
                        }
                    }
                    context.storeRt();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int lsb = insn >> 6 & 0x1F;
            int msb = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmINS(rt, rs, lsb, msb);
        }
    };
    public static final Common.Instruction MULT = new Common.Instruction(61){

        @Override
        public final String name() {
            return "MULT";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doMULT(rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.prepareHiloForStore();
            if (context.isRsRegister0() || context.isRtRegister0()) {
                context.getMethodVisitor().visitLdcInsn((Object)0L);
            } else {
                context.loadRs();
                context.getMethodVisitor().visitInsn(133);
                context.loadRt();
                context.getMethodVisitor().visitInsn(133);
                context.getMethodVisitor().visitInsn(105);
            }
            context.storeHilo();
        }

        @Override
        public String disasm(int address, int insn) {
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSRT("mult", rs, rt);
        }
    };
    public static final Common.Instruction MULTU = new Common.Instruction(62){

        @Override
        public final String name() {
            return "MULTU";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doMULTU(rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.prepareHiloForStore();
            if (context.isRsRegister0() || context.isRtRegister0()) {
                context.getMethodVisitor().visitLdcInsn((Object)0L);
            } else {
                context.loadRs();
                context.convertUnsignedIntToLong();
                context.loadRt();
                context.convertUnsignedIntToLong();
                context.getMethodVisitor().visitInsn(105);
            }
            context.storeHilo();
        }

        @Override
        public String disasm(int address, int insn) {
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSRT("multu", rs, rt);
        }
    };
    public static final Common.Instruction MADD = new Common.Instruction(63){

        @Override
        public final String name() {
            return "MADD";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doMADD(rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRsRegister0() && !context.isRtRegister0()) {
                context.prepareHiloForStore();
                context.loadHilo();
                context.loadRs();
                context.getMethodVisitor().visitInsn(133);
                context.loadRt();
                context.getMethodVisitor().visitInsn(133);
                context.getMethodVisitor().visitInsn(105);
                context.getMethodVisitor().visitInsn(97);
                context.storeHilo();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSRT("madd", rs, rt);
        }
    };
    public static final Common.Instruction MADDU = new Common.Instruction(64){

        @Override
        public final String name() {
            return "MADDU";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doMADDU(rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRsRegister0() && !context.isRtRegister0()) {
                context.prepareHiloForStore();
                context.loadHilo();
                context.loadRs();
                context.convertUnsignedIntToLong();
                context.loadRt();
                context.convertUnsignedIntToLong();
                context.getMethodVisitor().visitInsn(105);
                context.getMethodVisitor().visitInsn(97);
                context.storeHilo();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSRT("maddu", rs, rt);
        }
    };
    public static final Common.Instruction MSUB = new Common.Instruction(65){

        @Override
        public final String name() {
            return "MSUB";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doMSUB(rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRsRegister0() && !context.isRtRegister0()) {
                context.prepareHiloForStore();
                context.loadHilo();
                context.loadRs();
                context.getMethodVisitor().visitInsn(133);
                context.loadRt();
                context.getMethodVisitor().visitInsn(133);
                context.getMethodVisitor().visitInsn(105);
                context.getMethodVisitor().visitInsn(101);
                context.storeHilo();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSRT("msub", rs, rt);
        }
    };
    public static final Common.Instruction MSUBU = new Common.Instruction(66){

        @Override
        public final String name() {
            return "MSUBU";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doMSUBU(rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRsRegister0() && !context.isRtRegister0()) {
                context.prepareHiloForStore();
                context.loadHilo();
                context.loadRs();
                context.convertUnsignedIntToLong();
                context.loadRt();
                context.convertUnsignedIntToLong();
                context.getMethodVisitor().visitInsn(105);
                context.getMethodVisitor().visitInsn(101);
                context.storeHilo();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSRT("msubu", rs, rt);
        }
    };
    public static final Common.Instruction DIV = new Common.Instruction(67){

        @Override
        public final String name() {
            return "DIV";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doDIV(rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            Label divideByZero = new Label();
            Label afterInstruction = new Label();
            context.loadRt();
            context.getMethodVisitor().visitJumpInsn(153, divideByZero);
            context.loadRs();
            context.loadRt();
            context.getMethodVisitor().visitInsn(92);
            context.getMethodVisitor().visitInsn(112);
            context.getMethodVisitor().visitInsn(133);
            context.loadImm(32);
            context.getMethodVisitor().visitInsn(121);
            context.getMethodVisitor().visitInsn(94);
            context.getMethodVisitor().visitInsn(88);
            context.getMethodVisitor().visitInsn(108);
            context.getMethodVisitor().visitInsn(133);
            context.getMethodVisitor().visitLdcInsn((Object)0xFFFFFFFFL);
            context.getMethodVisitor().visitInsn(127);
            context.getMethodVisitor().visitInsn(129);
            context.storeHilo();
            context.getMethodVisitor().visitJumpInsn(167, afterInstruction);
            context.getMethodVisitor().visitLabel(divideByZero);
            context.compileInterpreterInstruction();
            context.getMethodVisitor().visitLabel(afterInstruction);
        }

        @Override
        public String disasm(int address, int insn) {
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSRT("div", rs, rt);
        }
    };
    public static final Common.Instruction DIVU = new Common.Instruction(68){

        @Override
        public final String name() {
            return "DIVU";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doDIVU(rs, rt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            Label divideByZero = new Label();
            Label afterInstruction = new Label();
            context.loadRt();
            context.getMethodVisitor().visitJumpInsn(153, divideByZero);
            context.loadRs();
            context.getMethodVisitor().visitInsn(133);
            context.getMethodVisitor().visitLdcInsn((Object)0xFFFFFFFFL);
            context.getMethodVisitor().visitInsn(127);
            context.getMethodVisitor().visitInsn(92);
            context.loadRt();
            context.getMethodVisitor().visitInsn(133);
            context.getMethodVisitor().visitLdcInsn((Object)0xFFFFFFFFL);
            context.getMethodVisitor().visitInsn(127);
            context.getMethodVisitor().visitInsn(94);
            context.getMethodVisitor().visitInsn(113);
            context.loadImm(32);
            context.getMethodVisitor().visitInsn(121);
            context.storeLTmp1();
            context.getMethodVisitor().visitInsn(109);
            context.getMethodVisitor().visitLdcInsn((Object)0xFFFFFFFFL);
            context.getMethodVisitor().visitInsn(127);
            context.loadLTmp1();
            context.getMethodVisitor().visitInsn(129);
            context.storeHilo();
            context.getMethodVisitor().visitJumpInsn(167, afterInstruction);
            context.getMethodVisitor().visitLabel(divideByZero);
            context.compileInterpreterInstruction();
            context.getMethodVisitor().visitLabel(afterInstruction);
        }

        @Override
        public String disasm(int address, int insn) {
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSRT("divu", rs, rt);
        }
    };
    public static final Common.Instruction MFHI = new Common.Instruction(69, 16384){

        @Override
        public final String name() {
            return "MFHI";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            processor.cpu.doMFHI(rd);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                context.prepareRdForStore();
                context.loadHilo();
                context.loadImm(32);
                context.getMethodVisitor().visitInsn(125);
                context.getMethodVisitor().visitInsn(136);
                context.storeRd();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            return Common.disasmRD("mfhi", rd);
        }
    };
    public static final Common.Instruction MFLO = new Common.Instruction(70, 16384){

        @Override
        public final String name() {
            return "MFLO";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            processor.cpu.doMFLO(rd);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRdRegister0()) {
                context.prepareRdForStore();
                context.loadHilo();
                context.getMethodVisitor().visitLdcInsn((Object)0xFFFFFFFFL);
                context.getMethodVisitor().visitInsn(127);
                context.getMethodVisitor().visitInsn(136);
                context.storeRd();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            return Common.disasmRD("mflo", rd);
        }
    };
    public static final Common.Instruction MTHI = new Common.Instruction(71){

        @Override
        public final String name() {
            return "MTHI";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doMTHI(rs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRS("mthi", rs);
        }
    };
    public static final Common.Instruction MTLO = new Common.Instruction(72){

        @Override
        public final String name() {
            return "MTLO";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doMTLO(rs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.loadHilo();
            context.getMethodVisitor().visitLdcInsn((Object)-4294967296L);
            context.getMethodVisitor().visitInsn(127);
            if (!context.isRsRegister0()) {
                context.loadRs();
                context.getMethodVisitor().visitInsn(133);
                context.getMethodVisitor().visitLdcInsn((Object)0xFFFFFFFFL);
                context.getMethodVisitor().visitInsn(127);
                context.getMethodVisitor().visitInsn(129);
            }
            context.storeHilo();
        }

        @Override
        public String disasm(int address, int insn) {
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRS("mtlo", rs);
        }
    };
    public static final Common.Instruction BEQ = new Common.Instruction(73, 174){

        @Override
        public final String name() {
            return "BEQ";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rs = insn >> 21 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBEQ(rs, rt, (short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSRTOFFSET("beq", rs, rt, (short)imm16, address);
        }
    };
    public static final Common.Instruction BEQL = new Common.Instruction(74, 46){

        @Override
        public final String name() {
            return "BEQL";
        }

        @Override
        public final String category() {
            return "MIPS II";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rs = insn >> 21 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBEQL(rs, rt, (short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSRTOFFSET("beql", rs, rt, (short)imm16, address);
        }
    };
    public static final Common.Instruction BGEZ = new Common.Instruction(75, 46){

        @Override
        public final String name() {
            return "BGEZ";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rs = insn >> 21 & 0x1F;
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBGEZ(rs, (short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSOFFSET("bgez", rs, (short)imm16, address);
        }
    };
    public static final Common.Instruction BGEZAL = new Common.Instruction(76, 110){

        @Override
        public final String name() {
            return "BGEZAL";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rs = insn >> 21 & 0x1F;
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBGEZAL(rs, (short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSOFFSET("bgezal", rs, (short)imm16, address);
        }
    };
    public static final Common.Instruction BGEZALL = new Common.Instruction(77, 110){

        @Override
        public final String name() {
            return "BGEZALL";
        }

        @Override
        public final String category() {
            return "MIPS II";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rs = insn >> 21 & 0x1F;
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBGEZALL(rs, (short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSOFFSET("bgezall", rs, (short)imm16, address);
        }
    };
    public static final Common.Instruction BGEZL = new Common.Instruction(78, 46){

        @Override
        public final String name() {
            return "BGEZL";
        }

        @Override
        public final String category() {
            return "MIPS II";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rs = insn >> 21 & 0x1F;
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBGEZL(rs, (short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSOFFSET("bgezl", rs, (short)imm16, address);
        }
    };
    public static final Common.Instruction BGTZ = new Common.Instruction(79, 46){

        @Override
        public final String name() {
            return "BGTZ";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rs = insn >> 21 & 0x1F;
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBGTZ(rs, (short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSOFFSET("bgtz", rs, (short)imm16, address);
        }
    };
    public static final Common.Instruction BGTZL = new Common.Instruction(80, 46){

        @Override
        public final String name() {
            return "BGTZL";
        }

        @Override
        public final String category() {
            return "MIPS II";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rs = insn >> 21 & 0x1F;
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBGTZL(rs, (short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSOFFSET("bgtzl", rs, (short)imm16, address);
        }
    };
    public static final Common.Instruction BLEZ = new Common.Instruction(81, 46){

        @Override
        public final String name() {
            return "BLEZ";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rs = insn >> 21 & 0x1F;
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBLEZ(rs, (short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSOFFSET("blez", rs, (short)imm16, address);
        }
    };
    public static final Common.Instruction BLEZL = new Common.Instruction(82, 46){

        @Override
        public final String name() {
            return "BLEZL";
        }

        @Override
        public final String category() {
            return "MIPS II";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rs = insn >> 21 & 0x1F;
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBLEZL(rs, (short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSOFFSET("blezl", rs, (short)imm16, address);
        }
    };
    public static final Common.Instruction BLTZ = new Common.Instruction(83, 46){

        @Override
        public final String name() {
            return "BLTZ";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rs = insn >> 21 & 0x1F;
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBLTZ(rs, (short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSOFFSET("bltz", rs, (short)imm16, address);
        }
    };
    public static final Common.Instruction BLTZAL = new Common.Instruction(84, 110){

        @Override
        public final String name() {
            return "BLTZAL";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rs = insn >> 21 & 0x1F;
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBLTZAL(rs, (short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSOFFSET("bltzal", rs, (short)imm16, address);
        }
    };
    public static final Common.Instruction BLTZALL = new Common.Instruction(85, 110){

        @Override
        public final String name() {
            return "BLTZALL";
        }

        @Override
        public final String category() {
            return "MIPS II";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rs = insn >> 21 & 0x1F;
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBLTZALL(rs, (short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSOFFSET("bltzall", rs, (short)imm16, address);
        }
    };
    public static final Common.Instruction BLTZL = new Common.Instruction(86, 46){

        @Override
        public final String name() {
            return "BLTZL";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rs = insn >> 21 & 0x1F;
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBLTZL(rs, (short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSOFFSET("bltzl", rs, (short)imm16, address);
        }
    };
    public static final Common.Instruction BNE = new Common.Instruction(87, 46){

        @Override
        public final String name() {
            return "BNE";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rs = insn >> 21 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBNE(rs, rt, (short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSRTOFFSET("bne", rs, rt, (short)imm16, address);
        }
    };
    public static final Common.Instruction BNEL = new Common.Instruction(88, 46){

        @Override
        public final String name() {
            return "BNEL";
        }

        @Override
        public final String category() {
            return "MIPS II";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rs = insn >> 21 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBNEL(rs, rt, (short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRSRTOFFSET("bnel", rs, rt, (short)imm16, address);
        }
    };
    public static final Common.Instruction J = new Common.Instruction(89, 150){

        @Override
        public final String name() {
            return "J";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm26 = insn >> 0 & 0x3FFFFFF;
            if (processor.cpu.doJ(imm26)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm26 = insn >> 0 & 0x3FFFFFF;
            return Common.disasmJUMP("j", imm26, address);
        }
    };
    public static final Common.Instruction JAL = new Common.Instruction(90, 84){

        @Override
        public final String name() {
            return "JAL";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm26 = insn >> 0 & 0x3FFFFFF;
            if (processor.cpu.doJAL(imm26)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm26 = insn >> 0 & 0x3FFFFFF;
            return Common.disasmJUMP("jal", imm26, address);
        }
    };
    public static final Common.Instruction JALR = new Common.Instruction(91, 4){

        @Override
        public final String name() {
            return "JALR";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            if (processor.cpu.doJALR(rd, rs)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int rd = insn >> 11 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRDRS("jalr", rd, rs);
        }
    };
    public static final Common.Instruction JR = new Common.Instruction(92, 134){

        @Override
        public final String name() {
            return "JR";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int rs = insn >> 21 & 0x1F;
            if (processor.cpu.doJR(rs)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRS("jr", rs);
        }
    };
    public static final Common.Instruction BC1F = new Common.Instruction(93, 46){

        @Override
        public final String name() {
            return "BC1F";
        }

        @Override
        public final String category() {
            return "MIPS I/FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBC1F((short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            return Common.disasmOFFSET("bc1f", (short)imm16, address);
        }
    };
    public static final Common.Instruction BC1T = new Common.Instruction(94, 46){

        @Override
        public final String name() {
            return "BC1T";
        }

        @Override
        public final String category() {
            return "MIPS I/FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBC1T((short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            return Common.disasmOFFSET("bc1t", (short)imm16, address);
        }
    };
    public static final Common.Instruction BC1FL = new Common.Instruction(95, 46){

        @Override
        public final String name() {
            return "BC1FL";
        }

        @Override
        public final String category() {
            return "MIPS II/FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBC1FL((short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            return Common.disasmOFFSET("bc1fl", (short)imm16, address);
        }
    };
    public static final Common.Instruction BC1TL = new Common.Instruction(96, 46){

        @Override
        public final String name() {
            return "BC1TL";
        }

        @Override
        public final String category() {
            return "MIPS II/FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBC1TL((short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            return Common.disasmOFFSET("bc1tl", (short)imm16, address);
        }
    };
    public static final Common.Instruction BVF = new Common.Instruction(97, 46){

        @Override
        public final String name() {
            return "BVF";
        }

        @Override
        public final String category() {
            return "MIPS I/VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm3 = insn >> 18 & 7;
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBVF(imm3, (short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int imm3 = insn >> 18 & 7;
            return Common.disasmVCCOFFSET("bvf", imm3, imm16, address);
        }
    };
    public static final Common.Instruction BVT = new Common.Instruction(98, 46){

        @Override
        public final String name() {
            return "BVT";
        }

        @Override
        public final String category() {
            return "MIPS I/VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm3 = insn >> 18 & 7;
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBVT(imm3, (short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int imm3 = insn >> 18 & 7;
            return Common.disasmVCCOFFSET("bvt", imm3, imm16, address);
        }
    };
    public static final Common.Instruction BVFL = new Common.Instruction(99, 46){

        @Override
        public final String name() {
            return "BVFL";
        }

        @Override
        public final String category() {
            return "MIPS II/VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm3 = insn >> 18 & 7;
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBVFL(imm3, (short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int imm3 = insn >> 18 & 7;
            return Common.disasmVCCOFFSET("bvfl", imm3, imm16, address);
        }
    };
    public static final Common.Instruction BVTL = new Common.Instruction(100, 46){

        @Override
        public final String name() {
            return "BVTL";
        }

        @Override
        public final String category() {
            return "MIPS II/VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm3 = insn >> 18 & 7;
            int imm16 = insn >> 0 & 0xFFFF;
            if (processor.cpu.doBVTL(imm3, (short)imm16)) {
                processor.interpretDelayslot();
            }
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int imm3 = insn >> 18 & 7;
            return Common.disasmVCCOFFSET("bvtl", imm3, imm16, address);
        }
    };
    public static final Common.Instruction LB = new Common.Instruction(101, 8192){

        @Override
        public final String name() {
            return "LB";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doLB(rt, rs, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRtRegister0()) {
                context.prepareRtForStore();
                context.memRead8(context.getRsRegisterIndex(), context.getImm16(true));
                context.getMethodVisitor().visitInsn(145);
                context.storeRt();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTIMMRS("lb", rt, rs, (short)imm16);
        }
    };
    public static final Common.Instruction LBU = new Common.Instruction(102, 8192){

        @Override
        public final String name() {
            return "LBU";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doLBU(rt, rs, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRtRegister0()) {
                context.prepareRtForStore();
                context.memRead8(context.getRsRegisterIndex(), context.getImm16(true));
                context.storeRt();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTIMMRS("lbu", rt, rs, (short)imm16);
        }
    };
    public static final Common.Instruction LH = new Common.Instruction(103, 8192){

        @Override
        public final String name() {
            return "LH";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doLH(rt, rs, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRtRegister0()) {
                context.prepareRtForStore();
                context.memRead16(context.getRsRegisterIndex(), context.getImm16(true));
                context.getMethodVisitor().visitInsn(147);
                context.storeRt();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTIMMRS("lh", rt, rs, (short)imm16);
        }
    };
    public static final Common.Instruction LHU = new Common.Instruction(104, 8192){

        @Override
        public final String name() {
            return "LHU";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doLHU(rt, rs, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRtRegister0()) {
                context.prepareRtForStore();
                context.memRead16(context.getRsRegisterIndex(), context.getImm16(true));
                context.storeRt();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTIMMRS("lhu", rt, rs, (short)imm16);
        }
    };
    public static final Common.Instruction LW = new Common.Instruction(105, 8192){

        @Override
        public final String name() {
            return "LW";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doLW(rt, rs, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRtRegister0()) {
                int rs = context.getRsRegisterIndex();
                int simm16 = context.getImm16(true);
                int countSequence = 1;
                int[] offsets = null;
                int[] registers = null;
                if (!context.getCodeInstruction().isDelaySlot() && context.getRtRegisterIndex() != rs) {
                    int address = context.getCodeInstruction().getAddress() + 4;
                    int opcodeMask = -2097152;
                    int i = 1;
                    while (true) {
                        CodeInstruction nextCodeInstruction = context.getCodeInstruction(address);
                        boolean isSequence = false;
                        if (nextCodeInstruction != null && !nextCodeInstruction.isBranchTarget() && (nextCodeInstruction.getOpcode() & 0xFFE00000) == (insn & 0xFFE00000) && nextCodeInstruction.getRtRegisterIndex() != rs) {
                            if (offsets == null) {
                                offsets = new int[2];
                                registers = new int[2];
                                offsets[0] = simm16;
                                registers[0] = context.getRtRegisterIndex();
                            } else {
                                offsets = Utilities.extendArray(offsets, 1);
                                registers = Utilities.extendArray(registers, 1);
                            }
                            offsets[i] = nextCodeInstruction.getImm16(true);
                            registers[i] = nextCodeInstruction.getRtRegisterIndex();
                            isSequence = true;
                        }
                        if (!isSequence) break;
                        ++countSequence;
                        ++i;
                        address += 4;
                    }
                }
                if (countSequence > 1 && context.compileLWsequence(rs, offsets, registers)) {
                    if (countSequence > 1) {
                        if (Compiler.log.isDebugEnabled()) {
                            SequenceLWCodeInstruction sequence = new SequenceLWCodeInstruction(rs, offsets, registers);
                            sequence.setAddress(context.getCodeInstruction().getAddress());
                            Compiler.log.debug((Object)String.format("CodeInstruction.compile %s", sequence));
                        }
                        context.skipInstructions(countSequence - 1, false);
                    }
                } else {
                    context.prepareRtForStore();
                    context.memRead32(rs, simm16);
                    context.storeRt();
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTIMMRS("lw", rt, rs, (short)imm16);
        }
    };
    public static final Common.Instruction LWL = new Common.Instruction(106, 8192){

        @Override
        public final String name() {
            return "LWL";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doLWL(rt, rs, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileRTRSIMM("doLWL", true);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTIMMRS("lwl", rt, rs, (short)imm16);
        }
    };
    public static final Common.Instruction LWR = new Common.Instruction(107, 8192){

        @Override
        public final String name() {
            return "LWR";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doLWR(rt, rs, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileRTRSIMM("doLWR", true);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTIMMRS("lwr", rt, rs, (short)imm16);
        }
    };
    public static final Common.Instruction SB = new Common.Instruction(108){

        @Override
        public final String name() {
            return "SB";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doSB(rt, rs, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int rs = context.getRsRegisterIndex();
            int simm16 = context.getImm16(true);
            if (context.isRtRegister0()) {
                context.memWriteZero8(rs, simm16);
            } else {
                context.prepareMemWrite8(rs, simm16);
                context.loadRt();
                context.memWrite8(rs, simm16);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTIMMRS("sb", rt, rs, (short)imm16);
        }
    };
    public static final Common.Instruction SH = new Common.Instruction(109){

        @Override
        public final String name() {
            return "SH";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doSH(rt, rs, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int rs = context.getRsRegisterIndex();
            int simm16 = context.getImm16(true);
            context.prepareMemWrite16(rs, simm16);
            context.loadRt();
            context.memWrite16(rs, simm16);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTIMMRS("sh", rt, rs, (short)imm16);
        }
    };
    public static final Common.Instruction SW = new Common.Instruction(110){

        @Override
        public final String name() {
            return "SW";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doSW(rt, rs, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int rs = context.getRsRegisterIndex();
            int simm16 = context.getImm16(true);
            int countSequence = 1;
            int[] offsets = null;
            int[] registers = null;
            if (!context.getCodeInstruction().isDelaySlot()) {
                int address = context.getCodeInstruction().getAddress() + 4;
                int opcodeMask = -2097152;
                int i = 1;
                while (true) {
                    CodeInstruction nextCodeInstruction = context.getCodeInstruction(address);
                    boolean isSequence = false;
                    if (nextCodeInstruction != null && !nextCodeInstruction.isBranchTarget() && (nextCodeInstruction.getOpcode() & 0xFFE00000) == (insn & 0xFFE00000)) {
                        if (offsets == null) {
                            offsets = new int[2];
                            registers = new int[2];
                            offsets[0] = simm16;
                            registers[0] = context.getRtRegisterIndex();
                        } else {
                            offsets = Utilities.extendArray(offsets, 1);
                            registers = Utilities.extendArray(registers, 1);
                        }
                        offsets[i] = nextCodeInstruction.getImm16(true);
                        registers[i] = nextCodeInstruction.getRtRegisterIndex();
                        isSequence = true;
                    }
                    if (!isSequence) break;
                    ++countSequence;
                    ++i;
                    address += 4;
                }
            }
            if (countSequence > 1 && context.compileSWsequence(rs, offsets, registers)) {
                if (countSequence > 1) {
                    if (Compiler.log.isDebugEnabled()) {
                        SequenceSWCodeInstruction sequence = new SequenceSWCodeInstruction(rs, offsets, registers);
                        sequence.setAddress(context.getCodeInstruction().getAddress());
                        Compiler.log.debug((Object)String.format("CodeInstruction.compile %s", sequence));
                    }
                    context.skipInstructions(countSequence - 1, false);
                }
            } else {
                context.prepareMemWrite32(rs, simm16);
                context.loadRt();
                context.memWrite32(rs, simm16);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTIMMRS("sw", rt, rs, (short)imm16);
        }
    };
    public static final Common.Instruction SWL = new Common.Instruction(111){

        @Override
        public final String name() {
            return "SWL";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doSWL(rt, rs, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileRTRSIMM("doSWL", true);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTIMMRS("swl", rt, rs, (short)imm16);
        }
    };
    public static final Common.Instruction SWR = new Common.Instruction(112){

        @Override
        public final String name() {
            return "SWR";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doSWR(rt, rs, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileRTRSIMM("doSWR", true);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTIMMRS("swr", rt, rs, (short)imm16);
        }
    };
    public static final Common.Instruction LL = new Common.Instruction(113){

        @Override
        public final String name() {
            return "LL";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doLL(rt, rs, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileRTRSIMM("doLL", true);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTIMMRS("ll", rt, rs, (short)imm16);
        }
    };
    public static final Common.Instruction LWC1 = new Common.Instruction(114){

        @Override
        public final String name() {
            return "LWC1";
        }

        @Override
        public final String category() {
            return "MIPS I/FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int ft = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doLWC1(ft, rs, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.prepareFtForStore();
            context.memRead32(context.getRsRegisterIndex(), context.getImm16(true));
            context.getMethodVisitor().visitMethodInsn(184, Type.getInternalName(Float.class), "intBitsToFloat", "(I)F");
            context.storeFt();
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int ft = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmFTIMMRS("lwc1", ft, rs, (short)imm16);
        }
    };
    public static final Common.Instruction LVS = new Common.Instruction(115){

        @Override
        public final String name() {
            return "LVS";
        }

        @Override
        public final String category() {
            return "MIPS I/VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vt2 = insn >> 0 & 3;
            int imm14 = insn >> 2 & 0x3FFF;
            int vt5 = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doLVS(vt5 | vt2 << 5, rs, (short)(imm14 << 2));
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vt2 = insn >> 0 & 3;
            int vt5 = insn >> 16 & 0x1F;
            int vt = vt5 | vt2 << 5;
            int simm14 = context.getImm14(true);
            int rs = context.getRsRegisterIndex();
            context.prepareVtForStoreInt(1, vt, 0);
            context.memRead32(rs, simm14);
            context.storeVtInt(1, vt, 0);
        }

        @Override
        public String disasm(int address, int insn) {
            int vt2 = insn >> 0 & 3;
            int imm14 = insn >> 2 & 0x3FFF;
            int vt5 = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmVTIMMRS("lv", 1, vt5 | vt2 << 5, rs, (short)(imm14 << 2));
        }
    };
    public static final Common.Instruction LVLQ = new Common.Instruction(116){

        @Override
        public final String name() {
            return "LVLQ";
        }

        @Override
        public final String category() {
            return "MIPS I/VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vt1 = insn >> 0 & 1;
            int imm14 = insn >> 2 & 0x3FFF;
            int vt5 = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doLVLQ(vt5 | vt1 << 5, rs, (short)(imm14 << 2));
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vt1 = insn >> 0 & 1;
            int imm14 = insn >> 2 & 0x3FFF;
            int vt5 = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmVTIMMRS("lvl", 4, vt5 | vt1 << 5, rs, (short)(imm14 << 2));
        }
    };
    public static final Common.Instruction LVRQ = new Common.Instruction(117){

        @Override
        public final String name() {
            return "LVRQ";
        }

        @Override
        public final String category() {
            return "MIPS I/VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vt1 = insn >> 0 & 1;
            int imm14 = insn >> 2 & 0x3FFF;
            int vt5 = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doLVRQ(vt5 | vt1 << 5, rs, (short)(imm14 << 2));
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vt1 = insn >> 0 & 1;
            int imm14 = insn >> 2 & 0x3FFF;
            int vt5 = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmVTIMMRS("lvr", 4, vt5 | vt1 << 5, rs, (short)(imm14 << 2));
        }
    };
    public static final Common.Instruction LVQ = new Common.Instruction(118){

        @Override
        public final String name() {
            return "LVQ";
        }

        @Override
        public final String category() {
            return "MIPS I/VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vt1 = insn >> 0 & 1;
            int imm14 = insn >> 2 & 0x3FFF;
            int vt5 = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doLVQ(vt5 | vt1 << 5, rs, (short)(imm14 << 2));
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vt1 = insn >> 0 & 1;
            int vt5 = insn >> 16 & 0x1F;
            int vt = vt5 | vt1 << 5;
            int simm14 = context.getImm14(true);
            int rs = context.getRsRegisterIndex();
            int vsize = 4;
            int countSequence = 1;
            int address = context.getCodeInstruction().getAddress();
            int opcodeMask = -2097149;
            int i = 1;
            while (true) {
                CodeInstruction nextCodeInstruction = context.getCodeInstruction(address + i * 4);
                boolean isSequence = false;
                if (nextCodeInstruction != null) {
                    int nextVt5;
                    int nextSimm14;
                    int nextInsn = nextCodeInstruction.getOpcode();
                    if (nextCodeInstruction != null && (nextInsn & 0xFFE00003) == (insn & 0xFFE00003) && (nextSimm14 = nextCodeInstruction.getImm14(true)) == simm14 + i * 16 && (nextVt5 = nextInsn >> 16 & 0x1F) == vt5 + i) {
                        isSequence = true;
                    }
                }
                if (!isSequence) break;
                ++countSequence;
                ++i;
            }
            if (context.compileVFPULoad(context.getRsRegisterIndex(), simm14, vt, countSequence * 4)) {
                if (countSequence > 1) {
                    if (Compiler.log.isDebugEnabled()) {
                        Compiler.log.debug((Object)String.format("lv.q sequence 0x%08X-0x%08X", address, address + countSequence * 4 - 4));
                    }
                    context.skipInstructions(countSequence - 1, false);
                }
            } else {
                for (int n = 0; n < 4; ++n) {
                    context.prepareVtForStoreInt(4, vt, n);
                    context.memRead32(rs, simm14 + n * 4);
                    context.storeVtInt(4, vt, n);
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int vt1 = insn >> 0 & 1;
            int imm14 = insn >> 2 & 0x3FFF;
            int vt5 = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmVTIMMRS("lv", 4, vt5 | vt1 << 5, rs, (short)(imm14 << 2));
        }
    };
    public static final Common.Instruction SC = new Common.Instruction(119){

        @Override
        public final String name() {
            return "SC";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doSC(rt, rs, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int rs = context.getRsRegisterIndex();
            int simm16 = context.getImm16(true);
            context.prepareMemWrite32(rs, simm16);
            context.loadRt();
            context.memWrite32(rs, simm16);
            if (!context.isRtRegister0()) {
                context.storeRt(1);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int rt = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmRTIMMRS("sc", rt, rs, (short)imm16);
        }
    };
    public static final Common.Instruction SWC1 = new Common.Instruction(120){

        @Override
        public final String name() {
            return "SWC1";
        }

        @Override
        public final String category() {
            return "MIPS I/FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int ft = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doSWC1(ft, rs, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int rs = context.getRsRegisterIndex();
            int simm16 = context.getImm16(true);
            context.prepareMemWrite32(rs, simm16);
            context.loadFt();
            context.getMethodVisitor().visitMethodInsn(184, Type.getInternalName(Float.class), "floatToRawIntBits", "(F)I");
            context.memWrite32(rs, simm16);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int ft = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmFTIMMRS("swc1", ft, rs, (short)imm16);
        }
    };
    public static final Common.Instruction SVS = new Common.Instruction(121){

        @Override
        public final String name() {
            return "SVS";
        }

        @Override
        public final String category() {
            return "MIPS I/VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vt2 = insn >> 0 & 3;
            int imm14 = insn >> 2 & 0x3FFF;
            int vt5 = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doSVS(vt5 | vt2 << 5, rs, (short)(imm14 << 2));
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vt2 = insn >> 0 & 3;
            int vt5 = insn >> 16 & 0x1F;
            int vt = vt5 | vt2 << 5;
            int simm14 = context.getImm14(true);
            int rs = context.getRsRegisterIndex();
            context.prepareMemWrite32(rs, simm14);
            context.loadVtInt(1, vt, 0);
            context.memWrite32(rs, simm14);
        }

        @Override
        public String disasm(int address, int insn) {
            int vt2 = insn >> 0 & 3;
            int imm14 = insn >> 2 & 0x3FFF;
            int vt5 = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmVTIMMRS("sv", 1, vt5 | vt2 << 5, rs, (short)(imm14 << 2));
        }
    };
    public static final Common.Instruction SVLQ = new Common.Instruction(122){

        @Override
        public final String name() {
            return "SVLQ";
        }

        @Override
        public final String category() {
            return "MIPS I/VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vt1 = insn >> 0 & 1;
            int imm14 = insn >> 2 & 0x3FFF;
            int vt5 = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doSVLQ(vt5 | vt1 << 5, rs, (short)(imm14 << 2));
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vt1 = insn >> 0 & 1;
            int imm14 = insn >> 2 & 0x3FFF;
            int vt5 = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmVTIMMRS("svl", 4, vt5 | vt1 << 5, rs, (short)(imm14 << 2));
        }
    };
    public static final Common.Instruction SVRQ = new Common.Instruction(123){

        @Override
        public final String name() {
            return "SVRQ";
        }

        @Override
        public final String category() {
            return "MIPS I/VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vt1 = insn >> 0 & 1;
            int imm14 = insn >> 2 & 0x3FFF;
            int vt5 = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doSVRQ(vt5 | vt1 << 5, rs, (short)(imm14 << 2));
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vt1 = insn >> 0 & 1;
            int imm14 = insn >> 2 & 0x3FFF;
            int vt5 = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmVTIMMRS("svr", 4, vt5 | vt1 << 5, rs, (short)(imm14 << 2));
        }
    };
    public static final Common.Instruction SVQ = new Common.Instruction(124){

        @Override
        public final String name() {
            return "SVQ";
        }

        @Override
        public final String category() {
            return "MIPS I/VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vt1 = insn >> 0 & 1;
            int imm14 = insn >> 2 & 0x3FFF;
            int vt5 = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            processor.cpu.doSVQ(vt5 | vt1 << 5, rs, (short)(imm14 << 2));
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vt1 = insn >> 0 & 1;
            int vt5 = insn >> 16 & 0x1F;
            int vt = vt5 | vt1 << 5;
            int simm14 = context.getImm14(true);
            int rs = context.getRsRegisterIndex();
            int vsize = 4;
            int countSequence = 1;
            int address = context.getCodeInstruction().getAddress();
            int opcodeMask = -2097151;
            for (int i = 1; i < 4; ++i) {
                CodeInstruction nextCodeInstruction = context.getCodeInstruction(address + i * 4);
                boolean isSequence = false;
                if (nextCodeInstruction != null) {
                    int nextVt5;
                    int nextSimm14;
                    int nextInsn = nextCodeInstruction.getOpcode();
                    if (nextCodeInstruction != null && (nextInsn & 0xFFE00001) == (insn & 0xFFE00001) && (nextSimm14 = nextCodeInstruction.getImm14(true)) == simm14 + i * 16 && (nextVt5 = nextInsn >> 16 & 0x1F) == vt5 + i) {
                        isSequence = true;
                    }
                }
                if (!isSequence) break;
                ++countSequence;
            }
            if (context.compileVFPUStore(context.getRsRegisterIndex(), simm14, vt, countSequence * 4)) {
                if (countSequence > 1) {
                    if (Compiler.log.isDebugEnabled()) {
                        Compiler.log.debug((Object)String.format("sv.q sequence 0x%08X-0x%08X", address, address + countSequence * 4 - 4));
                    }
                    context.skipInstructions(countSequence - 1, false);
                }
            } else {
                for (int n = 0; n < vsize; ++n) {
                    context.prepareMemWrite32(rs, simm14 + n * 4);
                    context.loadVtInt(vsize, vt, n);
                    context.memWrite32(rs, simm14 + n * 4);
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int vt1 = insn >> 0 & 1;
            int imm14 = insn >> 2 & 0x3FFF;
            int vt5 = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmVTIMMRS("sv", 4, vt5 | vt1 << 5, rs, (short)(imm14 << 2));
        }
    };
    public static final Common.Instruction VWB = new Common.Instruction(125){

        @Override
        public final String name() {
            return "VWB";
        }

        @Override
        public final String category() {
            return "MIPS I/VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            SVQ.interpret(processor, insn);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            SVQ.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vt1 = insn >> 0 & 1;
            int imm14 = insn >> 2 & 0x3FFF;
            int vt5 = insn >> 16 & 0x1F;
            int rs = insn >> 21 & 0x1F;
            return Common.disasmVTIMMRS("vwb", 4, vt5 | vt1 << 5, rs, (short)(imm14 << 2));
        }
    };
    public static final Common.Instruction ADD_S = new Common.Instruction(126){

        @Override
        public final String name() {
            return "ADD.S";
        }

        @Override
        public final String category() {
            return "FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            int ft = insn >> 16 & 0x1F;
            processor.cpu.doADDS(fd, fs, ft);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.prepareFdForStore();
            context.loadFs();
            context.loadFt();
            context.getMethodVisitor().visitInsn(98);
            context.storeFd();
        }

        @Override
        public String disasm(int address, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            int ft = insn >> 16 & 0x1F;
            return Common.disasmFDFSFT("add.s", fd, fs, ft);
        }
    };
    public static final Common.Instruction SUB_S = new Common.Instruction(127){

        @Override
        public final String name() {
            return "SUB.S";
        }

        @Override
        public final String category() {
            return "FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            int ft = insn >> 16 & 0x1F;
            processor.cpu.doSUBS(fd, fs, ft);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.prepareFdForStore();
            context.loadFs();
            context.loadFt();
            context.getMethodVisitor().visitInsn(102);
            context.storeFd();
        }

        @Override
        public String disasm(int address, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            int ft = insn >> 16 & 0x1F;
            return Common.disasmFDFSFT("sub.s", fd, fs, ft);
        }
    };
    public static final Common.Instruction MUL_S = new Common.Instruction(128){

        @Override
        public final String name() {
            return "MUL.S";
        }

        @Override
        public final String category() {
            return "FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            int ft = insn >> 16 & 0x1F;
            processor.cpu.doMULS(fd, fs, ft);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.prepareFdForStore();
            context.loadFs();
            context.loadFt();
            context.getMethodVisitor().visitInsn(106);
            context.storeFd();
        }

        @Override
        public String disasm(int address, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            int ft = insn >> 16 & 0x1F;
            return Common.disasmFDFSFT("mul.s", fd, fs, ft);
        }
    };
    public static final Common.Instruction DIV_S = new Common.Instruction(129){

        @Override
        public final String name() {
            return "DIV.S";
        }

        @Override
        public final String category() {
            return "FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            int ft = insn >> 16 & 0x1F;
            processor.cpu.doDIVS(fd, fs, ft);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.prepareFdForStore();
            context.loadFs();
            context.loadFt();
            context.getMethodVisitor().visitInsn(110);
            context.storeFd();
        }

        @Override
        public String disasm(int address, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            int ft = insn >> 16 & 0x1F;
            return Common.disasmFDFSFT("div.s", fd, fs, ft);
        }
    };
    public static final Common.Instruction SQRT_S = new Common.Instruction(130){

        @Override
        public final String name() {
            return "SQRT.S";
        }

        @Override
        public final String category() {
            return "FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            processor.cpu.doSQRTS(fd, fs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.prepareFdForStore();
            context.loadFs();
            context.getMethodVisitor().visitInsn(141);
            context.getMethodVisitor().visitMethodInsn(184, Type.getInternalName(Math.class), "sqrt", "(D)D");
            context.getMethodVisitor().visitInsn(144);
            context.storeFd();
        }

        @Override
        public String disasm(int address, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            return Common.disasmFDFS("sqrt.s", fd, fs);
        }
    };
    public static final Common.Instruction ABS_S = new Common.Instruction(131){

        @Override
        public final String name() {
            return "ABS.S";
        }

        @Override
        public final String category() {
            return "FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            processor.cpu.doABSS(fd, fs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.prepareFdForStore();
            context.loadFs();
            context.getMethodVisitor().visitMethodInsn(184, Type.getInternalName(Math.class), "abs", "(F)F");
            context.storeFd();
        }

        @Override
        public String disasm(int address, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            return Common.disasmFDFS("abs.s", fd, fs);
        }
    };
    public static final Common.Instruction MOV_S = new Common.Instruction(132){

        @Override
        public final String name() {
            return "MOV.S";
        }

        @Override
        public final String category() {
            return "FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            processor.cpu.doMOVS(fd, fs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.prepareFdForStore();
            context.loadFs();
            context.storeFd();
        }

        @Override
        public String disasm(int address, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            return Common.disasmFDFS("mov.s", fd, fs);
        }
    };
    public static final Common.Instruction NEG_S = new Common.Instruction(133){

        @Override
        public final String name() {
            return "NEG.S";
        }

        @Override
        public final String category() {
            return "FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            processor.cpu.doNEGS(fd, fs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.prepareFdForStore();
            context.loadFs();
            context.getMethodVisitor().visitInsn(118);
            context.storeFd();
        }

        @Override
        public String disasm(int address, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            return Common.disasmFDFS("neg.s", fd, fs);
        }
    };
    public static final Common.Instruction ROUND_W_S = new Common.Instruction(134){

        @Override
        public final String name() {
            return "ROUND.W.S";
        }

        @Override
        public final String category() {
            return "FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            processor.cpu.doROUNDWS(fd, fs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.prepareFdForStore();
            context.loadFs();
            context.getMethodVisitor().visitMethodInsn(184, Type.getInternalName(Math.class), "round", "(F)I");
            context.getMethodVisitor().visitMethodInsn(184, Type.getInternalName(Float.class), "intBitsToFloat", "(I)F");
            context.storeFd();
        }

        @Override
        public String disasm(int address, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            return Common.disasmFDFS("round.w.s", fd, fs);
        }
    };
    public static final Common.Instruction TRUNC_W_S = new Common.Instruction(135){

        @Override
        public final String name() {
            return "TRUNC.W.S";
        }

        @Override
        public final String category() {
            return "FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            processor.cpu.doTRUNCWS(fd, fs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.prepareFdForStore();
            context.loadFs();
            context.getMethodVisitor().visitInsn(139);
            context.getMethodVisitor().visitMethodInsn(184, Type.getInternalName(Float.class), "intBitsToFloat", "(I)F");
            context.storeFd();
        }

        @Override
        public String disasm(int address, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            return Common.disasmFDFS("trunc.w.s", fd, fs);
        }
    };
    public static final Common.Instruction CEIL_W_S = new Common.Instruction(136){

        @Override
        public final String name() {
            return "CEIL.W.S";
        }

        @Override
        public final String category() {
            return "FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            processor.cpu.doCEILWS(fd, fs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.prepareFdForStore();
            context.loadFs();
            context.getMethodVisitor().visitInsn(141);
            context.getMethodVisitor().visitMethodInsn(184, Type.getInternalName(Math.class), "ceil", "(D)D");
            context.getMethodVisitor().visitInsn(142);
            context.getMethodVisitor().visitMethodInsn(184, Type.getInternalName(Float.class), "intBitsToFloat", "(I)F");
            context.storeFd();
        }

        @Override
        public String disasm(int address, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            return Common.disasmFDFS("ceil.w.s", fd, fs);
        }
    };
    public static final Common.Instruction FLOOR_W_S = new Common.Instruction(137){

        @Override
        public final String name() {
            return "FLOOR.W.S";
        }

        @Override
        public final String category() {
            return "FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            processor.cpu.doFLOORWS(fd, fs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.prepareFdForStore();
            context.loadFs();
            context.getMethodVisitor().visitInsn(141);
            context.getMethodVisitor().visitMethodInsn(184, Type.getInternalName(Math.class), "floor", "(D)D");
            context.getMethodVisitor().visitInsn(142);
            context.getMethodVisitor().visitMethodInsn(184, Type.getInternalName(Float.class), "intBitsToFloat", "(I)F");
            context.storeFd();
        }

        @Override
        public String disasm(int address, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            return Common.disasmFDFS("floor.w.s", fd, fs);
        }
    };
    public static final Common.Instruction CVT_S_W = new Common.Instruction(138){

        @Override
        public final String name() {
            return "CVT.S.W";
        }

        @Override
        public final String category() {
            return "FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            processor.cpu.doCVTSW(fd, fs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.prepareFdForStore();
            context.loadFs();
            context.getMethodVisitor().visitMethodInsn(184, Type.getInternalName(Float.class), "floatToRawIntBits", "(F)I");
            context.getMethodVisitor().visitInsn(134);
            context.storeFd();
        }

        @Override
        public String disasm(int address, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            return Common.disasmFDFS("cvt.s.w", fd, fs);
        }
    };
    public static final Common.Instruction CVT_W_S = new Common.Instruction(139){

        @Override
        public final String name() {
            return "CVT.W.S";
        }

        @Override
        public final String category() {
            return "FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            processor.cpu.doCVTWS(fd, fs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int fd = insn >> 6 & 0x1F;
            int fs = insn >> 11 & 0x1F;
            return Common.disasmFDFS("cvt.w.s", fd, fs);
        }
    };
    public static final Common.Instruction C_COND_S = new Common.Instruction(140){

        @Override
        public final String name() {
            return "C.COND.S";
        }

        @Override
        public final String category() {
            return "FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int fcond = insn >> 0 & 0xF;
            int fs = insn >> 11 & 0x1F;
            int ft = insn >> 16 & 0x1F;
            processor.cpu.doCCONDS(fs, ft, fcond);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            boolean less;
            int fcond = insn >> 0 & 0xF;
            Label isNaN = new Label();
            Label isNotNaN = new Label();
            Label continueLabel = new Label();
            Label trueLabel = new Label();
            context.prepareFcr31cForStore();
            context.loadFt();
            context.storeFTmp2();
            context.loadFs();
            context.getMethodVisitor().visitInsn(89);
            context.storeFTmp1();
            context.getMethodVisitor().visitMethodInsn(184, Type.getInternalName(Float.class), "isNaN", "(F)Z");
            context.getMethodVisitor().visitJumpInsn(154, isNaN);
            context.loadFTmp2();
            context.getMethodVisitor().visitMethodInsn(184, Type.getInternalName(Float.class), "isNaN", "(F)Z");
            context.getMethodVisitor().visitJumpInsn(153, isNotNaN);
            context.getMethodVisitor().visitLabel(isNaN);
            context.getMethodVisitor().visitInsn((fcond & 1) != 0 ? 4 : 3);
            context.getMethodVisitor().visitJumpInsn(167, continueLabel);
            context.getMethodVisitor().visitLabel(isNotNaN);
            boolean equal = (fcond & 2) != 0;
            boolean bl = less = (fcond & 4) != 0;
            if (!equal && !less) {
                context.getMethodVisitor().visitInsn(3);
            } else {
                int testOpcode = equal ? (less ? 158 : 153) : 155;
                context.loadFTmp1();
                context.loadFTmp2();
                context.getMethodVisitor().visitInsn(149);
                context.getMethodVisitor().visitJumpInsn(testOpcode, trueLabel);
                context.getMethodVisitor().visitInsn(3);
                context.getMethodVisitor().visitJumpInsn(167, continueLabel);
                context.getMethodVisitor().visitLabel(trueLabel);
                context.getMethodVisitor().visitInsn(4);
            }
            context.getMethodVisitor().visitLabel(continueLabel);
            context.storeFcr31c();
        }

        @Override
        public String disasm(int address, int insn) {
            int fcond = insn >> 0 & 0xF;
            int fs = insn >> 11 & 0x1F;
            int ft = insn >> 16 & 0x1F;
            return Common.disasmCcondS(fcond, fs, ft);
        }
    };
    public static final Common.Instruction MFC1 = new Common.Instruction(141, 8192){

        @Override
        public final String name() {
            return "MFC1";
        }

        @Override
        public final String category() {
            return "MIPS I/FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int c1dr = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            processor.cpu.doMFC1(rt, c1dr);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRtRegister0()) {
                context.prepareRtForStore();
                context.loadFCr();
                context.getMethodVisitor().visitMethodInsn(184, Type.getInternalName(Float.class), "floatToRawIntBits", "(F)I");
                context.storeRt();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int c1dr = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            return Common.disasmRTFS("mfc1", rt, c1dr);
        }
    };
    public static final Common.Instruction CFC1 = new Common.Instruction(142){

        @Override
        public final String name() {
            return "CFC1";
        }

        @Override
        public final String category() {
            return "MIPS I/FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int c1cr = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            processor.cpu.doCFC1(rt, c1cr);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int c1cr = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            return Common.disasmRTFC("cfc1", rt, c1cr);
        }
    };
    public static final Common.Instruction MTC1 = new Common.Instruction(143){

        @Override
        public final String name() {
            return "MTC1";
        }

        @Override
        public final String category() {
            return "MIPS I/FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int c1dr = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            processor.cpu.doMTC1(rt, c1dr);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.prepareFCrForStore();
            context.loadRt();
            context.getMethodVisitor().visitMethodInsn(184, Type.getInternalName(Float.class), "intBitsToFloat", "(I)F");
            context.storeFCr();
        }

        @Override
        public String disasm(int address, int insn) {
            int c1dr = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            return Common.disasmRTFS("mtc1", rt, c1dr);
        }
    };
    public static final Common.Instruction CTC1 = new Common.Instruction(144){

        @Override
        public final String name() {
            return "CTC1";
        }

        @Override
        public final String category() {
            return "MIPS I/FPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int c1cr = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            processor.cpu.doCTC1(rt, c1cr);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int c1cr = insn >> 11 & 0x1F;
            int rt = insn >> 16 & 0x1F;
            return Common.disasmRTFC("ctc1", rt, c1cr);
        }
    };
    public static final Common.Instruction MFC0 = new Common.Instruction(145){

        @Override
        public final String name() {
            return "MFC0";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            return "Unimplemented MFC0";
        }
    };
    public static final Common.Instruction CFC0 = new Common.Instruction(146){

        @Override
        public final String name() {
            return "CFC0";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            return "Unimplemented CFC0";
        }
    };
    public static final Common.Instruction MTC0 = new Common.Instruction(147){

        @Override
        public final String name() {
            return "MTC0";
        }

        @Override
        public final String category() {
            return "MIPS I";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            return "Unimplemented MTC0";
        }
    };
    public static final Common.Instruction CTC0 = new Common.Instruction(148){

        @Override
        public final String name() {
            return "CTC0";
        }

        @Override
        public final String category() {
            return "ALLEGREX";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            return "Unimplemented CTC0";
        }
    };
    public static final Common.Instruction VADD = new Common.Instruction(149, 5888){

        @Override
        public final String name() {
            return "VADD";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVADD(1 + one + (two << 1), vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileVFPUInstr(null, 98, null);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSVT("vadd", 1 + one + (two << 1), vd, vs, vt);
        }
    };
    public static final Common.Instruction VSUB = new Common.Instruction(150, 5888){

        @Override
        public final String name() {
            return "VSUB";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVSUB(1 + one + (two << 1), vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileVFPUInstr(null, 102, null);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSVT("vsub", 1 + one + (two << 1), vd, vs, vt);
        }
    };
    public static final Common.Instruction VSBN = new Common.Instruction(151, 5888){

        @Override
        public final String name() {
            return "VSBN";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVSBN(1 + one + (two << 1), vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = context.getVsize();
            if (vsize == 1) {
                context.startPfxCompiled();
                for (int n = 0; n < vsize; ++n) {
                    context.prepareVdForStore(n);
                    context.loadVs(n);
                    context.loadVtInt(n);
                    context.getMethodVisitor().visitMethodInsn(184, Type.getInternalName(Math.class), "scalb", "(FI)F");
                    context.storeVd(n);
                }
                context.endPfxCompiled();
            } else {
                context.compileInterpreterInstruction();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSVT("vsbn", 1 + one + (two << 1), vd, vs, vt);
        }
    };
    public static final Common.Instruction VDIV = new Common.Instruction(152, 5888){

        @Override
        public final String name() {
            return "VDIV";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVDIV(1 + one + (two << 1), vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileVFPUInstr(null, 110, null);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSVT("vdiv", 1 + one + (two << 1), vd, vs, vt);
        }
    };
    public static final Common.Instruction VMUL = new Common.Instruction(153, 5888){

        @Override
        public final String name() {
            return "VMUL";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVMUL(1 + one + (two << 1), vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileVFPUInstr(null, 106, null);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSVT("vmul", 1 + one + (two << 1), vd, vs, vt);
        }
    };
    public static final Common.Instruction VDOT = new Common.Instruction(154, 5888){

        @Override
        public final String name() {
            return "VDOT";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVDOT(1 + one + (two << 1), vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = context.getVsize();
            if (vsize > 1) {
                context.startPfxCompiled();
                context.prepareVdForStore(1, 0);
                context.loadVs(0);
                context.loadVt(0);
                context.getMethodVisitor().visitInsn(106);
                for (int n = 1; n < vsize; ++n) {
                    context.loadVs(n);
                    context.loadVt(n);
                    context.getMethodVisitor().visitInsn(106);
                    context.getMethodVisitor().visitInsn(98);
                }
                context.storeVd(1, 0);
                context.endPfxCompiled(1);
            } else {
                context.compileInterpreterInstruction();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVD1VSVT("vdot", 1 + one + (two << 1), vd, vs, vt);
        }
    };
    public static final Common.Instruction VSCL = new Common.Instruction(155, 5888){

        @Override
        public final String name() {
            return "VSCL";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVSCL(1 + one + (two << 1), vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = context.getVsize();
            if (vsize > 1) {
                context.startPfxCompiled();
                context.loadVt(1, 0);
                context.storeFTmp1();
                for (int n = 0; n < vsize; ++n) {
                    context.prepareVdForStore(n);
                    context.loadVs(n);
                    context.loadFTmp1();
                    context.getMethodVisitor().visitInsn(106);
                    context.storeVd(n);
                }
                context.endPfxCompiled();
            } else {
                context.compileInterpreterInstruction();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSVT1("vscl", 1 + one + (two << 1), vd, vs, vt);
        }
    };
    public static final Common.Instruction VHDP = new Common.Instruction(156, 5888){

        @Override
        public final String name() {
            return "VHDP";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVHDP(1 + one + (two << 1), vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = context.getVsize();
            if (vsize > 1) {
                context.startPfxCompiled();
                context.prepareVdForStore(1, 0);
                context.loadVs(0);
                context.loadVt(0);
                context.getMethodVisitor().visitInsn(106);
                for (int n = 1; n < vsize - 1; ++n) {
                    context.loadVs(n);
                    context.loadVt(n);
                    context.getMethodVisitor().visitInsn(106);
                    context.getMethodVisitor().visitInsn(98);
                }
                context.loadVt(vsize - 1);
                context.getMethodVisitor().visitInsn(98);
                context.storeVd(1, 0);
                context.endPfxCompiled(1);
            } else {
                context.compileInterpreterInstruction();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVD1VSVT("vhdp", 1 + one + (two << 1), vd, vs, vt);
        }
    };
    public static final Common.Instruction VCRS = new Common.Instruction(157, 1792){

        @Override
        public final String name() {
            return "VCRS";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVCRS(1 + one + (two << 1), vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSVT("vcrs", 1 + one + (two << 1), vd, vs, vt);
        }
    };
    public static final Common.Instruction VDET = new Common.Instruction(158, 1792){

        @Override
        public final String name() {
            return "VDET";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVDET(1 + one + (two << 1), vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVD1VSVT("vdet", 1 + one + (two << 1), vd, vs, vt);
        }
    };
    public static final Common.Instruction MFV = new Common.Instruction(159, 8192){

        @Override
        public final String name() {
            return "MFV";
        }

        @Override
        public final String category() {
            return "MIPS I/VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm7 = insn >> 0 & 0x7F;
            int rt = insn >> 16 & 0x1F;
            processor.cpu.doMFV(rt, imm7);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRtRegister0()) {
                context.prepareRtForStore();
                context.loadVdInt(1, 0);
                context.storeRt();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int imm7 = insn >> 0 & 0x7F;
            int rt = insn >> 16 & 0x1F;
            return Common.disasmVDRS("mfv", imm7, rt);
        }
    };
    public static final Common.Instruction MFVC = new Common.Instruction(160, 8192){

        @Override
        public final String name() {
            return "MFVC";
        }

        @Override
        public final String category() {
            return "MIPS I/VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm7 = insn >> 0 & 0x7F;
            int rt = insn >> 16 & 0x1F;
            processor.cpu.doMFVC(rt, imm7);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (!context.isRtRegister0()) {
                int imm7 = context.getImm7();
                MethodVisitor mv = context.getMethodVisitor();
                switch (imm7) {
                    case 3: {
                        context.prepareRtForStore();
                        context.loadVcrCc(5);
                        for (int i = 4; i >= 0; --i) {
                            context.loadImm(1);
                            mv.visitInsn(120);
                            context.loadVcrCc(i);
                            mv.visitInsn(128);
                        }
                        context.storeRt();
                        break;
                    }
                    default: {
                        super.compile(context, insn);
                    }
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int imm7 = insn >> 0 & 0x7F;
            int rt = insn >> 16 & 0x1F;
            return "Unimplemented MFVC imm7=" + imm7 + ", rt=" + rt;
        }
    };
    public static final Common.Instruction MTV = new Common.Instruction(161){

        @Override
        public final String name() {
            return "MTV";
        }

        @Override
        public final String category() {
            return "MIPS I/VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm7 = insn >> 0 & 0x7F;
            int rt = insn >> 16 & 0x1F;
            processor.cpu.doMTV(rt, imm7);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.prepareVdForStoreInt(1, 0);
            context.loadRt();
            context.storeVdInt(1, 0);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm7 = insn >> 0 & 0x7F;
            int rt = insn >> 16 & 0x1F;
            return Common.disasmVDRS("MTV", imm7, rt);
        }
    };
    public static final Common.Instruction MTVC = new Common.Instruction(162){

        @Override
        public final String name() {
            return "MTVC";
        }

        @Override
        public final String category() {
            return "MIPS I/VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm7 = insn >> 0 & 0x7F;
            int rt = insn >> 16 & 0x1F;
            processor.cpu.doMTVC(rt, imm7);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm7 = insn >> 0 & 0x7F;
            int rt = insn >> 16 & 0x1F;
            return "Unimplemented MTVC imm7=" + imm7 + ", rt=" + rt;
        }
    };
    public static final Common.Instruction VCMP = new Common.Instruction(163, 4864){

        @Override
        public final String name() {
            return "VCMP";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm4 = insn >> 0 & 0xF;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVCMP(1 + one + (two << 1), vs, vt, imm4);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int cond = context.getImm4();
            int vsize = context.getVsize();
            MethodVisitor mv = context.getMethodVisitor();
            boolean not = (cond & 4) != 0;
            context.startPfxCompiled();
            if ((cond & 8) == 0) {
                if ((cond & 3) == 0) {
                    int value = not ? 1 : 0;
                    for (int n = 0; n < vsize; ++n) {
                        context.prepareVcrCcForStore(n);
                        context.loadImm(value);
                        context.storeVcrCc(n);
                    }
                    context.prepareVcrCcForStore(4);
                    context.loadImm(value);
                    context.storeVcrCc(4);
                    context.prepareVcrCcForStore(5);
                    context.loadImm(value);
                    context.storeVcrCc(5);
                } else {
                    if (vsize > 1) {
                        context.loadImm(0);
                        context.storeTmp1();
                        context.loadImm(1);
                        context.storeTmp2();
                    }
                    for (int n = 0; n < vsize; ++n) {
                        context.prepareVcrCcForStore(n);
                        context.loadVs(n);
                        context.loadVt(n);
                        mv.visitInsn(not ? 149 : 150);
                        int opcodeCond = 0;
                        switch (cond & 3) {
                            case 1: {
                                opcodeCond = not ? 154 : 153;
                                break;
                            }
                            case 2: {
                                opcodeCond = not ? 156 : 155;
                                break;
                            }
                            case 3: {
                                opcodeCond = not ? 157 : 158;
                            }
                        }
                        Label trueLabel = new Label();
                        Label afterLabel = new Label();
                        mv.visitJumpInsn(opcodeCond, trueLabel);
                        context.loadImm(0);
                        if (vsize > 1) {
                            context.loadImm(0);
                            context.storeTmp2();
                        } else {
                            context.prepareVcrCcForStore(4);
                            context.loadImm(0);
                            context.storeVcrCc(4);
                            context.prepareVcrCcForStore(5);
                            context.loadImm(0);
                            context.storeVcrCc(5);
                        }
                        mv.visitJumpInsn(167, afterLabel);
                        mv.visitLabel(trueLabel);
                        context.loadImm(1);
                        if (vsize > 1) {
                            context.loadImm(1);
                            context.storeTmp1();
                        } else {
                            context.prepareVcrCcForStore(4);
                            context.loadImm(1);
                            context.storeVcrCc(4);
                            context.prepareVcrCcForStore(5);
                            context.loadImm(1);
                            context.storeVcrCc(5);
                        }
                        mv.visitLabel(afterLabel);
                        context.storeVcrCc(n);
                    }
                    if (vsize > 1) {
                        context.prepareVcrCcForStore(4);
                        context.loadTmp1();
                        context.storeVcrCc(4);
                        context.prepareVcrCcForStore(5);
                        context.loadTmp2();
                        context.storeVcrCc(5);
                    }
                }
            } else {
                if (vsize > 1) {
                    context.loadImm(0);
                    context.storeTmp1();
                    context.loadImm(1);
                    context.storeTmp2();
                }
                for (int n = 0; n < vsize; ++n) {
                    context.prepareVcrCcForStore(n);
                    context.loadVs(n);
                    boolean updateOrAnd = false;
                    switch (cond & 3) {
                        case 0: {
                            mv.visitMethodInsn(184, Type.getInternalName(Math.class), "abs", "(F)F");
                            mv.visitInsn(11);
                            mv.visitInsn(149);
                            Label trueLabel = new Label();
                            Label afterLabel = new Label();
                            mv.visitJumpInsn(not ? 154 : 153, trueLabel);
                            context.loadImm(0);
                            if (vsize > 1) {
                                context.loadImm(0);
                                context.storeTmp2();
                            } else {
                                context.prepareVcrCcForStore(4);
                                context.loadImm(0);
                                context.storeVcrCc(4);
                                context.prepareVcrCcForStore(5);
                                context.loadImm(0);
                                context.storeVcrCc(5);
                            }
                            mv.visitJumpInsn(167, afterLabel);
                            mv.visitLabel(trueLabel);
                            context.loadImm(1);
                            if (vsize > 1) {
                                context.loadImm(1);
                                context.storeTmp1();
                            } else {
                                context.prepareVcrCcForStore(4);
                                context.loadImm(1);
                                context.storeVcrCc(4);
                                context.prepareVcrCcForStore(5);
                                context.loadImm(1);
                                context.storeVcrCc(5);
                            }
                            mv.visitLabel(afterLabel);
                            break;
                        }
                        case 1: {
                            mv.visitMethodInsn(184, Type.getInternalName(Float.class), "isNaN", "(F)Z");
                            updateOrAnd = true;
                            break;
                        }
                        case 2: {
                            mv.visitMethodInsn(184, Type.getInternalName(Float.class), "isInfinite", "(F)Z");
                            updateOrAnd = true;
                            break;
                        }
                        case 3: {
                            mv.visitInsn(89);
                            mv.visitMethodInsn(184, Type.getInternalName(Float.class), "isNaN", "(F)Z");
                            mv.visitInsn(95);
                            mv.visitMethodInsn(184, Type.getInternalName(Float.class), "isInfinite", "(F)Z");
                            mv.visitInsn(128);
                            updateOrAnd = true;
                        }
                    }
                    if (updateOrAnd) {
                        if (not) {
                            context.loadImm(1);
                            mv.visitInsn(130);
                        }
                        if (vsize > 1) {
                            mv.visitInsn(89);
                            context.loadTmp1();
                            mv.visitInsn(128);
                            context.storeTmp1();
                            mv.visitInsn(89);
                            context.loadTmp2();
                            mv.visitInsn(126);
                            context.storeTmp2();
                        } else {
                            mv.visitInsn(89);
                            context.storeVcrCc(4);
                            mv.visitInsn(89);
                            context.storeVcrCc(5);
                        }
                    }
                    context.storeVcrCc(n);
                }
                if (vsize > 1) {
                    context.prepareVcrCcForStore(4);
                    context.loadTmp1();
                    context.storeVcrCc(4);
                    context.prepareVcrCcForStore(5);
                    context.loadTmp2();
                    context.storeVcrCc(5);
                }
            }
            context.endPfxCompiled();
        }

        @Override
        public String disasm(int address, int insn) {
            int imm4 = insn >> 0 & 0xF;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVCMP("vcmp", 1 + one + (two << 1), imm4, vs, vt);
        }
    };
    public static final Common.Instruction VMIN = new Common.Instruction(164, 5888){

        @Override
        public final String name() {
            return "VMIN";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVMIN(1 + one + (two << 1), vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileVFPUInstr(null, 0, "min");
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSVT("vmin", 1 + one + (two << 1), vd, vs, vt);
        }
    };
    public static final Common.Instruction VMAX = new Common.Instruction(165, 5888){

        @Override
        public final String name() {
            return "VMAX";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVMAX(1 + one + (two << 1), vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileVFPUInstr(null, 0, "max");
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSVT("vmax", 1 + one + (two << 1), vd, vs, vt);
        }
    };
    public static final Common.Instruction VSCMP = new Common.Instruction(166, 1792){

        @Override
        public final String name() {
            return "VSCMP";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVSCMP(1 + one + (two << 1), vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSVT("vscmp", 1 + one + (two << 1), vd, vs, vt);
        }
    };
    public static final Common.Instruction VSGE = new Common.Instruction(167, 5888){

        @Override
        public final String name() {
            return "VSGE";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVSGE(1 + one + (two << 1), vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = context.getVsize();
            context.startPfxCompiled();
            MethodVisitor mv = context.getMethodVisitor();
            for (int n = 0; n < vsize; ++n) {
                context.prepareVdForStore(n);
                context.loadVs(n);
                context.loadVt(n);
                mv.visitInsn(149);
                Label trueLabel = new Label();
                Label afterLabel = new Label();
                mv.visitJumpInsn(156, trueLabel);
                mv.visitInsn(11);
                mv.visitJumpInsn(167, afterLabel);
                mv.visitLabel(trueLabel);
                mv.visitInsn(12);
                mv.visitLabel(afterLabel);
                context.storeVd(n);
            }
            context.endPfxCompiled();
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSVT("vsge", 1 + one + (two << 1), vd, vs, vt);
        }
    };
    public static final Common.Instruction VSLT = new Common.Instruction(168, 5888){

        @Override
        public final String name() {
            return "VSLT";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVSLT(1 + one + (two << 1), vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = context.getVsize();
            context.startPfxCompiled();
            MethodVisitor mv = context.getMethodVisitor();
            for (int n = 0; n < vsize; ++n) {
                context.prepareVdForStore(n);
                context.loadVs(n);
                context.loadVt(n);
                mv.visitInsn(150);
                Label trueLabel = new Label();
                Label afterLabel = new Label();
                mv.visitJumpInsn(155, trueLabel);
                mv.visitInsn(11);
                mv.visitJumpInsn(167, afterLabel);
                mv.visitLabel(trueLabel);
                mv.visitInsn(12);
                mv.visitLabel(afterLabel);
                context.storeVd(n);
            }
            context.endPfxCompiled();
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSVT("vslt", 1 + one + (two << 1), vd, vs, vt);
        }
    };
    public static final Common.Instruction VMOV = new Common.Instruction(169, 7424){

        @Override
        public final String name() {
            return "VMOV";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVMOV(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileVFPUInstr(null, 0, null);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vmov", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VABS = new Common.Instruction(170, 5376){

        @Override
        public final String name() {
            return "VABS";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVABS(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileVFPUInstr(null, 0, "abs");
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vabs", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VNEG = new Common.Instruction(171, 5376){

        @Override
        public final String name() {
            return "VNEG";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVNEG(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileVFPUInstr(null, 118, null);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vneg", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VIDT = new Common.Instruction(172, 5120){

        @Override
        public final String name() {
            return "VIDT";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int two = insn >> 15 & 1;
            processor.cpu.doVIDT(1 + one + (two << 1), vd);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.startPfxCompiled();
            int vsize = context.getVsize();
            int id = context.getVdRegisterIndex() % vsize;
            for (int n = 0; n < vsize; ++n) {
                context.prepareVdForStore(n);
                context.getMethodVisitor().visitInsn(id == n ? 12 : 11);
                context.storeVd(n);
            }
            context.endPfxCompiled();
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int two = insn >> 15 & 1;
            return Common.disasmVD("vidt", 1 + one + (two << 1), vd);
        }
    };
    public static final Common.Instruction VSAT0 = new Common.Instruction(173, 5376){

        @Override
        public final String name() {
            return "VSAT0";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVSAT0(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = context.getVsize();
            MethodVisitor mv = context.getMethodVisitor();
            context.startPfxCompiled();
            for (int n = 0; n < vsize; ++n) {
                context.prepareVdForStore(n);
                context.loadVs(n);
                mv.visitInsn(89);
                mv.visitLdcInsn((Object)Float.valueOf(0.0f));
                mv.visitInsn(150);
                Label limitLabel = new Label();
                Label afterLabel = new Label();
                mv.visitJumpInsn(157, limitLabel);
                mv.visitInsn(87);
                mv.visitLdcInsn((Object)Float.valueOf(0.0f));
                mv.visitJumpInsn(167, afterLabel);
                mv.visitLabel(limitLabel);
                mv.visitInsn(89);
                mv.visitLdcInsn((Object)Float.valueOf(1.0f));
                mv.visitInsn(149);
                mv.visitJumpInsn(158, afterLabel);
                mv.visitInsn(87);
                mv.visitLdcInsn((Object)Float.valueOf(1.0f));
                mv.visitLabel(afterLabel);
                context.storeVd(n);
            }
            context.endPfxCompiled();
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vsat0", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VSAT1 = new Common.Instruction(174, 5376){

        @Override
        public final String name() {
            return "VSAT1";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVSAT1(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = context.getVsize();
            MethodVisitor mv = context.getMethodVisitor();
            context.startPfxCompiled();
            for (int n = 0; n < vsize; ++n) {
                context.prepareVdForStore(n);
                context.loadVs(n);
                mv.visitInsn(89);
                mv.visitLdcInsn((Object)Float.valueOf(-1.0f));
                mv.visitInsn(150);
                Label limitLabel = new Label();
                Label afterLabel = new Label();
                mv.visitJumpInsn(157, limitLabel);
                mv.visitInsn(87);
                mv.visitLdcInsn((Object)Float.valueOf(-1.0f));
                mv.visitJumpInsn(167, afterLabel);
                mv.visitLabel(limitLabel);
                mv.visitInsn(89);
                mv.visitLdcInsn((Object)Float.valueOf(1.0f));
                mv.visitInsn(149);
                mv.visitJumpInsn(158, afterLabel);
                mv.visitInsn(87);
                mv.visitLdcInsn((Object)Float.valueOf(1.0f));
                mv.visitLabel(afterLabel);
                context.storeVd(n);
            }
            context.endPfxCompiled();
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vsat1", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VZERO = new Common.Instruction(175, 5120){

        @Override
        public final String name() {
            return "VZERO";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int two = insn >> 15 & 1;
            processor.cpu.doVZERO(1 + one + (two << 1), vd);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.startPfxCompiled();
            int vsize = context.getVsize();
            for (int n = 0; n < vsize; ++n) {
                context.prepareVdForStore(n);
                context.getMethodVisitor().visitInsn(11);
                context.storeVd(n);
            }
            context.endPfxCompiled();
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int two = insn >> 15 & 1;
            return Common.disasmVD("vzero", 1 + one + (two << 1), vd);
        }
    };
    public static final Common.Instruction VONE = new Common.Instruction(176, 5120){

        @Override
        public final String name() {
            return "VONE";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int two = insn >> 15 & 1;
            processor.cpu.doVONE(1 + one + (two << 1), vd);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.startPfxCompiled();
            int vsize = context.getVsize();
            for (int n = 0; n < vsize; ++n) {
                context.prepareVdForStore(n);
                context.getMethodVisitor().visitInsn(12);
                context.storeVd(n);
            }
            context.endPfxCompiled();
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int two = insn >> 15 & 1;
            return Common.disasmVD("vone", 1 + one + (two << 1), vd);
        }
    };
    public static final Common.Instruction VRCP = new Common.Instruction(177, 5376){

        @Override
        public final String name() {
            return "VRCP";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVRCP(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileVFPUInstr(Float.valueOf(1.0f), 110, null);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vrcp", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VRSQ = new Common.Instruction(178, 5376){

        @Override
        public final String name() {
            return "VRSQ";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVRSQ(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileVFPUInstr(Float.valueOf(1.0f), 110, "sqrt");
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vrsq", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VSIN = new Common.Instruction(179, 1280){

        @Override
        public final String name() {
            return "VSIN";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVSIN(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vsin", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VCOS = new Common.Instruction(180, 1280){

        @Override
        public final String name() {
            return "VCOS";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVCOS(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vcos", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VEXP2 = new Common.Instruction(181, 1280){

        @Override
        public final String name() {
            return "VEXP2";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVEXP2(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vexp2", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VLOG2 = new Common.Instruction(182, 1280){

        @Override
        public final String name() {
            return "VLOG2";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVLOG2(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vlog2", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VSQRT = new Common.Instruction(183, 5376){

        @Override
        public final String name() {
            return "VSQRT";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVSQRT(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.compileVFPUInstr(null, 0, "sqrt");
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vsqrt", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VASIN = new Common.Instruction(184, 1280){

        @Override
        public final String name() {
            return "VASIN";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVASIN(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vasin", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VNRCP = new Common.Instruction(185, 1280){

        @Override
        public final String name() {
            return "VNRCP";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVNRCP(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vnrcp", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VNSIN = new Common.Instruction(186, 1280){

        @Override
        public final String name() {
            return "VNSIN";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVNSIN(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vnsin", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VREXP2 = new Common.Instruction(187, 1280){

        @Override
        public final String name() {
            return "VREXP2";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVREXP2(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vrexp2", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VRNDS = new Common.Instruction(188, 256){

        @Override
        public final String name() {
            return "VRNDS";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVRNDS(1 + one + (two << 1), vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVS("vrnds", 1 + one + (two << 1), vs);
        }
    };
    public static final Common.Instruction VRNDI = new Common.Instruction(189, 1024){

        @Override
        public final String name() {
            return "VRNDI";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int two = insn >> 15 & 1;
            processor.cpu.doVRNDI(1 + one + (two << 1), vd);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int two = insn >> 15 & 1;
            return Common.disasmVD("vrndi", 1 + one + (two << 1), vd);
        }
    };
    public static final Common.Instruction VRNDF1 = new Common.Instruction(190, 1024){

        @Override
        public final String name() {
            return "VRNDF1";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int two = insn >> 15 & 1;
            processor.cpu.doVRNDF1(1 + one + (two << 1), vd);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int two = insn >> 15 & 1;
            return Common.disasmVD("vrndf1", 1 + one + (two << 1), vd);
        }
    };
    public static final Common.Instruction VRNDF2 = new Common.Instruction(191, 1024){

        @Override
        public final String name() {
            return "VRNDF2";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int two = insn >> 15 & 1;
            processor.cpu.doVRNDF2(1 + one + (two << 1), vd);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int two = insn >> 15 & 1;
            return Common.disasmVD("vrndf2", 1 + one + (two << 1), vd);
        }
    };
    public static final Common.Instruction VF2H = new Common.Instruction(192, 1280){

        @Override
        public final String name() {
            return "VF2H";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVF2H(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vf2h", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VH2F = new Common.Instruction(193, 1280){

        @Override
        public final String name() {
            return "VH2F";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVH2F(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vh2f", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VSBZ = new Common.Instruction(194){

        @Override
        public final String name() {
            return "VSBZ";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVSBZ(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("VSBZ", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VLGB = new Common.Instruction(195){

        @Override
        public final String name() {
            return "VLGB";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVLGB(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vlgb", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VUC2I = new Common.Instruction(196, 1280){

        @Override
        public final String name() {
            return "VUC2I";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVUC2I(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vuc2i", 1 + one + (two << 1), 4, vd, vs);
        }
    };
    public static final Common.Instruction VC2I = new Common.Instruction(197, 1280){

        @Override
        public final String name() {
            return "VC2I";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVC2I(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("VC2I", 1 + one + (two << 1), 4, vd, vs);
        }
    };
    public static final Common.Instruction VUS2I = new Common.Instruction(198, 1280){

        @Override
        public final String name() {
            return "VUS2I";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVUS2I(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vus2i", 1 + one + (two << 1), 1 + (one << 1), vd, vs);
        }
    };
    public static final Common.Instruction VS2I = new Common.Instruction(199, 1280){

        @Override
        public final String name() {
            return "VS2I";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVS2I(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vs2i", 1 + one + (two << 1), 1 + (one << 1), vd, vs);
        }
    };
    public static final Common.Instruction VI2UC = new Common.Instruction(200, 5376){

        @Override
        public final String name() {
            return "VI2UC";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVI2UC(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = context.getVsize();
            if (vsize == 4) {
                MethodVisitor mv = context.getMethodVisitor();
                context.startPfxCompiled(false);
                context.prepareVdForStoreInt(1, 0);
                for (int n = 0; n < vsize; ++n) {
                    context.loadVsInt(n);
                    mv.visitInsn(89);
                    Label afterLabel = new Label();
                    Label negativeLabel = new Label();
                    mv.visitJumpInsn(155, negativeLabel);
                    context.loadImm(23);
                    mv.visitInsn(122);
                    if (n > 0) {
                        context.loadImm(n * 8);
                        mv.visitInsn(120);
                        mv.visitInsn(128);
                    }
                    mv.visitJumpInsn(167, afterLabel);
                    mv.visitLabel(negativeLabel);
                    mv.visitInsn(87);
                    if (n == 0) {
                        context.loadImm(0);
                    }
                    mv.visitLabel(afterLabel);
                }
                context.storeVdInt(1, 0);
                context.endPfxCompiled(1, false);
            } else {
                context.compileInterpreterInstruction();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVD1VS("vi2uc", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VI2C = new Common.Instruction(201, 1280){

        @Override
        public final String name() {
            return "VI2C";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVI2C(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVD1VS("vi2c", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VI2US = new Common.Instruction(202, 1280){

        @Override
        public final String name() {
            return "VI2US";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVI2US(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vi2us", 1 + one + (two << 1), 1 + two, vd, vs);
        }
    };
    public static final Common.Instruction VI2S = new Common.Instruction(203, 1280){

        @Override
        public final String name() {
            return "VI2S";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVI2S(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vi2s", 1 + one + (two << 1), 1 + two, vd, vs);
        }
    };
    public static final Common.Instruction VSRT1 = new Common.Instruction(204, 1280){

        @Override
        public final String name() {
            return "VSRT1";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVSRT1(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vsrt1", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VSRT2 = new Common.Instruction(205, 1280){

        @Override
        public final String name() {
            return "VSRT2";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVSRT2(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vsrt2", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VBFY1 = new Common.Instruction(206, 1280){

        @Override
        public final String name() {
            return "VBFY1";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVBFY1(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vbfy1", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VBFY2 = new Common.Instruction(207, 1280){

        @Override
        public final String name() {
            return "VBFY2";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVBFY2(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vbfy2", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VOCP = new Common.Instruction(208, 1280){

        @Override
        public final String name() {
            return "VOCP";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVOCP(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vocp", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VSOCP = new Common.Instruction(209, 1280){

        @Override
        public final String name() {
            return "VSOCP";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVSOCP(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vsocp", 1 + one + (two << 1), 1 + (one << 1), vd, vs);
        }
    };
    public static final Common.Instruction VFAD = new Common.Instruction(210, 1280){

        @Override
        public final String name() {
            return "VFAD";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVFAD(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVD1VS("vfad", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VAVG = new Common.Instruction(211, 1280){

        @Override
        public final String name() {
            return "VAVG";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVAVG(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVD1VS("vavg", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VSRT3 = new Common.Instruction(212, 1280){

        @Override
        public final String name() {
            return "VSRT3";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVSRT3(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vsrt3", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VSGN = new Common.Instruction(251, 1280){

        @Override
        public final String name() {
            return "VSGN";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVSGN(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vsgn", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VSRT4 = new Common.Instruction(213, 1280){

        @Override
        public final String name() {
            return "VSRT4";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVSRT4(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vsrt4", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VMFVC = new Common.Instruction(214, 1024){

        @Override
        public final String name() {
            return "VMFVC";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int imm7 = insn >> 8 & 0x7F;
            processor.cpu.doVMFVC(vd, imm7);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int imm7 = insn >> 8 & 0x7F;
            return "Unimplemented VMFVC imm7=" + imm7 + ", vd=" + vd;
        }
    };
    public static final Common.Instruction VMTVC = new Common.Instruction(215){

        @Override
        public final String name() {
            return "VMTVC";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm7 = insn >> 0 & 0x7F;
            int vs = insn >> 8 & 0x7F;
            processor.cpu.doVMTVC(vs, imm7);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int imm7 = insn >> 0 & 0x7F;
            int vs = insn >> 8 & 0x7F;
            return "Unimplemented VMTVC imm7=" + imm7 + ", vs=" + vs;
        }
    };
    public static final Common.Instruction VT4444 = new Common.Instruction(216, 1280){

        @Override
        public final String name() {
            return "VT4444";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVT4444(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vt4444", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VT5551 = new Common.Instruction(217, 1280){

        @Override
        public final String name() {
            return "VT5551";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVT5551(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vt5551", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VT5650 = new Common.Instruction(218, 1280){

        @Override
        public final String name() {
            return "VT5650";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVT5650(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDVS("vt5650", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VCST = new Common.Instruction(219, 5120){

        @Override
        public final String name() {
            return "VCST";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int two = insn >> 15 & 1;
            int imm5 = insn >> 16 & 0x1F;
            processor.cpu.doVCST(1 + one + (two << 1), vd, imm5);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int imm5 = insn >> 16 & 0x1F;
            float constant = 0.0f;
            if (imm5 < VfpuState.floatConstants.length) {
                constant = VfpuState.floatConstants[imm5];
            }
            context.startPfxCompiled();
            int vsize = context.getVsize();
            for (int n = 0; n < vsize; ++n) {
                context.prepareVdForStore(n);
                context.getMethodVisitor().visitLdcInsn((Object)Float.valueOf(constant));
                context.storeVd(n);
            }
            context.endPfxCompiled();
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int two = insn >> 15 & 1;
            int imm5 = insn >> 16 & 0x1F;
            return Common.disasmVDCST("VCST", 1 + one + (two << 1), vd, imm5);
        }
    };
    public static final Common.Instruction VF2IN = new Common.Instruction(220, 5376){

        @Override
        public final String name() {
            return "VF2IN";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int imm5 = insn >> 16 & 0x1F;
            processor.cpu.doVF2IN(1 + one + (two << 1), vd, vs, imm5);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = context.getVsize();
            int imm5 = context.getImm5();
            MethodVisitor mv = context.getMethodVisitor();
            context.startPfxCompiled(false);
            for (int n = 0; n < vsize; ++n) {
                context.prepareVdForStoreInt(n);
                context.loadVs(n);
                if (imm5 != 0) {
                    context.loadImm(imm5);
                    mv.visitMethodInsn(184, Type.getInternalName(Math.class), "scalb", "(FI)F");
                }
                Label afterLabel = new Label();
                Label notNaNValueLabel = new Label();
                mv.visitInsn(89);
                mv.visitMethodInsn(184, Type.getInternalName(Float.class), "isNaN", "(F)Z");
                mv.visitJumpInsn(153, notNaNValueLabel);
                mv.visitInsn(87);
                context.loadImm(Integer.MAX_VALUE);
                mv.visitJumpInsn(167, afterLabel);
                mv.visitLabel(notNaNValueLabel);
                mv.visitInsn(141);
                mv.visitMethodInsn(184, Type.getInternalName(Math.class), "rint", "(D)D");
                mv.visitInsn(142);
                mv.visitLabel(afterLabel);
                context.storeVdInt(n);
            }
            context.endPfxCompiled(false);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int imm5 = insn >> 16 & 0x1F;
            return Common.disasmVDVSIMM("vf2in", 1 + one + (two << 1), vd, vs, imm5);
        }
    };
    public static final Common.Instruction VF2IZ = new Common.Instruction(221, 5376){

        @Override
        public final String name() {
            return "VF2IZ";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int imm5 = insn >> 16 & 0x1F;
            processor.cpu.doVF2IZ(1 + one + (two << 1), vd, vs, imm5);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = context.getVsize();
            int imm5 = context.getImm5();
            MethodVisitor mv = context.getMethodVisitor();
            context.startPfxCompiled(false);
            for (int n = 0; n < vsize; ++n) {
                context.prepareVdForStoreInt(n);
                context.loadVs(n);
                mv.visitInsn(89);
                mv.visitLdcInsn((Object)Float.valueOf(0.0f));
                mv.visitInsn(150);
                Label negativeLabel = new Label();
                Label afterSignTestLabel = new Label();
                mv.visitJumpInsn(155, negativeLabel);
                if (imm5 != 0) {
                    context.loadImm(imm5);
                    mv.visitMethodInsn(184, Type.getInternalName(Math.class), "scalb", "(FI)F");
                }
                mv.visitInsn(141);
                mv.visitMethodInsn(184, Type.getInternalName(Math.class), "floor", "(D)D");
                mv.visitJumpInsn(167, afterSignTestLabel);
                mv.visitLabel(negativeLabel);
                if (imm5 != 0) {
                    context.loadImm(imm5);
                    mv.visitMethodInsn(184, Type.getInternalName(Math.class), "scalb", "(FI)F");
                }
                mv.visitInsn(141);
                mv.visitMethodInsn(184, Type.getInternalName(Math.class), "ceil", "(D)D");
                mv.visitLabel(afterSignTestLabel);
                Label afterLabel = new Label();
                Label notNaNValueLabel = new Label();
                mv.visitInsn(92);
                mv.visitMethodInsn(184, Type.getInternalName(Double.class), "isNaN", "(D)Z");
                mv.visitJumpInsn(153, notNaNValueLabel);
                mv.visitInsn(88);
                context.loadImm(Integer.MAX_VALUE);
                mv.visitJumpInsn(167, afterLabel);
                mv.visitLabel(notNaNValueLabel);
                mv.visitInsn(142);
                mv.visitLabel(afterLabel);
                context.storeVdInt(n);
            }
            context.endPfxCompiled(false);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int imm5 = insn >> 16 & 0x1F;
            return Common.disasmVDVSIMM("vf2iz", 1 + one + (two << 1), vd, vs, imm5);
        }
    };
    public static final Common.Instruction VF2IU = new Common.Instruction(222, 5376){

        @Override
        public final String name() {
            return "VF2IU";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int imm5 = insn >> 16 & 0x1F;
            processor.cpu.doVF2IU(1 + one + (two << 1), vd, vs, imm5);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = context.getVsize();
            int imm5 = context.getImm5();
            MethodVisitor mv = context.getMethodVisitor();
            context.startPfxCompiled(false);
            for (int n = 0; n < vsize; ++n) {
                context.prepareVdForStoreInt(n);
                context.loadVs(n);
                if (imm5 != 0) {
                    context.loadImm(imm5);
                    mv.visitMethodInsn(184, Type.getInternalName(Math.class), "scalb", "(FI)F");
                }
                mv.visitInsn(141);
                mv.visitMethodInsn(184, Type.getInternalName(Math.class), "ceil", "(D)D");
                Label afterLabel = new Label();
                Label notNaNValueLabel = new Label();
                mv.visitInsn(92);
                mv.visitMethodInsn(184, Type.getInternalName(Double.class), "isNaN", "(D)Z");
                mv.visitJumpInsn(153, notNaNValueLabel);
                mv.visitInsn(88);
                context.loadImm(Integer.MAX_VALUE);
                mv.visitJumpInsn(167, afterLabel);
                mv.visitLabel(notNaNValueLabel);
                mv.visitInsn(142);
                mv.visitLabel(afterLabel);
                context.storeVdInt(n);
            }
            context.endPfxCompiled(false);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int imm5 = insn >> 16 & 0x1F;
            return Common.disasmVDVSIMM("vf2iu", 1 + one + (two << 1), vd, vs, imm5);
        }
    };
    public static final Common.Instruction VF2ID = new Common.Instruction(223, 5376){

        @Override
        public final String name() {
            return "VF2ID";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int imm5 = insn >> 16 & 0x1F;
            processor.cpu.doVF2ID(1 + one + (two << 1), vd, vs, imm5);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = context.getVsize();
            int imm5 = context.getImm5();
            MethodVisitor mv = context.getMethodVisitor();
            context.startPfxCompiled(false);
            for (int n = 0; n < vsize; ++n) {
                context.prepareVdForStoreInt(n);
                context.loadVs(n);
                if (imm5 != 0) {
                    context.loadImm(imm5);
                    mv.visitMethodInsn(184, Type.getInternalName(Math.class), "scalb", "(FI)F");
                }
                mv.visitInsn(141);
                mv.visitMethodInsn(184, Type.getInternalName(Math.class), "floor", "(D)D");
                Label afterLabel = new Label();
                Label notNaNValueLabel = new Label();
                mv.visitInsn(92);
                mv.visitMethodInsn(184, Type.getInternalName(Double.class), "isNaN", "(D)Z");
                mv.visitJumpInsn(153, notNaNValueLabel);
                mv.visitInsn(88);
                context.loadImm(Integer.MAX_VALUE);
                mv.visitJumpInsn(167, afterLabel);
                mv.visitLabel(notNaNValueLabel);
                mv.visitInsn(142);
                mv.visitLabel(afterLabel);
                context.storeVdInt(n);
            }
            context.endPfxCompiled(false);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int imm5 = insn >> 16 & 0x1F;
            return Common.disasmVDVSIMM("vf2id", 1 + one + (two << 1), vd, vs, imm5);
        }
    };
    public static final Common.Instruction VI2F = new Common.Instruction(224, 5376){

        @Override
        public final String name() {
            return "VI2F";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int imm5 = insn >> 16 & 0x1F;
            processor.cpu.doVI2F(1 + one + (two << 1), vd, vs, imm5);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = context.getVsize();
            int imm5 = context.getImm5();
            MethodVisitor mv = context.getMethodVisitor();
            context.startPfxCompiled();
            for (int n = 0; n < vsize; ++n) {
                context.prepareVdForStore(n);
                context.loadVsInt(n);
                mv.visitInsn(134);
                if (imm5 != 0) {
                    context.loadImm(-imm5);
                    mv.visitMethodInsn(184, Type.getInternalName(Math.class), "scalb", "(FI)F");
                }
                context.storeVd(n);
            }
            context.endPfxCompiled();
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int imm5 = insn >> 16 & 0x1F;
            return Common.disasmVDVSIMM("vi2f", 1 + one + (two << 1), vd, vs, imm5);
        }
    };
    public static final Common.Instruction VCMOVT = new Common.Instruction(225, 5376){

        @Override
        public final String name() {
            return "VCMOVT";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int imm3 = insn >> 16 & 7;
            processor.cpu.doVCMOVT(1 + one + (two << 1), imm3, vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = context.getVsize();
            int imm3 = context.getImm3();
            MethodVisitor mv = context.getMethodVisitor();
            if (imm3 < 6) {
                int n;
                context.startPfxCompiled(false);
                Label notMoveLabel = new Label();
                Label afterLabel = new Label();
                context.loadVcrCc(imm3);
                mv.visitJumpInsn(153, notMoveLabel);
                for (n = 0; n < vsize; ++n) {
                    context.prepareVdForStoreInt(n);
                    context.loadVsInt(n);
                    context.storeVdInt(n);
                }
                context.endPfxCompiled(false);
                mv.visitJumpInsn(167, afterLabel);
                mv.visitLabel(notMoveLabel);
                if (context.getPfxdState().isKnown() && context.getPfxdState().pfxDst.enabled) {
                    for (n = 0; n < vsize; ++n) {
                        context.prepareVdForStoreInt(n);
                        context.loadVdInt(n);
                        context.storeVdInt(n);
                    }
                    context.endPfxCompiled(false);
                }
                mv.visitLabel(afterLabel);
            } else if (imm3 == 6) {
                context.startPfxCompiled(false);
                for (int n = 0; n < vsize; ++n) {
                    Label notMoveLabel = new Label();
                    Label afterLabel = new Label();
                    context.loadVcrCc(n);
                    mv.visitJumpInsn(153, notMoveLabel);
                    context.prepareVdForStoreInt(n);
                    context.loadVsInt(n);
                    context.storeVdInt(n);
                    mv.visitJumpInsn(167, afterLabel);
                    mv.visitLabel(notMoveLabel);
                    if (context.getPfxdState().isKnown() && context.getPfxdState().pfxDst.enabled) {
                        context.prepareVdForStoreInt(n);
                        context.loadVdInt(n);
                        context.storeVdInt(n);
                    }
                    mv.visitLabel(afterLabel);
                }
                context.endPfxCompiled(false);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int imm3 = insn >> 16 & 7;
            return Common.disasmVDVSIMM("VCMOVT", 1 + one + (two << 1), vd, vs, imm3);
        }
    };
    public static final Common.Instruction VCMOVF = new Common.Instruction(226, 5376){

        @Override
        public final String name() {
            return "VCMOVF";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int imm3 = insn >> 16 & 7;
            processor.cpu.doVCMOVF(1 + one + (two << 1), imm3, vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = context.getVsize();
            int imm3 = context.getImm3();
            MethodVisitor mv = context.getMethodVisitor();
            context.startPfxCompiled(false);
            if (imm3 < 6) {
                int n;
                Label notMoveLabel = new Label();
                Label afterLabel = new Label();
                context.loadVcrCc(imm3);
                mv.visitJumpInsn(154, notMoveLabel);
                for (n = 0; n < vsize; ++n) {
                    context.prepareVdForStoreInt(n);
                    context.loadVsInt(n);
                    context.storeVdInt(n);
                }
                mv.visitJumpInsn(167, afterLabel);
                mv.visitLabel(notMoveLabel);
                if (context.getPfxdState().isKnown() && context.getPfxdState().pfxDst.enabled) {
                    for (n = 0; n < vsize; ++n) {
                        context.prepareVdForStoreInt(n);
                        context.loadVdInt(n);
                        context.storeVdInt(n);
                    }
                }
                mv.visitLabel(afterLabel);
            } else if (imm3 == 6) {
                for (int n = 0; n < vsize; ++n) {
                    Label notMoveLabel = new Label();
                    Label afterLabel = new Label();
                    context.loadVcrCc(n);
                    mv.visitJumpInsn(154, notMoveLabel);
                    context.prepareVdForStoreInt(n);
                    context.loadVsInt(n);
                    context.storeVdInt(n);
                    mv.visitJumpInsn(167, afterLabel);
                    mv.visitLabel(notMoveLabel);
                    if (context.getPfxdState().isKnown() && context.getPfxdState().pfxDst.enabled) {
                        context.prepareVdForStoreInt(n);
                        context.loadVdInt(n);
                        context.storeVdInt(n);
                    }
                    mv.visitLabel(afterLabel);
                }
            } else {
                for (int n = 0; n < vsize; ++n) {
                    context.prepareVdForStoreInt(n);
                    context.loadVsInt(n);
                    context.storeVdInt(n);
                }
            }
            context.endPfxCompiled(false);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int imm3 = insn >> 16 & 7;
            return Common.disasmVDVSIMM("VCMOVF", 1 + one + (two << 1), vd, vs, imm3);
        }
    };
    public static final Common.Instruction VWBN = new Common.Instruction(227){

        @Override
        public final String name() {
            return "VWBN";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int imm8 = insn >> 16 & 0xFF;
            processor.cpu.doVWBN(1 + one + (two << 1), vd, vs, imm8);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int imm8 = insn >> 16 & 0xFF;
            return Common.disasmVDVSIMM("VWBN", 1 + one + (two << 1), vd, vs, imm8);
        }
    };
    public static final Common.Instruction VPFXS = new Common.Instruction(228){

        @Override
        public final String name() {
            return "VPFXS";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int swzx = insn >> 0 & 3;
            int swzy = insn >> 2 & 3;
            int swzz = insn >> 4 & 3;
            int swzw = insn >> 6 & 3;
            int absx = insn >> 8 & 1;
            int absy = insn >> 9 & 1;
            int absz = insn >> 10 & 1;
            int absw = insn >> 11 & 1;
            int cstx = insn >> 12 & 1;
            int csty = insn >> 13 & 1;
            int cstz = insn >> 14 & 1;
            int cstw = insn >> 15 & 1;
            int negx = insn >> 16 & 1;
            int negy = insn >> 17 & 1;
            int negz = insn >> 18 & 1;
            int negw = insn >> 19 & 1;
            processor.cpu.doVPFXS(negw, negz, negy, negx, cstw, cstz, csty, cstx, absw, absz, absy, absx, swzw, swzz, swzy, swzx);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (context.isPfxConsumed(256)) {
                context.getPfxsState().setKnown(true);
                VfpuState.Vcr.PfxSrc pfxSrc = context.getPfxsState().pfxSrc;
                pfxSrc.swz[0] = insn >> 0 & 3;
                pfxSrc.swz[1] = insn >> 2 & 3;
                pfxSrc.swz[2] = insn >> 4 & 3;
                pfxSrc.swz[3] = insn >> 6 & 3;
                pfxSrc.abs[0] = (insn >> 8 & 1) != 0;
                pfxSrc.abs[1] = (insn >> 9 & 1) != 0;
                pfxSrc.abs[2] = (insn >> 10 & 1) != 0;
                pfxSrc.abs[3] = (insn >> 11 & 1) != 0;
                pfxSrc.cst[0] = (insn >> 12 & 1) != 0;
                pfxSrc.cst[1] = (insn >> 13 & 1) != 0;
                pfxSrc.cst[2] = (insn >> 14 & 1) != 0;
                pfxSrc.cst[3] = (insn >> 15 & 1) != 0;
                pfxSrc.neg[0] = (insn >> 16 & 1) != 0;
                pfxSrc.neg[1] = (insn >> 17 & 1) != 0;
                pfxSrc.neg[2] = (insn >> 18 & 1) != 0;
                pfxSrc.neg[3] = (insn >> 19 & 1) != 0;
                pfxSrc.enabled = true;
            } else {
                context.getPfxsState().setKnown(false);
                context.compileInterpreterInstruction();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int swzx = insn >> 0 & 3;
            int swzy = insn >> 2 & 3;
            int swzz = insn >> 4 & 3;
            int swzw = insn >> 6 & 3;
            int absx = insn >> 8 & 1;
            int absy = insn >> 9 & 1;
            int absz = insn >> 10 & 1;
            int absw = insn >> 11 & 1;
            int cstx = insn >> 12 & 1;
            int csty = insn >> 13 & 1;
            int cstz = insn >> 14 & 1;
            int cstw = insn >> 15 & 1;
            int negx = insn >> 16 & 1;
            int negy = insn >> 17 & 1;
            int negz = insn >> 18 & 1;
            int negw = insn >> 19 & 1;
            int[] swz = new int[4];
            boolean[] abs = new boolean[4];
            boolean[] cst = new boolean[4];
            boolean[] neg = new boolean[4];
            swz[0] = swzx;
            swz[1] = swzy;
            swz[2] = swzz;
            swz[3] = swzw;
            abs[0] = absx != 0;
            abs[1] = absy != 0;
            abs[2] = absz != 0;
            abs[3] = absw != 0;
            cst[0] = cstx != 0;
            cst[1] = csty != 0;
            cst[2] = cstz != 0;
            cst[3] = cstw != 0;
            neg[0] = negx != 0;
            neg[1] = negy != 0;
            neg[2] = negz != 0;
            neg[3] = negw != 0;
            return Common.disasmVPFX("VPFXS", swz, abs, cst, neg);
        }
    };
    public static final Common.Instruction VPFXT = new Common.Instruction(229){

        @Override
        public final String name() {
            return "VPFXT";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int swzx = insn >> 0 & 3;
            int swzy = insn >> 2 & 3;
            int swzz = insn >> 4 & 3;
            int swzw = insn >> 6 & 3;
            int absx = insn >> 8 & 1;
            int absy = insn >> 9 & 1;
            int absz = insn >> 10 & 1;
            int absw = insn >> 11 & 1;
            int cstx = insn >> 12 & 1;
            int csty = insn >> 13 & 1;
            int cstz = insn >> 14 & 1;
            int cstw = insn >> 15 & 1;
            int negx = insn >> 16 & 1;
            int negy = insn >> 17 & 1;
            int negz = insn >> 18 & 1;
            int negw = insn >> 19 & 1;
            processor.cpu.doVPFXT(negw, negz, negy, negx, cstw, cstz, csty, cstx, absw, absz, absy, absx, swzw, swzz, swzy, swzx);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (context.isPfxConsumed(512)) {
                context.getPfxtState().setKnown(true);
                VfpuState.Vcr.PfxSrc pfxSrc = context.getPfxtState().pfxSrc;
                pfxSrc.swz[0] = insn >> 0 & 3;
                pfxSrc.swz[1] = insn >> 2 & 3;
                pfxSrc.swz[2] = insn >> 4 & 3;
                pfxSrc.swz[3] = insn >> 6 & 3;
                pfxSrc.abs[0] = (insn >> 8 & 1) != 0;
                pfxSrc.abs[1] = (insn >> 9 & 1) != 0;
                pfxSrc.abs[2] = (insn >> 10 & 1) != 0;
                pfxSrc.abs[3] = (insn >> 11 & 1) != 0;
                pfxSrc.cst[0] = (insn >> 12 & 1) != 0;
                pfxSrc.cst[1] = (insn >> 13 & 1) != 0;
                pfxSrc.cst[2] = (insn >> 14 & 1) != 0;
                pfxSrc.cst[3] = (insn >> 15 & 1) != 0;
                pfxSrc.neg[0] = (insn >> 16 & 1) != 0;
                pfxSrc.neg[1] = (insn >> 17 & 1) != 0;
                pfxSrc.neg[2] = (insn >> 18 & 1) != 0;
                pfxSrc.neg[3] = (insn >> 19 & 1) != 0;
                pfxSrc.enabled = true;
            } else {
                context.getPfxtState().setKnown(false);
                context.compileInterpreterInstruction();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int swzx = insn >> 0 & 3;
            int swzy = insn >> 2 & 3;
            int swzz = insn >> 4 & 3;
            int swzw = insn >> 6 & 3;
            int absx = insn >> 8 & 1;
            int absy = insn >> 9 & 1;
            int absz = insn >> 10 & 1;
            int absw = insn >> 11 & 1;
            int cstx = insn >> 12 & 1;
            int csty = insn >> 13 & 1;
            int cstz = insn >> 14 & 1;
            int cstw = insn >> 15 & 1;
            int negx = insn >> 16 & 1;
            int negy = insn >> 17 & 1;
            int negz = insn >> 18 & 1;
            int negw = insn >> 19 & 1;
            int[] swz = new int[4];
            boolean[] abs = new boolean[4];
            boolean[] cst = new boolean[4];
            boolean[] neg = new boolean[4];
            swz[0] = swzx;
            swz[1] = swzy;
            swz[2] = swzz;
            swz[3] = swzw;
            abs[0] = absx != 0;
            abs[1] = absy != 0;
            abs[2] = absz != 0;
            abs[3] = absw != 0;
            cst[0] = cstx != 0;
            cst[1] = csty != 0;
            cst[2] = cstz != 0;
            cst[3] = cstw != 0;
            neg[0] = negx != 0;
            neg[1] = negy != 0;
            neg[2] = negz != 0;
            neg[3] = negw != 0;
            return Common.disasmVPFX("VPFXT", swz, abs, cst, neg);
        }
    };
    public static final Common.Instruction VPFXD = new Common.Instruction(230){

        @Override
        public final String name() {
            return "VPFXD";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int satx = insn >> 0 & 3;
            int saty = insn >> 2 & 3;
            int satz = insn >> 4 & 3;
            int satw = insn >> 6 & 3;
            int mskx = insn >> 8 & 1;
            int msky = insn >> 9 & 1;
            int mskz = insn >> 10 & 1;
            int mskw = insn >> 11 & 1;
            processor.cpu.doVPFXD(mskw, mskz, msky, mskx, satw, satz, saty, satx);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            if (context.isPfxConsumed(1024)) {
                context.getPfxdState().setKnown(true);
                VfpuState.Vcr.PfxDst pfxDst = context.getPfxdState().pfxDst;
                pfxDst.sat[0] = insn >> 0 & 3;
                pfxDst.sat[1] = insn >> 2 & 3;
                pfxDst.sat[2] = insn >> 4 & 3;
                pfxDst.sat[3] = insn >> 6 & 3;
                pfxDst.msk[0] = (insn >> 8 & 1) != 0;
                pfxDst.msk[1] = (insn >> 9 & 1) != 0;
                pfxDst.msk[2] = (insn >> 10 & 1) != 0;
                pfxDst.msk[3] = (insn >> 11 & 1) != 0;
                pfxDst.enabled = true;
            } else {
                context.getPfxdState().setKnown(false);
                context.compileInterpreterInstruction();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int satx = insn >> 0 & 3;
            int saty = insn >> 2 & 3;
            int satz = insn >> 4 & 3;
            int satw = insn >> 6 & 3;
            int mskx = insn >> 8 & 1;
            int msky = insn >> 9 & 1;
            int mskz = insn >> 10 & 1;
            int mskw = insn >> 11 & 1;
            int[] sat = new int[4];
            int[] msk = new int[4];
            sat[0] = satx;
            sat[1] = saty;
            sat[2] = satz;
            sat[3] = satw;
            msk[0] = mskx;
            msk[1] = msky;
            msk[2] = mskz;
            msk[3] = mskw;
            return Common.disasmVPFXD("VPFXD", sat, msk);
        }
    };
    public static final Common.Instruction VIIM = new Common.Instruction(231, 5120){

        @Override
        public final String name() {
            return "VIIM";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int vd = insn >> 16 & 0x7F;
            processor.cpu.doVIIM(vd, (short)imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            boolean vsize = true;
            int vd = context.getVtRegisterIndex();
            int simm16 = context.getImm16(true);
            context.startPfxCompiled();
            context.prepareVdForStore(1, vd, 0);
            context.getMethodVisitor().visitLdcInsn((Object)Float.valueOf(simm16));
            context.storeVd(1, vd, 0);
            context.endPfxCompiled();
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int vd = insn >> 16 & 0x7F;
            return Common.disasmVDIIM("VIIM", 1, vd, imm16);
        }
    };
    public static final Common.Instruction VFIM = new Common.Instruction(232, 5120){

        @Override
        public final String name() {
            return "VFIM";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int vd = insn >> 16 & 0x7F;
            processor.cpu.doVFIM(vd, imm16);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            boolean vsize = true;
            int vd = context.getVtRegisterIndex();
            int imm16 = context.getImm16(false);
            int value = VfpuState.halffloatToFloat(imm16);
            context.startPfxCompiled();
            context.prepareVdForStoreInt(1, vd, 0);
            context.loadImm(value);
            context.storeVdInt(1, vd, 0);
            context.endPfxCompiled();
        }

        @Override
        public String disasm(int address, int insn) {
            int imm16 = insn >> 0 & 0xFFFF;
            int vd = insn >> 16 & 0x7F;
            return Common.disasmVDFIM("VFIM", 1, vd, imm16);
        }
    };
    public static final Common.Instruction VMMUL = new Common.Instruction(233, 5888){

        @Override
        public final String name() {
            return "VMMUL";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVMMUL(1 + one + (two << 1), vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = context.getVsize();
            if (vsize > 1) {
                context.startPfxCompiled();
                int vs = context.getVsRegisterIndex();
                int vt = context.getVtRegisterIndex();
                int vd = context.getVdRegisterIndex();
                for (int i = 0; i < vsize; ++i) {
                    for (int j = 0; j < vsize; ++j) {
                        context.prepareVdForStore(vsize, vd + i, j);
                        context.loadVs(vsize, vs + j, 0);
                        context.loadVt(vsize, vt + i, 0);
                        context.getMethodVisitor().visitInsn(106);
                        for (int n = 1; n < vsize; ++n) {
                            context.loadVs(vsize, vs + j, n);
                            context.loadVt(vsize, vt + i, n);
                            context.getMethodVisitor().visitInsn(106);
                            context.getMethodVisitor().visitInsn(98);
                        }
                        context.storeVd(vsize, vd + i, j);
                    }
                    context.flushPfxCompiled(vsize, vd + i, true);
                }
                context.endPfxCompiled(vsize, true, false);
            } else {
                context.compileInterpreterInstruction();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDMVSMVTM("VMMUL", 1 + one + (two << 1), vd, vs ^ 0x20, vt);
        }
    };
    public static final Common.Instruction VHTFM2 = new Common.Instruction(234, 1792){

        @Override
        public final String name() {
            return "VHTFM2";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int vs = insn >> 8 & 0x7F;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVHTFM2(vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int vs = insn >> 8 & 0x7F;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSMVT("VHTFM2", 2, vd, vs, vt);
        }
    };
    public static final Common.Instruction VTFM2 = new Common.Instruction(235, 1792){

        @Override
        public final String name() {
            return "VTFM2";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int vs = insn >> 8 & 0x7F;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVTFM2(vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int vs = insn >> 8 & 0x7F;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSMVT("VTFM2", 2, vd, vs, vt);
        }
    };
    public static final Common.Instruction VHTFM3 = new Common.Instruction(236, 1792){

        @Override
        public final String name() {
            return "VHTFM3";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int vs = insn >> 8 & 0x7F;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVHTFM3(vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int vs = insn >> 8 & 0x7F;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSMVT("VHTFM3", 3, vd, vs, vt);
        }
    };
    public static final Common.Instruction VTFM3 = new Common.Instruction(237, 5888){

        @Override
        public final String name() {
            return "VTFM3";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int vs = insn >> 8 & 0x7F;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVTFM3(vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = 3;
            int vs = context.getVsRegisterIndex();
            MethodVisitor mv = context.getMethodVisitor();
            context.loadVt(3, 0);
            context.storeFTmp1();
            context.loadVt(3, 1);
            context.storeFTmp2();
            context.loadVt(3, 2);
            context.storeFTmp3();
            for (int n = 0; n < 3; ++n) {
                context.prepareVdForStore(3, n);
                context.loadVs(3, vs + n, 0);
                context.loadFTmp1();
                mv.visitInsn(106);
                context.loadVs(3, vs + n, 1);
                context.loadFTmp2();
                mv.visitInsn(106);
                mv.visitInsn(98);
                context.loadVs(3, vs + n, 2);
                context.loadFTmp3();
                mv.visitInsn(106);
                mv.visitInsn(98);
                context.storeVd(3, n);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int vs = insn >> 8 & 0x7F;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSMVT("VTFM3", 3, vd, vs, vt);
        }
    };
    public static final Common.Instruction VHTFM4 = new Common.Instruction(238, 5888){

        @Override
        public final String name() {
            return "VHTFM4";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int vs = insn >> 8 & 0x7F;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVHTFM4(vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = 4;
            int vs = context.getVsRegisterIndex();
            MethodVisitor mv = context.getMethodVisitor();
            context.loadVt(3, 0);
            context.storeFTmp1();
            context.loadVt(3, 1);
            context.storeFTmp2();
            context.loadVt(3, 2);
            context.storeFTmp3();
            for (int n = 0; n < 4; ++n) {
                context.prepareVdForStore(4, n);
                context.loadVs(4, vs + n, 0);
                context.loadFTmp1();
                mv.visitInsn(106);
                context.loadVs(4, vs + n, 1);
                context.loadFTmp2();
                mv.visitInsn(106);
                mv.visitInsn(98);
                context.loadVs(4, vs + n, 2);
                context.loadFTmp3();
                mv.visitInsn(106);
                mv.visitInsn(98);
                context.loadVs(4, vs + n, 3);
                mv.visitInsn(98);
                context.storeVd(4, n);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int vs = insn >> 8 & 0x7F;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSMVT("VHTFM4", 4, vd, vs, vt);
        }
    };
    public static final Common.Instruction VTFM4 = new Common.Instruction(239, 5888){

        @Override
        public final String name() {
            return "VTFM4";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int vs = insn >> 8 & 0x7F;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVTFM4(vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = 4;
            int vs = context.getVsRegisterIndex();
            MethodVisitor mv = context.getMethodVisitor();
            context.loadVt(4, 0);
            context.storeFTmp1();
            context.loadVt(4, 1);
            context.storeFTmp2();
            context.loadVt(4, 2);
            context.storeFTmp3();
            context.loadVt(4, 3);
            context.storeFTmp4();
            for (int n = 0; n < 4; ++n) {
                context.prepareVdForStore(4, n);
                context.loadVs(4, vs + n, 0);
                context.loadFTmp1();
                mv.visitInsn(106);
                context.loadVs(4, vs + n, 1);
                context.loadFTmp2();
                mv.visitInsn(106);
                mv.visitInsn(98);
                context.loadVs(4, vs + n, 2);
                context.loadFTmp3();
                mv.visitInsn(106);
                mv.visitInsn(98);
                context.loadVs(4, vs + n, 3);
                context.loadFTmp4();
                mv.visitInsn(106);
                mv.visitInsn(98);
                context.storeVd(4, n);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int vs = insn >> 8 & 0x7F;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSMVT("VTFM4", 4, vd, vs, vt);
        }
    };
    public static final Common.Instruction VMSCL = new Common.Instruction(240, 5888){

        @Override
        public final String name() {
            return "VMSCL";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVMSCL(1 + one + (two << 1), vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = context.getVsize();
            if (vsize > 1) {
                int vs = context.getVsRegisterIndex();
                int vd = context.getVdRegisterIndex();
                context.startPfxCompiled();
                context.loadVt(1, 0);
                context.storeFTmp1();
                for (int i = 0; i < vsize; ++i) {
                    for (int n = 0; n < vsize; ++n) {
                        context.prepareVdForStore(vsize, vd + i, n);
                        context.loadVs(vsize, vs + i, n);
                        context.loadFTmp1();
                        context.getMethodVisitor().visitInsn(106);
                        context.storeVd(vsize, vd + i, n);
                    }
                    context.flushPfxCompiled(vsize, vd + i, true);
                }
                context.endPfxCompiled(vsize, true, false);
            } else {
                context.compileInterpreterInstruction();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSVT("vmscl", 1 + one + (two << 1), vd, vs, vt);
        }
    };
    public static final Common.Instruction VCRSP = new Common.Instruction(241, 5888){

        @Override
        public final String name() {
            return "VCRSP";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int vs = insn >> 8 & 0x7F;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVCRSP(vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.startPfxCompiled();
            int vsize = 3;
            MethodVisitor mv = context.getMethodVisitor();
            context.prepareVdForStore(3, 0);
            context.loadVs(3, 1);
            context.loadVt(3, 2);
            mv.visitInsn(106);
            context.loadVs(3, 2);
            context.loadVt(3, 1);
            mv.visitInsn(106);
            mv.visitInsn(102);
            context.storeVd(3, 0);
            context.prepareVdForStore(3, 1);
            context.loadVs(3, 2);
            context.loadVt(3, 0);
            mv.visitInsn(106);
            context.loadVs(3, 0);
            context.loadVt(3, 2);
            mv.visitInsn(106);
            mv.visitInsn(102);
            context.storeVd(3, 1);
            context.prepareVdForStore(3, 2);
            context.loadVs(3, 0);
            context.loadVt(3, 1);
            mv.visitInsn(106);
            context.loadVs(3, 1);
            context.loadVt(3, 0);
            mv.visitInsn(106);
            mv.visitInsn(102);
            context.storeVd(3, 2);
            context.endPfxCompiled();
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int vs = insn >> 8 & 0x7F;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSVT("vcrsp", 3, vd, vs, vt);
        }
    };
    public static final Common.Instruction VQMUL = new Common.Instruction(242, 1792){

        @Override
        public final String name() {
            return "VQMUL";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int vs = insn >> 8 & 0x7F;
            int vt = insn >> 16 & 0x7F;
            processor.cpu.doVQMUL(vd, vs, vt);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            super.compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int vs = insn >> 8 & 0x7F;
            int vt = insn >> 16 & 0x7F;
            return Common.disasmVDVSVT("VQMUL", 4, vd, vs, vt);
        }
    };
    public static final Common.Instruction VMMOV = new Common.Instruction(243, 5376){

        @Override
        public final String name() {
            return "VMMOV";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            processor.cpu.doVMMOV(1 + one + (two << 1), vd, vs);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            int vsize = context.getVsize();
            int vd = context.getVdRegisterIndex();
            int vs = context.getVsRegisterIndex();
            context.startPfxCompiled(false);
            for (int i = 0; i < vsize; ++i) {
                for (int n = 0; n < vsize; ++n) {
                    context.prepareVdForStoreInt(vsize, vd + i, n);
                    context.loadVsInt(vsize, vs + i, n);
                    context.storeVdInt(vsize, vd + i, n);
                }
                context.flushPfxCompiled(vsize, vd + i, false);
            }
            context.endPfxCompiled(vsize, false, false);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            return Common.disasmVDMVSM("VMMOV", 1 + one + (two << 1), vd, vs);
        }
    };
    public static final Common.Instruction VMIDT = new Common.Instruction(244, 5120){

        @Override
        public final String name() {
            return "VMIDT";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int two = insn >> 15 & 1;
            processor.cpu.doVMIDT(1 + one + (two << 1), vd);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.startPfxCompiled();
            int vsize = context.getVsize();
            int vd = context.getVdRegisterIndex();
            for (int i = 0; i < vsize; ++i) {
                for (int n = 0; n < vsize; ++n) {
                    context.prepareVdForStore(vsize, vd + i, n);
                    context.getMethodVisitor().visitInsn(i == n ? 12 : 11);
                    context.storeVd(vsize, vd + i, n);
                }
                context.flushPfxCompiled(vsize, vd + i, true);
            }
            context.endPfxCompiled(vsize, true, false);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int two = insn >> 15 & 1;
            return Common.disasmVDM("VMIDT", 1 + one + (two << 1), vd);
        }
    };
    public static final Common.Instruction VMZERO = new Common.Instruction(245, 5120){

        @Override
        public final String name() {
            return "VMZERO";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int two = insn >> 15 & 1;
            processor.cpu.doVMZERO(1 + one + (two << 1), vd);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.startPfxCompiled();
            int vsize = context.getVsize();
            int vd = context.getVdRegisterIndex();
            for (int i = 0; i < vsize; ++i) {
                for (int n = 0; n < vsize; ++n) {
                    context.prepareVdForStore(vsize, vd + i, n);
                    context.getMethodVisitor().visitInsn(11);
                    context.storeVd(vsize, vd + i, n);
                }
                context.flushPfxCompiled(vsize, vd + i, true);
            }
            context.endPfxCompiled(vsize, true, false);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int two = insn >> 15 & 1;
            return Common.disasmVDM("VMZERO", 1 + one + (two << 1), vd);
        }
    };
    public static final Common.Instruction VMONE = new Common.Instruction(246, 5120){

        @Override
        public final String name() {
            return "VMONE";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int two = insn >> 15 & 1;
            processor.cpu.doVMONE(1 + one + (two << 1), vd);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.startPfxCompiled();
            int vsize = context.getVsize();
            int vd = context.getVdRegisterIndex();
            for (int i = 0; i < vsize; ++i) {
                for (int n = 0; n < vsize; ++n) {
                    context.prepareVdForStore(vsize, vd + i, n);
                    context.getMethodVisitor().visitInsn(12);
                    context.storeVd(vsize, vd + i, n);
                }
                context.flushPfxCompiled(vsize, vd + i, true);
            }
            context.endPfxCompiled(vsize, true, false);
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int two = insn >> 15 & 1;
            return Common.disasmVDM("VMONE", 1 + one + (two << 1), vd);
        }
    };
    public static final Common.Instruction VROT = new Common.Instruction(247, 5376){

        @Override
        public final String name() {
            return "VROT";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int imm5 = insn >> 16 & 0x1F;
            processor.cpu.doVROT(1 + one + (two << 1), vd, vs, imm5);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            context.startPfxCompiled();
            int vsize = context.getVsize();
            int imm5 = context.getImm5();
            int si = imm5 >>> 2 & 3;
            int ci = imm5 >>> 0 & 3;
            MethodVisitor mv = context.getMethodVisitor();
            context.loadVs(1, 0);
            mv.visitInsn(141);
            mv.visitLdcInsn((Object)1.5707963267948966);
            mv.visitInsn(107);
            mv.visitInsn(92);
            mv.visitMethodInsn(184, Type.getInternalName(Math.class), "cos", "(D)D");
            mv.visitInsn(144);
            context.storeFTmp1();
            mv.visitMethodInsn(184, Type.getInternalName(Math.class), "sin", "(D)D");
            mv.visitInsn(144);
            if ((imm5 & 0x10) != 0) {
                mv.visitInsn(118);
            }
            context.storeFTmp2();
            for (int n = 0; n < vsize; ++n) {
                context.prepareVdForStore(n);
                if (n == ci) {
                    context.loadFTmp1();
                } else if (si == ci || n == si) {
                    context.loadFTmp2();
                } else {
                    mv.visitInsn(11);
                }
                context.storeVd(n);
            }
            context.endPfxCompiled();
        }

        @Override
        public String disasm(int address, int insn) {
            int vd = insn >> 0 & 0x7F;
            int one = insn >> 7 & 1;
            int vs = insn >> 8 & 0x7F;
            int two = insn >> 15 & 1;
            int imm5 = insn >> 16 & 0x1F;
            return Common.disasmVROT("VROT", 1 + one + (two << 1), vd, vs, imm5);
        }
    };
    public static final Common.Instruction VNOP = new Common.Instruction(248){

        @Override
        public final String name() {
            return "VNOP";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
        }

        @Override
        public String disasm(int address, int insn) {
            return "vnop";
        }
    };
    public static final Common.Instruction VFLUSH = new Common.Instruction(249){

        @Override
        public final String name() {
            return "VFLUSH";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
        }

        @Override
        public String disasm(int address, int insn) {
            return "vflush";
        }
    };
    public static final Common.Instruction VSYNC = new Common.Instruction(250){

        @Override
        public final String name() {
            return "VSYNC";
        }

        @Override
        public final String category() {
            return "VFPU";
        }

        @Override
        public void interpret(Processor processor, int insn) {
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
        }

        @Override
        public String disasm(int address, int insn) {
            return "vsync";
        }
    };
}

