/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.StyleRange;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyledLabel
extends JLabel {
    private static final String uiClassID = "StyledLabelUI";
    private List<StyleRange> _styleRanges;
    private boolean _ignoreColorSettings;
    public static final String PROPERTY_STYLE_RANGE = "styleRange";
    public static final String PROPERTY_IGNORE_COLOR_SETTINGS = "ignoreColorSettings";

    public StyledLabel() {
    }

    public StyledLabel(Icon icon) {
        super(icon);
    }

    public StyledLabel(Icon icon, int n) {
        super(icon, n);
    }

    public StyledLabel(String string) {
        super(string);
    }

    public StyledLabel(String string, int n) {
        super(string, n);
    }

    public StyledLabel(String string, Icon icon, int n) {
        super(string, icon, n);
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public synchronized void addStyleRange(StyleRange styleRange) {
        if (styleRange == null) {
            throw new IllegalArgumentException("StyleRange cannot be null.");
        }
        List<StyleRange> list = this.internalGetStyleRanges();
        for (int i = list.size() - 1; i >= 0; --i) {
            StyleRange styleRange2 = list.get(i);
            if (styleRange2.getStart() != styleRange.getStart() || styleRange2.getStart() != styleRange.getStart()) continue;
            list.remove(i);
        }
        this.internalGetStyleRanges().add(styleRange);
        this.firePropertyChange(PROPERTY_STYLE_RANGE, null, styleRange);
    }

    public synchronized void setStyleRanges(StyleRange[] styleRangeArray) {
        this.internalGetStyleRanges().clear();
        this.addStyleRanges(styleRangeArray);
    }

    public synchronized void addStyleRanges(StyleRange[] styleRangeArray) {
        if (styleRangeArray != null) {
            for (StyleRange styleRange : styleRangeArray) {
                this.internalGetStyleRanges().add(styleRange);
            }
            this.firePropertyChange(PROPERTY_STYLE_RANGE, null, styleRangeArray);
        } else {
            this.firePropertyChange(PROPERTY_STYLE_RANGE, null, null);
        }
    }

    public synchronized StyleRange[] getStyleRanges() {
        List<StyleRange> list = this.internalGetStyleRanges();
        return list.toArray(new StyleRange[list.size()]);
    }

    private List<StyleRange> internalGetStyleRanges() {
        if (this._styleRanges == null) {
            this._styleRanges = new Vector<StyleRange>();
        }
        return this._styleRanges;
    }

    public synchronized void clearStyleRange(StyleRange styleRange) {
        if (this.internalGetStyleRanges().remove(styleRange)) {
            this.firePropertyChange(PROPERTY_STYLE_RANGE, styleRange, null);
        }
    }

    public synchronized void clearStyleRanges() {
        this.internalGetStyleRanges().clear();
        this.firePropertyChange(PROPERTY_STYLE_RANGE, null, null);
    }

    public boolean isIgnoreColorSettings() {
        return this._ignoreColorSettings;
    }

    public void setIgnoreColorSettings(boolean bl) {
        boolean bl2 = this._ignoreColorSettings;
        if (bl2 != bl) {
            this._ignoreColorSettings = bl;
            this.firePropertyChange(PROPERTY_IGNORE_COLOR_SETTINGS, bl2, bl);
        }
    }
}

