/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.scheduler;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.scheduler.SchedulerAction;

public class Scheduler {
    private static Scheduler instance = null;
    private List<SchedulerAction> actions;
    private SchedulerAction nextAction;

    public static Scheduler getInstance() {
        if (instance == null) {
            instance = new Scheduler();
        }
        return instance;
    }

    public synchronized void reset() {
        this.actions = new LinkedList<SchedulerAction>();
        this.nextAction = null;
    }

    public synchronized void step() {
        IAction action;
        if (this.nextAction == null) {
            return;
        }
        long now = Scheduler.getNow();
        while ((action = this.getAction(now)) != null) {
            action.execute();
        }
    }

    public synchronized long getNextActionDelay(long noActionDelay) {
        if (this.nextAction == null) {
            return noActionDelay;
        }
        long now = Scheduler.getNow();
        return this.nextAction.getSchedule() - now;
    }

    private void addSchedulerAction(SchedulerAction schedulerAction) {
        this.actions.add(schedulerAction);
        if (this.updateNextAction(schedulerAction)) {
            RuntimeContext.onNextScheduleModified();
        }
    }

    public synchronized void addAction(IAction action) {
        SchedulerAction schedulerAction = new SchedulerAction(0L, action);
        this.addSchedulerAction(schedulerAction);
    }

    public synchronized void addAction(long schedule, IAction action) {
        SchedulerAction schedulerAction = new SchedulerAction(schedule, action);
        this.addSchedulerAction(schedulerAction);
    }

    public synchronized void removeAction(long schedule, IAction action) {
        ListIterator<SchedulerAction> lit = this.actions.listIterator();
        while (lit.hasNext()) {
            SchedulerAction schedulerAction = lit.next();
            if (schedulerAction.getSchedule() != schedule || schedulerAction.getAction() != action) continue;
            lit.remove();
            this.updateNextAction();
            break;
        }
    }

    private boolean updateNextAction(SchedulerAction schedulerAction) {
        if (this.nextAction == null || schedulerAction.getSchedule() < this.nextAction.getSchedule()) {
            this.nextAction = schedulerAction;
            return true;
        }
        return false;
    }

    private void updateNextAction() {
        this.nextAction = null;
        for (SchedulerAction schedulerAction : this.actions) {
            this.updateNextAction(schedulerAction);
        }
        RuntimeContext.onNextScheduleModified();
    }

    public synchronized IAction getAction(long now) {
        if (this.nextAction == null || now < this.nextAction.getSchedule()) {
            return null;
        }
        IAction action = this.nextAction.getAction();
        this.actions.remove(this.nextAction);
        this.updateNextAction();
        return action;
    }

    public static long getNow() {
        return Emulator.getClock().microTime();
    }
}

