/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.hardware;

import jpcsp.util.Utilities;

public class MemoryStick {
    public static final int PSP_MEMORYSTICK_STATE_DRIVER_READY = 1;
    public static final int PSP_MEMORYSTICK_STATE_DRIVER_BUSY = 2;
    public static final int PSP_MEMORYSTICK_STATE_DEVICE_INSERTED = 4;
    public static final int PSP_MEMORYSTICK_STATE_DEVICE_REMOVED = 8;
    public static final int PSP_FAT_MEMORYSTICK_STATE_UNASSIGNED = 0;
    public static final int PSP_FAT_MEMORYSTICK_STATE_ASSIGNED = 1;
    private static int msState = 1;
    private static int fatMsState = 1;
    private static long freeSize = 0x40000000L;
    private static int sectorSize = 32768;

    public static int getStateMs() {
        return msState;
    }

    public static void setStateMs(int state) {
        msState = state;
    }

    public static int getStateFatMs() {
        return fatMsState;
    }

    public static void setStateFatMs(int state) {
        fatMsState = state;
    }

    public static long getFreeSize() {
        return freeSize;
    }

    public static int getFreeSizeKb() {
        return Utilities.getSizeKb(MemoryStick.getFreeSize());
    }

    public static void setFreeSize(long freeSize) {
        MemoryStick.freeSize = freeSize;
    }

    public static int getSectorSize() {
        return sectorSize;
    }

    public static int getSectorSizeKb() {
        return Utilities.getSizeKb(MemoryStick.getSectorSize());
    }

    public static int getSize32Kb(int sizeKb) {
        return sizeKb + 31 & 0xFFFFFFE0;
    }

    public static String getSizeKbString(int sizeKb) {
        if (sizeKb < 3072) {
            return String.format("%d KB", sizeKb);
        }
        if ((sizeKb /= 1024) < 3072) {
            return String.format("%d MB", sizeKb);
        }
        return String.format("%d GB", sizeKb /= 1024);
    }
}

