/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.textures;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.sceDisplay;
import jpcsp.Memory;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.buffer.IREBufferManager;
import jpcsp.graphics.VideoEngine;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class GETexture {
    protected static Logger log = VideoEngine.log;
    protected int address;
    protected int length;
    protected int bufferWidth;
    protected int width;
    protected int height;
    protected int widthPow2;
    protected int heightPow2;
    protected int pixelFormat;
    protected int bytesPerPixel;
    protected int textureId = -1;
    protected int drawBufferId = -1;
    protected float texS;
    protected float texT;
    private boolean changed;
    protected int bufferLength;
    protected Buffer buffer;
    protected boolean useViewportResize;
    protected float resizeScale;
    private int stencilFboId = -1;
    private int stencilTextureId = -1;
    private static final int stencilPixelFormat = 17;

    public GETexture(int address, int bufferWidth, int width, int height, int pixelFormat, boolean useViewportResize) {
        this.address = address;
        this.bufferWidth = bufferWidth;
        this.width = width;
        this.height = height;
        this.pixelFormat = pixelFormat;
        this.bytesPerPixel = sceDisplay.getPixelFormatBytes(pixelFormat);
        this.length = bufferWidth * height * this.bytesPerPixel;
        this.widthPow2 = Utilities.makePow2(width);
        this.heightPow2 = Utilities.makePow2(height);
        this.useViewportResize = useViewportResize;
        this.changed = true;
        this.resizeScale = this.getViewportResizeScaleFactor();
    }

    private int getTextureBufferLength() {
        return this.getTexImageWidth() * this.getTexImageHeight() * this.bytesPerPixel;
    }

    private float getViewportResizeScaleFactor() {
        if (!this.useViewportResize) {
            return 1.0f;
        }
        return Modules.sceDisplayModule.getViewportResizeScaleFactor();
    }

    public void bind(IRenderingEngine re, boolean forDrawing) {
        float viewportResizeScaleFactor = this.getViewportResizeScaleFactor();
        if (this.textureId == -1 || viewportResizeScaleFactor != this.resizeScale) {
            if (this.textureId != -1) {
                re.deleteTexture(this.textureId);
                this.textureId = -1;
            }
            if (this.stencilTextureId != -1) {
                re.deleteTexture(this.stencilTextureId);
                this.stencilTextureId = -1;
            }
            if (this.stencilFboId != -1) {
                re.deleteFramebuffer(this.stencilFboId);
                this.stencilFboId = -1;
            }
            this.resizeScale = viewportResizeScaleFactor;
            if (this.useViewportResize) {
                this.texS = (float)sceDisplay.getResizedWidth(this.width) / (float)this.getTexImageWidth();
                this.texT = (float)sceDisplay.getResizedHeight(this.height) / (float)this.getTexImageHeight();
            } else {
                this.texS = (float)this.width / (float)this.bufferWidth;
                this.texT = (float)this.height / (float)this.heightPow2;
            }
            this.textureId = re.genTexture();
            re.bindTexture(this.textureId);
            re.setTexImage(0, this.pixelFormat, this.getTexImageWidth(), this.getTexImageHeight(), this.pixelFormat, this.pixelFormat, 0, null);
            re.setTextureMipmapMinFilter(0);
            re.setTextureMipmapMagFilter(0);
            re.setTextureMipmapMinLevel(0);
            re.setTextureMipmapMaxLevel(0);
            re.setTextureWrapMode(1, 1);
            if (this.drawBufferId == -1) {
                this.drawBufferId = re.getBufferManager().genBuffer(0, 6, 16, 6);
            }
        } else {
            re.bindTexture(this.textureId);
        }
        if (forDrawing) {
            re.setTextureFormat(this.pixelFormat, false);
        }
    }

    public int getBufferWidth() {
        return this.bufferWidth;
    }

    public int getTexImageWidth() {
        return this.useViewportResize ? sceDisplay.getResizedWidthPow2(this.bufferWidth) : this.bufferWidth;
    }

    public int getTexImageHeight() {
        return this.useViewportResize ? sceDisplay.getResizedHeightPow2(this.heightPow2) : this.heightPow2;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getResizedWidth() {
        return this.useViewportResize ? sceDisplay.getResizedWidth(this.width) : this.width;
    }

    public int getResizedHeight() {
        return this.useViewportResize ? sceDisplay.getResizedHeight(this.height) : this.height;
    }

    public int getWidthPow2() {
        return this.widthPow2;
    }

    public int getHeightPow2() {
        return this.heightPow2;
    }

    public int getPixelFormat() {
        return this.pixelFormat;
    }

    public void copyScreenToTexture(IRenderingEngine re) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("GETexture.copyScreenToTexture %s", this.toString()));
        }
        this.bind(re, false);
        int texWidth = Math.min(this.bufferWidth, this.width);
        int texHeight = this.height;
        if (this.useViewportResize) {
            texWidth = sceDisplay.getResizedWidth(texWidth);
            texHeight = sceDisplay.getResizedHeight(texHeight);
        }
        re.copyTexSubImage(0, 0, 0, 0, 0, texWidth, texHeight);
        if (Modules.sceDisplayModule.isSaveStencilToMemory() && !this.copyStencilToTextureAlpha(re, texWidth, texHeight)) {
            Modules.sceDisplayModule.setSaveStencilToMemory(false);
        }
        this.setChanged(true);
    }

    public void copyTextureToScreen(IRenderingEngine re) {
        this.copyTextureToScreen(re, 0, 0, this.width, this.height, true, true, true, true, true);
    }

    protected void copyTextureToScreen(IRenderingEngine re, int x, int y, int projectionWidth, int projectionHeight, boolean scaleToCanvas, boolean redWriteEnabled, boolean greenWriteEnabled, boolean blueWriteEnabled, boolean alphaWriteEnabled) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("GETexture.copyTextureToScreen %s at %dx%d", this.toString(), x, y));
        }
        this.bind(re, true);
        this.drawTexture(re, x, y, projectionWidth, projectionHeight, scaleToCanvas, redWriteEnabled, greenWriteEnabled, blueWriteEnabled, alphaWriteEnabled);
    }

    private void drawTexture(IRenderingEngine re, int x, int y, int projectionWidth, int projectionHeight, boolean scaleToCanvas, boolean redWriteEnabled, boolean greenWriteEnabled, boolean blueWriteEnabled, boolean alphaWriteEnabled) {
        re.startDirectRendering(true, false, true, true, true, projectionWidth, projectionHeight);
        re.setColorMask(redWriteEnabled, greenWriteEnabled, blueWriteEnabled, alphaWriteEnabled);
        if (scaleToCanvas) {
            re.setViewport(0, 0, Modules.sceDisplayModule.getCanvasWidth(), Modules.sceDisplayModule.getCanvasHeight());
        } else {
            re.setViewport(0, 0, projectionWidth, projectionHeight);
        }
        IREBufferManager bufferManager = re.getBufferManager();
        ByteBuffer drawByteBuffer = bufferManager.getBuffer(this.drawBufferId);
        drawByteBuffer.clear();
        FloatBuffer drawFloatBuffer = drawByteBuffer.asFloatBuffer();
        drawFloatBuffer.clear();
        drawFloatBuffer.put(this.texS);
        drawFloatBuffer.put(this.texT);
        drawFloatBuffer.put(x + this.width);
        drawFloatBuffer.put(y + this.height);
        drawFloatBuffer.put(0.0f);
        drawFloatBuffer.put(this.texT);
        drawFloatBuffer.put(x);
        drawFloatBuffer.put(y + this.height);
        drawFloatBuffer.put(0.0f);
        drawFloatBuffer.put(0.0f);
        drawFloatBuffer.put(x);
        drawFloatBuffer.put(y);
        drawFloatBuffer.put(this.texS);
        drawFloatBuffer.put(0.0f);
        drawFloatBuffer.put(x + this.width);
        drawFloatBuffer.put(y);
        if (re.isVertexArrayAvailable()) {
            re.bindVertexArray(0);
        }
        re.setVertexInfo(null, false, false, true, -1);
        re.enableClientState(0);
        re.disableClientState(1);
        re.disableClientState(2);
        re.enableClientState(3);
        bufferManager.setTexCoordPointer(this.drawBufferId, 2, 6, 4 * VideoEngine.SIZEOF_FLOAT, 0);
        bufferManager.setVertexPointer(this.drawBufferId, 2, 6, 4 * VideoEngine.SIZEOF_FLOAT, 2 * VideoEngine.SIZEOF_FLOAT);
        bufferManager.setBufferData(0, this.drawBufferId, drawFloatBuffer.position() * VideoEngine.SIZEOF_FLOAT, drawByteBuffer.rewind(), 6);
        re.drawArrays(7, 0, 4);
        re.endDirectRendering();
    }

    protected void setChanged(boolean changed) {
        this.changed = changed;
    }

    protected boolean hasChanged() {
        return this.changed;
    }

    private void prepareBuffer() {
        if (this.buffer != null && this.bufferLength < this.getTextureBufferLength()) {
            this.buffer = null;
        }
        if (this.buffer == null) {
            this.bufferLength = this.getTextureBufferLength();
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.bufferLength).order(ByteOrder.LITTLE_ENDIAN);
            this.buffer = Memory.getInstance().getMainMemoryByteBuffer() instanceof IntBuffer ? byteBuffer.asIntBuffer() : byteBuffer;
        } else {
            this.buffer.clear();
        }
    }

    public void copyTextureToMemory(IRenderingEngine re) {
        if (this.textureId == -1) {
            return;
        }
        if (!this.hasChanged()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("GETexture.copyTextureToMemory %s", this.toString()));
        }
        Buffer memoryBuffer = Memory.getInstance().getBuffer(this.address, this.length);
        this.prepareBuffer();
        re.bindTexture(this.textureId);
        re.setTextureFormat(this.pixelFormat, false);
        re.setPixelStore(this.bufferWidth, sceDisplay.getPixelFormatBytes(this.pixelFormat));
        re.getTexImage(0, this.pixelFormat, this.pixelFormat, this.buffer);
        this.buffer.clear();
        if (this.buffer instanceof IntBuffer) {
            IntBuffer src = (IntBuffer)this.buffer;
            IntBuffer dst = (IntBuffer)memoryBuffer;
            int pixelsPerElement = 4 / this.bytesPerPixel;
            int copyWidth = Math.min(this.width, this.bufferWidth);
            int widthLimit = (copyWidth + pixelsPerElement - 1) / pixelsPerElement;
            int step = this.bufferWidth / pixelsPerElement;
            int srcOffset = 0;
            int dstOffset = (this.height - 1) * step;
            int y = 0;
            while (y < this.height) {
                src.limit(srcOffset + widthLimit);
                src.position(srcOffset);
                dst.position(dstOffset);
                dst.put(src);
                ++y;
                srcOffset += step;
                dstOffset -= step;
            }
        } else {
            ByteBuffer src = (ByteBuffer)this.buffer;
            ByteBuffer dst = (ByteBuffer)memoryBuffer;
            int copyWidth = Math.min(this.width, this.bufferWidth);
            int widthLimit = copyWidth * this.bytesPerPixel;
            int step = this.bufferWidth * this.bytesPerPixel;
            int srcOffset = 0;
            int dstOffset = (this.height - 1) * step;
            int y = 0;
            while (y < this.height) {
                src.limit(srcOffset + widthLimit);
                src.position(srcOffset);
                dst.position(dstOffset);
                dst.put(src);
                ++y;
                srcOffset += step;
                dstOffset -= step;
            }
        }
        this.setChanged(false);
    }

    public void delete(IRenderingEngine re) {
        if (this.drawBufferId != -1) {
            re.getBufferManager().deleteBuffer(this.drawBufferId);
            this.drawBufferId = -1;
        }
        if (this.textureId != -1) {
            re.deleteTexture(this.textureId);
            this.textureId = -1;
        }
    }

    public int getTextureId() {
        return this.textureId;
    }

    public boolean isCompatible(int width, int height, int bufferWidth, int pixelFormat) {
        if (width != this.width || height != this.height || bufferWidth != this.bufferWidth || pixelFormat != this.pixelFormat) {
            return false;
        }
        return !this.useViewportResize || this.resizeScale == this.getViewportResizeScaleFactor();
    }

    protected boolean copyStencilToTextureAlpha(IRenderingEngine re, int texWidth, int texHeight) {
        re.checkAndLogErrors(null);
        if (this.stencilFboId == -1) {
            this.stencilFboId = re.genFramebuffer();
            re.bindFramebuffer(2, this.stencilFboId);
            this.stencilTextureId = re.genTexture();
            re.bindTexture(this.stencilTextureId);
            re.checkAndLogErrors("bindTexture");
            re.setTexImage(0, 17, this.getTexImageWidth(), this.getTexImageHeight(), 17, 17, 0, null);
            if (re.checkAndLogErrors("setTexImage")) {
                return false;
            }
            re.setTextureMipmapMinFilter(0);
            re.setTextureMipmapMagFilter(0);
            re.setTextureMipmapMinLevel(0);
            re.setTextureMipmapMaxLevel(0);
            re.setTextureWrapMode(1, 1);
            re.setFramebufferTexture(2, 2, this.stencilTextureId, 0);
            if (re.checkAndLogErrors("setFramebufferTexture RE_STENCIL_ATTACHMENT")) {
                return false;
            }
            re.setFramebufferTexture(2, 3, this.textureId, 0);
            if (re.checkAndLogErrors("setFramebufferTexture RE_COLOR_ATTACHMENT0")) {
                return false;
            }
        } else {
            re.bindFramebuffer(2, this.stencilFboId);
        }
        re.blitFramebuffer(0, 0, texWidth, texHeight, 0, 0, texWidth, texHeight, 4, 0);
        if (re.checkAndLogErrors("blitFramebuffer")) {
            return false;
        }
        re.bindTexture(this.stencilTextureId);
        if (!re.setCopyRedToAlpha(true)) {
            return false;
        }
        this.drawTexture(re, 0, 0, this.width, this.height, true, false, false, false, true);
        re.checkAndLogErrors("drawTexture");
        re.bindFramebuffer(2, 0);
        re.setCopyRedToAlpha(false);
        return true;
    }

    public String toString() {
        return String.format("GETexture[0x%08X-0x%08X, %dx%d (texture %dx%d), bufferWidth=%d, pixelFormat=%d(%s)]", this.address, this.address + this.length, this.width, this.height, this.getTexImageWidth(), this.getTexImageHeight(), this.bufferWidth, this.pixelFormat, VideoEngine.getPsmName(this.pixelFormat));
    }
}

