/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE;

import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.Uniforms;
import jpcsp.graphics.VideoEngine;
import org.apache.log4j.Logger;

public class ShaderContext {
    protected static Logger log = VideoEngine.log;
    private float zPos;
    private float zScale;
    private int[] matFlags = new int[3];
    private int lightingEnable;
    private int lightMode;
    private int[] lightType = new int[4];
    private int[] lightKind = new int[4];
    private int[] lightEnabled = new int[4];
    private float[] boneMatrix = new float[128];
    private int numberBones;
    private int texEnable;
    private int texMapMode;
    private int texMapProj;
    private int[] texShade = new int[2];
    private int ctestEnable;
    private int ctestFunc;
    private int[] ctestMsk = new int[3];
    private int[] ctestRef = new int[3];
    private int[] texEnvMode = new int[2];
    private float colorDoubling;
    private int vinfoColor;
    private int vinfoPosition;
    private int vinfoTexture;
    private int vinfoNormal;
    private int vinfoTransform2D;
    private float positionScale;
    private float normalScale;
    private float textureScale;
    private float weightScale;
    private int clutShift;
    private int clutMask;
    private int clutOffset;
    private boolean mipmapShareClut;
    private int clut = -1;
    private int texPixelFormat;
    private int tex = 0;
    private int utex = -1;
    private float[] vertexColor = new float[4];
    private int clutIndexHint;
    private int stencilTestEnable;
    private int stencilFunc;
    private int stencilRef;
    private int stencilMask;
    private int stencilOpFail;
    private int stencilOpZFail;
    private int stencilOpZPass;
    private int depthTestEnable;
    private int depthFunc;
    private int depthMask;
    private int fbTex = -1;
    private int colorMaskEnable;
    private int[] colorMask = new int[4];
    private int[] notColorMask = new int[4];
    private int alphaTestEnable;
    private int alphaTestFunc;
    private int alphaTestRef;
    private int blendTestEnable;
    private int blendEquation;
    private int blendSrc;
    private int blendDst;
    private float[] blendSFix = new float[3];
    private float[] blendDFix = new float[3];
    private int copyRedToAlpha;
    private int wrapModeS;
    private int wrapModeT;

    public void setUniforms(IRenderingEngine re, int shaderProgram) {
        re.setUniform(Uniforms.zPos.getId(shaderProgram), this.zPos);
        re.setUniform(Uniforms.zScale.getId(shaderProgram), this.zScale);
        re.setUniform3(Uniforms.matFlags.getId(shaderProgram), this.matFlags);
        re.setUniform4(Uniforms.lightEnabled.getId(shaderProgram), this.lightEnabled);
        re.setUniform(Uniforms.lightMode.getId(shaderProgram), this.lightMode);
        re.setUniform4(Uniforms.lightType.getId(shaderProgram), this.lightType);
        re.setUniform4(Uniforms.lightKind.getId(shaderProgram), this.lightKind);
        re.setUniform(Uniforms.lightingEnable.getId(shaderProgram), this.lightingEnable);
        re.setUniformMatrix4(Uniforms.boneMatrix.getId(shaderProgram), this.numberBones, this.boneMatrix);
        re.setUniform(Uniforms.numberBones.getId(shaderProgram), this.numberBones);
        re.setUniform(Uniforms.texEnable.getId(shaderProgram), this.texEnable);
        re.setUniform(Uniforms.texMapMode.getId(shaderProgram), this.texMapMode);
        re.setUniform(Uniforms.texMapProj.getId(shaderProgram), this.texMapProj);
        re.setUniform2(Uniforms.texShade.getId(shaderProgram), this.texShade);
        re.setUniform(Uniforms.ctestEnable.getId(shaderProgram), this.ctestEnable);
        re.setUniform(Uniforms.ctestFunc.getId(shaderProgram), this.ctestFunc);
        re.setUniform3(Uniforms.ctestMsk.getId(shaderProgram), this.ctestMsk);
        re.setUniform3(Uniforms.ctestRef.getId(shaderProgram), this.ctestRef);
        re.setUniform2(Uniforms.texEnvMode.getId(shaderProgram), this.texEnvMode);
        re.setUniform(Uniforms.colorDoubling.getId(shaderProgram), this.colorDoubling);
        re.setUniform(Uniforms.vinfoColor.getId(shaderProgram), this.vinfoColor);
        re.setUniform(Uniforms.vinfoPosition.getId(shaderProgram), this.vinfoPosition);
        re.setUniform(Uniforms.vinfoTransform2D.getId(shaderProgram), this.vinfoTransform2D);
        re.setUniform(Uniforms.positionScale.getId(shaderProgram), this.positionScale);
        re.setUniform(Uniforms.normalScale.getId(shaderProgram), this.normalScale);
        re.setUniform(Uniforms.textureScale.getId(shaderProgram), this.textureScale);
        re.setUniform(Uniforms.weightScale.getId(shaderProgram), this.weightScale);
        re.setUniform(Uniforms.clutShift.getId(shaderProgram), this.clutShift);
        re.setUniform(Uniforms.clutMask.getId(shaderProgram), this.clutMask);
        re.setUniform(Uniforms.clutOffset.getId(shaderProgram), this.clutOffset);
        re.setUniform(Uniforms.mipmapShareClut.getId(shaderProgram), this.mipmapShareClut ? 1 : 0);
        re.setUniform(Uniforms.texPixelFormat.getId(shaderProgram), this.texPixelFormat);
        re.setUniform4(Uniforms.vertexColor.getId(shaderProgram), this.vertexColor);
        re.setUniform(Uniforms.vinfoTexture.getId(shaderProgram), this.vinfoTexture);
        re.setUniform(Uniforms.vinfoNormal.getId(shaderProgram), this.vinfoNormal);
        re.setUniform(Uniforms.stencilTestEnable.getId(shaderProgram), this.stencilTestEnable);
        re.setUniform(Uniforms.stencilFunc.getId(shaderProgram), this.stencilFunc);
        re.setUniform(Uniforms.stencilRef.getId(shaderProgram), this.stencilRef);
        re.setUniform(Uniforms.stencilMask.getId(shaderProgram), this.stencilMask);
        re.setUniform(Uniforms.stencilOpFail.getId(shaderProgram), this.stencilOpFail);
        re.setUniform(Uniforms.stencilOpZFail.getId(shaderProgram), this.stencilOpZFail);
        re.setUniform(Uniforms.stencilOpZPass.getId(shaderProgram), this.stencilOpZPass);
        re.setUniform(Uniforms.depthTestEnable.getId(shaderProgram), this.depthTestEnable);
        re.setUniform(Uniforms.depthFunc.getId(shaderProgram), this.depthFunc);
        re.setUniform(Uniforms.depthMask.getId(shaderProgram), this.depthMask);
        re.setUniform(Uniforms.colorMaskEnable.getId(shaderProgram), this.colorMaskEnable);
        re.setUniform4(Uniforms.colorMask.getId(shaderProgram), this.colorMask);
        re.setUniform4(Uniforms.notColorMask.getId(shaderProgram), this.notColorMask);
        re.setUniform(Uniforms.alphaTestEnable.getId(shaderProgram), this.alphaTestEnable);
        re.setUniform(Uniforms.alphaTestFunc.getId(shaderProgram), this.alphaTestFunc);
        re.setUniform(Uniforms.alphaTestRef.getId(shaderProgram), this.alphaTestRef);
        re.setUniform(Uniforms.blendTestEnable.getId(shaderProgram), this.blendTestEnable);
        re.setUniform(Uniforms.blendEquation.getId(shaderProgram), this.blendEquation);
        re.setUniform(Uniforms.blendSrc.getId(shaderProgram), this.blendSrc);
        re.setUniform(Uniforms.blendDst.getId(shaderProgram), this.blendDst);
        re.setUniform3(Uniforms.blendSFix.getId(shaderProgram), this.blendSFix);
        re.setUniform3(Uniforms.blendDFix.getId(shaderProgram), this.blendDFix);
        re.setUniform(Uniforms.copyRedToAlpha.getId(shaderProgram), this.copyRedToAlpha);
        re.setUniform(Uniforms.wrapModeS.getId(shaderProgram), this.wrapModeS);
        re.setUniform(Uniforms.wrapModeT.getId(shaderProgram), this.wrapModeT);
        this.setUniformsSamplers(re, shaderProgram);
    }

    protected void setUniformsSamplers(IRenderingEngine re, int shaderProgram) {
        re.setUniform(Uniforms.clut.getId(shaderProgram), this.clut);
        re.setUniform(Uniforms.tex.getId(shaderProgram), this.tex);
        re.setUniform(Uniforms.utex.getId(shaderProgram), this.utex);
        re.setUniform(Uniforms.fbTex.getId(shaderProgram), this.fbTex);
    }

    public void initShaderProgram(IRenderingEngine re, int shaderProgram) {
    }

    public float getZPos() {
        return this.zPos;
    }

    public void setZPos(float pos) {
        this.zPos = pos;
    }

    public float getZScale() {
        return this.zScale;
    }

    public void setZScale(float scale) {
        this.zScale = scale;
    }

    public int getMatFlags(int index) {
        return this.matFlags[index];
    }

    public void setMatFlags(int index, int matFlags) {
        this.matFlags[index] = matFlags;
    }

    public int getLightingEnable() {
        return this.lightingEnable;
    }

    public void setLightingEnable(int lightingEnable) {
        this.lightingEnable = lightingEnable;
    }

    public int getLightMode() {
        return this.lightMode;
    }

    public void setLightMode(int lightMode) {
        this.lightMode = lightMode;
    }

    public int getLightType(int light) {
        return this.lightType[light];
    }

    public void setLightType(int light, int lightType) {
        this.lightType[light] = lightType;
    }

    public int getLightKind(int light) {
        return this.lightKind[light];
    }

    public void setLightKind(int light, int lightKind) {
        this.lightKind[light] = lightKind;
    }

    public int getLightEnabled(int light) {
        return this.lightEnabled[light];
    }

    public void setLightEnabled(int light, int lightEnabled) {
        this.lightEnabled[light] = lightEnabled;
    }

    public int getBoneMatrixLength() {
        return this.boneMatrix.length;
    }

    public float[] getBoneMatrix() {
        return this.boneMatrix;
    }

    public void setBoneMatrix(int count, float[] boneMatrix) {
        if (count > 0) {
            System.arraycopy(boneMatrix, 0, this.boneMatrix, 0, 16 * count);
        }
    }

    public int getNumberBones() {
        return this.numberBones;
    }

    public void setNumberBones(int numberBones) {
        this.numberBones = numberBones;
    }

    public int getTexEnable() {
        return this.texEnable;
    }

    public void setTexEnable(int texEnable) {
        this.texEnable = texEnable;
    }

    public int getTexMapMode() {
        return this.texMapMode;
    }

    public void setTexMapMode(int texMapMode) {
        this.texMapMode = texMapMode;
    }

    public int getTexMapProj() {
        return this.texMapProj;
    }

    public void setTexMapProj(int texMapProj) {
        this.texMapProj = texMapProj;
    }

    public int getTexShade(int index) {
        return this.texShade[index];
    }

    public void setTexShade(int index, int texShade) {
        this.texShade[index] = texShade;
    }

    public int getCtestEnable() {
        return this.ctestEnable;
    }

    public void setCtestEnable(int ctestEnable) {
        this.ctestEnable = ctestEnable;
    }

    public int getCtestFunc() {
        return this.ctestFunc;
    }

    public void setCtestFunc(int ctestFunc) {
        this.ctestFunc = ctestFunc;
    }

    public int getCtestMsk(int index) {
        return this.ctestMsk[index];
    }

    public void setCtestMsk(int index, int ctestMsk) {
        this.ctestMsk[index] = ctestMsk;
    }

    public int getCtestRef(int index) {
        return this.ctestRef[index];
    }

    public void setCtestRef(int index, int ctestRef) {
        this.ctestRef[index] = ctestRef;
    }

    public int getTexEnvMode(int index) {
        return this.texEnvMode[index];
    }

    public void setTexEnvMode(int index, int texEnvMode) {
        this.texEnvMode[index] = texEnvMode;
    }

    public float getColorDoubling() {
        return this.colorDoubling;
    }

    public void setColorDoubling(float colorDoubling) {
        this.colorDoubling = colorDoubling;
    }

    public int getVinfoColor() {
        return this.vinfoColor;
    }

    public void setVinfoColor(int vinfoColor) {
        this.vinfoColor = vinfoColor;
    }

    public int getVinfoPosition() {
        return this.vinfoPosition;
    }

    public void setVinfoPosition(int vinfoPosition) {
        this.vinfoPosition = vinfoPosition;
    }

    public int getVinfoTransform2D() {
        return this.vinfoTransform2D;
    }

    public void setVinfoTransform2D(int vinfoTransform2D) {
        this.vinfoTransform2D = vinfoTransform2D;
    }

    public float getPositionScale() {
        return this.positionScale;
    }

    public void setPositionScale(float positionScale) {
        this.positionScale = positionScale;
    }

    public float getNormalScale() {
        return this.normalScale;
    }

    public void setNormalScale(float normalScale) {
        this.normalScale = normalScale;
    }

    public float getTextureScale() {
        return this.textureScale;
    }

    public void setTextureScale(float textureScale) {
        this.textureScale = textureScale;
    }

    public float getWeightScale() {
        return this.weightScale;
    }

    public void setWeightScale(float weightScale) {
        this.weightScale = weightScale;
    }

    public int getClutShift() {
        return this.clutShift;
    }

    public void setClutShift(int clutShift) {
        this.clutShift = clutShift;
    }

    public int getClutMask() {
        return this.clutMask;
    }

    public void setClutMask(int clutMask) {
        this.clutMask = clutMask;
    }

    public int getClutOffset() {
        return this.clutOffset;
    }

    public void setClutOffset(int clutOffset) {
        this.clutOffset = clutOffset;
    }

    public boolean isMipmapShareClut() {
        return this.mipmapShareClut;
    }

    public void setMipmapShareClut(boolean mipmapShareClut) {
        this.mipmapShareClut = mipmapShareClut;
    }

    public int getClut() {
        return this.clut;
    }

    public void setClut(int clut) {
        this.clut = clut;
    }

    public int getTexPixelFormat() {
        return this.texPixelFormat;
    }

    public void setTexPixelFormat(int texPixelFormat) {
        this.texPixelFormat = texPixelFormat;
    }

    public int getTex() {
        return this.tex;
    }

    public void setTex(int tex) {
        this.tex = tex;
    }

    public int getUtex() {
        return this.utex;
    }

    public void setUtex(int utex) {
        this.utex = utex;
    }

    public float[] getVertexColor() {
        return this.vertexColor;
    }

    public void setVertexColor(float[] vertexColor) {
        this.vertexColor[0] = vertexColor[0];
        this.vertexColor[1] = vertexColor[1];
        this.vertexColor[2] = vertexColor[2];
        this.vertexColor[3] = vertexColor[3];
    }

    public int getClutIndexHint() {
        return this.clutIndexHint;
    }

    public void setClutIndexHint(int clutIndexHint) {
        this.clutIndexHint = clutIndexHint;
    }

    public int getVinfoTexture() {
        return this.vinfoTexture;
    }

    public void setVinfoTexture(int vinfoTexture) {
        this.vinfoTexture = vinfoTexture;
    }

    public int getVinfoNormal() {
        return this.vinfoNormal;
    }

    public void setVinfoNormal(int vinfoNormal) {
        this.vinfoNormal = vinfoNormal;
    }

    public int getStencilTestEnable() {
        return this.stencilTestEnable;
    }

    public void setStencilTestEnable(int stencilTestEnable) {
        this.stencilTestEnable = stencilTestEnable;
    }

    public int getStencilFunc() {
        return this.stencilFunc;
    }

    public void setStencilFunc(int stencilFunc) {
        this.stencilFunc = stencilFunc;
    }

    public int getStencilRef() {
        return this.stencilRef;
    }

    public void setStencilRef(int stencilRef) {
        this.stencilRef = stencilRef;
    }

    public int getStencilMask() {
        return this.stencilMask;
    }

    public void setStencilMask(int stencilMask) {
        this.stencilMask = stencilMask;
    }

    public int getStencilOpFail() {
        return this.stencilOpFail;
    }

    public void setStencilOpFail(int stencilOpFail) {
        this.stencilOpFail = stencilOpFail;
    }

    public int getStencilOpZFail() {
        return this.stencilOpZFail;
    }

    public void setStencilOpZFail(int stencilOpZFail) {
        this.stencilOpZFail = stencilOpZFail;
    }

    public int getStencilOpZPass() {
        return this.stencilOpZPass;
    }

    public void setStencilOpZPass(int stencilOpZPass) {
        this.stencilOpZPass = stencilOpZPass;
    }

    public int getDepthTestEnable() {
        return this.depthTestEnable;
    }

    public void setDepthTestEnable(int depthTestEnable) {
        this.depthTestEnable = depthTestEnable;
    }

    public int getDepthFunc() {
        return this.depthFunc;
    }

    public void setDepthFunc(int depthFunc) {
        this.depthFunc = depthFunc;
    }

    public int getDepthMask() {
        return this.depthMask;
    }

    public void setDepthMask(int depthMask) {
        this.depthMask = depthMask;
    }

    public int getFbTex() {
        return this.fbTex;
    }

    public void setFbTex(int fbTex) {
        this.fbTex = fbTex;
    }

    public int getColorMaskEnable() {
        return this.colorMaskEnable;
    }

    public void setColorMaskEnable(int colorMaskEnable) {
        this.colorMaskEnable = colorMaskEnable;
    }

    public int[] getColorMask() {
        return this.colorMask;
    }

    public void setColorMask(int redMask, int greenMask, int blueMask, int alphaMask) {
        this.colorMask[0] = redMask;
        this.colorMask[1] = greenMask;
        this.colorMask[2] = blueMask;
        this.colorMask[3] = alphaMask;
    }

    public int[] getNotColorMask() {
        return this.notColorMask;
    }

    public void setNotColorMask(int notRedMask, int notGreenMask, int notBlueMask, int notAlphaMask) {
        this.notColorMask[0] = notRedMask;
        this.notColorMask[1] = notGreenMask;
        this.notColorMask[2] = notBlueMask;
        this.notColorMask[3] = notAlphaMask;
    }

    public int getAlphaTestEnable() {
        return this.alphaTestEnable;
    }

    public void setAlphaTestEnable(int alphaTestEnable) {
        this.alphaTestEnable = alphaTestEnable;
    }

    public int getAlphaTestFunc() {
        return this.alphaTestFunc;
    }

    public void setAlphaTestFunc(int alphaTestFunc) {
        this.alphaTestFunc = alphaTestFunc;
    }

    public int getAlphaTestRef() {
        return this.alphaTestRef;
    }

    public void setAlphaTestRef(int alphaTestRef) {
        this.alphaTestRef = alphaTestRef;
    }

    public int getBlendTestEnable() {
        return this.blendTestEnable;
    }

    public void setBlendTestEnable(int blendTestEnable) {
        this.blendTestEnable = blendTestEnable;
    }

    public int getBlendEquation() {
        return this.blendEquation;
    }

    public void setBlendEquation(int blendEquation) {
        this.blendEquation = blendEquation;
    }

    public int getBlendSrc() {
        return this.blendSrc;
    }

    public void setBlendSrc(int blendSrc) {
        this.blendSrc = blendSrc;
    }

    public int getBlendDst() {
        return this.blendDst;
    }

    public void setBlendDst(int blendDst) {
        this.blendDst = blendDst;
    }

    public float[] getBlendSFix() {
        return this.blendSFix;
    }

    public void setBlendSFix(float[] blendSFix) {
        this.blendSFix[0] = blendSFix[0];
        this.blendSFix[1] = blendSFix[1];
        this.blendSFix[2] = blendSFix[2];
    }

    public float[] getBlendDFix() {
        return this.blendDFix;
    }

    public void setBlendDFix(float[] blendDFix) {
        this.blendDFix[0] = blendDFix[0];
        this.blendDFix[1] = blendDFix[1];
        this.blendDFix[2] = blendDFix[2];
    }

    public int getCopyRedToAlpha() {
        return this.copyRedToAlpha;
    }

    public void setCopyRedToAlpha(int copyRedToAlpha) {
        this.copyRedToAlpha = copyRedToAlpha;
    }

    public int getWrapModeS() {
        return this.wrapModeS;
    }

    public void setWrapModeS(int wrapModeS) {
        this.wrapModeS = wrapModeS;
    }

    public int getWrapModeT() {
        return this.wrapModeT;
    }

    public void setWrapModeT(int wrapModeT) {
        this.wrapModeT = wrapModeT;
    }
}

