/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.psmf;

import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractProxyVirtualFile;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.format.psmf.PesHeader;
import jpcsp.media.MediaEngine;
import org.apache.log4j.Logger;

public class PsmfAudioDemuxVirtualFile
extends AbstractProxyVirtualFile {
    private static Logger log = MediaEngine.log;
    public static final int PACKET_START_CODE_MASK = -256;
    public static final int PACKET_START_CODE_PREFIX = 256;
    public static final int SEQUENCE_START_CODE = 435;
    public static final int EXT_START_CODE = 437;
    public static final int SEQUENCE_END_CODE = 439;
    public static final int GOP_START_CODE = 440;
    public static final int ISO_11172_END_CODE = 441;
    public static final int PACK_START_CODE = 442;
    public static final int SYSTEM_HEADER_START_CODE = 443;
    public static final int PROGRAM_STREAM_MAP = 444;
    public static final int PRIVATE_STREAM_1 = 445;
    public static final int PADDING_STREAM = 446;
    public static final int PRIVATE_STREAM_2 = 447;
    private byte[] buffer = new byte[1];
    private int audioChannel;
    private long position;
    private int mpegOffset;
    private long startPosition;

    public PsmfAudioDemuxVirtualFile(IVirtualFile vFile, int mpegOffset, int audioChannel) {
        super(vFile);
        this.mpegOffset = mpegOffset;
        this.audioChannel = audioChannel;
        this.startPosition = vFile.getPosition();
        if (mpegOffset > 0) {
            vFile.ioLseek(this.startPosition + (long)mpegOffset);
        } else {
            this.mpegOffset = 0;
        }
    }

    private int read8() {
        if (this.vFile.ioRead(this.buffer, 0, 1) != 1) {
            return -1;
        }
        return this.buffer[0] & 0xFF;
    }

    private int read16() {
        return this.read8() << 8 | this.read8();
    }

    private long readPts() {
        return this.readPts(this.read8());
    }

    private long readPts(int c) {
        return (long)(c & 0xE) << 29 | (long)(this.read16() >> 1 << 15) | (long)(this.read16() >> 1);
    }

    private void skip(int n) {
        if (n > 0) {
            this.vFile.ioLseek(this.vFile.getPosition() + (long)n);
        }
    }

    private int readPesHeader(PesHeader pesHeader, int length, int startCode) {
        int c = 0;
        while (length > 0) {
            c = this.read8();
            --length;
            if (c == 255) continue;
        }
        if ((c & 0xC0) == 64) {
            this.read8();
            c = this.read8();
            length -= 2;
        }
        pesHeader.pts = 0L;
        pesHeader.dts = 0L;
        if ((c & 0xE0) == 32) {
            pesHeader.dts = pesHeader.pts = this.readPts(c);
            length -= 4;
            if ((c & 0x10) != 0) {
                pesHeader.dts = this.readPts();
                length -= 5;
            }
        } else if ((c & 0xC0) == 128) {
            int flags = this.read8();
            int headerLength = this.read8();
            length -= 2;
            length -= headerLength;
            if ((flags & 0x80) != 0) {
                pesHeader.dts = pesHeader.pts = this.readPts();
                headerLength -= 5;
                if ((flags & 0x40) != 0) {
                    pesHeader.dts = this.readPts();
                    headerLength -= 5;
                }
            }
            if ((flags & 0x3F) != 0 && headerLength == 0) {
                flags &= 0xC0;
            }
            if ((flags & 1) != 0) {
                int pesExt = this.read8();
                int skip = pesExt >> 4 & 0xB;
                skip += skip & 9;
                if ((pesExt & 0x40) != 0 || skip > --headerLength) {
                    skip = 0;
                    pesExt = 0;
                }
                this.skip(skip);
                headerLength -= skip;
                if ((pesExt & 1) != 0) {
                    int ext2Length = this.read8();
                    --headerLength;
                    if ((ext2Length & 0x7F) != 0) {
                        int idExt = this.read8();
                        --headerLength;
                        if ((idExt & 0x80) == 0) {
                            startCode = (startCode & 0xFF) << 8 | idExt;
                        }
                    }
                }
            }
            this.skip(headerLength);
        }
        if (startCode == 445) {
            int channel;
            pesHeader.channel = channel = this.read8();
            --length;
            if (channel >= 128 && channel <= 207) {
                this.skip(3);
                length -= 3;
                if (channel >= 176 && channel <= 191) {
                    this.skip(1);
                    --length;
                }
            } else {
                this.skip(3);
                length -= 3;
            }
        }
        return length;
    }

    private boolean isEOF() {
        return this.vFile.getPosition() >= this.vFile.length();
    }

    private int doRead(TPointer outputPointer, byte[] outputBuffer, int outputOffset, int outputLength) {
        int readAddr;
        if (this.isEOF()) {
            return -1;
        }
        int readLength = 0;
        int n = readAddr = outputPointer != null ? outputPointer.getAddress() : 0;
        block7: while (!this.isEOF() && readLength < outputLength) {
            long startIndex = this.vFile.getPosition();
            int startCode = 255;
            while ((startCode & 0xFFFFFF00) != 256 && !this.isEOF()) {
                startCode = startCode << 8 | this.read8();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("StartCode 0x%08X, offset %08X, skipped %d", startCode, this.vFile.getPosition(), this.vFile.getPosition() - startIndex - 4L));
            }
            block0 : switch (startCode) {
                case 442: {
                    this.skip(10);
                    break;
                }
                case 443: {
                    this.skip(14);
                    break;
                }
                case 446: 
                case 447: {
                    int length = this.read16();
                    this.skip(length);
                    break;
                }
                case 445: {
                    int length = this.read16();
                    PesHeader pesHeader = new PesHeader(this.audioChannel);
                    length = this.readPesHeader(pesHeader, length, startCode);
                    if (pesHeader.channel == this.audioChannel || this.audioChannel < 0) {
                        int packetLength = 0;
                        while (packetLength < length) {
                            int maxReadLength = Math.min(length - packetLength, outputLength - readLength);
                            int l = outputBuffer != null ? this.vFile.ioRead(outputBuffer, outputOffset, maxReadLength) : (outputPointer != null ? this.vFile.ioRead(new TPointer(outputPointer.getMemory(), readAddr), maxReadLength) : maxReadLength);
                            if (l > 0) {
                                readLength += l;
                                readAddr += l;
                                outputOffset += l;
                                packetLength += l;
                                this.position += (long)l;
                                continue;
                            }
                            if (l >= 0) continue;
                            break block0;
                        }
                        continue block7;
                    }
                    this.skip(length);
                    break;
                }
                case 480: 
                case 481: 
                case 482: 
                case 483: 
                case 484: 
                case 485: 
                case 486: 
                case 487: 
                case 488: 
                case 489: 
                case 490: 
                case 491: 
                case 492: 
                case 493: 
                case 494: 
                case 495: {
                    int length = this.read16();
                    this.skip(length);
                    break;
                }
                default: {
                    log.warn((Object)String.format("Unknown StartCode 0x%08X, offset %08X", startCode, this.vFile.getPosition()));
                }
            }
        }
        return readLength;
    }

    @Override
    public int ioRead(TPointer outputPointer, int outputLength) {
        return this.doRead(outputPointer, null, 0, outputLength);
    }

    @Override
    public int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        return this.doRead(null, outputBuffer, outputOffset, outputLength);
    }

    @Override
    public long ioLseek(long offset) {
        long result = this.vFile.ioLseek(this.startPosition + (long)this.mpegOffset);
        if (result < 0L) {
            return result;
        }
        this.position = 0L;
        while (this.getPosition() < offset) {
            int length = this.doRead(null, null, 0, offset < Integer.MAX_VALUE ? (int)offset : Integer.MAX_VALUE);
            if (length >= 0) continue;
            return -1L;
        }
        return this.getPosition();
    }

    @Override
    public long length() {
        return super.length() - this.startPosition - (long)this.mpegOffset;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public IVirtualFile duplicate() {
        return super.duplicate();
    }
}

