/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.filesystems.umdiso;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import jpcsp.Emulator;
import jpcsp.filesystems.umdiso.ISectorDevice;
import org.apache.log4j.Logger;

public class ISOFileSectorDevice
implements ISectorDevice {
    protected static Logger log = Emulator.log;
    protected RandomAccessFile fileAccess;

    public ISOFileSectorDevice(RandomAccessFile fileAccess) {
        this.fileAccess = fileAccess;
    }

    @Override
    public int getNumSectors() throws IOException {
        return (int)(this.fileAccess.length() / 2048L);
    }

    @Override
    public void readSector(int sectorNumber, byte[] buffer, int offset) throws IOException {
        this.fileAccess.seek(2048L * (long)sectorNumber);
        int length = this.fileAccess.read(buffer, offset, 2048);
        if (length < 2048) {
            Arrays.fill(buffer, length, 2048, (byte)0);
        }
    }

    @Override
    public int readSectors(int sectorNumber, int numberSectors, byte[] buffer, int offset) throws IOException {
        this.fileAccess.seek(2048L * (long)sectorNumber);
        int length = this.fileAccess.read(buffer, offset, numberSectors * 2048);
        return length / 2048;
    }

    @Override
    public void close() throws IOException {
        this.fileAccess.close();
        this.fileAccess = null;
    }

    @Override
    public void writeSector(int sectorNumber, byte[] buffer, int offset) throws IOException {
        this.writeSectors(sectorNumber, 1, buffer, offset);
    }

    @Override
    public void writeSectors(int sectorNumber, int numberSectors, byte[] buffer, int offset) throws IOException {
        this.fileAccess.seek(2048L * (long)sectorNumber);
        this.fileAccess.write(buffer, offset, numberSectors * 2048);
    }
}

