/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.crypto;

import jpcsp.crypto.AMCTRL;
import jpcsp.crypto.DRM;
import jpcsp.crypto.KeyVault;

public class PGD {
    private static AMCTRL amctrl;
    private static DRM drm;
    private static AMCTRL.BBCipher_Ctx pgdCipherContext;
    private static AMCTRL.BBMac_Ctx pgdMacContext;

    public PGD() {
        amctrl = new AMCTRL();
        drm = new DRM();
    }

    public byte[] DecryptPGD(byte[] inbuf, int size, byte[] key) {
        int sdEncMode = 1;
        int sdGenMode = 2;
        pgdMacContext = new AMCTRL.BBMac_Ctx();
        pgdCipherContext = new AMCTRL.BBCipher_Ctx();
        int alignedSize = size + 15 >> 4 << 4;
        byte[] outbuf = new byte[alignedSize - 16];
        byte[] dataBuf = new byte[alignedSize];
        System.arraycopy(inbuf, 0, dataBuf, 0, size);
        amctrl.hleDrmBBMacInit(pgdMacContext, sdEncMode);
        amctrl.hleDrmBBCipherInit(pgdCipherContext, sdEncMode, sdGenMode, dataBuf, key, 0);
        amctrl.hleDrmBBMacUpdate(pgdMacContext, dataBuf, 16);
        System.arraycopy(dataBuf, 16, outbuf, 0, alignedSize - 16);
        amctrl.hleDrmBBMacUpdate(pgdMacContext, outbuf, alignedSize - 16);
        amctrl.hleDrmBBCipherUpdate(pgdCipherContext, outbuf, alignedSize - 16);
        return outbuf;
    }

    public byte[] UpdatePGDCipher(byte[] inbuf, int size) {
        int alignedSize = size + 15 >> 4 << 4;
        byte[] outbuf = new byte[alignedSize - 16];
        byte[] dataBuf = new byte[alignedSize];
        System.arraycopy(inbuf, 0, dataBuf, 0, size);
        System.arraycopy(dataBuf, 16, outbuf, 0, alignedSize - 16);
        amctrl.hleDrmBBCipherUpdate(pgdCipherContext, outbuf, alignedSize - 16);
        return outbuf;
    }

    public void FinishPGDCipher() {
        amctrl.hleDrmBBCipherFinal(pgdCipherContext);
    }

    public byte[] DecryptEDATPGD(byte[] inbuf, int size, int hashOffset, int chunkSize, byte[] key) {
        int cipherEncMode;
        int macEncMode;
        int genMode = 2;
        pgdMacContext = new AMCTRL.BBMac_Ctx();
        pgdCipherContext = new AMCTRL.BBCipher_Ctx();
        int alignedSize = size + 15 >> 4 << 4;
        int hashTableOffset = hashOffset + alignedSize;
        int chunkNum = (alignedSize + chunkSize - 1 & ~(chunkSize - 1)) / chunkSize;
        byte keyIndex = inbuf[4];
        byte drmType = inbuf[8];
        if ((drmType & 1) == 1) {
            macEncMode = 1;
            if (keyIndex > 1) {
                macEncMode = 3;
            }
            cipherEncMode = 1;
        } else {
            macEncMode = 2;
            cipherEncMode = 2;
        }
        byte[] hashTable = new byte[chunkNum * 16];
        System.arraycopy(inbuf, hashTableOffset, hashTable, 0, hashTable.length);
        byte[] macKey60 = new byte[16];
        System.arraycopy(inbuf, 96, macKey60, 0, 16);
        amctrl.hleDrmBBMacInit(pgdMacContext, macEncMode);
        amctrl.hleDrmBBMacUpdate(pgdMacContext, hashTable, hashTable.length);
        amctrl.hleDrmBBMacFinal2(pgdMacContext, macKey60, key);
        byte[] decDataBuf = new byte[inbuf.length - 48];
        System.arraycopy(inbuf, 48, decDataBuf, 0, decDataBuf.length);
        byte[] updateDecDataBuf = new byte[inbuf.length - 144];
        System.arraycopy(inbuf, 144, updateDecDataBuf, 0, updateDecDataBuf.length);
        amctrl.hleDrmBBCipherInit(pgdCipherContext, cipherEncMode, genMode, decDataBuf, key, 0);
        amctrl.hleDrmBBCipherUpdate(pgdCipherContext, updateDecDataBuf, alignedSize);
        amctrl.hleDrmBBCipherFinal(pgdCipherContext);
        byte[] outbuf = new byte[size];
        System.arraycopy(updateDecDataBuf, 0, outbuf, 0, outbuf.length);
        return outbuf;
    }

    public byte[] DecryptEDATPGDHeader(byte[] inbuf, int size, byte[] key) {
        int genMode = 2;
        pgdCipherContext = new AMCTRL.BBCipher_Ctx();
        int alignedSize = size + 15 >> 4 << 4;
        byte[] dataBuf = new byte[alignedSize];
        System.arraycopy(inbuf, 0, dataBuf, 0, size);
        byte drmType = dataBuf[8];
        int cipherEncMode = (drmType & 1) == 1 ? 1 : 2;
        byte[] cipherBuf = new byte[dataBuf.length - 16];
        byte[] pgdDataBuf = new byte[48];
        System.arraycopy(dataBuf, 16, cipherBuf, 0, dataBuf.length - 16);
        System.arraycopy(dataBuf, 48, pgdDataBuf, 0, 48);
        amctrl.hleDrmBBCipherInit(pgdCipherContext, cipherEncMode, genMode, cipherBuf, key, 0);
        amctrl.hleDrmBBCipherUpdate(pgdCipherContext, pgdDataBuf, 48);
        amctrl.hleDrmBBCipherFinal(pgdCipherContext);
        return pgdDataBuf;
    }

    public byte[] GetEDATPGDKey(byte[] inbuf, int size) {
        int i;
        int macEncMode;
        int pgdFlag = 2;
        pgdMacContext = new AMCTRL.BBMac_Ctx();
        int alignedSize = size + 15 >> 4 << 4;
        byte[] dataBuf = new byte[alignedSize];
        System.arraycopy(inbuf, 0, dataBuf, 0, size);
        byte keyIndex = dataBuf[4];
        byte drmType = dataBuf[8];
        if ((drmType & 1) == 1) {
            macEncMode = 1;
            pgdFlag |= 4;
            if (keyIndex > 1) {
                macEncMode = 3;
                pgdFlag |= 8;
            }
        } else {
            macEncMode = 2;
        }
        byte[] dnasKey = new byte[16];
        if ((pgdFlag & 2) == 2) {
            for (i = 0; i < KeyVault.drmDNASKey1.length; ++i) {
                dnasKey[i] = (byte)(KeyVault.drmDNASKey1[i] & 0xFF);
            }
        } else if ((pgdFlag & 1) == 1) {
            for (i = 0; i < KeyVault.drmDNASKey2.length; ++i) {
                dnasKey[i] = (byte)(KeyVault.drmDNASKey2[i] & 0xFF);
            }
        } else {
            return null;
        }
        byte[] macKey80 = new byte[16];
        System.arraycopy(dataBuf, 128, macKey80, 0, 16);
        byte[] macKey70 = new byte[16];
        System.arraycopy(dataBuf, 112, macKey70, 0, 16);
        amctrl.hleDrmBBMacInit(pgdMacContext, macEncMode);
        amctrl.hleDrmBBMacUpdate(pgdMacContext, dataBuf, 128);
        amctrl.hleDrmBBMacFinal2(pgdMacContext, macKey80, dnasKey);
        amctrl.hleDrmBBMacInit(pgdMacContext, macEncMode);
        amctrl.hleDrmBBMacUpdate(pgdMacContext, dataBuf, 112);
        byte[] key = new byte[16];
        amctrl.GetKeyFromBBMac(pgdMacContext, macKey70, key);
        return key;
    }

    public boolean CheckEDATRenameKey(byte[] nameHash, byte[] hash, byte[] data) {
        byte[] newHash = drm.hleNpDrmGetFixedKey(hash, data, 1);
        for (int i = 0; i < 16; ++i) {
            if (nameHash[i] == newHash[i]) continue;
            return false;
        }
        return true;
    }
}

