/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules395;

import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.pspFileBuffer;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules150.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

@HLELogging
public class sceAac
extends HLEModule {
    public static Logger log = Modules.getLogger("sceAac");
    protected SysMemUserForUser.SysMemInfo resourceMem;
    protected AacInfo[] ids;

    @Override
    public String getName() {
        return "sceAac";
    }

    @Override
    public void start() {
        this.ids = null;
        super.start();
    }

    public int checkId(int id) {
        if (this.ids == null || this.ids.length == 0) {
            throw new SceKernelErrorException(-2140596989);
        }
        if (id < 0 || id >= this.ids.length) {
            throw new SceKernelErrorException(-2140598271);
        }
        return id;
    }

    public int checkInitId(int id) {
        if (!this.ids[id = this.checkId(id)].isInit()) {
            throw new SceKernelErrorException(-2140598013);
        }
        return id;
    }

    protected AacInfo getAacInfo(int id) {
        return this.ids[id];
    }

    @HLEUnimplemented
    @HLEFunction(nid=-523724086, version=395)
    public int sceAacInit(@CanBeNull TPointer32 parameters, int unknown1, int unknown2, int unknown3) {
        if (parameters.isNull()) {
            return -2140598270;
        }
        long startPos = (long)parameters.getValue(0) << 32 | (long)parameters.getValue(4);
        long endPos = (long)parameters.getValue(8) << 32 | (long)parameters.getValue(12);
        int bufferAddr = parameters.getValue(16);
        int bufferSize = parameters.getValue(20);
        int outputAddr = parameters.getValue(24);
        int outputSize = parameters.getValue(28);
        int freq = parameters.getValue(32);
        int reserved = parameters.getValue(36);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAacInit parameters: startPos=0x%16X, endPos=0x%16X, bufferAddr=0x%08X, bufferSize=0x%X, outputAddr=0x%08X, outputSize=0x%X, freq=%d, reserved=0x%08X", startPos, endPos, bufferAddr, bufferSize, outputAddr, outputSize, freq, reserved));
        }
        if (bufferAddr == 0 || outputAddr == 0) {
            return -2140598270;
        }
        if (startPos < 0L || startPos > endPos) {
            return -2140598269;
        }
        if (bufferSize < 8192 || outputSize < 8192 || reserved != 0) {
            return -2140598269;
        }
        if (freq != 44100 && freq != 32000 && freq != 48000 && freq != 24000) {
            return -2140598269;
        }
        int id = -1;
        for (int i = 0; i < this.ids.length; ++i) {
            if (this.ids[i].isInit()) continue;
            id = i;
            break;
        }
        if (id < 0) {
            return -2140597759;
        }
        this.ids[id].init(bufferAddr, bufferSize, outputAddr, outputSize);
        return id;
    }

    @HLEUnimplemented
    @HLEFunction(nid=867745801, version=395)
    public int sceAacExit(@CheckArgument(value="checkId") int id) {
        this.getAacInfo(id).exit();
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1560266108, version=395)
    public int sceAacInitResource(int numberIds) {
        int memSize = numberIds * 102400;
        this.resourceMem = Modules.SysMemUserForUserModule.malloc(2, "SceLibAacResource", 0, memSize, 0);
        if (this.resourceMem == null) {
            return -2140596991;
        }
        Memory.getInstance().memset(this.resourceMem.addr, (byte)0, memSize);
        this.ids = new AacInfo[numberIds];
        for (int i = 0; i < numberIds; ++i) {
            this.ids[i] = new AacInfo();
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=601054382, version=395)
    public int sceAacTermResource() {
        if (this.resourceMem != null) {
            Modules.SysMemUserForUserModule.free(this.resourceMem);
            this.resourceMem = null;
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2118975204, version=395)
    public int sceAacDecode(@CheckArgument(value="checkInitId") int id, @CanBeNull TPointer32 bufferAddress) {
        int result = this.getAacInfo(id).decode(bufferAddress);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAacDecode bufferAddress=%s(0x%08X) returning 0x%X", bufferAddress, bufferAddress.getValue(), result));
        }
        if (result >= 0) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(2300, false);
        }
        return result;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1379092441, version=395)
    public int sceAacGetLoopNum() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1143118845, version=395)
    public int sceAacSetLoopNum() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-674949823, version=395)
    public boolean sceAacCheckStreamDataNeeded(@CheckArgument(value="checkInitId") int id) {
        return this.getAacInfo(id).isStreamDataNeeded();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1402090525, version=395)
    public int sceAacNotifyAddStreamData(@CheckArgument(value="checkInitId") int id, int bytesToAdd) {
        return this.getAacInfo(id).notifyAddStream(bytesToAdd);
    }

    @HLEUnimplemented
    @HLEFunction(nid=34180201, version=395)
    public int sceAacGetInfoToAddStreamData(@CheckArgument(value="checkInitId") int id, @CanBeNull TPointer32 writeAddr, @CanBeNull TPointer32 writableBytesAddr, @CanBeNull TPointer32 readOffsetAddr) {
        AacInfo info = this.getAacInfo(id);
        writeAddr.setValue(info.getInputBuffer().getWriteAddr());
        writableBytesAddr.setValue(info.getInputBuffer().getWriteSize());
        readOffsetAddr.setValue(info.getInputBuffer().getFilePosition());
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1841788298, version=395)
    public int sceAacGetMaxOutputSample() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1349252716, version=395)
    public int sceAacGetSumDecodedSample(@CheckArgument(value="checkInitId") int id) {
        int sumDecodedSamples = this.getAacInfo(id).getSumDecodedSamples();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAacGetSumDecodedSample returning 0x%X", sumDecodedSamples));
        }
        return sumDecodedSamples;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-757453894, version=395)
    public int sceAacResetPlayPosition() {
        return 0;
    }

    protected static class AacInfo {
        private boolean init;
        private pspFileBuffer inputBuffer;
        private int outputAddr;
        private int outputSize;
        private int sumDecodedSamples;

        protected AacInfo() {
        }

        public boolean isInit() {
            return this.init;
        }

        public void init(int bufferAddr, int bufferSize, int outputAddr, int outputSize) {
            this.init = true;
            this.inputBuffer = new pspFileBuffer(bufferAddr, bufferSize);
            this.inputBuffer.setFileMaxSize(Integer.MAX_VALUE);
            this.outputAddr = outputAddr;
            this.outputSize = outputSize;
        }

        public void exit() {
            this.init = false;
        }

        public int notifyAddStream(int bytesToAdd) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("notifyAddStream: %s", Utilities.getMemoryDump(this.inputBuffer.getWriteAddr(), bytesToAdd)));
            }
            this.inputBuffer.notifyWrite(bytesToAdd);
            return 0;
        }

        public pspFileBuffer getInputBuffer() {
            return this.inputBuffer;
        }

        public boolean isStreamDataNeeded() {
            return this.inputBuffer.getWriteSize() > 0;
        }

        public int getSumDecodedSamples() {
            return this.sumDecodedSamples;
        }

        public int decode(TPointer32 bufferAddress) {
            bufferAddress.setValue(this.outputAddr);
            int samples = 1024;
            int outputBytes = samples * 4;
            Memory.getInstance().memset(this.outputAddr, (byte)127, outputBytes);
            this.sumDecodedSamples += samples;
            return outputBytes;
        }
    }
}

