/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import jpcsp.Controller;
import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.kernel.managers.SystemTimeManager;
import jpcsp.HLE.kernel.types.SceFontInfo;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.kernel.types.SceUtilityGameSharingParams;
import jpcsp.HLE.kernel.types.SceUtilityGamedataInstallParams;
import jpcsp.HLE.kernel.types.SceUtilityHtmlViewerParams;
import jpcsp.HLE.kernel.types.SceUtilityMsgDialogParams;
import jpcsp.HLE.kernel.types.SceUtilityNetconfParams;
import jpcsp.HLE.kernel.types.SceUtilityNpSigninParams;
import jpcsp.HLE.kernel.types.SceUtilityOskParams;
import jpcsp.HLE.kernel.types.SceUtilitySavedataParam;
import jpcsp.HLE.kernel.types.SceUtilityScreenshotParams;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.HLE.kernel.types.pspCharInfo;
import jpcsp.HLE.kernel.types.pspUtilityDialogCommon;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.IoFileMgrForUser;
import jpcsp.HLE.modules.sceNetApctl;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.State;
import jpcsp.crypto.CryptoEngine;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.format.PSF;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VideoEngine;
import jpcsp.hardware.MemoryStick;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.ImageReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.settings.Settings;
import jpcsp.util.MemoryInputStream;
import jpcsp.util.Utilities;
import jpcsp.util.sceGu;
import org.apache.log4j.Logger;

@HLELogging
public class sceUtility
extends HLEModule {
    public static Logger log = Modules.getLogger("sceUtility");
    public static final String SYSTEMPARAM_SETTINGS_OPTION_NICKNAME = "emu.sysparam.nickname";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_ADHOC_CHANNEL = "emu.sysparam.adhocchannel";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_WLAN_POWER_SAVE = "emu.sysparam.wlanpowersave";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_DATE_FORMAT = "emu.sysparam.dateformat";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_TIME_FORMAT = "emu.sysparam.timeformat";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_TIME_ZONE = "emu.sysparam.timezone";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_DAYLIGHT_SAVING_TIME = "emu.sysparam.daylightsavings";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_LANGUAGE = "emu.impose.language";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_BUTTON_PREFERENCE = "emu.impose.button";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_LOCK_PARENTAL_LEVEL = "emu.sysparam.locl.parentallevel";
    public static final int PSP_SYSTEMPARAM_ID_STRING_NICKNAME = 1;
    public static final int PSP_SYSTEMPARAM_ID_INT_ADHOC_CHANNEL = 2;
    public static final int PSP_SYSTEMPARAM_ID_INT_WLAN_POWERSAVE = 3;
    public static final int PSP_SYSTEMPARAM_ID_INT_DATE_FORMAT = 4;
    public static final int PSP_SYSTEMPARAM_ID_INT_TIME_FORMAT = 5;
    public static final int PSP_SYSTEMPARAM_ID_INT_TIMEZONE = 6;
    public static final int PSP_SYSTEMPARAM_ID_INT_DAYLIGHTSAVINGS = 7;
    public static final int PSP_SYSTEMPARAM_ID_INT_LANGUAGE = 8;
    public static final int PSP_SYSTEMPARAM_ID_INT_BUTTON_PREFERENCE = 9;
    public static final int PSP_SYSTEMPARAM_ID_INT_LOCK_PARENTAL_LEVEL = 10;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_JAPANESE = 0;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_ENGLISH = 1;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_FRENCH = 2;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_SPANISH = 3;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_GERMAN = 4;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_ITALIAN = 5;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_DUTCH = 6;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_PORTUGUESE = 7;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_RUSSIAN = 8;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_KOREAN = 9;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_CHINESE_TRADITIONAL = 10;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_CHINESE_SIMPLIFIED = 11;
    public static final int PSP_SYSTEMPARAM_DATE_FORMAT_YYYYMMDD = 0;
    public static final int PSP_SYSTEMPARAM_DATE_FORMAT_MMDDYYYY = 1;
    public static final int PSP_SYSTEMPARAM_DATE_FORMAT_DDMMYYYY = 2;
    public static final int PSP_SYSTEMPARAM_TIME_FORMAT_24HR = 0;
    public static final int PSP_SYSTEMPARAM_TIME_FORMAT_12HR = 1;
    public static final int PSP_SYSTEMPARAM_BUTTON_CIRCLE = 0;
    public static final int PSP_SYSTEMPARAM_BUTTON_CROSS = 1;
    public static final int PSP_UTILITY_DIALOG_STATUS_NONE = 0;
    public static final int PSP_UTILITY_DIALOG_STATUS_INIT = 1;
    public static final int PSP_UTILITY_DIALOG_STATUS_VISIBLE = 2;
    public static final int PSP_UTILITY_DIALOG_STATUS_QUIT = 3;
    public static final int PSP_UTILITY_DIALOG_STATUS_FINISHED = 4;
    public static final int PSP_UTILITY_DIALOG_STATUS_SCREENSHOT_UNKNOWN = 5;
    public static final int PSP_UTILITY_DIALOG_RESULT_OK = 0;
    public static final int PSP_UTILITY_DIALOG_RESULT_CANCELED = 1;
    public static final int PSP_UTILITY_DIALOG_RESULT_ABORTED = 2;
    public static final int PSP_NETPARAM_NAME = 0;
    public static final int PSP_NETPARAM_SSID = 1;
    public static final int PSP_NETPARAM_SECURE = 2;
    public static final int PSP_NETPARAM_WEPKEY = 3;
    public static final int PSP_NETPARAM_IS_STATIC_IP = 4;
    public static final int PSP_NETPARAM_IP = 5;
    public static final int PSP_NETPARAM_NETMASK = 6;
    public static final int PSP_NETPARAM_ROUTE = 7;
    public static final int PSP_NETPARAM_MANUAL_DNS = 8;
    public static final int PSP_NETPARAM_PRIMARYDNS = 9;
    public static final int PSP_NETPARAM_SECONDARYDNS = 10;
    public static final int PSP_NETPARAM_PROXY_USER = 11;
    public static final int PSP_NETPARAM_PROXY_PASS = 12;
    public static final int PSP_NETPARAM_USE_PROXY = 13;
    public static final int PSP_NETPARAM_PROXY_SERVER = 14;
    public static final int PSP_NETPARAM_PROXY_PORT = 15;
    public static final int PSP_NETPARAM_UNKNOWN1 = 16;
    public static final int PSP_NETPARAM_UNKNOWN2 = 17;
    protected static final int maxLineLengthForDialog = 40;
    protected static final int icon0Width = 144;
    protected static final int icon0Height = 80;
    protected static final int icon0PixelFormat = 3;
    protected static final int smallIcon0Width = 80;
    protected static final int smallIcon0Height = 44;
    protected static final int icon0BufferWidth = VideoEngine.alignBufferWidth(144 + IRenderingEngine.alignementOfTextureBufferWidth[3] - 1, 3);
    protected GameSharingUtilityDialogState gameSharingState;
    protected UtilityDialogState netplayDialogState;
    protected NetconfUtilityDialogState netconfState;
    protected SavedataUtilityDialogState savedataState;
    protected MsgDialogUtilityDialogState msgDialogState;
    protected OskUtilityDialogState oskState;
    protected UtilityDialogState npSigninState;
    protected UtilityDialogState PS3ScanState;
    protected UtilityDialogState rssReaderState;
    protected UtilityDialogState rssSubscriberState;
    protected ScreenshotUtilityDialogState screenshotState;
    protected HtmlViewerUtilityDialogState htmlViewerState;
    protected UtilityDialogState savedataErrState;
    protected GamedataInstallUtilityDialogState gamedataInstallState;
    protected UtilityDialogState startedDialogState;
    private static final String dummyNetParamName = "NetConf #%d";
    private static final int numberNetConfigurations = 1;

    @Override
    public String getName() {
        return "sceUtility";
    }

    @Override
    public void start() {
        this.gameSharingState = new GameSharingUtilityDialogState("sceUtilityGameSharing");
        this.netplayDialogState = new NotImplementedUtilityDialogState("sceNetplayDialog");
        this.netconfState = new NetconfUtilityDialogState("sceUtilityNetconf");
        this.savedataState = new SavedataUtilityDialogState("sceUtilitySavedata");
        this.msgDialogState = new MsgDialogUtilityDialogState("sceUtilityMsgDialog");
        this.oskState = new OskUtilityDialogState("sceUtilityOsk");
        this.npSigninState = new NpSigninUtilityDialogState("sceUtilityNpSignin");
        this.PS3ScanState = new NotImplementedUtilityDialogState("sceUtilityPS3Scan");
        this.rssReaderState = new NotImplementedUtilityDialogState("sceUtilityRssReader");
        this.rssSubscriberState = new NotImplementedUtilityDialogState("sceUtilityRssSubscriber");
        this.screenshotState = new ScreenshotUtilityDialogState("sceUtilityScreenshot");
        this.htmlViewerState = new HtmlViewerUtilityDialogState("sceUtilityHtmlViewer");
        this.savedataErrState = new NotImplementedUtilityDialogState("sceUtilitySavedataErr");
        this.gamedataInstallState = new GamedataInstallUtilityDialogState("sceUtilityGamedataInstall");
        this.startedDialogState = null;
        super.start();
    }

    public static String getSystemParamNickname() {
        return Settings.getInstance().readString(SYSTEMPARAM_SETTINGS_OPTION_NICKNAME);
    }

    public static int getSystemParamAdhocChannel() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_ADHOC_CHANNEL, 0);
    }

    public static int getSystemParamWlanPowersave() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_WLAN_POWER_SAVE, 0);
    }

    public static int getSystemParamDateFormat() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_DATE_FORMAT, 0);
    }

    public static int getSystemParamTimeFormat() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_TIME_FORMAT, 0);
    }

    public static int getSystemParamTimeZone() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_TIME_ZONE, 0);
    }

    public static int getSystemParamDaylightSavingTime() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_DAYLIGHT_SAVING_TIME, 0);
    }

    public static int getSystemParamLanguage() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_LANGUAGE, 1);
    }

    public static int getSystemParamButtonPreference() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_BUTTON_PREFERENCE, 1);
    }

    public static int getSystemParamLockParentalLevel() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_LOCK_PARENTAL_LEVEL, 0);
    }

    protected static String getNetParamName(int id) {
        if (id == 0) {
            return "";
        }
        return String.format(dummyNetParamName, id);
    }

    protected static String formatMessageForDialog(String message) {
        StringBuilder formattedMessage = new StringBuilder();
        int i = 0;
        while (i < message.length()) {
            String rest = message.substring(i);
            int newLineIndex = rest.indexOf("\n");
            if (newLineIndex >= 0 && newLineIndex < 40) {
                formattedMessage.append(rest.substring(0, newLineIndex + 1));
                i += newLineIndex + 1;
                continue;
            }
            if (rest.length() > 40) {
                int lastSpace = rest.lastIndexOf(32, 40);
                rest = rest.substring(0, lastSpace >= 0 ? lastSpace : 40);
                formattedMessage.append(rest);
                i += rest.length() + 1;
                formattedMessage.append("\n");
                continue;
            }
            formattedMessage.append(rest);
            i += rest.length();
        }
        return formattedMessage.toString();
    }

    @HLEFunction(nid=-997001391, version=150)
    public int sceUtilityGameSharingInitStart(TPointer paramsAddr) {
        return this.gameSharingState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=-272173041, version=150)
    public int sceUtilityGameSharingShutdownStart() {
        return this.gameSharingState.executeShutdownStart();
    }

    @HLEFunction(nid=2018711597, version=150)
    public int sceUtilityGameSharingUpdate(int drawSpeed) {
        return this.gameSharingState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-1805032461, version=150)
    public int sceUtilityGameSharingGetStatus() {
        return this.gameSharingState.executeGetStatus();
    }

    @HLEFunction(nid=987040487, version=150)
    public int sceNetplayDialogInitStart(TPointer paramsAddr) {
        return this.netplayDialogState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=-1133813098, version=150)
    public int sceNetplayDialogShutdownStart() {
        return this.netplayDialogState.executeShutdownStart();
    }

    @HLEFunction(nid=1098640724, version=150)
    public int sceNetplayDialogUpdate(int drawSpeed) {
        return this.netplayDialogState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-1227954793, version=150)
    public int sceNetplayDialogGetStatus() {
        return this.netplayDialogState.executeGetStatus();
    }

    @HLEFunction(nid=1303504697, version=150)
    public int sceUtilityNetconfInitStart(TPointer paramsAddr) {
        return this.netconfState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=-125741578, version=150)
    public int sceUtilityNetconfShutdownStart() {
        return this.netconfState.executeShutdownStart();
    }

    @HLEFunction(nid=-1847128523, version=150)
    public int sceUtilityNetconfUpdate(int drawSpeed) {
        return this.netconfState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=1664264761, version=150)
    public int sceUtilityNetconfGetStatus() {
        return this.netconfState.executeGetStatus();
    }

    @HLEFunction(nid=1355074903, version=150)
    public int sceUtilitySavedataInitStart(TPointer paramsAddr) {
        return this.savedataState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=-1752124612, version=150)
    public int sceUtilitySavedataShutdownStart() {
        return this.savedataState.executeShutdownStart();
    }

    @HLEFunction(nid=-726048773, version=150)
    public int sceUtilitySavedataUpdate(int drawSpeed) {
        return this.savedataState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-2005607456, version=150)
    public int sceUtilitySavedataGetStatus() {
        return this.savedataState.executeGetStatus();
    }

    @HLEFunction(nid=697684000, version=150)
    public int sceUtilitySavedataErrInitStart(TPointer paramsAddr) {
        return this.savedataErrState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=-1238744991, version=150)
    public int sceUtilitySavedataErrShutdownStart() {
        return this.savedataErrState.executeShutdownStart();
    }

    @HLEFunction(nid=-317739720, version=150)
    public int sceUtilitySavedataErrUpdate(int drawSpeed) {
        return this.savedataErrState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-2000915450, version=150)
    public int sceUtilitySavedataErrGetStatus() {
        return this.savedataErrState.executeGetStatus();
    }

    @HLEFunction(nid=718856761, version=150)
    public int sceUtilityMsgDialogInitStart(TPointer paramsAddr) {
        return this.msgDialogState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=1739535400, version=150)
    public int sceUtilityMsgDialogShutdownStart() {
        return this.msgDialogState.executeShutdownStart();
    }

    @HLEFunction(nid=-1778637509, version=150)
    public int sceUtilityMsgDialogUpdate(int drawSpeed) {
        return this.msgDialogState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-1709403689, version=150)
    public int sceUtilityMsgDialogGetStatus() {
        return this.msgDialogState.executeGetStatus();
    }

    @HLEFunction(nid=-165241982, version=150)
    public int sceUtilityOskInitStart(TPointer paramsAddr) {
        return this.oskState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=1039854505, version=150)
    public int sceUtilityOskShutdownStart() {
        return this.oskState.executeShutdownStart();
    }

    @HLEFunction(nid=1267058785, version=150)
    public int sceUtilityOskUpdate(int drawSpeed) {
        return this.oskState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-201891817, version=150)
    public int sceUtilityOskGetStatus() {
        return this.oskState.executeGetStatus();
    }

    @HLEFunction(nid=382741232, version=150)
    public int sceUtilityNpSigninInitStart(TPointer paramsAddr) {
        return this.npSigninState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=-509831210, version=150)
    public int sceUtilityNpSigninShutdownStart() {
        return this.npSigninState.executeShutdownStart();
    }

    @HLEFunction(nid=-201603726, version=150)
    public int sceUtilityNpSigninUpdate(int drawSpeed) {
        return this.npSigninState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-2035557605, version=150)
    public int sceUtilityNpSigninGetStatus() {
        return this.npSigninState.executeGetStatus();
    }

    @HLEFunction(nid=1107761795, version=150)
    public int sceUtilityPS3ScanInitStart(TPointer paramsAddr) {
        return this.PS3ScanState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=-780532365, version=150)
    public int sceUtilityPS3ScanShutdownStart() {
        return this.PS3ScanState.executeShutdownStart();
    }

    @HLEFunction(nid=-665662002, version=150)
    public int sceUtilityPS3ScanUpdate(int drawSpeed) {
        return this.PS3ScanState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-1993245553, version=150)
    public int sceUtilityPS3ScanGetStatus() {
        return this.PS3ScanState.executeGetStatus();
    }

    @HLEFunction(nid=-2117843194, version=150)
    public int sceUtilityRssReaderInitStart(TPointer paramsAddr) {
        return this.rssReaderState.executeInitStart(paramsAddr);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1325694987, version=150)
    public int sceUtilityRssReaderContStart() {
        return -2146369533;
    }

    @HLEFunction(nid=-407406376, version=150)
    public int sceUtilityRssReaderShutdownStart() {
        return this.rssReaderState.executeShutdownStart();
    }

    @HLEFunction(nid=1867971023, version=150)
    public int sceUtilityRssReaderUpdate(int drawSpeed) {
        return this.rssReaderState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-2094617851, version=150)
    public int sceUtilityRssReaderGetStatus() {
        return this.rssReaderState.executeGetStatus();
    }

    @HLEFunction(nid=1258983397, version=150)
    public int sceUtilityRssSubscriberInitStart(TPointer paramsAddr) {
        return this.rssSubscriberState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=111445593, version=150)
    public int sceUtilityRssSubscriberShutdownStart() {
        return this.rssSubscriberState.executeShutdownStart();
    }

    @HLEFunction(nid=-1601904554, version=150)
    public int sceUtilityRssSubscriberUpdate(int drawSpeed) {
        return this.rssSubscriberState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=731256635, version=150)
    public int sceUtilityRssSubscriberGetStatus() {
        return this.rssSubscriberState.executeGetStatus();
    }

    @HLEFunction(nid=38908212, version=150)
    public int sceUtilityScreenshotInitStart(TPointer paramsAddr) {
        return this.screenshotState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=-2036319705, version=150)
    public int sceUtilityScreenshotContStart(TPointer paramsAddr) {
        return this.screenshotState.executeContStart(paramsAddr);
    }

    @HLEFunction(nid=-102760308, version=150)
    public int sceUtilityScreenshotShutdownStart() {
        return this.screenshotState.executeShutdownStart();
    }

    @HLEFunction(nid=-1425523031, version=150)
    public int sceUtilityScreenshotUpdate(int drawSpeed) {
        return this.screenshotState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-669427785, version=150)
    public int sceUtilityScreenshotGetStatus() {
        return this.screenshotState.executeGetStatus();
    }

    @HLEFunction(nid=-842814911, version=150)
    public int sceUtilityHtmlViewerInitStart(TPointer paramsAddr) {
        return this.htmlViewerState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=-171044556, version=150)
    public int sceUtilityHtmlViewerShutdownStart() {
        return this.htmlViewerState.executeShutdownStart();
    }

    @HLEFunction(nid=95402468, version=150)
    public int sceUtilityHtmlViewerUpdate(int drawSpeed) {
        return this.htmlViewerState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-1113073516, version=150)
    public int sceUtilityHtmlViewerGetStatus() {
        return this.htmlViewerState.executeGetStatus();
    }

    @HLEFunction(nid=615264747, version=150)
    public int sceUtilityGamedataInstallInitStart(TPointer paramsAddr) {
        return this.gamedataInstallState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=853749195, version=150)
    public int sceUtilityGamedataInstallShutdownStart() {
        return this.gamedataInstallState.executeShutdownStart();
    }

    @HLEFunction(nid=1257034105, version=150)
    public int sceUtilityGamedataInstallUpdate(int drawSpeed) {
        return this.gamedataInstallState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-1249995303, version=150)
    public int sceUtilityGamedataInstallGetStatus() {
        return this.gamedataInstallState.executeGetStatus();
    }

    @HLEFunction(nid=1170310406, version=150)
    public int sceUtilitySetSystemParamInt(int id, int value) {
        switch (id) {
            case 2: {
                if (value != 0 && value != 1 && value != 6 && value != 11) {
                    return -2146369276;
                }
                Settings.getInstance().writeInt(SYSTEMPARAM_SETTINGS_OPTION_ADHOC_CHANNEL, value);
                break;
            }
            case 3: {
                Settings.getInstance().writeInt(SYSTEMPARAM_SETTINGS_OPTION_WLAN_POWER_SAVE, value);
                break;
            }
            default: {
                return -2146369277;
            }
        }
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=1105397364, version=150)
    public int sceUtilitySetSystemParamString(int id, int string) {
        return -2146369277;
    }

    @HLEFunction(nid=-1512430586, version=150)
    public int sceUtilityGetSystemParamInt(int id, TPointer32 valueAddr) {
        switch (id) {
            case 2: {
                valueAddr.setValue(sceUtility.getSystemParamAdhocChannel());
                break;
            }
            case 3: {
                valueAddr.setValue(sceUtility.getSystemParamWlanPowersave());
                break;
            }
            case 4: {
                valueAddr.setValue(sceUtility.getSystemParamDateFormat());
                break;
            }
            case 5: {
                valueAddr.setValue(sceUtility.getSystemParamTimeFormat());
                break;
            }
            case 6: {
                valueAddr.setValue(sceUtility.getSystemParamTimeZone());
                break;
            }
            case 7: {
                valueAddr.setValue(sceUtility.getSystemParamDaylightSavingTime());
                break;
            }
            case 8: {
                valueAddr.setValue(sceUtility.getSystemParamLanguage());
                break;
            }
            case 9: {
                valueAddr.setValue(sceUtility.getSystemParamButtonPreference());
                break;
            }
            case 10: {
                if (Emulator.getInstance().getFirmwareVersion() <= 500) {
                    log.warn((Object)String.format("sceUtilityGetSystemParamInt id=%d, value_addr=%s PSP_SYSTEMPARAM_ID_INT_LOCK_PARENTAL_LEVEL not available in PSP v%d", id, valueAddr, Emulator.getInstance().getFirmwareVersion()));
                    return -2146369277;
                }
                valueAddr.setValue(sceUtility.getSystemParamLockParentalLevel());
                break;
            }
            default: {
                log.warn((Object)String.format("sceUtilityGetSystemParamInt id=%d, valueAddr=%s invalid id", id, valueAddr));
                return -2146369277;
            }
        }
        return 0;
    }

    @HLEFunction(nid=884441923, version=150)
    public int sceUtilityGetSystemParamString(int id, TPointer strAddr, int len) {
        switch (id) {
            case 1: {
                strAddr.setStringNZ(len, sceUtility.getSystemParamNickname());
                break;
            }
            default: {
                log.warn((Object)String.format("sceUtilityGetSystemParamString id=%d, strAddr=%s, len=%d invalid id", id, strAddr, len));
                return -2146369277;
            }
        }
        return 0;
    }

    @HLEFunction(nid=1592681800, version=150)
    public int sceUtilityCheckNetParam(int id) {
        boolean available = id >= 0 && id <= 1;
        return available ? 0 : -2146367999;
    }

    @HLEFunction(nid=1129139002, version=150)
    public int sceUtilityGetNetParam(int id, int param, TPointer data) {
        if (id < 0 || id > 1) {
            log.warn((Object)String.format("sceUtilityGetNetParam invalid id=%d", id));
            return -2146367999;
        }
        switch (param) {
            case 0: {
                data.setStringZ(sceUtility.getNetParamName(id));
                break;
            }
            case 1: {
                data.setStringZ(sceNetApctl.getSSID());
                break;
            }
            case 2: {
                data.setValue32(1);
                break;
            }
            case 3: {
                data.setStringZ("XXXXXXXXXXXXXXXXX");
                break;
            }
            case 4: {
                data.setValue32(0);
                break;
            }
            case 5: {
                data.setStringZ(sceNetApctl.getLocalHostIP());
                break;
            }
            case 6: {
                data.setStringZ(sceNetApctl.getSubnetMask());
                break;
            }
            case 7: {
                data.setStringZ(sceNetApctl.getGateway());
                break;
            }
            case 8: {
                data.setValue32(0);
                break;
            }
            case 9: {
                data.setStringZ(sceNetApctl.getPrimaryDNS());
                break;
            }
            case 10: {
                data.setStringZ(sceNetApctl.getSecondaryDNS());
                break;
            }
            default: {
                log.warn((Object)String.format("sceUtilityGetNetParam invalid param %d", param));
                return -2146367996;
            }
        }
        return 0;
    }

    @HLEFunction(nid=1340941528, version=150)
    public int sceUtilityGetNetParamLatestID(TPointer32 idAddr) {
        idAddr.setValue(1);
        return 0;
    }

    protected static class OskDialog
    extends UtilityDialog {
        private static final long serialVersionUID = 1155047781007677923L;
        protected JTextField textField;

        public OskDialog(SceUtilityOskParams oskParams, OskUtilityDialogState oskState) {
            this.createDialog(oskState, oskParams.oskData.desc);
            this.textField = new JTextField(oskParams.oskData.inText);
            this.messagePane.add(this.textField);
            JButton okButton = new JButton("Ok");
            okButton.addActionListener(this.closeActionListener);
            okButton.setActionCommand("OK");
            this.buttonPane.add(okButton);
            this.setDefaultButton(okButton);
            this.endDialog();
        }
    }

    protected static class GuMsgDialog
    extends GuUtilityDialog {
        protected SceUtilityMsgDialogParams msgDialogParams;

        public GuMsgDialog(SceUtilityMsgDialogParams msgDialogParams, MsgDialogUtilityDialogState msgDialogState) {
            super(msgDialogParams.base);
            this.msgDialogParams = msgDialogParams;
            msgDialogState.setYesSelected(msgDialogParams.isOptionYesNoDefaultYes());
            this.createDialog(msgDialogState);
        }

        @Override
        protected void updateDialog() {
            this.setSoftShadows(true);
            this.gu.sceGuClear(-6912383);
            int buttonY = 192;
            String message = this.getMessage();
            if (message != null) {
                int currentLineLength = 0;
                LinkedList<String> lines = new LinkedList<String>();
                StringBuilder currentLine = new StringBuilder();
                int splitLineIndex = -1;
                int maxLineLength = 430;
                int longestLine = 0;
                SceFontInfo fontInfo = this.getDefaultFontInfo();
                for (int i = 0; i < message.length(); ++i) {
                    char c = message.charAt(i);
                    if (c == '\n') {
                        longestLine = Math.max(longestLine, currentLineLength);
                        lines.add(currentLine.toString());
                        currentLine.setLength(0);
                        currentLineLength = 0;
                        splitLineIndex = -1;
                        continue;
                    }
                    int charLength = this.getTextLength(fontInfo, c);
                    if (currentLineLength + charLength > maxLineLength) {
                        if (splitLineIndex < 0) {
                            splitLineIndex = currentLine.length();
                        }
                        String line = currentLine.substring(0, splitLineIndex);
                        longestLine = Math.max(longestLine, this.getTextLength(fontInfo, line));
                        lines.add(line);
                        currentLine.delete(0, splitLineIndex);
                        currentLineLength = this.getTextLength(fontInfo, currentLine.toString());
                        splitLineIndex = -1;
                    }
                    currentLine.append(c);
                    currentLineLength += charLength;
                    if (c != ' ') continue;
                    splitLineIndex = currentLine.length();
                }
                if (currentLine.length() > 0) {
                    longestLine = Math.max(longestLine, currentLineLength);
                    lines.add(currentLine.toString());
                }
                int lineHeight = 19;
                int lineCount = lines.size();
                int textHeight = 19 * lineCount;
                int totalHeight = textHeight + 24;
                if (this.msgDialogParams.isOptionYesNo() || this.msgDialogParams.isOptionOk()) {
                    totalHeight += 33;
                }
                int topLineY = (272 - totalHeight) / 2;
                buttonY = topLineY + totalHeight - 29;
                int lineColor = -2106663;
                this.gu.sceGuDrawHorizontalLine(60, 420, topLineY, lineColor);
                this.gu.sceGuDrawHorizontalLine(60, 420, topLineY + totalHeight, lineColor);
                float scale = 0.79f;
                int y = topLineY + 17;
                int x = 63 + (360 - Math.round((float)longestLine * 0.79f)) / 2;
                for (String line : lines) {
                    this.drawTextWithShadow(x, y, 0.79f, line);
                    y += 19;
                }
            }
            if (this.msgDialogParams.isOptionYesNo()) {
                this.drawYesNo(185, 255, buttonY);
            } else if (this.msgDialogParams.isOptionOk()) {
                this.drawButton(223, buttonY, "OK", true);
            }
            if ((this.msgDialogParams.options & 1) != 0 && !this.msgDialogParams.isOptionOk() && !this.msgDialogParams.isOptionYesNo()) {
                this.drawBack();
            } else if ((this.msgDialogParams.options & 0x80) == 0) {
                if (this.msgDialogParams.options != 0) {
                    this.drawEnter();
                }
                this.drawBack();
            } else if ((this.msgDialogParams.options & 0x30) != 0) {
                this.drawEnter();
            }
        }

        protected String getMessage() {
            if (this.msgDialogParams.mode == 0) {
                return String.format("Error 0x%08X", this.msgDialogParams.errorValue);
            }
            return this.msgDialogParams.message;
        }

        @Override
        protected boolean canCancel() {
            return (this.msgDialogParams.options & 0x80) == 0;
        }

        @Override
        protected boolean canConfirm() {
            return (this.msgDialogParams.options & 0x30) != 0;
        }

        @Override
        protected int getButtonPressedOK() {
            if (this.msgDialogParams.isOptionYesNo()) {
                return this.utilityDialogState.isYesSelected() ? 1 : 2;
            }
            return super.getButtonPressedOK();
        }

        @Override
        protected boolean hasYesNo() {
            return this.msgDialogParams.isOptionYesNo();
        }
    }

    protected static class GuSavedataDialog
    extends GuUtilityDialog {
        private final SavedataUtilityDialogState savedataDialogState;
        private final SceUtilitySavedataParam savedataParams;
        private final String[] saveNames;
        private final int numberRows;
        private int selectedRow;
        private final String strNewData = ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString("sceUtilitySavedata.strNewData.text");
        private final String strNoData = ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString("sceUtilitySavedata.strNoData.text");

        public GuSavedataDialog(SceUtilitySavedataParam savedataParams, SavedataUtilityDialogState savedataDialogState, String[] saveNames) {
            super(savedataParams.base);
            this.savedataDialogState = savedataDialogState;
            this.savedataParams = savedataParams;
            this.saveNames = saveNames;
            this.createDialog(savedataDialogState);
            this.numberRows = saveNames == null ? 0 : saveNames.length;
            savedataDialogState.saveListEmpty = this.numberRows <= 0;
            this.selectedRow = 0;
            block0 : switch (savedataParams.focus) {
                case 1: {
                    this.selectedRow = 0;
                    break;
                }
                case 2: {
                    this.selectedRow = this.numberRows - 1;
                    break;
                }
                case 3: {
                    long latestTimestamp = Long.MIN_VALUE;
                    for (int i = 0; i < this.numberRows; ++i) {
                        long timestamp = this.getTimestamp(saveNames[i]);
                        if (timestamp <= latestTimestamp) continue;
                        latestTimestamp = timestamp;
                        this.selectedRow = i;
                    }
                    break;
                }
                case 4: {
                    long oldestTimestamp = Long.MAX_VALUE;
                    for (int i = 0; i < this.numberRows; ++i) {
                        long timestamp = this.getTimestamp(saveNames[i]);
                        if (timestamp >= oldestTimestamp) continue;
                        oldestTimestamp = timestamp;
                        this.selectedRow = i;
                    }
                    break;
                }
                case 7: {
                    for (int i = 0; i < this.numberRows; ++i) {
                        if (!this.isEmpty(saveNames[i])) continue;
                        this.selectedRow = i;
                        break block0;
                    }
                    break;
                }
                case 8: {
                    for (int i = this.numberRows - 1; i >= 0; --i) {
                        if (!this.isEmpty(saveNames[i])) continue;
                        this.selectedRow = i;
                        break block0;
                    }
                    break;
                }
            }
        }

        private boolean isEmpty(String saveName) {
            return !this.savedataParams.isPresent(this.savedataParams.gameName, saveName);
        }

        private long getTimestamp(String saveName) {
            return this.savedataParams.getTimestamp(this.savedataParams.gameName, saveName);
        }

        private int getIcon0(int index) {
            if (index < 0 || index >= this.saveNames.length) {
                return 0;
            }
            ByteArrayInputStream iconStream = null;
            String iconFileName = this.savedataParams.getFileName(this.saveNames[index], "ICON0.PNG");
            SeekableDataInput iconDataInput = Modules.IoFileMgrForUserModule.getFile(iconFileName, 1);
            if (iconDataInput != null) {
                try {
                    int length = (int)iconDataInput.length();
                    byte[] iconBuffer = new byte[length];
                    iconDataInput.readFully(iconBuffer);
                    iconDataInput.close();
                    iconStream = new ByteArrayInputStream(iconBuffer);
                }
                catch (IOException e) {
                    log.debug((Object)"getIcon0", (Throwable)e);
                }
            }
            return this.readIcon(iconStream);
        }

        private PSF getPsf(int index) {
            PSF psf = null;
            if (index < 0 || index >= this.saveNames.length) {
                return psf;
            }
            String sfoFileName = this.savedataParams.getFileName(this.saveNames[index], "PARAM.SFO");
            SeekableDataInput sfoDataInput = Modules.IoFileMgrForUserModule.getFile(sfoFileName, 1);
            if (sfoDataInput != null) {
                try {
                    int length = (int)sfoDataInput.length();
                    byte[] sfoBuffer = new byte[length];
                    sfoDataInput.readFully(sfoBuffer);
                    sfoDataInput.close();
                    psf = new PSF();
                    psf.read(ByteBuffer.wrap(sfoBuffer));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return psf;
        }

        private void drawIconByRow(int row, int iconX, int iconY, int iconWidth, int iconHeight) {
            this.drawIcon(this.getIcon0(row), iconX, iconY, iconWidth, iconHeight);
        }

        @Override
        protected void updateDialog() {
            if (this.numberRows > 0) {
                this.drawIconByRow(this.selectedRow, 26, 96, 144, 80);
                PSF psf = this.getPsf(this.selectedRow);
                if (psf != null) {
                    String title = psf.getString("TITLE");
                    String detail = psf.getString("SAVEDATA_DETAIL");
                    String savedataTitle = psf.getString("SAVEDATA_TITLE");
                    Calendar savedTime = this.savedataParams.getSavedTime(this.saveNames[this.selectedRow]);
                    int textX = 180;
                    int textY = 119;
                    this.drawTextWithShadow(textX, textY, 13747898, 0.85f, title);
                    textY += 22;
                    if (savedTime != null) {
                        this.drawTextWithShadow(textX, textY, 0.7f, String.format("%tF %tR", savedTime, savedTime));
                    }
                    this.gu.sceGuDrawHorizontalLine(textX, 480, textY - 6, -1);
                    this.drawTextWithShadow(textX -= 5, textY += 23, 0.7f, savedataTitle);
                    this.drawTextWithShadow(textX, textY += 24, 0.7f, detail);
                } else {
                    this.drawTextWithShadow(180, 130, 0.75f, this.strNewData);
                }
                this.drawEnter();
                this.drawBack();
                if (this.selectedRow > 0) {
                    this.drawIconByRow(this.selectedRow - 1, 58, 38, 80, 44);
                    if (this.selectedRow > 1) {
                        this.drawIconByRow(this.selectedRow - 2, 58, -5, 80, 44);
                    }
                }
                if (this.selectedRow < this.numberRows - 1) {
                    this.drawIconByRow(this.selectedRow + 1, 58, 190, 80, 44);
                    if (this.selectedRow < this.numberRows - 2) {
                        this.drawIconByRow(this.selectedRow + 2, 58, 233, 80, 44);
                    }
                }
            } else {
                this.drawTextWithShadow(180, 230, 0.75f, this.strNoData);
                this.drawBack();
            }
            String dialogTitle = this.savedataDialogState.getDialogTitle(this.savedataParams.getModeName(), "Savedata List");
            this.drawHeader(dialogTitle);
        }

        @Override
        public void checkController() {
            if (this.isDownPressed()) {
                ++this.selectedRow;
            } else if (this.isUpPressed()) {
                --this.selectedRow;
            } else if (this.isButtonPressed(256)) {
                this.selectedRow = 0;
            } else if (this.isButtonPressed(512)) {
                this.selectedRow = this.numberRows - 1;
            }
            this.selectedRow = Math.max(this.selectedRow, 0);
            this.selectedRow = Math.min(this.selectedRow, this.numberRows - 1);
            this.savedataDialogState.saveListSelection = this.selectedRow >= 0 ? this.saveNames[this.selectedRow] : null;
            super.checkController();
        }

        @Override
        protected boolean canConfirm() {
            return this.numberRows > 0;
        }
    }

    protected static class GuSavedataDialogCompleted
    extends GuUtilityDialog {
        protected final SavedataUtilityDialogState savedataDialogState;
        protected final SceUtilitySavedataParam savedataParams;
        protected boolean isYesSelected;
        private final String strCompleted = ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString("sceUtilitySavedata.strCompleted.text");

        protected GuSavedataDialogCompleted(SceUtilitySavedataParam savedataParams, SavedataUtilityDialogState savedataDialogState) {
            super(savedataParams.base);
            this.savedataDialogState = savedataDialogState;
            this.savedataParams = savedataParams;
            this.createDialog(savedataDialogState);
        }

        @Override
        protected void updateDialog() {
            String dialogTitle = this.savedataDialogState.getDialogTitle(this.savedataParams.getModeName(), "Save");
            Calendar savedTime = this.savedataParams.getSavedTime();
            this.drawIcon(this.readIcon(this.savedataParams.icon0FileData.buf), 26, 96, 144, 80);
            this.gu.sceGuDrawHorizontalLine(201, 464, 114, -1);
            this.drawTextWithShadow(270, 131, 0.75f, String.format("%s %s.", dialogTitle, this.strCompleted));
            this.gu.sceGuDrawHorizontalLine(201, 464, 157, -1);
            this.drawTextWithShadow(6, 202, 0.75f, this.savedataParams.sfoParam.savedataTitle);
            if (savedTime != null) {
                this.drawTextWithShadow(6, 219, 0.7f, String.format("%tF %tR", savedTime, savedTime));
            }
            this.drawTextWithShadow(6, 237, 0.75f, MemoryStick.getSizeKbString(this.savedataParams.getRequiredSizeKb()));
            this.drawBack();
            this.drawHeader(dialogTitle);
        }

        @Override
        protected boolean canConfirm() {
            return false;
        }
    }

    protected static class GuSavedataDialogLoad
    extends GuUtilityDialog {
        protected final SavedataUtilityDialogState savedataDialogState;
        protected final SceUtilitySavedataParam savedataParams;
        protected boolean isYesSelected;
        protected boolean hasYesNo;
        private final String strNoData = ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString("sceUtilitySavedata.strNoData.text");
        private final String strAskLoadData = ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString("sceUtilitySavedata.strAskLoadData.text");

        protected GuSavedataDialogLoad(SceUtilitySavedataParam savedataParams, SavedataUtilityDialogState savedataDialogState) {
            super(savedataParams.base);
            this.savedataDialogState = savedataDialogState;
            this.savedataParams = savedataParams;
            this.hasYesNo = savedataParams.isPresent();
            this.createDialog(savedataDialogState);
        }

        @Override
        protected void updateDialog() {
            String dialogTitle = this.savedataDialogState.getDialogTitle(this.savedataParams.getModeName(), "Load");
            Calendar savedTime = this.savedataParams.getSavedTime();
            if (!this.hasYesNo()) {
                this.gu.sceGuDrawHorizontalLine(201, 464, 114, -1);
                this.drawTextWithShadow(270, 131, 0.75f, this.strNoData);
                this.gu.sceGuDrawHorizontalLine(201, 464, 157, -1);
            } else {
                this.drawIcon(this.readIcon(this.savedataParams.icon0FileData.buf), 26, 96, 144, 80);
                this.gu.sceGuDrawHorizontalLine(201, 464, 87, -1);
                this.drawTextWithShadow(236, 105, 0.75f, this.strAskLoadData);
                this.drawYesNo(278, 349, 154);
                this.gu.sceGuDrawHorizontalLine(201, 464, 184, -1);
                this.drawTextWithShadow(6, 202, 0.75f, this.savedataParams.sfoParam.savedataTitle);
                if (savedTime != null) {
                    this.drawTextWithShadow(6, 219, 0.7f, String.format("%tF %tR", savedTime, savedTime));
                }
                this.drawTextWithShadow(6, 237, 0.75f, MemoryStick.getSizeKbString(this.savedataParams.getRequiredSizeKb()));
                this.drawEnter();
            }
            this.drawBack();
            this.drawHeader(dialogTitle);
        }

        @Override
        protected boolean hasYesNo() {
            return this.hasYesNo;
        }

        @Override
        protected boolean canConfirm() {
            return this.hasYesNo();
        }
    }

    protected static class GuSavedataDialogSave
    extends GuUtilityDialog {
        protected final SavedataUtilityDialogState savedataDialogState;
        protected final SceUtilitySavedataParam savedataParams;
        protected boolean isYesSelected;
        private final String strAskSaveData = ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString("sceUtilitySavedata.strAskSaveData.text");
        private final String strAskOverwriteData = ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString("sceUtilitySavedata.strAskOverwriteData.text");

        protected GuSavedataDialogSave(SceUtilitySavedataParam savedataParams, SavedataUtilityDialogState savedataDialogState) {
            super(savedataParams.base);
            this.savedataDialogState = savedataDialogState;
            this.savedataParams = savedataParams;
            this.createDialog(savedataDialogState);
        }

        @Override
        protected void updateDialog() {
            String dialogTitle = this.savedataDialogState.getDialogTitle(this.savedataParams.getModeName(), "Save");
            Calendar savedTime = this.savedataParams.getSavedTime();
            this.drawIcon(this.readIcon(this.savedataParams.icon0FileData.buf), 26, 96, 144, 80);
            if (this.hasYesNo()) {
                this.gu.sceGuDrawHorizontalLine(201, 464, 87, -1);
                this.drawTextWithShadow(236, 105, 0.75f, this.getText(dialogTitle));
                this.drawYesNo(278, 349, 154);
                this.gu.sceGuDrawHorizontalLine(201, 464, 184, -1);
            } else {
                this.gu.sceGuDrawHorizontalLine(201, 464, 114, -1);
                this.drawTextWithShadow(270, 131, 0.75f, this.getText(dialogTitle));
                this.gu.sceGuDrawHorizontalLine(201, 464, 157, -1);
            }
            this.drawTextWithShadow(6, 202, 0.75f, this.savedataParams.sfoParam.savedataTitle);
            if (savedTime != null) {
                this.drawTextWithShadow(6, 219, 0.7f, String.format("%tF %tR", savedTime, savedTime));
            }
            this.drawTextWithShadow(6, 237, 0.75f, MemoryStick.getSizeKbString(this.savedataParams.getRequiredSizeKb()));
            if (this.hasEnter()) {
                this.drawEnter();
            }
            this.drawBack();
            this.drawHeader(dialogTitle);
        }

        protected String getText(String dialogTitle) {
            return this.savedataParams.isPresent() ? this.strAskOverwriteData : this.strAskSaveData;
        }

        protected boolean hasEnter() {
            return true;
        }

        @Override
        protected boolean hasYesNo() {
            return true;
        }
    }

    protected static abstract class GuUtilityDialog {
        protected long pressedTimestamp;
        protected static final int repeatDelay = 100000;
        protected boolean downPressedButton;
        protected boolean downPressedAnalog;
        protected boolean upPressedButton;
        protected boolean upPressedAnalog;
        protected boolean leftPressedButton;
        protected boolean leftPressedAnalog;
        protected boolean rightPressedButton;
        protected boolean rightPressedAnalog;
        protected sceGu gu;
        protected UtilityDialogState utilityDialogState;
        private int x;
        private int y;
        private int textX;
        private int textY;
        private int textWidth;
        private int textHeight;
        private int textLineHeight;
        private int textAddr;
        private SceFontInfo defaultFontInfo;
        protected static final int baseAscender = 15;
        protected static final int defaultTextWidth = 512;
        protected static final int defaultTextHeight = 32;
        protected static final int textColor = 0xFFFFFF;
        protected static final int shadowColor = 0;
        protected boolean softShadows;
        protected long startDialogMillis;
        protected int drawSpeed;
        private boolean buttonsSwapped;
        private final String strEnter = ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString("sceUtilitySavedata.strEnter.text");
        private final String strBack = ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString("sceUtilitySavedata.strBack.text");
        private final String strYes = ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString("sceUtilitySavedata.strYes.text");
        private final String strNo = ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString("sceUtilitySavedata.strNo.text");

        protected GuUtilityDialog(pspUtilityDialogCommon utilityDialogCommon) {
            this.buttonsSwapped = utilityDialogCommon.buttonSwap == 0;
        }

        protected void createDialog(UtilityDialogState utilityDialogState) {
            this.utilityDialogState = utilityDialogState;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Free memory total=0x%X, max=0x%X", Modules.SysMemUserForUserModule.totalFreeMemSize(), Modules.SysMemUserForUserModule.maxFreeMemSize()));
            }
            this.startDialogMillis = Emulator.getClock().milliTime();
            this.gu = new sceGu(0x100000);
        }

        protected void dispose() {
            if (this.gu != null) {
                this.gu.free();
                this.gu = null;
            }
        }

        public boolean isVisible() {
            return this.gu != null;
        }

        protected void update(int drawSpeed) {
            this.drawSpeed = drawSpeed;
            if (this.gu != null && !this.gu.isListDrawing()) {
                this.gu.sceGuStart();
                this.gu.sceGuDisable(1);
                this.gu.sceGuDisable(0);
                this.gu.sceGuDisable(7);
                this.gu.sceGuDisable(10);
                this.gu.sceGuDisable(18);
                this.gu.sceGuDisable(3);
                this.gu.sceGuDisable(5);
                this.gu.sceGuDisable(2);
                this.gu.sceGuBlendFunc(0, 2, 3, 0, 0);
                this.gu.sceGuEnable(4);
                this.updateDialog();
                this.gu.sceGuFinish();
            }
            this.checkController();
        }

        private void drawText(SceFontInfo fontInfo, int baseAscender, char c, int glyphType) {
            pspCharInfo charInfo = fontInfo.getCharInfo(c, glyphType);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("drawText '%c'(%d), glyphType=0x%X, baseAscender=%d, position (%d,%d), %s", Character.valueOf(c), (int)c, glyphType, baseAscender, this.x, this.y, charInfo));
            }
            if (charInfo == null) {
                return;
            }
            if (c == '\n') {
                this.x = this.textX;
                this.y += this.textLineHeight;
                return;
            }
            fontInfo.printFont(this.textAddr, this.textWidth / 2, this.textWidth, this.textHeight, this.x - this.textX + charInfo.bitmapLeft, this.y - this.textY + baseAscender - charInfo.bitmapTop, 0, 0, this.textWidth, this.textHeight, 0, c, 32, glyphType);
            if (glyphType != 0) {
                charInfo = fontInfo.getCharInfo(c, 0);
            }
            this.x += charInfo.sfp26AdvanceH >> 6;
        }

        protected int getTextLength(SceFontInfo fontInfo, String s) {
            int length = 0;
            for (int i = 0; i < s.length(); ++i) {
                length += this.getTextLength(fontInfo, s.charAt(i));
            }
            return length;
        }

        protected int getTextLength(SceFontInfo fontInfo, char c) {
            pspCharInfo charInfo = fontInfo.getCharInfo(c, 0);
            if (charInfo == null) {
                return 0;
            }
            return charInfo.sfp26AdvanceH >> 6;
        }

        protected void drawTextWithShadow(int textX, int textY, float scale, String s) {
            this.drawTextWithShadow(textX, textY, 0xFFFFFF, scale, s);
        }

        protected void drawTextWithShadow(int textX, int textY, int textColor, float scale, String s) {
            int txtHeight = 32;
            if (s.contains("\n")) {
                txtHeight = 272 - textY;
            }
            this.drawTextWithShadow(textX, textY, 512, txtHeight, 20, this.getDefaultFontInfo(), 15, textColor, 0, scale, s);
        }

        protected void drawTextWithShadow(int textX, int textY, int textWidth, int textHeight, int textLineHeight, SceFontInfo fontInfo, int baseAscender, int textColor, int shadowColor, float scale, String s) {
            this.drawText(textX, textY, textWidth, textHeight, textLineHeight, fontInfo, baseAscender, scale, shadowColor, s, 1);
            this.drawText(textX, textY, textWidth, textHeight, textLineHeight, fontInfo, baseAscender, scale, textColor, s, 0);
        }

        protected void setSoftShadows(boolean softShadows) {
            this.softShadows = softShadows;
        }

        protected void drawText(int textX, int textY, int textWidth, int textHeight, int textLineHeight, SceFontInfo fontInfo, int baseAscender, float scale, int color, String s, int glyphType) {
            this.textX = textX;
            this.textY = textY;
            this.textWidth = textWidth;
            this.textHeight = textHeight;
            this.textLineHeight = textLineHeight;
            this.x = textX;
            this.y = textY;
            this.textAddr = this.gu.sceGuGetMemory(textWidth * textHeight / 2);
            if (this.textAddr == 0) {
                return;
            }
            for (int i = 0; i < s.length(); ++i) {
                this.drawText(fontInfo, baseAscender, s.charAt(i), glyphType);
            }
            int numberOfVertex = 2;
            int textVertexAddr = this.gu.sceGuGetMemory(20);
            IMemoryWriter vertexWriter = MemoryWriter.getMemoryWriter(textVertexAddr, 2);
            vertexWriter.writeNext(0);
            vertexWriter.writeNext(0);
            vertexWriter.writeNext(textX);
            vertexWriter.writeNext(textY);
            vertexWriter.writeNext(0);
            vertexWriter.writeNext(textWidth);
            vertexWriter.writeNext(textHeight);
            vertexWriter.writeNext(textX + (int)((float)textWidth * scale));
            vertexWriter.writeNext(textY + (int)((float)textHeight * scale));
            vertexWriter.writeNext(0);
            vertexWriter.flush();
            int clutAddr = this.gu.sceGuGetMemory(64);
            IMemoryWriter clutWriter = MemoryWriter.getMemoryWriter(clutAddr, 4);
            color &= 0xFFFFFF;
            for (int i = 0; i < 16; ++i) {
                int alpha = i << 4 | i;
                if (this.softShadows && glyphType == 1) {
                    alpha >>= 1;
                }
                clutWriter.writeNext(alpha << 24 | color);
            }
            this.gu.sceGuClutMode(3, 0, 255, 0);
            this.gu.sceGuClutLoad(2, clutAddr);
            this.gu.sceGuTexMode(4, 0, false);
            this.gu.sceGuTexFunc(3, true, false);
            this.gu.sceGuTexEnvColor(0);
            this.gu.sceGuTexWrap(1, 1);
            this.gu.sceGuTexFilter(1, 1);
            this.gu.sceGuEnable(9);
            this.gu.sceGuTexImage(0, 512, 256, textWidth, this.textAddr);
            this.gu.sceGuDrawArray(6, 8388866, 2, 0, textVertexAddr);
        }

        protected void drawButton(int x, int y, String text, boolean selected) {
            if (selected) {
                int alpha = this.getAnimationIndex(255);
                this.gu.sceGuDrawRectangle(x, y, x + text.length() * 17, y + 16, alpha << 24 | 0xC5C8CF);
            }
            this.drawTextWithShadow(x + 5, y + 2, 0.8f, text);
        }

        protected abstract void updateDialog();

        public void checkController() {
            if (this.canConfirm() && this.isConfirmButtonPressed()) {
                this.utilityDialogState.setButtonPressed(this.getButtonPressedOK());
                this.dispose();
            } else if (this.canCancel() && this.isCancelButtonPressed()) {
                this.utilityDialogState.setButtonPressed(3);
                this.dispose();
            }
            if (this.hasYesNo()) {
                if (this.isLeftPressed()) {
                    this.utilityDialogState.setYesSelected(true);
                } else if (this.isRightPressed()) {
                    this.utilityDialogState.setYesSelected(false);
                }
            }
        }

        protected boolean isButtonPressed(int button) {
            Controller controller = State.controller;
            return (controller.getButtons() & button) == button;
        }

        protected boolean isConfirmButtonPressed() {
            return this.isButtonPressed(this.areButtonsSwapped() ? 8192 : 16384);
        }

        protected boolean isCancelButtonPressed() {
            return this.isButtonPressed(this.areButtonsSwapped() ? 16384 : 8192);
        }

        private int getControllerLy() {
            return State.controller.getLy() & 0xFF;
        }

        private int getControllerLx() {
            return State.controller.getLx() & 0xFF;
        }

        private int getControllerAnalogCenter() {
            return 128;
        }

        protected boolean canConfirm() {
            return true;
        }

        protected boolean canCancel() {
            return true;
        }

        protected boolean hasYesNo() {
            return false;
        }

        protected int getButtonPressedOK() {
            return 1;
        }

        private void checkRepeat() {
            if (this.pressedTimestamp != 0L && SystemTimeManager.getSystemTime() - this.pressedTimestamp > 100000L) {
                this.upPressedAnalog = false;
                this.upPressedButton = false;
                this.downPressedAnalog = false;
                this.downPressedButton = false;
                this.leftPressedAnalog = false;
                this.leftPressedButton = false;
                this.rightPressedAnalog = false;
                this.rightPressedButton = false;
                this.pressedTimestamp = 0L;
            }
        }

        protected boolean isUpPressed() {
            this.checkRepeat();
            if (this.upPressedButton || this.upPressedAnalog) {
                if (!this.isButtonPressed(16)) {
                    this.upPressedButton = false;
                }
                if (this.getControllerLy() >= this.getControllerAnalogCenter()) {
                    this.upPressedAnalog = false;
                }
                return false;
            }
            if (this.isButtonPressed(16)) {
                this.upPressedButton = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            if (this.getControllerLy() < this.getControllerAnalogCenter()) {
                this.upPressedAnalog = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            return false;
        }

        protected boolean isDownPressed() {
            this.checkRepeat();
            if (this.downPressedButton || this.downPressedAnalog) {
                if (!this.isButtonPressed(64)) {
                    this.downPressedButton = false;
                }
                if (this.getControllerLy() <= this.getControllerAnalogCenter()) {
                    this.downPressedAnalog = false;
                }
                return false;
            }
            if (this.isButtonPressed(64)) {
                this.downPressedButton = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            if (this.getControllerLy() > this.getControllerAnalogCenter()) {
                this.downPressedAnalog = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            return false;
        }

        protected boolean isLeftPressed() {
            this.checkRepeat();
            if (this.leftPressedButton || this.leftPressedAnalog) {
                if (!this.isButtonPressed(128)) {
                    this.leftPressedButton = false;
                }
                if (this.getControllerLx() >= this.getControllerAnalogCenter()) {
                    this.leftPressedAnalog = false;
                }
                return false;
            }
            if (this.isButtonPressed(128)) {
                this.leftPressedButton = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            if (this.getControllerLx() < this.getControllerAnalogCenter()) {
                this.leftPressedAnalog = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            return false;
        }

        protected boolean isRightPressed() {
            this.checkRepeat();
            if (this.rightPressedButton || this.rightPressedAnalog) {
                if (!this.isButtonPressed(32)) {
                    this.rightPressedButton = false;
                }
                if (this.getControllerLx() <= this.getControllerAnalogCenter()) {
                    this.rightPressedAnalog = false;
                }
                return false;
            }
            if (this.isButtonPressed(32)) {
                this.rightPressedButton = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            if (this.getControllerLx() > this.getControllerAnalogCenter()) {
                this.rightPressedAnalog = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            return false;
        }

        protected SceFontInfo getDefaultFontInfo() {
            if (this.defaultFontInfo == null) {
                this.defaultFontInfo = Modules.sceFontModule.getFont((int)0).fontInfo;
            }
            return this.defaultFontInfo;
        }

        private String getCross() {
            return "X";
        }

        private String getCircle() {
            return "O";
        }

        protected boolean areButtonsSwapped() {
            return this.buttonsSwapped;
        }

        protected void drawEnter() {
            String confirm = this.areButtonsSwapped() ? this.getCircle() : this.getCross();
            this.drawTextWithShadow(183, 254, 0.75f, String.format("%s %s", confirm, this.strEnter));
        }

        protected void drawBack() {
            String cancel = this.areButtonsSwapped() ? this.getCross() : this.getCircle();
            this.drawTextWithShadow(260, 254, 0.75f, String.format("%s %s", cancel, this.strBack));
        }

        protected void drawHeader(String title) {
            this.gu.sceGuDrawRectangle(0, 0, 480, 22, -2141168556);
            this.drawText(30, 4, 128, 32, 20, this.getDefaultFontInfo(), 15, 0.82f, 0xFFFFFF, title, 0);
            this.drawText(9, 5, 32, 32, 20, this.getDefaultFontInfo(), 15, 0.65f, 0xFFFFFF, new String(Character.toChars(9679)), 0);
        }

        protected void drawYesNo(int xYes, int xNo, int y) {
            this.drawButton(xYes, y, this.strYes, this.utilityDialogState.isYesSelected());
            this.drawButton(xNo, y, this.strNo, this.utilityDialogState.isNoSelected());
        }

        protected void drawIcon(int textureAddr, int iconX, int iconY, int iconWidth, int iconHeight) {
            if (textureAddr == 0) {
                return;
            }
            int numberOfVertex = 2;
            int iconVertexAddr = this.gu.sceGuGetMemory(10 * numberOfVertex);
            if (iconVertexAddr == 0) {
                return;
            }
            IMemoryWriter vertexWriter = MemoryWriter.getMemoryWriter(iconVertexAddr, 2);
            vertexWriter.writeNext(0);
            vertexWriter.writeNext(0);
            vertexWriter.writeNext(iconX);
            vertexWriter.writeNext(iconY);
            vertexWriter.writeNext(0);
            vertexWriter.writeNext(144);
            vertexWriter.writeNext(80);
            vertexWriter.writeNext(iconX + iconWidth);
            vertexWriter.writeNext(iconY + iconHeight);
            vertexWriter.writeNext(0);
            vertexWriter.flush();
            this.gu.sceGuTexEnvColor(0);
            this.gu.sceGuTexMode(3, 0, false);
            this.gu.sceGuTexImage(0, 256, 128, icon0BufferWidth, textureAddr);
            this.gu.sceGuTexFunc(3, true, false);
            this.gu.sceGuTexFilter(1, 1);
            this.gu.sceGuTexWrap(1, 1);
            this.gu.sceGuEnable(9);
            this.gu.sceGuDrawArray(6, 8388866, numberOfVertex, 0, iconVertexAddr);
        }

        protected int readIcon(InputStream is) {
            BufferedImage image = null;
            if (is != null) {
                try {
                    image = ImageIO.read(is);
                }
                catch (IOException e) {
                    log.debug((Object)"getIcon0", (Throwable)e);
                }
            }
            if (image == null) {
                try {
                    image = ImageIO.read(this.getClass().getResource("/jpcsp/images/icon0.png"));
                }
                catch (IOException e) {
                    log.error((Object)"Cannot read default icon0.png", (Throwable)e);
                }
            }
            if (image == null) {
                return 0;
            }
            int bytesPerPixel = IRenderingEngine.sizeOfTextureType[3];
            int textureAddr = this.gu.sceGuGetMemory(icon0BufferWidth * 80 * bytesPerPixel);
            if (textureAddr == 0) {
                return 0;
            }
            IMemoryWriter textureWriter = MemoryWriter.getMemoryWriter(textureAddr, bytesPerPixel);
            int width = Math.min(image.getWidth(), 144);
            int height = Math.min(image.getHeight(), 80);
            for (int hy = 0; hy < height; ++hy) {
                int wx;
                for (wx = 0; wx < width; ++wx) {
                    int colorARGB = image.getRGB(wx, hy);
                    int colorABGR = ImageReader.colorARGBtoABGR(colorARGB);
                    textureWriter.writeNext(colorABGR);
                }
                for (wx = width; wx < icon0BufferWidth; ++wx) {
                    textureWriter.writeNext(0);
                }
            }
            textureWriter.flush();
            return textureAddr;
        }

        protected int readIcon(int address) {
            MemoryInputStream iconStream = null;
            if (address != 0) {
                iconStream = new MemoryInputStream(address);
            }
            return this.readIcon(iconStream);
        }

        protected int getAnimationIndex(int maxIndex) {
            if (this.drawSpeed <= 0) {
                return maxIndex;
            }
            long now = Emulator.getClock().currentTimeMillis();
            int durationMillis = (int)(now - this.startDialogMillis);
            int animationIndex = durationMillis % 500 * (maxIndex + 1) / 500;
            if (durationMillis / 500 % 2 != 0) {
                animationIndex = maxIndex - animationIndex;
            }
            return animationIndex;
        }
    }

    protected static abstract class UtilityDialog
    extends JComponent {
        private static final long serialVersionUID = -993546461292372048L;
        protected JDialog dialog;
        protected int buttonPressed;
        protected JPanel messagePane;
        protected JPanel buttonPane;
        protected ActionListener closeActionListener;
        protected static final String actionCommandOK = "OK";
        protected static final String actionCommandYES = "YES";
        protected static final String actionCommandNO = "NO";
        protected static final String actionCommandESC = "ESC";
        protected UtilityDialogState utilityDialogState;
        protected String confirmButtonActionCommand = "OK";
        protected String cancelButtonActionCommand = "ESC";
        protected long pressedTimestamp;
        protected static final int repeatDelay = 200000;
        protected boolean downPressedButton;
        protected boolean downPressedAnalog;
        protected boolean upPressedButton;
        protected boolean upPressedAnalog;

        protected UtilityDialog() {
        }

        protected void createDialog(UtilityDialogState utilityDialogState, String message) {
            this.utilityDialogState = utilityDialogState;
            String title = String.format("Message from %s", State.title);
            this.dialog = new JDialog((Frame)null, title, false);
            this.dialog.setDefaultCloseOperation(2);
            this.messagePane = new JPanel();
            this.messagePane.setBorder(new EmptyBorder(5, 10, 5, 10));
            this.messagePane.setLayout(new BoxLayout(this.messagePane, 1));
            if (message != null) {
                message = sceUtility.formatMessageForDialog(message);
                while (message.length() > 0) {
                    int newLinePosition = message.indexOf("\n");
                    JLabel label = new JLabel();
                    label.setHorizontalAlignment(0);
                    label.setAlignmentX(0.5f);
                    if (newLinePosition < 0) {
                        label.setText(message);
                        message = "";
                    } else {
                        String messagePart = message.substring(0, newLinePosition);
                        label.setText(messagePart);
                        message = message.substring(newLinePosition + 1);
                    }
                    this.messagePane.add(label);
                }
            }
            if (JDialog.isDefaultLookAndFeelDecorated() && UIManager.getLookAndFeel().getSupportsWindowDecorations()) {
                this.dialog.setUndecorated(true);
                this.getRootPane().setWindowDecorationStyle(3);
            }
            this.buttonPane = new JPanel();
            this.buttonPane.setBorder(new EmptyBorder(5, 10, 5, 10));
            this.buttonPane.setLayout(new BoxLayout(this.buttonPane, 0));
            this.closeActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    UtilityDialog.this.processActionCommand(event.getActionCommand());
                    UtilityDialog.this.dispose();
                }
            };
        }

        protected void dispose() {
            this.dialog.dispose();
            Emulator.getMainGUI().endWindowDialog();
        }

        protected void processActionCommand(String actionCommand) {
            this.buttonPressed = actionCommandYES.equals(actionCommand) ? 1 : (actionCommandNO.equals(actionCommand) ? 2 : (actionCommandOK.equals(actionCommand) ? 1 : (actionCommandESC.equals(actionCommand) ? 3 : 0)));
        }

        protected void endDialog() {
            Container contentPane = this.dialog.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            contentPane.add(this.messagePane);
            contentPane.add(this.buttonPane);
            this.dialog.pack();
            Emulator.getMainGUI().startWindowDialog(this.dialog);
        }

        protected void setDefaultButton(JButton button) {
            this.dialog.getRootPane().setDefaultButton(button);
        }

        @Override
        public void setVisible(boolean flag) {
            this.dialog.setVisible(flag);
        }

        @Override
        public boolean isVisible() {
            return this.dialog.isVisible();
        }

        @Override
        public Point getLocation() {
            return this.dialog.getLocation();
        }

        @Override
        public Dimension getSize() {
            return this.dialog.getSize();
        }

        protected boolean isButtonPressed(int button) {
            Controller controller = State.controller;
            return (controller.getButtons() & button) == button;
        }

        protected boolean isConfirmButtonPressed() {
            return this.isButtonPressed(sceUtility.getSystemParamButtonPreference() == 0 ? 8192 : 16384);
        }

        protected boolean isCancelButtonPressed() {
            return this.isButtonPressed(sceUtility.getSystemParamButtonPreference() == 0 ? 16384 : 8192);
        }

        private int getControllerLy() {
            return State.controller.getLy() & 0xFF;
        }

        private int getControllerAnalogCenter() {
            return 128;
        }

        private void checkRepeat() {
            if (this.pressedTimestamp != 0L && SystemTimeManager.getSystemTime() - this.pressedTimestamp > 200000L) {
                this.upPressedAnalog = false;
                this.upPressedButton = false;
                this.downPressedAnalog = false;
                this.downPressedButton = false;
                this.pressedTimestamp = 0L;
            }
        }

        protected boolean isUpPressed() {
            this.checkRepeat();
            if (this.upPressedButton || this.upPressedAnalog) {
                if (!this.isButtonPressed(16)) {
                    this.upPressedButton = false;
                }
                if (this.getControllerLy() >= this.getControllerAnalogCenter()) {
                    this.upPressedAnalog = false;
                }
                return false;
            }
            if (this.isButtonPressed(16)) {
                this.upPressedButton = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            if (this.getControllerLy() < this.getControllerAnalogCenter()) {
                this.upPressedAnalog = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            return false;
        }

        protected boolean isDownPressed() {
            this.checkRepeat();
            if (this.downPressedButton || this.downPressedAnalog) {
                if (!this.isButtonPressed(64)) {
                    this.downPressedButton = false;
                }
                if (this.getControllerLy() <= this.getControllerAnalogCenter()) {
                    this.downPressedAnalog = false;
                }
                return false;
            }
            if (this.isButtonPressed(64)) {
                this.downPressedButton = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            if (this.getControllerLy() > this.getControllerAnalogCenter()) {
                this.downPressedAnalog = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            return false;
        }

        public void checkController() {
            if (this.isConfirmButtonPressed()) {
                this.processActionCommand(this.confirmButtonActionCommand);
                this.dispose();
            } else if (this.isCancelButtonPressed()) {
                this.processActionCommand(this.cancelButtonActionCommand);
                this.dispose();
            }
        }
    }

    protected static class HtmlViewerUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityHtmlViewerParams htmlViewerParams;

        public HtmlViewerUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected boolean executeUpdateVisible() {
            return false;
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            this.htmlViewerParams = new SceUtilityHtmlViewerParams();
            this.paramsCommon = this.htmlViewerParams.base;
            return this.htmlViewerParams;
        }

        @Override
        protected boolean hasDialog() {
            return false;
        }
    }

    protected static class NpSigninUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityNpSigninParams npSigninParams;

        public NpSigninUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            this.npSigninParams = new SceUtilityNpSigninParams();
            this.paramsCommon = this.npSigninParams.base;
            return this.npSigninParams;
        }

        @Override
        protected boolean executeUpdateVisible() {
            return false;
        }

        @Override
        protected boolean hasDialog() {
            return false;
        }
    }

    protected static class GamedataInstallUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityGamedataInstallParams gamedataInstallParams;

        public GamedataInstallUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            this.gamedataInstallParams = new SceUtilityGamedataInstallParams();
            this.paramsCommon = this.gamedataInstallParams.base;
            return this.gamedataInstallParams;
        }

        @Override
        protected boolean executeUpdateVisible() {
            String[] fileNames;
            IoFileMgrForUser fileMgr = Modules.IoFileMgrForUserModule;
            StringBuilder sourceLocalFileName = new StringBuilder();
            IVirtualFileSystem ivfs = fileMgr.getVirtualFileSystem("disc0:/PSP_GAME/INSDIR", sourceLocalFileName);
            if (ivfs != null && (fileNames = ivfs.ioDopen(sourceLocalFileName.toString())) != null) {
                ivfs.ioDclose(sourceLocalFileName.toString());
                StringBuilder destinationLocalFileName = new StringBuilder();
                IVirtualFileSystem ovfs = fileMgr.getVirtualFileSystem(String.format("%s%s%s", "ms0:/PSP/SAVEDATA/", this.gamedataInstallParams.gameName, this.gamedataInstallParams.dataName), destinationLocalFileName);
                if (ovfs != null) {
                    int numberFiles = 0;
                    for (int i = 0; i < fileNames.length; ++i) {
                        String sourceFileName;
                        IVirtualFile ivf;
                        String fileName = fileNames[i];
                        if (fileName.equals(".") || fileName.equals("\u0001") || (ivf = ivfs.ioOpen(sourceFileName = String.format("%s/%s", sourceLocalFileName.toString(), fileName), 1, 0)) == null) continue;
                        String destinationFileName = String.format("%s/%s", destinationLocalFileName.toString(), fileName);
                        IVirtualFile ovf = ovfs.ioOpen(destinationFileName, 514, 511);
                        if (ovf != null) {
                            int length;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("GamedataInstall: copying file disc0:/%s to ms0:/%s", sourceFileName, destinationFileName));
                            }
                            byte[] buffer = new byte[524288];
                            for (long restLength = ivf.length(); restLength > 0L; restLength -= (long)length) {
                                length = buffer.length;
                                if ((long)length > restLength) {
                                    length = (int)restLength;
                                }
                                length = ivf.ioRead(buffer, 0, length);
                                ovf.ioWrite(buffer, 0, length);
                            }
                            ovf.ioClose();
                            ++numberFiles;
                        }
                        ivf.ioClose();
                    }
                    this.gamedataInstallParams.unkResult1 = numberFiles;
                    this.gamedataInstallParams.unkResult2 = numberFiles;
                    this.gamedataInstallParams.write(this.paramsAddr);
                }
            }
            return false;
        }

        @Override
        protected boolean hasDialog() {
            return false;
        }
    }

    protected static class ScreenshotUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityScreenshotParams screenshotParams;

        public ScreenshotUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected boolean executeUpdateVisible() {
            if (this.status == 2) {
                this.status = 5;
            }
            return false;
        }

        protected int executeContStart(TPointer paramsAddr) {
            if (this.status != 5) {
                return -2146369535;
            }
            this.paramsAddr = paramsAddr;
            this.params = this.createParams();
            this.params.read(paramsAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("%sContStart %s", this.name, this.params.toString()));
            }
            if (!this.screenshotParams.isContModeOn()) {
                return -2146364887;
            }
            this.status = 3;
            return 0;
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            this.screenshotParams = new SceUtilityScreenshotParams();
            this.paramsCommon = this.screenshotParams.base;
            return this.screenshotParams;
        }

        @Override
        protected boolean hasDialog() {
            return false;
        }
    }

    protected static class NetconfUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityNetconfParams netconfParams;

        public NetconfUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected boolean executeUpdateVisible() {
            boolean keepVisible = false;
            if (this.netconfParams.netAction == 0 || this.netconfParams.netAction == 3) {
                int state = Modules.sceNetApctlModule.hleNetApctlGetState();
                if (state == 4) {
                    keepVisible = false;
                } else {
                    keepVisible = true;
                    if (state == 0) {
                        Modules.sceNetApctlModule.hleNetApctlConnect(1);
                    }
                }
            } else if (this.netconfParams.netAction == 2 || this.netconfParams.netAction == 4 || this.netconfParams.netAction == 5) {
                int state = Modules.sceNetAdhocctlModule.hleNetAdhocctlGetState();
                if (state == 1) {
                    this.quitDialog();
                    keepVisible = false;
                } else {
                    this.updateDialog();
                    keepVisible = true;
                    if (state == 0 && this.netconfParams.netconfData != null) {
                        Modules.sceNetAdhocctlModule.hleNetAdhocctlConnect(this.netconfParams.netconfData.groupName);
                    }
                }
            }
            return keepVisible;
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            this.netconfParams = new SceUtilityNetconfParams();
            this.paramsCommon = this.netconfParams.base;
            return this.netconfParams;
        }
    }

    protected static class GameSharingUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityGameSharingParams gameSharingParams;

        public GameSharingUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected boolean executeUpdateVisible() {
            return false;
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            this.gameSharingParams = new SceUtilityGameSharingParams();
            this.paramsCommon = this.gameSharingParams.base;
            return this.gameSharingParams;
        }

        @Override
        protected boolean hasDialog() {
            return false;
        }
    }

    protected static class OskUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityOskParams oskParams;
        protected OskDialog oskDialog;

        public OskUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected boolean executeUpdateVisible() {
            Memory mem = Processor.memory;
            if (!this.isDialogOpen()) {
                this.oskDialog = new OskDialog(this.oskParams, this);
                this.openDialog(this.oskDialog);
            } else if (!this.isDialogActive()) {
                if (this.oskDialog.buttonPressed == 1) {
                    this.oskParams.oskData.result = 2;
                    this.oskParams.oskData.outText = this.oskDialog.textField.getText();
                    log.info((Object)("hleUtilityOskDisplay returning '" + this.oskParams.oskData.outText + "'"));
                } else {
                    this.oskParams.oskData.result = 1;
                    this.oskParams.oskData.outText = this.oskDialog.textField.getText();
                    log.info((Object)"hleUtilityOskDisplay cancelled");
                }
                this.quitDialog(0);
                this.oskParams.write(mem);
            } else {
                this.oskDialog.checkController();
                this.updateDialog();
            }
            return false;
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            this.oskParams = new SceUtilityOskParams();
            this.paramsCommon = this.oskParams.base;
            return this.oskParams;
        }
    }

    protected static class MsgDialogUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityMsgDialogParams msgDialogParams;

        public MsgDialogUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected boolean executeUpdateVisible() {
            Memory mem = Processor.memory;
            if (!this.isDialogOpen()) {
                GuMsgDialog gu = new GuMsgDialog(this.msgDialogParams, this);
                this.openDialog(gu);
            } else if (!this.isDialogActive()) {
                this.msgDialogParams.buttonPressed = this.msgDialogParams.mode == 1 ? this.getButtonPressed() : (this.msgDialogParams.mode == 0 ? 3 : 0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceUtilityMsgDialog returning buttonPressed=%d", this.msgDialogParams.buttonPressed));
                }
                this.quitDialog(0);
                this.msgDialogParams.write(mem);
            } else {
                this.updateDialog();
            }
            return false;
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            this.msgDialogParams = new SceUtilityMsgDialogParams();
            this.paramsCommon = this.msgDialogParams.base;
            return this.msgDialogParams;
        }
    }

    protected static class SavedataUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilitySavedataParam savedataParams;
        protected volatile String saveListSelection;
        protected boolean saveListEmpty;
        private int savedataMultiStatus;

        public SavedataUtilityDialogState(String name) {
            super(name);
            this.setMinimumVisibleDurationMillis(500);
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            this.savedataParams = new SceUtilitySavedataParam();
            this.paramsCommon = this.savedataParams.base;
            return this.savedataParams;
        }

        @Override
        protected int checkValidity() {
            int paramSize = this.savedataParams.base.totalSizeof();
            if (paramSize != 1480 && paramSize != 1500 && paramSize != 1536) {
                log.warn((Object)String.format("sceUtilitySavedataInitStart invalid parameter size %d", paramSize));
                return -2146369532;
            }
            return super.checkValidity();
        }

        protected int checkMultipleCallStatus() {
            if (this.savedataParams.multiStatus == 0 || this.savedataParams.multiStatus == 1) {
                this.savedataMultiStatus = this.savedataParams.multiStatus;
                return 0;
            }
            if ((this.savedataParams.multiStatus == 2 || this.savedataParams.multiStatus == 3) && this.savedataMultiStatus <= this.savedataParams.multiStatus) {
                this.savedataMultiStatus = this.savedataParams.multiStatus;
                return 0;
            }
            return -2146368724;
        }

        @Override
        protected boolean executeUpdateVisible() {
            Memory mem = Processor.memory;
            switch (this.savedataParams.mode) {
                case 0: {
                    if ((this.savedataParams.saveName == null || this.savedataParams.saveName.length() == 0) && this.savedataParams.saveNameList != null && this.savedataParams.saveNameList.length > 0) {
                        this.savedataParams.saveName = this.savedataParams.saveNameList[0];
                    }
                    try {
                        this.savedataParams.load(mem);
                        this.savedataParams.base.result = 0;
                        this.savedataParams.write(mem);
                    }
                    catch (IOException e) {
                        if (!this.savedataParams.isGameDirectoryPresent()) {
                            this.savedataParams.base.result = -2146368761;
                            break;
                        }
                        if (this.savedataParams.base.totalSizeof() < 1536) {
                            this.savedataParams.base.result = -2146368761;
                            break;
                        }
                        this.savedataParams.base.result = -2146368759;
                    }
                    catch (Exception e) {
                        this.savedataParams.base.result = -2146368763;
                        log.error((Object)e);
                    }
                    break;
                }
                case 2: {
                    switch (this.dialogState) {
                        case init: {
                            if ((this.savedataParams.saveName == null || this.savedataParams.saveName.length() == 0) && this.savedataParams.saveNameList != null && this.savedataParams.saveNameList.length > 0) {
                                this.savedataParams.saveName = this.savedataParams.saveNameList[0];
                            }
                            this.setYesSelected(true);
                            GuSavedataDialogLoad gu = new GuSavedataDialogLoad(this.savedataParams, this);
                            this.openDialog(gu);
                            this.dialogState = UtilityDialogState.DialogState.confirmation;
                            break;
                        }
                        case confirmation: {
                            if (!this.isDialogActive()) {
                                if (this.getButtonPressed() != 1 || this.isNoSelected()) {
                                    this.cancel();
                                    break;
                                }
                                this.closeDialog();
                                this.dialogState = UtilityDialogState.DialogState.inProgress;
                                break;
                            }
                            this.updateDialog();
                            break;
                        }
                        case inProgress: {
                            try {
                                this.savedataParams.load(mem);
                                this.savedataParams.base.result = 0;
                                this.savedataParams.write(mem);
                            }
                            catch (IOException e) {
                                this.savedataParams.base.result = !this.savedataParams.isGameDirectoryPresent() ? -2146368761 : (this.savedataParams.base.totalSizeof() < 1536 ? -2146368761 : -2146368759);
                            }
                            catch (Exception e) {
                                this.savedataParams.base.result = -2146368763;
                                log.error((Object)e);
                            }
                            if (!this.isReadyForVisible()) break;
                            GuSavedataDialogCompleted gu = new GuSavedataDialogCompleted(this.savedataParams, this);
                            this.openDialog(gu);
                            this.dialogState = UtilityDialogState.DialogState.completed;
                            break;
                        }
                        case completed: {
                            if (!this.isDialogActive()) {
                                this.quitDialog();
                                break;
                            }
                            this.updateDialog();
                        }
                    }
                    break;
                }
                case 4: {
                    switch (this.dialogState) {
                        case init: {
                            ArrayList<String> validNames = new ArrayList<String>();
                            for (int i = 0; i < this.savedataParams.saveNameList.length; ++i) {
                                this.savedataParams.saveName = this.savedataParams.saveNameList[i];
                                if (!this.savedataParams.isPresent()) continue;
                                validNames.add(this.savedataParams.saveName);
                            }
                            GuSavedataDialog gu = new GuSavedataDialog(this.savedataParams, this, validNames.toArray(new String[validNames.size()]));
                            this.openDialog(gu);
                            break;
                        }
                        case display: {
                            if (!this.isDialogActive()) {
                                if (this.getButtonPressed() != 1) {
                                    int result = this.saveListEmpty ? -2146368761 : -2146368760;
                                    this.quitDialog(result);
                                    break;
                                }
                                if (this.saveListSelection == null) {
                                    log.warn((Object)"Savedata MODE_LISTLOAD no save selected");
                                    this.quitDialog(-2146368760);
                                    break;
                                }
                                this.closeDialog();
                                this.dialogState = UtilityDialogState.DialogState.inProgress;
                                break;
                            }
                            this.updateDialog();
                            break;
                        }
                        case inProgress: {
                            try {
                                this.savedataParams.saveName = this.saveListSelection;
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)String.format("Loading savedata %s", this.savedataParams.saveName));
                                }
                                this.savedataParams.load(mem);
                                this.savedataParams.base.result = 0;
                                this.savedataParams.write(mem);
                            }
                            catch (IOException e) {
                                this.savedataParams.base.result = !this.savedataParams.isGameDirectoryPresent() ? -2146368761 : (this.savedataParams.base.totalSizeof() < 1536 ? -2146368761 : -2146368759);
                            }
                            catch (Exception e) {
                                this.savedataParams.base.result = -2146368763;
                                log.error((Object)e);
                            }
                            if (!this.isReadyForVisible()) break;
                            GuSavedataDialogCompleted gu = new GuSavedataDialogCompleted(this.savedataParams, this);
                            this.openDialog(gu);
                            this.dialogState = UtilityDialogState.DialogState.completed;
                            break;
                        }
                        case completed: {
                            if (!this.isDialogActive()) {
                                this.quitDialog();
                                break;
                            }
                            this.updateDialog();
                        }
                    }
                    break;
                }
                case 1: {
                    if ((this.savedataParams.saveName == null || this.savedataParams.saveName.length() == 0) && this.savedataParams.saveNameList != null && this.savedataParams.saveNameList.length > 0) {
                        this.savedataParams.saveName = this.savedataParams.saveNameList[0];
                    }
                    try {
                        this.savedataParams.save(mem);
                        this.savedataParams.base.result = 0;
                    }
                    catch (IOException e) {
                        this.savedataParams.base.result = -2146368635;
                    }
                    catch (Exception e) {
                        this.savedataParams.base.result = -2146368635;
                        log.error((Object)e);
                    }
                    break;
                }
                case 3: {
                    switch (this.dialogState) {
                        case init: {
                            if ((this.savedataParams.saveName == null || this.savedataParams.saveName.length() == 0) && this.savedataParams.saveNameList != null && this.savedataParams.saveNameList.length > 0) {
                                this.savedataParams.saveName = this.savedataParams.saveNameList[0];
                            }
                            this.setYesSelected(!this.savedataParams.isPresent());
                            GuSavedataDialogSave gu = new GuSavedataDialogSave(this.savedataParams, this);
                            this.openDialog(gu);
                            this.dialogState = UtilityDialogState.DialogState.confirmation;
                            break;
                        }
                        case confirmation: {
                            if (!this.isDialogActive()) {
                                if (this.getButtonPressed() != 1 || this.isNoSelected()) {
                                    this.cancel();
                                    break;
                                }
                                this.closeDialog();
                                this.dialogState = UtilityDialogState.DialogState.inProgress;
                                break;
                            }
                            this.updateDialog();
                            break;
                        }
                        case inProgress: {
                            try {
                                this.savedataParams.save(mem);
                                this.savedataParams.base.result = 0;
                            }
                            catch (IOException e) {
                                this.savedataParams.base.result = -2146368635;
                            }
                            catch (Exception e) {
                                this.savedataParams.base.result = -2146368635;
                                log.error((Object)e);
                            }
                            if (!this.isReadyForVisible()) break;
                            GuSavedataDialogCompleted gu = new GuSavedataDialogCompleted(this.savedataParams, this);
                            this.openDialog(gu);
                            this.dialogState = UtilityDialogState.DialogState.completed;
                            break;
                        }
                        case completed: {
                            if (!this.isDialogActive()) {
                                this.quitDialog();
                                break;
                            }
                            this.updateDialog();
                        }
                    }
                    break;
                }
                case 5: {
                    switch (this.dialogState) {
                        case init: {
                            GuSavedataDialog gu = new GuSavedataDialog(this.savedataParams, this, this.savedataParams.saveNameList);
                            this.openDialog(gu);
                            break;
                        }
                        case display: {
                            if (!this.isDialogActive()) {
                                this.closeDialog();
                                if (this.getButtonPressed() != 1) {
                                    this.quitDialog(-2146368632);
                                    break;
                                }
                                if (this.saveListSelection == null) {
                                    log.warn((Object)"Savedata MODE_LISTSAVE no save selected");
                                    this.quitDialog(-2146368632);
                                    break;
                                }
                                this.savedataParams.saveName = this.saveListSelection;
                                this.savedataParams.write(mem);
                                if (this.savedataParams.isPresent(this.savedataParams.gameName, this.saveListSelection)) {
                                    if (!this.isReadyForVisible()) break;
                                    GuSavedataDialogSave gu = new GuSavedataDialogSave(this.savedataParams, this);
                                    this.openDialog(gu);
                                    this.dialogState = UtilityDialogState.DialogState.confirmation;
                                    break;
                                }
                                this.dialogState = UtilityDialogState.DialogState.inProgress;
                                break;
                            }
                            this.updateDialog();
                            break;
                        }
                        case confirmation: {
                            if (!this.isDialogActive()) {
                                if (this.getButtonPressed() != 1 || this.isNoSelected()) {
                                    this.cancel();
                                    break;
                                }
                                this.closeDialog();
                                this.dialogState = UtilityDialogState.DialogState.inProgress;
                                break;
                            }
                            this.updateDialog();
                            break;
                        }
                        case inProgress: {
                            try {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)String.format("Saving savedata %s", this.savedataParams.saveName));
                                }
                                this.savedataParams.save(mem);
                                this.savedataParams.base.result = 0;
                            }
                            catch (IOException e) {
                                this.savedataParams.base.result = -2146368635;
                            }
                            catch (Exception e) {
                                this.savedataParams.base.result = -2146368635;
                                log.error((Object)e);
                            }
                            if (!this.isReadyForVisible()) break;
                            GuSavedataDialogCompleted gu = new GuSavedataDialogCompleted(this.savedataParams, this);
                            this.openDialog(gu);
                            this.dialogState = UtilityDialogState.DialogState.completed;
                            break;
                        }
                        case completed: {
                            if (!this.isDialogActive()) {
                                this.quitDialog();
                                break;
                            }
                            this.updateDialog();
                        }
                    }
                    break;
                }
                case 7: {
                    if (this.savedataParams.saveNameList != null) {
                        for (int i = 0; i < this.savedataParams.saveNameList.length; ++i) {
                            String save = this.savedataParams.getBasePath(this.savedataParams.saveNameList[i]);
                            if (!Modules.IoFileMgrForUserModule.rmdir(save, true)) continue;
                            log.debug((Object)("Savedata MODE_DELETE deleting " + save));
                        }
                        this.savedataParams.base.result = 0;
                        break;
                    }
                    if (this.savedataParams.saveName.length() > 0) {
                        String saveDir = this.savedataParams.getBasePath();
                        if (Modules.IoFileMgrForUserModule.rmdir(saveDir, true)) {
                            this.savedataParams.base.result = 0;
                            break;
                        }
                        log.warn((Object)"Savedata MODE_DELETE directory not found!");
                        this.savedataParams.base.result = -2146368697;
                        break;
                    }
                    if (!this.isDialogOpen()) {
                        String pattern = this.savedataParams.gameName + ".*";
                        String[] entries = Modules.IoFileMgrForUserModule.listFiles("ms0:/PSP/SAVEDATA/", pattern);
                        ArrayList<String> validNames = new ArrayList<String>();
                        for (int i = 0; entries != null && i < entries.length; ++i) {
                            String saveName = entries[i].substring(this.savedataParams.gameName.length());
                            if (!this.savedataParams.isPresent(this.savedataParams.gameName, saveName)) continue;
                            validNames.add(saveName);
                        }
                        GuSavedataDialog gu = new GuSavedataDialog(this.savedataParams, this, validNames.toArray(new String[validNames.size()]));
                        this.openDialog(gu);
                        break;
                    }
                    if (!this.isDialogActive()) {
                        int result;
                        if (this.getButtonPressed() != 1) {
                            result = -2146368696;
                        } else if (this.saveListSelection == null) {
                            log.warn((Object)"Savedata MODE_DELETE no save selected");
                            result = -2146368696;
                        } else {
                            String dirName = this.savedataParams.getBasePath(this.saveListSelection);
                            if (Modules.IoFileMgrForUserModule.rmdir(dirName, true)) {
                                log.debug((Object)("Savedata MODE_DELETE deleting " + dirName));
                                result = 0;
                            } else {
                                result = -2146368699;
                            }
                        }
                        this.quitDialog(result);
                        break;
                    }
                    this.updateDialog();
                    break;
                }
                case 8: {
                    int utilityDataAddr;
                    int msDataAddr;
                    int msFreeAddr;
                    int retval = 0;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("MODE_SIZES: msFreeAddr=0x%08X-0x%08X, msDataAddr=0x%08X-0x%08X, utilityDataAddr=0x%08X-0x%08X", this.savedataParams.msFreeAddr, this.savedataParams.msFreeAddr + 20, this.savedataParams.msDataAddr, this.savedataParams.msDataAddr + 64, this.savedataParams.utilityDataAddr, this.savedataParams.utilityDataAddr + 28));
                    }
                    if ((msFreeAddr = this.savedataParams.msFreeAddr) != 0) {
                        String memoryStickFreeSpaceString = MemoryStick.getSizeKbString(MemoryStick.getFreeSizeKb());
                        mem.write32(msFreeAddr + 0, MemoryStick.getSectorSize());
                        mem.write32(msFreeAddr + 4, MemoryStick.getFreeSizeKb() / MemoryStick.getSectorSizeKb());
                        mem.write32(msFreeAddr + 8, MemoryStick.getFreeSizeKb());
                        Utilities.writeStringNZ(mem, msFreeAddr + 12, 8, memoryStickFreeSpaceString);
                        log.debug((Object)("Memory Stick Free Space = " + memoryStickFreeSpaceString));
                    }
                    if ((msDataAddr = this.savedataParams.msDataAddr) != 0) {
                        String gameName = Utilities.readStringNZ(mem, msDataAddr, 13);
                        String saveName = Utilities.readStringNZ(mem, msDataAddr + 16, 20);
                        if (this.savedataParams.isDirectoryPresent(gameName, saveName = this.savedataParams.getAnySaveName(gameName, saveName))) {
                            int savedataSizeKb = this.savedataParams.getSizeKb(gameName, saveName);
                            int savedataSize32Kb = MemoryStick.getSize32Kb(savedataSizeKb);
                            mem.write32(msDataAddr + 36, savedataSizeKb / MemoryStick.getSectorSizeKb());
                            mem.write32(msDataAddr + 40, savedataSizeKb);
                            Utilities.writeStringNZ(mem, msDataAddr + 44, 8, MemoryStick.getSizeKbString(savedataSizeKb));
                            mem.write32(msDataAddr + 52, savedataSize32Kb);
                            Utilities.writeStringNZ(mem, msDataAddr + 56, 8, MemoryStick.getSizeKbString(savedataSize32Kb));
                            log.debug((Object)("Memory Stick Used Space = " + MemoryStick.getSizeKbString(savedataSizeKb)));
                        } else {
                            log.debug((Object)String.format("Savedata MODE_SIZES directory not found, gameName='%s', saveName='%s'", gameName, saveName));
                            retval = -2146368569;
                        }
                    }
                    if ((utilityDataAddr = this.savedataParams.utilityDataAddr) != 0) {
                        int memoryStickRequiredSpaceKb = this.savedataParams.getRequiredSizeKb();
                        String memoryStickRequiredSpaceString = MemoryStick.getSizeKbString(memoryStickRequiredSpaceKb);
                        int memoryStickRequiredSpace32Kb = MemoryStick.getSize32Kb(memoryStickRequiredSpaceKb);
                        String memoryStickRequiredSpace32KbString = MemoryStick.getSizeKbString(memoryStickRequiredSpace32Kb);
                        mem.write32(utilityDataAddr + 0, memoryStickRequiredSpaceKb / MemoryStick.getSectorSizeKb());
                        mem.write32(utilityDataAddr + 4, memoryStickRequiredSpaceKb);
                        Utilities.writeStringNZ(mem, utilityDataAddr + 8, 8, memoryStickRequiredSpaceString);
                        mem.write32(utilityDataAddr + 16, memoryStickRequiredSpace32Kb);
                        Utilities.writeStringNZ(mem, utilityDataAddr + 20, 8, memoryStickRequiredSpace32KbString);
                        log.debug((Object)("Memory Stick Required Space = " + memoryStickRequiredSpaceString));
                    }
                    this.savedataParams.base.result = retval;
                    break;
                }
                case 9: {
                    String saveDir = this.savedataParams.getBasePath();
                    if (Modules.IoFileMgrForUserModule.rmdir(saveDir, true)) {
                        this.savedataParams.base.result = 0;
                        break;
                    }
                    log.warn((Object)"Savedata MODE_AUTODELETE directory not found!");
                    this.savedataParams.base.result = -2146368697;
                    break;
                }
                case 10: {
                    String saveDir = this.savedataParams.getBasePath();
                    if (Modules.IoFileMgrForUserModule.rmdir(saveDir, true)) {
                        this.savedataParams.base.result = 0;
                        break;
                    }
                    log.warn((Object)"Savedata MODE_SINGLEDELETE directory not found!");
                    this.savedataParams.base.result = -2146368697;
                    break;
                }
                case 11: {
                    int buffer4Addr = this.savedataParams.idListAddr;
                    if (Memory.isAddressGood(buffer4Addr)) {
                        int maxEntries = mem.read32(buffer4Addr + 0);
                        int entriesAddr = mem.read32(buffer4Addr + 8);
                        String saveName = this.savedataParams.saveName;
                        String pattern = saveName.replace('?', '.');
                        pattern = pattern.replace("*", ".*");
                        pattern = this.savedataParams.gameName + pattern;
                        String[] entries = Modules.IoFileMgrForUserModule.listFiles("ms0:/PSP/SAVEDATA/", pattern);
                        int numEntries = entries == null ? 0 : entries.length;
                        numEntries = Math.min(numEntries, maxEntries);
                        for (int i = 0; i < numEntries; ++i) {
                            String filePath = "ms0:/PSP/SAVEDATA//" + entries[i];
                            SceIoStat stat = Modules.IoFileMgrForUserModule.statFile(filePath);
                            int entryAddr = entriesAddr + i * 72;
                            if (stat != null) {
                                mem.write32(entryAddr + 0, stat.mode);
                                stat.ctime.write(mem, entryAddr + 4);
                                stat.atime.write(mem, entryAddr + 20);
                                stat.mtime.write(mem, entryAddr + 36);
                            }
                            String entryName = entries[i].substring(this.savedataParams.gameName.length());
                            Utilities.writeStringNZ(mem, entryAddr + 52, 20, entryName);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)String.format("MODE_LIST returning filePath=%s, stat=%s, entryName=%s at 0x%08X", filePath, stat, entryName, entryAddr));
                        }
                        mem.write32(buffer4Addr + 4, numEntries);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("MODE_LIST returning %d entries", numEntries));
                        }
                    }
                    this.savedataParams.base.result = this.checkMultipleCallStatus();
                    break;
                }
                case 12: {
                    int fileListAddr = this.savedataParams.fileListAddr;
                    if (!Memory.isAddressGood(fileListAddr)) break;
                    int saveFileSecureEntriesAddr = mem.read32(fileListAddr + 24);
                    int saveFileEntriesAddr = mem.read32(fileListAddr + 28);
                    int systemEntriesAddr = mem.read32(fileListAddr + 32);
                    String path = this.savedataParams.getBasePath();
                    String[] entries = Modules.IoFileMgrForUserModule.listFiles(path, null);
                    int maxNumEntries = entries == null ? 0 : entries.length;
                    int saveFileSecureNumEntries = 0;
                    int saveFileNumEntries = 0;
                    int systemFileNumEntries = 0;
                    for (int i = 0; i < maxNumEntries; ++i) {
                        String entryName;
                        int entryAddr;
                        String entry = entries[i];
                        String filePath = path + "/" + entry;
                        SceIoStat stat = Modules.IoFileMgrForUserModule.statFile(filePath);
                        if (SceUtilitySavedataParam.isSystemFile(entry)) {
                            if (systemEntriesAddr == 0) continue;
                            entryAddr = systemEntriesAddr + systemFileNumEntries * 80;
                            if (stat != null) {
                                mem.write32(entryAddr + 0, stat.mode);
                                mem.write64(entryAddr + 8, stat.size);
                                stat.ctime.write(mem, entryAddr + 16);
                                stat.atime.write(mem, entryAddr + 32);
                                stat.mtime.write(mem, entryAddr + 48);
                            }
                            entryName = entries[i];
                            Utilities.writeStringNZ(mem, entryAddr + 64, 16, entryName);
                            ++systemFileNumEntries;
                            continue;
                        }
                        if (this.savedataParams.isSecureFile(entry)) {
                            if (saveFileSecureEntriesAddr == 0) continue;
                            entryAddr = saveFileSecureEntriesAddr + saveFileSecureNumEntries * 80;
                            if (stat != null) {
                                mem.write32(entryAddr + 0, stat.mode);
                                long fileSize = stat.size;
                                if (CryptoEngine.getSavedataCryptoStatus()) {
                                    fileSize = (fileSize + 15L & 0xFFFFFFFFFFFFFFF0L) - 16L;
                                }
                                mem.write64(entryAddr + 8, fileSize);
                                stat.ctime.write(mem, entryAddr + 16);
                                stat.atime.write(mem, entryAddr + 32);
                                stat.mtime.write(mem, entryAddr + 48);
                            }
                            entryName = entries[i];
                            Utilities.writeStringNZ(mem, entryAddr + 64, 16, entryName);
                            ++saveFileSecureNumEntries;
                            continue;
                        }
                        if (saveFileEntriesAddr == 0) continue;
                        entryAddr = saveFileEntriesAddr + saveFileNumEntries * 80;
                        if (stat != null) {
                            mem.write32(entryAddr + 0, stat.mode);
                            mem.write64(entryAddr + 8, stat.size);
                            stat.ctime.write(mem, entryAddr + 16);
                            stat.atime.write(mem, entryAddr + 32);
                            stat.mtime.write(mem, entryAddr + 48);
                        }
                        entryName = entries[i];
                        Utilities.writeStringNZ(mem, entryAddr + 64, 16, entryName);
                        ++saveFileNumEntries;
                    }
                    this.savedataParams.base.result = entries == null ? -2146368729 : this.checkMultipleCallStatus();
                    if (this.savedataParams.base.result == 0) {
                        mem.write32(fileListAddr + 12, saveFileSecureNumEntries);
                        mem.write32(fileListAddr + 16, saveFileNumEntries);
                        mem.write32(fileListAddr + 20, systemFileNumEntries);
                    }
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)String.format("FileList: %s", Utilities.getMemoryDump(fileListAddr, 36)));
                    if (saveFileSecureEntriesAddr != 0 && saveFileSecureNumEntries > 0) {
                        log.debug((Object)String.format("SecureEntries: %s", Utilities.getMemoryDump(saveFileSecureEntriesAddr, saveFileSecureNumEntries * 80)));
                    }
                    if (saveFileEntriesAddr != 0 && saveFileNumEntries > 0) {
                        log.debug((Object)String.format("NormalEntries: %s", Utilities.getMemoryDump(saveFileEntriesAddr, saveFileNumEntries * 80)));
                    }
                    if (systemEntriesAddr == 0 || systemFileNumEntries <= 0) break;
                    log.debug((Object)String.format("SystemEntries: %s", Utilities.getMemoryDump(systemEntriesAddr, systemFileNumEntries * 80)));
                    break;
                }
                case 13: 
                case 14: {
                    try {
                        this.savedataParams.save(mem, this.savedataParams.mode == 13);
                        this.savedataParams.base.result = this.checkMultipleCallStatus();
                    }
                    catch (IOException e) {
                        this.savedataParams.base.result = -2146368731;
                    }
                    catch (Exception e) {
                        this.savedataParams.base.result = -2146368731;
                        log.error((Object)e);
                    }
                    break;
                }
                case 15: 
                case 16: {
                    if ((this.savedataParams.saveName == null || this.savedataParams.saveName.length() == 0) && this.savedataParams.saveNameList != null && this.savedataParams.saveNameList.length > 0) {
                        this.savedataParams.saveName = this.savedataParams.saveNameList[0];
                    }
                    try {
                        this.savedataParams.load(mem);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("MODE_READ/MODE_READSECURE reading %s", Utilities.getMemoryDump(this.savedataParams.dataBuf, this.savedataParams.dataSize, 4, 16)));
                        }
                        this.savedataParams.base.result = this.checkMultipleCallStatus();
                        this.savedataParams.write(mem);
                    }
                    catch (FileNotFoundException e) {
                        if (this.savedataParams.isGameDirectoryPresent()) {
                            this.savedataParams.base.result = -2146368727;
                            break;
                        }
                        this.savedataParams.base.result = -2146368729;
                    }
                    catch (IOException e) {
                        this.savedataParams.base.result = -2146368729;
                    }
                    catch (Exception e) {
                        this.savedataParams.base.result = -2146368731;
                        log.error((Object)e);
                    }
                    break;
                }
                case 17: 
                case 18: {
                    try {
                        this.savedataParams.save(mem, this.savedataParams.mode == 17);
                        this.savedataParams.base.result = this.checkMultipleCallStatus();
                    }
                    catch (IOException e) {
                        if (!this.savedataParams.isGameDirectoryPresent()) {
                            this.savedataParams.base.result = -2146368729;
                            break;
                        }
                        this.savedataParams.base.result = -2146368731;
                    }
                    catch (Exception e) {
                        this.savedataParams.base.result = -2146368731;
                        log.error((Object)e);
                    }
                    break;
                }
                case 21: {
                    if (this.savedataParams.fileName != null) {
                        String save = "ms0/PSP/SAVEDATA/" + State.discId + this.savedataParams.saveName + "/" + this.savedataParams.fileName;
                        File f = new File(save);
                        if (f.exists()) {
                            log.debug((Object)("Savedata MODE_DELETEDATA deleting " + save));
                            f.delete();
                        }
                        this.savedataParams.base.result = this.checkMultipleCallStatus();
                        break;
                    }
                    log.warn((Object)"Savedata MODE_DELETEDATA no data found!");
                    this.savedataParams.base.result = -2146368729;
                    break;
                }
                case 22: {
                    int buffer6Addr = this.savedataParams.sizeAddr;
                    boolean isPresent = this.savedataParams.isPresent();
                    if (Memory.isAddressGood(buffer6Addr)) {
                        int sizeKb;
                        String fileName;
                        long size;
                        int entryAddr;
                        int i;
                        int saveFileSecureNumEntries = mem.read32(buffer6Addr + 0);
                        int saveFileNumEntries = mem.read32(buffer6Addr + 4);
                        int saveFileSecureEntriesAddr = mem.read32(buffer6Addr + 8);
                        int saveFileEntriesAddr = mem.read32(buffer6Addr + 12);
                        int totalSizeKb = 0;
                        for (i = 0; i < saveFileSecureNumEntries; ++i) {
                            entryAddr = saveFileSecureEntriesAddr + i * 24;
                            size = mem.read64(entryAddr);
                            fileName = Utilities.readStringNZ(entryAddr + 8, 16);
                            sizeKb = Utilities.getSizeKb(size);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("   Secure File '%s', size %d (%d KB)", fileName, size, sizeKb));
                            }
                            totalSizeKb += sizeKb;
                        }
                        for (i = 0; i < saveFileNumEntries; ++i) {
                            entryAddr = saveFileEntriesAddr + i * 24;
                            size = mem.read64(entryAddr);
                            fileName = Utilities.readStringNZ(entryAddr + 8, 16);
                            sizeKb = Utilities.getSizeKb(size);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("   File '%s', size %d (%d KB)", fileName, size, sizeKb));
                            }
                            totalSizeKb += sizeKb;
                        }
                        int freeSizeKb = MemoryStick.getFreeSizeKb();
                        String memoryStickFreeSpaceString = MemoryStick.getSizeKbString(freeSizeKb);
                        mem.write32(buffer6Addr + 16, MemoryStick.getSectorSize());
                        mem.write32(buffer6Addr + 20, freeSizeKb / MemoryStick.getSectorSizeKb());
                        mem.write32(buffer6Addr + 24, freeSizeKb);
                        Utilities.writeStringNZ(mem, buffer6Addr + 28, 8, memoryStickFreeSpaceString);
                        if (totalSizeKb > freeSizeKb) {
                            int neededSizeKb = totalSizeKb - freeSizeKb;
                            mem.write32(buffer6Addr + 36, neededSizeKb);
                            Utilities.writeStringNZ(mem, buffer6Addr + 40, 8, MemoryStick.getSizeKbString(neededSizeKb));
                            if (isPresent) {
                                mem.write32(buffer6Addr + 48, neededSizeKb);
                                Utilities.writeStringNZ(mem, buffer6Addr + 52, 8, MemoryStick.getSizeKbString(neededSizeKb));
                            }
                        } else {
                            mem.write32(buffer6Addr + 36, 0);
                            if (isPresent) {
                                mem.write32(buffer6Addr + 48, 0);
                            }
                        }
                    }
                    if (MemoryStick.getStateMs() != 1) {
                        this.savedataParams.base.result = -2146368735;
                        break;
                    }
                    if (!isPresent) {
                        this.savedataParams.base.result = -2146368729;
                        break;
                    }
                    this.savedataParams.base.result = this.checkMultipleCallStatus();
                    break;
                }
                case 19: {
                    if (this.savedataParams.fileName != null) {
                        String save = this.savedataParams.getFileName(this.savedataParams.saveName, this.savedataParams.fileName);
                        if (Modules.IoFileMgrForUserModule.deleteFile(save)) {
                            this.savedataParams.base.result = this.checkMultipleCallStatus();
                            break;
                        }
                        if (this.savedataParams.isGameDirectoryPresent()) {
                            this.savedataParams.base.result = -2146368729;
                            break;
                        }
                        this.savedataParams.base.result = -2146368727;
                        break;
                    }
                    log.warn((Object)"Savedata MODE_ERASESECURE no fileName specified!");
                    this.savedataParams.base.result = -2146368729;
                    break;
                }
                default: {
                    log.warn((Object)String.format("Savedata - Unsupported mode %d", this.savedataParams.mode));
                    this.quitDialog(-1);
                }
            }
            this.savedataParams.base.writeResult(mem);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleUtilitySavedataDisplay result: 0x%08X", this.savedataParams.base.result));
            }
            return false;
        }

        @Override
        protected boolean hasDialog() {
            switch (this.savedataParams.mode) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 10: {
                    return true;
                }
            }
            return false;
        }
    }

    protected static class NotImplementedUtilityDialogState
    extends UtilityDialogState {
        public NotImplementedUtilityDialogState(String name) {
            super(name);
        }

        @Override
        public int executeInitStart(TPointer paramsAddr) {
            log.warn((Object)String.format("Unimplemented: %sInitStart params=%s", this.name, paramsAddr));
            return -2146369533;
        }

        @Override
        public int executeShutdownStart() {
            log.warn((Object)("Unimplemented: " + this.name + "ShutdownStart"));
            return -2146369533;
        }

        @Override
        public int executeGetStatus() {
            log.warn((Object)("Unimplemented: " + this.name + "GetStatus"));
            return -2146369533;
        }

        @Override
        protected boolean executeUpdateVisible() {
            log.warn((Object)("Unimplemented: " + this.name + "Update"));
            return false;
        }

        @Override
        protected pspAbstractMemoryMappedStructure createParams() {
            return null;
        }

        @Override
        protected boolean hasDialog() {
            return false;
        }
    }

    protected static abstract class UtilityDialogState {
        protected String name;
        protected pspAbstractMemoryMappedStructure params;
        protected pspUtilityDialogCommon paramsCommon;
        protected TPointer paramsAddr;
        protected int status;
        protected UtilityDialog dialog;
        protected int drawSpeed;
        protected int minimumVisibleDurationMillis;
        protected long startVisibleTimeMillis;
        protected int buttonPressed;
        protected GuUtilityDialog guDialog;
        protected boolean isOnlyGeGraphics;
        protected boolean isYesSelected;
        protected DialogState dialogState;

        public UtilityDialogState(String name) {
            this.name = name;
            this.status = 0;
            this.dialogState = DialogState.init;
            this.setButtonPressed(0);
        }

        protected void openDialog(UtilityDialog dialog) {
            if (this.dialogState == DialogState.init) {
                this.dialogState = DialogState.display;
            }
            this.status = 2;
            this.dialog = dialog;
            dialog.setVisible(true);
        }

        protected void openDialog(GuUtilityDialog guDialog) {
            if (this.dialogState == DialogState.init) {
                this.dialogState = DialogState.display;
            }
            this.status = 2;
            this.guDialog = guDialog;
            this.isOnlyGeGraphics = Modules.sceDisplayModule.isOnlyGEGraphics();
            if (this.isOnlyGeGraphics) {
                Modules.sceDisplayModule.setOnlyGEGraphics(false);
            }
        }

        protected boolean isDialogOpen() {
            return this.dialog != null || this.guDialog != null;
        }

        protected void updateDialog() {
            int delayMicros = 16666;
            if (this.drawSpeed > 0) {
                delayMicros /= this.drawSpeed;
            }
            Modules.ThreadManForUserModule.hleKernelDelayThread(delayMicros, false);
        }

        protected boolean isDialogActive() {
            if (this.isDialogOpen()) {
                if (this.dialog != null) {
                    return this.dialog.isVisible();
                }
                if (this.guDialog != null) {
                    return this.guDialog.isVisible();
                }
            }
            return false;
        }

        protected void closeDialog() {
            if (this.dialog != null) {
                this.dialog = null;
            }
            if (this.guDialog != null) {
                if (this.isOnlyGeGraphics) {
                    Modules.sceDisplayModule.setOnlyGEGraphics(this.isOnlyGeGraphics);
                }
                this.guDialog = null;
            }
        }

        private void setResult(int result) {
            if (this.paramsCommon != null) {
                this.paramsCommon.result = result;
                this.paramsCommon.writeResult(this.paramsAddr);
            }
        }

        protected void quitDialog() {
            this.closeDialog();
            this.status = 3;
            this.dialogState = DialogState.quit;
        }

        protected void quitDialog(int result) {
            this.quitDialog();
            this.setResult(result);
        }

        public int getButtonPressed() {
            return this.buttonPressed;
        }

        public final void setButtonPressed(int buttonPressed) {
            this.buttonPressed = buttonPressed;
        }

        public int executeInitStart(TPointer paramsAddr) {
            int validityResult;
            if (this.status != 0 && this.status != 4) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("%sInitStart already started status=%d", this.name, this.status));
                }
                return -2146369535;
            }
            this.paramsAddr = paramsAddr;
            this.params = this.createParams();
            this.params.read(paramsAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("%sInitStart %s-0x%08X: %s", this.name, paramsAddr, paramsAddr.getAddress() + this.params.sizeof(), this.params.toString()));
            }
            if ((validityResult = this.checkValidity()) == 0) {
                this.status = 1;
                this.dialogState = DialogState.init;
                Modules.sceUtilityModule.startedDialogState = this;
                if (!this.hasDialog()) {
                    this.status = 2;
                    this.dialogState = DialogState.quit;
                    this.startVisibleTimeMillis = Emulator.getClock().currentTimeMillis();
                }
            }
            return validityResult;
        }

        protected boolean isReadyForVisible() {
            if (State.controller.getButtons() != 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Not ready for visible, button pressed 0x%X", State.controller.getButtons()));
                }
                return false;
            }
            return true;
        }

        protected boolean hasDialog() {
            return true;
        }

        public int executeGetStatus() {
            if (Modules.sceUtilityModule.startedDialogState == null || Modules.sceUtilityModule.startedDialogState != this) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("%sGetStatus returning ERROR_UTILITY_WRONG_TYPE", this.name));
                }
                return -2146369531;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("%sGetStatus status %d", this.name, this.status));
            }
            int previousStatus = this.status;
            if (this.status == 4) {
                this.status = 0;
            } else if (this.status == 1 && this.isReadyForVisible()) {
                this.status = 2;
                this.startVisibleTimeMillis = Emulator.getClock().currentTimeMillis();
            }
            return previousStatus;
        }

        public int executeShutdownStart() {
            if (Modules.sceUtilityModule.startedDialogState == null || Modules.sceUtilityModule.startedDialogState != this) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("%ShutdownStart returning ERROR_UTILITY_WRONG_TYPE", this.name));
                }
                return -2146369531;
            }
            if (this.status != 3) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("%ShutdownStart returning ERROR_UTILITY_INVALID_STATUS", this.name));
                }
                return -2146369535;
            }
            this.status = 4;
            return 0;
        }

        public final int executeUpdate(int drawSpeed) {
            if (Modules.sceUtilityModule.startedDialogState == null || Modules.sceUtilityModule.startedDialogState != this) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("%sUpdate returning ERROR_UTILITY_WRONG_TYPE", this.name));
                }
                return -2146369531;
            }
            int result = -2146369535;
            if (this.status == 1 && this.isReadyForVisible()) {
                this.status = 2;
                this.startVisibleTimeMillis = Emulator.getClock().currentTimeMillis();
            } else if (this.status == 2 || this.status == 5) {
                long now;
                result = 0;
                this.params.read(this.paramsAddr);
                if (this.guDialog != null) {
                    this.guDialog.update(drawSpeed);
                }
                boolean keepVisible = this.executeUpdateVisible();
                if (this.status == 2 && this.isDialogOpen()) {
                    if (this.dialog != null) {
                        this.dialog.checkController();
                    }
                    if (this.guDialog != null) {
                        this.guDialog.checkController();
                    }
                }
                if (this.status == 2 && !this.isDialogOpen() && !keepVisible && this.dialogState == DialogState.quit && (now = Emulator.getClock().currentTimeMillis()) - this.startVisibleTimeMillis >= (long)this.getMinimumVisibleDurationMillis()) {
                    this.status = 3;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("%sUpdate returning 0x%08X", this.name, result));
            }
            return result;
        }

        public int executeAbort() {
            if (Modules.sceUtilityModule.startedDialogState == null || Modules.sceUtilityModule.startedDialogState != this) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("%sAbort returning ERROR_UTILITY_WRONG_TYPE", this.name));
                }
                return -2146369531;
            }
            if (this.status != 2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("%sAbort returning ERROR_UTILITY_INVALID_STATUS", this.name));
                }
                return -2146369535;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("%sAbort", this.name));
            }
            this.quitDialog(2);
            return 0;
        }

        public void cancel() {
            this.quitDialog(1);
        }

        protected abstract boolean executeUpdateVisible();

        protected abstract pspAbstractMemoryMappedStructure createParams();

        protected int checkValidity() {
            return 0;
        }

        public int getMinimumVisibleDurationMillis() {
            return this.minimumVisibleDurationMillis;
        }

        public void setMinimumVisibleDurationMillis(int minimumVisibleDurationMillis) {
            this.minimumVisibleDurationMillis = minimumVisibleDurationMillis;
        }

        protected String getDialogTitle(String key, String defaultTitle) {
            String title;
            try {
                ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
                title = key == null ? bundle.getString(this.name) : bundle.getString(this.name + "." + key);
            }
            catch (MissingResourceException mre) {
                title = defaultTitle;
            }
            return title;
        }

        public boolean isYesSelected() {
            return this.isYesSelected;
        }

        public boolean isNoSelected() {
            return !this.isYesSelected;
        }

        public void setYesSelected(boolean isYesSelected) {
            this.isYesSelected = isYesSelected;
        }

        protected static enum DialogState {
            init,
            display,
            confirmation,
            inProgress,
            completed,
            quit;

        }
    }
}

