/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.SceMT19937;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import org.apache.log4j.Logger;

@HLELogging
public class sceMt19937
extends HLEModule {
    public static Logger log = Modules.getLogger("sceMt19937");

    @Override
    public String getName() {
        return "sceMt19937";
    }

    @HLEFunction(nid=-319433863, version=150)
    public int sceMt19937Init(TPointer mt19937Addr, int seed) {
        SceMT19937 mt19937 = new SceMT19937();
        MT19937.init(mt19937, seed);
        mt19937.write(mt19937Addr);
        return 0;
    }

    @HLEFunction(nid=-200501018, version=150)
    public int sceMt19937UInt(SceMT19937 mt19937) {
        int random = MT19937.getInt(mt19937);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMt19937UInt returning 0x%08X", random));
        }
        mt19937.write(Memory.getInstance());
        return random;
    }

    public static class MT19937 {
        public static final int N = 624;
        private static final int M = 397;
        private static final int MATRIX_A = -1727483681;
        private static final int UPPER_MASK = Integer.MIN_VALUE;
        private static final int LOWER_MASK = Integer.MAX_VALUE;
        private static final int[] mag01 = new int[]{0, -1727483681};
        public static final int TEMPERING_MASK_B = -1658038656;
        public static final int TEMPERING_MASK_C = -272236544;
        public static final int TEMPERING_SHIFT_U = 11;
        public static final int TEMPERING_SHIFT_S = 7;
        public static final int TEMPERING_SHIFT_T = 15;
        public static final int TEMPERING_SHIFT_L = 18;

        protected static void init(SceMT19937 mt19937, int seed) {
            mt19937.mt[0] = seed;
            for (int mti = 1; mti < 624; ++mti) {
                mt19937.mt[mti] = 69069 * mt19937.mt[mti - 1];
            }
            mt19937.mti = 624;
        }

        protected static int getInt(SceMT19937 mt19937) {
            if (mt19937.mti >= 624) {
                int y;
                int kk;
                if (mt19937.mti == 625) {
                    MT19937.init(mt19937, 4357);
                }
                for (kk = 0; kk < 227; ++kk) {
                    y = mt19937.mt[kk] & Integer.MIN_VALUE | mt19937.mt[kk + 1] & Integer.MAX_VALUE;
                    mt19937.mt[kk] = mt19937.mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
                }
                while (kk < 623) {
                    y = mt19937.mt[kk] & Integer.MIN_VALUE | mt19937.mt[kk + 1] & Integer.MAX_VALUE;
                    mt19937.mt[kk] = mt19937.mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                    ++kk;
                }
                y = mt19937.mt[623] & Integer.MIN_VALUE | mt19937.mt[0] & Integer.MAX_VALUE;
                mt19937.mt[623] = mt19937.mt[396] ^ y >>> 1 ^ mag01[y & 1];
                mt19937.mti = 0;
            }
            long y = mt19937.mt[mt19937.mti++];
            y ^= y >> 11;
            y ^= y << 7 & 0xFFFFFFFF9D2C5680L;
            y ^= y << 15 & 0xFFFFFFFFEFC60000L;
            y ^= y >> 18;
            return (int)y;
        }
    }
}

