/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.hardware.Audio;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.sound.AudioBlockingOutputAction;
import jpcsp.sound.SoundChannel;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALC11;
import org.lwjgl.openal.ALCdevice;

@HLELogging
public class sceAudio
extends HLEModule {
    public static Logger log = Modules.getLogger("sceAudio");
    protected static final int PSP_AUDIO_VOLUME_MAX = 32768;
    protected static final int PSP_AUDIO_CHANNEL_MAX = 8;
    protected static final int PSP_AUDIO_SAMPLE_MIN = 64;
    protected static final int PSP_AUDIO_SAMPLE_MAX = 65472;
    protected static final int PSP_AUDIO_FORMAT_STEREO = 0;
    protected static final int PSP_AUDIO_FORMAT_MONO = 16;
    protected SoundChannel[] pspPCMChannels;
    protected SoundChannel pspSRCChannel;
    protected boolean disableChReserve;
    protected boolean disableBlockingAudio;
    protected ALCdevice inputDevice;
    protected ByteBuffer captureBuffer;
    protected IntBuffer samplesBuffer;
    protected boolean inputDeviceInitialized;

    @Override
    public String getName() {
        return "sceAudio";
    }

    @Override
    public void start() {
        SoundChannel.init();
        this.pspPCMChannels = new SoundChannel[8];
        for (int channel = 0; channel < this.pspPCMChannels.length; ++channel) {
            this.pspPCMChannels[channel] = new SoundChannel(channel);
        }
        this.pspSRCChannel = new SoundChannel(8);
        this.setSettingsListener("emu.disablesceAudio", new DisableAudioSettingsListerner());
        this.setSettingsListener("emu.disableblockingaudio", new DisableBlockingAudioSettingsListerner());
        super.start();
    }

    @Override
    public void stop() {
        if (this.inputDevice != null) {
            ALC11.alcCaptureCloseDevice(this.inputDevice);
            this.inputDevice = null;
        }
        this.inputDeviceInitialized = false;
        this.captureBuffer = null;
        super.stop();
    }

    private void setChReserveEnabled(boolean enabled) {
        this.disableChReserve = !enabled;
        log.info((Object)("Audio ChReserve disabled: " + this.disableChReserve));
    }

    private void setBlockingEnabled(boolean enabled) {
        this.disableBlockingAudio = !enabled;
        log.info((Object)("Audio Blocking disabled: " + this.disableBlockingAudio));
    }

    protected static int doAudioOutput(SoundChannel channel, int pvoid_buf) {
        int ret = -1;
        if (channel.isReserved()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("doAudioOutput(%s, 0x%08X)", channel.toString(), pvoid_buf));
            }
            int bytesPerSample = channel.isFormatStereo() ? 4 : 2;
            int nbytes = bytesPerSample * channel.getSampleLength();
            byte[] data = new byte[nbytes];
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(pvoid_buf, nbytes, 2);
            if (channel.isFormatMono()) {
                int volume = Audio.getVolume(channel.getLeftVolume());
                for (int i = 0; i < nbytes; i += 2) {
                    short sample = (short)memoryReader.readNext();
                    sample = SoundChannel.adjustSample(sample, volume);
                    SoundChannel.storeSample(sample, data, i);
                }
            } else {
                int leftVolume = Audio.getVolume(channel.getLeftVolume());
                int rightVolume = Audio.getVolume(channel.getRightVolume());
                for (int i = 0; i < nbytes; i += 4) {
                    short lsample = (short)memoryReader.readNext();
                    short rsample = (short)memoryReader.readNext();
                    lsample = SoundChannel.adjustSample(lsample, leftVolume);
                    rsample = SoundChannel.adjustSample(rsample, rightVolume);
                    SoundChannel.storeSample(lsample, data, i);
                    SoundChannel.storeSample(rsample, data, i + 2);
                }
            }
            channel.play(data);
            ret = channel.getSampleLength();
        } else {
            log.warn((Object)("doAudioOutput: channel " + channel.getIndex() + " not reserved"));
        }
        return ret;
    }

    protected static void blockThreadOutput(SoundChannel channel, int addr, int leftVolume, int rightVolume) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        sceAudio.blockThreadOutput(threadMan.getCurrentThreadID(), channel, addr, leftVolume, rightVolume);
        threadMan.hleBlockCurrentThread(260);
    }

    protected static void blockThreadOutput(int threadId, SoundChannel channel, int addr, int leftVolume, int rightVolume) {
        AudioBlockingOutputAction action = new AudioBlockingOutputAction(threadId, channel, addr, leftVolume, rightVolume);
        int delayMicros = channel.getUnblockOutputDelayMicros(addr == 0);
        long schedule = Emulator.getClock().microTime() + (long)delayMicros;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("blockThreadOutput micros=%d, schedule=%d", delayMicros, schedule));
        }
        Emulator.getScheduler().addAction(schedule, action);
    }

    public void hleAudioBlockingOutput(int threadId, SoundChannel channel, int addr, int leftVolume, int rightVolume) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleAudioBlockingOutput %s", channel.toString()));
        }
        if (addr == 0) {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            SceKernelThreadInfo thread = threadMan.getThreadById(threadId);
            if (thread != null) {
                thread.cpuContext._v0 = channel.getSampleLength();
                threadMan.hleUnblockThread(threadId);
            }
        } else if (!channel.isOutputBlocking()) {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            SceKernelThreadInfo thread = threadMan.getThreadById(threadId);
            if (thread != null) {
                int ret;
                sceAudio.changeChannelVolume(channel, leftVolume, rightVolume);
                thread.cpuContext._v0 = ret = sceAudio.doAudioOutput(channel, addr);
                threadMan.hleUnblockThread(threadId);
            }
        } else {
            sceAudio.blockThreadOutput(threadId, channel, addr, leftVolume, rightVolume);
        }
    }

    protected static int changeChannelVolume(SoundChannel channel, int leftvol, int rightvol) {
        int ret = -1;
        if (channel.isReserved()) {
            if (leftvol >= 0) {
                channel.setLeftVolume(leftvol);
            }
            if (rightvol >= 0) {
                channel.setRightVolume(rightvol);
            }
            ret = 0;
        }
        return ret;
    }

    protected int hleAudioGetChannelRestLength(SoundChannel channel) {
        int len = channel.getRestLength();
        if (len <= 2048) {
            len = 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleAudioGetChannelRestLength(%d) = %d", channel.getIndex(), len));
        }
        return len;
    }

    protected int hleAudioSRCChReserve(int sampleCount, int freq, int format) {
        if (this.disableChReserve) {
            log.warn((Object)String.format("IGNORED hleAudioSRCChReserve sampleCount=%d, freq=%d, format=%d", sampleCount, freq, format));
            return -1;
        }
        if (this.pspSRCChannel.isReserved()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleAudioSRCChReserve returning ERROR_AUDIO_CHANNEL_ALREADY_RESERVED", new Object[0]));
            }
            return -2144960510;
        }
        this.pspSRCChannel.setSampleRate(freq);
        this.pspSRCChannel.setReserved(true);
        this.pspSRCChannel.setSampleLength(sampleCount);
        this.pspSRCChannel.setFormat(format);
        return 0;
    }

    public int checkChannel(int channel) {
        if (channel < 0 || channel >= 8) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Invalid channel number %d", channel));
            }
            throw new SceKernelErrorException(-2144993277);
        }
        return channel;
    }

    public int checkReservedChannel(int channel) {
        if (!this.pspPCMChannels[channel = this.checkChannel(channel)].isReserved()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Channel not reserved %d", channel));
            }
            throw new SceKernelErrorException(-2144993279);
        }
        return channel;
    }

    public int checkSampleCount(int sampleCount) {
        if (sampleCount <= 0 || sampleCount > 65472 || (sampleCount & 0x3F) != 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Invalid sampleCount 0x%X", sampleCount));
            }
            throw new SceKernelErrorException(-2144993274);
        }
        return sampleCount;
    }

    public int checkSmallSampleCount(int sampleCount) {
        if (sampleCount < 17 || sampleCount >= 4112) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Invalid small sampleCount 0x%X", sampleCount));
            }
            throw new SceKernelErrorException(-2144993274);
        }
        return sampleCount;
    }

    public int checkReserveSampleCount(int sampleCount) {
        if (sampleCount < 17 || sampleCount >= 4112) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Invalid reserve sampleCount 0x%X", sampleCount));
            }
            throw new SceKernelErrorException(-2147483388);
        }
        return sampleCount;
    }

    public int checkVolume(int volume) {
        if (volume > 65535) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Invalid volume 0x%X", volume));
            }
            throw new SceKernelErrorException(-2144993269);
        }
        return volume;
    }

    public int checkVolume2(int volume) {
        if (volume < 0 || volume > 1048575) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Invalid volume 0x%X", volume));
            }
            throw new SceKernelErrorException(-2144993269);
        }
        return volume;
    }

    public int checkFormat(int format) {
        if (format != 0 && format != 16) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Invalid format 0x%X", format));
            }
            throw new SceKernelErrorException(-2144993273);
        }
        return format;
    }

    public int checkFrequency(int frequency) {
        switch (frequency) {
            case 0: 
            case 8000: 
            case 11025: 
            case 12000: 
            case 16000: 
            case 22050: 
            case 24000: 
            case 32000: 
            case 48000: {
                break;
            }
            default: {
                throw new SceKernelErrorException(-2144993270);
            }
        }
        return frequency;
    }

    public int checkChannelCount(int channelCount) {
        if (channelCount != 2) {
            if (channelCount == 4) {
                throw new SceKernelErrorException(-2147483645);
            }
            throw new SceKernelErrorException(-2147483388);
        }
        return channelCount;
    }

    protected void hleAudioBlockingInput(int threadId, int addr, int samples, int frequency) {
        int availableSamples = this.hleAudioGetInputLength();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("hleAudioBlockingInput available samples: %d from %d", availableSamples, samples));
        }
        int bufferBytes = samples << 1;
        if (this.inputDevice == null) {
            Memory.getInstance().memset(addr, (byte)0, bufferBytes);
            Modules.ThreadManForUserModule.hleUnblockThread(threadId);
        } else if (availableSamples >= samples) {
            if (this.captureBuffer == null || this.captureBuffer.capacity() < bufferBytes) {
                this.captureBuffer = BufferUtils.createByteBuffer(bufferBytes);
            } else {
                this.captureBuffer.rewind();
            }
            ALC11.alcCaptureSamples(this.inputDevice, this.captureBuffer, samples);
            this.captureBuffer.rewind();
            IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(addr, samples, 2);
            for (int i = 0; i < samples; ++i) {
                short sample = this.captureBuffer.getShort();
                memoryWriter.writeNext(sample & 0xFFFF);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("hleAudioBlockingInput returning %d samples: %s", samples, Utilities.getMemoryDump(addr, bufferBytes, 2, 16)));
            }
            Modules.ThreadManForUserModule.hleUnblockThread(threadId);
        } else {
            this.blockThreadInput(threadId, addr, samples, frequency, availableSamples);
        }
    }

    public int hleAudioGetInputLength() {
        if (this.inputDevice == null) {
            return 0;
        }
        if (this.samplesBuffer == null) {
            this.samplesBuffer = BufferUtils.createIntBuffer(1);
        }
        ALC10.alcGetInteger(this.inputDevice, 786, this.samplesBuffer);
        return this.samplesBuffer.get(0);
    }

    protected int getUnblockInputDelayMicros(int availableSamples, int samples, int frequency) {
        if (availableSamples >= samples) {
            return 0;
        }
        int missingSamples = samples - availableSamples;
        int delayMicros = (int)((long)missingSamples * 1000000L / (long)frequency);
        return delayMicros;
    }

    protected void blockThreadInput(int addr, int samples, int frequency) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        int threadId = threadMan.getCurrentThreadID();
        threadMan.hleBlockCurrentThread(260);
        this.blockThreadInput(threadId, addr, samples, frequency, this.hleAudioGetInputLength());
    }

    protected void blockThreadInput(int threadId, int addr, int samples, int frequency, int availableSamples) {
        int delayMicros = this.getUnblockInputDelayMicros(availableSamples, samples, frequency);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("blockThreadInput waiting %d micros", delayMicros));
        }
        Emulator.getScheduler().addAction(Emulator.getClock().microTime() + (long)delayMicros, new AudioBlockingInputAction(threadId, addr, samples, frequency));
    }

    public int hleAudioInputBlocking(int maxSamples, int frequency, TPointer buffer) {
        if (!this.inputDeviceInitialized) {
            IntBuffer majorVersion = BufferUtils.createIntBuffer(1);
            IntBuffer minorVersion = BufferUtils.createIntBuffer(1);
            ALC10.alcGetInteger(null, 4096, majorVersion);
            ALC10.alcGetInteger(null, 4097, minorVersion);
            log.info((Object)String.format("OpenAL Version %d.%d, extensions %s", majorVersion.get(0), minorVersion.get(0), ALC10.alcGetString(null, 4102)));
            this.inputDevice = ALC11.alcCaptureOpenDevice(null, frequency, 4353, 10240);
            if (this.inputDevice != null) {
                ALC11.alcCaptureStart(this.inputDevice);
            } else {
                log.warn((Object)String.format("No audio input device available, faking.", new Object[0]));
            }
            this.inputDeviceInitialized = true;
        }
        this.blockThreadInput(buffer.getAddress(), maxSamples, frequency);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2131626016, version=150, moduleName="sceAudio_driver", checkInsideInterrupt=true)
    public int sceAudioInit() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=554002423, version=150, moduleName="sceAudio_driver", checkInsideInterrupt=true)
    public int sceAudioEnd() {
        return 0;
    }

    @HLEFunction(nid=-1564562836, version=150, moduleName="sceAudio_driver", checkInsideInterrupt=true)
    public int sceAudioSetFrequency(int frequency) {
        if (frequency != 44100 && frequency != 48000) {
            return -2144993270;
        }
        for (int i = 0; i < this.pspPCMChannels.length; ++i) {
            this.pspPCMChannels[i].setSampleRate(frequency);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1240099392, version=150, moduleName="sceAudio_driver", checkInsideInterrupt=true)
    public int sceAudioLoopbackTest() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1837448405, version=150, moduleName="sceAudio_driver", checkInsideInterrupt=true)
    public int sceAudioSetVolumeOffset() {
        return 0;
    }

    @HLEFunction(nid=-1945105998, version=150, checkInsideInterrupt=true)
    public int sceAudioOutput(@CheckArgument(value="checkReservedChannel") int channel, @CheckArgument(value="checkVolume") int vol, @CanBeNull TPointer pvoid_buf) {
        if (this.pspPCMChannels[channel].isOutputBlocking()) {
            return -2144993278;
        }
        sceAudio.changeChannelVolume(this.pspPCMChannels[channel], vol, vol);
        int result = sceAudio.doAudioOutput(this.pspPCMChannels[channel], pvoid_buf.getAddress());
        Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        return result;
    }

    @HLEFunction(nid=325889873, version=150, checkInsideInterrupt=true)
    public int sceAudioOutputBlocking(@CheckArgument(value="checkReservedChannel") int channel, @CheckArgument(value="checkVolume") int vol, @CanBeNull TPointer pvoid_buf) {
        int result = 0;
        if (pvoid_buf.isNull()) {
            if (!this.pspPCMChannels[channel].isDrained()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sceAudioOutputBlocking[pvoid_buf==0] blocking " + this.pspPCMChannels[channel].toString()));
                }
                sceAudio.blockThreadOutput(this.pspPCMChannels[channel], pvoid_buf.getAddress(), vol, vol);
            }
            result = this.pspPCMChannels[channel].getSampleLength();
        } else if (!this.pspPCMChannels[channel].isOutputBlocking() || this.disableBlockingAudio) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("sceAudioOutputBlocking[not blocking] " + this.pspPCMChannels[channel].toString()));
            }
            sceAudio.changeChannelVolume(this.pspPCMChannels[channel], vol, vol);
            result = sceAudio.doAudioOutput(this.pspPCMChannels[channel], pvoid_buf.getAddress());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAudioOutputBlocking[not blocking] returning %d (%s)", result, this.pspPCMChannels[channel]));
            }
            Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("sceAudioOutputBlocking[blocking] " + this.pspPCMChannels[channel].toString()));
            }
            sceAudio.blockThreadOutput(this.pspPCMChannels[channel], pvoid_buf.getAddress(), vol, vol);
        }
        return result;
    }

    @HLEFunction(nid=-489329875, version=150, checkInsideInterrupt=true)
    public int sceAudioOutputPanned(@CheckArgument(value="checkReservedChannel") int channel, @CheckArgument(value="checkVolume") int leftvol, @CheckArgument(value="checkVolume") int rightvol, @CanBeNull TPointer pvoid_buf) {
        if (this.pspPCMChannels[channel].isOutputBlocking()) {
            return -2144993278;
        }
        sceAudio.changeChannelVolume(this.pspPCMChannels[channel], leftvol, rightvol);
        int result = sceAudio.doAudioOutput(this.pspPCMChannels[channel], pvoid_buf.getAddress());
        Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        return result;
    }

    @HLEFunction(nid=334860988, version=150, checkInsideInterrupt=true)
    public int sceAudioOutputPannedBlocking(@CheckArgument(value="checkReservedChannel") int channel, @CheckArgument(value="checkVolume") int leftvol, @CheckArgument(value="checkVolume") int rightvol, @CanBeNull TPointer pvoid_buf) {
        int result = 0;
        if (leftvol == Integer.MIN_VALUE || rightvol == Integer.MIN_VALUE) {
            return -2144993269;
        }
        if (pvoid_buf.isNull()) {
            if (!this.pspPCMChannels[channel].isDrained()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sceAudioOutputPannedBlocking[pvoid_buf==0] blocking " + this.pspPCMChannels[channel].toString()));
                }
                sceAudio.blockThreadOutput(this.pspPCMChannels[channel], pvoid_buf.getAddress(), leftvol, rightvol);
            }
            result = this.pspPCMChannels[channel].getSampleLength();
        } else if (!this.pspPCMChannels[channel].isOutputBlocking() || this.disableBlockingAudio) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAudioOutputPannedBlocking[not blocking] leftVol=%d, rightVol=%d, channel=%s", leftvol, rightvol, this.pspPCMChannels[channel].toString()));
            }
            sceAudio.changeChannelVolume(this.pspPCMChannels[channel], leftvol, rightvol);
            result = sceAudio.doAudioOutput(this.pspPCMChannels[channel], pvoid_buf.getAddress());
            Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAudioOutputPannedBlocking[blocking] leftVol=%d, rightVol=%d, channel=%s", leftvol, rightvol, this.pspPCMChannels[channel].toString()));
            }
            sceAudio.blockThreadOutput(this.pspPCMChannels[channel], pvoid_buf.getAddress(), leftvol, rightvol);
        }
        return result;
    }

    @HLEFunction(nid=1590172757, version=150, checkInsideInterrupt=true)
    public int sceAudioChReserve(int channel, int sampleCount, int format) {
        if (this.disableChReserve) {
            log.warn((Object)String.format("IGNORED sceAudioChReserve channel=%d, sampleCount=%d, format=%d", channel, sampleCount, format));
            return -2144993275;
        }
        if (channel >= 0) {
            if (this.pspPCMChannels[channel = this.checkChannel(channel)].isReserved()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceAudioChReserve failed - channel %d already in use", channel));
                }
                return -2144993277;
            }
        } else {
            for (int i = this.pspPCMChannels.length - 1; i >= 0; --i) {
                if (this.pspPCMChannels[i].isReserved()) continue;
                channel = i;
                break;
            }
            if (channel < 0) {
                log.debug((Object)"sceAudioChReserve failed - no free channels available");
                return -2144993275;
            }
        }
        sampleCount = this.checkSampleCount(sampleCount);
        format = this.checkFormat(format);
        this.pspPCMChannels[channel].setReserved(true);
        this.pspPCMChannels[channel].setSampleLength(sampleCount);
        this.pspPCMChannels[channel].setFormat(format);
        return channel;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1106226663, version=150, checkInsideInterrupt=true)
    public int sceAudioOneshotOutput() {
        return 0;
    }

    @HLEFunction(nid=1875142739, version=150, checkInsideInterrupt=true)
    public int sceAudioChRelease(@CheckArgument(value="checkChannel") int channel) {
        if (!this.pspPCMChannels[channel].isReserved()) {
            return -2144993272;
        }
        this.pspPCMChannels[channel].release();
        this.pspPCMChannels[channel].setReserved(false);
        return 0;
    }

    @HLEFunction(nid=-1341025745, version=150, checkInsideInterrupt=true)
    public int sceAudioGetChannelRestLength(@CheckArgument(value="checkChannel") int channel) {
        return this.hleAudioGetChannelRestLength(this.pspPCMChannels[channel]);
    }

    @HLEFunction(nid=-886160482, version=150, checkInsideInterrupt=true)
    public int sceAudioSetChannelDataLen(@CheckArgument(value="checkReservedChannel") int channel, @CheckArgument(value="checkSampleCount") int sampleCount) {
        this.pspPCMChannels[channel].setSampleLength(sampleCount);
        return 0;
    }

    @HLEFunction(nid=-1778578387, version=150, checkInsideInterrupt=true)
    public int sceAudioChangeChannelConfig(@CheckArgument(value="checkReservedChannel") int channel, @CheckArgument(value="checkFormat") int format) {
        this.pspPCMChannels[channel].setFormat(format);
        return 0;
    }

    @HLEFunction(nid=-1209935641, version=150, checkInsideInterrupt=true)
    public int sceAudioChangeChannelVolume(@CheckArgument(value="checkReservedChannel") int channel, @CheckArgument(value="checkVolume") int leftvol, @CheckArgument(value="checkVolume") int rightvol) {
        return sceAudio.changeChannelVolume(this.pspPCMChannels[channel], leftvol, rightvol);
    }

    @HLEFunction(nid=22424483, version=150, checkInsideInterrupt=true)
    public int sceAudioOutput2Reserve(@CheckArgument(value="checkReserveSampleCount") int sampleCount) {
        return this.hleAudioSRCChReserve(sampleCount, 44100, 0);
    }

    @HLEFunction(nid=1125738565, version=150, checkInsideInterrupt=true)
    public int sceAudioOutput2Release() {
        return this.sceAudioSRCChRelease();
    }

    @HLEFunction(nid=760476526, version=150, checkInsideInterrupt=true)
    public int sceAudioOutput2OutputBlocking(@CheckArgument(value="checkVolume2") int vol, @CanBeNull TPointer buf) {
        return this.sceAudioSRCOutputBlocking(vol, buf);
    }

    @HLEFunction(nid=1685909299, version=150, checkInsideInterrupt=true)
    public int sceAudioOutput2GetRestSample() {
        if (!this.pspSRCChannel.isReserved()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAudioOutput2GetRestSample returning ERROR_AUDIO_CHANNEL_NOT_RESERVED", new Object[0]));
            }
            return -2144993272;
        }
        return this.hleAudioGetChannelRestLength(this.pspSRCChannel);
    }

    @HLEFunction(nid=1676839068, version=150, checkInsideInterrupt=true)
    public int sceAudioOutput2ChangeLength(@CheckArgument(value="checkSmallSampleCount") int sampleCount) {
        if (!this.pspSRCChannel.isReserved()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAudioOutput2ChangeLength returning ERROR_AUDIO_CHANNEL_NOT_RESERVED", new Object[0]));
            }
            return -2144993272;
        }
        this.pspSRCChannel.setSampleLength(sampleCount);
        return 0;
    }

    @HLEFunction(nid=945107217, version=150, checkInsideInterrupt=true)
    public int sceAudioSRCChReserve(@CheckArgument(value="checkReserveSampleCount") int sampleCount, @CheckArgument(value="checkFrequency") int freq, @CheckArgument(value="checkChannelCount") int format) {
        return this.hleAudioSRCChReserve(sampleCount, freq, format);
    }

    @HLEFunction(nid=1547157678, version=150, checkInsideInterrupt=true)
    public int sceAudioSRCChRelease() {
        if (!this.pspSRCChannel.isReserved()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAudioSRCChRelease returning ERROR_AUDIO_CHANNEL_NOT_RESERVED", new Object[0]));
            }
            return -2144993272;
        }
        this.pspSRCChannel.release();
        this.pspSRCChannel.setReserved(false);
        return 0;
    }

    @HLEFunction(nid=-529371050, version=150, checkInsideInterrupt=true)
    public int sceAudioSRCOutputBlocking(@CheckArgument(value="checkVolume2") int vol, @CanBeNull TPointer buf) {
        int channelVolume = Math.min(32768, vol);
        this.pspSRCChannel.setVolume(channelVolume);
        if (buf.isNull()) {
            if (!this.pspSRCChannel.isDrained()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sceAudioSRCOutputBlocking[buf==0] blocking " + this.pspSRCChannel));
                }
                sceAudio.blockThreadOutput(this.pspSRCChannel, buf.getAddress(), -1, -1);
            } else {
                Modules.ThreadManForUserModule.hleYieldCurrentThread();
            }
        } else if (!this.pspSRCChannel.isReserved() && !this.disableChReserve) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAudioSRCOutputBlocking automatically reserving channel %s", this.pspSRCChannel));
            }
            this.pspSRCChannel.setReserved(true);
        } else {
            if (!this.pspSRCChannel.isOutputBlocking() || this.disableBlockingAudio) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceAudioSRCOutputBlocking[not blocking] %s to %s", buf, this.pspSRCChannel.toString()));
                }
                Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
                return sceAudio.doAudioOutput(this.pspSRCChannel, buf.getAddress());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAudioSRCOutputBlocking[blocking] %s to %s", buf, this.pspSRCChannel.toString()));
            }
            sceAudio.blockThreadOutput(this.pspSRCChannel, buf.getAddress(), -1, -1);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=141449365, version=150, checkInsideInterrupt=true)
    public int sceAudioInputBlocking(int maxSamples, int frequency, TPointer buffer) {
        if (frequency != 44100 && frequency != 22050 && frequency != 11025) {
            return -2144993270;
        }
        return this.hleAudioInputBlocking(maxSamples, frequency, buffer);
    }

    @HLEUnimplemented
    @HLEFunction(nid=1833692264, version=150, checkInsideInterrupt=true)
    public int sceAudioInput() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1492597082, version=150, checkInsideInterrupt=true)
    public int sceAudioGetInputLength() {
        return this.hleAudioGetInputLength();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2018318767, version=150, checkInsideInterrupt=true)
    public int sceAudioWaitInputEnd() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2112231048, version=150, checkInsideInterrupt=true)
    public int sceAudioInputInit() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-383331333, version=150, checkInsideInterrupt=true)
    public int sceAudioInputInitEx() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1506605938, version=150, checkInsideInterrupt=true)
    public int sceAudioPollInputEnd() {
        return 0;
    }

    @HLEFunction(nid=-371623679, version=150, checkInsideInterrupt=true)
    public int sceAudioGetChannelRestLen(@CheckArgument(value="checkChannel") int channel) {
        return this.hleAudioGetChannelRestLength(this.pspPCMChannels[channel]);
    }

    protected static class AudioBlockingInputAction
    implements IAction {
        private int threadId;
        private int addr;
        private int samples;
        private int frequency;

        public AudioBlockingInputAction(int threadId, int addr, int samples, int frequency) {
            this.threadId = threadId;
            this.addr = addr;
            this.samples = samples;
            this.frequency = frequency;
        }

        @Override
        public void execute() {
            Modules.sceAudioModule.hleAudioBlockingInput(this.threadId, this.addr, this.samples, this.frequency);
        }
    }

    private class DisableBlockingAudioSettingsListerner
    extends AbstractBoolSettingsListener {
        private DisableBlockingAudioSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceAudio.this.setBlockingEnabled(!value);
        }
    }

    private class DisableAudioSettingsListerner
    extends AbstractBoolSettingsListener {
        private DisableAudioSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceAudio.this.setChReserveEnabled(!value);
        }
    }
}

