/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.util.HashMap;
import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.pspFileBuffer;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules150.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.connector.AtracCodec;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.util.Hash;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

@HLELogging
public class sceAtrac3plus
extends HLEModule {
    public static Logger log = Modules.getLogger("sceAtrac3plus");
    protected static final String at3IdPurpose = "sceAtrac3plus.AT3";
    protected static final String at3PlusIdPurpose = "sceAtrac3plus.AT3+";
    protected static final int AT3_MAGIC = 624;
    protected static final int AT3_PLUS_MAGIC = 65534;
    public static final int RIFF_MAGIC = 1179011410;
    public static final int WAVE_MAGIC = 1163280727;
    public static final int FMT_CHUNK_MAGIC = 544501094;
    protected static final int FACT_CHUNK_MAGIC = 1952670054;
    protected static final int SMPL_CHUNK_MAGIC = 1819307379;
    public static final int DATA_CHUNK_MAGIC = 1635017060;
    private static final int ATRAC3_CONTEXT_READ_SIZE_OFFSET = 160;
    private static final int ATRAC3_CONTEXT_REQUIRED_SIZE_OFFSET = 164;
    private static final int ATRAC3_CONTEXT_DECODE_RESULT_OFFSET = 188;
    public static final int PSP_ATRAC_ALLDATA_IS_ON_MEMORY = -1;
    public static final int PSP_ATRAC_NONLOOP_STREAM_DATA_IS_ON_MEMORY = -2;
    public static final int PSP_ATRAC_LOOP_STREAM_DATA_IS_ON_MEMORY = -3;
    protected static final int PSP_ATRAC_STATUS_NONLOOP_STREAM_DATA = 0;
    protected static final int PSP_ATRAC_STATUS_LOOP_STREAM_DATA = 1;
    protected static final int PSP_MODE_AT_3_PLUS = 4096;
    protected static final int PSP_MODE_AT_3 = 4097;
    public static final int ATRAC_HEADER_HASH_LENGTH = 512;
    protected int atrac3MaxIDsCount;
    protected int atrac3plusMaxIDsCount;
    protected int atrac3Num;
    protected int atrac3plusNum;
    public static final int atracDecodeDelay = 2300;
    public static boolean useAtracCodec = false;
    protected HashMap<Integer, AtracID> atracIDs;

    @Override
    public String getName() {
        return "sceAtrac3plus";
    }

    @Override
    public void start() {
        this.atracIDs = new HashMap();
        this.atrac3Num = 0;
        this.atrac3plusNum = 0;
        this.atrac3MaxIDsCount = 2;
        this.atrac3plusMaxIDsCount = 2;
        this.setSettingsListener("emu.useConnector", new EnableConnectorSettingsListener());
        super.start();
    }

    public static boolean isEnableConnector() {
        return useAtracCodec;
    }

    private static void setEnableConnector(boolean useConnector) {
        useAtracCodec = useConnector;
    }

    protected static String getStringFromInt32(int n) {
        char c1 = (char)(n & 0xFF);
        char c2 = (char)(n >> 8 & 0xFF);
        char c3 = (char)(n >> 16 & 0xFF);
        char c4 = (char)(n >> 24 & 0xFF);
        return String.format("%c%c%c%c", Character.valueOf(c1), Character.valueOf(c2), Character.valueOf(c3), Character.valueOf(c4));
    }

    public int getBytesPerFrame(int atID) {
        return this.atracIDs.get(atID).getAtracBytesPerFrame();
    }

    protected int getRemainFrames(AtracID id, int samples) {
        int remainFrames = id.getRemainFrames();
        if (!id.getInputBuffer().isFileEnd()) {
            if (remainFrames > 0 && samples < id.getMaxSamples()) {
                id.getInputBuffer().notifyReadAll();
                remainFrames = 0;
            } else if (id.getAtracCodec().getChannelLength() < id.getInputFileSize()) {
                if (id.getAtracCodec().getChannelLength() < 32768 && id.getAtracCurrentSample() > 0) {
                    id.getInputBuffer().notifyReadAll();
                    remainFrames = 0;
                } else if (id.getAtracCodec().getChannelLength() <= 0) {
                    id.getInputBuffer().notifyReadAll();
                    remainFrames = 0;
                }
            }
        }
        return remainFrames;
    }

    protected void hleAtracReinit(int newAT3IdCount, int newAT3plusIdCount) {
        this.atrac3MaxIDsCount = newAT3IdCount;
        this.atrac3plusMaxIDsCount = newAT3plusIdCount;
        SceUidManager.resetIds(at3IdPurpose);
        SceUidManager.resetIds(at3PlusIdPurpose);
    }

    public int hleCreateAtracID(int codecType) {
        int atracID;
        String idPurpose;
        if (codecType == 4096) {
            idPurpose = at3PlusIdPurpose;
            atracID = SceUidManager.getNewId(idPurpose, 0, this.atrac3plusMaxIDsCount - 1);
        } else if (codecType == 4097) {
            idPurpose = at3IdPurpose;
            atracID = SceUidManager.getNewId(idPurpose, this.atrac3plusMaxIDsCount, this.atrac3plusMaxIDsCount + this.atrac3MaxIDsCount - 1);
        } else {
            return -1;
        }
        AtracCodec atracCodec = new AtracCodec();
        AtracID id = new AtracID(atracID, codecType, atracCodec);
        if (id.getAtracId() < 0) {
            if (atracID >= 0) {
                SceUidManager.releaseId(atracID, idPurpose);
            }
            return -2140995581;
        }
        this.atracIDs.put(atracID, id);
        return atracID;
    }

    public AtracID hleGetAtracID(int atID) {
        return this.atracIDs.get(atID);
    }

    protected int hleSetHalfwayBufferAndGetID(TPointer buffer, int readSize, int bufferSize, boolean isMonoOutput) {
        int result;
        if (readSize > bufferSize) {
            return -2140995565;
        }
        int codecType = sceAtrac3plus.getCodecType(buffer.getAddress());
        if (codecType == 0) {
            return -2140995578;
        }
        int atID = this.hleCreateAtracID(codecType);
        if (this.atracIDs.containsKey(atID) && (result = this.hleSetHalfwayBuffer(atID, buffer, readSize, bufferSize, isMonoOutput)) != 0) {
            this.hleReleaseAtracID(atID);
            return result;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleSetHalfwayBufferAndGetID returning atID=0x%X", atID));
        }
        return atID;
    }

    protected int hleSetHalfwayBuffer(int atID, TPointer buffer, int readSize, int bufferSize, boolean isMonoOutput) {
        int codecType;
        if (readSize > bufferSize) {
            return -2140995565;
        }
        AtracID id = this.atracIDs.get(atID);
        if (id.inputBuffer == null && (codecType = sceAtrac3plus.getCodecType(buffer.getAddress())) != id.getAtracCodecType()) {
            return -2140995577;
        }
        int result = id.setData(buffer.getAddress(), readSize, bufferSize, false);
        if (result == 0) {
            if (isMonoOutput && id.getAtracChannels() == 1) {
                id.setAtracOutputChannels(1);
            }
            Modules.ThreadManForUserModule.hleYieldCurrentThread();
        }
        return result;
    }

    protected void hleReleaseAtracID(int atracID) {
        AtracID id = this.atracIDs.remove(atracID);
        if (atracID >= 0) {
            if (id.getAtracCodecType() == 4096) {
                SceUidManager.releaseId(atracID, at3PlusIdPurpose);
            } else if (id.getAtracCodecType() == 4097) {
                SceUidManager.releaseId(atracID, at3IdPurpose);
            }
        }
        id.release();
    }

    public static int getCodecType(int address) {
        int at3magic = Memory.getInstance().read16(address + 20);
        if (at3magic == 624) {
            return 4097;
        }
        if (at3magic == 65534) {
            return 4096;
        }
        return 0;
    }

    public int checkAtracID(int atID) {
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)String.format("Unknown atracID=0x%X", atID));
            throw new SceKernelErrorException(-2140995579);
        }
        return atID;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-772431909, version=150, checkInsideInterrupt=true)
    public int sceAtracStartEntry() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-708670272, version=150, checkInsideInterrupt=true)
    public int sceAtracEndEntry() {
        return 0;
    }

    @HLEFunction(nid=2014283985, version=150, checkInsideInterrupt=true)
    public int sceAtracGetAtracID(int codecType) {
        int atId = this.hleCreateAtracID(codecType);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetAtracID: returning atracID=0x%08X", atId));
        }
        return atId;
    }

    @HLEFunction(nid=1642804213, version=150, checkInsideInterrupt=true)
    public int sceAtracReleaseAtracID(@CheckArgument(value="checkAtracID") int atID) {
        AtracCodec atracCodec = this.atracIDs.get(atID).getAtracCodec();
        if (atracCodec != null) {
            atracCodec.finish();
        }
        this.hleReleaseAtracID(atID);
        return 0;
    }

    @HLEFunction(nid=237663147, version=150, checkInsideInterrupt=true)
    public int sceAtracSetData(@CheckArgument(value="checkAtracID") int atID, TPointer buffer, int bufferSize) {
        return this.hleSetHalfwayBuffer(atID, buffer, bufferSize, bufferSize, false);
    }

    @HLEFunction(nid=1064183477, version=150, checkInsideInterrupt=true)
    public int sceAtracSetHalfwayBuffer(@CheckArgument(value="checkAtracID") int atID, TPointer halfBuffer, int readSize, int halfBufferSize) {
        return this.hleSetHalfwayBuffer(atID, halfBuffer, readSize, halfBufferSize, false);
    }

    @HLEFunction(nid=2048976815, version=150, checkInsideInterrupt=true)
    public int sceAtracSetDataAndGetID(TPointer buffer, int bufferSize) {
        return this.hleSetHalfwayBufferAndGetID(buffer, bufferSize, bufferSize, false);
    }

    @HLEFunction(nid=263075598, version=150, checkInsideInterrupt=true)
    public int sceAtracSetHalfwayBufferAndGetID(TPointer halfBuffer, int readSize, int halfBufferSize) {
        return this.hleSetHalfwayBufferAndGetID(halfBuffer, readSize, halfBufferSize, false);
    }

    @HLEFunction(nid=1787575509, version=150, checkInsideInterrupt=true)
    public int sceAtracDecodeData(@CheckArgument(value="checkAtracID") int atID, @CanBeNull TPointer samplesAddr, @CanBeNull TPointer32 samplesNbrAddr, @CanBeNull TPointer32 outEndAddr, @CanBeNull TPointer32 remainFramesAddr) {
        if (this.atracIDs.get(atID).isSecondBufferNeeded() && !this.atracIDs.get(atID).isSecondBufferSet()) {
            log.warn((Object)String.format("sceAtracDecodeData atracID=0x%X needs second buffer!", atID));
            return -2140995566;
        }
        AtracID id = this.atracIDs.get(atID);
        int result = 0;
        AtracCodec atracCodec = id.getAtracCodec();
        int samples = 0;
        boolean end = true;
        if (id.isForceReloadOfData()) {
            result = -2140995549;
            end = false;
        } else if (atracCodec != null) {
            if (id.getAtracCurrentSample() == 0) {
                atracCodec.setAtracMaxSamples(id.getMaxSamples() >> 1);
            } else {
                atracCodec.setAtracMaxSamples(id.getMaxSamples());
            }
            samples = atracCodec.atracDecodeData(atID, samplesAddr.getAddress(), id.getAtracOutputChannels());
            if (samples < 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sceAtracDecodeData faked samples");
                }
                samples = id.getMaxSamples();
                if (id.getAtracCurrentSample() >= id.getAtracEndSample()) {
                    samples = 0;
                    result = -2140995548;
                    end = true;
                } else {
                    end = false;
                }
                samplesAddr.clear(samples * id.getAtracOutputChannels() * 2);
            } else if (samples == 0) {
                result = -2140995548;
                end = true;
            } else {
                end = atracCodec.getAtracEnd();
            }
        }
        if (samples > 0) {
            int consumedInputBytes = id.getAtracBytesPerFrame();
            id.getInputBuffer().notifyRead(consumedInputBytes);
        }
        if (samples > 0) {
            id.setDecodedSamples(samples);
            if (id.getAtracCurrentSample() >= id.getAtracEndSample()) {
                end = true;
            }
        }
        id.setLastDecodedSamples(samples);
        int remainFrames = end ? -1 : this.getRemainFrames(id, samples);
        samplesNbrAddr.setValue(samples);
        outEndAddr.setValue(end);
        remainFramesAddr.setValue(remainFrames);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracDecodeData returning 0x%08X, samples=%d, end=%b, remainFrames=%d, currentSample=%d/%d, %s", result, samples, end, remainFrames, id.getAtracCurrentSample(), id.getAtracEndSample(), id.toString()));
        }
        if (result == 0) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(2300, false);
        }
        return result;
    }

    @HLEFunction(nid=-1696052825, version=150, checkInsideInterrupt=true)
    public int sceAtracGetRemainFrame(@CheckArgument(value="checkAtracID") int atID, TPointer32 remainFramesAddr) {
        AtracID id = this.atracIDs.get(atID);
        if (id.getInputBuffer() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAtracGetRemainFrame returning 0x%08X (ERROR_ATRAC_NO_DATA)", -2140995568));
            }
            return -2140995568;
        }
        int remainFrames = this.getRemainFrames(id, id.getLastDecodedSamples());
        remainFramesAddr.setValue(remainFrames);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetRemainFrame returning %d, %s", remainFrames, id.toString()));
        }
        return 0;
    }

    @HLEFunction(nid=1562806023, version=150, checkInsideInterrupt=true)
    public int sceAtracGetStreamDataInfo(@CheckArgument(value="checkAtracID") int atID, @CanBeNull TPointer32 writeAddr, @CanBeNull TPointer32 writableBytesAddr, @CanBeNull TPointer32 readOffsetAddr) {
        AtracID id = this.atracIDs.get(atID);
        writeAddr.setValue(id.getInputBuffer().getWriteAddr());
        writableBytesAddr.setValue(id.getInputBuffer().getWriteSize());
        readOffsetAddr.setValue(id.getInputBuffer().getFilePosition());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetStreamDataInfo write=0x%08X, writableBytes=%d, readOffset=%d, %s", writeAddr.getValue(), writableBytesAddr.getValue(), readOffsetAddr.getValue(), id.toString()));
        }
        return 0;
    }

    @HLEFunction(nid=2108887633, version=150, checkInsideInterrupt=true)
    public int sceAtracAddStreamData(@CheckArgument(value="checkAtracID") int atID, int bytesToAdd) {
        AtracID id = this.atracIDs.get(atID);
        id.addStreamData(bytesToAdd);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracAddStreamData: %s", id.toString()));
        }
        return 0;
    }

    @HLEFunction(nid=-2081923424, version=150, checkInsideInterrupt=true)
    public int sceAtracGetSecondBufferInfo(@CheckArgument(value="checkAtracID") int atID, TPointer32 outPosition, TPointer32 outBytes) {
        AtracID id = this.atracIDs.get(atID);
        if (!id.isSecondBufferNeeded()) {
            outPosition.setValue(0);
            outBytes.setValue(0);
            return -2140995550;
        }
        outPosition.setValue(id.getSecondBuffer().getFilePosition());
        outBytes.setValue(id.getSecondBuffer().getWriteSize());
        return 0;
    }

    @HLEFunction(nid=-2084603139, version=150, checkInsideInterrupt=true)
    public int sceAtracSetSecondBuffer(@CheckArgument(value="checkAtracID") int atID, TPointer secondBuffer, int secondBufferSize) {
        AtracID id = this.atracIDs.get(atID);
        id.setData(secondBuffer.getAddress(), secondBufferSize, secondBufferSize, true);
        return 0;
    }

    @HLEFunction(nid=-499238347, version=150, checkInsideInterrupt=true)
    public int sceAtracGetNextDecodePosition(@CheckArgument(value="checkAtracID") int atID, TPointer32 posAddr) {
        AtracID id = this.atracIDs.get(atID);
        if (id.getAtracCurrentSample() >= id.getAtracEndSample()) {
            return -2140995548;
        }
        posAddr.setValue(id.getAtracCurrentSample());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetNextDecodePosition returning pos=%d", posAddr.getValue()));
        }
        return 0;
    }

    @HLEFunction(nid=-1564759874, version=150, checkInsideInterrupt=true)
    public int sceAtracGetSoundSample(@CheckArgument(value="checkAtracID") int atID, @CanBeNull TPointer32 endSampleAddr, @CanBeNull TPointer32 loopStartSampleAddr, @CanBeNull TPointer32 loopEndSampleAddr) {
        AtracID id = this.atracIDs.get(atID);
        int endSample = id.getAtracEndSample();
        int loopStartSample = id.getLoopStartSample();
        int loopEndSample = id.getLoopEndSample();
        if (endSample < 0) {
            endSample = id.getAtracCodec().getAtracEndSample();
        }
        if (endSample < 0) {
            endSample = id.getInputFileSize();
        }
        endSampleAddr.setValue(endSample);
        loopStartSampleAddr.setValue(loopStartSample);
        loopEndSampleAddr.setValue(loopEndSample);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetSoundSample returning endSample=0x%X, loopStartSample=0x%X, loopEndSample=0x%X", endSample, loopStartSample, loopEndSample));
        }
        return 0;
    }

    @HLEFunction(nid=828804010, version=150, checkInsideInterrupt=true)
    public int sceAtracGetChannel(@CheckArgument(value="checkAtracID") int atID, TPointer32 channelAddr) {
        AtracID id = this.atracIDs.get(atID);
        channelAddr.setValue(id.getAtracChannels());
        return 0;
    }

    @HLEFunction(nid=-693767433, version=150, checkInsideInterrupt=true)
    public int sceAtracGetMaxSample(@CheckArgument(value="checkAtracID") int atID, TPointer32 maxSamplesAddr) {
        AtracID id = this.atracIDs.get(atID);
        maxSamplesAddr.setValue(id.getMaxSamples());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetMaxSample returning maxSamples=0x%X", id.getMaxSamples()));
        }
        return 0;
    }

    @HLEFunction(nid=922397691, version=150, checkInsideInterrupt=true)
    public int sceAtracGetNextSample(@CheckArgument(value="checkAtracID") int atID, TPointer32 nbrSamplesAddr) {
        AtracID id = this.atracIDs.get(atID);
        int samples = id.getMaxSamples();
        if (id.getInputBuffer().isEmpty() && id.getAtracCodec().getChannelLength() <= 0) {
            samples = 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetNextSample returning %d samples", samples));
        }
        nbrSamplesAddr.setValue(samples);
        return 0;
    }

    @HLEFunction(nid=-1521180328, version=150, checkInsideInterrupt=true)
    public int sceAtracGetBitrate(@CheckArgument(value="checkAtracID") int atID, TPointer32 bitrateAddr) {
        AtracID id = this.atracIDs.get(atID);
        int bitrate = id.getAtracBytesPerFrame() * 352800 / 1000;
        bitrate = id.getAtracCodecType() == 4096 ? (bitrate >> 11) + 8 & 0xFFFFFFF0 : bitrate + 511 >> 10;
        bitrateAddr.setValue(bitrate);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetBitrate returning bitRate=0x%X", bitrate));
        }
        return 0;
    }

    @HLEFunction(nid=-89851749, version=150, checkInsideInterrupt=true)
    public int sceAtracGetLoopStatus(@CheckArgument(value="checkAtracID") int atID, @CanBeNull TPointer32 loopNbr, @CanBeNull TPointer32 statusAddr) {
        AtracID id = this.atracIDs.get(atID);
        loopNbr.setValue(id.getLoopNum());
        statusAddr.setValue(id.getLoopStatus());
        return 0;
    }

    @HLEFunction(nid=-2038357835, version=150, checkInsideInterrupt=true)
    public int sceAtracSetLoopNum(@CheckArgument(value="checkAtracID") int atID, int loopNbr) {
        AtracID id = this.atracIDs.get(atID);
        if (!id.hasLoop()) {
            return -2140995551;
        }
        id.setLoopNum(loopNbr);
        id.getAtracCodec().setAtracLoopCount(loopNbr);
        return 0;
    }

    @HLEFunction(nid=-901995566, version=150, checkInsideInterrupt=true)
    public int sceAtracGetBufferInfoForReseting(@CheckArgument(value="checkAtracID") int atID, int sample, TPointer32 bufferInfoAddr) {
        AtracID id = this.atracIDs.get(atID);
        return id.getBufferInfoForResetting(sample, bufferInfoAddr);
    }

    @HLEFunction(nid=1682855431, version=150, checkInsideInterrupt=true)
    public int sceAtracResetPlayPosition(@CheckArgument(value="checkAtracID") int atID, int sample, int bytesWrittenFirstBuf, int bytesWrittenSecondBuf) {
        AtracID id = this.atracIDs.get(atID);
        id.setPlayPosition(sample, bytesWrittenFirstBuf, bytesWrittenSecondBuf);
        return 0;
    }

    @HLEFunction(nid=-393251429, version=150, checkInsideInterrupt=true)
    public int sceAtracGetInternalErrorInfo(@CheckArgument(value="checkAtracID") int atID, TPointer32 errorAddr) {
        AtracID id = this.atracIDs.get(atID);
        errorAddr.setValue(id.getInternalErrorInfo());
        return 0;
    }

    private static class EnableConnectorSettingsListener
    extends AbstractBoolSettingsListener {
        private EnableConnectorSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceAtrac3plus.setEnableConnector(value);
        }
    }

    public static class AtracID {
        protected int id;
        protected int codecType;
        protected AtracCodec atracCodec;
        protected SysMemUserForUser.SysMemInfo atracContext;
        protected SysMemUserForUser.SysMemInfo internalBuffer;
        protected int atracBitrate = 64;
        protected int atracChannels = 2;
        protected int atracOutputChannels = 2;
        protected int atracSampleRate = 44100;
        protected int atracBytesPerFrame = 560;
        protected int atracEndSample;
        protected int atracCurrentSample;
        protected int maxSamples;
        protected int atracSampleOffset;
        protected int lastDecodedSamples;
        protected pspFileBuffer inputBuffer;
        protected pspFileBuffer secondBuffer = new pspFileBuffer();
        protected int inputFileSize;
        protected int secondInputFileSize;
        protected boolean isSecondBufferNeeded;
        protected boolean isSecondBufferSet;
        protected int internalErrorInfo;
        protected int inputFileDataOffset;
        protected int loopNum;
        protected int numLoops;
        protected LoopInfo[] loops;
        protected int loopStartBytesWrittenFirstBuf;
        protected int loopStartBytesWrittenSecondBuf;
        protected int currentLoopNum = -1;
        protected boolean forceReloadOfData;
        protected boolean forceAllDataIsOnMemory;
        protected int sourceBufferLength;

        public AtracID(int id, int codecType, AtracCodec atracCodec) {
            this.codecType = codecType;
            this.id = id;
            this.atracCodec = atracCodec;
            if (codecType == 4097 && Modules.sceAtrac3plusModule.atrac3Num < Modules.sceAtrac3plusModule.atrac3MaxIDsCount) {
                ++Modules.sceAtrac3plusModule.atrac3Num;
                this.maxSamples = 1024;
                atracCodec.setAtracMaxSamples(this.maxSamples);
            } else if (codecType == 4096 && Modules.sceAtrac3plusModule.atrac3plusNum < Modules.sceAtrac3plusModule.atrac3plusMaxIDsCount) {
                ++Modules.sceAtrac3plusModule.atrac3plusNum;
                this.maxSamples = 2048;
                atracCodec.setAtracMaxSamples(this.maxSamples);
            } else {
                this.id = -1;
                this.atracCodec = null;
                this.maxSamples = 0;
            }
            this.lastDecodedSamples = this.maxSamples;
        }

        public void release() {
            if (this.id >= 0) {
                if (this.codecType == 4097) {
                    --Modules.sceAtrac3plusModule.atrac3Num;
                } else if (this.codecType == 4096) {
                    --Modules.sceAtrac3plusModule.atrac3plusNum;
                }
            }
            this.releaseContext();
            this.releaseInternalBuffer();
        }

        public void createContext() {
            if (this.atracContext == null) {
                this.atracContext = Modules.SysMemUserForUserModule.malloc(2, String.format("ThreadMan-AtracCtx-%d", this.id), 1, 200, 0);
                if (this.atracContext != null) {
                    Memory mem = Memory.getInstance();
                    int contextAddr = this.atracContext.addr;
                    mem.memset(contextAddr, (byte)0, this.atracContext.size);
                    mem.write32(contextAddr + 140, 0);
                    mem.write8(contextAddr + 149, (byte)2);
                    mem.write8(contextAddr + 151, (byte)1);
                    mem.write16(contextAddr + 154, (short)this.getAtracCodecType());
                    mem.write32(contextAddr + 160, this.getInputBuffer().getFilePosition());
                    mem.write32(contextAddr + 164, this.getInputBuffer().getFilePosition());
                    mem.write32(contextAddr + 188, 0);
                }
            }
        }

        private void releaseContext() {
            if (this.atracContext != null) {
                Modules.SysMemUserForUserModule.free(this.atracContext);
                this.atracContext = null;
            }
        }

        public SysMemUserForUser.SysMemInfo getContext() {
            return this.atracContext;
        }

        public void createInternalBuffer(int size) {
            if (this.internalBuffer == null) {
                this.internalBuffer = Modules.SysMemUserForUserModule.malloc(2, String.format("ThreadMan-AtracBuf-%d", this.id), 0, size, 0);
            }
        }

        private void releaseInternalBuffer() {
            if (this.internalBuffer != null) {
                Modules.SysMemUserForUserModule.free(this.internalBuffer);
                this.internalBuffer = null;
            }
        }

        public SysMemUserForUser.SysMemInfo getInternalBuffer() {
            return this.internalBuffer;
        }

        private int analyzeAtracHeader() {
            Memory mem = Memory.getInstance();
            int result = 0;
            int currentAddr = this.inputBuffer.getReadAddr();
            int bufferSize = this.inputBuffer.getCurrentSize();
            this.atracEndSample = -1;
            this.atracCurrentSample = 0;
            this.isSecondBufferNeeded = false;
            this.numLoops = 0;
            this.inputFileDataOffset = 0;
            if (bufferSize < 12) {
                log.error((Object)String.format("Atrac buffer too small %d", bufferSize));
                return -2140995567;
            }
            int RIFFMagic = Utilities.readUnaligned32(mem, currentAddr);
            int WAVEMagic = Utilities.readUnaligned32(mem, currentAddr + 8);
            if (RIFFMagic != 1179011410 || WAVEMagic != 1163280727) {
                log.error((Object)String.format("Not a RIFF/WAVE format! %08X %08X", RIFFMagic, WAVEMagic));
                return -2140995578;
            }
            this.inputFileSize = Utilities.readUnaligned32(mem, currentAddr + 4) + 8;
            currentAddr += 12;
            bufferSize -= 12;
            boolean foundData = false;
            while (bufferSize >= 8 && !foundData) {
                int chunkMagic = Utilities.readUnaligned32(mem, currentAddr);
                int chunkSize = Utilities.readUnaligned32(mem, currentAddr + 4);
                currentAddr += 8;
                bufferSize -= 8;
                if (chunkMagic == 1635017060) {
                    foundData = true;
                    this.inputFileDataOffset = currentAddr - this.inputBuffer.getReadAddr();
                }
                if (chunkSize > bufferSize) break;
                switch (chunkMagic) {
                    case 544501094: {
                        if (chunkSize < 16) break;
                        int compressionCode = mem.read16(currentAddr);
                        this.atracChannels = mem.read16(currentAddr + 2);
                        this.atracSampleRate = Utilities.readUnaligned32(mem, currentAddr + 4);
                        this.atracBitrate = Utilities.readUnaligned32(mem, currentAddr + 8);
                        this.atracBytesPerFrame = mem.read16(currentAddr + 12);
                        int hiBytesPerSample = mem.read16(currentAddr + 14);
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)String.format("WAVE format: magic=0x%08X('%s'), chunkSize=%d, compressionCode=0x%04X, channels=%d, outputChannels=%d, sampleRate=%d, bitrate=%d, bytesPerFrame=%d, hiBytesPerSample=%d", chunkMagic, sceAtrac3plus.getStringFromInt32(chunkMagic), chunkSize, compressionCode, this.atracChannels, this.atracOutputChannels, this.atracSampleRate, this.atracBitrate, this.atracBytesPerFrame, hiBytesPerSample));
                        StringBuilder restChunk = new StringBuilder();
                        for (int i = 16; i < chunkSize; ++i) {
                            int b = mem.read8(currentAddr + i);
                            restChunk.append(String.format(" %02X", b));
                        }
                        if (restChunk.length() <= 0) break;
                        log.debug((Object)String.format("Additional chunk data:%s", restChunk));
                        break;
                    }
                    case 1952670054: {
                        if (chunkSize < 8) break;
                        this.atracEndSample = Utilities.readUnaligned32(mem, currentAddr);
                        this.atracSampleOffset = Utilities.readUnaligned32(mem, currentAddr + 4);
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)String.format("FACT Chunk: endSample=%d, sampleOffset=%d", this.atracEndSample, this.atracSampleOffset));
                        break;
                    }
                    case 1819307379: {
                        int checkNumLoops;
                        if (chunkSize < 36 || chunkSize < 36 + (checkNumLoops = Utilities.readUnaligned32(mem, currentAddr + 28)) * 24) break;
                        this.numLoops = checkNumLoops;
                        this.loops = new LoopInfo[this.numLoops];
                        int loopInfoAddr = currentAddr + 36;
                        for (int i = 0; i < this.numLoops; ++i) {
                            LoopInfo loop;
                            this.loops[i] = loop = new LoopInfo();
                            loop.cuePointID = Utilities.readUnaligned32(mem, loopInfoAddr);
                            loop.type = Utilities.readUnaligned32(mem, loopInfoAddr + 4);
                            loop.startSample = Utilities.readUnaligned32(mem, loopInfoAddr + 8) - this.atracSampleOffset;
                            loop.endSample = Utilities.readUnaligned32(mem, loopInfoAddr + 12) - this.atracSampleOffset;
                            loop.fraction = Utilities.readUnaligned32(mem, loopInfoAddr + 16);
                            loop.playCount = Utilities.readUnaligned32(mem, loopInfoAddr + 20);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("Loop #%d: %s", i, loop.toString()));
                            }
                            loopInfoAddr += 24;
                        }
                        break;
                    }
                }
                currentAddr += chunkSize;
                bufferSize -= chunkSize;
            }
            if (this.loops != null) {
                for (LoopInfo loop : this.loops) {
                    if (loop.endSample <= this.atracEndSample) continue;
                    loop.endSample = this.atracEndSample;
                }
            }
            return result;
        }

        public int getAtracId() {
            return this.id;
        }

        public int getAtracCodecType() {
            return this.codecType;
        }

        public AtracCodec getAtracCodec() {
            return this.atracCodec;
        }

        public int getAtracBitrate() {
            return this.atracBitrate;
        }

        public int getAtracChannels() {
            return this.atracChannels;
        }

        public void setAtracChannels(int atracChannels) {
            this.atracChannels = atracChannels;
        }

        public int getAtracSampleRate() {
            return this.atracSampleRate;
        }

        public int getAtracEndSample() {
            return this.atracEndSample;
        }

        public int getAtracCurrentSample() {
            return this.atracCurrentSample;
        }

        public int getAtracBytesPerFrame() {
            return this.atracBytesPerFrame;
        }

        public void setAtracCurrentSample(int sample) {
            this.atracCurrentSample = sample;
        }

        public int getLoopNum() {
            if (!this.hasLoop()) {
                return 0;
            }
            return this.loopNum;
        }

        public void setLoopNum(int num) {
            this.loopNum = num;
        }

        public int getMaxSamples() {
            return this.maxSamples;
        }

        public pspFileBuffer getInputBuffer() {
            return this.inputBuffer;
        }

        public pspFileBuffer getSecondBuffer() {
            return this.secondBuffer;
        }

        public int getInputFileSize() {
            return this.inputFileSize;
        }

        public void setInputFileSize(int bytes) {
            this.inputFileSize = bytes;
        }

        public int getSecondInputFileSize() {
            return this.secondInputFileSize;
        }

        public boolean isSecondBufferNeeded() {
            return this.isSecondBufferNeeded;
        }

        public boolean isSecondBufferSet() {
            return this.isSecondBufferSet;
        }

        public int getInternalErrorInfo() {
            return this.internalErrorInfo;
        }

        public int setData(int buffer, int readSize, int bufferSize, boolean isSecondBuf) {
            int result = 0;
            if (bufferSize < 0) {
                bufferSize = MemoryMap.SIZE_RAM;
            }
            if (readSize < 0) {
                readSize = MemoryMap.SIZE_RAM;
            }
            Emulator.getClock().pause();
            if (isSecondBuf) {
                this.secondBuffer = new pspFileBuffer(buffer, bufferSize, readSize);
                this.isSecondBufferSet = true;
            } else {
                this.inputBuffer = new pspFileBuffer(buffer, bufferSize, readSize);
                this.inputFileSize = readSize;
                this.secondInputFileSize = 256;
                this.forceAllDataIsOnMemory = false;
                this.forceReloadOfData = false;
                result = this.analyzeAtracHeader();
                if (result != 0) {
                    return result;
                }
                this.getInputBuffer().setFileMaxSize(this.inputFileSize);
                log.info((Object)String.format("hleAtracSetData atID=0x%X, buffer=0x%08X, readSize=0x%X, bufferSize=0x%X, fileSize=0x%X", this.getAtracId(), buffer, readSize, bufferSize, this.inputFileSize));
                if (this.getAtracCodec() == null) {
                    log.warn((Object)String.format("hleAtracSetData atID=0x%X is invalid", this.getAtracId()));
                    return -1;
                }
                if (readSize > this.inputFileSize || bufferSize > this.inputFileSize) {
                    readSize = Math.min(readSize, this.inputFileSize);
                    bufferSize = Math.min(bufferSize, this.inputFileSize);
                    this.inputBuffer = new pspFileBuffer(buffer, bufferSize, readSize);
                }
                this.inputBuffer.notifyRead(this.inputFileDataOffset);
                int atracHash = Hash.getHashCode(0, buffer, Math.min(readSize, 512));
                this.getAtracCodec().atracSetData(this.getAtracId(), this.getAtracCodecType(), buffer, readSize, this.inputFileSize, atracHash);
                if (this.secondBuffer.getAddr() == 0) {
                    this.secondBuffer.setAddr(buffer);
                }
            }
            Emulator.getClock().resume();
            return result;
        }

        protected void addStreamData(int length) {
            this.addStreamData(this.inputBuffer.getWriteAddr(), length);
        }

        public void addStreamData(int address, int length) {
            if (length > 0) {
                this.inputBuffer.notifyWrite(length);
                this.forceReloadOfData = false;
                this.getAtracCodec().atracAddStreamData(address, length);
            }
        }

        public int getRemainFrames() {
            if (this.atracCurrentSample >= this.atracEndSample) {
                return -1;
            }
            if (this.inputBuffer.isFileEnd() && this.atracCurrentSample > this.getLoopEndSample()) {
                return -1;
            }
            if (this.forceReloadOfData) {
                return 0;
            }
            if (this.forceAllDataIsOnMemory) {
                return -1;
            }
            if (this.inputBuffer.getWriteSize() <= 0) {
                return this.inputBuffer.getMaxSize() / this.atracBytesPerFrame;
            }
            int remainFrames = this.inputBuffer.getCurrentSize() / this.atracBytesPerFrame;
            return remainFrames;
        }

        public int getBufferInfoForResetting(int sample, TPointer32 bufferInfoAddr) {
            if (sample > this.getAtracEndSample()) {
                return -2140995563;
            }
            int inputFileSampleOffset = this.inputBuffer.isFileEnd() ? 0 : this.inputFileDataOffset + sample / this.maxSamples * this.atracBytesPerFrame;
            int resetWritableBytes = this.inputBuffer.isFileEnd() ? 0 : this.inputBuffer.getMaxSize();
            int resetNeededBytes = this.inputBuffer.isFileEnd() ? 0 : this.atracBytesPerFrame * 2;
            bufferInfoAddr.setValue(0, this.inputBuffer.getAddr());
            bufferInfoAddr.setValue(4, resetWritableBytes);
            bufferInfoAddr.setValue(8, resetNeededBytes);
            bufferInfoAddr.setValue(12, inputFileSampleOffset);
            bufferInfoAddr.setValue(16, this.secondBuffer.getAddr());
            bufferInfoAddr.setValue(20, this.secondBuffer.getWriteSize());
            bufferInfoAddr.setValue(24, this.secondBuffer.getWriteSize());
            bufferInfoAddr.setValue(28, this.secondBuffer.getFilePosition());
            return 0;
        }

        public void setDecodedSamples(int samples) {
            int currentSample = this.getAtracCurrentSample();
            int nextCurrentSample = currentSample + samples;
            for (int i = 0; i < this.numLoops; ++i) {
                LoopInfo loop = this.loops[i];
                if (currentSample <= loop.startSample && loop.startSample < nextCurrentSample) {
                    this.loopStartBytesWrittenFirstBuf = this.inputBuffer.getFilePosition();
                    this.loopStartBytesWrittenSecondBuf = this.secondBuffer.getFilePosition();
                    this.currentLoopNum = i;
                    break;
                }
                if (currentSample > loop.endSample || loop.endSample > nextCurrentSample || this.currentLoopNum != i) continue;
                if (this.loopNum == 0) {
                    this.currentLoopNum = -1;
                    continue;
                }
                log.info((Object)String.format("Replaying atrac loop atracID=%d, loopStart=%d, loopEnd=%d", this.id, loop.startSample, loop.endSample));
                this.setPlayPosition(loop.startSample, this.loopStartBytesWrittenFirstBuf, this.loopStartBytesWrittenSecondBuf);
                nextCurrentSample = loop.startSample;
                if (this.loopNum <= 0) break;
                --this.loopNum;
                break;
            }
            this.setAtracCurrentSample(nextCurrentSample);
        }

        public void setPlayPosition(int sample, int bytesWrittenFirstBuf, int bytesWrittenSecondBuf) {
            if (sample != this.getAtracCurrentSample()) {
                this.setAtracCurrentSample(sample);
                this.getAtracCodec().atracResetPlayPosition(sample);
                int position = this.getAtracCodec().getChannelPosition();
                this.getInputBuffer().reset(0, Utilities.max(position, 0));
                if (this.getInputBuffer().getMaxSize() < this.getInputFileSize() && !this.getAtracCodec().isExternalAudio()) {
                    this.getAtracCodec().resetChannel();
                    this.forceReloadOfData = true;
                } else {
                    this.forceAllDataIsOnMemory = true;
                }
            }
        }

        public boolean hasLoop() {
            return this.numLoops > 0;
        }

        public int getLoopStatus() {
            if (!this.hasLoop()) {
                return 0;
            }
            return 1;
        }

        public int getLoopStartSample() {
            if (!this.hasLoop()) {
                return -1;
            }
            return this.loops[0].startSample;
        }

        public int getLoopEndSample() {
            if (!this.hasLoop()) {
                return -1;
            }
            return this.loops[0].endSample;
        }

        public boolean isForceReloadOfData() {
            return this.forceReloadOfData;
        }

        public void setContextDecodeResult(int result, int requestedSize) {
            if (this.getContext() != null) {
                Memory mem = Memory.getInstance();
                int contextAddr = this.getContext().addr;
                mem.write32(contextAddr + 188, result);
                int readSize = mem.read32(contextAddr + 160);
                mem.write32(contextAddr + 164, readSize + requestedSize);
            }
        }

        public String toString() {
            return String.format("AtracID[id=%d, inputBuffer=%s, channels=%d, outputChannels=%d]", this.id, this.inputBuffer, this.getAtracChannels(), this.getAtracOutputChannels());
        }

        public int getSourceBufferLength() {
            return this.sourceBufferLength;
        }

        public void setSourceBufferLength(int sourceBufferLength) {
            this.sourceBufferLength = sourceBufferLength;
        }

        public int getLastDecodedSamples() {
            return this.lastDecodedSamples;
        }

        public void setLastDecodedSamples(int lastDecodedSamples) {
            this.lastDecodedSamples = lastDecodedSamples;
        }

        public int getAtracOutputChannels() {
            return this.atracOutputChannels;
        }

        public void setAtracOutputChannels(int atracOutputChannels) {
            this.atracOutputChannels = atracOutputChannels;
        }
    }

    protected static class LoopInfo {
        protected int cuePointID;
        protected int type;
        protected int startSample;
        protected int endSample;
        protected int fraction;
        protected int playCount;

        protected LoopInfo() {
        }

        public String toString() {
            return String.format("LoopInfo[cuePointID %d, type %d, startSample %d, endSample %d, fraction %d, playCount %d]", this.cuePointID, this.type, this.startSample, this.endSample, this.fraction, this.playCount);
        }
    }
}

