/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.HLE.kernel.types.pspFileBuffer;

public class SceMpegRingbuffer
extends pspAbstractMemoryMappedStructure {
    private static final int ringbufferPacketSize = 2048;
    private int packets;
    private int packetsRead;
    private int packetsWritten;
    private int packetsInRingbuffer;
    private int packetSize;
    private int data;
    private int callbackAddr;
    private int callbackArgs;
    private int dataUpperBound;
    private int semaID;
    private int mpeg;
    private pspFileBuffer buffer;

    public SceMpegRingbuffer(int packets, int data, int size, int callbackAddr, int callbackArgs) {
        this.packets = packets;
        this.packetSize = 2048;
        this.data = data;
        this.callbackAddr = callbackAddr;
        this.callbackArgs = callbackArgs;
        this.dataUpperBound = data + packets * 2048;
        this.semaID = -1;
        this.mpeg = 0;
        this.initBuffer();
        if (this.dataUpperBound > data + size) {
            this.dataUpperBound = data + size;
            Modules.log.warn((Object)("SceMpegRingbuffer clamping dataUpperBound to " + this.dataUpperBound));
        }
        this.reset();
    }

    private SceMpegRingbuffer() {
    }

    private void initBuffer() {
        this.buffer = new pspFileBuffer(this.data, this.dataUpperBound - this.data);
        this.buffer.setFileMaxSize(Integer.MAX_VALUE);
    }

    public static SceMpegRingbuffer fromMem(TPointer address) {
        SceMpegRingbuffer ringbuffer = new SceMpegRingbuffer();
        ringbuffer.read(address);
        ringbuffer.initBuffer();
        return ringbuffer;
    }

    public void reset() {
        this.packetsRead = 0;
        this.packetsWritten = 0;
        this.packetsInRingbuffer = 0;
        this.buffer.reset(0, 0);
    }

    @Override
    protected void read() {
        this.packets = this.read32();
        this.packetsRead = this.read32();
        this.packetsWritten = this.read32();
        this.packetsInRingbuffer = this.read32();
        this.packetSize = this.read32();
        this.data = this.read32();
        this.callbackAddr = this.read32();
        this.callbackArgs = this.read32();
        this.dataUpperBound = this.read32();
        this.semaID = this.read32();
        this.mpeg = this.read32();
    }

    @Override
    protected void write() {
        this.write32(this.packets);
        this.write32(this.packetsRead);
        this.write32(this.packetsWritten);
        this.write32(this.packetsInRingbuffer);
        this.write32(this.packetSize);
        this.write32(this.data);
        this.write32(this.callbackAddr);
        this.write32(this.callbackArgs);
        this.write32(this.dataUpperBound);
        this.write32(this.semaID);
        this.write32(this.mpeg);
    }

    public int getFreePackets() {
        return this.packets - this.packetsInRingbuffer;
    }

    public void addPackets(int packetsAdded) {
        this.buffer.notifyWrite(packetsAdded * this.packetSize);
        this.packetsRead += packetsAdded;
        this.packetsWritten += packetsAdded;
        this.packetsInRingbuffer += packetsAdded;
    }

    public void consumeAllPackets() {
        this.buffer.notifyReadAll();
        this.packetsInRingbuffer = 0;
    }

    public int getPacketsInRingbuffer() {
        return this.packetsInRingbuffer;
    }

    public boolean isEmpty() {
        return this.getPacketsInRingbuffer() == 0;
    }

    public void consumePackets(int consumedPackets) {
        if (consumedPackets > 0) {
            this.buffer.notifyRead(consumedPackets * this.packetSize);
            this.packetsInRingbuffer -= consumedPackets;
            if (this.packetsInRingbuffer < 0) {
                this.packetsInRingbuffer = 0;
            }
        }
    }

    public int getReadPackets() {
        return this.packetsRead;
    }

    public boolean hasReadPackets() {
        return this.packetsRead != 0;
    }

    public void setReadPackets(int packetsRead) {
        this.packetsRead = packetsRead;
    }

    public int getProcessedPackets() {
        return this.getReadPackets() - this.getPacketsInRingbuffer();
    }

    public int getTotalPackets() {
        return this.packets;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public int getBaseDataAddr() {
        return this.data;
    }

    public int getReadDataAddr() {
        return this.buffer.getReadAddr();
    }

    public int getReadSequentialPackets() {
        return this.buffer.getReadSize() / this.packetSize;
    }

    public int getPutDataAddr() {
        return this.buffer.getWriteAddr();
    }

    public int getPutSequentialPackets() {
        return this.buffer.getWriteSize() / this.packetSize;
    }

    public void setFileMaxSize(int fileMaxSize) {
        this.buffer.setFileMaxSize(fileMaxSize);
    }

    public int getTmpAddress(int length) {
        return this.dataUpperBound - length;
    }

    public void setMpeg(int mpeg) {
        this.mpeg = mpeg;
    }

    public int getUpperDataAddr() {
        return this.dataUpperBound;
    }

    public int getCallbackAddr() {
        return this.callbackAddr;
    }

    public int getCallbackArgs() {
        return this.callbackArgs;
    }

    @Override
    public int sizeof() {
        return 44;
    }

    @Override
    public String toString() {
        return String.format("SceMpegRingbuffer(packets=0x%X, packetsRead=0x%X, packetsWritten=0x%X, packetsFree=0x%X, packetSize=0x%X, buffer=%s)", this.packets, this.packetsRead, this.packetsWritten, this.getFreePackets(), this.packetSize, this.buffer);
    }
}

