/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.interrupts.AbstractAllegrexInterruptHandler;
import jpcsp.HLE.kernel.types.interrupts.AbstractInterruptHandler;
import jpcsp.HLE.kernel.types.interrupts.AfterSubIntrAction;
import jpcsp.HLE.kernel.types.interrupts.InterruptState;
import jpcsp.HLE.kernel.types.interrupts.IntrHandler;
import jpcsp.HLE.kernel.types.interrupts.SubIntrHandler;
import jpcsp.HLE.kernel.types.interrupts.VBlankInterruptHandler;
import jpcsp.hardware.Interrupts;
import jpcsp.scheduler.Scheduler;
import org.apache.log4j.Logger;

public class IntrManager {
    protected static Logger log = Modules.getLogger("ThreadManForUser");
    public static final int PSP_GPIO_INTR = 4;
    public static final int PSP_ATA_INTR = 5;
    public static final int PSP_UMD_INTR = 6;
    public static final int PSP_MSCM0_INTR = 7;
    public static final int PSP_WLAN_INTR = 8;
    public static final int PSP_AUDIO_INTR = 10;
    public static final int PSP_I2C_INTR = 12;
    public static final int PSP_SIRS_INTR = 14;
    public static final int PSP_SYSTIMER0_INTR = 15;
    public static final int PSP_SYSTIMER1_INTR = 16;
    public static final int PSP_SYSTIMER2_INTR = 17;
    public static final int PSP_SYSTIMER3_INTR = 18;
    public static final int PSP_THREAD0_INTR = 19;
    public static final int PSP_NAND_INTR = 20;
    public static final int PSP_DMACPLUS_INTR = 21;
    public static final int PSP_DMA0_INTR = 22;
    public static final int PSP_DMA1_INTR = 23;
    public static final int PSP_MEMLMD_INTR = 24;
    public static final int PSP_GE_INTR = 25;
    public static final int PSP_VBLANK_INTR = 30;
    public static final int PSP_MECODEC_INTR = 31;
    public static final int PSP_HPREMOTE_INTR = 36;
    public static final int PSP_MSCM1_INTR = 60;
    public static final int PSP_MSCM2_INTR = 61;
    public static final int PSP_THREAD1_INTR = 65;
    public static final int PSP_INTERRUPT_INTR = 66;
    public static final int PSP_NUMBER_INTERRUPTS = 67;
    private static String[] PSP_INTERRUPT_NAMES;
    public static final int VBLANK_SCHEDULE_MICROS = 16667;
    protected static IntrManager instance;
    private Vector<LinkedList<AbstractInterruptHandler>> interrupts;
    protected IntrHandler[] intrHandlers;
    protected boolean insideInterrupt;
    protected List<AbstractAllegrexInterruptHandler> allegrexInterruptHandlers;
    protected List<AbstractInterruptHandler> deferredInterrupts;
    private VBlankInterruptHandler vblankInterruptHandler = new VBlankInterruptHandler();

    public static IntrManager getInstance() {
        if (instance == null) {
            instance = new IntrManager();
        }
        return instance;
    }

    private IntrManager() {
    }

    public void reset() {
        this.stop();
        this.installDefaultInterrupts();
    }

    public void stop() {
        this.interrupts = new Vector(67);
        this.interrupts.setSize(67);
        this.intrHandlers = new IntrHandler[67];
        this.allegrexInterruptHandlers = new LinkedList<AbstractAllegrexInterruptHandler>();
        this.deferredInterrupts = new LinkedList<AbstractInterruptHandler>();
    }

    public static String getInterruptName(int interruptNumber) {
        if (PSP_INTERRUPT_NAMES == null) {
            PSP_INTERRUPT_NAMES = new String[67];
            IntrManager.PSP_INTERRUPT_NAMES[4] = "GPIO";
            IntrManager.PSP_INTERRUPT_NAMES[5] = "ATA";
            IntrManager.PSP_INTERRUPT_NAMES[6] = "UMD";
            IntrManager.PSP_INTERRUPT_NAMES[7] = "MSCM0";
            IntrManager.PSP_INTERRUPT_NAMES[8] = "WLAN";
            IntrManager.PSP_INTERRUPT_NAMES[10] = "AUDIO";
            IntrManager.PSP_INTERRUPT_NAMES[12] = "I2C";
            IntrManager.PSP_INTERRUPT_NAMES[14] = "SIRS";
            IntrManager.PSP_INTERRUPT_NAMES[15] = "SYSTIMER0";
            IntrManager.PSP_INTERRUPT_NAMES[16] = "SYSTIMER1";
            IntrManager.PSP_INTERRUPT_NAMES[17] = "SYSTIMER2";
            IntrManager.PSP_INTERRUPT_NAMES[18] = "SYSTIMER3";
            IntrManager.PSP_INTERRUPT_NAMES[19] = "THREAD0";
            IntrManager.PSP_INTERRUPT_NAMES[20] = "NAND";
            IntrManager.PSP_INTERRUPT_NAMES[21] = "DMACPLUS";
            IntrManager.PSP_INTERRUPT_NAMES[22] = "DMA0";
            IntrManager.PSP_INTERRUPT_NAMES[23] = "DMA1";
            IntrManager.PSP_INTERRUPT_NAMES[24] = "MEMLMD";
            IntrManager.PSP_INTERRUPT_NAMES[25] = "GE";
            IntrManager.PSP_INTERRUPT_NAMES[30] = "VBLANK";
            IntrManager.PSP_INTERRUPT_NAMES[31] = "MECODEC";
            IntrManager.PSP_INTERRUPT_NAMES[36] = "HPREMOTE";
            IntrManager.PSP_INTERRUPT_NAMES[60] = "MSCM1";
            IntrManager.PSP_INTERRUPT_NAMES[61] = "MSCM2";
            IntrManager.PSP_INTERRUPT_NAMES[65] = "THREAD1";
            IntrManager.PSP_INTERRUPT_NAMES[66] = "INTERRUPT";
        }
        String name = null;
        if (interruptNumber >= 0 && interruptNumber < PSP_INTERRUPT_NAMES.length) {
            name = PSP_INTERRUPT_NAMES[interruptNumber];
        }
        if (name == null) {
            name = String.format("INTERRUPT_%X", interruptNumber);
        }
        return name;
    }

    private void installDefaultInterrupts() {
        Scheduler scheduler = Emulator.getScheduler();
        scheduler.addAction(Scheduler.getNow() + 16667L, this.vblankInterruptHandler);
    }

    public void addDeferredInterrupt(AbstractInterruptHandler interruptHandler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("addDeferredInterrupt insideInterrupt=%b, interruptsEnabled=%b", this.isInsideInterrupt(), Interrupts.isInterruptsEnabled()));
        }
        this.deferredInterrupts.add(interruptHandler);
    }

    public boolean canExecuteInterruptNow() {
        return !this.isInsideInterrupt() && Interrupts.isInterruptsEnabled();
    }

    public void onInterruptsEnabled() {
        if (!this.deferredInterrupts.isEmpty() && this.canExecuteInterruptNow()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Executing deferred interrupts");
            }
            LinkedList<AbstractInterruptHandler> copyDeferredInterrupts = new LinkedList<AbstractInterruptHandler>(this.deferredInterrupts);
            this.deferredInterrupts.clear();
            this.executeInterrupts(copyDeferredInterrupts, null, null);
        }
    }

    public LinkedList<AbstractInterruptHandler> getInterruptHandlers(int intrNumber) {
        if (intrNumber < 0 || intrNumber >= 67) {
            return null;
        }
        return this.interrupts.get(intrNumber);
    }

    public void addInterruptHandler(int interruptNumber, AbstractInterruptHandler interruptHandler) {
        if (interruptNumber < 0 || interruptNumber >= 67) {
            return;
        }
        LinkedList<AbstractInterruptHandler> interruptHandlers = this.interrupts.get(interruptNumber);
        if (interruptHandlers == null) {
            interruptHandlers = new LinkedList();
            this.interrupts.set(interruptNumber, interruptHandlers);
        }
        interruptHandlers.add(interruptHandler);
    }

    public boolean removeInterruptHandler(int intrNumber, AbstractInterruptHandler interruptHandler) {
        if (intrNumber < 0 || intrNumber >= 67) {
            return false;
        }
        LinkedList<AbstractInterruptHandler> interruptHandlers = this.interrupts.get(intrNumber);
        if (interruptHandlers == null) {
            return false;
        }
        return interruptHandlers.remove(interruptHandler);
    }

    protected void onEndOfInterrupt() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"End of Interrupt");
        }
        this.allegrexInterruptHandlers.clear();
        Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        this.onInterruptsEnabled();
    }

    public void pushAllegrexInterruptHandler(AbstractAllegrexInterruptHandler allegrexInterruptHandler) {
        this.allegrexInterruptHandlers.add(allegrexInterruptHandler);
    }

    public void continueCallAllegrexInterruptHandler(InterruptState interruptState, Iterator<AbstractAllegrexInterruptHandler> allegrexInterruptHandlersIterator, IAction continueAction) {
        boolean somethingExecuted = false;
        while (allegrexInterruptHandlersIterator != null && allegrexInterruptHandlersIterator.hasNext()) {
            AbstractAllegrexInterruptHandler allegrexInterruptHandler = allegrexInterruptHandlersIterator.next();
            if (allegrexInterruptHandler != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Calling InterruptHandler " + allegrexInterruptHandler.toString()));
                }
                allegrexInterruptHandler.copyArgumentsToCpu(Emulator.getProcessor().cpu);
                Modules.ThreadManForUserModule.callAddress(allegrexInterruptHandler.getAddress(), continueAction, true);
                somethingExecuted = true;
            }
            if (!somethingExecuted) continue;
        }
        if (!somethingExecuted) {
            this.setInsideInterrupt(interruptState.restore(Emulator.getProcessor().cpu));
            IAction afterInterruptAction = interruptState.getAfterInterruptAction();
            if (afterInterruptAction != null) {
                afterInterruptAction.execute();
            }
            this.onEndOfInterrupt();
        }
    }

    protected void executeInterrupts(List<AbstractInterruptHandler> interruptHandlers, IAction afterInterruptAction, IAction afterHandlerAction) {
        if (interruptHandlers != null) {
            for (AbstractInterruptHandler interruptHandler : interruptHandlers) {
                if (interruptHandler == null) continue;
                interruptHandler.execute();
            }
        }
        if (this.allegrexInterruptHandlers.isEmpty()) {
            if (afterInterruptAction != null) {
                afterInterruptAction.execute();
            }
            this.onEndOfInterrupt();
        } else {
            InterruptState interruptState = new InterruptState();
            interruptState.save(this.insideInterrupt, Emulator.getProcessor().cpu, afterInterruptAction, afterHandlerAction);
            this.setInsideInterrupt(true);
            Iterator<AbstractAllegrexInterruptHandler> allegrexInterruptHandlersIterator = this.allegrexInterruptHandlers.iterator();
            AfterSubIntrAction continueAction = new AfterSubIntrAction(this, interruptState, allegrexInterruptHandlersIterator);
            this.continueCallAllegrexInterruptHandler(interruptState, allegrexInterruptHandlersIterator, continueAction);
        }
    }

    public void triggerInterrupt(int interruptNumber, IAction afterInterruptAction, IAction afterHandlerAction) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Triggering Interrupt %s(0x%X)", IntrManager.getInterruptName(interruptNumber), interruptNumber));
        }
        this.executeInterrupts(this.getInterruptHandlers(interruptNumber), afterInterruptAction, afterHandlerAction);
    }

    public void triggerInterrupt(int interruptNumber, IAction afterInterruptAction, IAction afterHandlerAction, AbstractAllegrexInterruptHandler allegrexInterruptHandler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Triggering Interrupt %s(0x%X) at 0x%08X", IntrManager.getInterruptName(interruptNumber), interruptNumber, allegrexInterruptHandler.getAddress()));
        }
        this.allegrexInterruptHandlers.add(allegrexInterruptHandler);
        this.executeInterrupts(null, afterInterruptAction, afterHandlerAction);
    }

    public boolean isInsideInterrupt() {
        return this.insideInterrupt;
    }

    public void setInsideInterrupt(boolean insideInterrupt) {
        this.insideInterrupt = insideInterrupt;
    }

    public void addVBlankAction(IAction action) {
        this.vblankInterruptHandler.addVBlankAction(action);
    }

    public boolean removeVBlankAction(IAction action) {
        return this.vblankInterruptHandler.removeVBlankAction(action);
    }

    public void addVBlankActionOnce(IAction action) {
        this.vblankInterruptHandler.addVBlankActionOnce(action);
    }

    public boolean removeVBlankActionOnce(IAction action) {
        return this.vblankInterruptHandler.removeVBlankActionOnce(action);
    }

    public int sceKernelRegisterSubIntrHandler(int intrNumber, int subIntrNumber, int handlerAddress, int handlerArgument) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelRegisterSubIntrHandler(%d, %d, 0x%08X, 0x%08X)", intrNumber, subIntrNumber, handlerAddress, handlerArgument));
        }
        if (intrNumber < 0 || intrNumber >= 67 || subIntrNumber < 0) {
            return -2147352475;
        }
        if (this.intrHandlers[intrNumber] == null) {
            IntrHandler intrHandler;
            this.intrHandlers[intrNumber] = intrHandler = new IntrHandler();
            this.addInterruptHandler(intrNumber, intrHandler);
        } else if (this.intrHandlers[intrNumber].getSubIntrHandler(subIntrNumber) != null) {
            return -2147352473;
        }
        SubIntrHandler subIntrHandler = new SubIntrHandler(handlerAddress, subIntrNumber, handlerArgument);
        subIntrHandler.setEnabled(false);
        this.intrHandlers[intrNumber].addSubIntrHandler(subIntrNumber, subIntrHandler);
        return 0;
    }

    public int sceKernelReleaseSubIntrHandler(int intrNumber, int subIntrNumber) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelReleaseSubIntrHandler(%d, %d)", intrNumber, subIntrNumber));
        }
        if (intrNumber < 0 || intrNumber >= 67 || subIntrNumber < 0) {
            return -2147352475;
        }
        if (this.intrHandlers[intrNumber] == null) {
            return -2147352472;
        }
        if (!this.intrHandlers[intrNumber].removeSubIntrHandler(subIntrNumber)) {
            return -2147352472;
        }
        return 0;
    }

    protected int hleKernelEnableDisableSubIntr(int intrNumber, int subIntrNumber, boolean enabled) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernel%sSubIntr(%d, %d)", enabled ? "Enable" : "Disable", intrNumber, subIntrNumber));
        }
        if (intrNumber < 0 || intrNumber >= 67) {
            return -1;
        }
        if (this.intrHandlers[intrNumber] == null) {
            return -1;
        }
        SubIntrHandler subIntrHandler = this.intrHandlers[intrNumber].getSubIntrHandler(subIntrNumber);
        if (subIntrHandler == null) {
            return -1;
        }
        subIntrHandler.setEnabled(enabled);
        return 0;
    }

    public int sceKernelEnableSubIntr(int intrNumber, int subIntrNumber) {
        return this.hleKernelEnableDisableSubIntr(intrNumber, subIntrNumber, true);
    }

    public int sceKernelDisableSubIntr(int intrNumber, int subIntrNumber) {
        return this.hleKernelEnableDisableSubIntr(intrNumber, subIntrNumber, false);
    }

    static {
        instance = null;
    }
}

