/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS;

import java.util.HashMap;
import jpcsp.HLE.VFS.ITmpVirtualFileSystem;
import jpcsp.HLE.VFS.IVirtualFileSystem;

public class VirtualFileSystemManager {
    protected HashMap<String, IVirtualFileSystem> virtualFileSystems = new HashMap();
    protected ITmpVirtualFileSystem tmpVfs;

    public void register(String name, IVirtualFileSystem vfs) {
        name = name.toLowerCase();
        this.virtualFileSystems.put(name, vfs);
    }

    public void unregister(String name) {
        name = name.toLowerCase();
        this.virtualFileSystems.remove(name);
    }

    public void register(ITmpVirtualFileSystem tmpVfs) {
        this.tmpVfs = tmpVfs;
    }

    public IVirtualFileSystem getVirtualFileSystem(String absoluteFileName, StringBuilder localFileName) {
        int colon = absoluteFileName.indexOf(58);
        if (colon < 0) {
            return null;
        }
        String name = absoluteFileName.substring(0, colon);
        name = name.toLowerCase();
        if (localFileName != null) {
            localFileName.setLength(0);
            localFileName.append(absoluteFileName.substring(colon + 1));
            this.normalizeLocalFileName(localFileName);
        }
        return this.virtualFileSystems.get(name);
    }

    public ITmpVirtualFileSystem getTmpVirtualFileSystem() {
        return this.tmpVfs;
    }

    private void normalizeLocalFileName(StringBuilder localFileName) {
        int dotIndex;
        int parentIndex;
        int dotDotIndex;
        while ((dotDotIndex = localFileName.indexOf("/../")) >= 0 && (parentIndex = localFileName.lastIndexOf("/", dotDotIndex - 1)) >= 0) {
            localFileName.delete(parentIndex, dotDotIndex + 3);
        }
        if (localFileName.length() >= 3 && localFileName.lastIndexOf("/..") == localFileName.length() - 3) {
            if (localFileName.length() <= 3) {
                localFileName.setLength(0);
            } else {
                int parentIndex2 = localFileName.lastIndexOf("/", localFileName.length() - 4);
                if (parentIndex2 < 0) {
                    localFileName.setLength(0);
                } else {
                    localFileName.setLength(parentIndex2);
                }
            }
        }
        while ((dotIndex = localFileName.indexOf("/./")) >= 0) {
            localFileName.delete(dotIndex, dotIndex + 2);
        }
        if (localFileName.length() >= 2 && localFileName.lastIndexOf("/.") == localFileName.length() - 2) {
            localFileName.setLength(localFileName.length() - 2);
        }
        if (localFileName.length() > 0 && localFileName.charAt(0) == '/') {
            localFileName.deleteCharAt(0);
        }
        if (localFileName.length() > 0 && localFileName.charAt(localFileName.length() - 1) == '/') {
            localFileName.setLength(localFileName.length() - 1);
        }
    }

    public static String getFileNameLastPart(String fileName) {
        int lastSepIndex;
        if (fileName != null && (lastSepIndex = fileName.lastIndexOf(47)) >= 0) {
            fileName = fileName.substring(lastSepIndex + 1);
        }
        return fileName;
    }
}

