/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS;

import java.io.File;
import jpcsp.HLE.Modules;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.VFS.VirtualFileSystemManager;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.settings.Settings;

public interface ITmpVirtualFileSystem
extends IVirtualFileSystem {
    public static final IPurpose tmpPurposePGD = new PurposePGD();
    public static final IPurpose tmpPurposeAtrac = new PurposeAtrac();

    public IVirtualFile ioOpen(String var1, int var2, int var3, IPurpose var4);

    public IVirtualFile ioOpen(String var1, int var2, int var3, IPurpose var4, IVirtualFile var5);

    public static class PurposeAtrac
    extends AbstractPurpose {
        @Override
        public String getFileName(String fileName) {
            return this.getFileName("Atrac", fileName);
        }
    }

    public static class PurposePGD
    extends AbstractPurpose {
        @Override
        public String getFileName(String fileName) {
            return this.getFileName("PGD", this.getFileNameById(fileName), "PGDfile.raw.decrypted");
        }
    }

    public static abstract class AbstractPurpose
    implements IPurpose {
        protected String getFileName(String dir, String fileName) {
            return String.format("%s%s%c%s", Settings.getInstance().getDiscDirectory(), dir, Character.valueOf(File.separatorChar), fileName);
        }

        protected String getFileName(String dir1, String dir2, String fileName) {
            return String.format("%s%s%c%s%c%s", Settings.getInstance().getDiscDirectory(), dir1, Character.valueOf(File.separatorChar), dir2, Character.valueOf(File.separatorChar), fileName);
        }

        protected String getFileNameById(String fileName) {
            int fileId = 0;
            SceIoStat stat = Modules.IoFileMgrForUserModule.statFile(fileName);
            if (stat != null) {
                fileId = stat.getStartSector();
            }
            if (fileId == 0 && fileName != null) {
                fileId = Math.abs(VirtualFileSystemManager.getFileNameLastPart(fileName).hashCode());
            }
            return String.format("File-%d", fileId);
        }
    }

    public static interface IPurpose {
        public String getFileName(String var1);
    }
}

