/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE;

import java.util.HashMap;

public class HLEUidObjectMapping {
    private static HashMap<String, DoubleHash<Integer, Object>> map = new HashMap();

    public static void reset() {
        map.clear();
    }

    protected static DoubleHash<Integer, Object> getMapForClass(String className) {
        if (!map.containsKey(className)) {
            map.put(className, new DoubleHash());
        }
        return map.get(className);
    }

    public static int addObjectMap(String className, int uid, Object object) {
        HLEUidObjectMapping.getMapForClass(className).put(uid, object);
        return uid;
    }

    public static int addObjectMap(int uid, Object object) {
        return HLEUidObjectMapping.addObjectMap(object.getClass().getName(), uid, object);
    }

    public static int createUidForObject(String className, Object object) {
        return HLEUidObjectMapping.addObjectMap(className, HLEUidObjectMapping.getMapForClass(className).size(), object);
    }

    public static int createUidForObject(Object object) {
        return HLEUidObjectMapping.createUidForObject(object.getClass().getName(), object);
    }

    public static Object getObject(String className, int uid) {
        return HLEUidObjectMapping.getMapForClass(className).getValueByKey(uid);
    }

    public static void removeObject(String className, Object object) {
        HLEUidObjectMapping.getMapForClass(className).removeValue(object);
    }

    public static void removeObject(Object object) {
        HLEUidObjectMapping.removeObject(object.getClass().getName(), object);
    }

    public static class DoubleHash<TKey, TValue> {
        private HashMap<TKey, TValue> map = new HashMap();
        private HashMap<TValue, TKey> reverseMap = new HashMap();

        public void put(TKey key, TValue value) {
            this.map.put(key, value);
            this.reverseMap.put(value, key);
        }

        public TValue getValueByKey(TKey key) {
            return this.map.get(key);
        }

        public TKey getKeyByValue(TValue value) {
            return this.reverseMap.get(value);
        }

        public boolean containsKey(TKey key) {
            return this.map.containsKey(key);
        }

        public boolean containsValue(TValue value) {
            return this.reverseMap.containsKey(value);
        }

        public void removeKey(TKey key) {
            TValue value = this.map.get(key);
            this.map.remove(key);
            this.reverseMap.remove(value);
        }

        public void removeValue(TValue value) {
            TKey key = this.reverseMap.get(value);
            this.map.remove(key);
            this.reverseMap.remove(value);
        }

        public int size() {
            return this.map.size();
        }
    }
}

