/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.GUI;

import com.jidesoft.swing.FolderChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jpcsp.Emulator;
import jpcsp.GUI.CancelButton;
import jpcsp.WindowPropSaver;
import jpcsp.settings.Settings;
import jpcsp.util.JpcspDialogManager;

public class SettingsGUI
extends JFrame {
    private static final long serialVersionUID = -732715495873159718L;
    private Settings settings = Settings.getInstance();
    private JPanel AudioPanel;
    private JPanel CompilerPanel;
    private JPanel CryptoPanel;
    private JCheckBox DisableSceAudioCheck;
    private JPanel DisplayPanel;
    private JPanel GeneralPanel;
    private JCheckBox IgnoreAudioThreadsCheck;
    private JPanel MemoryPanel;
    private JPanel MiscPanel;
    private JPanel RegionPanel;
    private JPanel VideoPanel;
    private JComboBox adhocChannelBox;
    private JLabel adhocChannelLabel;
    private JLabel antiAliasLabel;
    private JComboBox antiAliasingBox;
    private JButton btnUMDPathAdd;
    private JButton btnUMDPathRemove;
    private JComboBox buttonBox;
    private ButtonGroup buttonGroup1;
    private JLabel buttonLabel;
    private CancelButton cancelButton;
    private JRadioButton classicUmdDialog;
    private JCheckBox cryptoSavedata;
    private JComboBox dateFormatBox;
    private JLabel dateFormatLabel;
    private JComboBox daylightBox;
    private JLabel daylightLabel;
    private JCheckBox disableBlockingAudioCheck;
    private JCheckBox disableOptimizedVertexInfoReading;
    private JCheckBox disableUBOCheck;
    private JCheckBox disableVBOCheck;
    private JCheckBox enableDynamicShadersCheck;
    private JCheckBox enableGETextureCheck;
    private JCheckBox enableNativeCLUTCheck;
    private JCheckBox enableShaderColorMaskCheck;
    private JCheckBox enableShaderStencilTestCheck;
    private JCheckBox enableVAOCheck;
    private JCheckBox extractEboot;
    private JCheckBox extractPGD;
    private JCheckBox fullscreenCheck;
    private JCheckBox geometryShaderCheck;
    private JCheckBox ignoreUnmappedImports;
    private JLabel imposeLabel;
    private JCheckBox invalidMemoryCheck;
    private JButton jButtonApply;
    private JButton jButtonOK;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JComboBox languageBox;
    private JLabel languageLabel;
    private JList lbUMDPaths;
    private JCheckBox loadAndRunCheck;
    private JComboBox methodMaxInstructionsBox;
    private JLabel methodMaxInstructionsLabel;
    private JTextField nicknameTextField;
    private JLabel nicknamelLabel;
    private JCheckBox onlyGEGraphicsCheck;
    private JCheckBox pbpunpackcheck;
    private JCheckBox profilerCheck;
    private JComboBox resolutionBox;
    private JLabel resolutionLabel;
    private JCheckBox saveStencilToMemory;
    private JCheckBox saveWindowPosCheck;
    private JCheckBox shadersCheck;
    private JLabel sysParmLabel;
    private JComboBox timeFormatBox;
    private JLabel timeFormatLabel;
    private JLabel timezoneLabel;
    private JSpinner timezoneSpinner;
    private JButton tmpPathBrowseButton;
    private JLabel tmpPathLabel;
    private JTextField tmppath;
    private JRadioButton umdBrowser;
    private JLabel umdPathLabel;
    private JCheckBox useCompiler;
    private JCheckBox useConnector;
    private JCheckBox useDebugFont;
    private JCheckBox useDebugMemory;
    private JCheckBox useExternalDecoder;
    private JCheckBox useMediaEngine;
    private JCheckBox useSoftwareRenderer;
    private JCheckBox useVertexCache;
    private JComboBox wlanPowerBox;
    private JLabel wlanPowerLabel;

    public SettingsGUI() {
        this.initComponents();
        this.setAllComponentsFromSettings();
        this.lbUMDPaths.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SettingsGUI.this.btnUMDPathRemove.setEnabled(!((ListSelectionModel)e.getSource()).isSelectionEmpty() && SettingsGUI.this.lbUMDPaths.getModel().getSize() > 1);
            }
        });
        WindowPropSaver.loadWindowProperties(this);
    }

    private void setAllComponentsFromSettings() {
        String umdPath;
        this.setBoolFromSettings(this.pbpunpackcheck, "emu.pbpunpack");
        this.setBoolFromSettings(this.saveWindowPosCheck, "gui.saveWindowPos");
        this.setBoolFromSettings(this.fullscreenCheck, "gui.fullscreen");
        this.setBoolFromSettings(this.useCompiler, "emu.compiler");
        this.setBoolFromSettings(this.profilerCheck, "emu.profiler");
        this.setBoolFromSettings(this.shadersCheck, "emu.useshaders");
        this.setBoolFromSettings(this.geometryShaderCheck, "emu.useGeometryShader");
        this.setBoolFromSettings(this.loadAndRunCheck, "emu.loadAndRun");
        this.setIntFromSettings(this.languageBox, "emu.impose.language");
        this.setIntFromSettings(this.buttonBox, "emu.impose.button");
        this.setIntFromSettings(this.daylightBox, "emu.sysparam.daylightsavings");
        this.setIntFromSettings(this.timezoneSpinner, "emu.sysparam.timezone");
        this.setIntFromSettings(this.timeFormatBox, "emu.sysparam.timeformat");
        this.setIntFromSettings(this.dateFormatBox, "emu.sysparam.dateformat");
        this.setIntFromSettings(this.wlanPowerBox, "emu.sysparam.wlanpowersave");
        this.setIntFromSettings(this.adhocChannelBox, "emu.sysparam.adhocchannel");
        this.setStringFromSettings(this.nicknameTextField, "emu.sysparam.nickname");
        this.setBoolFromSettings(this.disableVBOCheck, "emu.disablevbo");
        this.setBoolFromSettings(this.disableUBOCheck, "emu.disableubo");
        this.setBoolFromSettings(this.enableVAOCheck, "emu.enablevao");
        this.setBoolFromSettings(this.enableGETextureCheck, "emu.enablegetexture");
        this.setBoolFromSettings(this.enableNativeCLUTCheck, "emu.enablenativeclut");
        this.setBoolFromSettings(this.enableDynamicShadersCheck, "emu.enabledynamicshaders");
        this.setBoolFromSettings(this.enableShaderStencilTestCheck, "emu.enableshaderstenciltest");
        this.setBoolFromSettings(this.enableShaderColorMaskCheck, "emu.enableshadercolormask");
        this.setBoolFromSettings(this.disableOptimizedVertexInfoReading, "emu.disableoptimizedvertexinforeading");
        this.setBoolFromSettings(this.saveStencilToMemory, "emu.saveStencilToMemory");
        this.setBoolFromSettings(this.useSoftwareRenderer, "emu.useSoftwareRenderer");
        this.setBoolFromSettings(this.onlyGEGraphicsCheck, "emu.onlyGEGraphics");
        this.setBoolFromSettings(this.useConnector, "emu.useConnector");
        this.setBoolFromSettings(this.useDebugFont, "emu.useDebugFont");
        this.setBoolFromSettings(this.useDebugMemory, "emu.useDebuggerMemory");
        this.setBoolFromSettings(this.useExternalDecoder, "emu.useExternalDecoder");
        this.setBoolFromSettings(this.useMediaEngine, "emu.useMediaEngine");
        this.setBoolFromSettings(this.useVertexCache, "emu.useVertexCache");
        this.setBoolFromSettings(this.invalidMemoryCheck, "emu.ignoreInvalidMemoryAccess");
        this.setBoolFromSettings(this.DisableSceAudioCheck, "emu.disablesceAudio");
        this.setBoolFromSettings(this.IgnoreAudioThreadsCheck, "emu.ignoreaudiothreads");
        this.setBoolFromSettings(this.disableBlockingAudioCheck, "emu.disableblockingaudio");
        this.setBoolFromSettings(this.ignoreUnmappedImports, "emu.ignoreUnmappedImports");
        this.setIntAsStringFromSettings(this.methodMaxInstructionsBox, "emu.compiler.methodMaxInstructions", 3000);
        this.setBoolFromSettings(this.extractEboot, "emu.extractEboot");
        this.setBoolFromSettings(this.cryptoSavedata, "emu.cryptoSavedata");
        this.setBoolFromSettings(this.extractPGD, "emu.extractPGD");
        this.setStringFromSettings(this.antiAliasingBox, "emu.graphics.antialias");
        this.setStringFromSettings(this.resolutionBox, "emu.graphics.resolution");
        this.setStringFromSettings(this.tmppath, "emu.tmppath");
        this.setBoolFromSettings(this.umdBrowser, this.classicUmdDialog, "emu.umdbrowser");
        DefaultListModel dlm = (DefaultListModel)this.lbUMDPaths.getModel();
        dlm.clear();
        dlm.addElement(this.settings.readString("emu.umdpath"));
        int i = 1;
        while ((umdPath = this.settings.readString(String.format("emu.umdpath.%d", i), null)) != null) {
            if (!dlm.contains(umdPath)) {
                dlm.addElement(umdPath);
            }
            ++i;
        }
    }

    private boolean isEnabledSettings(String settingsOption) {
        return !this.settings.isOptionFromPatch(settingsOption);
    }

    private void setBoolFromSettings(JRadioButton trueButton, JRadioButton falseButton, String settingsOption) {
        boolean value = this.settings.readBool(settingsOption);
        trueButton.setSelected(value);
        falseButton.setSelected(!value);
        trueButton.setEnabled(this.isEnabledSettings(settingsOption));
        falseButton.setEnabled(this.isEnabledSettings(settingsOption));
    }

    private void setBoolFromSettings(JCheckBox checkBox, String settingsOption) {
        checkBox.setSelected(this.settings.readBool(settingsOption));
        checkBox.setEnabled(this.isEnabledSettings(settingsOption));
    }

    private void setIntFromSettings(JComboBox comboBox, String settingsOption) {
        comboBox.setSelectedIndex(this.settings.readInt(settingsOption));
        comboBox.setEnabled(this.isEnabledSettings(settingsOption));
    }

    private void setIntAsStringFromSettings(JComboBox comboBox, String settingsOption, int defaultValue) {
        comboBox.setSelectedItem(Integer.toString(this.settings.readInt(settingsOption, defaultValue)));
        comboBox.setEnabled(this.isEnabledSettings(settingsOption));
    }

    private void setIntFromSettings(JSpinner spinner, String settingsOption) {
        spinner.setValue(this.settings.readInt(settingsOption));
        spinner.setEnabled(this.isEnabledSettings(settingsOption));
    }

    private void setStringFromSettings(JComboBox comboBox, String settingsOption) {
        comboBox.setSelectedItem(this.settings.readString(settingsOption));
        comboBox.setEnabled(this.isEnabledSettings(settingsOption));
    }

    private void setStringFromSettings(JTextField textField, String settingsOption) {
        textField.setText(this.settings.readString(settingsOption));
        textField.setEnabled(this.isEnabledSettings(settingsOption));
    }

    private void setAllComponentsToSettings() {
        int i;
        this.setBoolToSettings(this.pbpunpackcheck, "emu.pbpunpack");
        this.setBoolToSettings(this.saveWindowPosCheck, "gui.saveWindowPos");
        this.setBoolToSettings(this.fullscreenCheck, "gui.fullscreen");
        this.setBoolToSettings(this.useCompiler, "emu.compiler");
        this.setBoolToSettings(this.profilerCheck, "emu.profiler");
        this.setBoolToSettings(this.shadersCheck, "emu.useshaders");
        this.setBoolToSettings(this.geometryShaderCheck, "emu.useGeometryShader");
        this.setBoolToSettings(this.loadAndRunCheck, "emu.loadAndRun");
        this.setIntToSettings(this.languageBox, "emu.impose.language");
        this.setIntToSettings(this.buttonBox, "emu.impose.button");
        this.setIntToSettings(this.daylightBox, "emu.sysparam.daylightsavings");
        this.setIntToSettings(this.timezoneSpinner, "emu.sysparam.timezone");
        this.setIntToSettings(this.timeFormatBox, "emu.sysparam.timeformat");
        this.setIntToSettings(this.dateFormatBox, "emu.sysparam.dateformat");
        this.setIntToSettings(this.wlanPowerBox, "emu.sysparam.wlanpowersave");
        this.setIntToSettings(this.adhocChannelBox, "emu.sysparam.adhocchannel");
        this.setStringToSettings(this.nicknameTextField, "emu.sysparam.nickname");
        this.setBoolToSettings(this.disableVBOCheck, "emu.disablevbo");
        this.setBoolToSettings(this.disableUBOCheck, "emu.disableubo");
        this.setBoolToSettings(this.enableVAOCheck, "emu.enablevao");
        this.setBoolToSettings(this.enableGETextureCheck, "emu.enablegetexture");
        this.setBoolToSettings(this.enableNativeCLUTCheck, "emu.enablenativeclut");
        this.setBoolToSettings(this.enableDynamicShadersCheck, "emu.enabledynamicshaders");
        this.setBoolToSettings(this.enableShaderStencilTestCheck, "emu.enableshaderstenciltest");
        this.setBoolToSettings(this.enableShaderColorMaskCheck, "emu.enableshadercolormask");
        this.setBoolToSettings(this.disableOptimizedVertexInfoReading, "emu.disableoptimizedvertexinforeading");
        this.setBoolToSettings(this.saveStencilToMemory, "emu.saveStencilToMemory");
        this.setBoolToSettings(this.useSoftwareRenderer, "emu.useSoftwareRenderer");
        this.setBoolToSettings(this.onlyGEGraphicsCheck, "emu.onlyGEGraphics");
        this.setBoolToSettings(this.useConnector, "emu.useConnector");
        this.setBoolToSettings(this.useDebugFont, "emu.useDebugFont");
        this.setBoolToSettings(this.useDebugMemory, "emu.useDebuggerMemory");
        this.setBoolToSettings(this.useExternalDecoder, "emu.useExternalDecoder");
        this.setBoolToSettings(this.useMediaEngine, "emu.useMediaEngine");
        this.setBoolToSettings(this.useVertexCache, "emu.useVertexCache");
        this.setBoolToSettings(this.invalidMemoryCheck, "emu.ignoreInvalidMemoryAccess");
        this.setBoolToSettings(this.DisableSceAudioCheck, "emu.disablesceAudio");
        this.setBoolToSettings(this.IgnoreAudioThreadsCheck, "emu.ignoreaudiothreads");
        this.setBoolToSettings(this.disableBlockingAudioCheck, "emu.disableblockingaudio");
        this.setBoolToSettings(this.ignoreUnmappedImports, "emu.ignoreUnmappedImports");
        this.setIntAsStringToSettings(this.methodMaxInstructionsBox, "emu.compiler.methodMaxInstructions", 3000);
        this.setBoolToSettings(this.extractEboot, "emu.extractEboot");
        this.setBoolToSettings(this.cryptoSavedata, "emu.cryptoSavedata");
        this.setBoolToSettings(this.extractPGD, "emu.extractPGD");
        this.setStringToSettings(this.antiAliasingBox, "emu.graphics.antialias");
        this.setStringToSettings(this.resolutionBox, "emu.graphics.resolution");
        this.setStringToSettings(this.tmppath, "emu.tmppath");
        this.setBoolToSettings(this.umdBrowser, "emu.umdbrowser");
        DefaultListModel dlm = (DefaultListModel)this.lbUMDPaths.getModel();
        this.settings.writeString("emu.umdpath", (String)dlm.getElementAt(0));
        for (i = 1; i < dlm.getSize(); ++i) {
            this.settings.writeString(String.format("emu.umdpath.%d", i), (String)dlm.getElementAt(i));
        }
        i = dlm.getSize();
        while (this.settings.hasProperty(String.format("emu.umdpath.%d", i))) {
            this.settings.clearProperty(String.format("emu.umdpath.%d", i));
            ++i;
        }
    }

    private void setBoolToSettings(JRadioButton radioButton, String settingsOption) {
        if (this.isEnabledSettings(settingsOption)) {
            this.settings.writeBool(settingsOption, radioButton.isSelected());
        }
    }

    private void setBoolToSettings(JCheckBox checkBox, String settingsOption) {
        if (this.isEnabledSettings(settingsOption)) {
            this.settings.writeBool(settingsOption, checkBox.isSelected());
        }
    }

    private void setIntToSettings(JComboBox comboBox, String settingsOption) {
        if (this.isEnabledSettings(settingsOption)) {
            this.settings.writeInt(settingsOption, comboBox.getSelectedIndex());
        }
    }

    private void setIntAsStringToSettings(JComboBox comboBox, String settingsOption, int defaultValue) {
        if (this.isEnabledSettings(settingsOption)) {
            this.settings.writeInt(settingsOption, Integer.parseInt(comboBox.getSelectedItem().toString()));
        }
    }

    private void setIntToSettings(JSpinner spinner, String settingsOption) {
        if (this.isEnabledSettings(settingsOption)) {
            this.settings.writeInt(settingsOption, Integer.parseInt(spinner.getValue().toString()));
        }
    }

    private void setStringToSettings(JComboBox comboBox, String settingsOption) {
        if (this.isEnabledSettings(settingsOption)) {
            this.settings.writeString(settingsOption, comboBox.getSelectedItem().toString());
        }
    }

    private void setStringToSettings(JTextField textField, String settingsOption) {
        if (this.isEnabledSettings(settingsOption)) {
            this.settings.writeString(settingsOption, textField.getText());
        }
    }

    private ComboBoxModel makeComboBoxModel(String[] items) {
        DefaultComboBoxModel<String> comboBox = new DefaultComboBoxModel<String>();
        for (String item : items) {
            comboBox.addElement(item);
        }
        return comboBox;
    }

    public static String[] getImposeLanguages() {
        return new String[]{"Japanese", "English", "French", "Spanish", "German", "Italian", "Dutch", "Portuguese", "Russian", "Korean", "Traditional Chinese", "Simplfied Chinese"};
    }

    public static String[] getImposeButtons() {
        return new String[]{"\"O\" for \"Enter\"", "\"X\" for \"Enter\""};
    }

    public static String[] getSysparamDaylightSavings() {
        return new String[]{"Off", "On"};
    }

    public static String[] getSysparamTimeFormats() {
        return new String[]{"24H", "12H"};
    }

    public static String[] getSysparamDateFormats() {
        return new String[]{"YYYY-MM-DD", "MM-DD-YYYY", "DD-MM-YYYY"};
    }

    public static String[] getSysparamWlanPowerSaves() {
        return new String[]{"Off", "On"};
    }

    public static String[] getSysparamAdhocChannels() {
        return new String[]{"Auto", "1", "6", "11"};
    }

    private ComboBoxModel makeResolutions() {
        DefaultComboBoxModel<String> comboBox = new DefaultComboBoxModel<String>();
        comboBox.addElement("Native");
        HashSet<String> resolutions = new HashSet<String>();
        GraphicsDevice localDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode[] displayModes = localDevice.getDisplayModes();
        for (int i = 0; displayModes != null && i < displayModes.length; ++i) {
            String resolution;
            DisplayMode displayMode = displayModes[i];
            if (displayMode.getBitDepth() != 32 || resolutions.contains(resolution = String.format("%dx%d", displayMode.getWidth(), displayMode.getHeight()))) continue;
            comboBox.addElement(resolution);
            resolutions.add(resolution);
        }
        return comboBox;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonOK = new JButton();
        this.jButtonApply = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.GeneralPanel = new JPanel();
        this.pbpunpackcheck = new JCheckBox();
        this.saveWindowPosCheck = new JCheckBox();
        this.loadAndRunCheck = new JCheckBox();
        this.umdBrowser = new JRadioButton();
        this.classicUmdDialog = new JRadioButton();
        this.umdPathLabel = new JLabel();
        this.tmpPathLabel = new JLabel();
        this.tmppath = new JTextField();
        this.tmpPathBrowseButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.lbUMDPaths = new JList();
        this.btnUMDPathRemove = new JButton();
        this.btnUMDPathAdd = new JButton();
        this.RegionPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.imposeLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.languageLabel = new JLabel();
        this.languageBox = new JComboBox();
        this.buttonLabel = new JLabel();
        this.buttonBox = new JComboBox();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.sysParmLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.daylightLabel = new JLabel();
        this.daylightBox = new JComboBox();
        this.timeFormatLabel = new JLabel();
        this.timeFormatBox = new JComboBox();
        this.dateFormatLabel = new JLabel();
        this.dateFormatBox = new JComboBox();
        this.wlanPowerLabel = new JLabel();
        this.wlanPowerBox = new JComboBox();
        this.adhocChannelLabel = new JLabel();
        this.adhocChannelBox = new JComboBox();
        this.timezoneLabel = new JLabel();
        this.timezoneSpinner = new JSpinner();
        this.nicknamelLabel = new JLabel();
        this.nicknameTextField = new JTextField();
        this.VideoPanel = new JPanel();
        this.disableVBOCheck = new JCheckBox();
        this.onlyGEGraphicsCheck = new JCheckBox();
        this.useVertexCache = new JCheckBox();
        this.shadersCheck = new JCheckBox();
        this.geometryShaderCheck = new JCheckBox();
        this.disableUBOCheck = new JCheckBox();
        this.enableVAOCheck = new JCheckBox();
        this.enableGETextureCheck = new JCheckBox();
        this.enableNativeCLUTCheck = new JCheckBox();
        this.enableDynamicShadersCheck = new JCheckBox();
        this.enableShaderStencilTestCheck = new JCheckBox();
        this.enableShaderColorMaskCheck = new JCheckBox();
        this.disableOptimizedVertexInfoReading = new JCheckBox();
        this.saveStencilToMemory = new JCheckBox();
        this.useSoftwareRenderer = new JCheckBox();
        this.AudioPanel = new JPanel();
        this.IgnoreAudioThreadsCheck = new JCheckBox();
        this.disableBlockingAudioCheck = new JCheckBox();
        this.DisableSceAudioCheck = new JCheckBox();
        this.MemoryPanel = new JPanel();
        this.invalidMemoryCheck = new JCheckBox();
        this.ignoreUnmappedImports = new JCheckBox();
        this.MiscPanel = new JPanel();
        this.useMediaEngine = new JCheckBox();
        this.useConnector = new JCheckBox();
        this.useExternalDecoder = new JCheckBox();
        this.useDebugFont = new JCheckBox();
        this.useDebugMemory = new JCheckBox();
        this.CompilerPanel = new JPanel();
        this.useCompiler = new JCheckBox();
        this.methodMaxInstructionsBox = new JComboBox();
        this.profilerCheck = new JCheckBox();
        this.methodMaxInstructionsLabel = new JLabel();
        this.CryptoPanel = new JPanel();
        this.extractEboot = new JCheckBox();
        this.cryptoSavedata = new JCheckBox();
        this.extractPGD = new JCheckBox();
        this.DisplayPanel = new JPanel();
        this.antiAliasLabel = new JLabel();
        this.antiAliasingBox = new JComboBox();
        this.resolutionLabel = new JLabel();
        this.resolutionBox = new JComboBox();
        this.fullscreenCheck = new JCheckBox();
        this.cancelButton = new CancelButton();
        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
        this.setTitle(bundle.getString("SettingsGUI.title"));
        this.jButtonOK.setText(bundle.getString("OkButton.text"));
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsGUI.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonApply.setText(bundle.getString("SettingsGUI.jButtonApply.text"));
        this.jButtonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsGUI.this.jButtonApplyActionPerformed(evt);
            }
        });
        this.pbpunpackcheck.setText(bundle.getString("SettingsGUI.pbpunpackcheck.text"));
        this.saveWindowPosCheck.setText(bundle.getString("SettingsGUI.saveWindowPosCheck.text"));
        this.loadAndRunCheck.setText(bundle.getString("SettingsGUI.loadAndRunCheck.text"));
        this.buttonGroup1.add(this.umdBrowser);
        this.umdBrowser.setText(bundle.getString("SettingsGUI.umdBrowser.text"));
        this.buttonGroup1.add(this.classicUmdDialog);
        this.classicUmdDialog.setText(bundle.getString("SettingsGUI.classicUmdDialog.text"));
        this.umdPathLabel.setText(bundle.getString("SettingsGUI.umdPathLabel.text"));
        this.tmpPathLabel.setText(bundle.getString("SettingsGUI.tmpPathLabel.text"));
        this.tmppath.setEditable(false);
        this.tmppath.setText("tmp");
        this.tmpPathBrowseButton.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/AddFolderIcon.png")));
        this.tmpPathBrowseButton.setPreferredSize(new Dimension(26, 26));
        this.tmpPathBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsGUI.this.tmpPathBrowseButtonActionPerformed(evt);
            }
        });
        this.lbUMDPaths.setFont(new Font("Dialog", 0, 12));
        this.lbUMDPaths.setModel(new DefaultListModel());
        this.lbUMDPaths.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.lbUMDPaths);
        this.btnUMDPathRemove.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/DeleteIcon.png")));
        this.btnUMDPathRemove.setEnabled(false);
        this.btnUMDPathRemove.setPreferredSize(new Dimension(26, 26));
        this.btnUMDPathRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsGUI.this.btnUMDPathRemoveActionPerformed(evt);
            }
        });
        this.btnUMDPathAdd.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/AddFolderIcon.png")));
        this.btnUMDPathAdd.setPreferredSize(new Dimension(26, 26));
        this.btnUMDPathAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsGUI.this.btnUMDPathAddActionPerformed(evt);
            }
        });
        GroupLayout GeneralPanelLayout = new GroupLayout(this.GeneralPanel);
        this.GeneralPanel.setLayout(GeneralPanelLayout);
        GeneralPanelLayout.setHorizontalGroup(GeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GeneralPanelLayout.createSequentialGroup().addContainerGap().addGroup(GeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GeneralPanelLayout.createSequentialGroup().addComponent(this.pbpunpackcheck, -1, -1, Short.MAX_VALUE).addGap(431, 431, 431)).addGroup(GeneralPanelLayout.createSequentialGroup().addComponent(this.saveWindowPosCheck, -1, 258, Short.MAX_VALUE).addGap(493, 493, 493)).addGroup(GeneralPanelLayout.createSequentialGroup().addComponent(this.loadAndRunCheck, -1, -1, Short.MAX_VALUE).addGap(489, 489, 489)).addGroup(GeneralPanelLayout.createSequentialGroup().addComponent(this.umdBrowser, -1, -1, Short.MAX_VALUE).addGap(582, 582, 582)).addGroup(GeneralPanelLayout.createSequentialGroup().addComponent(this.classicUmdDialog, -1, -1, Short.MAX_VALUE).addGap(482, 482, 482)).addGroup(GeneralPanelLayout.createSequentialGroup().addGroup(GeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.umdPathLabel).addComponent(this.tmpPathLabel)).addGap(21, 21, 21).addGroup(GeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane1, -1, 385, Short.MAX_VALUE).addComponent(this.tmppath)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(GeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tmpPathBrowseButton, -2, -1, -2).addComponent(this.btnUMDPathRemove, -2, -1, -2).addComponent(this.btnUMDPathAdd, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)))));
        GeneralPanelLayout.setVerticalGroup(GeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GeneralPanelLayout.createSequentialGroup().addContainerGap().addGroup(GeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tmpPathBrowseButton, -2, -1, -2).addGroup(GeneralPanelLayout.createSequentialGroup().addComponent(this.pbpunpackcheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveWindowPosCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadAndRunCheck).addGap(18, 18, 18).addComponent(this.umdBrowser).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.classicUmdDialog).addGap(18, 18, 18).addGroup(GeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GeneralPanelLayout.createSequentialGroup().addComponent(this.umdPathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnUMDPathAdd, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnUMDPathRemove, -2, -1, -2)).addComponent(this.jScrollPane1, -2, -1, -2)).addGap(18, 18, 18).addGroup(GeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tmppath, -2, -1, -2).addComponent(this.tmpPathLabel)))).addContainerGap(165, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(bundle.getString("SettingsGUI.GeneralPanel.title"), this.GeneralPanel);
        this.jPanel1.setLayout(new GridLayout(20, 2, 10, 0));
        this.imposeLabel.setText(bundle.getString("SettingsGUI.imposeLabel.text"));
        this.jPanel1.add(this.imposeLabel);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 364, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 23, Short.MAX_VALUE));
        this.jPanel1.add(this.jPanel2);
        this.languageLabel.setText(bundle.getString("SettingsGUI.languageLabel.text"));
        this.jPanel1.add(this.languageLabel);
        this.languageBox.setModel(this.makeComboBoxModel(SettingsGUI.getImposeLanguages()));
        this.jPanel1.add(this.languageBox);
        this.buttonLabel.setText(bundle.getString("SettingsGUI.buttonLabel.text"));
        this.jPanel1.add(this.buttonLabel);
        this.buttonBox.setModel(this.makeComboBoxModel(SettingsGUI.getImposeButtons()));
        this.jPanel1.add(this.buttonBox);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 364, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 23, Short.MAX_VALUE));
        this.jPanel1.add(this.jPanel4);
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 364, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 23, Short.MAX_VALUE));
        this.jPanel1.add(this.jPanel5);
        this.sysParmLabel.setText(bundle.getString("SettingsGUI.sysParmLabel.text"));
        this.jPanel1.add(this.sysParmLabel);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 364, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 23, Short.MAX_VALUE));
        this.jPanel1.add(this.jPanel3);
        this.daylightLabel.setText(bundle.getString("SettingsGUI.daylightLabel.text"));
        this.jPanel1.add(this.daylightLabel);
        this.daylightBox.setModel(this.makeComboBoxModel(SettingsGUI.getSysparamDaylightSavings()));
        this.jPanel1.add(this.daylightBox);
        this.timeFormatLabel.setText(bundle.getString("SettingsGUI.timeFormatLabel.text"));
        this.jPanel1.add(this.timeFormatLabel);
        this.timeFormatBox.setModel(this.makeComboBoxModel(SettingsGUI.getSysparamTimeFormats()));
        this.jPanel1.add(this.timeFormatBox);
        this.dateFormatLabel.setText(bundle.getString("SettingsGUI.dateFormatLabel.text"));
        this.jPanel1.add(this.dateFormatLabel);
        this.dateFormatBox.setModel(this.makeComboBoxModel(SettingsGUI.getSysparamDateFormats()));
        this.jPanel1.add(this.dateFormatBox);
        this.wlanPowerLabel.setText(bundle.getString("SettingsGUI.wlanPowerLabel.text"));
        this.jPanel1.add(this.wlanPowerLabel);
        this.wlanPowerBox.setModel(this.makeComboBoxModel(SettingsGUI.getSysparamWlanPowerSaves()));
        this.jPanel1.add(this.wlanPowerBox);
        this.adhocChannelLabel.setText(bundle.getString("SettingsGUI.adhocChannel.text"));
        this.jPanel1.add(this.adhocChannelLabel);
        this.adhocChannelBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Auto", "1", "6", "11"}));
        this.jPanel1.add(this.adhocChannelBox);
        this.timezoneLabel.setText(bundle.getString("SettingsGUI.timezoneLabel.text"));
        this.jPanel1.add(this.timezoneLabel);
        this.timezoneSpinner.setModel(new SpinnerNumberModel(0, -720, 720, 1));
        this.jPanel1.add(this.timezoneSpinner);
        this.nicknamelLabel.setText(bundle.getString("SettingsGUI.nicknameLabel.text"));
        this.jPanel1.add(this.nicknamelLabel);
        this.nicknameTextField.setHorizontalAlignment(4);
        this.nicknameTextField.setText("JPCSP");
        this.jPanel1.add(this.nicknameTextField);
        GroupLayout RegionPanelLayout = new GroupLayout(this.RegionPanel);
        this.RegionPanel.setLayout(RegionPanelLayout);
        RegionPanelLayout.setHorizontalGroup(RegionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(RegionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, 739, Short.MAX_VALUE).addContainerGap()));
        RegionPanelLayout.setVerticalGroup(RegionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(RegionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, 468, -2).addContainerGap()));
        this.jTabbedPane1.addTab(bundle.getString("SettingsGUI.RegionPanel.title"), this.RegionPanel);
        this.disableVBOCheck.setText(bundle.getString("SettingsGUI.disableVBOCheck.text"));
        this.onlyGEGraphicsCheck.setText(bundle.getString("SettingsGUI.onlyGEGraphicsCheck.text"));
        this.useVertexCache.setText(bundle.getString("SettingsGUI.useVertexCache.text"));
        this.shadersCheck.setText(bundle.getString("SettingsGUI.shaderCheck.text"));
        this.geometryShaderCheck.setText(bundle.getString("SettingsGUI.geometryShaderCheck.text"));
        this.disableUBOCheck.setText(bundle.getString("SettingsGUI.disableUBOCheck.text"));
        this.enableVAOCheck.setText(bundle.getString("SettingsGUI.enableVAOCheck.text"));
        this.enableGETextureCheck.setText(bundle.getString("SettingsGUI.enableGETextureCheck.text"));
        this.enableNativeCLUTCheck.setText(bundle.getString("SettingsGUI.enableNativeCLUTCheck.text"));
        this.enableDynamicShadersCheck.setText(bundle.getString("SettingsGUI.enableDynamicShadersCheck.text"));
        this.enableShaderStencilTestCheck.setText(bundle.getString("SettingsGUI.enableShaderStencilTestCheck.text"));
        this.enableShaderColorMaskCheck.setText(bundle.getString("SettingsGUI.enableShaderColorMaskCheck.text"));
        this.disableOptimizedVertexInfoReading.setText(bundle.getString("SettingsGUI.disableOptimizedVertexInfoReading.text"));
        this.saveStencilToMemory.setText(bundle.getString("SettingsGUI.saveStencilToMemory.text"));
        this.useSoftwareRenderer.setText(bundle.getString("SettingsGUI.useSoftwareRenderer.text"));
        GroupLayout VideoPanelLayout = new GroupLayout(this.VideoPanel);
        this.VideoPanel.setLayout(VideoPanelLayout);
        VideoPanelLayout.setHorizontalGroup(VideoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(VideoPanelLayout.createSequentialGroup().addContainerGap().addGroup(VideoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(VideoPanelLayout.createSequentialGroup().addComponent(this.disableVBOCheck, -1, 423, Short.MAX_VALUE).addGap(315, 315, 315)).addGroup(VideoPanelLayout.createSequentialGroup().addComponent(this.onlyGEGraphicsCheck, -1, -1, Short.MAX_VALUE).addGap(331, 331, 331)).addGroup(VideoPanelLayout.createSequentialGroup().addComponent(this.useVertexCache, -1, -1, Short.MAX_VALUE).addGap(575, 575, 575)).addGroup(VideoPanelLayout.createSequentialGroup().addComponent(this.shadersCheck, -1, -1, Short.MAX_VALUE).addGap(606, 606, 606)).addComponent(this.geometryShaderCheck, -2, 720, -2).addGroup(VideoPanelLayout.createSequentialGroup().addComponent(this.disableUBOCheck, -1, -1, Short.MAX_VALUE).addGap(64, 64, 64)).addGroup(VideoPanelLayout.createSequentialGroup().addComponent(this.enableVAOCheck, -1, -1, Short.MAX_VALUE).addGap(235, 235, 235)).addGroup(VideoPanelLayout.createSequentialGroup().addComponent(this.enableGETextureCheck, -1, -1, Short.MAX_VALUE).addGap(304, 304, 304)).addGroup(VideoPanelLayout.createSequentialGroup().addComponent(this.enableNativeCLUTCheck, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18)).addComponent(this.enableDynamicShadersCheck, -1, -1, Short.MAX_VALUE).addGroup(VideoPanelLayout.createSequentialGroup().addComponent(this.enableShaderStencilTestCheck, -1, -1, Short.MAX_VALUE).addGap(103, 103, 103)).addGroup(VideoPanelLayout.createSequentialGroup().addComponent(this.enableShaderColorMaskCheck, -1, -1, Short.MAX_VALUE).addGap(108, 108, 108)).addGroup(VideoPanelLayout.createSequentialGroup().addComponent(this.disableOptimizedVertexInfoReading, -1, -1, Short.MAX_VALUE).addGap(234, 234, 234)).addGroup(VideoPanelLayout.createSequentialGroup().addComponent(this.saveStencilToMemory, -1, -1, Short.MAX_VALUE).addGap(334, 334, 334)).addGroup(VideoPanelLayout.createSequentialGroup().addComponent(this.useSoftwareRenderer, -1, -1, Short.MAX_VALUE).addGap(210, 210, 210))).addGap(17, 17, 17)));
        VideoPanelLayout.setVerticalGroup(VideoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(VideoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.disableVBOCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.onlyGEGraphicsCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useVertexCache).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shadersCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.geometryShaderCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.disableUBOCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enableVAOCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enableGETextureCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enableNativeCLUTCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enableDynamicShadersCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enableShaderStencilTestCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enableShaderColorMaskCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.disableOptimizedVertexInfoReading).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveStencilToMemory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useSoftwareRenderer).addContainerGap(139, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(bundle.getString("SettingsGUI.VideoPanel.title"), this.VideoPanel);
        this.IgnoreAudioThreadsCheck.setText(bundle.getString("SettingsGUI.IgnoreAudioThreadsCheck.text"));
        this.disableBlockingAudioCheck.setText(bundle.getString("SettingsGUI.disableBlockingAudioCheck.text"));
        this.DisableSceAudioCheck.setText(bundle.getString("SettingsGUI.DisableSceAudioCheck.text"));
        GroupLayout AudioPanelLayout = new GroupLayout(this.AudioPanel);
        this.AudioPanel.setLayout(AudioPanelLayout);
        AudioPanelLayout.setHorizontalGroup(AudioPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(AudioPanelLayout.createSequentialGroup().addContainerGap().addGroup(AudioPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(AudioPanelLayout.createSequentialGroup().addComponent(this.IgnoreAudioThreadsCheck, -1, 200, Short.MAX_VALUE).addGap(150, 150, 150)).addComponent(this.DisableSceAudioCheck, -1, -1, Short.MAX_VALUE).addGroup(AudioPanelLayout.createSequentialGroup().addComponent(this.disableBlockingAudioCheck, -1, -1, Short.MAX_VALUE).addGap(147, 147, 147))).addGap(405, 405, 405)));
        AudioPanelLayout.setVerticalGroup(AudioPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(AudioPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.IgnoreAudioThreadsCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DisableSceAudioCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.disableBlockingAudioCheck).addContainerGap(415, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(bundle.getString("SettingsGUI.AudioPanel.title"), this.AudioPanel);
        this.invalidMemoryCheck.setText(bundle.getString("SettingsGUI.invalidMemoryCheck.text"));
        this.ignoreUnmappedImports.setText(bundle.getString("SettingsGUI.ignoreUnmappedImports.text"));
        GroupLayout MemoryPanelLayout = new GroupLayout(this.MemoryPanel);
        this.MemoryPanel.setLayout(MemoryPanelLayout);
        MemoryPanelLayout.setHorizontalGroup(MemoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(MemoryPanelLayout.createSequentialGroup().addContainerGap().addGroup(MemoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.invalidMemoryCheck, -1, 747, Short.MAX_VALUE).addComponent(this.ignoreUnmappedImports, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        MemoryPanelLayout.setVerticalGroup(MemoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(MemoryPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.invalidMemoryCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ignoreUnmappedImports).addContainerGap(438, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(bundle.getString("SettingsGUI.MemoryPanel.title"), this.MemoryPanel);
        this.useMediaEngine.setText(bundle.getString("SettingsGUI.useMediaEngine.text"));
        this.useConnector.setText(bundle.getString("SettingsGUI.useConnector.text"));
        this.useExternalDecoder.setText(bundle.getString("SettingsGUI.useExternalDecoder.text"));
        this.useDebugFont.setText(bundle.getString("SettingsGUI.useDebugFont.text"));
        this.useDebugMemory.setText(bundle.getString("SettingsGUI.useDebugMemory.text"));
        GroupLayout MiscPanelLayout = new GroupLayout(this.MiscPanel);
        this.MiscPanel.setLayout(MiscPanelLayout);
        MiscPanelLayout.setHorizontalGroup(MiscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(MiscPanelLayout.createSequentialGroup().addContainerGap().addGroup(MiscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useExternalDecoder, -1, 747, Short.MAX_VALUE).addComponent(this.useConnector, -1, -1, Short.MAX_VALUE).addComponent(this.useMediaEngine, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.useDebugFont, -1, -1, Short.MAX_VALUE).addComponent(this.useDebugMemory, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        MiscPanelLayout.setVerticalGroup(MiscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(MiscPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.useMediaEngine).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useConnector).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useExternalDecoder).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useDebugFont).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useDebugMemory).addContainerGap(369, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(bundle.getString("SettingsGUI.MiscPanel.title"), this.MiscPanel);
        this.useCompiler.setText(bundle.getString("SettingsGUI.useCompiler.text"));
        this.methodMaxInstructionsBox.setModel(new DefaultComboBoxModel<String>(new String[]{"50", "100", "500", "1000", "3000"}));
        this.profilerCheck.setText(bundle.getString("SettingsGUI.profileCheck.text"));
        this.methodMaxInstructionsLabel.setText(bundle.getString("SettingsGUI.methodMaxInstructionsLabel.text"));
        GroupLayout CompilerPanelLayout = new GroupLayout(this.CompilerPanel);
        this.CompilerPanel.setLayout(CompilerPanelLayout);
        CompilerPanelLayout.setHorizontalGroup(CompilerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(CompilerPanelLayout.createSequentialGroup().addContainerGap().addGroup(CompilerPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.useCompiler, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.profilerCheck, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, CompilerPanelLayout.createSequentialGroup().addComponent(this.methodMaxInstructionsBox, -2, 143, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.methodMaxInstructionsLabel, -2, 238, -2))).addContainerGap(358, Short.MAX_VALUE)));
        CompilerPanelLayout.setVerticalGroup(CompilerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(CompilerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.useCompiler).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.profilerCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(CompilerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.methodMaxInstructionsBox, -2, -1, -2).addComponent(this.methodMaxInstructionsLabel)).addContainerGap(412, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(bundle.getString("SettingsGUI.CompilerPanel.title"), this.CompilerPanel);
        this.extractEboot.setText(bundle.getString("SettingsGUI.extractEboot.text"));
        this.cryptoSavedata.setText(bundle.getString("SettingsGUI.cryptoSavedata.text"));
        this.extractPGD.setText(bundle.getString("SettingsGUI.extractPGD.text"));
        GroupLayout CryptoPanelLayout = new GroupLayout(this.CryptoPanel);
        this.CryptoPanel.setLayout(CryptoPanelLayout);
        CryptoPanelLayout.setHorizontalGroup(CryptoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(CryptoPanelLayout.createSequentialGroup().addContainerGap().addGroup(CryptoPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.extractEboot, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.cryptoSavedata, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.extractPGD, GroupLayout.Alignment.LEADING)).addContainerGap(394, Short.MAX_VALUE)));
        CryptoPanelLayout.setVerticalGroup(CryptoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(CryptoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.extractEboot).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cryptoSavedata).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.extractPGD).addContainerGap(415, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(bundle.getString("SettingsGUI.CryptoPanel.title"), this.CryptoPanel);
        this.antiAliasLabel.setText(bundle.getString("SettingsGUI.antiAliasLabel.text"));
        this.antiAliasingBox.setModel(new DefaultComboBoxModel<String>(new String[]{"OFF", "x4", "x8", "x16"}));
        this.resolutionLabel.setText(bundle.getString("SettingsGUI.resolutionLabel.text"));
        this.resolutionBox.setModel(this.makeResolutions());
        this.fullscreenCheck.setText(bundle.getString("SettingsGUI.fullscreenCheck.text"));
        GroupLayout DisplayPanelLayout = new GroupLayout(this.DisplayPanel);
        this.DisplayPanel.setLayout(DisplayPanelLayout);
        DisplayPanelLayout.setHorizontalGroup(DisplayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(DisplayPanelLayout.createSequentialGroup().addContainerGap().addGroup(DisplayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fullscreenCheck).addGroup(DisplayPanelLayout.createSequentialGroup().addGroup(DisplayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(DisplayPanelLayout.createSequentialGroup().addComponent(this.antiAliasLabel, -2, 1, Short.MAX_VALUE).addGap(28, 28, 28)).addComponent(this.resolutionLabel)).addGroup(DisplayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.antiAliasingBox, 0, -1, Short.MAX_VALUE).addComponent(this.resolutionBox, 0, -1, Short.MAX_VALUE)))).addGap(1318, 1318, 1318)));
        DisplayPanelLayout.setVerticalGroup(DisplayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(DisplayPanelLayout.createSequentialGroup().addContainerGap().addGroup(DisplayPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.antiAliasLabel).addComponent(this.antiAliasingBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(DisplayPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resolutionBox, -2, -1, -2).addComponent(this.resolutionLabel)).addGap(18, 18, 18).addComponent(this.fullscreenCheck).addContainerGap(385, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(bundle.getString("SettingsGUI.DisplayPanel.title"), this.DisplayPanel);
        this.cancelButton.setText(bundle.getString("CancelButton.text"));
        this.cancelButton.setParent(this);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(395, Short.MAX_VALUE).addComponent(this.jButtonOK, -1, 105, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -1, 132, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonApply, -1, 124, Short.MAX_VALUE)).addComponent(this.jTabbedPane1, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonApply).addComponent(this.jButtonOK).addComponent(this.cancelButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    public void RefreshWindow() {
        this.setAllComponentsFromSettings();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.setAllComponentsToSettings();
        this.dispose();
    }

    private void jButtonApplyActionPerformed(ActionEvent evt) {
        this.setAllComponentsToSettings();
    }

    private void tmpPathBrowseButtonActionPerformed(ActionEvent evt) {
        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
        FolderChooser folderChooser = new FolderChooser(bundle.getString("SettingsGUI.strSelectTMPPath.text"));
        int result = folderChooser.showSaveDialog((Component)this.tmpPathBrowseButton.getTopLevelAncestor());
        if (result == 0) {
            this.tmppath.setText(folderChooser.getSelectedFile().getPath());
        }
    }

    private void btnUMDPathAddActionPerformed(ActionEvent evt) {
        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
        FolderChooser folderChooser = new FolderChooser(bundle.getString("SettingsGUI.strSelectUMDPath.text"));
        int result = folderChooser.showSaveDialog((Component)this.lbUMDPaths.getTopLevelAncestor());
        if (result == 0) {
            DefaultListModel dlm = (DefaultListModel)this.lbUMDPaths.getModel();
            File pathtoadd = folderChooser.getSelectedFile();
            for (int i = 0; i < this.lbUMDPaths.getModel().getSize(); ++i) {
                File check = new File((String)this.lbUMDPaths.getModel().getElementAt(i));
                if (!check.equals(pathtoadd)) continue;
                JpcspDialogManager.showInformation(this, ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString("SettingsGUI.strPathInList.text"));
                return;
            }
            dlm.addElement(pathtoadd.getPath());
        }
    }

    private void btnUMDPathRemoveActionPerformed(ActionEvent evt) {
        DefaultListModel dlm = (DefaultListModel)this.lbUMDPaths.getModel();
        dlm.remove(this.lbUMDPaths.getSelectedIndex());
    }

    @Override
    public void dispose() {
        Emulator.getMainGUI().endWindowDialog();
        super.dispose();
    }
}

