﻿<%@ WebHandler Language="C#" Class="CascadeSchool_handler" %>

using System;
using System.Web;

public class CascadeSchool_handler : IHttpHandler {
    
    public void ProcessRequest (HttpContext context) {
        context.Response.ContentType = "text/plain";

        if (context.Request["cascadeSchool"] != null)
        {
            RecordDataService.Teacher_Service service = new RecordDataService.Teacher_Service();
            System.Data.DataTable data = service.Fill(context.Request["cascadeSchool"].ToString());
            System.Text.StringBuilder sb = new System.Text.StringBuilder();
            sb.Append(String.Format("<option value='' selected='selected'>选择</option>"));
            foreach (System.Data.DataRow row in data.Rows)
                sb.Append(String.Format("<option value='{0}'>{1}</option>", row[0], row[1]));

            Jayrock.Json.JsonObject json = new Jayrock.Json.JsonObject();
            json.Accumulate("state", 1);
            json.Accumulate("value", sb.ToString());
            context.Response.Write(json);
            context.Response.End();
        }
    }
 
    public bool IsReusable {
        get {
            return false;
        }
    }

}