---------- // No Unitframe Combat Text // ----------

PetHitIndicator:ClearAllPoints() PlayerHitIndicator:ClearAllPoints()

---------- // ChatTab // ----------

local f = CreateFrame("Frame")
f:RegisterEvent("VARIABLES_LOADED")
f:SetScript("OnEvent", function(self, e, ...)
	if (e == "VARIABLES_LOADED") then
		-- Set Alpha of faded tabs to 0
		CHAT_FRAME_TAB_NORMAL_NOMOUSE_ALPHA = 0
		CHAT_FRAME_TAB_SELECTED_NOMOUSE_ALPHA = 0
		 
		for _, i in ipairs(CHAT_FRAMES) do
			FCFTab_UpdateAlpha(_G[i])
		end
		
		-- Hide Micro Button
		FriendsMicroButton:Hide()
		
		-- Move B.NET Alert frame down due to Friend button being hidden
		BN_TOAST_TOP_OFFSET = 10
	end
end)

	
---------- // Hide Faction/PvP Icon // ----------

PlayerPVPIcon:SetAlpha(0)
TargetFrameTextureFramePVPIcon:SetAlpha(0)
FocusFrameTextureFramePVPIcon:SetAlpha(0)

---------- // Auto Repair // ----------

local g = CreateFrame("Frame")
g:RegisterEvent("MERCHANT_SHOW")

g:SetScript("OnEvent", function()  
        local bag, slot
        for bag = 0, 4 do
                for slot = 0, GetContainerNumSlots(bag) do
                        local link = GetContainerItemLink(bag, slot)
                        if link and (select(3, GetItemInfo(link)) == 0) then
                                UseContainerItem(bag, slot)
                        end
                end
        end

        if(CanMerchantRepair()) then
                local cost = GetRepairAllCost()
                if cost > 0 then
                        local money = GetMoney()
                        if IsInGuild() then
                                local guildMoney = GetGuildBankWithdrawMoney()
                                if guildMoney > GetGuildBankMoney() then
                                        guildMoney = GetGuildBankMoney()
                                end
                                if guildMoney > cost and CanGuildBankRepair() then
                                        RepairAllItems(1)
                                        print(format("|cfff07100Repair cost covered by G-Bank: %.1fg|r", cost * 0.0001))
                                        return
                                end
                        end
                        if money > cost then
                                RepairAllItems()
                                print(format("|cffead000Repair cost: %.1fg|r", cost * 0.0001))
                        else
                                print("Not enough gold to cover the repair cost.")
                        end
                end
        end
end)

---------- // Hide Errors // ----------

local event = CreateFrame"Frame"
local dummy = function() end

UIErrorsFrame:UnregisterEvent"UI_ERROR_MESSAGE"
event.UI_ERROR_MESSAGE = function(self, event, error)
	if(not stuff[error]) then
		UIErrorsFrame:AddMessage(error, 1, .1, .1)
	end
end
	
event:RegisterEvent"UI_ERROR_MESSAGE"

---------- // Stance Bar // ----------

StanceBarFrame:ClearAllPoints()
StanceBarFrame:SetPoint("TOPLEFT", 30.4, 107)
StanceBarFrame:SetScale(116.0)
StanceBarFrame.SetPoint = function() end
       
---------- // Dragon Hide // ----------
local Version = 11

local function EventHandler(self, event, ...)

	if ( event == "PLAYER_ENTERING_WORLD" ) then
		self:UnregisterEvent("PLAYER_ENTERING_WORLD")

		MainMenuBarLeftEndCap:Hide()
		MainMenuBarRightEndCap:Hide()

		end
end

-- main
local frame = CreateFrame("Frame")
frame:RegisterEvent("PLAYER_ENTERING_WORLD")
frame:SetScript("OnEvent", EventHandler)





---------- // MINIMAP // ----------

local CF=CreateFrame("Frame")
	CF:RegisterEvent("PLAYER_ENTERING_WORLD")
	CF:SetScript("OnEvent", function(self, event)
		if not (IsAddOnLoaded("SexyMap")) then
			for i,v in pairs({
				MinimapBorder,
				MiniMapMailBorder,
				QueueStatusMinimapButtonBorder,
				select(1, TimeManagerClockButton:GetRegions()), 
				select(1, GameTimeFrame:GetRegions()),
              		}) do
                 		v:SetVertexColor(.3, .3, .3)
			end    
			MinimapBorderTop:Hide()
			MinimapZoomIn:Hide()
			MinimapZoomOut:Hide()
			MiniMapWorldMapButton:Hide()
			GameTimeFrame:Hide()
			GameTimeFrame:UnregisterAllEvents()
			GameTimeFrame.Show = kill
			MiniMapTracking:Hide()
			MiniMapTracking.Show = kill
			MiniMapTracking:UnregisterAllEvents()
			MinimapZoneText:SetPoint("TOPLEFT","MinimapZoneTextButton","TOPLEFT", 5, 5) -- to center the minimap zone text
			Minimap:EnableMouseWheel(true)
			Minimap:SetScript("OnMouseWheel", function(self, z)
				local c = Minimap:GetZoom()
				if(z > 0 and c < 5) then
					Minimap:SetZoom(c + 1)
				elseif(z < 0 and c > 0) then
					Minimap:SetZoom(c - 1)
				end
			end)
			Minimap:SetScript("OnMouseUp", function(self, btn)
				if btn == "RightButton" then
					_G.GameTimeFrame:Click()
				elseif btn == "MiddleButton" then
					_G.ToggleDropDownMenu(1, nil, _G.MiniMapTrackingDropDown, self)
				else
					_G.Minimap_OnClick(self)
				end
			end)
		end
	end)


---------- // Dark Main Bar // ----------

	for i,v in pairs({
		SlidingActionBarTexture0,
		
		SlidingActionBarTexture1,
		
        	MainMenuBarTexture0,
		MainMenuBarTexture1,
		MainMenuBarTexture2,
		MainMenuBarTexture3,
        	MainMenuMaxLevelBar0,
        	MainMenuMaxLevelBar1,
		MainMenuMaxLevelBar2,
		MainMenuMaxLevelBar3,
		MainMenuXPBarTextureLeftCap,
		MainMenuXPBarTextureRightCap,
		MainMenuXPBarTextureMid,
		ReputationWatchBarTexture0,
		ReputationWatchBarTexture1,
		ReputationWatchBarTexture2,
		ReputationWatchBarTexture3,
		ReputationXPBarTexture0,
		ReputationXPBarTexture1,
		ReputationXPBarTexture2,
		ReputationXPBarTexture3,	
	}) do

                 v:SetVertexColor(.3, .3, .3)
  
	end 	
	for i=1,19 do _G["MainMenuXPBarDiv"..i]:SetTexture(Empty_Art) end
	ExhaustionTick:SetAlpha(0)
        for i,v in pairs({
		MainMenuBarLeftEndCap,
                MainMenuBarRightEndCap, 
		StanceBarLeft,
		
		StanceBarMiddle,
		
		StanceBarRight, 
	}) do
                v:SetVertexColor(.35, .35, .35)
	end 

-- Dark Arena Frames
	local CF = CreateFrame("Frame")
	local _, instanceType = IsInInstance()
	CF:RegisterEvent("ADDON_LOADED")
	CF:RegisterEvent("PLAYER_ENTERING_WORLD")
	CF:RegisterEvent("ARENA_PREP_OPPONENT_SPECIALIZATIONS")
        CF:SetScript("OnEvent", function(self, event, addon)
             	if addon == "Blizzard_ArenaUI" and not (IsAddOnLoaded("Shadowed Unit Frames")) then
			for i,v in pairs({
 				ArenaEnemyFrame1Texture,
				ArenaEnemyFrame2Texture,
				ArenaEnemyFrame3Texture, 
				ArenaEnemyFrame4Texture,
				ArenaEnemyFrame5Texture,
				ArenaEnemyFrame1SpecBorder,
				ArenaEnemyFrame2SpecBorder,
				ArenaEnemyFrame3SpecBorder,
				ArenaEnemyFrame4SpecBorder,
				ArenaEnemyFrame5SpecBorder,
				ArenaEnemyFrame1PetFrameTexture,
				ArenaEnemyFrame2PetFrameTexture,
				ArenaEnemyFrame3PetFrameTexture,
				ArenaEnemyFrame4PetFrameTexture, 
				ArenaEnemyFrame5PetFrameTexture,
              		}) do
                		v:SetVertexColor(.3, .3, .3)
	      		end 
		elseif event == "ARENA_PREP_OPPONENT_SPECIALIZATIONS" or (event == "PLAYER_ENTERING_WORLD" and instanceType == "arena") then
			for i,v in pairs({
				ArenaPrepFrame1Texture,
				ArenaPrepFrame2Texture,
				ArenaPrepFrame3Texture,
				ArenaPrepFrame4Texture,
				ArenaPrepFrame5Texture,
				ArenaPrepFrame1SpecBorder,
				ArenaPrepFrame2SpecBorder,
				ArenaPrepFrame3SpecBorder,
				ArenaPrepFrame4SpecBorder,
				ArenaPrepFrame5SpecBorder,
			}) do
                		v:SetVertexColor(.3, .3, .3)
	      		end 		
		end 
	end)

-- Dark Frames
local frame=CreateFrame("Frame")
frame:RegisterEvent("ADDON_LOADED")

frame:SetScript("OnEvent", function(self, event, addon)
        if (addon == "Blizzard_TimeManager") then
                for i, v in pairs({PlayerFrameTexture, TargetFrameTextureFrameTexture, PetFrameTexture, PartyMemberFrame1Texture, PartyMemberFrame2Texture, PartyMemberFrame3Texture, PartyMemberFrame4Texture,
                        PartyMemberFrame1PetFrameTexture, PartyMemberFrame2PetFrameTexture, PartyMemberFrame3PetFrameTexture, PartyMemberFrame4PetFrameTexture, FocusFrameTextureFrameTexture,
                        TargetFrameToTTextureFrameTexture, FocusFrameToTTextureFrameTexture, BonusActionBarFrameTexture0, BonusActionBarFrameTexture1, BonusActionBarFrameTexture2, BonusActionBarFrameTexture3,
                        BonusActionBarFrameTexture4, MainMenuBarTexture0, MainMenuBarTexture1, MainMenuBarTexture2, MainMenuBarTexture3, MainMenuMaxLevelBar0, MainMenuMaxLevelBar1, MainMenuMaxLevelBar2,
                        MainMenuMaxLevelBar3, MinimapBorder, CastingBarFrameBorder, FocusFrameSpellBarBorder, TargetFrameSpellBarBorder, MiniMapTrackingButtonBorder, MiniMapLFGFrameBorder, MiniMapBattlefieldBorder,
                        MiniMapMailBorder, MinimapBorderTop,
                        select(1, TimeManagerClockButton:GetRegions())
                }) do
                        v:SetVertexColor(.4, .4, .4)
                end

                for i,v in pairs({ select(2, TimeManagerClockButton:GetRegions()) }) do
                        v:SetVertexColor(1, 1, 1)
                end

                self:UnregisterEvent("ADDON_LOADED")
                frame:SetScript("OnEvent", nil)
        end
end)

for i, v in pairs({ MainMenuBarLeftEndCap, MainMenuBarRightEndCap }) do
        v:SetVertexColor(.35, .35, .35)
end
	


---------- // Class Color Frames // ----------


--HIDE COLORS BEHIND NAME
hooksecurefunc("TargetFrame_CheckFaction", function(self)
    self.nameBackground:SetVertexColor(0.0, 0.0, 0.0, 0.5);
end)

-- CLASS COLOR HP BAR
local function colour(statusbar, unit)
        local _, class, c
        if UnitIsPlayer(unit) and UnitIsConnected(unit) and unit == statusbar.unit and UnitClass(unit) then
                _, class = UnitClass(unit)
                c = CUSTOM_CLASS_COLORS and CUSTOM_CLASS_COLORS[class] or RAID_CLASS_COLORS[class]
                statusbar:SetStatusBarColor(c.r, c.g, c.b)
                --PlayerFrameHealthBar:SetStatusBarColor(0,1,0)
        end
end

hooksecurefunc("UnitFrameHealthBar_Update", colour)
hooksecurefunc("HealthBar_OnValueChanged", function(self)
        colour(self, self.unit)
end)


---------- // Mail // ----------


local f = CreateFrame('Button', nil, InboxFrame, 'UIPanelButtonTemplate')
f:SetPoint('TOPRIGHT', -58, -30)
f:SetSize(100, 22)
f:SetText(OPENMAIL)

local totalMoney = 0
local processing = false
local function OnEvent()
    if (not MailFrame:IsShown()) then
        return
    end

    local num = GetInboxNumItems()
    if (processing) then
        if (num == 0) then
            MiniMapMailFrame:Hide()
            processing = false
            return
        end

        for i = num, 1, -1 do
            local _, _, _, _, money, COD, _, item = GetInboxHeaderInfo(i)
            if (item and COD < 1) then
                TakeInboxItem(i)
                return
            end

            if (money > 0) then
                totalMoney = totalMoney + money
                TakeInboxMoney(i)
                return
            end
        end

        if (totalMoney > 0) then
            local chatWindowFontSize = select(2, GetChatWindowInfo(1))
            DEFAULT_CHAT_FRAME:AddMessage('Total money collected from mailbox was '..GetCoinTextureString(totalMoney, chatWindowFontSize)..'.')
        end
    end
end

f:RegisterEvent('MAIL_INBOX_UPDATE')
f:SetScript('OnEvent', OnEvent)
f:SetScript('OnClick', function(self)
    if (not processing) then
        totalMoney = 0
        processing = true
        OnEvent()
    end
end)

f:SetScript('OnHide', function(self)
    processing = false
end)


---------- // Grid // ----------

-- Slah Command for activation - Usage : /sgrid <value>
SLASH_SGRIDA1 = "/sgrid"

-- local variables for frame and line points
local frame
local w
local h

SlashCmdList["SGRIDA"] = function(msg, editbox)
	-- hiding grid if already enabled
	if frame then
		frame:Hide()
		frame = nil
	else
	-- cases for grid size
		if msg == '128' then
			w = 128
			h = 72
		elseif msg == '96' then
			w = 96
			h = 54
		elseif msg == '64' then
			w = 64
			h = 36
		elseif msg == '32' then
			w = 32
			h = 18
		else
		-- grid size reset
			w = nil
			w = nil
		end
		-- check for corrrect grid case, if incorrect print usage and end
		if w == nil then
			print("Usage: '/sgrid <value>' Value options are 32/64/96/128")
		else
		-- determin grid line points
			local lines_w = GetScreenWidth() / w
			local lines_h = GetScreenHeight() / h
		-- create frame
			frame = CreateFrame('Frame', nil, UIParent)
			frame:SetAllPoints(UIParent)
		-- build horizontal lines
			for i = 0, w do
				local line_texture = frame:CreateTexture(nil, 'BACKGROUND')
				if i == w/2 then
					line_texture:SetColorTexture(1, 0, 0, 0.5)
				else
					line_texture:SetColorTexture(0, 0, 0, 0.1)
				end
				line_texture:SetPoint('TOPLEFT', frame, 'TOPLEFT', i * lines_w - 1, 0)
				line_texture:SetPoint('BOTTOMRIGHT', frame, 'BOTTOMLEFT', i * lines_w + 1, 0)
			end
		-- build vertical lines
			for i = 0, h do
				local line_texture = frame:CreateTexture(nil, 'BACKGROUND')
				if i == h/2 then
					line_texture:SetColorTexture(1, 0, 0, 0.5)
				else
					line_texture:SetColorTexture(0, 0, 0, 0.5)
				end
					line_texture:SetPoint('TOPLEFT', frame, 'TOPLEFT', 0, -i * lines_h + 1)
					line_texture:SetPoint('BOTTOMRIGHT', frame, 'TOPRIGHT', 0, -i * lines_h - 1)
			end
		end
	end
end



---------- // UF Name Color // ----------

for i, f in pairs({TargetFrame, PlayerFrame, FocusFrame}) do f.name:SetVertexColor(1,10,10) end

---------- // Class Icon Unitframes // ----------

hooksecurefunc("UnitFramePortrait_Update",function(self)
	if self.portrait then
		if UnitIsPlayer(self.unit) then			
			local t = CLASS_ICON_TCOORDS[select(2,UnitClass(self.unit))]
			if t then
				self.portrait:SetTexture("Interface\\TargetingFrame\\UI-Classes-Circles")
				self.portrait:SetTexCoord(unpack(t))
			end
		else
			self.portrait:SetTexCoord(0,1,0,1)
		end
	end
end);




---------- // Hide Talent Alert // ----------


local NAME = ...
local db

-- TalentMicroButton:EvaluateAlertVisibility() doesnt work the way we want it to
-- its mostly the talents that show a popup, leave the rest alone
local buttons = {
	TalentMicroButton = true,
	--CollectionsMicroButton = true, -- already gets remembered
	--LFDMicroMicroButton = true,
	--EJMicroMicroButton = true,
}

local f = CreateFrame("Frame")

function f:OnEvent(event, addon)
	if event == "ADDON_LOADED" then
		if addon ~= NAME then return end
		
		-- init savedvariables per character
		HideTalentAlertDB = HideTalentAlertDB or {}
		db = HideTalentAlertDB
		
		-- onclick alert closebutton
		for k in pairs(buttons) do
			_G[k.."Alert"].CloseButton:HookScript("OnClick", function()
				db[k] = true -- remember it
				MicroButtonPulseStop(_G[k]) -- simultaneously stop the button from pulsing, once you press the closebutton
			end)
		end
		
		-- showed talentframe
		hooksecurefunc("ToggleTalentFrame", function()
			db.TalentMicroButton = true -- remember it
		end)
		
		-- hide alert
		hooksecurefunc("MainMenuMicroButton_ShowAlert", function(alert)
			if db[alert.MicroButton:GetName()] then
				alert:Hide() -- hide it
			end
		end)
		
		-- hide pulse
		hooksecurefunc("MicroButtonPulse", function(self)
			if db[self:GetName()] then
				MicroButtonPulseStop(self) -- stop it
			end
		end)
		
		self:UnregisterEvent(event)
		
	elseif event == "PLAYER_LEVEL_UP" then
		-- player might have a new talent; not sure how honor talents work though
		wipe(db)
	end
end

f:RegisterEvent("ADDON_LOADED")
f:RegisterEvent("PLAYER_LEVEL_UP")
f:SetScript("OnEvent", f.OnEvent)



