-- yMerchant v0.7 by YLeaf
local addon = CreateFrame('Frame')
addon:SetScript('OnEvent', function(self, event, ...) if self[event] then return self[event](self, ...) end end)
addon:RegisterEvent('MERCHANT_SHOW')
addon:RegisterEvent('PLAYER_ENTERING_WORLD')

local AutoSellJunk = true
local AutoRepair = true
local UseGuildBank = true
local AutoHideTracker = true
local _G = _G

local CustomSellList = {
	--[itemID] = true,
	--[17058] = true, -- Fish Oil
}

function addon:MERCHANT_SHOW()
	if AutoSellJunk then
		for bag = 0, 4 do
			for slot = 0, GetContainerNumSlots(bag) do
				local link = GetContainerItemLink(bag, slot)
				if link then
					local id = tonumber(link:match'item:(%d+):')
					if select(3, GetItemInfo(id)) == 0 or CustomSellList[id] then
						ShowMerchantSellCursor(1)
						UseContainerItem(bag, slot)
					end
				end
			end
		end
	end
	if AutoRepair and CanMerchantRepair() then
		local cost, canRepair = GetRepairAllCost()
		if canRepair then
			local str = GetCoinTextureString(cost, 10)			-- GetMoneyString
			local limit = GetGuildBankWithdrawMoney()
			local money = GetGuildBankMoney()
			if UseGuildBank and IsInGuild() and CanGuildBankRepair() and ((limit == -1 and money >= cost) or min(limit, money) >= cost) then
				RepairAllItems(1)
				str = '公款修理：' .. str
			elseif GetMoney() >= cost then
				RepairAllItems()
				str = '自费修理：' .. str
			else
				DEFAULT_CHAT_FRAME:AddMessage('修理需要：' .. str)
				return
			end
			PlaySound('ITEM_REPAIR')
			DEFAULT_CHAT_FRAME:AddMessage(str)
		end
	end
end

function addon:PLAYER_ENTERING_WORLD()
	local frame = ObjectiveTrackerFrame
	if not AutoHideTracker or not frame then return end
	if IsInInstance() and not frame.collapsed then
		ObjectiveTracker_Collapse()
	elseif not IsInInstance() and frame.collapsed then
		ObjectiveTracker_Expand()
	end
end

-- AH helper
local function auctionUpdate()
	local numBatchAuctions = GetNumAuctionItems("list")
	local offset = FauxScrollFrame_GetOffset(BrowseScrollFrame)
	for i = 1, NUM_BROWSE_TO_DISPLAY do
		local index = offset + i + (NUM_AUCTION_ITEMS_PER_PAGE * AuctionFrameBrowse.page)
		if index <= numBatchAuctions + (NUM_AUCTION_ITEMS_PER_PAGE * AuctionFrameBrowse.page) then
			local name, _, count, _, _, _, _, _, _, buyoutPrice, bidAmount =  GetAuctionItemInfo("list", offset + i)
			local alpha = 0.5
			local color = "yellow"
			if name then
				local itemName = _G["BrowseButton"..i.."Name"]
				local moneyFrame = _G["BrowseButton"..i.."MoneyFrame"]
				local buyoutMoney = _G["BrowseButton"..i.."BuyoutFrameMoney"]
				if (buyoutPrice/10000) >= 5000 then color = "red" end
				if bidAmount > 0 then
					name = name .. " |cffffff00拍|r"
					alpha = 1.0
				end
				if (buyoutPrice > 0) and (count > 1) then
					name = name .. " |cffffff00"..GetCoinTextureString(ceil(buyoutPrice/count), 10).."|r"		-- GetMoneyString
				end
				itemName:SetText(name)
				moneyFrame:SetAlpha(alpha)
				SetMoneyFrameColor(buyoutMoney:GetName(), color)
			end
		end
	end
end

local loaded = false
hooksecurefunc("AuctionFrame_LoadUI", function()
    if loaded then
        return
    else
		loaded = true
		hooksecurefunc("AuctionFrameBrowse_Update", auctionUpdate)
	end
end)


-- ArtifactFrame and Artifact Power
local function openArtifactFrame()
	local currentWeapon = GetInventoryItemID("player", GetInventorySlotInfo("MainHandSlot"))
	if currentWeapon == nil then return end
	local name, link, quality = GetItemInfo(currentWeapon)
	if name and quality == LE_ITEM_QUALITY_ARTIFACT then
		SocketInventoryItem(16)
	end
end

local function ArtifactFrame_Toggle()
	if ArtifactFrame and ArtifactFrame:IsShown() then
		C_ArtifactUI.Clear()
	else
		openArtifactFrame()
	end
end

GarrisonLandingPageMinimapButton:RegisterForClicks("LeftButtonUp", "RightButtonUp")
GarrisonLandingPageMinimapButton:SetScript("OnClick", function(self, button)
	if button == "RightButton" then
		ArtifactFrame_Toggle()
	else
		GarrisonLandingPage_Toggle()
	end
end)

hooksecurefunc("MainMenuBar_ArtifactUpdateOverlayFrameText", function()
	if ArtifactWatchBar.OverlayFrame.Text:IsShown() then
		local xp = ArtifactWatchBar.StatusBar:GetAnimatedValue()
		local _, xpForNextPoint = ArtifactWatchBar.StatusBar:GetMinMaxValues()
		if xpForNextPoint > 0 then
			local text = ArtifactWatchBar.OverlayFrame.Text:GetText()
			local _, _, _, _, totalXP, pointsSpent = C_ArtifactUI.GetEquippedArtifactInfo()
			for i = 0, pointsSpent - 1 do
				totalXP = totalXP + C_ArtifactUI.GetCostForPointAtRank(i)
			end
			text = text .. "    ( 总计：" .. totalXP.. " / 升级：" .. xpForNextPoint - xp .. " )"
			ArtifactWatchBar.OverlayFrame.Text:SetText(text)
		end
	end
end)


-- Focuser v0.51 by slizen
local modifier = "shift" -- shift, alt or ctrl
local mouseButton = "1" -- 1 = left, 2 = right, 3 = middle, 4 and 5 = thumb buttons if there are any

local function SetFocusHotkey(frame)
	frame:SetAttribute(modifier.."-type"..mouseButton, "focus")
end

local function CreateFrame_Hook(type, name, parent, template)
	if name and template == "SecureUnitButtonTemplate" then
		SetFocusHotkey(_G[name])
	end
end

hooksecurefunc("CreateFrame", CreateFrame_Hook)

local f = CreateFrame("CheckButton", "FocuserButton", UIParent, "SecureActionButtonTemplate")
f:SetAttribute("type1", "macro")
f:SetAttribute("macrotext", "/focus mouseover")
SetOverrideBindingClick(FocuserButton, true, modifier.."-BUTTON"..mouseButton, "FocuserButton")

local duf = {
	PetFrame,
	PartyMemberFrame1,
	PartyMemberFrame2,
	PartyMemberFrame3,
	PartyMemberFrame4,
	PartyMemberFrame1PetFrame,
	PartyMemberFrame2PetFrame,
	PartyMemberFrame3PetFrame,
	PartyMemberFrame4PetFrame,
	PartyMemberFrame1TargetFrame,
	PartyMemberFrame2TargetFrame,
	PartyMemberFrame3TargetFrame,
	PartyMemberFrame4TargetFrame,
	TargetFrame,
	TargetFrameToT,
}

for i, frame in pairs(duf) do
	SetFocusHotkey(frame)
end