--[[
	Cloudy Trade Skill
	Copyright (c) 2016, Cloudyfa
	All rights reserved.
]]


--- Variables ---
local itemDisplay = 30
local numTabs = 0
local subList = {
	[333] = true,  	-- Enchanting ħֽ⣩--
	[755] = true,  	-- Jewelcrafting 鱦ӹѡ--
	[773] = true,  	-- Inscription ģĥ--
	[185] = true,    	-- Cooking ⿣û--
}

--- Create Frame ---
local f = CreateFrame('Frame', 'CloudyTradeSkill')
f:RegisterEvent('TRADE_SKILL_SHOW')
f:RegisterEvent('TRADE_SKILL_LIST_UPDATE')

--- Local Functions ---
--- Check Current Tab ---
local function isCurrentTab(self)
	if self.tooltip and IsCurrentSpell(self.tooltip) then
		self:SetChecked(true)
	else
		self:SetChecked(false)
	end
end

--- Add Tab Button ---
local function addTab(id, index, isSub)
	local name, _, icon = GetSpellInfo(id)
	if (not name) or (not icon) then return end

	local tab = _G['CTradeSkillTab' .. index] or CreateFrame('CheckButton', 'CTradeSkillTab' .. index, TradeSkillFrame, 'SpellBookSkillLineTabTemplate,SecureActionButtonTemplate')
	tab:SetPoint('TOPLEFT', TradeSkillFrame, 'TOPRIGHT', 1, -41 + (-44 * index) + (-32 * isSub))

	tab:SetScript('OnEvent', isCurrentTab)
	tab:RegisterEvent('CURRENT_SPELL_CAST_CHANGED')

	tab.id = id
	tab.tooltip = name
	tab:SetAttribute('type', 'spell')
	tab:SetAttribute('spell', name)
	tab:SetNormalTexture(icon)
	tab:Show()

	isCurrentTab(tab)
end

--- Remove Tab Buttons ---
local function removeTabs()
	for i = 1, numTabs do
		local tab = _G['CTradeSkillTab' .. i]
		if tab and tab:IsShown() then
			tab:UnregisterEvent('CURRENT_SPELL_CAST_CHANGED')
			tab:Hide()
		end
	end
end

--- Check Profession Useable ---
local function isUseable(id)
	local name = GetSpellInfo(id)
	return IsUsableSpell(name)
end

--- Update Profession Tabs ---
local function updateTabs()
	local mainTabs, subTabs = {}, {}

	local _, class = UnitClass('player')
	if class == 'DEATHKNIGHT' and isUseable(53428) then
		mainTabs[1] = 53428 					--RuneForging
	elseif class == 'ROGUE' and isUseable(1804) then
		subTabs[1] = 1804 					--PickLock
	end

	local prof1, prof2, arch, fishing, cooking, firstaid = GetProfessions()
	local profs = {prof1, prof2, cooking, firstaid}
	for _, prof in pairs(profs) do
		local num, offset, skillLine = select(5, GetProfessionInfo(prof))
		for i = 1, num do
			if not IsPassiveSpell(offset + i, BOOKTYPE_PROFESSION) then
				local _, id = GetSpellBookItemInfo(offset + i, BOOKTYPE_PROFESSION)
				if (i == 1) then
					mainTabs[#mainTabs + 1] = id
				elseif subList[skillLine] then
					subTabs[#subTabs + 1] = id
				end
			end
		end
	end

	local sameTabs = true
	for i = 1, #mainTabs do
		local tab = _G['CTradeSkillTab' .. i]
		if tab and not (tab.id == mainTabs[i]) then
			sameTabs = false
			break
		end
	end

	if not sameTabs or not (numTabs == #mainTabs + #subTabs) then
		removeTabs()
		numTabs = #mainTabs + #subTabs
		for i = 1, numTabs do
			addTab(mainTabs[i] or subTabs[i - #mainTabs], i, mainTabs[i] and 0 or 1)
		end
	end
end


--- Fix SearchBox ---
hooksecurefunc('ChatEdit_InsertLink', function(link)
	if link and TradeSkillFrame and TradeSkillFrame:IsShown() then
		local text = strmatch(link, '|h%[(.+)%]|h|r')
		if text then
			text = strmatch(text, ':%s(.+)') or text
			TradeSkillFrame.SearchBox:SetText(text:lower())
		end
	end
end)


--- Fix RecipeLink ---
local getRecipe = C_TradeSkillUI.GetRecipeLink
C_TradeSkillUI.GetRecipeLink = function(link)
	if link and (link ~= '') then
		return getRecipe(link)
	end
end


--- Modify Default Frame ---
local function modifyFrame()
	TradeSkillFrame:SetHeight(itemDisplay * 16 + 96) --496
	TradeSkillFrame.RecipeInset:SetHeight(itemDisplay * 16 + 10) --410
	TradeSkillFrame.DetailsInset:SetHeight(itemDisplay * 16 - 10) --390
	TradeSkillFrame.DetailsFrame:SetHeight(itemDisplay * 16 - 15) --385
	TradeSkillFrame.DetailsFrame.Background:SetHeight(itemDisplay * 16 - 17) --383
	hooksecurefunc('HybridScrollFrame_Update', function(self, ...)
		if TradeSkillFrame and self == TradeSkillFrame.RecipeList then
			if self.FilterBar:IsVisible() then
				self:SetHeight(itemDisplay * 16 - 11) --389
			else
				self:SetHeight(itemDisplay * 16 + 5) --405
			end
		end
	end)
end


--- Handle Events ---
f:SetScript('OnEvent', function(self, event, ...)
	if event == 'TRADE_SKILL_SHOW' then
		if TradeSkillFrame then
			TradeSkillFrame.SearchBox:SetWidth(205)
			modifyFrame()
			self:UnregisterEvent('TRADE_SKILL_SHOW')
		end
	elseif (event == 'TRADE_SKILL_LIST_UPDATE') then
		if TradeSkillFrame and TradeSkillFrame.RecipeList then
			if TradeSkillFrame.RecipeList.buttons and #TradeSkillFrame.RecipeList.buttons ~= (itemDisplay + 2) then
				HybridScrollFrame_CreateButtons(TradeSkillFrame.RecipeList, 'TradeSkillRowButtonTemplate', 0, 0)
			end
			if not InCombatLockdown() then updateTabs() end
		end
	end
end)