-- IDCard v1.5 by tardmrr

local registry = {}

local hookfactory = function(hook, orig)
	return function(self, ...)
		local reg = registry[self]
		if reg[orig] then reg[orig](self, ...) end
		hook(reg.button, self, ...)
	end
end

local function colorBorder(self, link)
	local quality = select(3, GetItemInfo(link))
	if not quality then return end
	local r, g, b = GetItemQualityColor(quality)
	self:SetBackdropBorderColor(r, g, b)
	self:SetBackdropColor(0, 0, 0, 1)
end

local function addSpellID(self, id)
	local found = false
	for i = 1, 15 do
		local frame = _G[self:GetName() .. "TextLeft" .. i]
		local text
		if frame then text = frame:GetText() end
		if text and text == "SpellID:" then found = true break end
	end
	if not found then
		self:AddDoubleLine("SpellID:", "|cffffffff" .. id)
		self:Show()
	end
end

local setItem = hookfactory(function(b, self)
	local link = select(2, self:GetItem())
	if link then
		b:SetNormalTexture(GetItemIcon(link))
		b.link = link
		b.type = "item"
		colorBorder(self, link)
	end
end, "setItem")

local function openToAchievement(link)
	if not (AchievementFrame and AchievementFrame:IsShown()) then ToggleAchievementFrame() end
	local id = tonumber(link:match("achievement:(%d+)"))
	if not id then return end
	AchievementFrame_SelectAchievement(id)
end

local cleared = hookfactory(function(b, self)
	b:SetNormalTexture(nil)
	b.achOverlay:Hide()
	b.type = nil
	b.link = nil
	self:SetBackdropBorderColor(1, 1, 1)        -- TOOLTIP_DEFAULT_COLOR
	self:SetBackdropColor(0.09, 0.09, 0.19 )    -- TOOLTIP_DEFAULT_BACKGROUND_COLOR
end, "cleared")

local setHyperlink = hookfactory(function(b, self, link)
	if not (link and type(link) == "string") then return end
	local linkType, id = link:match("^([^:]+):(%d+)")
	if linkType == "achievement" and id then
		b.link = GetAchievementLink(id)
		b:SetNormalTexture(select(10, GetAchievementInfo(id)))
		b.achOverlay:Show()
		b.type = "achievement"
	elseif linkType == "spell" and id then
		b.link = GetSpellLink(id)
		b:SetNormalTexture(select(3, GetSpellInfo(id)))
		b.type = "spell"
		addSpellID(self, id)
	end
end, "setHyperlink")

local function click(self)
	if IsModifiedClick("CHATLINK") and ACTIVE_CHAT_EDIT_BOX and self.link then
		ACTIVE_CHAT_EDIT_BOX:Insert(self.link)
	elseif IsModifiedClick("DRESSUP") and self.link then
		if     self.type == "item" then DressUpItemLink(self.link)
		elseif self.type == "achievement" then openToAchievement(self.link) end
	end
end

local function RegisterTooltip(tooltip)
	if registry[tooltip] then return end
	local reg = {}
	registry[tooltip] = reg

	local b = CreateFrame("Button", nil, tooltip)
	b:SetWidth(37)
	b:SetHeight(37)
	b:SetPoint("TOPRIGHT", tooltip, "TOPLEFT", 0, -3)
	b:SetScript("OnClick", click)
	reg.button = b

	local t = b:CreateTexture(nil, "OVERLAY")
	t:SetTexture("Interface\\AchievementFrame\\UI-Achievement-IconFrame")
	t:SetTexCoord(0, 0.5625, 0, 0.5625)
	t:SetPoint("CENTER", 0, 0)
	t:SetWidth(47)
	t:SetHeight(47)
	t:Hide()
	b.achOverlay = t

	reg.setItem = tooltip:GetScript("OnTooltipSetItem")
	reg.cleared = tooltip:GetScript("OnTooltipCleared")
	reg.setHyperlink = tooltip.SetHyperlink
	tooltip:SetScript("OnTooltipSetItem", setItem)
	tooltip:SetScript("OnTooltipCleared", cleared)
	tooltip.SetHyperlink = setHyperlink
end

RegisterTooltip(ItemRefTooltip)


-- Add more Info on Tooltip

local addIcon = function(self, icon)
	local title = icon and _G[self:GetName().."TextLeft1"]
	if title and not title:GetText():find('|T' .. icon) then
		title:SetFormattedText("|T%s:%d|t %s", icon, 24, title:GetText())
	end
end

local OnTooltipSetItem = function(self, ...)
	local link = select(2, self:GetItem())
	if link then
		colorBorder(self, link)
		local icon = GetItemIcon(link)          			-- local icon = select(10, GetItemInfo(link))
		if icon then addIcon(self, icon) end
	end
end

local OnTooltipSetSpell = function(self, ...)
	local id = select(3, self:GetSpell())
	if id then
		addIcon(self, select(3, GetSpellInfo(id)))
		addSpellID(self, id)
	end
end

for _, obj in next, {
	GameTooltip,
	ItemRefShoppingTooltip1,
	ItemRefShoppingTooltip2,
	ShoppingTooltip1,
	ShoppingTooltip2,
} do
	obj:HookScript("OnTooltipSetItem", OnTooltipSetItem)
end

GameTooltip:HookScript("OnTooltipSetSpell", OnTooltipSetSpell)

hooksecurefunc(GameTooltip, "SetUnitBuff", function(self, ...)
    local id = select(11, UnitBuff(...))
    if id then addSpellID(self, id) end
end)

hooksecurefunc(GameTooltip, "SetUnitDebuff", function(self, ...)
    local id = select(11, UnitDebuff(...))
    if id then addSpellID(self, id) end
end)

hooksecurefunc(GameTooltip, "SetUnitAura", function(self, ...)
    local id = select(11, UnitAura(...))
    if id then addSpellID(self, id) end
end)