-- Author: Ketho (EU-Boulderfist)
-- License: Public Domain

DefaultCompactNamePlateFriendlyFrameOptions.useClassColors = false

SetCVar("ShowClassColorInNameplate", 1)
C_Timer.After(.1, function()
	DefaultCompactNamePlateEnemyFrameOptions.useClassColors = true
	if not InCombatLockdown() then
		SetCVar("nameplateMaxDistance", 40)
		SetCVar("nameplateOtherTopInset", -1)
		SetCVar("nameplateOtherBottomInset", -1)
--		SetCVar("NamePlateHorizontalScale", 1.2)
--		SetCVar("NamePlateVerticalScale", 2)
	end
end)

local function levelColor(level, canAttack)
	local color = canAttack and GetQuestDifficultyColor(level) or NORMAL_FONT_COLOR
	return format("|cff%2x%2x%2x%s|r", color.r*255, color.g*255, color.b*255, level)
end

hooksecurefunc("CompactUnitFrame_UpdateName", function(frame)
	if not frame:GetName():find("NamePlate%d") then return end
	if frame.name:IsShown() then
		local isPlayer = UnitIsPlayer(frame.unit)
		local isFriend = UnitIsFriend("player", frame.unit)
		local class = select(2, UnitClass(frame.unit))
		local color = RAID_CLASS_COLORS[class]
		local name = GetUnitName(frame.unit)
		if not CompactUnitFrame_IsTapDenied(frame) and frame.optionTable.colorNameBySelection and isPlayer and isFriend and class then
			if class == "DEATHKNIGHT" then
				name = format(PLAYER_CLASS_NO_SPEC, "ffe03B57", name)   	-- ffe05252
			else
				name = format(PLAYER_CLASS_NO_SPEC, color.colorStr, name)
			end
		end
		local level = UnitLevel(frame.unit)
		if level and level >= 1 then
			level = levelColor(level, UnitCanAttack(frame.unit, PlayerFrame.unit))
			name = level .. " " .. name
		end
		frame.name:SetText(name)
	end
end)

hooksecurefunc("CompactUnitFrame_UpdateSelectionHighlight", function(frame)
	if not frame:GetName():find("NamePlate%d") then return end
	if not frame.marker then
		frame.marker = frame:CreateTexture(nil, "PARENT")
		frame.marker:SetPoint("BOTTOM", frame.healthBar, "TOP", 0, 42)
		frame.marker:SetSize(50, 50)
		frame.marker:SetAlpha(0)
	end
	if UnitIsUnit(frame.displayedUnit, "target") and not UnitIsUnit(frame.displayedUnit, PlayerFrame.unit) then
		if UnitIsFriend("player", frame.displayedUnit) then
			frame.marker:SetAtlas("worldquest-questmarker-abilityhighlight")
		else
			frame.marker:SetAtlas("worldquest-questmarker-glow")
		end
		frame.marker:SetAlpha(1)
	else
		frame.marker:SetAlpha(0)
	end
end)