﻿local colorbyclass = true									-- 血条按职业着色
local newLayout = true										-- 初始玩家/目标头像的位置，如需改动，请调整下面的坐标值或设为false后，手动移动
local pFrameX = -265											-- 初始玩家头像的X坐标
local pFrameY = -150											-- 初始玩家头像的Y坐标
local tFrameX = 265											-- 初始目标头像的X坐标
local tFrameY = -150											-- 初始目标头像的Y坐标
local ptFrameX = newLayout and 220 or 90				-- 初始队友头像的X坐标
local ptFrameY = -256										-- 初始队友头像的Y坐标
local frameScale = 1.2										-- 玩家/目标/队友头像的缩放比例
local hideCaps = true										-- 隐藏主动作条两边的狮鹫并将右侧动作条稍微上移
local iURCEnable = true										-- 队友/目标/焦点超出治疗范围，框体变淡（仅作用于治疗职业）
local showPlayerSpeed = true								-- 显示玩家移动速度
local showTargetSpeed = true								-- 显示目标移动速度
local hasTarget, updateElapsed, lastPlayerSpeed, lastTargetSpeed
local playerUnit = "player"

local function localizeV(value)
	if value >= 1e8 then
		return ("%.2f亿"):format(value / 1e8)
	elseif value >= 1e4 then
		return ('%.2f万'):format(value / 1e4)
	else
		return ("%d"):format(value)
	end
end

local function textUpdate(bar)
	local textType = GetCVar("statusTextDisplay")
	local frame = bar:GetParent()
	local value = bar:GetValue()
	local _, max = bar:GetMinMaxValues()
	if bar.pctText then
		bar.pctText:SetText((textType ~= "NUMERIC" or value == 0) and "" or tostring(math.ceil((value / max) * 100)) .. "%")
	end
	if bar.TextString and frame.addPctText and textType == "NUMERIC" then
		bar.TextString:SetText(value == 0 and "" or localizeV(value))
	end
end

local function colorHPBar(bar, unit)
	if bar and not bar.lockValues and unit == bar.unit then
		local r, g, b
		local min, max = bar:GetMinMaxValues()
		local value = bar:GetValue()
		if max > min then
			value = (value - min) / (max - min)
		else
			value = 0
		end
		if value > 0.5 then
			r, g, b = 2*(1-value), 1, 0
		else
			r, g, b = 1, 2*value, 0
		end
		if not bar.disconnected and not bar.lockColor then
			if colorbyclass and UnitIsPlayer(unit) and UnitClass(unit) then
				local color = RAID_CLASS_COLORS[select(2, UnitClass(unit))]
				bar:SetStatusBarColor(color.r, color.g, color.b)
			else
				bar:SetStatusBarColor(r, g, b)
			end
		end
		if bar.pctText then bar.pctText:SetTextColor(r, g, b) end
	end
end

hooksecurefunc("TextStatusBar_UpdateTextString", textUpdate)
hooksecurefunc("UnitFrameHealthBar_Update", colorHPBar)
hooksecurefunc("HealthBar_OnValueChanged", function(self) colorHPBar(self, self.unit) end)

function CreateBarPctText(frame, ap, rp, x, y, font, manabar)
	local bar = ( manabar and frame.manabar ) or ( not manabar and frame.healthbar )
	if bar then
		if bar.pctText then
			bar.pctText:ClearAllPoints()
			bar.pctText:SetPoint(ap, bar, rp, x, y)
		else
			font = font or "NumberFontNormal"
			bar.pctText = frame:CreateFontString(nil, "OVERLAY", font)
			bar.pctText:SetPoint(ap, bar, rp, x, y)
			frame.addPctText = true
		end
	end
end

function SetNameColor(frame)
	if frame.name and frame.unit then
		local color = UnitIsPlayer(frame.unit) and RAID_CLASS_COLORS[select(2, UnitClass(frame.unit))] or NORMAL_FONT_COLOR
		frame.name:SetTextColor(color.r, color.g, color.b)
	end
end

function CreateClassIcon(parent, scale, ap, rp, x, y)
	local icon = CreateFrame("Button", nil, parent)
	icon:Hide()
	icon:SetWidth(31*scale)
	icon:SetHeight(31*scale)
	icon:SetFrameLevel(parent:GetFrameLevel()+3)
	icon:SetPoint(ap, parent, rp, x, y)

	icon.tex = icon:CreateTexture(nil, "BACKGROUND")
	icon.tex:SetWidth(20*scale)
	icon.tex:SetHeight(20*scale)
	icon.tex:SetTexture("Interface\\Glues\\CharacterCreate\\UI-CharacterCreate-Classes")
	icon.tex:SetPoint("CENTER")

	icon.lay = icon:CreateTexture(nil, "OVERLAY")
	icon.lay:SetWidth(54*scale)
	icon.lay:SetHeight(54*scale)
	icon.lay:SetTexture("Interface\\Minimap\\MiniMap-TrackingBorder")
	icon.lay:SetPoint("TOPLEFT")

	return icon
end

function PVPIcon_Update(self)
	if not self.pvpIcon then return end
	local faction = UnitFactionGroup(self.unit)
	if UnitIsPlayer(self.unit) and faction then
		self.pvpIcon:SetTexture("Interface\\GroupFrame\\UI-Group-PVP-"..faction)
		self.pvpIcon:Show()
	else
		self.pvpIcon:Hide()
	end
end

function TinyTargetFrame_OnLoad(self)
	local prefix = self:GetName()
	local unit = self:GetParent().unit.."target"
	UnitFrame_Initialize(self, unit,  _G[prefix.."Name"], _G[prefix.."Portrait"], _G[prefix.."HealthBar"], nil, _G[prefix.."ManaBar"])
	SecureUnitButton_OnLoad(self, unit)
	RegisterUnitWatch(self)
	self.curName = nil
	self.pvpIcon = _G[prefix.."PVPIcon"]
	CreateBarPctText(self, "BOTTOM", "TOP", 2, 2)
end

local function PartyLevelText_Update(self)
	local level = ""
	if self.unit and UnitLevel(self.unit) and UnitLevel(self.unit) >= 1 then
		level = UnitLevel(self.unit)
	end
	if not self.levelText then
		self.levelText = _G[self:GetName()]:CreateFontString(nil, "OVERLAY", "NumberFontNormalYellow")
		self.levelText:SetPoint("TOPRIGHT", self, "BOTTOMLEFT", 24, 1)
	end
	self.levelText:SetText(level)
end


---------------------
------ Frames -------
---------------------
CreateBarPctText(PlayerFrame, "LEFT", "RIGHT", 6, 0, "NumberFontNormalLarge")
CreateBarPctText(PetFrame, "LEFT", "RIGHT", 6, 0)
PetFrameHealthBarText:SetTextHeight(9)
PetFrameManaBarText:SetTextHeight(9)

--PlayerHitIndicator:SetText(nil)
--PlayerHitIndicator.SetText = function() end
--PetHitIndicator:SetText(nil)
--PetHitIndicator.SetText = function() end

for i = 1, 4 do
	local frame = "PartyMemberFrame"..i
	CreateBarPctText(_G[frame], "LEFT", "RIGHT", 6, 0)
	_G[frame.."HealthBarText"]:SetTextHeight(9)
	_G[frame.."ManaBarText"]:SetTextHeight(9)
	if i == 1 then
		_G[frame]:ClearAllPoints()
		_G[frame]:SetPoint("TOPLEFT", ptFrameX, ptFrameY)
	end
	_G[frame]:SetScale(frameScale)
end

CreateBarPctText(TargetFrame, "RIGHT", "LEFT", -6, 0, "NumberFontNormalLarge")
CreateBarPctText(TargetFrameToT, "BOTTOMLEFT", "TOPRIGHT", 0, 5)
CreateBarPctText(FocusFrame, "RIGHT", "LEFT", -4, 0, "NumberFontNormalLarge")
CreateBarPctText(FocusFrameToT, "BOTTOMLEFT", "TOP", 24, 10)

for i = 1, MAX_BOSS_FRAMES do
	local bossFrame = _G["Boss"..i.."TargetFrame"]
	CreateBarPctText(bossFrame, "BOTTOMLEFT", "TOPRIGHT", 17, 19, "NumberFontNormalLarge")
end

TargetFrameNumericalThreatValue:SetTextHeight(10)
FocusFrameNumericalThreatValue:SetTextHeight(10)
TargetFrame.type = TargetFrame:CreateFontString(nil, "OVERLAY", "ReputationDetailFont")
TargetFrame.type:SetPoint("BOTTOMRIGHT", TargetFrameNameBackground, "TOPRIGHT", -11, 5)

TargetFrame.icon = CreateClassIcon(TargetFrame, 1, "TOPRIGHT", "TOPRIGHT", -87, -4)
TargetFrame.icon:SetScript("OnClick", function() if IsAltKeyDown() then InitiateTrade("target") else InspectUnit("target") end end)
FocusFrame.icon = CreateClassIcon(FocusFrame, 1, "TOPLEFT", "TOPLEFT", 114, -4)

hooksecurefunc("UnitFrame_Update", function(self)
	if self.name and self.unit then
		SetNameColor(self)
		if string.len(self:GetName()) == 17 and string.find(self:GetName(), "PartyMemberFrame") then
			self.name:SetText(GetUnitName(self.unit))							-- 防止队友的名字遮挡其debuff
		end
	end
end)

hooksecurefunc("PartyMemberFrame_UpdateMember", function(self)
	local unit = "party"..self:GetID()
	if UnitExists(unit) then
		PartyLevelText_Update(self)
		CastingBarFrame_SetUnit(self.castBar, unit, false, true)
	end
end)

hooksecurefunc("TargetFrame_Update", function(self)
	if not UnitExists(self.unit) then return end
	local type, color
	if UnitIsPlayer(self.unit) then
		if self.icon then
			local coord = CLASS_ICON_TCOORDS[select(2, UnitClass(self.unit))]
			self.icon.tex:SetTexCoord(unpack(coord))
			self.icon:Show()
		end
		type = UnitRace(self.unit)
		if UnitFactionGroup(self.unit) == UnitFactionGroup("player") then
			color = GREEN_FONT_COLOR
		else
			color = RED_FONT_COLOR
		end
		self.nameBackground:SetAlpha(0.2)
	else
		if self.icon then self.icon:Hide() end
		type = UnitCreatureType(self.unit) or ""
		if type == "非战斗宠物" then
			type = "宠物"
		elseif type == "小动物" then
			type = "动物"
		elseif type == "未指定" then
			type = "不明"
		elseif type ~= "" then
			type = string.sub(type, 1, 6)
		end
		if UnitCanAttack(self.unit, "player") then
			color = UnitPlayerControlled(self.unit) and ORANGE_FONT_COLOR or YELLOW_FONT_COLOR
		else
			color = HIGHLIGHT_FONT_COLOR
		end
		self.nameBackground:SetAlpha(1.0)
	end
	if self.type then
		self.type:SetText(type)
		self.type:SetTextColor(color.r, color.g, color.b)
	end
end)

hooksecurefunc("UIParent_UpdateTopFramePositions", function()
	local topOffset = 0
	if OrderHallCommandBar and OrderHallCommandBar:IsShown() then
		topOffset = 12
	end
	if TargetFrame and not TargetFrame:IsUserPlaced() then
		TargetFrame:SetPoint("TOPLEFT", UIParent, "TOPLEFT", 320, -4 - topOffset)
	end
end)

local function SetNewLayout()
	if newLayout then
		PlayerFrame:ClearAllPoints()
		PlayerFrame:SetPoint("CENTER", pFrameX, pFrameY)
		PlayerFrame:SetUserPlaced(true)
		TargetFrame:ClearAllPoints()
		TargetFrame:SetPoint("CENTER", tFrameX, tFrameY)
		TargetFrame:SetUserPlaced(true)
	end
	PlayerFrame:SetScale(frameScale)
	TargetFrame:SetScale(frameScale)
	if hideCaps then
		MainMenuBarLeftEndCap:Hide()
		MainMenuBarRightEndCap:Hide()
		MultiBarRight:ClearAllPoints()
		MultiBarRight:SetPoint("TOPRIGHT", UIParent, "RIGHT", 0, 156)
	end
end

local iFrame = CreateFrame("Frame")
iFrame:RegisterEvent("PLAYER_ENTERING_WORLD")
iFrame:RegisterEvent("UNIT_LEVEL")
iFrame:RegisterEvent("UNIT_ENTERED_VEHICLE")
iFrame:RegisterEvent("UNIT_EXITED_VEHICLE")
iFrame:RegisterEvent("PLAYER_TARGET_CHANGED")

iFrame:SetScript("OnEvent", function(self, event, ...)
	local arg1 = ...
	if event == "PLAYER_ENTERING_WORLD" and InCombatLockdown() == false then
		SetNewLayout()
		self:UnregisterEvent("PLAYER_ENTERING_WORLD")
	elseif event == "UNIT_LEVEL" then
		for i = 1, 4 do
			if arg1 == "party"..i then
				PartyLevelText_Update(_G["PartyMemberFrame"..i])
			end
		end
	elseif event == "PLAYER_TARGET_CHANGED" then
		hasTarget = UnitExists("target") and not UnitIsUnit("player", "target") and not UnitIsUnit("vehicle", "target")
	elseif arg1 == "player" then
		if event == "UNIT_ENTERED_VEHICLE" then
			playerUnit = "vehicle"
		elseif event == "UNIT_EXITED_VEHICLE" then
			playerUnit = "player"
		end
	end
end)


-------------------------------------------------------------------------
-- Unit Range Check for Healers and Show Speed of Player or/and Target --
-------------------------------------------------------------------------
local healingSpell = { ["德鲁伊"]   = "回春术",
					   ["牧师"]     = "快速治疗",
					   ["圣骑士"]   = "圣光闪现",
					   ["萨满祭司"] = "治疗之涌",
					   ["武僧"]     = "升腾之雾"  }
local iURCSpell = healingSpell[UnitClass("player")] or nil

local function rangeCheck(frame)
	if not frame:IsShown() or not frame.unit then return end
	if IsSpellInRange(iURCSpell, frame.unit) == 0 or not UnitIsVisible(frame.unit) then
		frame:SetAlpha(0.5)
	else
		frame:SetAlpha(1)
	end
end

local function GetSpeedText(speed)
	local text = ""
	if speed and speed > 0 then
		text = format("%d%%", speed * 100 / 7 + 0.5)
	end
	return text
end

PlayerFrame.speed = PlayerFrame:CreateFontString(nil, "OVERLAY", "NumberFontNormal")
PlayerFrame.speed:SetPoint("LEFT", PlayerFrame.manabar, "RIGHT", 7, -2)
TargetFrame.speed = TargetFrame:CreateFontString(nil, "OVERLAY", "NumberFontNormal")
TargetFrame.speed:SetPoint("RIGHT", TargetFrame.manabar, "LEFT", -7, -2)

iFrame:SetScript("OnUpdate", function(self, elapsed)
	updateElapsed = (updateElapsed or 0) + elapsed
	if updateElapsed > TOOLTIP_UPDATE_TIME then
		updateElapsed = 0
		if iURCEnable and iURCSpell then
			for i = 1, 4 do
				rangeCheck(_G["PartyMemberFrame"..i])
			end
			rangeCheck(TargetFrame)
			rangeCheck(FocusFrame)
		end
		if showPlayerSpeed then
			local playerSpeed = GetUnitSpeed(playerUnit)
			if lastPlayerSpeed ~= playerSpeed then
				lastPlayerSpeed = playerSpeed
				PlayerFrame.speed:SetText(GetSpeedText(playerSpeed))
			end
		end
		if showTargetSpeed then
			local targetSpeed = hasTarget and GetUnitSpeed("target") or nil
			if lastTargetSpeed ~= targetSpeed then
				lastTargetSpeed = targetSpeed
				TargetFrame.speed:SetText(GetSpeedText(targetSpeed))
			end
		end
	end
end)