local L = {
	["open"] = "打开装备管理器",
	["quick strip"] = "一键脱光",
	["gearset"] = "套装[|cffffffff%d|r] - |T%s:22|t|cff00ff00%s|r",
	["strip set"] = "已脱下套装|cff00ff00[%d]|r中的|cff00ff00%d|r件，穿回请点击原套装按钮",
	["strip"] = "已脱下当前着装中的|cff00ff00%d|r件，请手动换回原装备或选择某套装",
	["wear set"] = "装备了套装[|cff00ff00%d|r] - |T%s:12:12:0:0|t|cff00ff00%s|r",
	["changed"] = "改动了当前套装|cff00ff00[%d]|r - |T%s:12:12:0:0|t|cff00ff00%s|r",
	["not a set"] = "当前着装不再定义为套装",
	["manager"] = "M",
	["symbol"] = "X",
}

local activeSetID, currSetID, updateElapsed
local DURASLOTS = { 16, 17, 18, 5, 7, 1, 3, 8, 10, 6, 9 }

local function IsEquippableSlot(slot)
	return slot > 15 or not InCombatLockdown()
end

local function GetItemLocked()
	local bag, slot
	for bag = 0, 4 do
		for slot = 1, GetContainerNumSlots(bag) do
			if select(3, GetContainerItemInfo(bag, slot)) then
				return bag, slot
			end
		end
	end
end

local function GetAvailableBags()
	local bags = {}
	for i = 0, 4 do
		local slots, family = GetContainerNumFreeSlots(i)
		bags[i] = (family == 0) and slots or 0
	end
	return bags
end

local function GetFirstAvailableBag(bags)
	for i = 0, 4 do
		if bags[i] > 0 then
			return i
		end
	end
end

local function GetNameandIcon(SetID)
	local setName, iconPath = GetEquipmentSetInfo(SetID)
	if setName and not iconPath then iconPath = 134400 end
	return setName, iconPath
end

local function QuickStripOff()
	if UnitIsDeadOrGhost("player") or not HasFullControl() or GetItemLocked() then
		UIErrorsFrame:AddMessage(ERR_CLIENT_LOCKED_OUT, 1, 0, 0)
		return
	end
	ClearCursor()
	local bags = GetAvailableBags()
	local count = 0
	for i = 1, #DURASLOTS do
		local inv = DURASLOTS[i]
		local lnk = GetInventoryItemLink("player", inv)
		if lnk and IsEquippableSlot(inv) and GetInventoryItemDurability(inv) then
			local bag = GetFirstAvailableBag(bags)
			if bag then
				bags[bag] = bags[bag] - 1
				PickupInventoryItem(inv)
				if CursorHasItem() then
					if bag == 0 then
						PutItemInBackpack()
					else
						PutItemInBag(19 + bag)
					end
					count = count + 1
				end
			else
				DEFAULT_CHAT_FRAME:AddMessage(ERR_INV_FULL, 1, 0, 0)
				break
			end
		end
	end
	if count == 0 then return end
	if activeSetID then
		_G["EquipSetsButton"..activeSetID]:UnlockHighlight()
		DEFAULT_CHAT_FRAME:AddMessage(format(L["strip set"], activeSetID, count), 1, 0.3, 0.3)
		activeSetID = nil
	else
		DEFAULT_CHAT_FRAME:AddMessage(format(L["strip"], count), 1, 0.3, 0.3)
	end
end

local function GetItemId(bag, slot)
	local lnk
	if slot then
		lnk = GetContainerItemLink(bag, slot)
	else
		lnk = GetInventoryItemLink("player", bag)
	end
	if lnk then
		local _, _, id = string.find(lnk, "item:(%d+).+%[(.+)%]")
		return tonumber(id or "")
	end
end

local function CheckSetWorn(equipped, name)
	if not name then return end
	local ids = GetEquipmentSetItemIDs(name)
	for k, v in pairs(ids) do
		if v and v > 1 and equipped[k] ~= v then
			return
		end
	end
	return 1
end

local function GetActiveSet()
	local equipped = {}
	for i = 0, 19 do
		equipped[i] = GetItemId(i) or 0
	end
	for i = 1, GetNumEquipmentSets() do
		local setName = GetNameandIcon(i)
		if CheckSetWorn(equipped, setName) then
			return i
		end
	end
end

local function CheckButtonsHighlight()
	currSetID = GetActiveSet()
	if activeSetID == currSetID then return end
	local setName, iconPath
	if activeSetID then
		_G["EquipSetsButton"..activeSetID]:UnlockHighlight()
		if not currSetID then
			setName, iconPath = GetNameandIcon(activeSetID)
			if setName then
				DEFAULT_CHAT_FRAME:AddMessage(format(L["changed"], activeSetID, iconPath, setName), 1, 0.3, 0.3)
			else
				DEFAULT_CHAT_FRAME:AddMessage(L["not a set"], 1, 0.3, 0.3)
			end
		end
	end
	if currSetID then
		_G["EquipSetsButton"..currSetID]:LockHighlight()
		setName, iconPath = GetNameandIcon(currSetID)
		DEFAULT_CHAT_FRAME:AddMessage(format(L["wear set"], currSetID, iconPath, setName))
	end
	activeSetID = currSetID
end

local function UpdateButtonsNum(self)
	local num = GetNumEquipmentSets()
	for i = 1, 10 do
		if i > num then
			_G["EquipSetsButton"..i]:Hide()
		else
			_G["EquipSetsButton"..i]:Show()
		end
	end
	_G["StripButton"]:ClearAllPoints()
	_G["StripButton"]:SetPoint("BOTTOMLEFT", PlayerFrame, "TOPLEFT", 98+21*(num+1), -21)
	self.SetsNum = num
end

local function buttonOnEnter(self)
	GameTooltip:SetOwner(_G["StripButton"], "ANCHOR_RIGHT")
	local id = self:GetID()
	if id == 0 then
		GameTooltip:AddLine(L["open"])
	elseif id == 11 then
		GameTooltip:AddLine(L["quick strip"])
	else
		local setName, iconPath = GetNameandIcon(id)
		GameTooltip:AddLine(format(L["gearset"], id, iconPath, setName))
	end
	GameTooltip:Show()
end

local function buttonOnClick(self)
	local id = self:GetID()
	if id == 0 then
		if PaperDollEquipmentManagerPane:IsVisible() then
			ToggleCharacter("PaperDollFrame")
		else
			if not PaperDollFrame:IsVisible() then ToggleCharacter("PaperDollFrame") end
			if not CharacterFrame.Expanded then CharacterFrame_Expand()	end
			PaperDollFrame_SetSidebar(PaperDollSidebarTab3, PaperDollSidebarTab3:GetID())
		end
	elseif id == 11 then
		QuickStripOff()
	elseif id ~= activeSetID then
		EquipmentManager_EquipSet(GetNameandIcon(id))
	end
end

local iEquip = CreateFrame("Frame", "iEquip", PlayerFrame)
iEquip:RegisterEvent("PLAYER_ENTERING_WORLD")
iEquip:RegisterEvent("PLAYER_EQUIPMENT_CHANGED")
iEquip:RegisterEvent("EQUIPMENT_SETS_CHANGED")
iEquip:RegisterEvent("UNIT_ENTERED_VEHICLE")
iEquip:RegisterEvent("UNIT_EXITED_VEHICLE")
iEquip:Show()

local function makeButton(name, text, id)
	local button = CreateFrame("Button", name, iEquip, "UIPanelButtonTemplate")
	button:SetWidth(20)
	button:SetHeight(20)
	button:SetText(text)
	button:SetID(id)
	button:SetPoint("BOTTOMLEFT", PlayerFrame, "TOPLEFT", 98+21*id, -21)
	button:SetScript("OnEnter", buttonOnEnter)
	button:SetScript("OnLeave", function() GameTooltip:Hide() end)
	button:SetScript("OnClick", buttonOnClick)
	return button
end

makeButton("ManagerButton", L["manager"], 0)
for i = 1, 10 do
	makeButton("EquipSetsButton"..i, i, i)
end
makeButton("StripButton", L["symbol"], 11)

iEquip:SetScript("OnEvent", function(self, event, ...)
	local arg1 = ...
	if event == "PLAYER_ENTERING_WORLD" then
		self:UnregisterEvent("PLAYER_ENTERING_WORLD")
		PlayerFrameGroupIndicatorLeft:SetAlpha(0)
		PlayerFrameGroupIndicatorRight:SetAlpha(0)
		PlayerFrameGroupIndicatorMiddle:SetAlpha(0)
		PlayerFrameGroupIndicatorText:ClearAllPoints()
		PlayerFrameGroupIndicatorText:SetPoint("BOTTOMLEFT", PlayerFrame, "BOTTOMLEFT", 25, 0)
		UpdateButtonsNum(self)
		self.needCheck = 1
	elseif event == "PLAYER_EQUIPMENT_CHANGED" then
		self.needCheck = 1
	elseif event == "EQUIPMENT_SETS_CHANGED" then
		if self.SetsNum ~= GetNumEquipmentSets() then
			UpdateButtonsNum(self)
		end
		self.needCheck = 1
	elseif arg1 == "player" then
		if event == "UNIT_ENTERED_VEHICLE" then
			iEquip:Hide()
		elseif event == "UNIT_EXITED_VEHICLE" then
			iEquip:Show()
		end
	end
end)

iEquip:SetScript("OnUpdate", function(self, elapsed)
	updateElapsed = (updateElapsed or 0) + elapsed
	if updateElapsed > TOOLTIP_UPDATE_TIME then
		updateElapsed = 0
		if self.needCheck then
			self.needCheck = nil
			CheckButtonsHighlight()
		end
	end
end)