CHAT_FRAME_FADE_OUT_TIME = 0
CHAT_TAB_HIDE_DELAY = 0
CHAT_FRAME_TAB_SELECTED_NOMOUSE_ALPHA = 0
CHAT_FRAME_TAB_NORMAL_NOMOUSE_ALPHA = 0

local ScrollLines = 3
local topInput = true

local function Hide(f)
	f:SetScript('OnShow', f.Hide)
	f:Hide()
end

FloatingChatFrame_OnMouseScroll = function(self, dir)
	if dir > 0 then
		if IsControlKeyDown() then
			self:ScrollToTop()
		elseif IsShiftKeyDown() then
			for i = 1, ScrollLines do
				self:ScrollUp()
			end
		else
			self:ScrollUp()
		end
	elseif dir < 0 then
		if IsControlKeyDown() then
			self:ScrollToBottom()
		elseif IsShiftKeyDown() then
			for i = 1, ScrollLines do
				self:ScrollDown()
			end
		else
			self:ScrollDown()
		end
	end
end

local TypeIcons = {
	['spell'] = function(id) return select(3, GetSpellInfo(id)) end,
	['item'] = GetItemIcon,
	['achievement'] = function(id) return select(10, GetAchievementInfo(id)) end,
}

local _icon_link = ' |T%s:12:12:0:0|t%s'
local function iconify(link)
	local type, id = link:match('|H(%w+):(%w+)')
	local icon = TypeIcons[type] and TypeIcons[type](id)
	return icon and _icon_link:format(icon, link) or link
end

local AddMessage = function(frame, text, ...)
	if text then
		text = text:gsub('(|c%x+|H.-|h|r)', iconify)
		text = text:gsub('|h%[(%d+)%. 大脚世界频道%]|h', '|h%[%1%. 世界%]|h')
	end
	frame.am(frame, text, ...)
end

for i = 1, NUM_CHAT_WINDOWS do
	local cf = _G['ChatFrame'..i]
	cf:SetClampRectInsets(0, 0, 0, 0)
	cf:SetFading(false)
	if i ~= 2 then
		cf.am = cf.AddMessage
		cf.AddMessage = AddMessage
	end

	local buttons = cf.buttonFrame
	buttons:DisableDrawLayer('BACKGROUND')
	buttons:DisableDrawLayer('BORDER')

	Hide(buttons.upButton)
	Hide(buttons.downButton)

	local bottom = buttons.bottomButton
	bottom:SetPoint('BOTTOMRIGHT', cf)
	bottom:SetScale(.6)
	bottom:DisableDrawLayer()

	local editbox = cf.editBox
	editbox:SetAltArrowKeyMode(false)
	editbox:HookScript('OnEditFocusLost', function(self) self:Hide() end)
	if topInput then
		editbox:ClearAllPoints()
		editbox:SetPoint('BOTTOMLEFT', cf, 'TOPLEFT', -5, 0)
		editbox:SetPoint('BOTTOMRIGHT', cf, 'TOPRIGHT', -15, 0)
		_G['ChatFrame'..i..'Tab']:HookScript('OnClick', function() editbox:Hide() end)
	end
	_G['ChatFrame'..i..'EditBoxLeft']:Hide()
	_G['ChatFrame'..i..'EditBoxRight']:Hide()
	_G['ChatFrame'..i..'EditBoxMid']:Hide()
end

QuickJoinToastButton:SetAlpha(.4)
QuickJoinToastButton:SetScale(.6)
QuickJoinToastButton:ClearAllPoints()
QuickJoinToastButton:SetPoint('TOPLEFT', ChatFrame1, 'TOPRIGHT')
QuickJoinToastButton:RegisterForClicks('LeftButtonUp', 'RightButtonUp')
QuickJoinToastButton:SetScript('OnClick', function(self, button)
	if button == 'RightButton' then
		PlaySound('igChatEmoteButton')
		if not ChatMenu:IsShown() then
			ChatMenu:Show()
		else
			ChatMenu:Hide()
		end
	else
		if IsModifierKeyDown() then
			if MacroFrame and MacroFrame:IsShown() then
				HideUIPanel(MacroFrame)
			else
				ShowMacroFrame()
			end
		else
			ToggleFriendsFrame(1)
		end
	end
end)
BNToastFrame:SetClampedToScreen(true)

ChatMenu:SetPoint('BOTTOMLEFT', QuickJoinToastButton, 'TOPRIGHT')
Hide(ChatFrameMenuButton)

CHAT_SAY_GET = '%s: '
CHAT_YELL_GET = '%s: '
CHAT_WHISPER_GET ='From %s: '
CHAT_WHISPER_INFORM_GET ='To %s: '
CHAT_GUILD_GET = '[会] %s: '
CHAT_RAID_GET = '[团] %s: '
CHAT_PARTY_GET = '[队] %s: '
CHAT_OFFICER_GET = '[官] %s: '
CHAT_RAID_LEADER_GET = '[RL] %s: '
CHAT_RAID_WARNING_GET = '[警] %s: '
-- CHAT_BATTLEGROUND_GET = '[战] %s: '

ChatTypeInfo.WHISPER.sticky = 0
ChatTypeInfo.BN_WHISPER.sticky = 0


local chateditbox = CreateFrame('Button', nil, ChatFrame1EditBox)
chateditbox:SetBackdrop(GameTooltip:GetBackdrop())
chateditbox:SetBackdropColor(0, 0, 0, 0)
chateditbox:SetBackdropBorderColor(0, 0, 0, 0)

hooksecurefunc('ChatEdit_UpdateHeader', function(editbox)
	if ACTIVE_CHAT_EDIT_BOX then
		local type = editbox:GetAttribute('chatType')
		local frame = string.match(ACTIVE_CHAT_EDIT_BOX:GetName(),'ChatFrame%d', 1)
		if frame then
			if type == 'CHANNEL' then
				local id = GetChannelName(editbox:GetAttribute('channelTarget'))
				if id == 0 then
					chateditbox:SetBackdropColor(0.5/3, 0.5/3, 0.5/3)
				else
					chateditbox:SetBackdropColor(ChatTypeInfo[type..id].r/3, ChatTypeInfo[type..id].g/3, ChatTypeInfo[type..id].b/3)
				end
			else
				if type and ChatTypeInfo[type] and ChatTypeInfo[type].r then
					chateditbox:SetBackdropColor(ChatTypeInfo[type].r/3, ChatTypeInfo[type].g/3, ChatTypeInfo[type].b/3)
				end
			end
			chateditbox:SetParent(ACTIVE_CHAT_EDIT_BOX)
			chateditbox:ClearAllPoints()
			chateditbox:SetPoint('TOPLEFT', ACTIVE_CHAT_EDIT_BOX:GetName()..'FocusLeft', 'TOPLEFT', 4, -3)
			chateditbox:SetPoint('BOTTOMRIGHT', ACTIVE_CHAT_EDIT_BOX:GetName()..'FocusRight', 'BOTTOMRIGHT', -4, 3)
			chateditbox:SetFrameLevel(_G[frame..'EditBox']:GetFrameLevel()-1)
		end
	else
		chateditbox:SetBackdropColor(0, 0, 0, 0)
	end
end)


function ChatEdit_CustomTabPressed(self)
	if strsub(tostring(self:GetText()), 1, 1) == '/' then return end
	local chatType = self:GetAttribute('chatType')
	local inParty = GetNumSubgroupMembers() > 0
	local inInstance = IsInGroup(LE_PARTY_CATEGORY_INSTANCE) and IsInInstance()
	local inRaid = GetNumGroupMembers() > 0 and IsInRaid()
	local inGuild = IsInGuild()
	local isOfficer = CanEditOfficerNote()
	local setType
	if chatType == 'SAY' then
		setType = inParty and 'PARTY' or inInstance and 'INSTANCE_CHAT' or inRaid and 'RAID' or inGuild and 'GUILD' or isOfficer and 'OFFICER'
	elseif chatType == 'PARTY' then
		setType = inInstance and 'INSTANCE_CHAT' or inRaid and 'RAID' or inGuild and 'GUILD' or isOfficer and 'OFFICER' or 'SAY'
	elseif chatType == 'INSTANCE_CHAT' then
		setType = inGuild and 'GUILD' or isOfficer and 'OFFICER' or 'SAY'
	elseif chatType == 'RAID' then
		setType = inGuild and 'GUILD' or isOfficer and 'OFFICER' or 'SAY'
	elseif chatType == 'GUILD' then
		setType = isOfficer and 'OFFICER' or 'SAY'
	elseif chatType == 'OFFICER' then
		setType = 'SAY'
	elseif chatType == 'CHANNEL' then
		setType = inParty and 'PARTY' or inInstance and 'INSTANCE_CHAT' or inRaid and 'RAID' or inGuild and 'GUILD' or isOfficer and 'OFFICER' or 'SAY'
	end
	if setType then
		self:SetAttribute('chatType', setType)
		ChatEdit_UpdateHeader(self)	
	else
		return
	end
end


SLASH_RELOAD1 = '/rl'
SlashCmdList.RELOAD = ReloadUI