local topDebuffs = true 						-- ͷƶ󣬽ҵdebuffͷϷʾ
local iMAX_PARTY_BUFFS = 12
local iMAX_PARTY_DEBUFFS = 10
local ColorizeBuff = true

local PLAYER_UNITS = {
	player = true,
	vehicle = true,
	pet = true,
}

local buff, debuff

for i = 1, 4 do
	local str = "PartyMemberFrame"..i

	for j = 1, iMAX_PARTY_BUFFS do
		buff = CreateFrame("Button", str.."Buff"..j, _G[str], "PartyBuffFrameTemplate")
		buff:SetID(j)
		if j == 1 then
			buff:SetPoint("TOPLEFT", str, "TOPLEFT", 48, -32)
		else
			buff:SetPoint("LEFT", str.."Buff"..j-1, "RIGHT", 2, 0)
		end
	end

	local debuff1 = _G[str.."Debuff1"]
	debuff1:ClearAllPoints()
	debuff1:SetPoint("LEFT", str, "RIGHT", 39, 28)
	for j = 5, iMAX_PARTY_DEBUFFS do
		debuff = CreateFrame("Button", str.."Debuff"..j, _G[str], "PartyDebuffFrameTemplate")
		debuff:SetID(j)
		if j == 6 then
			debuff:SetPoint("TOP", str.."Debuff"..1, "BOTTOM", 0, -3)
		else
			debuff:SetPoint("LEFT", str.."Debuff"..j-1, "RIGHT", 2, 0)
		end
	end
end

PartyMemberBuffTooltip_Update = function(self) return end

for i = 1, MAX_PARTY_DEBUFFS do
	debuff = _G["TargetFrameToTDebuff"..i]
	debuff:SetWidth(15)
	debuff:SetHeight(15)
	debuff:ClearAllPoints()
	if i == 1 then
		debuff:SetPoint("LEFT", TargetFrameToT, "RIGHT", 1, 0)
	else
		debuff:SetPoint("LEFT", "TargetFrameToTDebuff"..i-1, "RIGHT", 2, 0)
	end
end

hooksecurefunc("RefreshBuffs", function(frame, unit, numBuffs, suffix, checkCVar)
	numBuffs = numBuffs or MAX_PARTY_BUFFS
	suffix = suffix or "Buff"

	local buffName, buffCount, coolDown, count, duration, expirationTime, caster
	local canAssist = UnitCanAssist("player", unit)
	local needShowCD
	local filter
	if checkCVar and SHOW_CASTABLE_BUFFS == "1" and canAssist then
		filter = "RAID"
	end

	for i = 1, numBuffs do
		buffName = frame:GetName()..suffix..i
		buffCount = _G[buffName.."Count"]
		if not buffCount then
			buffCount = _G[buffName]:CreateFontString(buffName.."Count", "OVERLAY", "TextStatusBarText")
			buffCount:SetPoint("BOTTOMLEFT")
		end
		coolDown = _G[buffName.."Cooldown"]
		if not coolDown then
			needShowCD = true
			coolDown = CreateFrame("Cooldown", buffName.."Cooldown", _G[buffName], "CooldownFrameTemplate")
			coolDown:SetReverse(true)
			coolDown:SetPoint("CENTER", 0, -1)
			coolDown:Hide()
		else
			needShowCD = false
		end
		if _G[buffName]:IsShown() then
			_, _, _, count, _, duration, expirationTime, caster = UnitBuff(unit, i, filter)
			if count > 1 then
				buffCount:SetText(count)
				buffCount:Show()
			else
				buffCount:Hide()
			end
			if needShowCD then
				CooldownFrame_Set(coolDown, expirationTime - duration, duration, true)
			end
			if ColorizeBuff then
				if canAssist and not PLAYER_UNITS[caster] then
					_G[buffName.."Icon"]:SetDesaturated(true)
				else
					_G[buffName.."Icon"]:SetDesaturated(false)
				end
			end
		end
	end
end)

hooksecurefunc("RefreshDebuffs", function(frame, unit, numDebuffs, suffix, checkCVar)
	local numBuffs = nil
	if string.find(unit, "party") and string.len(unit) == 6 then
		numBuffs, numDebuffs = iMAX_PARTY_BUFFS, iMAX_PARTY_DEBUFFS
	else
		numDebuffs = numDebuffs or MAX_PARTY_DEBUFFS
	end
	suffix = suffix or "Debuff"

	if numBuffs then RefreshBuffs(frame, unit, numBuffs, nil, true) end

	local debuffName, debuffCount, coolDown, count, duration, expirationTime, caster
	local canAssist = UnitCanAssist("player", unit)
	local needShowCD
	local filter
	if checkCVar and SHOW_DISPELLABLE_DEBUFFS == "1" and canAssist then
		filter = "RAID"
	end

	for i = 1, numDebuffs do
		debuffName = frame:GetName()..suffix..i
		debuffCount = _G[debuffName.."Count"]
		if not debuffCount then
			debuffCount = _G[debuffName]:CreateFontString(debuffName.."Count", "OVERLAY", "TextStatusBarText")
			debuffCount:SetPoint("BOTTOMLEFT")
		end
		coolDown = _G[debuffName.."Cooldown"]
		if not coolDown then
			needShowCD = true
			coolDown = CreateFrame("Cooldown", debuffName.."Cooldown", _G[debuffName], "CooldownFrameTemplate")
			coolDown:SetReverse(true)
			coolDown:SetPoint("CENTER", 0, -1)
			coolDown:Hide()
		else
			needShowCD = false
		end
		if _G[debuffName]:IsShown() then
			_, _, _, count, _, duration, expirationTime, caster = UnitDebuff(unit, i, filter)
			if count > 1 then
				debuffCount:SetText(count)
				debuffCount:Show()
			else
				debuffCount:Hide()
			end
			if needShowCD then
				CooldownFrame_Set(coolDown, expirationTime - duration, duration, true)
			end
			if ColorizeBuff then
				if not canAssist and not PLAYER_UNITS[caster] then
					_G[debuffName.."Icon"]:SetDesaturated(true)
					_G[debuffName.."Border"]:Hide()
				else
					_G[debuffName.."Icon"]:SetDesaturated(false)
					_G[debuffName.."Border"]:Show()
				end
			end
		end
	end
end)

hooksecurefunc("TargetFrame_UpdateAuras", function(self)
	if not ColorizeBuff then return end

	local frameName, caster
	local canAssist = UnitCanAssist("player", self.unit)

	for i = 1, MAX_TARGET_BUFFS do
		frameName = self:GetName().."Buff"..(i)
		caster = select(8, UnitBuff(self.unit, i, nil))
		if _G[frameName] and _G[frameName]:IsShown() then
			if canAssist and not PLAYER_UNITS[caster] then
				_G[frameName.."Icon"]:SetDesaturated(true)
			else
				_G[frameName.."Icon"]:SetDesaturated(false)
			end
		end
	end

	for i = 1, MAX_TARGET_DEBUFFS do
		frameName = self:GetName().."Debuff"..i
		caster = select(8, UnitDebuff(self.unit, i, "INCLUDE_NAME_PLATE_ONLY"))
		if _G[frameName] and _G[frameName]:IsShown() then
			if not canAssist and not PLAYER_UNITS[caster] then
				_G[frameName.."Icon"]:SetDesaturated(true)
				_G[frameName.."Border"]:Hide()
			else
				_G[frameName.."Icon"]:SetDesaturated(false)
				_G[frameName.."Border"]:Show()
			end
		end
	end
end)

hooksecurefunc("FocusFrame_SetSmallSize", function()
	if not FocusFrame.showAuraCount then
		FocusFrame.showAuraCount = true
		TargetFrame_UpdateAuras(FocusFrame)
	end
end)

hooksecurefunc("AuraButton_Update", function(buttonName, index, filter)
	local buff = _G[buttonName..index]
	if not topDebuffs or not buff or buff.filter == "HELPFUL" then return end
	local _, _, _, _, _, duration, expirationTime = UnitAura(PlayerFrame.unit, index, filter)
	if duration and expirationTime then
		if not buff.coolDown then
			buff.coolDown = CreateFrame("Cooldown", buttonName..index.."Cooldown", buff, "CooldownFrameTemplate")
			buff.coolDown:SetReverse(true)
			buff.coolDown:SetPoint("CENTER", 0, -1)
		end
		CooldownFrame_Set(buff.coolDown, expirationTime - duration, duration, duration > 0)
	end
	if buff.duration then buff.duration:SetAlpha(0) end
end)

hooksecurefunc("DebuffButton_UpdateAnchors", function(buttonName, index)
	if not topDebuffs or not PlayerFrame:IsUserPlaced() then return end
	local buff = _G[buttonName..index]
	buff:ClearAllPoints()
	if index == 1 then
		buff:SetPoint("BOTTOMRIGHT", PlayerFrame, "TOPRIGHT", -13, 2)
	elseif index > 4 then
		buff:SetPoint("BOTTOM", _G[buttonName..(index-4)], "TOP", 0, 5)
	else
		buff:SetPoint("RIGHT", _G[buttonName..(index-1)], "LEFT", -5, 0)
	end
end)