/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.instrumentation;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.PropertyPermission;
import jdk.internal.instrumentation.Inliner;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.Logger;
import jdk.internal.instrumentation.MaxLocalsTracker;
import jdk.internal.instrumentation.MethodMergeAdapter;
import jdk.internal.instrumentation.Tracer;
import jdk.internal.instrumentation.TypeMapping;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassVisitor;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.tree.ClassNode;
import jdk.internal.org.objectweb.asm.util.CheckClassAdapter;

public final class ClassInstrumentation {
    private final Class<?> instrumentor;
    private final Logger logger;
    private final String targetName;
    private final String instrumentorName;
    private byte[] newBytes;
    private final ClassReader targetClassReader;
    private final ClassReader instrClassReader;
    private static final String JAVA_HOME = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("java.home");
        }
    }, null, new PropertyPermission("java.home", "read"));

    public ClassInstrumentation(Class<?> clazz, String string, byte[] byArray, Logger logger) throws ClassNotFoundException, IOException {
        this.instrumentorName = clazz.getName();
        this.targetName = string;
        this.instrumentor = clazz;
        this.logger = logger;
        this.targetClassReader = new ClassReader(byArray);
        this.instrClassReader = new ClassReader(this.getInstrumentationInputStream(this.instrumentorName));
        this.instrument();
        this.saveGeneratedInstrumentation();
    }

    private InputStream getInstrumentationInputStream(final String string) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    return Tracer.class.getResourceAsStream("/" + string.replace(".", "/") + ".class");
                }
            }, null, new FilePermission(JAVA_HOME + File.separator + "-", "read"));
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw (RuntimeException)exception;
        }
    }

    private void instrument() throws IOException, ClassNotFoundException {
        Object object;
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : this.instrumentor.getDeclaredMethods()) {
            object = method.getAnnotation(InstrumentationMethod.class);
            if (object == null) continue;
            arrayList.add(method);
        }
        MaxLocalsTracker maxLocalsTracker = new MaxLocalsTracker();
        this.instrClassReader.accept(maxLocalsTracker, 0);
        ClassNode classNode = new ClassNode();
        Inliner inliner = new Inliner(327680, classNode, this.instrumentorName, this.targetClassReader, arrayList, maxLocalsTracker, this.logger);
        this.instrClassReader.accept(inliner, 8);
        ClassWriter classWriter = new ClassWriter(2);
        object = new MethodMergeAdapter(classWriter, classNode, arrayList, (TypeMapping[])this.instrumentor.getAnnotationsByType(TypeMapping.class), this.logger);
        this.targetClassReader.accept((ClassVisitor)object, 8);
        this.newBytes = classWriter.toByteArray();
    }

    public byte[] getNewBytes() {
        return (byte[])this.newBytes.clone();
    }

    private void saveGeneratedInstrumentation() {
        boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean("jfr.savegenerated");
            }
        });
        if (bl) {
            try {
                this.writeGeneratedDebugInstrumentation();
            }
            catch (IOException | ClassNotFoundException exception) {
                this.logger.info("Unable to create debug instrumentation");
            }
        }
    }

    private void writeGeneratedDebugInstrumentation() throws IOException, ClassNotFoundException {
        try (Closeable closeable = new FileOutputStream(this.targetName + ".class");){
            ((FileOutputStream)closeable).write(this.newBytes);
        }
        closeable = new FileWriter(this.targetName + ".asm");
        var2_2 = null;
        try (PrintWriter printWriter = new PrintWriter((Writer)closeable);){
            ClassReader classReader = new ClassReader(this.getNewBytes());
            CheckClassAdapter.verify(classReader, true, printWriter);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (closeable != null) {
                if (var2_2 != null) {
                    try {
                        ((OutputStreamWriter)closeable).close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    ((OutputStreamWriter)closeable).close();
                }
            }
        }
        this.logger.info("Instrumented code saved to " + this.targetName + ".class and .asm");
    }
}

