/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.ArrayTable;
import javax.swing.KeyStroke;

public class InputMap
implements Serializable {
    private transient ArrayTable arrayTable;
    private InputMap parent;

    public void setParent(InputMap inputMap) {
        this.parent = inputMap;
    }

    public InputMap getParent() {
        return this.parent;
    }

    public void put(KeyStroke keyStroke, Object object) {
        if (keyStroke == null) {
            return;
        }
        if (object == null) {
            this.remove(keyStroke);
        } else {
            if (this.arrayTable == null) {
                this.arrayTable = new ArrayTable();
            }
            this.arrayTable.put(keyStroke, object);
        }
    }

    public Object get(KeyStroke keyStroke) {
        InputMap inputMap;
        if (this.arrayTable == null) {
            InputMap inputMap2 = this.getParent();
            if (inputMap2 != null) {
                return inputMap2.get(keyStroke);
            }
            return null;
        }
        Object object = this.arrayTable.get(keyStroke);
        if (object == null && (inputMap = this.getParent()) != null) {
            return inputMap.get(keyStroke);
        }
        return object;
    }

    public void remove(KeyStroke keyStroke) {
        if (this.arrayTable != null) {
            this.arrayTable.remove(keyStroke);
        }
    }

    public void clear() {
        if (this.arrayTable != null) {
            this.arrayTable.clear();
        }
    }

    public KeyStroke[] keys() {
        if (this.arrayTable == null) {
            return null;
        }
        Object[] objectArray = new KeyStroke[this.arrayTable.size()];
        this.arrayTable.getKeys(objectArray);
        return objectArray;
    }

    public int size() {
        if (this.arrayTable == null) {
            return 0;
        }
        return this.arrayTable.size();
    }

    public KeyStroke[] allKeys() {
        int n;
        int n2 = this.size();
        InputMap inputMap = this.getParent();
        if (n2 == 0) {
            if (inputMap != null) {
                return inputMap.allKeys();
            }
            return this.keys();
        }
        if (inputMap == null) {
            return this.keys();
        }
        KeyStroke[] keyStrokeArray = this.keys();
        KeyStroke[] keyStrokeArray2 = inputMap.allKeys();
        if (keyStrokeArray2 == null) {
            return keyStrokeArray;
        }
        if (keyStrokeArray == null) {
            return keyStrokeArray2;
        }
        HashMap<KeyStroke, KeyStroke> hashMap = new HashMap<KeyStroke, KeyStroke>();
        for (n = keyStrokeArray.length - 1; n >= 0; --n) {
            hashMap.put(keyStrokeArray[n], keyStrokeArray[n]);
        }
        for (n = keyStrokeArray2.length - 1; n >= 0; --n) {
            hashMap.put(keyStrokeArray2[n], keyStrokeArray2[n]);
        }
        KeyStroke[] keyStrokeArray3 = new KeyStroke[hashMap.size()];
        return hashMap.keySet().toArray(keyStrokeArray3);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        ArrayTable.writeArrayTable(objectOutputStream, this.arrayTable);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        for (int i = objectInputStream.readInt() - 1; i >= 0; --i) {
            this.put((KeyStroke)objectInputStream.readObject(), objectInputStream.readObject());
        }
    }
}

