/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.SignedMutableBigInteger;
import java.util.Arrays;

class MutableBigInteger {
    int[] value;
    int intLen;
    int offset = 0;
    static final MutableBigInteger ONE = new MutableBigInteger(1);
    static final int KNUTH_POW2_THRESH_LEN = 6;
    static final int KNUTH_POW2_THRESH_ZEROS = 3;

    MutableBigInteger() {
        this.value = new int[1];
        this.intLen = 0;
    }

    MutableBigInteger(int n) {
        this.value = new int[1];
        this.intLen = 1;
        this.value[0] = n;
    }

    MutableBigInteger(int[] nArray) {
        this.value = nArray;
        this.intLen = nArray.length;
    }

    MutableBigInteger(BigInteger bigInteger) {
        this.intLen = bigInteger.mag.length;
        this.value = Arrays.copyOf(bigInteger.mag, this.intLen);
    }

    MutableBigInteger(MutableBigInteger mutableBigInteger) {
        this.intLen = mutableBigInteger.intLen;
        this.value = Arrays.copyOfRange(mutableBigInteger.value, mutableBigInteger.offset, mutableBigInteger.offset + this.intLen);
    }

    private void ones(int n) {
        if (n > this.value.length) {
            this.value = new int[n];
        }
        Arrays.fill(this.value, -1);
        this.offset = 0;
        this.intLen = n;
    }

    private int[] getMagnitudeArray() {
        if (this.offset > 0 || this.value.length != this.intLen) {
            return Arrays.copyOfRange(this.value, this.offset, this.offset + this.intLen);
        }
        return this.value;
    }

    private long toLong() {
        assert (this.intLen <= 2) : "this MutableBigInteger exceeds the range of long";
        if (this.intLen == 0) {
            return 0L;
        }
        long l = (long)this.value[this.offset] & 0xFFFFFFFFL;
        return this.intLen == 2 ? l << 32 | (long)this.value[this.offset + 1] & 0xFFFFFFFFL : l;
    }

    BigInteger toBigInteger(int n) {
        if (this.intLen == 0 || n == 0) {
            return BigInteger.ZERO;
        }
        return new BigInteger(this.getMagnitudeArray(), n);
    }

    BigInteger toBigInteger() {
        this.normalize();
        return this.toBigInteger(this.isZero() ? 0 : 1);
    }

    BigDecimal toBigDecimal(int n, int n2) {
        if (this.intLen == 0 || n == 0) {
            return BigDecimal.zeroValueOf(n2);
        }
        int[] nArray = this.getMagnitudeArray();
        int n3 = nArray.length;
        int n4 = nArray[0];
        if (n3 > 2 || n4 < 0 && n3 == 2) {
            return new BigDecimal(new BigInteger(nArray, n), Long.MIN_VALUE, n2, 0);
        }
        long l = n3 == 2 ? (long)nArray[1] & 0xFFFFFFFFL | ((long)n4 & 0xFFFFFFFFL) << 32 : (long)n4 & 0xFFFFFFFFL;
        return BigDecimal.valueOf(n == -1 ? -l : l, n2);
    }

    long toCompactValue(int n) {
        if (this.intLen == 0 || n == 0) {
            return 0L;
        }
        int[] nArray = this.getMagnitudeArray();
        int n2 = nArray.length;
        int n3 = nArray[0];
        if (n2 > 2 || n3 < 0 && n2 == 2) {
            return Long.MIN_VALUE;
        }
        long l = n2 == 2 ? (long)nArray[1] & 0xFFFFFFFFL | ((long)n3 & 0xFFFFFFFFL) << 32 : (long)n3 & 0xFFFFFFFFL;
        return n == -1 ? -l : l;
    }

    void clear() {
        this.intLen = 0;
        this.offset = 0;
        int n = this.value.length;
        for (int i = 0; i < n; ++i) {
            this.value[i] = 0;
        }
    }

    void reset() {
        this.intLen = 0;
        this.offset = 0;
    }

    final int compare(MutableBigInteger mutableBigInteger) {
        int n = mutableBigInteger.intLen;
        if (this.intLen < n) {
            return -1;
        }
        if (this.intLen > n) {
            return 1;
        }
        int[] nArray = mutableBigInteger.value;
        int n2 = this.offset;
        int n3 = mutableBigInteger.offset;
        while (n2 < this.intLen + this.offset) {
            int n4 = this.value[n2] + Integer.MIN_VALUE;
            int n5 = nArray[n3] + Integer.MIN_VALUE;
            if (n4 < n5) {
                return -1;
            }
            if (n4 > n5) {
                return 1;
            }
            ++n2;
            ++n3;
        }
        return 0;
    }

    private int compareShifted(MutableBigInteger mutableBigInteger, int n) {
        int n2 = this.intLen - n;
        int n3 = mutableBigInteger.intLen;
        if (n2 < n3) {
            return -1;
        }
        if (n2 > n3) {
            return 1;
        }
        int[] nArray = mutableBigInteger.value;
        int n4 = this.offset;
        int n5 = mutableBigInteger.offset;
        while (n4 < n2 + this.offset) {
            int n6 = this.value[n4] + Integer.MIN_VALUE;
            int n7 = nArray[n5] + Integer.MIN_VALUE;
            if (n6 < n7) {
                return -1;
            }
            if (n6 > n7) {
                return 1;
            }
            ++n4;
            ++n5;
        }
        return 0;
    }

    final int compareHalf(MutableBigInteger mutableBigInteger) {
        int n = mutableBigInteger.intLen;
        int n2 = this.intLen;
        if (n2 <= 0) {
            return n <= 0 ? 0 : -1;
        }
        if (n2 > n) {
            return 1;
        }
        if (n2 < n - 1) {
            return -1;
        }
        int[] nArray = mutableBigInteger.value;
        int n3 = 0;
        int n4 = 0;
        if (n2 != n) {
            if (nArray[n3] == 1) {
                ++n3;
                n4 = Integer.MIN_VALUE;
            } else {
                return -1;
            }
        }
        int[] nArray2 = this.value;
        int n5 = this.offset;
        int n6 = n3;
        while (n5 < n2 + this.offset) {
            int n7;
            long l;
            long l2;
            if ((l2 = (long)nArray2[n5++] & 0xFFFFFFFFL) != (l = (long)(((n7 = nArray[n6++]) >>> 1) + n4) & 0xFFFFFFFFL)) {
                return l2 < l ? -1 : 1;
            }
            n4 = (n7 & 1) << 31;
        }
        return n4 == 0 ? 0 : -1;
    }

    private final int getLowestSetBit() {
        int n;
        if (this.intLen == 0) {
            return -1;
        }
        for (n = this.intLen - 1; n > 0 && this.value[n + this.offset] == 0; --n) {
        }
        int n2 = this.value[n + this.offset];
        if (n2 == 0) {
            return -1;
        }
        return (this.intLen - 1 - n << 5) + Integer.numberOfTrailingZeros(n2);
    }

    private final int getInt(int n) {
        return this.value[this.offset + n];
    }

    private final long getLong(int n) {
        return (long)this.value[this.offset + n] & 0xFFFFFFFFL;
    }

    final void normalize() {
        if (this.intLen == 0) {
            this.offset = 0;
            return;
        }
        int n = this.offset;
        if (this.value[n] != 0) {
            return;
        }
        int n2 = n + this.intLen;
        while (++n < n2 && this.value[n] == 0) {
        }
        int n3 = n - this.offset;
        this.intLen -= n3;
        this.offset = this.intLen == 0 ? 0 : this.offset + n3;
    }

    private final void ensureCapacity(int n) {
        if (this.value.length < n) {
            this.value = new int[n];
            this.offset = 0;
            this.intLen = n;
        }
    }

    int[] toIntArray() {
        int[] nArray = new int[this.intLen];
        for (int i = 0; i < this.intLen; ++i) {
            nArray[i] = this.value[this.offset + i];
        }
        return nArray;
    }

    void setInt(int n, int n2) {
        this.value[this.offset + n] = n2;
    }

    void setValue(int[] nArray, int n) {
        this.value = nArray;
        this.intLen = n;
        this.offset = 0;
    }

    void copyValue(MutableBigInteger mutableBigInteger) {
        int n = mutableBigInteger.intLen;
        if (this.value.length < n) {
            this.value = new int[n];
        }
        System.arraycopy(mutableBigInteger.value, mutableBigInteger.offset, this.value, 0, n);
        this.intLen = n;
        this.offset = 0;
    }

    void copyValue(int[] nArray) {
        int n = nArray.length;
        if (this.value.length < n) {
            this.value = new int[n];
        }
        System.arraycopy(nArray, 0, this.value, 0, n);
        this.intLen = n;
        this.offset = 0;
    }

    boolean isOne() {
        return this.intLen == 1 && this.value[this.offset] == 1;
    }

    boolean isZero() {
        return this.intLen == 0;
    }

    boolean isEven() {
        return this.intLen == 0 || (this.value[this.offset + this.intLen - 1] & 1) == 0;
    }

    boolean isOdd() {
        return this.isZero() ? false : (this.value[this.offset + this.intLen - 1] & 1) == 1;
    }

    boolean isNormal() {
        if (this.intLen + this.offset > this.value.length) {
            return false;
        }
        if (this.intLen == 0) {
            return true;
        }
        return this.value[this.offset] != 0;
    }

    public String toString() {
        BigInteger bigInteger = this.toBigInteger(1);
        return bigInteger.toString();
    }

    void safeRightShift(int n) {
        if (n / 32 >= this.intLen) {
            this.reset();
        } else {
            this.rightShift(n);
        }
    }

    void rightShift(int n) {
        if (this.intLen == 0) {
            return;
        }
        int n2 = n >>> 5;
        int n3 = n & 0x1F;
        this.intLen -= n2;
        if (n3 == 0) {
            return;
        }
        int n4 = BigInteger.bitLengthForInt(this.value[this.offset]);
        if (n3 >= n4) {
            this.primitiveLeftShift(32 - n3);
            --this.intLen;
        } else {
            this.primitiveRightShift(n3);
        }
    }

    void safeLeftShift(int n) {
        if (n > 0) {
            this.leftShift(n);
        }
    }

    void leftShift(int n) {
        if (this.intLen == 0) {
            return;
        }
        int n2 = n >>> 5;
        int n3 = n & 0x1F;
        int n4 = BigInteger.bitLengthForInt(this.value[this.offset]);
        if (n <= 32 - n4) {
            this.primitiveLeftShift(n3);
            return;
        }
        int n5 = this.intLen + n2 + 1;
        if (n3 <= 32 - n4) {
            --n5;
        }
        if (this.value.length < n5) {
            int[] nArray = new int[n5];
            for (int i = 0; i < this.intLen; ++i) {
                nArray[i] = this.value[this.offset + i];
            }
            this.setValue(nArray, n5);
        } else if (this.value.length - this.offset >= n5) {
            for (int i = 0; i < n5 - this.intLen; ++i) {
                this.value[this.offset + this.intLen + i] = 0;
            }
        } else {
            int n6;
            for (n6 = 0; n6 < this.intLen; ++n6) {
                this.value[n6] = this.value[this.offset + n6];
            }
            for (n6 = this.intLen; n6 < n5; ++n6) {
                this.value[n6] = 0;
            }
            this.offset = 0;
        }
        this.intLen = n5;
        if (n3 == 0) {
            return;
        }
        if (n3 <= 32 - n4) {
            this.primitiveLeftShift(n3);
        } else {
            this.primitiveRightShift(32 - n3);
        }
    }

    private int divadd(int[] nArray, int[] nArray2, int n) {
        long l = 0L;
        for (int i = nArray.length - 1; i >= 0; --i) {
            long l2 = ((long)nArray[i] & 0xFFFFFFFFL) + ((long)nArray2[i + n] & 0xFFFFFFFFL) + l;
            nArray2[i + n] = (int)l2;
            l = l2 >>> 32;
        }
        return (int)l;
    }

    private int mulsub(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        long l = (long)n & 0xFFFFFFFFL;
        long l2 = 0L;
        n3 += n2;
        for (int i = n2 - 1; i >= 0; --i) {
            long l3 = ((long)nArray2[i] & 0xFFFFFFFFL) * l + l2;
            long l4 = (long)nArray[n3] - l3;
            nArray[n3--] = (int)l4;
            l2 = (l3 >>> 32) + (long)((l4 & 0xFFFFFFFFL) > ((long)(~((int)l3)) & 0xFFFFFFFFL) ? 1 : 0);
        }
        return (int)l2;
    }

    private int mulsubBorrow(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        long l = (long)n & 0xFFFFFFFFL;
        long l2 = 0L;
        n3 += n2;
        for (int i = n2 - 1; i >= 0; --i) {
            long l3;
            long l4;
            l2 = (l4 >>> 32) + (long)(((l3 = (long)nArray[n3--] - (l4 = ((long)nArray2[i] & 0xFFFFFFFFL) * l + l2)) & 0xFFFFFFFFL) > ((long)(~((int)l4)) & 0xFFFFFFFFL) ? 1 : 0);
        }
        return (int)l2;
    }

    private final void primitiveRightShift(int n) {
        int n2;
        int[] nArray = this.value;
        int n3 = 32 - n;
        int n4 = nArray[n2];
        for (n2 = this.offset + this.intLen - 1; n2 > this.offset; --n2) {
            int n5 = n4;
            n4 = nArray[n2 - 1];
            nArray[n2] = n4 << n3 | n5 >>> n;
        }
        int n6 = this.offset;
        nArray[n6] = nArray[n6] >>> n;
    }

    private final void primitiveLeftShift(int n) {
        int n2;
        int[] nArray = this.value;
        int n3 = 32 - n;
        int n4 = nArray[n2];
        int n5 = n2 + this.intLen - 1;
        for (n2 = this.offset; n2 < n5; ++n2) {
            int n6 = n4;
            n4 = nArray[n2 + 1];
            nArray[n2] = n6 << n | n4 >>> n3;
        }
        int n7 = this.offset + this.intLen - 1;
        nArray[n7] = nArray[n7] << n;
    }

    private BigInteger getLower(int n) {
        int n2;
        if (this.isZero()) {
            return BigInteger.ZERO;
        }
        if (this.intLen < n) {
            return this.toBigInteger(1);
        }
        for (n2 = n; n2 > 0 && this.value[this.offset + this.intLen - n2] == 0; --n2) {
        }
        int n3 = n2 > 0 ? 1 : 0;
        return new BigInteger(Arrays.copyOfRange(this.value, this.offset + this.intLen - n2, this.offset + this.intLen), n3);
    }

    private void keepLower(int n) {
        if (this.intLen >= n) {
            this.offset += this.intLen - n;
            this.intLen = n;
        }
    }

    void add(MutableBigInteger mutableBigInteger) {
        long l;
        int n = this.intLen;
        int n2 = mutableBigInteger.intLen;
        int n3 = this.intLen > mutableBigInteger.intLen ? this.intLen : mutableBigInteger.intLen;
        int[] nArray = this.value.length < n3 ? new int[n3] : this.value;
        int n4 = nArray.length - 1;
        long l2 = 0L;
        while (n > 0 && n2 > 0) {
            l = ((long)this.value[--n + this.offset] & 0xFFFFFFFFL) + ((long)mutableBigInteger.value[--n2 + mutableBigInteger.offset] & 0xFFFFFFFFL) + l2;
            nArray[n4--] = (int)l;
            l2 = l >>> 32;
        }
        while (n > 0) {
            if (l2 == 0L && nArray == this.value && n4 == --n + this.offset) {
                return;
            }
            l = ((long)this.value[n + this.offset] & 0xFFFFFFFFL) + l2;
            nArray[n4--] = (int)l;
            l2 = l >>> 32;
        }
        while (n2 > 0) {
            l = ((long)mutableBigInteger.value[--n2 + mutableBigInteger.offset] & 0xFFFFFFFFL) + l2;
            nArray[n4--] = (int)l;
            l2 = l >>> 32;
        }
        if (l2 > 0L) {
            if (nArray.length < ++n3) {
                int[] nArray2 = new int[n3];
                System.arraycopy(nArray, 0, nArray2, 1, nArray.length);
                nArray2[0] = 1;
                nArray = nArray2;
            } else {
                nArray[n4--] = 1;
            }
        }
        this.value = nArray;
        this.intLen = n3;
        this.offset = nArray.length - n3;
    }

    void addShifted(MutableBigInteger mutableBigInteger, int n) {
        long l;
        int n2;
        if (mutableBigInteger.isZero()) {
            return;
        }
        int n3 = this.intLen;
        int n4 = mutableBigInteger.intLen + n;
        int n5 = this.intLen > n4 ? this.intLen : n4;
        int[] nArray = this.value.length < n5 ? new int[n5] : this.value;
        int n6 = nArray.length - 1;
        long l2 = 0L;
        while (n3 > 0 && n4 > 0) {
            n2 = --n4 + mutableBigInteger.offset < mutableBigInteger.value.length ? mutableBigInteger.value[n4 + mutableBigInteger.offset] : 0;
            l = ((long)this.value[--n3 + this.offset] & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL) + l2;
            nArray[n6--] = (int)l;
            l2 = l >>> 32;
        }
        while (n3 > 0) {
            if (l2 == 0L && nArray == this.value && n6 == --n3 + this.offset) {
                return;
            }
            l = ((long)this.value[n3 + this.offset] & 0xFFFFFFFFL) + l2;
            nArray[n6--] = (int)l;
            l2 = l >>> 32;
        }
        while (n4 > 0) {
            n2 = --n4 + mutableBigInteger.offset < mutableBigInteger.value.length ? mutableBigInteger.value[n4 + mutableBigInteger.offset] : 0;
            l = ((long)n2 & 0xFFFFFFFFL) + l2;
            nArray[n6--] = (int)l;
            l2 = l >>> 32;
        }
        if (l2 > 0L) {
            if (nArray.length < ++n5) {
                int[] nArray2 = new int[n5];
                System.arraycopy(nArray, 0, nArray2, 1, nArray.length);
                nArray2[0] = 1;
                nArray = nArray2;
            } else {
                nArray[n6--] = 1;
            }
        }
        this.value = nArray;
        this.intLen = n5;
        this.offset = nArray.length - n5;
    }

    void addDisjoint(MutableBigInteger mutableBigInteger, int n) {
        int[] nArray;
        int n2;
        if (mutableBigInteger.isZero()) {
            return;
        }
        int n3 = this.intLen;
        int n4 = mutableBigInteger.intLen + n;
        int n5 = n2 = this.intLen > n4 ? this.intLen : n4;
        if (this.value.length < n2) {
            nArray = new int[n2];
        } else {
            nArray = this.value;
            Arrays.fill(this.value, this.offset + this.intLen, this.value.length, 0);
        }
        int n6 = nArray.length - 1;
        System.arraycopy(this.value, this.offset, nArray, n6 + 1 - n3, n3);
        int n7 = Math.min(n4 -= n3, mutableBigInteger.value.length - mutableBigInteger.offset);
        System.arraycopy(mutableBigInteger.value, mutableBigInteger.offset, nArray, (n6 -= n3) + 1 - n4, n7);
        for (int i = n6 + 1 - n4 + n7; i < n6 + 1; ++i) {
            nArray[i] = 0;
        }
        this.value = nArray;
        this.intLen = n2;
        this.offset = nArray.length - n2;
    }

    void addLower(MutableBigInteger mutableBigInteger, int n) {
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(mutableBigInteger);
        if (mutableBigInteger2.offset + mutableBigInteger2.intLen >= n) {
            mutableBigInteger2.offset = mutableBigInteger2.offset + mutableBigInteger2.intLen - n;
            mutableBigInteger2.intLen = n;
        }
        mutableBigInteger2.normalize();
        this.add(mutableBigInteger2);
    }

    int subtract(MutableBigInteger mutableBigInteger) {
        int n;
        MutableBigInteger mutableBigInteger2 = this;
        int[] nArray = this.value;
        int n2 = mutableBigInteger2.compare(mutableBigInteger);
        if (n2 == 0) {
            this.reset();
            return 0;
        }
        if (n2 < 0) {
            MutableBigInteger mutableBigInteger3 = mutableBigInteger2;
            mutableBigInteger2 = mutableBigInteger;
            mutableBigInteger = mutableBigInteger3;
        }
        if (nArray.length < (n = mutableBigInteger2.intLen)) {
            nArray = new int[n];
        }
        long l = 0L;
        int n3 = mutableBigInteger2.intLen;
        int n4 = mutableBigInteger.intLen;
        int n5 = nArray.length - 1;
        while (n4 > 0) {
            l = ((long)mutableBigInteger2.value[--n3 + mutableBigInteger2.offset] & 0xFFFFFFFFL) - ((long)mutableBigInteger.value[--n4 + mutableBigInteger.offset] & 0xFFFFFFFFL) - (long)((int)(-(l >> 32)));
            nArray[n5--] = (int)l;
        }
        while (n3 > 0) {
            l = ((long)mutableBigInteger2.value[--n3 + mutableBigInteger2.offset] & 0xFFFFFFFFL) - (long)((int)(-(l >> 32)));
            nArray[n5--] = (int)l;
        }
        this.value = nArray;
        this.intLen = n;
        this.offset = this.value.length - n;
        this.normalize();
        return n2;
    }

    private int difference(MutableBigInteger mutableBigInteger) {
        MutableBigInteger mutableBigInteger2 = this;
        int n = mutableBigInteger2.compare(mutableBigInteger);
        if (n == 0) {
            return 0;
        }
        if (n < 0) {
            MutableBigInteger mutableBigInteger3 = mutableBigInteger2;
            mutableBigInteger2 = mutableBigInteger;
            mutableBigInteger = mutableBigInteger3;
        }
        long l = 0L;
        int n2 = mutableBigInteger2.intLen;
        int n3 = mutableBigInteger.intLen;
        while (n3 > 0) {
            l = ((long)mutableBigInteger2.value[mutableBigInteger2.offset + --n2] & 0xFFFFFFFFL) - ((long)mutableBigInteger.value[mutableBigInteger.offset + --n3] & 0xFFFFFFFFL) - (long)((int)(-(l >> 32)));
            mutableBigInteger2.value[mutableBigInteger2.offset + n2] = (int)l;
        }
        while (n2 > 0) {
            l = ((long)mutableBigInteger2.value[mutableBigInteger2.offset + --n2] & 0xFFFFFFFFL) - (long)((int)(-(l >> 32)));
            mutableBigInteger2.value[mutableBigInteger2.offset + n2] = (int)l;
        }
        mutableBigInteger2.normalize();
        return n;
    }

    void multiply(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2) {
        int n = this.intLen;
        int n2 = mutableBigInteger.intLen;
        int n3 = n + n2;
        if (mutableBigInteger2.value.length < n3) {
            mutableBigInteger2.value = new int[n3];
        }
        mutableBigInteger2.offset = 0;
        mutableBigInteger2.intLen = n3;
        long l = 0L;
        int n4 = n2 - 1;
        int n5 = n2 + n - 1;
        while (n4 >= 0) {
            long l2 = ((long)mutableBigInteger.value[n4 + mutableBigInteger.offset] & 0xFFFFFFFFL) * ((long)this.value[n - 1 + this.offset] & 0xFFFFFFFFL) + l;
            mutableBigInteger2.value[n5] = (int)l2;
            l = l2 >>> 32;
            --n4;
            --n5;
        }
        mutableBigInteger2.value[n - 1] = (int)l;
        for (n4 = n - 2; n4 >= 0; --n4) {
            l = 0L;
            n5 = n2 - 1;
            int n6 = n2 + n4;
            while (n5 >= 0) {
                long l3 = ((long)mutableBigInteger.value[n5 + mutableBigInteger.offset] & 0xFFFFFFFFL) * ((long)this.value[n4 + this.offset] & 0xFFFFFFFFL) + ((long)mutableBigInteger2.value[n6] & 0xFFFFFFFFL) + l;
                mutableBigInteger2.value[n6] = (int)l3;
                l = l3 >>> 32;
                --n5;
                --n6;
            }
            mutableBigInteger2.value[n4] = (int)l;
        }
        mutableBigInteger2.normalize();
    }

    void mul(int n, MutableBigInteger mutableBigInteger) {
        if (n == 1) {
            mutableBigInteger.copyValue(this);
            return;
        }
        if (n == 0) {
            mutableBigInteger.clear();
            return;
        }
        long l = (long)n & 0xFFFFFFFFL;
        int[] nArray = mutableBigInteger.value.length < this.intLen + 1 ? new int[this.intLen + 1] : mutableBigInteger.value;
        long l2 = 0L;
        for (int i = this.intLen - 1; i >= 0; --i) {
            long l3 = l * ((long)this.value[i + this.offset] & 0xFFFFFFFFL) + l2;
            nArray[i + 1] = (int)l3;
            l2 = l3 >>> 32;
        }
        if (l2 == 0L) {
            mutableBigInteger.offset = 1;
            mutableBigInteger.intLen = this.intLen;
        } else {
            mutableBigInteger.offset = 0;
            mutableBigInteger.intLen = this.intLen + 1;
            nArray[0] = (int)l2;
        }
        mutableBigInteger.value = nArray;
    }

    int divideOneWord(int n, MutableBigInteger mutableBigInteger) {
        long l = (long)n & 0xFFFFFFFFL;
        if (this.intLen == 1) {
            long l2 = (long)this.value[this.offset] & 0xFFFFFFFFL;
            int n2 = (int)(l2 / l);
            int n3 = (int)(l2 - (long)n2 * l);
            mutableBigInteger.value[0] = n2;
            mutableBigInteger.intLen = n2 == 0 ? 0 : 1;
            mutableBigInteger.offset = 0;
            return n3;
        }
        if (mutableBigInteger.value.length < this.intLen) {
            mutableBigInteger.value = new int[this.intLen];
        }
        mutableBigInteger.offset = 0;
        mutableBigInteger.intLen = this.intLen;
        int n4 = Integer.numberOfLeadingZeros(n);
        int n5 = this.value[this.offset];
        long l3 = (long)n5 & 0xFFFFFFFFL;
        if (l3 < l) {
            mutableBigInteger.value[0] = 0;
        } else {
            mutableBigInteger.value[0] = (int)(l3 / l);
            n5 = (int)(l3 - (long)mutableBigInteger.value[0] * l);
            l3 = (long)n5 & 0xFFFFFFFFL;
        }
        int n6 = this.intLen;
        while (--n6 > 0) {
            int n7;
            long l4 = l3 << 32 | (long)this.value[this.offset + this.intLen - n6] & 0xFFFFFFFFL;
            if (l4 >= 0L) {
                n7 = (int)(l4 / l);
                n5 = (int)(l4 - (long)n7 * l);
            } else {
                long l5 = MutableBigInteger.divWord(l4, n);
                n7 = (int)(l5 & 0xFFFFFFFFL);
                n5 = (int)(l5 >>> 32);
            }
            mutableBigInteger.value[this.intLen - n6] = n7;
            l3 = (long)n5 & 0xFFFFFFFFL;
        }
        mutableBigInteger.normalize();
        if (n4 > 0) {
            return n5 % n;
        }
        return n5;
    }

    MutableBigInteger divide(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2) {
        return this.divide(mutableBigInteger, mutableBigInteger2, true);
    }

    MutableBigInteger divide(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2, boolean bl) {
        if (mutableBigInteger.intLen < 80 || this.intLen - mutableBigInteger.intLen < 40) {
            return this.divideKnuth(mutableBigInteger, mutableBigInteger2, bl);
        }
        return this.divideAndRemainderBurnikelZiegler(mutableBigInteger, mutableBigInteger2);
    }

    MutableBigInteger divideKnuth(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2) {
        return this.divideKnuth(mutableBigInteger, mutableBigInteger2, true);
    }

    MutableBigInteger divideKnuth(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2, boolean bl) {
        int n;
        if (mutableBigInteger.intLen == 0) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        if (this.intLen == 0) {
            mutableBigInteger2.offset = 0;
            mutableBigInteger2.intLen = 0;
            return bl ? new MutableBigInteger() : null;
        }
        int n2 = this.compare(mutableBigInteger);
        if (n2 < 0) {
            mutableBigInteger2.offset = 0;
            mutableBigInteger2.intLen = 0;
            return bl ? new MutableBigInteger(this) : null;
        }
        if (n2 == 0) {
            mutableBigInteger2.intLen = 1;
            mutableBigInteger2.value[0] = 1;
            mutableBigInteger2.offset = 0;
            return bl ? new MutableBigInteger() : null;
        }
        mutableBigInteger2.clear();
        if (mutableBigInteger.intLen == 1) {
            int n3 = this.divideOneWord(mutableBigInteger.value[mutableBigInteger.offset], mutableBigInteger2);
            if (bl) {
                if (n3 == 0) {
                    return new MutableBigInteger();
                }
                return new MutableBigInteger(n3);
            }
            return null;
        }
        if (this.intLen >= 6 && (n = Math.min(this.getLowestSetBit(), mutableBigInteger.getLowestSetBit())) >= 96) {
            MutableBigInteger mutableBigInteger3 = new MutableBigInteger(this);
            mutableBigInteger = new MutableBigInteger(mutableBigInteger);
            mutableBigInteger3.rightShift(n);
            mutableBigInteger.rightShift(n);
            MutableBigInteger mutableBigInteger4 = mutableBigInteger3.divideKnuth(mutableBigInteger, mutableBigInteger2);
            mutableBigInteger4.leftShift(n);
            return mutableBigInteger4;
        }
        return this.divideMagnitude(mutableBigInteger, mutableBigInteger2, bl);
    }

    MutableBigInteger divideAndRemainderBurnikelZiegler(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2) {
        MutableBigInteger mutableBigInteger3;
        int n = this.intLen;
        int n2 = mutableBigInteger.intLen;
        mutableBigInteger2.intLen = 0;
        mutableBigInteger2.offset = 0;
        if (n < n2) {
            return this;
        }
        int n3 = 1 << 32 - Integer.numberOfLeadingZeros(n2 / 80);
        int n4 = (n2 + n3 - 1) / n3;
        int n5 = n4 * n3;
        long l = 32L * (long)n5;
        int n6 = (int)Math.max(0L, l - mutableBigInteger.bitLength());
        MutableBigInteger mutableBigInteger4 = new MutableBigInteger(mutableBigInteger);
        mutableBigInteger4.safeLeftShift(n6);
        MutableBigInteger mutableBigInteger5 = new MutableBigInteger(this);
        mutableBigInteger5.safeLeftShift(n6);
        int n7 = (int)((mutableBigInteger5.bitLength() + l) / l);
        if (n7 < 2) {
            n7 = 2;
        }
        MutableBigInteger mutableBigInteger6 = mutableBigInteger5.getBlock(n7 - 1, n7, n5);
        MutableBigInteger mutableBigInteger7 = mutableBigInteger5.getBlock(n7 - 2, n7, n5);
        mutableBigInteger7.addDisjoint(mutableBigInteger6, n5);
        MutableBigInteger mutableBigInteger8 = new MutableBigInteger();
        for (int i = n7 - 2; i > 0; --i) {
            mutableBigInteger3 = mutableBigInteger7.divide2n1n(mutableBigInteger4, mutableBigInteger8);
            mutableBigInteger7 = mutableBigInteger5.getBlock(i - 1, n7, n5);
            mutableBigInteger7.addDisjoint(mutableBigInteger3, n5);
            mutableBigInteger2.addShifted(mutableBigInteger8, i * n5);
        }
        mutableBigInteger3 = mutableBigInteger7.divide2n1n(mutableBigInteger4, mutableBigInteger8);
        mutableBigInteger2.add(mutableBigInteger8);
        mutableBigInteger3.rightShift(n6);
        return mutableBigInteger3;
    }

    private MutableBigInteger divide2n1n(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2) {
        int n = mutableBigInteger.intLen;
        if (n % 2 != 0 || n < 80) {
            return this.divideKnuth(mutableBigInteger, mutableBigInteger2);
        }
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(this);
        mutableBigInteger3.safeRightShift(32 * (n / 2));
        this.keepLower(n / 2);
        MutableBigInteger mutableBigInteger4 = new MutableBigInteger();
        MutableBigInteger mutableBigInteger5 = mutableBigInteger3.divide3n2n(mutableBigInteger, mutableBigInteger4);
        this.addDisjoint(mutableBigInteger5, n / 2);
        MutableBigInteger mutableBigInteger6 = this.divide3n2n(mutableBigInteger, mutableBigInteger2);
        mutableBigInteger2.addDisjoint(mutableBigInteger4, n / 2);
        return mutableBigInteger6;
    }

    private MutableBigInteger divide3n2n(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2) {
        MutableBigInteger mutableBigInteger3;
        MutableBigInteger mutableBigInteger4;
        int n = mutableBigInteger.intLen / 2;
        MutableBigInteger mutableBigInteger5 = new MutableBigInteger(this);
        mutableBigInteger5.safeRightShift(32 * n);
        MutableBigInteger mutableBigInteger6 = new MutableBigInteger(mutableBigInteger);
        mutableBigInteger6.safeRightShift(n * 32);
        BigInteger bigInteger = mutableBigInteger.getLower(n);
        if (this.compareShifted(mutableBigInteger, n) < 0) {
            mutableBigInteger4 = mutableBigInteger5.divide2n1n(mutableBigInteger6, mutableBigInteger2);
            mutableBigInteger3 = new MutableBigInteger(mutableBigInteger2.toBigInteger().multiply(bigInteger));
        } else {
            mutableBigInteger2.ones(n);
            mutableBigInteger5.add(mutableBigInteger6);
            mutableBigInteger6.leftShift(32 * n);
            mutableBigInteger5.subtract(mutableBigInteger6);
            mutableBigInteger4 = mutableBigInteger5;
            mutableBigInteger3 = new MutableBigInteger(bigInteger);
            mutableBigInteger3.leftShift(32 * n);
            mutableBigInteger3.subtract(new MutableBigInteger(bigInteger));
        }
        mutableBigInteger4.leftShift(32 * n);
        mutableBigInteger4.addLower(this, n);
        while (mutableBigInteger4.compare(mutableBigInteger3) < 0) {
            mutableBigInteger4.add(mutableBigInteger);
            mutableBigInteger2.subtract(ONE);
        }
        mutableBigInteger4.subtract(mutableBigInteger3);
        return mutableBigInteger4;
    }

    private MutableBigInteger getBlock(int n, int n2, int n3) {
        int n4 = n * n3;
        if (n4 >= this.intLen) {
            return new MutableBigInteger();
        }
        int n5 = n == n2 - 1 ? this.intLen : (n + 1) * n3;
        if (n5 > this.intLen) {
            return new MutableBigInteger();
        }
        int[] nArray = Arrays.copyOfRange(this.value, this.offset + this.intLen - n5, this.offset + this.intLen - n4);
        return new MutableBigInteger(nArray);
    }

    long bitLength() {
        if (this.intLen == 0) {
            return 0L;
        }
        return (long)this.intLen * 32L - (long)Integer.numberOfLeadingZeros(this.value[this.offset]);
    }

    long divide(long l, MutableBigInteger mutableBigInteger) {
        if (l == 0L) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        if (this.intLen == 0) {
            mutableBigInteger.offset = 0;
            mutableBigInteger.intLen = 0;
            return 0L;
        }
        if (l < 0L) {
            l = -l;
        }
        int n = (int)(l >>> 32);
        mutableBigInteger.clear();
        if (n == 0) {
            return (long)this.divideOneWord((int)l, mutableBigInteger) & 0xFFFFFFFFL;
        }
        return this.divideLongMagnitude(l, mutableBigInteger).toLong();
    }

    private static void copyAndShift(int[] nArray, int n, int n2, int[] nArray2, int n3, int n4) {
        int n5 = 32 - n4;
        int n6 = nArray[n];
        for (int i = 0; i < n2 - 1; ++i) {
            int n7 = n6;
            n6 = nArray[++n];
            nArray2[n3 + i] = n7 << n4 | n6 >>> n5;
        }
        nArray2[n3 + n2 - 1] = n6 << n4;
    }

    private MutableBigInteger divideMagnitude(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2, boolean bl) {
        long l;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        MutableBigInteger mutableBigInteger3;
        int[] nArray;
        int n9 = Integer.numberOfLeadingZeros(mutableBigInteger.value[mutableBigInteger.offset]);
        int n10 = mutableBigInteger.intLen;
        if (n9 > 0) {
            int[] nArray2;
            nArray = new int[n10];
            MutableBigInteger.copyAndShift(mutableBigInteger.value, mutableBigInteger.offset, n10, nArray, 0, n9);
            if (Integer.numberOfLeadingZeros(this.value[this.offset]) >= n9) {
                nArray2 = new int[this.intLen + 1];
                mutableBigInteger3 = new MutableBigInteger(nArray2);
                mutableBigInteger3.intLen = this.intLen;
                mutableBigInteger3.offset = 1;
                MutableBigInteger.copyAndShift(this.value, this.offset, this.intLen, nArray2, 1, n9);
            } else {
                nArray2 = new int[this.intLen + 2];
                mutableBigInteger3 = new MutableBigInteger(nArray2);
                mutableBigInteger3.intLen = this.intLen + 1;
                mutableBigInteger3.offset = 1;
                n8 = this.offset;
                int n11 = 0;
                n7 = 32 - n9;
                int n12 = 1;
                while (n12 < this.intLen + 1) {
                    int n13 = n11;
                    n11 = this.value[n8];
                    nArray2[n12] = n13 << n9 | n11 >>> n7;
                    ++n12;
                    ++n8;
                }
                nArray2[this.intLen + 1] = n11 << n9;
            }
        } else {
            nArray = Arrays.copyOfRange(mutableBigInteger.value, mutableBigInteger.offset, mutableBigInteger.offset + mutableBigInteger.intLen);
            mutableBigInteger3 = new MutableBigInteger(new int[this.intLen + 1]);
            System.arraycopy(this.value, this.offset, mutableBigInteger3.value, 1, this.intLen);
            mutableBigInteger3.intLen = this.intLen;
            mutableBigInteger3.offset = 1;
        }
        int n14 = mutableBigInteger3.intLen;
        n8 = n14 - n10 + 1;
        if (mutableBigInteger2.value.length < n8) {
            mutableBigInteger2.value = new int[n8];
            mutableBigInteger2.offset = 0;
        }
        mutableBigInteger2.intLen = n8;
        int[] nArray3 = mutableBigInteger2.value;
        if (mutableBigInteger3.intLen == n14) {
            mutableBigInteger3.offset = 0;
            mutableBigInteger3.value[0] = 0;
            ++mutableBigInteger3.intLen;
        }
        n7 = nArray[0];
        long l2 = (long)n7 & 0xFFFFFFFFL;
        int n15 = nArray[1];
        for (n6 = 0; n6 < n8 - 1; ++n6) {
            long l3;
            long l4;
            long l5;
            n5 = 0;
            n4 = 0;
            n3 = 0;
            n2 = mutableBigInteger3.value[n6 + mutableBigInteger3.offset];
            n = n2 + Integer.MIN_VALUE;
            int n16 = mutableBigInteger3.value[n6 + 1 + mutableBigInteger3.offset];
            if (n2 == n7) {
                n5 = -1;
                n4 = n2 + n16;
                n3 = n4 + Integer.MIN_VALUE < n ? 1 : 0;
            } else {
                l5 = (long)n2 << 32 | (long)n16 & 0xFFFFFFFFL;
                if (l5 >= 0L) {
                    n5 = (int)(l5 / l2);
                    n4 = (int)(l5 - (long)n5 * l2);
                } else {
                    l4 = MutableBigInteger.divWord(l5, n7);
                    n5 = (int)(l4 & 0xFFFFFFFFL);
                    n4 = (int)(l4 >>> 32);
                }
            }
            if (n5 == 0) continue;
            if (n3 == 0 && this.unsignedLongCompare(l3 = ((long)n15 & 0xFFFFFFFFL) * ((long)n5 & 0xFFFFFFFFL), l4 = ((long)n4 & 0xFFFFFFFFL) << 32 | (l5 = (long)mutableBigInteger3.value[n6 + 2 + mutableBigInteger3.offset] & 0xFFFFFFFFL))) {
                --n5;
                if (((long)(n4 = (int)(((long)n4 & 0xFFFFFFFFL) + l2)) & 0xFFFFFFFFL) >= l2 && this.unsignedLongCompare(l3 -= (long)n15 & 0xFFFFFFFFL, l4 = ((long)n4 & 0xFFFFFFFFL) << 32 | l5)) {
                    --n5;
                }
            }
            mutableBigInteger3.value[n6 + mutableBigInteger3.offset] = 0;
            int n17 = this.mulsub(mutableBigInteger3.value, nArray, n5, n10, n6 + mutableBigInteger3.offset);
            if (n17 + Integer.MIN_VALUE > n) {
                this.divadd(nArray, mutableBigInteger3.value, n6 + 1 + mutableBigInteger3.offset);
            }
            nArray3[n6] = --n5;
        }
        n6 = 0;
        n5 = 0;
        n4 = 0;
        n3 = mutableBigInteger3.value[n8 - 1 + mutableBigInteger3.offset];
        n2 = n3 + Integer.MIN_VALUE;
        n = mutableBigInteger3.value[n8 + mutableBigInteger3.offset];
        if (n3 == n7) {
            n6 = -1;
            n5 = n3 + n;
            n4 = n5 + Integer.MIN_VALUE < n2 ? 1 : 0;
        } else {
            long l6 = (long)n3 << 32 | (long)n & 0xFFFFFFFFL;
            if (l6 >= 0L) {
                n6 = (int)(l6 / l2);
                n5 = (int)(l6 - (long)n6 * l2);
            } else {
                l = MutableBigInteger.divWord(l6, n7);
                n6 = (int)(l & 0xFFFFFFFFL);
                n5 = (int)(l >>> 32);
            }
        }
        if (n6 != 0) {
            long l7;
            long l8;
            if (n4 == 0 && this.unsignedLongCompare(l8 = ((long)n15 & 0xFFFFFFFFL) * ((long)n6 & 0xFFFFFFFFL), l = ((long)n5 & 0xFFFFFFFFL) << 32 | (l7 = (long)mutableBigInteger3.value[n8 + 1 + mutableBigInteger3.offset] & 0xFFFFFFFFL))) {
                --n6;
                if (((long)(n5 = (int)(((long)n5 & 0xFFFFFFFFL) + l2)) & 0xFFFFFFFFL) >= l2 && this.unsignedLongCompare(l8 -= (long)n15 & 0xFFFFFFFFL, l = ((long)n5 & 0xFFFFFFFFL) << 32 | l7)) {
                    --n6;
                }
            }
            mutableBigInteger3.value[n8 - 1 + mutableBigInteger3.offset] = 0;
            int n18 = bl ? this.mulsub(mutableBigInteger3.value, nArray, n6, n10, n8 - 1 + mutableBigInteger3.offset) : this.mulsubBorrow(mutableBigInteger3.value, nArray, n6, n10, n8 - 1 + mutableBigInteger3.offset);
            if (n18 + Integer.MIN_VALUE > n2 && bl) {
                this.divadd(nArray, mutableBigInteger3.value, n8 - 1 + 1 + mutableBigInteger3.offset);
            }
            nArray3[n8 - 1] = --n6;
        }
        if (bl) {
            if (n9 > 0) {
                mutableBigInteger3.rightShift(n9);
            }
            mutableBigInteger3.normalize();
        }
        mutableBigInteger2.normalize();
        return bl ? mutableBigInteger3 : null;
    }

    private MutableBigInteger divideLongMagnitude(long l, MutableBigInteger mutableBigInteger) {
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(new int[this.intLen + 1]);
        System.arraycopy(this.value, this.offset, mutableBigInteger2.value, 1, this.intLen);
        mutableBigInteger2.intLen = this.intLen;
        mutableBigInteger2.offset = 1;
        int n = mutableBigInteger2.intLen;
        int n2 = n - 2 + 1;
        if (mutableBigInteger.value.length < n2) {
            mutableBigInteger.value = new int[n2];
            mutableBigInteger.offset = 0;
        }
        mutableBigInteger.intLen = n2;
        int[] nArray = mutableBigInteger.value;
        int n3 = Long.numberOfLeadingZeros(l);
        if (n3 > 0) {
            l <<= n3;
            mutableBigInteger2.leftShift(n3);
        }
        if (mutableBigInteger2.intLen == n) {
            mutableBigInteger2.offset = 0;
            mutableBigInteger2.value[0] = 0;
            ++mutableBigInteger2.intLen;
        }
        int n4 = (int)(l >>> 32);
        long l2 = (long)n4 & 0xFFFFFFFFL;
        int n5 = (int)(l & 0xFFFFFFFFL);
        for (int i = 0; i < n2; ++i) {
            long l3;
            long l4;
            long l5;
            int n6 = 0;
            int n7 = 0;
            boolean bl = false;
            int n8 = mutableBigInteger2.value[i + mutableBigInteger2.offset];
            int n9 = n8 + Integer.MIN_VALUE;
            int n10 = mutableBigInteger2.value[i + 1 + mutableBigInteger2.offset];
            if (n8 == n4) {
                n6 = -1;
                n7 = n8 + n10;
                bl = n7 + Integer.MIN_VALUE < n9;
            } else {
                l5 = (long)n8 << 32 | (long)n10 & 0xFFFFFFFFL;
                if (l5 >= 0L) {
                    n6 = (int)(l5 / l2);
                    n7 = (int)(l5 - (long)n6 * l2);
                } else {
                    l4 = MutableBigInteger.divWord(l5, n4);
                    n6 = (int)(l4 & 0xFFFFFFFFL);
                    n7 = (int)(l4 >>> 32);
                }
            }
            if (n6 == 0) continue;
            if (!bl && this.unsignedLongCompare(l3 = ((long)n5 & 0xFFFFFFFFL) * ((long)n6 & 0xFFFFFFFFL), l4 = ((long)n7 & 0xFFFFFFFFL) << 32 | (l5 = (long)mutableBigInteger2.value[i + 2 + mutableBigInteger2.offset] & 0xFFFFFFFFL))) {
                --n6;
                if (((long)(n7 = (int)(((long)n7 & 0xFFFFFFFFL) + l2)) & 0xFFFFFFFFL) >= l2 && this.unsignedLongCompare(l3 -= (long)n5 & 0xFFFFFFFFL, l4 = ((long)n7 & 0xFFFFFFFFL) << 32 | l5)) {
                    --n6;
                }
            }
            mutableBigInteger2.value[i + mutableBigInteger2.offset] = 0;
            int n11 = this.mulsubLong(mutableBigInteger2.value, n4, n5, n6, i + mutableBigInteger2.offset);
            if (n11 + Integer.MIN_VALUE > n9) {
                this.divaddLong(n4, n5, mutableBigInteger2.value, i + 1 + mutableBigInteger2.offset);
            }
            nArray[i] = --n6;
        }
        if (n3 > 0) {
            mutableBigInteger2.rightShift(n3);
        }
        mutableBigInteger.normalize();
        mutableBigInteger2.normalize();
        return mutableBigInteger2;
    }

    private int divaddLong(int n, int n2, int[] nArray, int n3) {
        long l = 0L;
        long l2 = ((long)n2 & 0xFFFFFFFFL) + ((long)nArray[1 + n3] & 0xFFFFFFFFL);
        nArray[1 + n3] = (int)l2;
        l2 = ((long)n & 0xFFFFFFFFL) + ((long)nArray[n3] & 0xFFFFFFFFL) + l;
        nArray[n3] = (int)l2;
        l = l2 >>> 32;
        return (int)l;
    }

    private int mulsubLong(int[] nArray, int n, int n2, int n3, int n4) {
        long l = (long)n3 & 0xFFFFFFFFL;
        long l2 = ((long)n2 & 0xFFFFFFFFL) * l;
        long l3 = (long)nArray[n4 += 2] - l2;
        nArray[n4--] = (int)l3;
        long l4 = (l2 >>> 32) + (long)((l3 & 0xFFFFFFFFL) > ((long)(~((int)l2)) & 0xFFFFFFFFL) ? 1 : 0);
        l2 = ((long)n & 0xFFFFFFFFL) * l + l4;
        l3 = (long)nArray[n4] - l2;
        nArray[n4--] = (int)l3;
        l4 = (l2 >>> 32) + (long)((l3 & 0xFFFFFFFFL) > ((long)(~((int)l2)) & 0xFFFFFFFFL) ? 1 : 0);
        return (int)l4;
    }

    private boolean unsignedLongCompare(long l, long l2) {
        return l + Long.MIN_VALUE > l2 + Long.MIN_VALUE;
    }

    static long divWord(long l, int n) {
        long l2 = (long)n & 0xFFFFFFFFL;
        if (l2 == 1L) {
            long l3 = (int)l;
            long l4 = 0L;
            return l4 << 32 | l3 & 0xFFFFFFFFL;
        }
        long l5 = (l >>> 1) / (l2 >>> 1);
        long l6 = l - l5 * l2;
        while (l6 < 0L) {
            l6 += l2;
            --l5;
        }
        while (l6 >= l2) {
            l6 -= l2;
            ++l5;
        }
        return l6 << 32 | l5 & 0xFFFFFFFFL;
    }

    MutableBigInteger hybridGCD(MutableBigInteger mutableBigInteger) {
        MutableBigInteger mutableBigInteger2 = this;
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger();
        while (mutableBigInteger.intLen != 0) {
            if (Math.abs(mutableBigInteger2.intLen - mutableBigInteger.intLen) < 2) {
                return mutableBigInteger2.binaryGCD(mutableBigInteger);
            }
            MutableBigInteger mutableBigInteger4 = mutableBigInteger2.divide(mutableBigInteger, mutableBigInteger3);
            mutableBigInteger2 = mutableBigInteger;
            mutableBigInteger = mutableBigInteger4;
        }
        return mutableBigInteger2;
    }

    private MutableBigInteger binaryGCD(MutableBigInteger mutableBigInteger) {
        int n;
        int n2;
        int n3;
        int n4;
        MutableBigInteger mutableBigInteger2 = this;
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger();
        int n5 = mutableBigInteger2.getLowestSetBit();
        int n6 = n4 = n5 < (n3 = mutableBigInteger.getLowestSetBit()) ? n5 : n3;
        if (n4 != 0) {
            mutableBigInteger2.rightShift(n4);
            mutableBigInteger.rightShift(n4);
        }
        boolean bl = n4 == n5;
        MutableBigInteger mutableBigInteger4 = bl ? mutableBigInteger : mutableBigInteger2;
        int n7 = n2 = bl ? -1 : 1;
        while ((n = mutableBigInteger4.getLowestSetBit()) >= 0) {
            mutableBigInteger4.rightShift(n);
            if (n2 > 0) {
                mutableBigInteger2 = mutableBigInteger4;
            } else {
                mutableBigInteger = mutableBigInteger4;
            }
            if (mutableBigInteger2.intLen < 2 && mutableBigInteger.intLen < 2) {
                int n8 = mutableBigInteger2.value[mutableBigInteger2.offset];
                int n9 = mutableBigInteger.value[mutableBigInteger.offset];
                mutableBigInteger3.value[0] = n8 = MutableBigInteger.binaryGcd(n8, n9);
                mutableBigInteger3.intLen = 1;
                mutableBigInteger3.offset = 0;
                if (n4 > 0) {
                    mutableBigInteger3.leftShift(n4);
                }
                return mutableBigInteger3;
            }
            n2 = mutableBigInteger2.difference(mutableBigInteger);
            if (n2 == 0) break;
            mutableBigInteger4 = n2 >= 0 ? mutableBigInteger2 : mutableBigInteger;
        }
        if (n4 > 0) {
            mutableBigInteger2.leftShift(n4);
        }
        return mutableBigInteger2;
    }

    static int binaryGcd(int n, int n2) {
        int n3;
        if (n2 == 0) {
            return n;
        }
        if (n == 0) {
            return n2;
        }
        int n4 = Integer.numberOfTrailingZeros(n);
        int n5 = Integer.numberOfTrailingZeros(n2);
        n >>>= n4;
        n2 >>>= n5;
        int n6 = n3 = n4 < n5 ? n4 : n5;
        while (n != n2) {
            if (n + Integer.MIN_VALUE > n2 + Integer.MIN_VALUE) {
                n -= n2;
                n >>>= Integer.numberOfTrailingZeros(n);
                continue;
            }
            n2 -= n;
            n2 >>>= Integer.numberOfTrailingZeros(n2);
        }
        return n << n3;
    }

    MutableBigInteger mutableModInverse(MutableBigInteger mutableBigInteger) {
        if (mutableBigInteger.isOdd()) {
            return this.modInverse(mutableBigInteger);
        }
        if (this.isEven()) {
            throw new ArithmeticException("BigInteger not invertible.");
        }
        int n = mutableBigInteger.getLowestSetBit();
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(mutableBigInteger);
        mutableBigInteger2.rightShift(n);
        if (mutableBigInteger2.isOne()) {
            return this.modInverseMP2(n);
        }
        MutableBigInteger mutableBigInteger3 = this.modInverse(mutableBigInteger2);
        MutableBigInteger mutableBigInteger4 = this.modInverseMP2(n);
        MutableBigInteger mutableBigInteger5 = MutableBigInteger.modInverseBP2(mutableBigInteger2, n);
        MutableBigInteger mutableBigInteger6 = mutableBigInteger2.modInverseMP2(n);
        MutableBigInteger mutableBigInteger7 = new MutableBigInteger();
        MutableBigInteger mutableBigInteger8 = new MutableBigInteger();
        MutableBigInteger mutableBigInteger9 = new MutableBigInteger();
        mutableBigInteger3.leftShift(n);
        mutableBigInteger3.multiply(mutableBigInteger5, mutableBigInteger9);
        mutableBigInteger4.multiply(mutableBigInteger2, mutableBigInteger7);
        mutableBigInteger7.multiply(mutableBigInteger6, mutableBigInteger8);
        mutableBigInteger9.add(mutableBigInteger8);
        return mutableBigInteger9.divide(mutableBigInteger, mutableBigInteger7);
    }

    MutableBigInteger modInverseMP2(int n) {
        if (this.isEven()) {
            throw new ArithmeticException("Non-invertible. (GCD != 1)");
        }
        if (n > 64) {
            return this.euclidModInverse(n);
        }
        int n2 = MutableBigInteger.inverseMod32(this.value[this.offset + this.intLen - 1]);
        if (n < 33) {
            n2 = n == 32 ? n2 : n2 & (1 << n) - 1;
            return new MutableBigInteger(n2);
        }
        long l = (long)this.value[this.offset + this.intLen - 1] & 0xFFFFFFFFL;
        if (this.intLen > 1) {
            l |= (long)this.value[this.offset + this.intLen - 2] << 32;
        }
        long l2 = (long)n2 & 0xFFFFFFFFL;
        l2 *= 2L - l * l2;
        l2 = n == 64 ? l2 : l2 & (1L << n) - 1L;
        MutableBigInteger mutableBigInteger = new MutableBigInteger(new int[2]);
        mutableBigInteger.value[0] = (int)(l2 >>> 32);
        mutableBigInteger.value[1] = (int)l2;
        mutableBigInteger.intLen = 2;
        mutableBigInteger.normalize();
        return mutableBigInteger;
    }

    static int inverseMod32(int n) {
        int n2 = n;
        n2 *= 2 - n * n2;
        n2 *= 2 - n * n2;
        n2 *= 2 - n * n2;
        n2 *= 2 - n * n2;
        return n2;
    }

    static MutableBigInteger modInverseBP2(MutableBigInteger mutableBigInteger, int n) {
        return MutableBigInteger.fixup(new MutableBigInteger(1), new MutableBigInteger(mutableBigInteger), n);
    }

    private MutableBigInteger modInverse(MutableBigInteger mutableBigInteger) {
        int n;
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(mutableBigInteger);
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(this);
        MutableBigInteger mutableBigInteger4 = new MutableBigInteger(mutableBigInteger2);
        SignedMutableBigInteger signedMutableBigInteger = new SignedMutableBigInteger(1);
        SignedMutableBigInteger signedMutableBigInteger2 = new SignedMutableBigInteger();
        MutableBigInteger mutableBigInteger5 = null;
        SignedMutableBigInteger signedMutableBigInteger3 = null;
        int n2 = 0;
        if (mutableBigInteger3.isEven()) {
            n = mutableBigInteger3.getLowestSetBit();
            mutableBigInteger3.rightShift(n);
            signedMutableBigInteger2.leftShift(n);
            n2 = n;
        }
        while (!mutableBigInteger3.isOne()) {
            if (mutableBigInteger3.isZero()) {
                throw new ArithmeticException("BigInteger not invertible.");
            }
            if (mutableBigInteger3.compare(mutableBigInteger4) < 0) {
                mutableBigInteger5 = mutableBigInteger3;
                mutableBigInteger3 = mutableBigInteger4;
                mutableBigInteger4 = mutableBigInteger5;
                signedMutableBigInteger3 = signedMutableBigInteger2;
                signedMutableBigInteger2 = signedMutableBigInteger;
                signedMutableBigInteger = signedMutableBigInteger3;
            }
            if (((mutableBigInteger3.value[mutableBigInteger3.offset + mutableBigInteger3.intLen - 1] ^ mutableBigInteger4.value[mutableBigInteger4.offset + mutableBigInteger4.intLen - 1]) & 3) == 0) {
                mutableBigInteger3.subtract(mutableBigInteger4);
                signedMutableBigInteger.signedSubtract(signedMutableBigInteger2);
            } else {
                mutableBigInteger3.add(mutableBigInteger4);
                signedMutableBigInteger.signedAdd(signedMutableBigInteger2);
            }
            n = mutableBigInteger3.getLowestSetBit();
            mutableBigInteger3.rightShift(n);
            signedMutableBigInteger2.leftShift(n);
            n2 += n;
        }
        while (signedMutableBigInteger.sign < 0) {
            signedMutableBigInteger.signedAdd(mutableBigInteger2);
        }
        return MutableBigInteger.fixup(signedMutableBigInteger, mutableBigInteger2, n2);
    }

    static MutableBigInteger fixup(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2, int n) {
        int n2;
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger();
        int n3 = -MutableBigInteger.inverseMod32(mutableBigInteger2.value[mutableBigInteger2.offset + mutableBigInteger2.intLen - 1]);
        int n4 = n >> 5;
        for (n2 = 0; n2 < n4; ++n2) {
            int n5 = n3 * mutableBigInteger.value[mutableBigInteger.offset + mutableBigInteger.intLen - 1];
            mutableBigInteger2.mul(n5, mutableBigInteger3);
            mutableBigInteger.add(mutableBigInteger3);
            --mutableBigInteger.intLen;
        }
        n2 = n & 0x1F;
        if (n2 != 0) {
            n4 = n3 * mutableBigInteger.value[mutableBigInteger.offset + mutableBigInteger.intLen - 1];
            mutableBigInteger2.mul(n4 &= (1 << n2) - 1, mutableBigInteger3);
            mutableBigInteger.add(mutableBigInteger3);
            mutableBigInteger.rightShift(n2);
        }
        while (mutableBigInteger.compare(mutableBigInteger2) >= 0) {
            mutableBigInteger.subtract(mutableBigInteger2);
        }
        return mutableBigInteger;
    }

    MutableBigInteger euclidModInverse(int n) {
        MutableBigInteger mutableBigInteger = new MutableBigInteger(1);
        mutableBigInteger.leftShift(n);
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(mutableBigInteger);
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(this);
        MutableBigInteger mutableBigInteger4 = new MutableBigInteger();
        MutableBigInteger mutableBigInteger5 = mutableBigInteger.divide(mutableBigInteger3, mutableBigInteger4);
        MutableBigInteger mutableBigInteger6 = mutableBigInteger;
        mutableBigInteger = mutableBigInteger5;
        mutableBigInteger5 = mutableBigInteger6;
        MutableBigInteger mutableBigInteger7 = new MutableBigInteger(mutableBigInteger4);
        MutableBigInteger mutableBigInteger8 = new MutableBigInteger(1);
        MutableBigInteger mutableBigInteger9 = new MutableBigInteger();
        while (!mutableBigInteger.isOne()) {
            mutableBigInteger5 = mutableBigInteger3.divide(mutableBigInteger, mutableBigInteger4);
            if (mutableBigInteger5.intLen == 0) {
                throw new ArithmeticException("BigInteger not invertible.");
            }
            mutableBigInteger3 = mutableBigInteger6 = mutableBigInteger5;
            if (mutableBigInteger4.intLen == 1) {
                mutableBigInteger7.mul(mutableBigInteger4.value[mutableBigInteger4.offset], mutableBigInteger9);
            } else {
                mutableBigInteger4.multiply(mutableBigInteger7, mutableBigInteger9);
            }
            mutableBigInteger6 = mutableBigInteger4;
            mutableBigInteger4 = mutableBigInteger9;
            mutableBigInteger9 = mutableBigInteger6;
            mutableBigInteger8.add(mutableBigInteger4);
            if (mutableBigInteger3.isOne()) {
                return mutableBigInteger8;
            }
            mutableBigInteger5 = mutableBigInteger.divide(mutableBigInteger3, mutableBigInteger4);
            if (mutableBigInteger5.intLen == 0) {
                throw new ArithmeticException("BigInteger not invertible.");
            }
            mutableBigInteger6 = mutableBigInteger;
            mutableBigInteger = mutableBigInteger5;
            if (mutableBigInteger4.intLen == 1) {
                mutableBigInteger8.mul(mutableBigInteger4.value[mutableBigInteger4.offset], mutableBigInteger9);
            } else {
                mutableBigInteger4.multiply(mutableBigInteger8, mutableBigInteger9);
            }
            mutableBigInteger6 = mutableBigInteger4;
            mutableBigInteger4 = mutableBigInteger9;
            mutableBigInteger9 = mutableBigInteger6;
            mutableBigInteger7.add(mutableBigInteger4);
        }
        mutableBigInteger2.subtract(mutableBigInteger7);
        return mutableBigInteger2;
    }
}

