/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client;

import com.oracle.webservices.internal.api.message.BaseDistributedPropertySet;
import com.oracle.webservices.internal.api.message.BasePropertySet;
import com.oracle.webservices.internal.api.message.PropertySet;
import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.PropertySet;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.client.ContentNegotiation;
import com.sun.xml.internal.ws.transport.Headers;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class RequestContext
extends BaseDistributedPropertySet {
    private static final Logger LOGGER = Logger.getLogger(RequestContext.class.getName());
    private static ContentNegotiation defaultContentNegotiation = ContentNegotiation.obtainFromSystemProperty();
    @NotNull
    private EndpointAddress endpointAddress;
    public ContentNegotiation contentNegotiation = defaultContentNegotiation;
    private String soapAction;
    private Boolean soapActionUse;
    private static final BasePropertySet.PropertyMap propMap = RequestContext.parse(RequestContext.class);

    public void addSatellite(@NotNull PropertySet propertySet) {
        super.addSatellite(propertySet);
    }

    @PropertySet.Property(value={"javax.xml.ws.service.endpoint.address"})
    public String getEndPointAddressString() {
        return this.endpointAddress != null ? this.endpointAddress.toString() : null;
    }

    public void setEndPointAddressString(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.endpointAddress = EndpointAddress.create(string);
    }

    public void setEndpointAddress(@NotNull EndpointAddress endpointAddress) {
        this.endpointAddress = endpointAddress;
    }

    @NotNull
    public EndpointAddress getEndpointAddress() {
        return this.endpointAddress;
    }

    @PropertySet.Property(value={"com.sun.xml.internal.ws.client.ContentNegotiation"})
    public String getContentNegotiationString() {
        return this.contentNegotiation.toString();
    }

    public void setContentNegotiationString(String string) {
        if (string == null) {
            this.contentNegotiation = ContentNegotiation.none;
        } else {
            try {
                this.contentNegotiation = ContentNegotiation.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.contentNegotiation = ContentNegotiation.none;
            }
        }
    }

    @PropertySet.Property(value={"javax.xml.ws.soap.http.soapaction.uri"})
    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String string) {
        this.soapAction = string;
    }

    @PropertySet.Property(value={"javax.xml.ws.soap.http.soapaction.use"})
    public Boolean getSoapActionUse() {
        return this.soapActionUse;
    }

    public void setSoapActionUse(Boolean bl) {
        this.soapActionUse = bl;
    }

    RequestContext() {
    }

    private RequestContext(RequestContext requestContext) {
        for (Map.Entry<String, Object> entry : requestContext.asMapLocal().entrySet()) {
            if (propMap.containsKey(entry.getKey())) continue;
            this.asMap().put(entry.getKey(), entry.getValue());
        }
        this.endpointAddress = requestContext.endpointAddress;
        this.soapAction = requestContext.soapAction;
        this.soapActionUse = requestContext.soapActionUse;
        this.contentNegotiation = requestContext.contentNegotiation;
        requestContext.copySatelliteInto(this);
    }

    @Override
    public Object get(Object object) {
        if (this.supports(object)) {
            return super.get(object);
        }
        return this.asMap().get(object);
    }

    @Override
    public Object put(String string, Object object) {
        if (this.supports(string)) {
            return super.put(string, object);
        }
        return this.asMap().put(string, object);
    }

    public void fill(Packet packet, boolean bl) {
        if (this.endpointAddress != null) {
            packet.endpointAddress = this.endpointAddress;
        }
        packet.contentNegotiation = this.contentNegotiation;
        this.fillSOAPAction(packet, bl);
        this.mergeRequestHeaders(packet);
        HashSet<String> hashSet = new HashSet<String>();
        this.copySatelliteInto(packet);
        for (String string : this.asMapLocal().keySet()) {
            if (!this.supportsLocal(string)) {
                hashSet.add(string);
            }
            if (propMap.containsKey(string)) continue;
            Object object = this.asMapLocal().get(string);
            if (packet.supports(string)) {
                packet.put(string, object);
                continue;
            }
            packet.invocationProperties.put(string, object);
        }
        if (!hashSet.isEmpty()) {
            packet.getHandlerScopePropertyNames(false).addAll(hashSet);
        }
    }

    private void mergeRequestHeaders(Packet packet) {
        Headers headers = (Headers)packet.invocationProperties.get("javax.xml.ws.http.request.headers");
        Map map = (Map)this.asMap().get("javax.xml.ws.http.request.headers");
        if (headers != null && map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                if (string == null || string.trim().length() == 0) continue;
                List list = (List)headers.get(string);
                if (list != null) {
                    list.addAll((Collection)entry.getValue());
                    continue;
                }
                headers.put(string, map.get(string));
            }
            this.asMap().put("javax.xml.ws.http.request.headers", headers);
        }
    }

    private void fillSOAPAction(Packet packet, boolean bl) {
        Boolean bl2;
        boolean bl3 = packet.packetTakesPriorityOverRequestContext;
        String string = bl3 ? packet.soapAction : this.soapAction;
        Boolean bl4 = bl2 = bl3 ? (Boolean)packet.invocationProperties.get("javax.xml.ws.soap.http.soapaction.use") : this.soapActionUse;
        if ((bl2 != null && bl2.booleanValue() || bl2 == null && bl) && string != null) {
            packet.soapAction = string;
        }
        if (!(bl || bl2 != null && bl2.booleanValue() || string == null)) {
            LOGGER.warning("BindingProvider.SOAPACTION_URI_PROPERTY is set in the RequestContext but is ineffective, Either set BindingProvider.SOAPACTION_USE_PROPERTY to true or enable AddressingFeature");
        }
    }

    public RequestContext copy() {
        return new RequestContext(this);
    }

    @Override
    protected BasePropertySet.PropertyMap getPropertyMap() {
        return propMap;
    }

    @Override
    protected boolean mapAllowsAdditionalProperties() {
        return true;
    }
}

