/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.config.management.policy;

import com.sun.istack.internal.logging.Logger;
import com.sun.xml.internal.ws.api.client.WSPortInfo;
import com.sun.xml.internal.ws.api.config.management.policy.ManagementAssertion;
import com.sun.xml.internal.ws.policy.PolicyAssertion;
import com.sun.xml.internal.ws.policy.PolicyMap;
import com.sun.xml.internal.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.internal.ws.policy.spi.AssertionCreationException;
import com.sun.xml.internal.ws.resources.ManagementMessages;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

public class ManagedClientAssertion
extends ManagementAssertion {
    public static final QName MANAGED_CLIENT_QNAME = new QName("http://java.sun.com/xml/ns/metro/management", "ManagedClient");
    private static final Logger LOGGER = Logger.getLogger(ManagedClientAssertion.class);

    public static ManagedClientAssertion getAssertion(WSPortInfo wSPortInfo) throws WebServiceException {
        if (wSPortInfo == null) {
            return null;
        }
        LOGGER.entering(wSPortInfo);
        PolicyMap policyMap = wSPortInfo.getPolicyMap();
        ManagedClientAssertion managedClientAssertion = ManagementAssertion.getAssertion(MANAGED_CLIENT_QNAME, policyMap, wSPortInfo.getServiceName(), wSPortInfo.getPortName(), ManagedClientAssertion.class);
        LOGGER.exiting(managedClientAssertion);
        return managedClientAssertion;
    }

    public ManagedClientAssertion(AssertionData assertionData, Collection<PolicyAssertion> collection) throws AssertionCreationException {
        super(MANAGED_CLIENT_QNAME, assertionData, collection);
    }

    @Override
    public boolean isManagementEnabled() {
        String string = this.getAttributeValue(MANAGEMENT_ATTRIBUTE_QNAME);
        if (string != null && (string.trim().toLowerCase().equals("on") || Boolean.parseBoolean(string))) {
            LOGGER.warning(ManagementMessages.WSM_1006_CLIENT_MANAGEMENT_ENABLED());
        }
        return false;
    }
}

