/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.org.jvnet.mimepull;

import com.sun.xml.internal.org.jvnet.mimepull.BASE64DecoderStream;
import com.sun.xml.internal.org.jvnet.mimepull.DecodingException;
import com.sun.xml.internal.org.jvnet.mimepull.PropUtil;
import com.sun.xml.internal.org.jvnet.mimepull.QPDecoderStream;
import com.sun.xml.internal.org.jvnet.mimepull.UUDecoderStream;
import java.io.InputStream;

final class MimeUtility {
    private static final boolean ignoreUnknownEncoding = PropUtil.getBooleanSystemProperty("mail.mime.ignoreunknownencoding", false);

    private MimeUtility() {
    }

    public static InputStream decode(InputStream inputStream, String string) throws DecodingException {
        if (string.equalsIgnoreCase("base64")) {
            return new BASE64DecoderStream(inputStream);
        }
        if (string.equalsIgnoreCase("quoted-printable")) {
            return new QPDecoderStream(inputStream);
        }
        if (string.equalsIgnoreCase("uuencode") || string.equalsIgnoreCase("x-uuencode") || string.equalsIgnoreCase("x-uue")) {
            return new UUDecoderStream(inputStream);
        }
        if (string.equalsIgnoreCase("binary") || string.equalsIgnoreCase("7bit") || string.equalsIgnoreCase("8bit")) {
            return inputStream;
        }
        if (!ignoreUnknownEncoding) {
            throw new DecodingException("Unknown encoding: " + string);
        }
        return inputStream;
    }
}

