/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.utils;

import com.sun.org.apache.xalan.internal.utils.ObjectFactory;
import com.sun.org.apache.xml.internal.res.XMLMessages;
import com.sun.org.apache.xml.internal.utils.WrappedRuntimeException;
import java.io.Serializable;
import java.util.ArrayList;

public class ObjectPool
implements Serializable {
    static final long serialVersionUID = -8519013691660936643L;
    private final Class objectType;
    private final ArrayList freeStack;

    public ObjectPool(Class clazz) {
        this.objectType = clazz;
        this.freeStack = new ArrayList();
    }

    public ObjectPool(String string) {
        try {
            this.objectType = ObjectFactory.findProviderClass(string, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WrappedRuntimeException(classNotFoundException);
        }
        this.freeStack = new ArrayList();
    }

    public ObjectPool(Class clazz, int n) {
        this.objectType = clazz;
        this.freeStack = new ArrayList(n);
    }

    public ObjectPool() {
        this.objectType = null;
        this.freeStack = new ArrayList();
    }

    public synchronized Object getInstanceIfFree() {
        if (!this.freeStack.isEmpty()) {
            Object e = this.freeStack.remove(this.freeStack.size() - 1);
            return e;
        }
        return null;
    }

    public synchronized Object getInstance() {
        if (this.freeStack.isEmpty()) {
            try {
                return this.objectType.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            throw new RuntimeException(XMLMessages.createXMLMessage("ER_EXCEPTION_CREATING_POOL", null));
        }
        Object e = this.freeStack.remove(this.freeStack.size() - 1);
        return e;
    }

    public synchronized void freeInstance(Object object) {
        this.freeStack.add(object);
    }
}

