/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.Logger;
import oracle.jrockit.jfr.MsgLevel;
import oracle.jrockit.jfr.NativeOptions;

@Deprecated
final class Repository {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
    private final Logger logger;
    private final String pid;
    private static final int MAX_REPO_CREATION_RETRIES = 1000;
    private File path;

    Repository(JFR jFR, NativeOptions nativeOptions, Logger logger) throws Exception {
        this.logger = logger;
        this.pid = String.valueOf(jFR.getpid());
        this.create(nativeOptions.repository());
    }

    private String create(String string) throws Exception {
        String string2;
        String string3 = string;
        if (string3 == null) {
            string3 = JFR.JAVA_IO_TMPDIR;
        }
        assert (string3 != null);
        final File file = new File(string3);
        String string4 = null;
        try {
            string4 = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    String string = file.getCanonicalFile().getPath();
                    if (file.exists() && !file.canWrite()) {
                        throw new Exception("JFR repository directory (" + string + ") exists, but isn't writable.");
                    }
                    return string;
                }
            }, null, new FilePermission(file.getPath(), "read, write"));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
        File file2 = null;
        String string5 = string2 = this.repositoryName();
        int n = 0;
        while (n < 1000 && !this.tryToUseAsRepository(file2 = new File(string4, string5))) {
            string5 = string2 + "_" + n++;
        }
        if (n == 1000) {
            throw new Exception("Unable to create JFR repository directory using base location (" + string3 + ").");
        }
        this.path = file2;
        String string6 = null;
        try {
            string6 = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    return Repository.this.path.getCanonicalFile().getPath();
                }
            }, null, new FilePermission(this.path.getPath(), "read"));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
        this.logger.log(MsgLevel.INFO, "Using %s as Flight Recorder repository.", string6);
        return string6;
    }

    private boolean tryToUseAsRepository(final File file) {
        assert (file != null);
        boolean bl = false;
        Permission[] permissionArray = new FilePermission[]{new FilePermission(file.getPath(), "read, write"), new FilePermission(file.getParentFile().getPath(), "read, write")};
        try {
            bl = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws IOException {
                    file.getCanonicalFile().getParentFile().mkdirs();
                    if (file.exists()) {
                        return false;
                    }
                    if (!file.mkdir()) {
                        return false;
                    }
                    if (!file.exists()) {
                        return false;
                    }
                    return true;
                }
            }, null, permissionArray);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            this.logger.log(MsgLevel.WARN, exception, "Could not open %s as repository.", file);
        }
        return bl;
    }

    final String filenameBase() {
        return this.sdf.format(new Date()) + "_" + this.pid;
    }

    public final File getPath() {
        return this.path;
    }

    private final String repositoryName() {
        return this.filenameBase();
    }

    void destroy() {
        boolean bl = false;
        try {
            bl = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws IOException {
                    if (Repository.this.path != null) {
                        return Repository.this.path.delete();
                    }
                    return false;
                }
            }, null, new FilePermission(this.path.getPath(), "delete"));
        }
        catch (PrivilegedActionException privilegedActionException) {
        }
        finally {
            if (bl) {
                this.logger.info("Flight Recorder repository deleted");
            } else {
                this.logger.error("Repository could not be removed at shutdown");
            }
        }
    }
}

