﻿-- 显示恶魔术恶魔存活时间 2017.2.7 基于http://bbs.nga.cn/read.php?tid=10909944中提供的附件修改，显示4t19下的时间 逆势孤狼
WarlockDemons = LibStub('AceAddon-3.0'):NewAddon('WarlockDemons', 'AceEvent-3.0', 'AceHook-3.0')
local candy = LibStub("LibCandyBar-3.0")
local media = LibStub("LibSharedMedia-3.0")
local T19_DB = {
		[1] = 138314,
		[3] = 138323,
		[5] = 138320,
		[15] = 138373,
		[7] = 138317,
		[10] = 138311
	}
local function is_4t19_equipped()
	local counter = 0
	for k, v in pairs(T19_DB) do
		if GetInventoryItemID("player",k) == v then
			counter = counter +1
		end
	end
	if counter >= 4 then
		return true
	else
		return false
	end
end


WarlockDemons.validDemonsDB = {
    [55659]  = {icon=GetSpellTexture(205145), duration=12}, -- Wild imps from Hand of Gul'dan+class trinket
	[99737]  = {icon=GetSpellTexture(205145), duration=12}, -- Wild imps from Dreadstalkers ( talented only )
    [98035]  = {icon=GetSpellTexture(104316), duration=12}, -- Dreadstalkers, which is a vehicle. Imps on dreadstalkers are 99737
    [103673] = {icon=GetSpellTexture(205180), duration=12}, -- Darkglare
	[95468]  = {icon=GetSpellTexture(189297), duration=12}, -- Satyre illidari
	[95469]  = {icon=GetSpellTexture(224504), duration=12}, -- Vicious Fellhound
	[17252]  = {icon=GetSpellTexture(30146), duration=25}, -- Service/pet
	[11859]  = {icon=GetSpellTexture(18540), duration=25}, -- Felguard
}

if IDI_SETTINGS == nil then
    IDI_SETTINGS = {
        texture = 'Glaze2',
        width = 200,
        height = 20,
        point = 'TOPLEFT',
        relativeFrame = 'UIParent',
        relativePoint = 'TOPLEFT',
        ofsx = 0,
        ofsy = -80,
        color = {r=1, g=0, b=0, a=1},
        grow = -1, -- -1 = down, 1 = up
		debug = 1
    }
end

WarlockDemons.BarPool = {}

function WarlockDemons:CreateBar(icon, duration, note)
    local s = IDI_SETTINGS
    local texture = media:Fetch('statusbar', s.texture)
    local bar = candy:New(texture, s.width, s.height)
    local cnt = #WarlockDemons.BarPool
    bar:SetIcon(icon)
    bar:SetDuration(duration)
    bar:SetPoint(s.point, s.relativeFrame, s.relativePoint, s.ofsx, s.ofsy+cnt*s.height*s.grow)
    bar:SetColor(s.color.r, s.color.g, s.color.b, s.color.a)
    bar.updater:SetScript('OnStop', function() WarlockDemons:RemoveBar(bar) end)
    bar.note = note or ''
    return bar
end

function WarlockDemons:RemoveBar(bar)
    local _, _, _, _, removed_y = bar:GetPoint()
    local s = IDI_SETTINGS
    for k, b in pairs(WarlockDemons.BarPool) do
        if b.note == bar.note then
            WarlockDemons.BarPool[k] = 'removed' -- mark removal, safe for iteration
        else
            local _, _, _, _, y = b:GetPoint()
            if (y <= removed_y and s.grow < 0 or y >= removed_y and s.grow > 0) then
                b:ClearAllPoints()
                b:SetPoint(s.point, s.relativeFrame, s.relativePoint, s.ofsx, y-s.height*s.grow)
            end
        end
    end
    for k, b in pairs(WarlockDemons.BarPool) do
        if b == 'removed' then
            table.remove(WarlockDemons.BarPool, k)
        end
    end
end

function check_status()
    local player_class = select(2, UnitClass('player'))
    local specialization = GetSpecialization()
    if player_class == 'WARLOCK' and specialization == 2 then -- Demonology only
        WarlockDemons:RegisterEvent('COMBAT_LOG_EVENT_UNFILTERED')
		if (IDI_SETTINGS.debug) then
			if (GetLocale() == 'zhCN') then
				DEFAULT_CHAT_FRAME:AddMessage('检测到恶魔术，正在启用核武器...|cff00FF00完成|r')
			else
				DEFAULT_CHAT_FRAME:AddMessage('Demonology warlock detected, launching nuclear weapon...|cff00FF00DONE|r')
			end
        end
    end
end

function WarlockDemons:OnInitialize()
    media:Register('statusbar', 'Glaze2', [[Interface\Addons\IcyDemonsIndicator\textures\Glaze2]])
    self:RegisterEvent('ACTIVE_TALENT_GROUP_CHANGED', check_status)
    self:RegisterEvent('PLAYER_ENTERING_WORLD', check_status)
end

function WarlockDemons:OnDisable()
    self:UnRegisterAllEvents()
end

function WarlockDemons:COMBAT_LOG_EVENT_UNFILTERED(event, ...)
    local timestamp, combat_event, _, sourceGUID, sourceName, sourceFlags, sourceFlags2, destGUID, destName, destFlags, destFlags2, spellId, spellName, spellSchool = ...
    if sourceGUID ~= UnitGUID('player') then
        return
    end
	if is_4t19_equipped() then
	WarlockDemons.validDemonsDB[98035].duration = 16
	WarlockDemons.validDemonsDB[99737].duration = 16
	else
	WarlockDemons.validDemonsDB[98035].duration = 12
	WarlockDemons.validDemonsDB[99737].duration = 12
	end
    if combat_event == 'SPELL_SUMMON' then    
        local _, _, _, _, _, _, _, creature_id, _ = destGUID:find('(%S+)-(%d+)-(%d+)-(%d+)-(%d+)-(%d+)-(%S+)')
        creature_id = tonumber(creature_id)
        
        for id, v in pairs(WarlockDemons.validDemonsDB) do
            if id == creature_id then
                bar = WarlockDemons:CreateBar(v.icon, v.duration, destGUID)
                table.insert(WarlockDemons.BarPool, bar)
                bar:Start()
                return
            end
        end
    elseif combat_event == 'SPELL_INSTAKILL' then
        if spellId == 196278 then -- implosion
            for k, b in pairs(WarlockDemons.BarPool) do
                if b.note == destGUID then
					b:Stop()
                end
            end
        end
    end
	if combat_event == 'SPELL_AURA_APPLIED' then
		if spellId == 193396 then -- Demonic Empowerment
			for k, b in pairs(WarlockDemons.BarPool) do
				b:SetColor(0, 1, 0, 1)
			end
		end
	elseif combat_event == 'SPELL_AURA_REMOVED' then
		if spellId == 193396 then -- Demonic Empowerment
			for k, b in pairs(WarlockDemons.BarPool) do
				if b.note == destGUID then
					b:SetColor(1, 0, 0, 1)
				end	
			end
		end
	end
end

-- slash command for accessing config
SLASH_ICYDEMONSINDICATOR1, SLASH_ICYDEMONSINDICATOR2 = '/idi', '/icydemonsindicator'
function SlashCmdList.ICYDEMONSINDICATOR(msg)
    action, param = msg:match('([^ ]+) ([^ ]+)')
    if action == 'width' then
        IDI_SETTINGS.width = tonumber(param)
    elseif action == 'height' then
        IDI_SETTINGS.height = tonumber(param)
    elseif action == 'x' then
        IDI_SETTINGS.ofsx = tonumber(param)
    elseif action == 'y' then
        IDI_SETTINGS.ofsy = tonumber(param)
	elseif action == 'debug' then
		IDI_SETTINGS.debug = (tonumber(param)>=1 and true or false)
	elseif action == 'grow' then
		IDI_SETTINGS.grow = (string.lower(param) == 'up' and 1 or -1)
    else
	
        if (GetLocale() == 'zhCN') then
            DEFAULT_CHAT_FRAME:AddMessage('|cff00FF00IcyDemonsIndicator|r 帮助文档')
            DEFAULT_CHAT_FRAME:AddMessage('命令行：/idi 或 /icydemonsindicator')
            DEFAULT_CHAT_FRAME:AddMessage('/idi width 200: 调整计量条宽度为200（默认200）')
            DEFAULT_CHAT_FRAME:AddMessage('/idi height 20: 调整计量条高度为20（默认20）')
            DEFAULT_CHAT_FRAME:AddMessage('/idi x 0: 调整横坐标位置为0（默认0）')
            DEFAULT_CHAT_FRAME:AddMessage('/idi y -80: 调整纵坐标位置为-80（默认-80）')
			DEFAULT_CHAT_FRAME:AddMessage('/idi debug 1: enable (1) or disable (0) debug messages (default 1)')
			DEFAULT_CHAT_FRAME:AddMessage('/idi grow UP: set bar grow direction UP or DOWN (default DOWN)')
        else
            DEFAULT_CHAT_FRAME:AddMessage('|cff00FF00IcyDemonsIndicator|r manuals')
            DEFAULT_CHAT_FRAME:AddMessage('Console: /idi or /icydemonsindicator')
            DEFAULT_CHAT_FRAME:AddMessage('/idi width 200: set bar width to 200(default 200)')
            DEFAULT_CHAT_FRAME:AddMessage('/idi height 20: set bar height to 20(default 20)')
            DEFAULT_CHAT_FRAME:AddMessage('/idi x 0: set x coordinate to 0(default 0)')
            DEFAULT_CHAT_FRAME:AddMessage('/idi y -80: set y coordinate to -80(default -80)')
			DEFAULT_CHAT_FRAME:AddMessage('/idi debug 1: enable (1) or disable (0) debug messages (default 1)')
			DEFAULT_CHAT_FRAME:AddMessage('/idi grow UP: set bar grow direction UP or DOWN (default DOWN)')
        end
    end
end