/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.util.Log;
import com.google.android.gms.internal.o;
import com.google.android.gms.internal.r;

public class GooglePlusUtil {
    public static final int SUCCESS = 0;
    public static final int APP_MISSING = 1;
    public static final int APP_UPDATE_REQUIRED = 2;
    public static final int APP_DISABLED = 3;
    public static final String GOOGLE_PLUS_PACKAGE = "com.google.android.apps.plus";
    public static final String PLATFORM_LOGGING_TAG = "GooglePlusPlatform";

    private GooglePlusUtil() {
        throw new AssertionError((Object)"Cannot instantiate GooglePlusUtil");
    }

    public static int checkGooglePlusApp(Context context) {
        return GooglePlusUtil.b(context, 330000000);
    }

    private static int b(Context context, int n2) {
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(GOOGLE_PLUS_PACKAGE, 0);
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(GOOGLE_PLUS_PACKAGE, 0);
            if (packageInfo.versionCode < n2) {
                return 2;
            }
            if (!applicationInfo.enabled) {
                return 3;
            }
            return 0;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return 1;
        }
    }

    public static Dialog getErrorDialog(int errorCode, Activity activity, int requestCode) {
        return GooglePlusUtil.a(new AlertDialog.Builder((Context)activity), errorCode, activity, requestCode);
    }

    static Dialog a(AlertDialog.Builder builder, int n2, Activity activity, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Request code must not be negative.");
        }
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: {
                return builder.setTitle((CharSequence)GooglePlusUtil.a((Context)activity, "install_google_plus_title", "Get Google+")).setMessage((CharSequence)GooglePlusUtil.a((Context)activity, "install_google_plus_text", "Download Google+ from Google Play so you can share this?")).setPositiveButton((CharSequence)GooglePlusUtil.a((Context)activity, "install_google_plus_button", "Get Google+"), (DialogInterface.OnClickListener)new o(activity, r.g(GOOGLE_PLUS_PACKAGE), n3)).create();
            }
            case 3: {
                return builder.setTitle((CharSequence)GooglePlusUtil.a((Context)activity, "enable_google_plus_title", "Enable Google+")).setMessage((CharSequence)GooglePlusUtil.a((Context)activity, "enable_google_plus_text", "Enable Google+ from Google Play so you can share this?")).setPositiveButton((CharSequence)GooglePlusUtil.a((Context)activity, "enable_google_plus_button", "Enable Google+"), (DialogInterface.OnClickListener)new o(activity, r.e(GOOGLE_PLUS_PACKAGE), n3)).create();
            }
            case 2: {
                return builder.setTitle((CharSequence)GooglePlusUtil.a((Context)activity, "update_google_plus_title", "Update Google+")).setMessage((CharSequence)GooglePlusUtil.a((Context)activity, "update_google_plus_text", "Update Google+ from Google Play so you can share this?")).setPositiveButton((CharSequence)GooglePlusUtil.a((Context)activity, "update_google_plus_button", "Update"), (DialogInterface.OnClickListener)new o(activity, r.g(GOOGLE_PLUS_PACKAGE), n3)).create();
            }
        }
        throw new IllegalArgumentException("Unexpected errorCode " + n2);
    }

    static String a(Context context, String string2, String string3) {
        try {
            Context context2 = context.createPackageContext("com.google.android.gms", 0);
            Resources resources = context2.getResources();
            return resources.getString(resources.getIdentifier(string2, "string", "com.google.android.gms"));
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)"GooglePlusUtil", (String)"Unable to load resources from GMS: GMS not installed.", (Throwable)nameNotFoundException);
        }
        catch (Resources.NotFoundException notFoundException) {
            Log.e((String)"GooglePlusUtil", (String)("Unable to load resources from GMS: Resource \"" + string2 + "\" not found."), (Throwable)notFoundException);
        }
        catch (SecurityException securityException) {
            Log.e((String)"GooglePlusUtil", (String)"Unable to load resources from GMS.", (Throwable)securityException);
        }
        return string3;
    }
}

