/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.internal.ae;
import com.google.android.gms.internal.bc;
import com.google.android.gms.internal.cx;
import com.google.android.gms.internal.da;
import com.google.android.gms.internal.x;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.GroundOverlayOptionsCreator;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;

public final class GroundOverlayOptions
implements ae {
    public static final GroundOverlayOptionsCreator CREATOR = new GroundOverlayOptionsCreator();
    public static final float NO_DIMENSION = -1.0f;
    private final int T;
    private BitmapDescriptor fX;
    private LatLng fY;
    private float fZ;
    private float ga;
    private LatLngBounds gb;
    private float fN;
    private float fU;
    private boolean fV = true;
    private float gc = 0.0f;
    private float gd = 0.5f;
    private float ge = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.T = versionCode;
        this.fX = new BitmapDescriptor(bc.a.j(wrappedImage));
        this.fY = location;
        this.fZ = width;
        this.ga = height;
        this.gb = bounds;
        this.fN = bearing;
        this.fU = zIndex;
        this.fV = visible;
        this.gc = transparency;
        this.gd = anchorU;
        this.ge = anchorV;
    }

    public GroundOverlayOptions() {
        this.T = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (cx.aV()) {
            da.a(this, out, flags);
        } else {
            GroundOverlayOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public IBinder aX() {
        return this.fX.aD().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.fX = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u2, float v2) {
        this.gd = u2;
        this.ge = v2;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        x.a(this.gb == null, "Position has already been set using positionFromBounds");
        x.b(location != null, (Object)"Location must be specified");
        x.b(width >= 0.0f, (Object)"Width must be non-negative");
        return this.a(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        x.a(this.gb == null, "Position has already been set using positionFromBounds");
        x.b(location != null, (Object)"Location must be specified");
        x.b(width >= 0.0f, (Object)"Width must be non-negative");
        x.b(height >= 0.0f, (Object)"Height must be non-negative");
        return this.a(location, width, height);
    }

    private GroundOverlayOptions a(LatLng latLng, float f2, float f3) {
        this.fY = latLng;
        this.fZ = f2;
        this.ga = f3;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        x.a(this.fY == null, "Position has already been set using position: " + this.fY);
        this.gb = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.fN = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.fU = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.fV = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        x.b(transparency >= 0.0f && transparency <= 1.0f, (Object)"Transparency must be in the range [0..1]");
        this.gc = transparency;
        return this;
    }

    public int u() {
        return this.T;
    }

    public BitmapDescriptor getImage() {
        return this.fX;
    }

    public LatLng getLocation() {
        return this.fY;
    }

    public float getWidth() {
        return this.fZ;
    }

    public float getHeight() {
        return this.ga;
    }

    public LatLngBounds getBounds() {
        return this.gb;
    }

    public float getBearing() {
        return this.fN;
    }

    public float getZIndex() {
        return this.fU;
    }

    public float getTransparency() {
        return this.gc;
    }

    public float getAnchorU() {
        return this.gd;
    }

    public float getAnchorV() {
        return this.ge;
    }

    public boolean isVisible() {
        return this.fV;
    }
}

