/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.internal.ae;
import com.google.android.gms.internal.ci;
import com.google.android.gms.internal.cj;
import com.google.android.gms.internal.cx;
import com.google.android.gms.maps.GoogleMapOptionsCreator;
import com.google.android.gms.maps.model.CameraPosition;

public final class GoogleMapOptions
implements ae {
    public static final GoogleMapOptionsCreator CREATOR = new GoogleMapOptionsCreator();
    private final int T;
    private Boolean fi;
    private Boolean fj;
    private int fk = -1;
    private CameraPosition fl;
    private Boolean fm;
    private Boolean fn;
    private Boolean fo;
    private Boolean fp;
    private Boolean fq;
    private Boolean fr;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled) {
        this.T = versionCode;
        this.fi = cj.a(zOrderOnTop);
        this.fj = cj.a(useViewLifecycleInFragment);
        this.fk = mapType;
        this.fl = camera;
        this.fm = cj.a(zoomControlsEnabled);
        this.fn = cj.a(compassEnabled);
        this.fo = cj.a(scrollGesturesEnabled);
        this.fp = cj.a(zoomGesturesEnabled);
        this.fq = cj.a(tiltGesturesEnabled);
        this.fr = cj.a(rotateGesturesEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (cx.aV()) {
            ci.a(this, out, flags);
        } else {
            GoogleMapOptionsCreator.a(this, out, flags);
        }
    }

    public int u() {
        return this.T;
    }

    public byte aG() {
        return cj.b(this.fi);
    }

    public byte aH() {
        return cj.b(this.fj);
    }

    public byte aI() {
        return cj.b(this.fm);
    }

    public byte aJ() {
        return cj.b(this.fn);
    }

    public byte aK() {
        return cj.b(this.fo);
    }

    public byte aL() {
        return cj.b(this.fp);
    }

    public byte aM() {
        return cj.b(this.fq);
    }

    public byte aN() {
        return cj.b(this.fr);
    }

    public GoogleMapOptions() {
        this.T = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.fi = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.fj = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.fk = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.fl = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.fm = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.fn = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.fo = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.fp = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.fq = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.fr = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.fi;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.fj;
    }

    public int getMapType() {
        return this.fk;
    }

    public CameraPosition getCamera() {
        return this.fl;
    }

    public Boolean getZoomControlsEnabled() {
        return this.fm;
    }

    public Boolean getCompassEnabled() {
        return this.fn;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.fo;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.fp;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.fq;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.fr;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(0)) {
            googleMapOptions.mapType(typedArray.getInt(0, -1));
        }
        if (typedArray.hasValue(13)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(13, false));
        }
        if (typedArray.hasValue(12)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(12, false));
        }
        if (typedArray.hasValue(6)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(6, true));
        }
        if (typedArray.hasValue(7)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(7, true));
        }
        if (typedArray.hasValue(8)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(8, true));
        }
        if (typedArray.hasValue(9)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(9, true));
        }
        if (typedArray.hasValue(11)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(11, true));
        }
        if (typedArray.hasValue(10)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(10, true));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

