/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.internal.ae;
import com.google.android.gms.location.LocationRequestCreator;

public final class LocationRequest
implements ae {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_NO_POWER = 105;
    int T;
    int mPriority = 102;
    long ez = 3600000L;
    long eA = (long)((double)this.ez / 6.0);
    boolean eB = false;
    long eu = Long.MAX_VALUE;
    int eC = Integer.MAX_VALUE;
    float eD = 0.0f;
    public static final LocationRequestCreator CREATOR = new LocationRequestCreator();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.H(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.c(millis);
        this.ez = millis;
        if (!this.eB) {
            this.eA = (long)((double)this.ez / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.ez;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.c(millis);
        this.eB = true;
        this.eA = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.eA;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l2 = SystemClock.elapsedRealtime();
        this.eu = millis > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : millis + l2;
        if (this.eu < 0L) {
            this.eu = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.eu = millis;
        if (this.eu < 0L) {
            this.eu = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.eu;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.eC = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.eC;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.a(smallestDisplacementMeters);
        this.eD = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.eD;
    }

    private static void c(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l2);
        }
    }

    private static void H(int n2) {
        switch (n2) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n2);
            }
        }
    }

    private static void a(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f2);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        LocationRequestCreator.a(this, parcel, flags);
    }

    public static String I(int n2) {
        switch (n2) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.I(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.ez + "ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.eA + "ms");
        if (this.eu != Long.MAX_VALUE) {
            long l2 = this.eu - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l2 + "ms");
        }
        if (this.eC != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.eC);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

